/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.organize.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.organize.dao.OrgCompanyMapper;
import com.yqbsoft.laser.service.organize.dao.OrgEmployeeMapper;
import com.yqbsoft.laser.service.organize.domain.OrgChannelsendDomain;
import com.yqbsoft.laser.service.organize.domain.OrgCompanyDomain;
import com.yqbsoft.laser.service.organize.domain.OrgCompanyReDomain;
import com.yqbsoft.laser.service.organize.domain.OrgEmployeeDomain;
import com.yqbsoft.laser.service.organize.domain.OrgUserBean;
import com.yqbsoft.laser.service.organize.domain.UmUserReDomainBean;
import com.yqbsoft.laser.service.organize.domain.UmUserinfoReDomainBean;
import com.yqbsoft.laser.service.organize.model.OrgChannelsend;
import com.yqbsoft.laser.service.organize.model.OrgCompany;
import com.yqbsoft.laser.service.organize.model.OrgDepart;
import com.yqbsoft.laser.service.organize.model.OrgDepartemp;
import com.yqbsoft.laser.service.organize.model.OrgEmployee;
import com.yqbsoft.laser.service.organize.service.OrgChannelsendBaseService;
import com.yqbsoft.laser.service.organize.service.OrgChannelsendService;
import com.yqbsoft.laser.service.organize.service.OrgCompanyService;
import com.yqbsoft.laser.service.organize.service.OrgDepartService;
import com.yqbsoft.laser.service.organize.service.OrgEmployeeService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class OrgCompanyServiceImpl
extends BaseServiceImpl
implements OrgCompanyService {
    private static final String SYS_CODE = "org.OrgCompanyServiceImpl";
    private OrgCompanyMapper orgCompanyMapper;
    private OrgEmployeeService orgEmployeeService;
    private OrgDepartService orgDepartService;
    private OrgChannelsendService orgChannelsendService;
    private OrgEmployeeMapper orgEmployeeMapper;
    private OrgChannelsendBaseService orgChannelsendBaseService;
    private String cachekeydomain = "OrgCompany-companyCode";
    private String cachetreekeydomain = "OrgCompany-companyPcode";
    private String cacheallkeydomain = "OrgCompany-all";

    public OrgEmployeeMapper getOrgEmployeeMapper() {
        return this.orgEmployeeMapper;
    }

    public void setOrgEmployeeMapper(OrgEmployeeMapper orgEmployeeMapper) {
        this.orgEmployeeMapper = orgEmployeeMapper;
    }

    public OrgChannelsendBaseService getOrgChannelsendBaseService() {
        return this.orgChannelsendBaseService;
    }

    public void setOrgChannelsendBaseService(OrgChannelsendBaseService orgChannelsendBaseService) {
        this.orgChannelsendBaseService = orgChannelsendBaseService;
    }

    public OrgChannelsendService getOrgChannelsendService() {
        return this.orgChannelsendService;
    }

    public void setOrgChannelsendService(OrgChannelsendService orgChannelsendService) {
        this.orgChannelsendService = orgChannelsendService;
    }

    public void setOrgDepartService(OrgDepartService orgDepartService) {
        this.orgDepartService = orgDepartService;
    }

    public void setOrgEmployeeService(OrgEmployeeService orgEmployeeService) {
        this.orgEmployeeService = orgEmployeeService;
    }

    public void setOrgCompanyMapper(OrgCompanyMapper orgCompanyMapper) {
        this.orgCompanyMapper = orgCompanyMapper;
    }

    private Date getSysDate() {
        try {
            return this.orgCompanyMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("org.OrgCompanyServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkCompany(OrgCompanyDomain orgCompanyDomain) {
        if (null == orgCompanyDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)orgCompanyDomain.getCompanyName())) {
            msg = msg + "CompanyName\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)orgCompanyDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setCompanyDefault(OrgCompany orgCompany) {
        if (null == orgCompany) {
            return;
        }
        if (null == orgCompany.getDataState()) {
            orgCompany.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == orgCompany.getGmtCreate()) {
            orgCompany.setGmtCreate(date);
        }
        orgCompany.setGmtModified(date);
        if (StringUtils.isBlank((String)orgCompany.getCompanyCode())) {
            orgCompany.setCompanyCode(this.getNo(null, "orgCompany", "companyCode", orgCompany.getTenantCode()));
        }
        if (StringUtils.isBlank((String)orgCompany.getCompanyOrgin())) {
            orgCompany.setCompanyOrgin("1");
        }
    }

    private int getCompanyMaxCode() {
        int code = 0;
        try {
            return this.orgCompanyMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("org.OrgCompanyServiceImpl.getCompanyMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setCompanyUpdataDefault(OrgCompany orgCompany) {
        if (null == orgCompany) {
            return;
        }
        orgCompany.setGmtModified(this.getSysDate());
    }

    private void saveCompanyModel(OrgCompany orgCompany) throws ApiException {
        if (null == orgCompany) {
            return;
        }
        try {
            this.orgCompanyMapper.insert(orgCompany);
        }
        catch (Exception e) {
            throw new ApiException("org.OrgCompanyServiceImpl.saveCompanyModel.ex", (Throwable)e);
        }
    }

    private void saveCompanyBatchModel(List<OrgCompany> orgCompanyList) throws ApiException {
        if (null == orgCompanyList || orgCompanyList.isEmpty()) {
            return;
        }
        try {
            this.orgCompanyMapper.insertBatch(orgCompanyList);
        }
        catch (Exception e) {
            throw new ApiException("org.OrgCompanyServiceImpl.saveCompanyBatchModel.ex", (Throwable)e);
        }
    }

    private OrgCompany getCompanyModelById(Integer companyId) {
        if (null == companyId) {
            return null;
        }
        try {
            return this.orgCompanyMapper.selectByPrimaryKey(companyId);
        }
        catch (Exception e) {
            this.logger.error("org.OrgCompanyServiceImpl.getCompanyModelById", (Throwable)e);
            return null;
        }
    }

    private OrgCompany getCompanyModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.orgCompanyMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("org.OrgCompanyServiceImpl.getCompanyModelByCode", (Throwable)e);
            return null;
        }
    }

    private OrgCompany getCompanyModelByName(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.orgCompanyMapper.getByName(map);
        }
        catch (Exception e) {
            this.logger.error("org.OrgCompanyServiceImpl.getCompanyModelByName", (Throwable)e);
            return null;
        }
    }

    private void delCompanyModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.orgCompanyMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("org.OrgCompanyServiceImpl.delCompanyModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("org.OrgCompanyServiceImpl.delCompanyModelByCode.num");
        }
    }

    private void deleteCompanyModel(Integer companyId) throws ApiException {
        if (null == companyId) {
            return;
        }
        int i = 0;
        try {
            i = this.orgCompanyMapper.deleteByPrimaryKey(companyId);
        }
        catch (Exception e) {
            throw new ApiException("org.OrgCompanyServiceImpl.deleteCompanyModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("org.OrgCompanyServiceImpl.deleteCompanyModel.num");
        }
    }

    private void updateCompanyModel(OrgCompany orgCompany) throws ApiException {
        if (null == orgCompany) {
            return;
        }
        int i = 0;
        try {
            i = this.orgCompanyMapper.updateByPrimaryKeySelective(orgCompany);
        }
        catch (Exception e) {
            throw new ApiException("org.OrgCompanyServiceImpl.updateCompanyModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("org.OrgCompanyServiceImpl.updateCompanyModel.num");
        }
    }

    private void updateStateCompanyModel(Integer companyId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == companyId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("companyId", companyId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.orgCompanyMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("org.OrgCompanyServiceImpl.updateStateCompanyModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("org.OrgCompanyServiceImpl.updateStateCompanyModel.null");
        }
    }

    private void updateStateCompanyModelByCode(String tenantCode, String companyCode, Integer dataState, Integer oldDataState) throws ApiException {
        if (StringUtils.isBlank((String)companyCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("companyCode", companyCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.orgCompanyMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("org.OrgCompanyServiceImpl.updateStateCompanyModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("org.OrgCompanyServiceImpl.updateStateCompanyModelByCode.null");
        }
    }

    private void updateUserinfoCode(String tenantCode, String companyCode, String userinfoCode) {
        if (StringUtils.isBlank((String)companyCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("companyCode", companyCode);
        map.put("userinfoCode", userinfoCode);
        int i = 0;
        try {
            i = this.orgCompanyMapper.updateUserinfoCodeByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("org.OrgCompanyServiceImpl.updateUserinfoCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("org.OrgCompanyServiceImpl.updateUserinfoCode.null", ((Object)map).toString());
        }
    }

    private OrgCompany makeCompany(OrgCompanyDomain orgCompanyDomain, OrgCompany orgCompany) {
        if (null == orgCompanyDomain) {
            return null;
        }
        if (null == orgCompany) {
            orgCompany = new OrgCompany();
        }
        try {
            BeanUtils.copyAllPropertys((Object)orgCompany, (Object)orgCompanyDomain);
            return orgCompany;
        }
        catch (Exception e) {
            this.logger.error("org.OrgCompanyServiceImpl.makeCompany", (Throwable)e);
            return null;
        }
    }

    private OrgCompanyReDomain makeOrgCompanyReDomain(OrgCompany orgCompany) {
        if (null == orgCompany) {
            return null;
        }
        OrgCompanyReDomain orgCompanyReDomain = new OrgCompanyReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)orgCompanyReDomain, (Object)orgCompany);
            return orgCompanyReDomain;
        }
        catch (Exception e) {
            this.logger.error("org.OrgCompanyServiceImpl.makeOrgCompanyReDomain", (Throwable)e);
            return null;
        }
    }

    private List<OrgCompany> queryCompanyModelPage(Map<String, Object> parammap) {
        try {
            return this.orgCompanyMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("org.OrgCompanyServiceImpl.queryCompanyModel", (Throwable)e);
            return null;
        }
    }

    private int countCompany(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.orgCompanyMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("org.OrgCompanyServiceImpl.countCompany", (Throwable)e);
        }
        return i;
    }

    private OrgCompany createOrgCompany(OrgCompanyDomain orgCompanyDomain) {
        String msg = this.checkCompany(orgCompanyDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("org.OrgCompanyServiceImpl.saveCompany.checkCompany", msg);
        }
        OrgCompany orgCompany = this.makeCompany(orgCompanyDomain, null);
        this.setCompanyDefault(orgCompany);
        return orgCompany;
    }

    @Override
    public List<OrgChannelsend> saveCompany(OrgCompanyDomain orgCompanyDomain) throws ApiException {
        this.logger.error("org.OrgCompanyServiceImpl.saveCompany.", (Object)JsonUtil.buildNonNullBinder().toJson((Object)orgCompanyDomain));
        OrgCompany orgCompany = this.createOrgCompany(orgCompanyDomain);
        this.logger.error("org.OrgCompanyServiceImpl.saveCompany.", (Object)JsonUtil.buildNonNullBinder().toJson((Object)orgCompany));
        this.saveCompanyModel(orgCompany);
        this.saveEmployeeBatch(orgCompany, orgCompanyDomain.getOrgEmployeeDomainList());
        this.updateCache(orgCompany);
        ArrayList<OrgCompany> list = new ArrayList<OrgCompany>();
        list.add(orgCompany);
        return this.buidPmChannelsend(list, "insert");
    }

    private void saveEmployeeBatch(OrgCompany orgCompany, List<OrgEmployeeDomain> orgEmployeeDomainList) {
        if (null == orgCompany || null == orgEmployeeDomainList || orgEmployeeDomainList.isEmpty()) {
            return;
        }
        for (OrgEmployeeDomain orgEmployeeDomain : orgEmployeeDomainList) {
            orgEmployeeDomain.setCompanyCode(orgCompany.getCompanyCode());
            orgEmployeeDomain.setCompanyShortname(orgCompany.getCompanyShortname());
        }
        this.orgEmployeeService.saveEmployeeBatch(orgEmployeeDomainList);
    }

    @Override
    public List<OrgChannelsend> saveCompanyBatch(List<OrgCompanyDomain> orgCompanyDomainList) throws ApiException {
        if (ListUtil.isEmpty(orgCompanyDomainList)) {
            return null;
        }
        ArrayList<OrgChannelsend> rePmChannelsendList = new ArrayList<OrgChannelsend>();
        for (OrgCompanyDomain orgCompanyDomain : orgCompanyDomainList) {
            List<OrgChannelsend> pmChannelsendList = this.saveCompany(orgCompanyDomain);
            if (!ListUtil.isNotEmpty(pmChannelsendList)) continue;
            rePmChannelsendList.addAll(pmChannelsendList);
        }
        return rePmChannelsendList;
    }

    @Override
    public List<OrgChannelsend> updateCompanyState(Integer companyId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateCompanyModel(companyId, dataState, oldDataState);
        OrgCompany orgCompany = this.getCompany(companyId);
        if (null == orgCompany) {
            throw new ApiException("org.OrgCompanyServiceImpl.updateCompanyState.orgCompany", "\u6570\u636e\u4e3a\u7a7a");
        }
        if (-1 == dataState) {
            this.deleteCache(orgCompany);
        } else {
            this.updateCache(orgCompany);
        }
        return this.saveSend(dataState, oldDataState, orgCompany);
    }

    @Override
    public List<OrgChannelsend> updateCompanyStateByCode(String tenantCode, String companyCode, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateCompanyModelByCode(tenantCode, companyCode, dataState, oldDataState);
        OrgCompany orgCompany = this.getCompanyByCode(tenantCode, companyCode);
        if (null == orgCompany) {
            throw new ApiException("org.OrgCompanyServiceImpl.updateCompanyStateByCode.orgCompany", "\u6570\u636e\u4e3a\u7a7a");
        }
        if (-1 == dataState) {
            this.deleteCache(orgCompany);
        } else {
            this.updateCache(orgCompany);
        }
        return this.saveSend(dataState, oldDataState, orgCompany);
    }

    @Override
    public List<OrgChannelsend> updateCompany(OrgCompanyDomain orgCompanyDomain) throws ApiException {
        OrgCompany orgCompany = this.getOrgCompany(orgCompanyDomain);
        this.updateCompanyModel(orgCompany);
        this.updateCache(orgCompany);
        ArrayList<OrgCompany> list = new ArrayList<OrgCompany>();
        list.add(orgCompany);
        return this.buidPmChannelsend(list, "update");
    }

    @Override
    public OrgCompany getCompany(Integer companyId) {
        return this.getCompanyModelById(companyId);
    }

    @Override
    public List<OrgChannelsend> deleteCompany(Integer companyId) throws ApiException {
        OrgCompany orgCompany = this.getOrgCompany(companyId);
        this.deleteCache(orgCompany);
        ArrayList<OrgCompany> list = new ArrayList<OrgCompany>();
        list.add(orgCompany);
        return this.buidPmChannelsend(list, "delete");
    }

    @Override
    public QueryResult<OrgCompany> queryCompanyPage(Map<String, Object> map) {
        List<OrgCompany> orgCompanyList = this.queryCompanyModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countCompany(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(orgCompanyList);
        return queryResult;
    }

    @Override
    public OrgCompany getCompanyByCode(String tenantCode, String companyCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("companyCode", companyCode);
        return this.getCompanyModelByCode(map);
    }

    @Override
    public List<OrgChannelsend> deleteCompanyByCode(String tenantCode, String companyCode) throws ApiException {
        OrgCompany orgCompany = this.getOrgCompany(tenantCode, companyCode);
        this.deleteCache(orgCompany);
        ArrayList<OrgCompany> list = new ArrayList<OrgCompany>();
        list.add(orgCompany);
        return this.buidPmChannelsend(list, "delete");
    }

    private void deleteCache(OrgCompany orgCompany) {
        if (null == orgCompany) {
            return;
        }
        DisUtil.delMapVer((String)this.cachekeydomain, (String[])new String[]{orgCompany.getCompanyCode() + "-" + orgCompany.getTenantCode()});
        DisUtil.delMapVer((String)this.cachetreekeydomain, (String[])new String[]{orgCompany.getCompanyCode() + "-" + orgCompany.getTenantCode()});
        DisUtil.delMapVer((String)this.cacheallkeydomain, (String[])new String[]{orgCompany.getUserinfoCode() + "-" + orgCompany.getTenantCode()});
    }

    private void updateCache(OrgCompany orgCompany) {
        if (null == orgCompany) {
            return;
        }
        if (null != orgCompany.getUserinfoCode()) {
            DisUtil.setMapVer((String)this.cachekeydomain, (String)(orgCompany.getCompanyCode() + "-" + orgCompany.getTenantCode()), (String)orgCompany.getUserinfoCode());
        }
        if (null != orgCompany.getCompanyPcode()) {
            DisUtil.setMapVer((String)this.cachetreekeydomain, (String)(orgCompany.getCompanyCode() + "-" + orgCompany.getTenantCode()), (String)orgCompany.getCompanyPcode());
        }
        DisUtil.setMapVer((String)this.cacheallkeydomain, (String)(orgCompany.getUserinfoCode() + "-" + orgCompany.getTenantCode()), (String)JsonUtil.buildNormalBinder().toJson((Object)orgCompany));
    }

    @Override
    public void queryCompanyLoadCache() {
        this.logger.info("OrgCompanyService.queryMschannelConfigLoadCache", (Object)"===========start==========");
        HashMap<String, Object> parammap = new HashMap<String, Object>();
        parammap.put("dataState", 0);
        List<OrgCompany> companyList = this.queryCompanyModelPage(parammap);
        if (null == companyList || companyList.isEmpty()) {
            DisUtil.delVer((String)this.cachekeydomain);
            DisUtil.delVer((String)this.cachetreekeydomain);
            DisUtil.delVer((String)this.cacheallkeydomain);
            this.logger.info("OrgCompanyService.queryMschannelConfigLoadCache", (Object)"===========del-end==========");
            return;
        }
        ConcurrentHashMap<String, String> codeMap = new ConcurrentHashMap<String, String>();
        ConcurrentHashMap<String, String> pcodeMap = new ConcurrentHashMap<String, String>();
        ConcurrentHashMap<String, String> userMap = new ConcurrentHashMap<String, String>();
        for (OrgCompany orgCompany : companyList) {
            if (StringUtils.isNotBlank((String)orgCompany.getUserinfoCode())) {
                codeMap.put(orgCompany.getCompanyCode() + "-" + orgCompany.getTenantCode(), orgCompany.getUserinfoCode());
            }
            if (StringUtils.isNotBlank((String)orgCompany.getCompanyPcode())) {
                pcodeMap.put(orgCompany.getCompanyCode() + "-" + orgCompany.getTenantCode(), orgCompany.getCompanyPcode());
            }
            userMap.put(orgCompany.getUserinfoCode() + "-" + orgCompany.getTenantCode(), JsonUtil.buildNormalBinder().toJson((Object)orgCompany));
        }
        DisUtil.setMapVer((String)this.cachekeydomain, codeMap);
        DisUtil.setMapVer((String)this.cachetreekeydomain, pcodeMap);
        DisUtil.setMapVer((String)this.cacheallkeydomain, userMap);
        this.logger.info("OrgCompanyService.queryMschannelConfigLoadCache", (Object)"===========add-end==========");
    }

    @Override
    public OrgCompany getCompanyByName(String tenantCode, String companyName) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("companyName", companyName);
        return this.getCompanyModelByName(map);
    }

    @Override
    public String saveUserinfoCompany(UmUserinfoReDomainBean umUserinfo, UmUserReDomainBean umUser, String optype) throws ApiException {
        if (null == umUserinfo) {
            return "error";
        }
        OrgCompanyDomain orgCompanyDomain = new OrgCompanyDomain();
        try {
            BeanUtils.copyAllPropertys((Object)orgCompanyDomain, (Object)umUserinfo);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        orgCompanyDomain.setCompanyName(umUserinfo.getUserinfoCompname());
        orgCompanyDomain.setCompanyType(null == umUserinfo.getCompanyType() ? null : umUserinfo.getCompanyType().toString());
        orgCompanyDomain.setCompanyTel(umUserinfo.getUserinfoPhone());
        orgCompanyDomain.setCompanyContacts(umUserinfo.getUserinfoCon());
        orgCompanyDomain.setCompanyContactsPhone(umUserinfo.getUserinfoConPhone());
        OrgEmployeeDomain orgEmployeeDomain = new OrgEmployeeDomain();
        orgEmployeeDomain.setEmployeeName(umUserinfo.getUserinfoCon());
        orgEmployeeDomain.setEmployeePhone(umUserinfo.getUserinfoPhone());
        orgEmployeeDomain.setUserinfoCode(umUserinfo.getUserinfoCode());
        orgEmployeeDomain.setTenantCode(umUserinfo.getTenantCode());
        orgEmployeeDomain.setUserCode(umUserinfo.getUserCode());
        ArrayList<OrgEmployeeDomain> orgEmployeeDomainList = new ArrayList<OrgEmployeeDomain>();
        orgEmployeeDomainList.add(orgEmployeeDomain);
        orgCompanyDomain.setOrgEmployeeDomainList(orgEmployeeDomainList);
        this.saveCompany(orgCompanyDomain);
        return "Success";
    }

    @Override
    public OrgUserBean getEmpByUserCode(String userCode, String companyCode, String tenantCode) {
        if (StringUtils.isBlank((String)userCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        QueryResult<OrgEmployee> qe = this.orgEmployeeService.queryEmployeePage(this.getQueryMapParam("userCode,companyCode,tenantCode", new Object[]{userCode, companyCode, tenantCode}));
        if (null == qe || ListUtil.isEmpty((Collection)qe.getList())) {
            return null;
        }
        OrgUserBean orgUserBean = new OrgUserBean();
        orgUserBean.setEmployeeCode(((OrgEmployee)qe.getList().get(0)).getEmployeeCode());
        orgUserBean.setEmployeeName(((OrgEmployee)qe.getList().get(0)).getEmployeeName());
        companyCode = ((OrgEmployee)qe.getList().get(0)).getCompanyCode();
        orgUserBean.setCompanyCode(companyCode);
        QueryResult<OrgDepartemp> qde = this.orgDepartService.queryDepartempPage(this.getQueryMapParam("employeeCode,companyCode,tenantCode", new Object[]{orgUserBean.getEmployeeCode(), companyCode, tenantCode}));
        if (null == qde || ListUtil.isEmpty((Collection)qde.getList())) {
            return orgUserBean;
        }
        orgUserBean.setDepartCode(((OrgDepartemp)qde.getList().get(0)).getDepartCode());
        OrgDepart orgDepart = this.orgDepartService.getDepartByCode(tenantCode, orgUserBean.getDepartCode());
        if (null == orgDepart) {
            return orgUserBean;
        }
        orgUserBean.setDepartShortname(orgDepart.getDepartShortname());
        OrgCompany orgCompany = this.getCompanyByCode(tenantCode, companyCode);
        if (null == orgCompany) {
            return orgUserBean;
        }
        orgUserBean.setCompanyCode(companyCode);
        orgUserBean.setCompanyShortname(orgCompany.getCompanyShortname());
        return orgUserBean;
    }

    private List<OrgChannelsend> buidPmChannelsend(List<OrgCompany> pmPromotionList, String dri) {
        if (ListUtil.isEmpty(pmPromotionList)) {
            return null;
        }
        ArrayList<OrgChannelsend> pmChannelsendList = new ArrayList();
        ArrayList<OrgChannelsendDomain> disChannelsendDomainList = new ArrayList<OrgChannelsendDomain>();
        for (OrgCompany promotion : pmPromotionList) {
            OrgChannelsendDomain pmChannelsendDomain = new OrgChannelsendDomain();
            pmChannelsendDomain.setChannelsendOpcode(promotion.getCompanyCode());
            pmChannelsendDomain.setChannelsendType("orgCompany");
            pmChannelsendDomain.setChannelsendDir(dri);
            pmChannelsendDomain.setChannelsendTxt(JsonUtil.buildNormalBinder().toJson((Object)promotion));
            pmChannelsendDomain.setTenantCode(promotion.getTenantCode());
            disChannelsendDomainList.add(pmChannelsendDomain);
        }
        pmChannelsendList = this.orgChannelsendService.saveSendOrgChannelsendBatch(disChannelsendDomainList);
        return pmChannelsendList;
    }

    private List<OrgChannelsend> saveSend(Integer dataState, Integer oldDataState, OrgCompany pmPromotion) {
        ArrayList<OrgCompany> list = new ArrayList<OrgCompany>();
        list.add(pmPromotion);
        String dir = "update";
        return this.buidPmChannelsend(list, dir);
    }

    private OrgCompany getOrgCompany(OrgCompanyDomain orgCompanyDomain) {
        String msg = this.checkCompany(orgCompanyDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("org.OrgCompanyServiceImpl.updateCompany.checkCompany", msg);
        }
        OrgCompany oldOrgCompany = this.getCompanyModelById(orgCompanyDomain.getCompanyId());
        if (null == oldOrgCompany) {
            throw new ApiException("org.OrgCompanyServiceImpl.updateCompany.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        OrgCompany orgCompany = this.makeCompany(orgCompanyDomain, oldOrgCompany);
        this.setCompanyUpdataDefault(orgCompany);
        return orgCompany;
    }

    private OrgCompany getOrgCompany(Integer companyId) {
        OrgCompany orgCompany = this.getCompany(companyId);
        if (null == orgCompany) {
            throw new ApiException("org.OrgCompanyServiceImpl.deleteCompany.orgCompany", "\u6570\u636e\u4e3a\u7a7a");
        }
        this.deleteCompanyModel(companyId);
        DisUtil.delMap((String)this.cachekeydomain, (String[])new String[]{orgCompany.getCompanyCode() + "-" + orgCompany.getTenantCode()});
        DisUtil.delMap((String)this.cachetreekeydomain, (String[])new String[]{orgCompany.getCompanyCode() + "-" + orgCompany.getTenantCode()});
        DisUtil.delMap((String)this.cacheallkeydomain, (String[])new String[]{orgCompany.getUserinfoCode() + "-" + orgCompany.getTenantCode()});
        return orgCompany;
    }

    private OrgCompany getOrgCompany(String tenantCode, String companyCode) {
        OrgCompany orgCompany = this.getCompanyByCode(tenantCode, companyCode);
        if (null == orgCompany) {
            throw new ApiException("org.OrgCompanyServiceImpl.deleteCompanyByCode.orgCompany", "\u6570\u636e\u4e3a\u7a7a");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("companyCode", companyCode);
        this.delCompanyModelByCode(map);
        this.deleteCache(orgCompany);
        return orgCompany;
    }

    @Override
    public OrgCompanyReDomain getCompanyTreeByCode(String tenantCode, String companyCode) throws ApiException {
        if (StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)companyCode)) {
            return null;
        }
        OrgCompany orgCompany = this.getCompanyByCode(tenantCode, companyCode);
        return this.makeTree(orgCompany);
    }

    private OrgCompanyReDomain makeTree(OrgCompany orgCompany) {
        if (null == orgCompany) {
            return null;
        }
        OrgCompanyReDomain orgCompanyReDomain = new OrgCompanyReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)orgCompanyReDomain, (Object)orgCompany);
        }
        catch (Exception exception) {
            // empty catch block
        }
        orgCompanyReDomain.setOrgDepartReDomainList(this.orgDepartService.queryDepartTree(orgCompany.getTenantCode(), orgCompany.getCompanyCode()));
        orgCompanyReDomain.setOrgEmployeeReDomainList(this.orgEmployeeService.queryEmployeeReDomain(orgCompany.getCompanyCode(), orgCompany.getTenantCode()));
        return orgCompanyReDomain;
    }

    @Override
    public List<OrgChannelsend> updateUserinfoCodeByCode(String tenantCode, String companyCode, String userinfoCode) throws ApiException {
        this.updateUserinfoCode(tenantCode, companyCode, userinfoCode);
        OrgCompany orgCompany = this.getCompanyByCode(tenantCode, companyCode);
        if (null == orgCompany) {
            throw new ApiException("org.OrgCompanyServiceImpl.updateUserinfoCodeByCode.orgCompany", "\u6570\u636e\u4e3a\u7a7a");
        }
        return this.saveSend(null, null, orgCompany);
    }

    @Override
    public void comAndEmpExpirationDate(Map<String, Object> map) throws ApiException {
        List<Integer> userinfoIds;
        HashMap<String, Object> queryComMap = new HashMap<String, Object>();
        queryComMap.put("gmtValidityQend", new Date());
        queryComMap.put("dataState", 0);
        queryComMap.put("fuzzy", false);
        List<OrgCompany> orgCompanies = this.queryCompanyModelPage(queryComMap);
        if (ListUtil.isNotEmpty(orgCompanies)) {
            for (OrgCompany orgCompany : orgCompanies) {
                try {
                    this.orgChannelsendBaseService.sendUpdateCompanyState(orgCompany.getCompanyId(), -1, 0);
                }
                catch (ApiException e) {
                    this.logger.error("org.OrgCompanyServiceImpl.comAndEmpExpirationDate.sendUpdateCompanyState.companyId:", (Object)orgCompany.getCompanyId());
                    throw new RuntimeException(e);
                }
            }
        }
        if (ListUtil.isNotEmpty(userinfoIds = this.orgEmployeeMapper.queryEmpValidityForUserinfoId())) {
            for (Integer userinfoId : userinfoIds) {
                String s = this.updateUserinfoState(userinfoId, -1, 0, new HashMap<String, Object>());
                this.logger.error("org.OrgCompanyServiceImpl.comAndEmpExpirationDate.updateUserinfoState.s", (Object)(s + "userinfoId::" + userinfoId));
            }
        }
    }

    private String updateUserinfoState(Integer userinfoId, Integer dataState, Integer oldDataState, Map<String, Object> map) {
        String apiCode = "um.user.sendUpdateUserinfoState";
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("userinfoId", userinfoId);
        paramMap.put("dataState", dataState);
        paramMap.put("oldDataState", oldDataState);
        paramMap.put("map", map);
        return this.internalInvoke(apiCode, paramMap);
    }
}

