/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.organize.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.router.InternalRouter;
import com.yqbsoft.laser.service.esb.core.spring.ApplicationContextUtil;
import com.yqbsoft.laser.service.esb.core.spring.SpringApplicationContextUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.organize.OrganizeConstants;
import com.yqbsoft.laser.service.organize.dao.OrgChannelsendListBakMapper;
import com.yqbsoft.laser.service.organize.dao.OrgChannelsendListMapper;
import com.yqbsoft.laser.service.organize.domain.OrgChannelsendListBakDomain;
import com.yqbsoft.laser.service.organize.domain.OrgChannelsendListBakReDomain;
import com.yqbsoft.laser.service.organize.domain.OrgChannelsendListDomain;
import com.yqbsoft.laser.service.organize.domain.OrgChannelsendListReDomain;
import com.yqbsoft.laser.service.organize.domain.UmUserDomainBean;
import com.yqbsoft.laser.service.organize.engine.EsSendEnginePollThread;
import com.yqbsoft.laser.service.organize.engine.EsSendEnginePutThread;
import com.yqbsoft.laser.service.organize.engine.EsSendEngineService;
import com.yqbsoft.laser.service.organize.model.OrgChannelsendList;
import com.yqbsoft.laser.service.organize.model.OrgChannelsendListBak;
import com.yqbsoft.laser.service.organize.model.OrgCompany;
import com.yqbsoft.laser.service.organize.model.OrgDepart;
import com.yqbsoft.laser.service.organize.model.OrgEmployee;
import com.yqbsoft.laser.service.organize.model.OrgGroup;
import com.yqbsoft.laser.service.organize.service.OrgChannelsendListService;
import com.yqbsoft.laser.service.organize.service.OrgCompanyService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class OrgChannelsendListServiceImpl
extends BaseServiceImpl
implements OrgChannelsendListService {
    private static final String SYS_CODE = "org.OrgChannelsendListServiceImpl";
    private OrgChannelsendListMapper orgChannelsendListMapper;
    private OrgChannelsendListBakMapper orgChannelsendListBakMapper;
    OrgCompanyService orgCompanyService;
    private static EsSendEngineService esSendEngineService;
    private static Object lock;

    public OrgCompanyService getOrgCompanyService() {
        if (null == this.orgCompanyService) {
            this.orgCompanyService = (OrgCompanyService)ApplicationContextUtil.getService((String)"orgCompanyService");
        }
        return this.orgCompanyService;
    }

    public void setOrgChannelsendListBakMapper(OrgChannelsendListBakMapper orgChannelsendListBakMapper) {
        this.orgChannelsendListBakMapper = orgChannelsendListBakMapper;
    }

    public void setOrgChannelsendListMapper(OrgChannelsendListMapper orgChannelsendListMapper) {
        this.orgChannelsendListMapper = orgChannelsendListMapper;
    }

    private Date getSysDate() {
        try {
            return this.orgChannelsendListMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("org.OrgChannelsendListServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkChannelsendList(OrgChannelsendListDomain orgChannelsendListDomain) {
        if (null == orgChannelsendListDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)orgChannelsendListDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setChannelsendListDefault(OrgChannelsendList orgChannelsendList) {
        if (null == orgChannelsendList) {
            return;
        }
        if (null == orgChannelsendList.getDataState()) {
            orgChannelsendList.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == orgChannelsendList.getGmtCreate()) {
            orgChannelsendList.setGmtCreate(date);
        }
        orgChannelsendList.setGmtModified(date);
        if (StringUtils.isBlank((String)orgChannelsendList.getChannelsendlistCode())) {
            orgChannelsendList.setChannelsendlistCode(this.getNo(null, "OrgChannelsendList", "orgChannelsendList", orgChannelsendList.getTenantCode()));
        }
    }

    private int getChannelsendListMaxCode() {
        int code = 0;
        try {
            return this.orgChannelsendListMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("org.OrgChannelsendListServiceImpl.getChannelsendListMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setChannelsendListUpdataDefault(OrgChannelsendList orgChannelsendList) {
        if (null == orgChannelsendList) {
            return;
        }
        orgChannelsendList.setGmtModified(this.getSysDate());
    }

    private void saveChannelsendListModel(OrgChannelsendList orgChannelsendList) throws ApiException {
        if (null == orgChannelsendList) {
            return;
        }
        try {
            this.orgChannelsendListMapper.insert(orgChannelsendList);
        }
        catch (Exception e) {
            throw new ApiException("org.OrgChannelsendListServiceImpl.saveChannelsendListModel.ex", (Throwable)e);
        }
    }

    private void saveChannelsendListBatchModel(List<OrgChannelsendList> orgChannelsendListList) throws ApiException {
        if (null == orgChannelsendListList || orgChannelsendListList.isEmpty()) {
            return;
        }
        try {
            this.orgChannelsendListMapper.insertBatch(orgChannelsendListList);
        }
        catch (Exception e) {
            throw new ApiException("org.OrgChannelsendListServiceImpl.saveChannelsendListBatchModel.ex", (Throwable)e);
        }
    }

    private OrgChannelsendList getChannelsendListModelById(Integer channelsendlistId) {
        if (null == channelsendlistId) {
            return null;
        }
        try {
            return this.orgChannelsendListMapper.selectByPrimaryKey(channelsendlistId);
        }
        catch (Exception e) {
            this.logger.error("org.OrgChannelsendListServiceImpl.getChannelsendListModelById", (Throwable)e);
            return null;
        }
    }

    private OrgChannelsendList getChannelsendListModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.orgChannelsendListMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("org.OrgChannelsendListServiceImpl.getChannelsendListModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delChannelsendListModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.orgChannelsendListMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("org.OrgChannelsendListServiceImpl.delChannelsendListModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("org.OrgChannelsendListServiceImpl.delChannelsendListModelByCode.num");
        }
    }

    private void deleteChannelsendListModel(Integer channelsendlistId) throws ApiException {
        if (null == channelsendlistId) {
            return;
        }
        int i = 0;
        try {
            i = this.orgChannelsendListMapper.deleteByPrimaryKey(channelsendlistId);
        }
        catch (Exception e) {
            throw new ApiException("org.OrgChannelsendListServiceImpl.deleteChannelsendListModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("org.OrgChannelsendListServiceImpl.deleteChannelsendListModel.num");
        }
    }

    private void updateChannelsendListModel(OrgChannelsendList orgChannelsendList) throws ApiException {
        if (null == orgChannelsendList) {
            return;
        }
        int i = 0;
        try {
            i = this.orgChannelsendListMapper.updateByPrimaryKey(orgChannelsendList);
        }
        catch (Exception e) {
            throw new ApiException("org.OrgChannelsendListServiceImpl.updateChannelsendListModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("org.OrgChannelsendListServiceImpl.updateChannelsendListModel.num");
        }
    }

    private void updateStateChannelsendListModel(Integer channelsendlistId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == channelsendlistId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("channelsendlistId", channelsendlistId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.orgChannelsendListMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("org.OrgChannelsendListServiceImpl.updateStateChannelsendListModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("org.OrgChannelsendListServiceImpl.updateStateChannelsendListModel.null");
        }
    }

    private void updateStateChannelsendListModelByCode(String tenantCode, String channelsendlistCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)channelsendlistCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("channelsendlistCode", channelsendlistCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.orgChannelsendListMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("org.OrgChannelsendListServiceImpl.updateStateChannelsendListModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("org.OrgChannelsendListServiceImpl.updateStateChannelsendListModelByCode.null");
        }
    }

    private OrgChannelsendList makeChannelsendList(OrgChannelsendListDomain orgChannelsendListDomain, OrgChannelsendList orgChannelsendList) {
        if (null == orgChannelsendListDomain) {
            return null;
        }
        if (null == orgChannelsendList) {
            orgChannelsendList = new OrgChannelsendList();
        }
        try {
            BeanUtils.copyAllPropertys((Object)orgChannelsendList, (Object)orgChannelsendListDomain);
            return orgChannelsendList;
        }
        catch (Exception e) {
            this.logger.error("org.OrgChannelsendListServiceImpl.makeChannelsendList", (Throwable)e);
            return null;
        }
    }

    private OrgChannelsendListReDomain makeOrgChannelsendListReDomain(OrgChannelsendList orgChannelsendList) {
        if (null == orgChannelsendList) {
            return null;
        }
        OrgChannelsendListReDomain orgChannelsendListReDomain = new OrgChannelsendListReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)orgChannelsendListReDomain, (Object)orgChannelsendList);
            return orgChannelsendListReDomain;
        }
        catch (Exception e) {
            this.logger.error("org.OrgChannelsendListServiceImpl.makeOrgChannelsendListReDomain", (Throwable)e);
            return null;
        }
    }

    private List<OrgChannelsendList> queryChannelsendListModelPage(Map<String, Object> parammap) {
        try {
            return this.orgChannelsendListMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("org.OrgChannelsendListServiceImpl.queryChannelsendListModel", (Throwable)e);
            return null;
        }
    }

    private int countChannelsendList(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.orgChannelsendListMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("org.OrgChannelsendListServiceImpl.countChannelsendList", (Throwable)e);
        }
        return i;
    }

    private OrgChannelsendList createOrgChannelsendList(OrgChannelsendListDomain orgChannelsendListDomain) {
        String msg = this.checkChannelsendList(orgChannelsendListDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("org.OrgChannelsendListServiceImpl.saveChannelsendList.checkChannelsendList", msg);
        }
        OrgChannelsendList orgChannelsendList = this.makeChannelsendList(orgChannelsendListDomain, null);
        this.setChannelsendListDefault(orgChannelsendList);
        return orgChannelsendList;
    }

    @Override
    public String saveChannelsendList(OrgChannelsendListDomain orgChannelsendListDomain) throws ApiException {
        OrgChannelsendList orgChannelsendList = this.createOrgChannelsendList(orgChannelsendListDomain);
        this.saveChannelsendListModel(orgChannelsendList);
        return orgChannelsendList.getChannelsendlistCode();
    }

    @Override
    public String saveChannelsendListBatch(List<OrgChannelsendListDomain> orgChannelsendListDomainList) throws ApiException {
        if (null == orgChannelsendListDomainList || orgChannelsendListDomainList.isEmpty()) {
            return null;
        }
        ArrayList<OrgChannelsendList> orgChannelsendListList = new ArrayList<OrgChannelsendList>();
        String code = "";
        for (OrgChannelsendListDomain orgChannelsendListDomain : orgChannelsendListDomainList) {
            OrgChannelsendList orgChannelsendList = this.createOrgChannelsendList(orgChannelsendListDomain);
            code = orgChannelsendList.getChannelsendlistCode();
            orgChannelsendListList.add(orgChannelsendList);
        }
        this.saveChannelsendListBatchModel(orgChannelsendListList);
        return code;
    }

    @Override
    public List<OrgChannelsendList> saveChannelsendlistsBatch(List<OrgChannelsendListDomain> orgChannelsendListDomainList) throws ApiException {
        if (null == orgChannelsendListDomainList || orgChannelsendListDomainList.isEmpty()) {
            return null;
        }
        ArrayList<OrgChannelsendList> resChannelsendlistList = new ArrayList<OrgChannelsendList>();
        for (OrgChannelsendListDomain resChannelsendlistDomain : orgChannelsendListDomainList) {
            OrgChannelsendList orgChannelsendList = this.createOrgChannelsendList(resChannelsendlistDomain);
            resChannelsendlistList.add(orgChannelsendList);
        }
        this.saveChannelsendListBatchModel(resChannelsendlistList);
        return resChannelsendlistList;
    }

    @Override
    public void updateChannelsendListState(Integer channelsendlistId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == channelsendlistId) {
            return;
        }
        this.updateStateChannelsendListModel(channelsendlistId, dataState, oldDataState, map);
    }

    @Override
    public void updateChannelsendListStateByCode(String tenantCode, String channelsendlistCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)channelsendlistCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateChannelsendListModelByCode(tenantCode, channelsendlistCode, dataState, oldDataState, map);
    }

    @Override
    public void updateChannelsendList(OrgChannelsendListDomain orgChannelsendListDomain) throws ApiException {
        String msg = this.checkChannelsendList(orgChannelsendListDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("org.OrgChannelsendListServiceImpl.updateChannelsendList.checkChannelsendList", msg);
        }
        OrgChannelsendList oldOrgChannelsendList = this.getChannelsendListModelById(orgChannelsendListDomain.getChannelsendlistId());
        if (null == oldOrgChannelsendList) {
            throw new ApiException("org.OrgChannelsendListServiceImpl.updateChannelsendList.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        OrgChannelsendList orgChannelsendList = this.makeChannelsendList(orgChannelsendListDomain, oldOrgChannelsendList);
        this.setChannelsendListUpdataDefault(orgChannelsendList);
        this.updateChannelsendListModel(orgChannelsendList);
    }

    @Override
    public OrgChannelsendList getChannelsendList(Integer channelsendlistId) {
        if (null == channelsendlistId) {
            return null;
        }
        return this.getChannelsendListModelById(channelsendlistId);
    }

    @Override
    public void deleteChannelsendList(Integer channelsendlistId) throws ApiException {
        if (null == channelsendlistId) {
            return;
        }
        this.deleteChannelsendListModel(channelsendlistId);
    }

    @Override
    public QueryResult<OrgChannelsendList> queryChannelsendListPage(Map<String, Object> map) {
        List<OrgChannelsendList> orgChannelsendListList = this.queryChannelsendListModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countChannelsendList(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(orgChannelsendListList);
        return queryResult;
    }

    @Override
    public OrgChannelsendList getChannelsendListByCode(String tenantCode, String channelsendlistCode) throws ApiException {
        if (StringUtils.isBlank((String)channelsendlistCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("channelsendlistCode", channelsendlistCode);
        return this.getChannelsendListModelByCode(map);
    }

    @Override
    public void deleteChannelsendListByCode(String tenantCode, String channelsendlistCode) throws ApiException {
        if (StringUtils.isBlank((String)channelsendlistCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("channelsendlistCode", channelsendlistCode);
        this.delChannelsendListModelByCode(map);
    }

    @Override
    public String saveChannelsendListBak(OrgChannelsendListBakDomain orgChannelsendListBakDomain) throws ApiException {
        OrgChannelsendListBak orgChannelsendListBak = this.createOrgChannelsendListBak(orgChannelsendListBakDomain);
        this.saveChannelsendListBakModel(orgChannelsendListBak);
        return orgChannelsendListBak.getChannelsendlistCode();
    }

    private OrgChannelsendListBak createOrgChannelsendListBak(OrgChannelsendListBakDomain orgChannelsendListBakDomain) {
        String msg = this.checkChannelsendListBak(orgChannelsendListBakDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("org.OrgChannelsendListServiceImpl.saveChannelsendListBak.checkChannelsendListBak", msg);
        }
        OrgChannelsendListBak orgChannelsendListBak = this.makeChannelsendListBak(orgChannelsendListBakDomain, null);
        this.setChannelsendListBakDefault(orgChannelsendListBak);
        return orgChannelsendListBak;
    }

    private void setChannelsendListBakDefault(OrgChannelsendListBak orgChannelsendListBak) {
        if (null == orgChannelsendListBak) {
            return;
        }
        if (null == orgChannelsendListBak.getDataState()) {
            orgChannelsendListBak.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == orgChannelsendListBak.getGmtCreate()) {
            orgChannelsendListBak.setGmtCreate(date);
        }
        orgChannelsendListBak.setGmtModified(date);
        if (StringUtils.isBlank((String)orgChannelsendListBak.getChannelsendlistCode())) {
            orgChannelsendListBak.setChannelsendlistCode(this.getNo(null, "OrgChannelsendListBak", "orgChannelsendListBak", orgChannelsendListBak.getTenantCode()));
        }
    }

    private OrgChannelsendListBak makeChannelsendListBak(OrgChannelsendListBakDomain orgChannelsendListBakDomain, OrgChannelsendListBak orgChannelsendListBak) {
        if (null == orgChannelsendListBakDomain) {
            return null;
        }
        if (null == orgChannelsendListBak) {
            orgChannelsendListBak = new OrgChannelsendListBak();
        }
        try {
            BeanUtils.copyAllPropertys((Object)orgChannelsendListBak, (Object)orgChannelsendListBakDomain);
            return orgChannelsendListBak;
        }
        catch (Exception e) {
            this.logger.error("org.OrgChannelsendListServiceImpl.makeChannelsendListBak", (Throwable)e);
            return null;
        }
    }

    private String checkChannelsendListBak(OrgChannelsendListBakDomain orgChannelsendListBakDomain) {
        if (null == orgChannelsendListBakDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)orgChannelsendListBakDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void saveChannelsendListBakModel(OrgChannelsendListBak orgChannelsendListBak) throws ApiException {
        if (null == orgChannelsendListBak) {
            return;
        }
        try {
            this.orgChannelsendListBakMapper.insert(orgChannelsendListBak);
        }
        catch (Exception e) {
            throw new ApiException("org.OrgChannelsendListServiceImpl.saveChannelsendListBakModel.ex", (Throwable)e);
        }
    }

    @Override
    public String saveChannelsendListBakBatch(List<OrgChannelsendListBakDomain> orgChannelsendListBakDomainList) throws ApiException {
        if (null == orgChannelsendListBakDomainList || orgChannelsendListBakDomainList.isEmpty()) {
            return null;
        }
        ArrayList<OrgChannelsendListBak> orgChannelsendListBakList = new ArrayList<OrgChannelsendListBak>();
        String code = "";
        for (OrgChannelsendListBakDomain orgChannelsendListBakDomain : orgChannelsendListBakDomainList) {
            OrgChannelsendListBak orgChannelsendListBak = this.createOrgChannelsendListBak(orgChannelsendListBakDomain);
            code = orgChannelsendListBak.getChannelsendlistCode();
            orgChannelsendListBakList.add(orgChannelsendListBak);
        }
        this.saveChannelsendListBakBatchModel(orgChannelsendListBakList);
        return code;
    }

    private void saveChannelsendListBakBatchModel(List<OrgChannelsendListBak> orgChannelsendListBakList) throws ApiException {
        if (null == orgChannelsendListBakList || orgChannelsendListBakList.isEmpty()) {
            return;
        }
        try {
            this.orgChannelsendListBakMapper.insertBatch(orgChannelsendListBakList);
        }
        catch (Exception e) {
            throw new ApiException("org.OrgChannelsendListServiceImpl.saveChannelsendListBakBatchModel.ex", (Throwable)e);
        }
    }

    @Override
    public void updateChannelsendListBakState(Integer channelsendlistbakId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == channelsendlistbakId) {
            return;
        }
        this.updateStateChannelsendListBakModel(channelsendlistbakId, dataState, oldDataState, map);
    }

    private void updateStateChannelsendListBakModel(Integer channelsendlistbakId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == channelsendlistbakId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("channelsendlistbakId", channelsendlistbakId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.orgChannelsendListBakMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("org.OrgChannelsendListServiceImpl.updateStateChannelsendListBakModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("org.OrgChannelsendListServiceImpl.updateStateChannelsendListBakModel.null");
        }
    }

    @Override
    public void updateChannelsendListBakStateByCode(String tenantCode, String channelsendlistCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)channelsendlistCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateChannelsendListBakModelByCode(tenantCode, channelsendlistCode, dataState, oldDataState, map);
    }

    private void updateStateChannelsendListBakModelByCode(String tenantCode, String channelsendlistCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)channelsendlistCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("channelsendlistCode", channelsendlistCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.orgChannelsendListBakMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("org.OrgChannelsendListServiceImpl.updateStateChannelsendListBakModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("org.OrgChannelsendListServiceImpl.updateStateChannelsendListBakModelByCode.null");
        }
    }

    @Override
    public void updateChannelsendListBak(OrgChannelsendListBakDomain orgChannelsendListBakDomain) throws ApiException {
        String msg = this.checkChannelsendListBak(orgChannelsendListBakDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("org.OrgChannelsendListServiceImpl.updateChannelsendListBak.checkChannelsendListBak", msg);
        }
        OrgChannelsendListBak oldOrgChannelsendListBak = this.getChannelsendListBakModelById(orgChannelsendListBakDomain.getChannelsendlistbakId());
        if (null == oldOrgChannelsendListBak) {
            throw new ApiException("org.OrgChannelsendListServiceImpl.updateChannelsendListBak.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        OrgChannelsendListBak orgChannelsendListBak = this.makeChannelsendListBak(orgChannelsendListBakDomain, oldOrgChannelsendListBak);
        this.setChannelsendListBakUpdataDefault(orgChannelsendListBak);
        this.updateChannelsendListBakModel(orgChannelsendListBak);
    }

    private void setChannelsendListBakUpdataDefault(OrgChannelsendListBak orgChannelsendListBak) {
        if (null == orgChannelsendListBak) {
            return;
        }
        orgChannelsendListBak.setGmtModified(this.getSysDate());
    }

    private OrgChannelsendListBak getChannelsendListBakModelById(Integer channelsendlistbakId) {
        if (null == channelsendlistbakId) {
            return null;
        }
        try {
            return this.orgChannelsendListBakMapper.selectByPrimaryKey(channelsendlistbakId);
        }
        catch (Exception e) {
            this.logger.error("org.OrgChannelsendListServiceImpl.getChannelsendListBakModelById", (Throwable)e);
            return null;
        }
    }

    private void updateChannelsendListBakModel(OrgChannelsendListBak orgChannelsendListBak) throws ApiException {
        if (null == orgChannelsendListBak) {
            return;
        }
        int i = 0;
        try {
            i = this.orgChannelsendListBakMapper.updateByPrimaryKey(orgChannelsendListBak);
        }
        catch (Exception e) {
            throw new ApiException("org.OrgChannelsendListServiceImpl.updateChannelsendListBakModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("org.OrgChannelsendListServiceImpl.updateChannelsendListBakModel.num");
        }
    }

    @Override
    public OrgChannelsendListBak getChannelsendListBak(Integer channelsendlistbakId) {
        if (null == channelsendlistbakId) {
            return null;
        }
        return this.getChannelsendListBakModelById(channelsendlistbakId);
    }

    @Override
    public void deleteChannelsendListBak(Integer channelsendlistbakId) throws ApiException {
        if (null == channelsendlistbakId) {
            return;
        }
        this.deleteChannelsendListBakModel(channelsendlistbakId);
    }

    private void deleteChannelsendListBakModel(Integer channelsendlistbakId) throws ApiException {
        if (null == channelsendlistbakId) {
            return;
        }
        int i = 0;
        try {
            i = this.orgChannelsendListBakMapper.deleteByPrimaryKey(channelsendlistbakId);
        }
        catch (Exception e) {
            throw new ApiException("org.OrgChannelsendListServiceImpl.deleteChannelsendListBakModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("org.OrgChannelsendListServiceImpl.deleteChannelsendListBakModel.num");
        }
    }

    @Override
    public QueryResult<OrgChannelsendListBak> queryChannelsendListBakPage(Map<String, Object> map) {
        List<OrgChannelsendListBak> orgChannelsendListBakList = this.queryChannelsendListBakModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countChannelsendListBak(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(orgChannelsendListBakList);
        return queryResult;
    }

    private int countChannelsendListBak(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.orgChannelsendListBakMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("org.OrgChannelsendListServiceImpl.countChannelsendListBak", (Throwable)e);
        }
        return i;
    }

    private List<OrgChannelsendListBak> queryChannelsendListBakModelPage(Map<String, Object> parammap) {
        try {
            return this.orgChannelsendListBakMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("org.OrgChannelsendListServiceImpl.queryChannelsendListBakModel", (Throwable)e);
            return null;
        }
    }

    @Override
    public OrgChannelsendListBak getChannelsendListBakByCode(String tenantCode, String channelsendlistCode) throws ApiException {
        if (StringUtils.isBlank((String)channelsendlistCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("channelsendlistCode", channelsendlistCode);
        return this.getChannelsendListBakModelByCode(map);
    }

    private OrgChannelsendListBak getChannelsendListBakModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.orgChannelsendListBakMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("org.OrgChannelsendListServiceImpl.getChannelsendListBakModelByCode", (Throwable)e);
            return null;
        }
    }

    @Override
    public void deleteChannelsendListBakByCode(String tenantCode, String channelsendlistCode) throws ApiException {
        if (StringUtils.isBlank((String)channelsendlistCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("channelsendlistCode", channelsendlistCode);
        this.delChannelsendListBakModelByCode(map);
    }

    private void delChannelsendListBakModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.orgChannelsendListBakMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("org.OrgChannelsendListServiceImpl.delChannelsendListBakModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("org.OrgChannelsendListServiceImpl.delChannelsendListBakModelByCode.num");
        }
    }

    @Override
    public String saveApiSendChannelsendlist(OrgChannelsendList orgChannelsendList) throws ApiException {
        this.logger.error("org.OrgChannelsendListServiceImplsaveApiSendChannelsendlist", (Object)("\u51c6\u5907\u53d1\u9001\u7684\u53c2\u6570\u4e3a:" + orgChannelsendList));
        if (null == orgChannelsendList || StringUtils.isBlank((String)orgChannelsendList.getChannelsendlistCode()) || StringUtils.isBlank((String)orgChannelsendList.getTenantCode())) {
            return "param is null";
        }
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        HashMap<String, Object> callparamMap = new HashMap<String, Object>();
        String parammsg = this.buildParam(orgChannelsendList, paramMap, callparamMap);
        if (StringUtils.isNotBlank((String)parammsg)) {
            this.logger.error("org.OrgChannelsendListServiceImpl.saveApiSendChannelsendlist.buildParam", (Object)((Object)paramMap).toString());
            return parammsg;
        }
        this.logger.error("org.OrgChannelsendListServiceImplsaveApiSendChannelsendlist", (Object)("\u51c6\u5907\u63a8\u9001\u7684\u6570\u636e\u4e3a" + paramMap));
        try {
            Map m;
            String msg = (String)this.getInternalRouter().inInvoke(orgChannelsendList.getChannelsendApiApicode(), "1.0", "0", paramMap);
            if (StringUtils.isNotBlank((String)msg) && (msg = msg.trim()).indexOf("{") == 0 && (MapUtil.isEmpty((Map)(m = (Map)JsonUtil.buildNormalBinder().getJsonToMap(msg, String.class, String.class))) || StringUtils.isBlank((String)((String)m.get("state"))) || !"success".equals(m.get("state")))) {
                this.logger.error("org.OrgChannelsendListServiceImpl.saveApiSendChannelsendlist.m", (Object)msg);
                if (msg.length() > 200) {
                    msg = msg.substring(0, 200);
                }
                return msg;
            }
        }
        catch (Exception e) {
            this.logger.error("org.OrgChannelsendListServiceImpl.saveApiSendChannelsendlist.ex", (Throwable)e);
            return "\u8c03\u7528\u5f02\u5e38:" + e.getMessage();
        }
        OrgChannelsendListBakReDomain pmChannelsendlistbakDomain = new OrgChannelsendListBakReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)pmChannelsendlistbakDomain, (Object)orgChannelsendList);
        }
        catch (Exception e) {
            this.logger.error("org.OrgChannelsendListServiceImpl.saveApiSendChannelsendlist.make", (Throwable)e);
        }
        String usersendBakCode = this.saveChannelsendListBak(pmChannelsendlistbakDomain);
        if (StringUtils.isBlank((String)usersendBakCode)) {
            this.logger.error("org.OrgChannelsendListServiceImpl.saveApiSendChannelsendlist.bak", (Object)"\u6dfb\u52a0\u5931\u8d25");
            return "bak\u5f02\u5e38";
        }
        this.deleteChannelsendListByCode(orgChannelsendList.getTenantCode(), orgChannelsendList.getChannelsendlistCode());
        return "";
    }

    @Override
    public void loadSendChannelsendlistProcess() {
        this.loadDb();
    }

    private void loadDb() {
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("order", true);
            map.put("orderStr", "GMT_CREATE asc");
            int startRow = 0;
            boolean flag = true;
            QueryResult<OrgChannelsendList> result = null;
            do {
                startRow = OrgChannelsendListServiceImpl.getEsSendEngineService().getStartRow();
                map.put("startRow", startRow);
                map.put("rows", OrgChannelsendListServiceImpl.getEsSendEngineService().getPage());
                result = this.queryChannelsendListPage(map);
                if (null != result && null != result.getPageTools() && null != result.getRows() && !result.getRows().isEmpty()) {
                    startRow = result.getPageTools().getRecordCountNo();
                    OrgChannelsendListServiceImpl.getEsSendEngineService().addPutPool(new EsSendEnginePutThread(OrgChannelsendListServiceImpl.getEsSendEngineService(), result.getRows()));
                    if (result.getRows().size() != OrgChannelsendListServiceImpl.getEsSendEngineService().getPage()) {
                        flag = false;
                    }
                } else {
                    flag = false;
                }
                Thread.sleep(5000L);
            } while (flag);
            OrgChannelsendListServiceImpl.getEsSendEngineService().initStartRow();
        }
        catch (Exception e) {
            throw new ApiException("org.OrgChannelsendListServiceImpl.loadDb.an.e", (Throwable)e);
        }
    }

    private String buildParam(OrgChannelsendList pmChannelsendlist, Map<String, Object> paramMap, Map<String, Object> callparamMap) {
        this.logger.error("org.OrgChannelsendListServiceImpl.buildParam. >>> ", (Object)pmChannelsendlist.getChannelsendApiApicode());
        if (pmChannelsendlist.getChannelsendApiApicode().equals("um.user.sendOpenUserinfo")) {
            UmUserDomainBean umUserDomainBean = new UmUserDomainBean();
            if ("orgCompany".equals(pmChannelsendlist.getChannelsendType())) {
                OrgCompany orgCompany = (OrgCompany)JsonUtil.buildNormalBinder().getJsonToObject(pmChannelsendlist.getChannelsendTxt(), OrgCompany.class);
                try {
                    BeanUtils.copyAllPropertys((Object)umUserDomainBean, (Object)orgCompany);
                    umUserDomainBean.setUserPhone(orgCompany.getCompanyContactsPhone());
                    umUserDomainBean.setUserinfoCon(orgCompany.getCompanyContacts());
                    umUserDomainBean.setUserinfoCorp(orgCompany.getCompanyLegal());
                    umUserDomainBean.setUserEmial(orgCompany.getCompanyEmail());
                    umUserDomainBean.setUserinfoCompname(orgCompany.getCompanyName());
                    umUserDomainBean.setUserinfoDischannelcode(orgCompany.getCompanyPcode());
                    umUserDomainBean.setUserinfoDischannelname(orgCompany.getCompanyPname());
                    umUserDomainBean.setUserinfoType(2);
                    umUserDomainBean.setUserinfoQuality("1".equals(orgCompany.getCompanyType()) ? "retailer" : "company");
                }
                catch (Exception exception) {}
            } else if ("orgDepart".equals(pmChannelsendlist.getChannelsendType())) {
                OrgDepart orgDepart = (OrgDepart)JsonUtil.buildNormalBinder().getJsonToObject(pmChannelsendlist.getChannelsendTxt(), OrgDepart.class);
                try {
                    BeanUtils.copyAllPropertys((Object)umUserDomainBean, (Object)orgDepart);
                    umUserDomainBean.setUserPhone(orgDepart.getDepartContactsPhone());
                    umUserDomainBean.setUserinfoCon(orgDepart.getDepartContacts());
                    umUserDomainBean.setUserEmial(orgDepart.getDepartEmail());
                    umUserDomainBean.setCompanyCode(orgDepart.getCompanyCode());
                    umUserDomainBean.setDepartCode(orgDepart.getDepartCode());
                    umUserDomainBean.setDepartName(orgDepart.getDepartName());
                    umUserDomainBean.setUserinfoCompname(orgDepart.getDepartName());
                    umUserDomainBean.setUserinfoType(2);
                    umUserDomainBean.setUserinfoQuality("depart");
                    umUserDomainBean.setUserinfoDischannelcode(orgDepart.getDepartPcode());
                    umUserDomainBean.setUserinfoDischannelname(orgDepart.getDepartPname());
                    OrgCompany orgCompany = this.getOrgCompanyService().getCompanyByCode(orgDepart.getTenantCode(), orgDepart.getCompanyCode());
                    if (null != orgCompany) {
                        umUserDomainBean.setUserinfoParentCode(orgCompany.getUserinfoCode());
                        umUserDomainBean.setUserinfoParentName(orgCompany.getCompanyName());
                    }
                }
                catch (Exception orgCompany) {}
            } else if ("orgEmployee".equals(pmChannelsendlist.getChannelsendType())) {
                OrgEmployee orgEmployee = (OrgEmployee)JsonUtil.buildNormalBinder().getJsonToObject(pmChannelsendlist.getChannelsendTxt(), OrgEmployee.class);
                try {
                    BeanUtils.copyAllPropertys((Object)umUserDomainBean, (Object)orgEmployee);
                    umUserDomainBean.setUserPhone(orgEmployee.getEmployeePhone());
                    umUserDomainBean.setUserinfoCon(orgEmployee.getEmployeeName());
                    umUserDomainBean.setUserEmial(orgEmployee.getEmployeeEmail());
                    umUserDomainBean.setEmployeeCode(orgEmployee.getEmployeeCode());
                    umUserDomainBean.setUserinfoCompname(orgEmployee.getEmployeeName());
                    umUserDomainBean.setUserinfoType(1);
                    umUserDomainBean.setUserinfoQuality("emp");
                    OrgCompany orgCompany = this.getOrgCompanyService().getCompanyByCode(orgEmployee.getTenantCode(), orgEmployee.getCompanyCode());
                    if (null != orgCompany) {
                        umUserDomainBean.setUserinfoParentCode(orgCompany.getUserinfoCode());
                        umUserDomainBean.setUserinfoParentName(orgCompany.getCompanyName());
                    }
                }
                catch (Exception orgCompany) {}
            } else if ("orgGroup".equals(pmChannelsendlist.getChannelsendType())) {
                OrgGroup orgGroup = (OrgGroup)JsonUtil.buildNormalBinder().getJsonToObject(pmChannelsendlist.getChannelsendTxt(), OrgGroup.class);
                try {
                    BeanUtils.copyAllPropertys((Object)umUserDomainBean, (Object)orgGroup);
                    umUserDomainBean.setUserPhone(orgGroup.getGroupContactsPhone());
                    umUserDomainBean.setUserinfoCon(orgGroup.getGroupContacts());
                    umUserDomainBean.setUserEmial(orgGroup.getGroupEmail());
                    umUserDomainBean.setUserinfoType(2);
                    umUserDomainBean.setCompanyCode(orgGroup.getGroupCode());
                    umUserDomainBean.setUserinfoCompname(orgGroup.getGroupName());
                    umUserDomainBean.setUserinfoDischannelcode(orgGroup.getGroupPcode());
                    umUserDomainBean.setUserinfoDischannelname(orgGroup.getGroupPname());
                    OrgCompany orgCompany = this.getOrgCompanyService().getCompanyByCode(orgGroup.getTenantCode(), orgGroup.getCompanyCode());
                    if (null != orgCompany) {
                        umUserDomainBean.setUserinfoParentCode(orgCompany.getUserinfoCode());
                        umUserDomainBean.setUserinfoParentName(orgCompany.getCompanyName());
                    }
                    umUserDomainBean.setUserinfoQuality("orggroup");
                }
                catch (Exception orgCompany) {
                    // empty catch block
                }
            }
            paramMap.put("umUserDomainBean", JsonUtil.buildNormalBinder().toJson((Object)umUserDomainBean));
        } else {
            if (OrganizeConstants.SendApiCode.EMPLOYEE_UPDATE_STATE.getApiCode().equals(pmChannelsendlist.getChannelsendApiApicode())) {
                OrgEmployee orgEmployee = (OrgEmployee)JsonUtil.buildNormalBinder().getJsonToObject(pmChannelsendlist.getChannelsendTxt(), OrgEmployee.class);
                paramMap.put("userCode", orgEmployee.getUserCode());
                paramMap.put("dataState", orgEmployee.getDataState());
                return "";
            }
            if ("um.user.orgUpdateSynUser".equals(pmChannelsendlist.getChannelsendApiApicode())) {
                this.logger.error("org.OrgChannelsendListServiceImpl.orgUpdateSynUser.buildParam. >>> ", (Object)pmChannelsendlist.getChannelsendApiApicode());
                OrgDepart orgDepart = (OrgDepart)JsonUtil.buildNormalBinder().getJsonToObject(pmChannelsendlist.getChannelsendTxt(), OrgDepart.class);
                UmUserDomainBean umUserDomainBean = new UmUserDomainBean();
                try {
                    BeanUtils.copyAllPropertys((Object)umUserDomainBean, (Object)orgDepart);
                    umUserDomainBean.setUserPhone(orgDepart.getDepartContactsPhone());
                    umUserDomainBean.setUserinfoCon(orgDepart.getDepartContacts());
                    umUserDomainBean.setUserEmial(orgDepart.getDepartEmail());
                    umUserDomainBean.setCompanyCode(orgDepart.getCompanyCode());
                    umUserDomainBean.setDepartCode(orgDepart.getDepartCode());
                    umUserDomainBean.setDepartName(orgDepart.getDepartName());
                    umUserDomainBean.setUserinfoCompname(orgDepart.getDepartName());
                    umUserDomainBean.setUserinfoType(2);
                    umUserDomainBean.setUserinfoQuality("depart");
                    umUserDomainBean.setUserinfoDischannelcode(orgDepart.getDepartPcode());
                    umUserDomainBean.setUserinfoDischannelname(orgDepart.getDepartPname());
                    OrgCompany orgCompany = this.getOrgCompanyService().getCompanyByCode(orgDepart.getTenantCode(), orgDepart.getCompanyCode());
                    if (null != orgCompany) {
                        umUserDomainBean.setUserinfoParentCode(orgCompany.getUserinfoCode());
                        umUserDomainBean.setUserinfoParentName(orgCompany.getCompanyName());
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                paramMap.put("umUserDomainBean", JsonUtil.buildNormalBinder().toJson((Object)umUserDomainBean));
            } else {
                paramMap.put("channelCode", pmChannelsendlist.getChannelCode());
                paramMap.put("tenantCode", pmChannelsendlist.getTenantCode());
                String memberCode = pmChannelsendlist.getMemberCode();
                paramMap.put("memberCode", memberCode);
                paramMap.put(pmChannelsendlist.getChannelsendType(), pmChannelsendlist.getChannelsendTxt());
            }
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EsSendEngineService getEsSendEngineService() {
        Object object = lock;
        synchronized (object) {
            if (null == esSendEngineService) {
                esSendEngineService = new EsSendEngineService((OrgChannelsendListService)SpringApplicationContextUtil.getBean((String)"orgChannelsendListService"), (InternalRouter)SpringApplicationContextUtil.getBean((String)"internalRouter"));
                for (int i = 0; i < 80; ++i) {
                    esSendEngineService.addPollPool(new EsSendEnginePollThread(esSendEngineService));
                }
            }
            return esSendEngineService;
        }
    }

    static {
        lock = new Object();
    }
}

