/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.pay.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.pay.PaConstants;
import com.yqbsoft.laser.service.pay.dao.PaPaymentMapper;
import com.yqbsoft.laser.service.pay.domain.PaPaymentDomain;
import com.yqbsoft.laser.service.pay.model.PaPayment;
import com.yqbsoft.laser.service.pay.model.PtradeBackBean;
import com.yqbsoft.laser.service.pay.service.PaPaymentService;
import com.yqbsoft.laser.service.pay.trade.domain.PtePtradeDomain;
import com.yqbsoft.laser.service.pay.trade.enumc.PtradpdeEnum;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class PaPaymentServiceImpl
extends BaseServiceImpl
implements PaPaymentService {
    public static final String SYS_CODE = "PA.PaPaymentServiceImpl";
    private PaPaymentMapper paPaymentMapper;

    public void setPaPaymentMapper(PaPaymentMapper paPaymentMapper) {
        this.paPaymentMapper = paPaymentMapper;
    }

    private Date getSysDate() {
        try {
            return this.paPaymentMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("PA.PaPaymentServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkPayment(PaPaymentDomain paPaymentDomain) {
        if (null == paPaymentDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)paPaymentDomain.getTenantCode())) {
            msg = msg + "\u79df\u6237\u4ee3\u7801\u4e3a\u7a7a;";
        }
        if (paPaymentDomain.getOrderAmount() == null) {
            msg = msg + "\u91d1\u989d\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)paPaymentDomain.getOpuserCode())) {
            msg = msg + "\u7528\u6237\u4ee3\u7801\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)paPaymentDomain.getMerchantCode())) {
            msg = msg + "\u5546\u6237\u4ee3\u7801\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setPaymentDefault(PaPayment paPayment) {
        if (null == paPayment) {
            return;
        }
        if (null == paPayment.getDataState()) {
            paPayment.setDataState(0);
        }
        if (null == paPayment.getGmtCreate()) {
            paPayment.setGmtCreate(this.getSysDate());
        }
        paPayment.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)paPayment.getPaymentCode())) {
            paPayment.setPaymentCode(this.createUUIDString());
        }
    }

    private int getPaymentMaxCode() {
        int code = 0;
        try {
            return this.paPaymentMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("PA.PaPaymentServiceImpl.getPaymentMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setPaymentUpdataDefault(PaPayment paPayment) {
        if (null == paPayment) {
            return;
        }
        paPayment.setGmtModified(this.getSysDate());
    }

    private void savePaymentModel(PaPayment paPayment) throws ApiException {
        if (null == paPayment) {
            return;
        }
        try {
            this.paPaymentMapper.insert(paPayment);
        }
        catch (Exception e) {
            throw new ApiException("PA.PaPaymentServiceImpl.savePaymentModel.ex", (Throwable)e);
        }
    }

    private PaPayment getPaymentModelById(Integer paymentId) {
        if (null == paymentId) {
            return null;
        }
        try {
            return this.paPaymentMapper.selectByPrimaryKey(paymentId);
        }
        catch (Exception e) {
            this.logger.error("PA.PaPaymentServiceImpl.getPaymentModelById", (Throwable)e);
            return null;
        }
    }

    public PaPayment getPaymentModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.paPaymentMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("PA.PaPaymentServiceImpl.getPaymentModelByCode", (Throwable)e);
            return null;
        }
    }

    public void delPaymentModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.paPaymentMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("PA.PaPaymentServiceImpl.delPaymentModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("PA.PaPaymentServiceImpl.delPaymentModelByCode.num");
        }
    }

    private void deletePaymentModel(Integer paymentId) throws ApiException {
        if (null == paymentId) {
            return;
        }
        int i = 0;
        try {
            i = this.paPaymentMapper.deleteByPrimaryKey(paymentId);
        }
        catch (Exception e) {
            throw new ApiException("PA.PaPaymentServiceImpl.deletePaymentModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("PA.PaPaymentServiceImpl.deletePaymentModel.num");
        }
    }

    private void updatePaymentModel(PaPayment paPayment) throws ApiException {
        if (null == paPayment) {
            return;
        }
        try {
            this.paPaymentMapper.updateByPrimaryKeySelective(paPayment);
        }
        catch (Exception e) {
            throw new ApiException("PA.PaPaymentServiceImpl.updatePaymentModel.ex", (Throwable)e);
        }
    }

    private void updateStatePaymentModel(Integer paymentId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == paymentId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("paymentId", paymentId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.paPaymentMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("PA.PaPaymentServiceImpl.updateStatePaymentModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("PA.PaPaymentServiceImpl.updateStatePaymentModel.null");
        }
    }

    private PaPayment makePayment(PaPaymentDomain paPaymentDomain, PaPayment paPayment) {
        if (null == paPaymentDomain) {
            return null;
        }
        if (null == paPayment) {
            paPayment = new PaPayment();
        }
        try {
            BeanUtils.copyAllPropertys((Object)paPayment, (Object)paPaymentDomain);
            return paPayment;
        }
        catch (Exception e) {
            this.logger.error("PA.PaPaymentServiceImpl.makePayment", (Throwable)e);
            return null;
        }
    }

    private List<PaPayment> queryPaymentModelPage(Map<String, Object> parammap) {
        try {
            return this.paPaymentMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("PA.PaPaymentServiceImpl.queryPaymentModel", (Throwable)e);
            return null;
        }
    }

    private int countPayment(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.paPaymentMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("PA.PaPaymentServiceImpl.countPayment", (Throwable)e);
        }
        return i;
    }

    @Override
    public String savePayment(PaPaymentDomain paPaymentDomain) throws ApiException {
        String msg = this.checkPayment(paPaymentDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("PA.PaPaymentServiceImpl.savePayment.checkPayment", msg);
        }
        PaPayment paPayment = this.makePayment(paPaymentDomain, null);
        this.setPaymentDefault(paPayment);
        this.savePaymentModel(paPayment);
        return paPayment.getPaymentCode();
    }

    @Override
    public void updatePaymentState(Integer paymentId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStatePaymentModel(paymentId, dataState, oldDataState);
    }

    @Override
    public void updatePayment(PaPaymentDomain paPaymentDomain) throws ApiException {
        String msg = this.checkPayment(paPaymentDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("PA.PaPaymentServiceImpl.updatePayment.checkPayment", msg);
        }
        PaPayment oldPaPayment = this.getPaymentModelById(paPaymentDomain.getPaymentId());
        if (null == oldPaPayment) {
            throw new ApiException("PA.PaPaymentServiceImpl.updatePayment.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        PaPayment paPayment = this.makePayment(paPaymentDomain, oldPaPayment);
        this.setPaymentUpdataDefault(paPayment);
        this.updatePaymentModel(paPayment);
    }

    @Override
    public PaPayment getPayment(Integer paymentId) {
        return this.getPaymentModelById(paymentId);
    }

    @Override
    public void deletePayment(Integer paymentId) throws ApiException {
        this.deletePaymentModel(paymentId);
    }

    @Override
    public QueryResult<PaPayment> queryPaymentPage(Map<String, Object> map) {
        List<PaPayment> paPaymentList = this.queryPaymentModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countPayment(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(paPaymentList);
        return queryResult;
    }

    @Override
    public PaPayment getPaymentByCode(Map<String, Object> map) {
        return this.getPaymentModelByCode(map);
    }

    @Override
    public void delPaymentByCode(Map<String, Object> map) throws ApiException {
        this.delPaymentModelByCode(map);
    }

    @Override
    public String savePyamentToPte(PaPaymentDomain paPaymentDomain) {
        if (paPaymentDomain == null) {
            throw new ApiException("PA.PaPaymentServiceImpl.savePyamentToPte.paPaymentDomain\u5bf9\u8c61\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isBlank((String)paPaymentDomain.getPtradpdeCode())) {
            paPaymentDomain.setPtradpdeCode(PtradpdeEnum.PAYMENT.getCode());
        }
        String paymentCode = this.savePayment(paPaymentDomain);
        PtePtradeDomain ptePtradeDomain = new PtePtradeDomain();
        try {
            BeanUtils.copyAllPropertys((Object)ptePtradeDomain, (Object)paPaymentDomain);
            ptePtradeDomain.setBusinessOrderno(paymentCode);
            ptePtradeDomain.setAcquireSeqno(paymentCode);
            ptePtradeDomain.setPtradpdeCode(paPaymentDomain.getPtradpdeCode());
            ptePtradeDomain.setPaymentNotifyurl("pa.payment.updatePyamentToPteBack");
        }
        catch (Exception e) {
            this.logger.error("PA.PaPaymentServiceImpl.copyAllPropertys", (Throwable)e);
        }
        HashMap<String, String> queryMap = new HashMap<String, String>();
        queryMap.put("ptePtradeDomain", JsonUtil.buildNormalBinder().toJson((Object)ptePtradeDomain));
        String result = this.internalInvoke("pte.ptrade.savePtrade", queryMap);
        if (StringUtils.isBlank((String)result)) {
            throw new ApiException("PA.PaPaymentServiceImpl.savePyamentToPte.pte.ptrade.savePtrade", "\u8c03\u7528\u4ea4\u6613\u5f15\u64ce\u5931\u8d25\uff01");
        }
        return result;
    }

    @Override
    public boolean updatePyamentToPteBack(Map<String, Object> map) {
        if (map == null || map.isEmpty()) {
            return false;
        }
        String paymentCode = (String)map.get("acquireSeqno");
        String tenantCode = (String)map.get("tenantCode");
        Integer dataState = (Integer)map.get("dataState");
        if (StringUtils.isBlank((String)paymentCode) || dataState == null) {
            throw new ApiException("PA.PaPaymentServiceImpl.updatePyamentToPteBack.null", "\u53c2\u6570\u4e3a\u7a7a\uff01");
        }
        HashMap<String, Object> pmap = new HashMap<String, Object>();
        pmap.put("paymentCode", paymentCode);
        pmap.put("tenantCode", tenantCode);
        PaPayment paPayment = this.getPaymentByCode(pmap);
        if (paPayment == null) {
            throw new ApiException("PA.PaPaymentServiceImpl.updatePyamentToPteBack.null", "\u67e5\u8be2\u652f\u4ed8\u8ba2\u5355\u4fe1\u606f\u5931\u8d25\uff01");
        }
        if (PtradpdeEnum.PAYMENTBACK.getCode().equals(paPayment.getPtradpdeCode())) {
            dataState = dataState == 3 ? PaConstants.DATA_STATE_4 : (dataState == 5 ? PaConstants.DATA_STATE_5 : PaConstants.DATA_STATE_10);
            pmap.put("paymentCode", paPayment.getBusinessOrderno());
            PaPayment oldpaPayment = this.getPaymentByCode(pmap);
            if (oldpaPayment != null) {
                this.updateStatePaymentModel(oldpaPayment.getPaymentId(), dataState, oldpaPayment.getDataState());
            }
        } else if (PtradpdeEnum.PAYMENT.getCode().equals(paPayment.getPtradpdeCode())) {
            dataState = dataState == 2 ? PaConstants.DATA_STATE_1 : (dataState == 3 ? PaConstants.DATA_STATE_2 : PaConstants.DATA_STATE_9);
        }
        this.updateStatePaymentModel(paPayment.getPaymentId(), dataState, paPayment.getDataState());
        return true;
    }

    @Override
    public void savePyamentToPteBack(PtradeBackBean ptradeBackBean) {
        if (ptradeBackBean == null) {
            throw new ApiException("PA.PaPaymentServiceImpl.saveRechargeTradeBack.null", "\u6570\u636e\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isBlank((String)ptradeBackBean.getAcquireSeqno())) {
            throw new ApiException("PA.PaPaymentServiceImpl.saveRechargeTradeBack.null", "\u56de\u9000\u8ba2\u5355\u7f16\u53f7\u4e3a\u7a7a\uff01");
        }
        this.logger.info("savePyamentToPteBack >>>>>>>>>>>> ", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)ptradeBackBean));
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("paymentCode", ptradeBackBean.getAcquireSeqno());
        map.put("tenantCode", ptradeBackBean.getTenantCode());
        map.put("dataState", PaConstants.DATA_STATE_2);
        PaPayment paPayment = this.getPaymentByCode(map);
        if (paPayment == null) {
            throw new ApiException("PA.PaPaymentServiceImpl.savePyamentToPteBack.null", "\u8ba2\u5355\u72b6\u6001\u4e0d\u80fd\u9000\u6b3e\uff01");
        }
        paPayment.setDataState(null);
        paPayment.setPaymentId(null);
        paPayment.setPaymentCode(null);
        paPayment.setGmtCreate(null);
        paPayment.setDataState(PaConstants.DATA_STATE_3);
        if (StringUtils.isBlank((String)ptradeBackBean.getPtradpdeCode())) {
            paPayment.setPtradpdeCode(PtradpdeEnum.PAYMENTBACK.getCode());
        }
        if (ptradeBackBean.getOrderAmount() != null && ptradeBackBean.getOrderAmount().compareTo(BigDecimal.ZERO) == 1) {
            paPayment.setOrderAmount(ptradeBackBean.getOrderAmount());
        }
        this.setPaymentDefault(paPayment);
        this.savePaymentModel(paPayment);
        ptradeBackBean.setAcquireSeqno_new(paPayment.getPaymentCode());
        ptradeBackBean.setPtradpdeCode(paPayment.getPtradpdeCode());
        if (ptradeBackBean.getTenantCode().equals("2020021100000063")) {
            ptradeBackBean.setBackAmountType("2");
        }
        ConcurrentHashMap<String, String> queryMap = new ConcurrentHashMap<String, String>();
        queryMap.put("ptradeBackBean", JsonUtil.buildNormalBinder().toJson((Object)ptradeBackBean));
        this.internalInvoke("pte.ptrade.saveParticipantByPtradeBack", queryMap);
    }
}

