/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.payengine.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.log.performance.OpenPerfLogUtil;
import com.yqbsoft.laser.service.esb.core.router.InternalRouter;
import com.yqbsoft.laser.service.payengine.domain.CmFchannel;
import com.yqbsoft.laser.service.payengine.domain.CmFchannelClassify;
import com.yqbsoft.laser.service.payengine.domain.CmFchannelInfo;
import com.yqbsoft.laser.service.payengine.domain.PayClearInfoQ;
import com.yqbsoft.laser.service.payengine.domain.PeClearOrderDomain;
import com.yqbsoft.laser.service.payengine.domain.PePaymentDomain;
import com.yqbsoft.laser.service.payengine.domain.PePaymentOrderDomain;
import com.yqbsoft.laser.service.payengine.domain.PeProtClearagCycleReDomain;
import com.yqbsoft.laser.service.payengine.domain.PeProtClearagFaReDomain;
import com.yqbsoft.laser.service.payengine.domain.PeProtClearagReDomain;
import com.yqbsoft.laser.service.payengine.domain.PeProtCruleInfoReDomain;
import com.yqbsoft.laser.service.payengine.domain.PeProtCruleReDomain;
import com.yqbsoft.laser.service.payengine.enumc.ClearagType;
import com.yqbsoft.laser.service.payengine.enumc.FaccountIdType;
import com.yqbsoft.laser.service.payengine.enumc.ProtCruleType;
import com.yqbsoft.laser.service.payengine.model.PePaymentParticipant;
import com.yqbsoft.laser.service.payengine.model.PeProtClearinfo;
import com.yqbsoft.laser.service.payengine.transformer.ExpBean;
import com.yqbsoft.laser.service.payengine.transformer.ExpEnum;
import com.yqbsoft.laser.service.suppercore.log.SupperLogUtil;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.DateUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ScriptUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RuleService {
    private InternalRouter internalRouter;
    protected final SupperLogUtil logger = new SupperLogUtil(this.getClass());
    public static final String SYS_CODE = "pe.RuleService";

    public InternalRouter getInternalRouter() {
        return this.internalRouter;
    }

    public void setInternalRouter(InternalRouter internalRouter) {
        this.internalRouter = internalRouter;
    }

    public List<PeClearOrderDomain> exRule(PayClearInfoQ payClearInfoQ) {
        if (null == payClearInfoQ || null == payClearInfoQ.getPeProtClearinfo() || null == payClearInfoQ.getPeProtEtc() || null == payClearInfoQ.getPePaymentOrderDomain()) {
            return null;
        }
        long start = System.currentTimeMillis();
        PeProtClearinfo peProtClearinfo = payClearInfoQ.getPeProtClearinfo();
        PePaymentOrderDomain pePaymentOrderDomain = payClearInfoQ.getPePaymentOrderDomain();
        String supkey = peProtClearinfo.getTenantCode();
        String key = (supkey = supkey + "-" + pePaymentOrderDomain.getDicPaypdCode() + "-" + peProtClearinfo.getDicPayType() + "-" + peProtClearinfo.getDicClearCode() + "-" + peProtClearinfo.getDicClearreqCode()) + "-" + payClearInfoQ.getPeProtEtc().getProtEtcType();
        String v = DisUtil.getMap((String)"peProtCrule", (String)key);
        if (StringUtils.isBlank((String)v)) {
            this.logger.debug("pe.RuleService.exRule.rule", (Object)("\u7edf\u914d\u89c4\u5219key:" + key));
            key = supkey = supkey + "-*";
            v = DisUtil.getMap((String)"peProtCrule", (String)key);
        }
        if (StringUtils.isBlank((String)v)) {
            supkey = peProtClearinfo.getTenantCode();
            supkey = supkey + "-" + pePaymentOrderDomain.getDicPaypdCode() + "-" + peProtClearinfo.getDicPayType() + "-" + peProtClearinfo.getDicClearCode() + "-" + peProtClearinfo.getDicClearreqCode();
            key = supkey = supkey + "-*";
            v = DisUtil.getMap((String)"peProtCrule", (String)key);
        }
        if (StringUtils.isBlank((String)v)) {
            supkey = peProtClearinfo.getTenantCode();
            supkey = supkey + "-*-" + peProtClearinfo.getDicPayType() + "-" + peProtClearinfo.getDicClearCode() + "-" + peProtClearinfo.getDicClearreqCode();
            key = supkey = supkey + "-*";
            v = DisUtil.getMap((String)"peProtCrule", (String)key);
        }
        if (StringUtils.isBlank((String)v)) {
            supkey = "00000000";
            supkey = supkey + "-*-" + peProtClearinfo.getDicPayType() + "-" + peProtClearinfo.getDicClearCode() + "-" + peProtClearinfo.getDicClearreqCode();
            key = supkey = supkey + "-*";
            v = DisUtil.getMap((String)"peProtCrule", (String)key);
        }
        if (StringUtils.isBlank((String)v)) {
            throw new ApiException("pe.RuleService.exRule.null", "key:" + key);
        }
        PeProtCruleReDomain peProtCruleReDomain = (PeProtCruleReDomain)JsonUtil.buildNormalBinder().getJsonToObject(v, PeProtCruleReDomain.class);
        if (null == peProtCruleReDomain || null == peProtCruleReDomain.getInfoReDomainList()) {
            throw new ApiException("pe.RuleService.exRule.json", "key:" + key + "==" + v);
        }
        ArrayList<PeClearOrderDomain> orderList = new ArrayList<PeClearOrderDomain>();
        HashMap<String, String> actorCode = new HashMap<String, String>();
        for (PeProtCruleInfoReDomain peProtCruleInfoReDomain : peProtCruleReDomain.getInfoReDomainList()) {
            PeClearOrderDomain peClearOrderDomain = this.createOrder(payClearInfoQ, peProtCruleInfoReDomain, actorCode);
            if (null == peClearOrderDomain) continue;
            orderList.add(peClearOrderDomain);
        }
        if (null == orderList || orderList.isEmpty()) {
            throw new ApiException("pe.RuleService.exRule.orderList", "key:" + key + "==" + v);
        }
        OpenPerfLogUtil.debug((String)("RuleService exRule end time consuming:{}ms,paymentSeqno=" + payClearInfoQ.getPePaymentDomain().getPaymentSeqno()), (long)(System.currentTimeMillis() - start));
        return orderList;
    }

    private PeClearOrderDomain createOrder(PayClearInfoQ payClearInfoQ, PeProtCruleInfoReDomain peProtCruleInfoReDomain, Map<String, String> actorCode) {
        if (null == payClearInfoQ || null == payClearInfoQ.getParticipantList() || null == payClearInfoQ.getPeProtClearinfo() || null == peProtCruleInfoReDomain || null == payClearInfoQ.getPePaymentOrderDomain()) {
            return null;
        }
        PeClearOrderDomain peClearOrderDomain = this.make(payClearInfoQ);
        if (null == peClearOrderDomain) {
            return null;
        }
        if (null == (peClearOrderDomain = this.excuteRule(peProtCruleInfoReDomain, peClearOrderDomain, this.makeParticipantMap(payClearInfoQ.getParticipantList()), actorCode))) {
            this.logger.error("pe.RuleService.createOrder.peClearOrderDomain");
            return null;
        }
        if (null == peClearOrderDomain.getOrderAmount() || new BigDecimal("0").equals(peClearOrderDomain.getOrderAmount())) {
            this.logger.debug("pe.RuleService.createOrder.0", (Object)"");
            return null;
        }
        if (StringUtils.isNotBlank((String)peClearOrderDomain.getFchannelCode())) {
            String proStr = DisUtil.getMap((String)"Fchannel_pro", (String)(peClearOrderDomain.getFchannelCode() + "-" + peClearOrderDomain.getTenantCode()));
            if (StringUtils.isBlank((String)proStr)) {
                proStr = DisUtil.getMap((String)"Fchannel_pro", (String)(peClearOrderDomain.getFchannelCode() + "-" + "00000000"));
            }
            if (StringUtils.isNotBlank((String)proStr)) {
                CmFchannel cmFchannel = (CmFchannel)JsonUtil.buildNormalBinder().getJsonToObject(proStr, CmFchannel.class);
                if (null == cmFchannel) {
                    this.logger.error("pe.RuleService.createOrder.proStr", (Object)(peClearOrderDomain.getFchannelCode() + "-" + peClearOrderDomain.getTenantCode()));
                }
                peClearOrderDomain.setClearOrderCtype(cmFchannel.getFchannelPro());
                peClearOrderDomain.setFaccountLocation(cmFchannel.getFchannelLocation());
                peClearOrderDomain.setFchannelName(cmFchannel.getFchannelName());
            } else {
                this.logger.error("pe.RuleService.createOrder.proStr", (Object)(peClearOrderDomain.getFchannelCode() + "-" + peClearOrderDomain.getTenantCode()));
            }
        }
        peClearOrderDomain.setProtEtcSeqno(this.createProtEtcSeqno(payClearInfoQ.getPeProtEtc().getProtEtcSeqno(), peClearOrderDomain));
        peClearOrderDomain = this.excuteClearag(payClearInfoQ.getPePaymentDomain(), payClearInfoQ.getPePaymentOrderDomain(), peClearOrderDomain);
        if (null == peClearOrderDomain) {
            this.logger.error("pe.RuleService.createOrder.peClearOrderDomain");
            return null;
        }
        return peClearOrderDomain;
    }

    public String createProtEtcSeqno(String protEtcSeqnoEx, PeClearOrderDomain peClearOrde) {
        if (null == peClearOrde) {
            return "";
        }
        if (StringUtils.isBlank((String)protEtcSeqnoEx) || "-".equals(protEtcSeqnoEx)) {
            return "-";
        }
        String[] paStr = protEtcSeqnoEx.split("\\+");
        if (null == paStr) {
            return protEtcSeqnoEx;
        }
        String protEtcSeqno = "";
        String proName = "";
        for (int i = 0; i < paStr.length; ++i) {
            proName = paStr[i];
            if (StringUtils.isNotBlank((String)protEtcSeqno)) {
                protEtcSeqno = protEtcSeqno + "-";
            }
            if (proName.indexOf("$") >= 0) {
                proName = proName.replace("$", "").replace("{", "").replace("}", "").trim();
                protEtcSeqno = protEtcSeqno + (String)BeanUtils.forceGetProperty((Object)peClearOrde, (String)proName);
                continue;
            }
            protEtcSeqno = protEtcSeqno + proName;
        }
        return protEtcSeqno;
    }

    private PeClearOrderDomain excuteClearag(PePaymentDomain pePaymentDomain, PePaymentOrderDomain pePaymentOrderDomain, PeClearOrderDomain peClearOrderDomain) {
        if (null == peClearOrderDomain || null == pePaymentOrderDomain || null == pePaymentDomain) {
            return null;
        }
        String key = peClearOrderDomain.getTenantCode();
        String clearagStr = DisUtil.getMap((String)"PeProtClearag", (String)(key = key + "-" + ClearagType.MERCHANT.getCode() + "-" + pePaymentOrderDomain.getMerchantCode()));
        if (StringUtils.isBlank((String)clearagStr)) {
            key = peClearOrderDomain.getTenantCode();
            key = key + "-" + ClearagType.PARTNER.getCode() + "-" + pePaymentDomain.getPartnerCode();
            clearagStr = DisUtil.getMap((String)"PeProtClearag", (String)key);
        }
        if (StringUtils.isBlank((String)clearagStr)) {
            key = peClearOrderDomain.getTenantCode();
            key = key + "-*-*";
            clearagStr = DisUtil.getMap((String)"PeProtClearag", (String)key);
        }
        if (StringUtils.isBlank((String)clearagStr)) {
            peClearOrderDomain.setClearOrderTime(new Date());
            return peClearOrderDomain;
        }
        PeProtClearagReDomain peProtClearagReDomain = (PeProtClearagReDomain)JsonUtil.buildNormalBinder().getJsonToObject(clearagStr, PeProtClearagReDomain.class);
        if (null == peProtClearagReDomain) {
            this.logger.error("pe.RuleService.createOrder.peClearOrderDomain", (Object)("key:" + key));
            peClearOrderDomain = null;
            return null;
        }
        this.createFa(peClearOrderDomain, peProtClearagReDomain.getFaReDomainList());
        this.createCycle(pePaymentDomain.getGmtCreate(), peClearOrderDomain, peProtClearagReDomain.getCycleReDomainList());
        this.missClear(peClearOrderDomain);
        return peClearOrderDomain;
    }

    private void missClear(PeClearOrderDomain peClearOrderDomain) {
        if (peClearOrderDomain.getClearOrderTime() == null) {
            peClearOrderDomain.setClearOrderTime(new Date());
        }
    }

    private void createCycle(Date createDate, PeClearOrderDomain peClearOrderDomain, List<PeProtClearagCycleReDomain> cycleReDomainList) {
        if (null == peClearOrderDomain || null == cycleReDomainList || cycleReDomainList.isEmpty()) {
            return;
        }
        for (PeProtClearagCycleReDomain peProtClearagCycleReDomain : cycleReDomainList) {
            if (!this.equalsCycle(peProtClearagCycleReDomain, peClearOrderDomain)) continue;
            String t = peProtClearagCycleReDomain.getProtClearagCycleT();
            if (StringUtils.isBlank((String)t)) {
                t = "1";
            }
            String time = DateUtils.getAfterDate((Date)createDate, (int)Integer.valueOf(t), (String)"yyyy-MM-dd 00:00:00");
            peClearOrderDomain.setClearOrderTime(DateUtils.getDateToString((String)time, (String)"yyyy-MM-dd HH:mm:ss"));
        }
    }

    private boolean equalsCycle(PeProtClearagCycleReDomain peProtClearagCycleReDomain, PeClearOrderDomain peClearOrderDomain) {
        if (null == peClearOrderDomain || null == peProtClearagCycleReDomain) {
            return false;
        }
        if (StringUtils.isNotBlank((String)peProtClearagCycleReDomain.getDicPaypdCode()) && !peProtClearagCycleReDomain.getDicPaypdCode().equals(peClearOrderDomain.getDicPaypdCode())) {
            return false;
        }
        if (StringUtils.isNotBlank((String)peProtClearagCycleReDomain.getProtClearagCycleType()) && !peProtClearagCycleReDomain.getProtClearagCycleType().equals(peClearOrderDomain.getDicActorCode())) {
            return false;
        }
        if (StringUtils.isNotBlank((String)peProtClearagCycleReDomain.getDicClearCode()) && !peProtClearagCycleReDomain.getDicClearCode().equals(peClearOrderDomain.getDicClearCode())) {
            return false;
        }
        if (StringUtils.isNotBlank((String)peProtClearagCycleReDomain.getDicClearreqCode()) && !peProtClearagCycleReDomain.getDicClearreqCode().equals(peClearOrderDomain.getDicClearreqCode())) {
            return false;
        }
        if (StringUtils.isNotBlank((String)peProtClearagCycleReDomain.getProtClearagCycleTid()) && !peProtClearagCycleReDomain.getProtClearagCycleTid().equals(peClearOrderDomain.getFaccountId())) {
            return false;
        }
        if (StringUtils.isNotBlank((String)peProtClearagCycleReDomain.getProtClearagCycleCondition())) {
            HashMap<String, PeClearOrderDomain> map = new HashMap<String, PeClearOrderDomain>();
            map.put("peClearOrderDomain", peClearOrderDomain);
            String res = (String)ScriptUtil.evel((String)peProtClearagCycleReDomain.getProtClearagCycleCondition(), map);
            if (!"ok".equals(res)) {
                return false;
            }
        }
        return true;
    }

    private void createFa(PeClearOrderDomain peClearOrderDomain, List<PeProtClearagFaReDomain> faReDomainList) {
        if (null == peClearOrderDomain || null == faReDomainList || faReDomainList.isEmpty()) {
            return;
        }
        for (PeProtClearagFaReDomain peProtClearagFaReDomain : faReDomainList) {
            if (!this.equalsFa(peProtClearagFaReDomain, peClearOrderDomain)) continue;
            if (StringUtils.isNotBlank((String)peProtClearagFaReDomain.getFchannelClassifyCode())) {
                peClearOrderDomain.setFchannelClassifyCode(peProtClearagFaReDomain.getFchannelClassifyCode());
            }
            if (StringUtils.isNotBlank((String)peProtClearagFaReDomain.getFaccountId())) {
                peClearOrderDomain.setFaccountId(peProtClearagFaReDomain.getFaccountId());
            }
            if (StringUtils.isNotBlank((String)peProtClearagFaReDomain.getFundType())) {
                peClearOrderDomain.setFundType(peProtClearagFaReDomain.getFundType());
            }
            return;
        }
    }

    private boolean equalsFa(PeProtClearagFaReDomain peProtClearagFaReDomain, PeClearOrderDomain peClearOrderDomain) {
        if (null == peProtClearagFaReDomain || null == peClearOrderDomain) {
            return false;
        }
        if (StringUtils.isNotBlank((String)peProtClearagFaReDomain.getDicPaypdCode()) && !peProtClearagFaReDomain.getDicPaypdCode().equals(peClearOrderDomain.getDicPaypdCode())) {
            return false;
        }
        if (StringUtils.isNotBlank((String)peProtClearagFaReDomain.getDicActorCode()) && !peProtClearagFaReDomain.getDicActorCode().equals(peClearOrderDomain.getDicActorCode())) {
            return false;
        }
        if (StringUtils.isNotBlank((String)peProtClearagFaReDomain.getDicClearCode()) && !peProtClearagFaReDomain.getDicClearCode().equals(peClearOrderDomain.getDicClearCode())) {
            return false;
        }
        return !StringUtils.isNotBlank((String)peProtClearagFaReDomain.getDicClearreqCode()) || peProtClearagFaReDomain.getDicClearreqCode().equals(peClearOrderDomain.getDicClearreqCode());
    }

    private PeClearOrderDomain excuteRule(PeProtCruleInfoReDomain peProtCruleInfoReDomain, PeClearOrderDomain peClearOrderDomain, Map<String, PePaymentParticipant> map, Map<String, String> actorCode) {
        String am;
        String[] s;
        if (null == peProtCruleInfoReDomain || null == peClearOrderDomain || null == map || map.isEmpty()) {
            return null;
        }
        String type = peProtCruleInfoReDomain.getProtCruleType();
        if (StringUtils.isNotBlank((String)peProtCruleInfoReDomain.getFundType())) {
            peClearOrderDomain.setFundType(peProtCruleInfoReDomain.getFundType());
        }
        if (StringUtils.isNotBlank((String)peProtCruleInfoReDomain.getOrderlDc())) {
            peClearOrderDomain.setOrderDc(peProtCruleInfoReDomain.getOrderlDc());
        }
        peClearOrderDomain.setClearOrderSuitno(peProtCruleInfoReDomain.getProtCruleInfoSuitno());
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("peClearOrderDomain", peClearOrderDomain);
        paramMap.putAll(map);
        String dicActorCode = peClearOrderDomain.getDicActorCode();
        if (StringUtils.isBlank((String)dicActorCode)) {
            dicActorCode = "";
        }
        String cruleDicActorCode = "";
        String oldcruleDicActorCode = peProtCruleInfoReDomain.getDicActorCode();
        if (StringUtils.isNotBlank((String)oldcruleDicActorCode)) {
            if (oldcruleDicActorCode.indexOf("*") > 0) {
                cruleDicActorCode = oldcruleDicActorCode.replace("*", "");
                if (dicActorCode.indexOf(cruleDicActorCode) >= 0) {
                    cruleDicActorCode = dicActorCode;
                    actorCode.put(oldcruleDicActorCode, cruleDicActorCode);
                }
            } else {
                cruleDicActorCode = oldcruleDicActorCode;
            }
        }
        String exp = peProtCruleInfoReDomain.getProtCruleExp();
        this.setpeClearOrderDomainExp(exp, peClearOrderDomain, map);
        if (ProtCruleType.SYSID.getCode().equals(type)) {
            peClearOrderDomain.setDicActorCode(cruleDicActorCode);
            peClearOrderDomain.setFaccountIdType(FaccountIdType.ACCOUNT.getCode());
            if (StringUtils.isBlank((String)peProtCruleInfoReDomain.getProtCruleIdType())) {
                this.logger.error("pe.RuleService.excuteRule.getProtCruleIdType", (Object)(peClearOrderDomain.getPaymentOrderSeqno() + ":" + peProtCruleInfoReDomain.getDicActorCode() + " is null"));
                peClearOrderDomain = null;
                return null;
            }
            if (StringUtils.isNotBlank((String)dicActorCode)) {
                PePaymentParticipant pePaymentParticipant = map.get(dicActorCode);
                if (null == pePaymentParticipant) {
                    this.logger.error("pe.RuleService.excuteRule.dicActorCode", (Object)(peClearOrderDomain.getPaymentOrderSeqno() + ":" + dicActorCode + " is null"));
                    peClearOrderDomain = null;
                    return null;
                }
                paramMap.put("pePaymentParticipant", pePaymentParticipant);
            }
            if (null == (s = peProtCruleInfoReDomain.getProtCruleIdType().split("-")) || s.length != 3) {
                this.logger.error("pe.RuleService.excuteRule.s", (Object)(peClearOrderDomain.getPaymentOrderSeqno() + ":" + peProtCruleInfoReDomain.getDicActorCode() + " is " + peProtCruleInfoReDomain.getProtCruleIdType()));
                peClearOrderDomain = null;
                return null;
            }
            peClearOrderDomain.setFchannelCode(s[0]);
            peClearOrderDomain.setFaccountId(this.getInnerFaccount(peClearOrderDomain.getTenantCode(), s[2]));
            peClearOrderDomain.setFchannelClassifyCode(s[2]);
            String am2 = (String)ScriptUtil.evel((String)peProtCruleInfoReDomain.getProtCruleInfoExp(), paramMap);
            peClearOrderDomain.setOrderAmount(new BigDecimal(Double.valueOf(am2)));
        } else if (ProtCruleType.SYSFC.getCode().equals(type)) {
            peClearOrderDomain.setDicActorCode(cruleDicActorCode);
            peClearOrderDomain.setFaccountIdType(FaccountIdType.ACCOUNT.getCode());
            if (StringUtils.isNotBlank((String)dicActorCode)) {
                PePaymentParticipant pePaymentParticipant = map.get(dicActorCode);
                if (null == pePaymentParticipant) {
                    this.logger.error("pe.RuleService.excuteRule.dicActorCode", (Object)(peClearOrderDomain.getPaymentOrderSeqno() + ":" + dicActorCode + " is null"));
                    peClearOrderDomain = null;
                    return null;
                }
                paramMap.put("pePaymentParticipant", pePaymentParticipant);
            }
            peClearOrderDomain.setFchannelCode(peProtCruleInfoReDomain.getFchannelCode());
            if (StringUtils.isNotBlank((String)peProtCruleInfoReDomain.getProtCruleIdType())) {
                s = peProtCruleInfoReDomain.getProtCruleIdType().split("-");
                if (null == s || s.length != 3) {
                    this.logger.error("pe.RuleService.excuteRule.s", (Object)(peClearOrderDomain.getPaymentOrderSeqno() + ":" + peProtCruleInfoReDomain.getDicActorCode() + " is " + peProtCruleInfoReDomain.getProtCruleIdType()));
                    peClearOrderDomain = null;
                    return null;
                }
                peClearOrderDomain.setFchannelCode(s[0]);
                peClearOrderDomain.setFaccountId(s[1]);
                peClearOrderDomain.setFchannelClassifyCode(s[2]);
            }
            am = (String)ScriptUtil.evel((String)peProtCruleInfoReDomain.getProtCruleInfoExp(), paramMap);
            peClearOrderDomain.setOrderAmount(new BigDecimal(Double.valueOf(am)));
        } else if (ProtCruleType.FACCOUNTID.getCode().equals(type)) {
            peClearOrderDomain.setDicActorCode(cruleDicActorCode);
            peClearOrderDomain.setFaccountIdType(FaccountIdType.ACCOUNT.getCode());
            PePaymentParticipant pePaymentParticipant = map.get(cruleDicActorCode);
            if (null == pePaymentParticipant) {
                this.logger.error("pe.RuleService.excuteRule.pePaymentParticipant", (Object)(peClearOrderDomain.getPaymentOrderSeqno() + ":" + peProtCruleInfoReDomain.getDicActorCode() + " is null"));
                peClearOrderDomain = null;
                return null;
            }
            paramMap.put("pePaymentParticipant", pePaymentParticipant);
            am = (String)ScriptUtil.evel((String)peProtCruleInfoReDomain.getProtCruleInfoExp(), paramMap);
            peClearOrderDomain.setOrderAmount(new BigDecimal(Double.valueOf(am)));
            peClearOrderDomain.setOpuserCode(pePaymentParticipant.getOpuserCode());
            peClearOrderDomain.setFaccountId(pePaymentParticipant.getFaccountId());
            peClearOrderDomain.setFchannelCode(pePaymentParticipant.getFchannelCode());
            peClearOrderDomain.setFaccountName(pePaymentParticipant.getFaccountName());
            peClearOrderDomain.setFaccountAname(pePaymentParticipant.getFaccountAname());
            peClearOrderDomain.setFaccountBranch(pePaymentParticipant.getFaccountBranch());
            peClearOrderDomain.setFaccountCity(pePaymentParticipant.getFaccountCity());
            peClearOrderDomain.setFaccountLocation(pePaymentParticipant.getFaccountLocation());
            peClearOrderDomain.setFaccountProvince(pePaymentParticipant.getFaccountProvince());
            if (StringUtils.isNotBlank((String)peClearOrderDomain.getFundType())) {
                peClearOrderDomain.setFundType(pePaymentParticipant.getFundType());
            }
            if (StringUtils.isNotBlank((String)peClearOrderDomain.getOrderCurrency())) {
                peClearOrderDomain.setOrderCurrency(pePaymentParticipant.getOrderCurrency());
            }
            if (StringUtils.isNotBlank((String)peProtCruleInfoReDomain.getProtCruleIdType())) {
                HashMap<String, Object> cparamMap = new HashMap<String, Object>();
                String memeber = pePaymentParticipant.getOpuserCode();
                if (StringUtils.isNotBlank((String)memeber)) {
                    cparamMap.put("memberType", memeber.subSequence(0, 1));
                }
                cparamMap.put("pePaymentParticipant", pePaymentParticipant);
                peClearOrderDomain.setFchannelClassifyCode((String)ScriptUtil.evel((String)peProtCruleInfoReDomain.getProtCruleIdType(), cparamMap));
            }
            if (StringUtils.isBlank((String)peClearOrderDomain.getFchannelClassifyCode())) {
                peClearOrderDomain.setFchannelClassifyCode(pePaymentParticipant.getFchannelClassifyCode());
            }
        } else if (!ProtCruleType.FCHANNELCID.getCode().equals(type)) {
            if (ProtCruleType.FCHANNELID.getCode().equals(type)) {
                peClearOrderDomain.setDicActorCode(cruleDicActorCode);
                PePaymentParticipant pePaymentParticipant = map.get(cruleDicActorCode);
                if (null != pePaymentParticipant) {
                    paramMap.put("pePaymentParticipant", pePaymentParticipant);
                    if (StringUtils.isBlank((String)peClearOrderDomain.getFchannelCode())) {
                        peClearOrderDomain.setFchannelCode(pePaymentParticipant.getFchannelCode());
                    }
                    peClearOrderDomain.setFaccountName(pePaymentParticipant.getFaccountName());
                    peClearOrderDomain.setFaccountAname(pePaymentParticipant.getFaccountAname());
                    peClearOrderDomain.setFaccountBranch(pePaymentParticipant.getFaccountBranch());
                    peClearOrderDomain.setFaccountCity(pePaymentParticipant.getFaccountCity());
                    peClearOrderDomain.setFaccountLocation(pePaymentParticipant.getFaccountLocation());
                    peClearOrderDomain.setFaccountProvince(pePaymentParticipant.getFaccountProvince());
                    if (StringUtils.isNotBlank((String)peClearOrderDomain.getOrderCurrency())) {
                        peClearOrderDomain.setOrderCurrency(pePaymentParticipant.getOrderCurrency());
                    }
                }
                am = (String)ScriptUtil.evel((String)peProtCruleInfoReDomain.getProtCruleInfoExp(), paramMap);
                peClearOrderDomain.setOrderAmount(new BigDecimal(Double.valueOf(am)));
                peClearOrderDomain.setFaccountIdType(FaccountIdType.ACCOUNT.getCode());
                String infokey = peClearOrderDomain.getFchannelCode() + "-" + peProtCruleInfoReDomain.getProtCruleIdType() + "-" + peClearOrderDomain.getDicPayType() + "-" + peClearOrderDomain.getDicClearCode() + "-" + peClearOrderDomain.getDicClearreqCode() + "-" + peClearOrderDomain.getTenantCode();
                String fidStr = DisUtil.getMap((String)"Fchannel_info", (String)infokey);
                if (StringUtils.isBlank((String)fidStr)) {
                    infokey = peClearOrderDomain.getFchannelCode() + "-" + peProtCruleInfoReDomain.getProtCruleIdType() + "-" + peClearOrderDomain.getDicPayType() + "-" + peClearOrderDomain.getDicClearCode() + "-" + "*-" + peClearOrderDomain.getTenantCode();
                    fidStr = DisUtil.getMap((String)"Fchannel_info", (String)infokey);
                    if (StringUtils.isBlank((String)fidStr)) {
                        infokey = peClearOrderDomain.getFchannelCode() + "-" + peProtCruleInfoReDomain.getProtCruleIdType() + "-" + peClearOrderDomain.getDicPayType() + "-" + "*-" + "*-" + peClearOrderDomain.getTenantCode();
                        fidStr = DisUtil.getMap((String)"Fchannel_info", (String)infokey);
                    }
                    if (StringUtils.isBlank((String)fidStr)) {
                        infokey = peClearOrderDomain.getFchannelCode() + "-" + peProtCruleInfoReDomain.getProtCruleIdType() + "-*-*-" + "*-" + peClearOrderDomain.getTenantCode();
                        fidStr = DisUtil.getMap((String)"Fchannel_info", (String)infokey);
                    }
                }
                if (StringUtils.isBlank((String)fidStr)) {
                    this.logger.error("pe.RuleService.excuteRule.fidStr", (Object)(peClearOrderDomain.getPaymentOrderSeqno() + ":" + infokey + " is null"));
                    peClearOrderDomain = null;
                    return null;
                }
                CmFchannelInfo cmFchannelInfo = (CmFchannelInfo)JsonUtil.buildNormalBinder().getJsonToObject(fidStr, CmFchannelInfo.class);
                if (null == cmFchannelInfo) {
                    this.logger.error("pe.RuleService.excuteRule.cmFchannelInfo", (Object)(peClearOrderDomain.getPaymentOrderSeqno() + ":" + infokey + ":" + fidStr));
                    peClearOrderDomain = null;
                    return null;
                }
                peClearOrderDomain.setFaccountId(cmFchannelInfo.getFchannelInfoTid());
                peClearOrderDomain.setFundType(cmFchannelInfo.getFundType());
                if (StringUtils.isNotBlank((String)cmFchannelInfo.getDicActorCode())) {
                    peClearOrderDomain.setDicActorCode(cmFchannelInfo.getDicActorCode());
                }
                if (StringUtils.isNotBlank((String)peProtCruleInfoReDomain.getProtCruleIdType())) {
                    peClearOrderDomain.setFchannelClassifyCode(peProtCruleInfoReDomain.getProtCruleIdType());
                }
                if (StringUtils.isBlank((String)peProtCruleInfoReDomain.getFundType())) {
                    peClearOrderDomain.setFundType(peProtCruleInfoReDomain.getFundType());
                }
                if (StringUtils.isNotBlank((String)peProtCruleInfoReDomain.getFchannelCode())) {
                    peClearOrderDomain.setFchannelCode(peProtCruleInfoReDomain.getFchannelCode());
                }
            } else if (ProtCruleType.MEMBERID.getCode().equals(type)) {
                // empty if block
            }
        }
        if (StringUtils.isNotBlank((String)peClearOrderDomain.getFchannelClassifyCode())) {
            String classfyStr = DisUtil.getMap((String)"Fchannel_classify", (String)(peClearOrderDomain.getFchannelClassifyCode() + "-" + peClearOrderDomain.getTenantCode()));
            CmFchannelClassify cmFchannelClassify = null;
            if (StringUtils.isBlank((String)classfyStr)) {
                classfyStr = DisUtil.getMap((String)"Fchannel_classify", (String)(peClearOrderDomain.getFchannelClassifyCode() + "-" + "00000000"));
            }
            if (StringUtils.isNotBlank((String)classfyStr)) {
                cmFchannelClassify = (CmFchannelClassify)JsonUtil.buildNormalBinder().getJsonToObject(classfyStr, CmFchannelClassify.class);
            }
            if (null != cmFchannelClassify) {
                if (StringUtils.isBlank((String)peClearOrderDomain.getFchannelCode())) {
                    peClearOrderDomain.setFchannelCode(cmFchannelClassify.getFchannelCode());
                }
                peClearOrderDomain.setFchannelClassifyName(cmFchannelClassify.getFchannelClassifyName());
            }
        }
        return this.excuteRuleEx(peProtCruleInfoReDomain, peClearOrderDomain, map, actorCode);
    }

    private PeClearOrderDomain excuteRuleEx(PeProtCruleInfoReDomain peProtCruleInfoReDomain, PeClearOrderDomain peClearOrderDomain, Map<String, PePaymentParticipant> map, Map<String, String> actorCode) {
        if (null == peProtCruleInfoReDomain || null == peClearOrderDomain || null == map || map.isEmpty()) {
            return peClearOrderDomain;
        }
        String type = peProtCruleInfoReDomain.getExprotCruleType();
        if (StringUtils.isBlank((String)type)) {
            return peClearOrderDomain;
        }
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("peClearOrderDomain", peClearOrderDomain);
        paramMap.putAll(map);
        String dicActorCode = peClearOrderDomain.getDicActorCode();
        if (StringUtils.isBlank((String)dicActorCode)) {
            dicActorCode = "";
        }
        String cruleDicActorCode = "";
        String oldcruleDicActorCode = peProtCruleInfoReDomain.getExdicActorCode();
        if (StringUtils.isNotBlank((String)oldcruleDicActorCode)) {
            if (oldcruleDicActorCode.indexOf("*") > 0) {
                cruleDicActorCode = oldcruleDicActorCode.replace("*", "");
                if (dicActorCode.indexOf(cruleDicActorCode) >= 0) {
                    cruleDicActorCode = dicActorCode;
                    actorCode.put(oldcruleDicActorCode, cruleDicActorCode);
                }
            } else {
                cruleDicActorCode = oldcruleDicActorCode;
            }
        }
        String exp = peProtCruleInfoReDomain.getExprotCruleExp();
        this.setpeClearOrderDomainExp(exp, peClearOrderDomain, map);
        if (ProtCruleType.SYSID.getCode().equals(type)) {
            peClearOrderDomain.setExfaccountIdType(FaccountIdType.ACCOUNT.getCode());
            if (StringUtils.isBlank((String)peProtCruleInfoReDomain.getExprotCruleIdType())) {
                this.logger.error("pe.RuleService.excuteRuleEx.getProtCruleIdType", (Object)(peClearOrderDomain.getPaymentOrderSeqno() + ":" + peProtCruleInfoReDomain.getDicActorCode() + " is null"));
                peClearOrderDomain = null;
                return null;
            }
            String[] s = peProtCruleInfoReDomain.getExprotCruleIdType().split("-");
            if (null == s || s.length != 3) {
                this.logger.error("pe.RuleService.excuteRuleEx.s", (Object)(peClearOrderDomain.getPaymentOrderSeqno() + ":" + peProtCruleInfoReDomain.getDicActorCode() + " is " + peProtCruleInfoReDomain.getProtCruleIdType()));
                peClearOrderDomain = null;
                return null;
            }
            peClearOrderDomain.setExfaccountId(this.getInnerFaccount(peClearOrderDomain.getTenantCode(), s[2]));
            PePaymentParticipant pePaymentParticipant = map.get(cruleDicActorCode);
            if (null != pePaymentParticipant) {
                peClearOrderDomain.setExfaccountId(pePaymentParticipant.getFaccountId());
                peClearOrderDomain.setExfaccountBranch(pePaymentParticipant.getFaccountBranch());
                peClearOrderDomain.setExfaccountCity(pePaymentParticipant.getFaccountCity());
                peClearOrderDomain.setExfaccountLocation(pePaymentParticipant.getFaccountLocation());
                peClearOrderDomain.setExfaccountName(pePaymentParticipant.getFaccountName());
                peClearOrderDomain.setExfaccountAname(pePaymentParticipant.getFaccountAname());
                peClearOrderDomain.setExfaccountProvince(pePaymentParticipant.getFaccountProvince());
            }
        } else if (ProtCruleType.FACCOUNTID.getCode().equals(type)) {
            peClearOrderDomain.setExfaccountIdType(FaccountIdType.ACCOUNT.getCode());
            PePaymentParticipant pePaymentParticipant = map.get(cruleDicActorCode);
            if (null == pePaymentParticipant) {
                this.logger.error("pe.RuleService.excuteRuleEx.pePaymentParticipant", (Object)(peClearOrderDomain.getPaymentOrderSeqno() + ":" + peProtCruleInfoReDomain.getDicActorCode() + " is null"));
                peClearOrderDomain = null;
                return null;
            }
            peClearOrderDomain.setExfaccountId(pePaymentParticipant.getFaccountId());
            peClearOrderDomain.setExfaccountBranch(pePaymentParticipant.getFaccountBranch());
            peClearOrderDomain.setExfaccountCity(pePaymentParticipant.getFaccountCity());
            peClearOrderDomain.setExfaccountLocation(pePaymentParticipant.getFaccountLocation());
            peClearOrderDomain.setExfaccountName(pePaymentParticipant.getFaccountName());
            peClearOrderDomain.setExfaccountAname(pePaymentParticipant.getFaccountAname());
            peClearOrderDomain.setExfaccountProvince(pePaymentParticipant.getFaccountProvince());
        } else if (!ProtCruleType.FCHANNELCID.getCode().equals(type)) {
            if (ProtCruleType.FCHANNELID.getCode().equals(type)) {
                peClearOrderDomain.setExfaccountIdType(FaccountIdType.ACCOUNT.getCode());
                PePaymentParticipant pePaymentParticipant = map.get(cruleDicActorCode);
                if (null == pePaymentParticipant) {
                    this.logger.error("pe.RuleService.excuteRuleEx.pePaymentParticipant", (Object)(peClearOrderDomain.getPaymentOrderSeqno() + ":" + peProtCruleInfoReDomain.getDicActorCode() + " is null"));
                    peClearOrderDomain = null;
                    return null;
                }
                peClearOrderDomain.setExfaccountBranch(pePaymentParticipant.getFaccountBranch());
                peClearOrderDomain.setExfaccountCity(pePaymentParticipant.getFaccountCity());
                peClearOrderDomain.setExfaccountLocation(pePaymentParticipant.getFaccountLocation());
                peClearOrderDomain.setExfaccountName(pePaymentParticipant.getFaccountName());
                peClearOrderDomain.setExfaccountAname(pePaymentParticipant.getFaccountAname());
                peClearOrderDomain.setExfaccountProvince(pePaymentParticipant.getFaccountProvince());
                String infokey = peClearOrderDomain.getFchannelCode() + "-" + peProtCruleInfoReDomain.getProtCruleIdType() + "-" + peClearOrderDomain.getDicPayType() + "-" + peClearOrderDomain.getDicClearCode() + "-" + peClearOrderDomain.getDicClearreqCode() + "-" + peClearOrderDomain.getTenantCode();
                String fidStr = DisUtil.getMap((String)"Fchannel_info", (String)infokey);
                if (StringUtils.isBlank((String)fidStr)) {
                    infokey = peClearOrderDomain.getFchannelCode() + "-" + peProtCruleInfoReDomain.getProtCruleIdType() + "-" + peClearOrderDomain.getDicPayType() + "-" + peClearOrderDomain.getDicClearCode() + "-" + "*-" + peClearOrderDomain.getTenantCode();
                    fidStr = DisUtil.getMap((String)"Fchannel_info", (String)infokey);
                    if (StringUtils.isBlank((String)fidStr)) {
                        infokey = peClearOrderDomain.getFchannelCode() + "-" + peProtCruleInfoReDomain.getProtCruleIdType() + "-" + peClearOrderDomain.getDicPayType() + "-" + "*-" + "*-" + peClearOrderDomain.getTenantCode();
                        fidStr = DisUtil.getMap((String)"Fchannel_info", (String)infokey);
                    }
                    if (StringUtils.isBlank((String)fidStr)) {
                        infokey = peClearOrderDomain.getFchannelCode() + "-" + peProtCruleInfoReDomain.getProtCruleIdType() + "-*-*-" + "*-" + peClearOrderDomain.getTenantCode();
                        fidStr = DisUtil.getMap((String)"Fchannel_info", (String)infokey);
                    }
                }
                if (StringUtils.isBlank((String)fidStr)) {
                    this.logger.error("pe.RuleService.excuteRuleEx.fidStr", (Object)(peClearOrderDomain.getPaymentOrderSeqno() + ":" + infokey + " is null"));
                    peClearOrderDomain = null;
                    return null;
                }
                CmFchannelInfo cmFchannelInfo = (CmFchannelInfo)JsonUtil.buildNormalBinder().getJsonToObject(fidStr, CmFchannelInfo.class);
                if (null == cmFchannelInfo) {
                    this.logger.error("pe.RuleService.excuteRuleEx.cmFchannelInfo", (Object)(peClearOrderDomain.getPaymentOrderSeqno() + ":" + infokey + ":" + fidStr));
                    peClearOrderDomain = null;
                    return null;
                }
                peClearOrderDomain.setExfaccountId(cmFchannelInfo.getFchannelInfoTid());
            } else if (ProtCruleType.MEMBERID.getCode().equals(type)) {
                // empty if block
            }
        }
        return peClearOrderDomain;
    }

    private void setpeClearOrderDomainExp(String exp, PeClearOrderDomain peClearOrderDomain, Map<String, PePaymentParticipant> partMap) {
        if (StringUtils.isBlank((String)exp) || null == peClearOrderDomain) {
            return;
        }
        List expBeans = (List)JsonUtil.buildNormalBinder().getJsonToList(exp, ExpBean.class);
        if (null == expBeans || expBeans.isEmpty()) {
            this.logger.error("pe.RuleService.setpeClearOrderDomainExp.exp", (Object)exp);
            return;
        }
        for (ExpBean bean : expBeans) {
            String key = bean.getKey();
            Object setValue = null;
            HashMap<String, Object> objectMap = new HashMap<String, Object>();
            objectMap.putAll(partMap);
            objectMap.put(PeClearOrderDomain.class.getSimpleName(), peClearOrderDomain);
            if (StringUtils.isBlank((String)bean.getType())) {
                bean.setType(ExpEnum.CST.getType());
            }
            if (ExpEnum.VAR.getType().equals(bean.getType())) {
                String script = (String)bean.getValue();
                if (StringUtils.isBlank((String)script)) continue;
                setValue = ScriptUtil.evel((String)script, objectMap);
            } else {
                setValue = bean.getValue();
            }
            BeanUtils.forceSetProperty((Object)peClearOrderDomain, (String)key, (Object)setValue);
        }
    }

    private Map<String, PePaymentParticipant> makeParticipantMap(List<PePaymentParticipant> participantList) {
        if (null == participantList) {
            return null;
        }
        HashMap<String, PePaymentParticipant> map = new HashMap<String, PePaymentParticipant>();
        for (PePaymentParticipant pePaymentParticipant : participantList) {
            map.put(pePaymentParticipant.getDicActorCode(), pePaymentParticipant);
        }
        return map;
    }

    private PeClearOrderDomain make(PayClearInfoQ payClearInfoQ) {
        if (null == payClearInfoQ || null == payClearInfoQ.getParticipantList() || null == payClearInfoQ.getPeProtClearinfo() || null == payClearInfoQ.getPePaymentOrderDomain()) {
            return null;
        }
        PeClearOrderDomain peClearOrderDomain = new PeClearOrderDomain();
        try {
            BeanUtils.copyAllPropertys((Object)peClearOrderDomain, (Object)payClearInfoQ.getPePaymentOrderDomain());
            BeanUtils.copyAllPropertys((Object)peClearOrderDomain, (Object)payClearInfoQ.getPePaymentDomain());
            BeanUtils.copyAllPropertys((Object)peClearOrderDomain, (Object)payClearInfoQ.getPeProtClearinfo());
            peClearOrderDomain.setOpuserCode(payClearInfoQ.getPePaymentOrderDomain().getMerchantCode());
            return peClearOrderDomain;
        }
        catch (Exception e) {
            this.logger.error("pe.RuleService.make.e", (Throwable)e);
            return null;
        }
    }

    private String getInnerFaccount(String tenantCode, String faccountType) {
        Map kmap;
        List list;
        HashMap<String, String> pmap = new HashMap<String, String>();
        pmap.put("tenantCode", tenantCode);
        pmap.put("faccountType", faccountType);
        HashMap<String, String> paramap = new HashMap<String, String>();
        paramap.put("map", JsonUtil.buildNormalBinder().toJson(pmap));
        String rs = (String)this.internalRouter.inInvoke("vd.faccountInner.queryFaccountInnerPage", paramap);
        if (StringUtils.isBlank((String)rs)) {
            this.logger.error("pe.RuleService.getInnerFaccount", (Object)"\u67e5\u8be2\u4e3a\u7a7a");
        }
        if ((list = (List)(kmap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(rs, String.class, Object.class)).get("rows")) == null || list.isEmpty()) {
            this.logger.error("pe.RuleService.getInnerFaccount", (Object)("\u672a\u67e5\u8be2\u5230\u8d26\u53f7\u4fe1\u606f\u3010tenantCode\u3011\uff1a" + tenantCode + "\u3010faccountType\u3011:" + faccountType));
        }
        Map mp = (Map)list.get(0);
        return (String)mp.get("faccountInnerNo");
    }
}

