/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.payengine.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.payengine.dao.PeCflowPprocessMapper;
import com.yqbsoft.laser.service.payengine.dao.PeClearOrderMapper;
import com.yqbsoft.laser.service.payengine.dao.PeClearRespMapper;
import com.yqbsoft.laser.service.payengine.dao.PePaymentMapper;
import com.yqbsoft.laser.service.payengine.dao.PePaymentOrderMapper;
import com.yqbsoft.laser.service.payengine.dao.PePaymentParticipantMapper;
import com.yqbsoft.laser.service.payengine.dao.PePaymentReorderMapper;
import com.yqbsoft.laser.service.payengine.dao.PeProtClearinfoMapper;
import com.yqbsoft.laser.service.payengine.domain.CallbackResult;
import com.yqbsoft.laser.service.payengine.domain.PayengineForm;
import com.yqbsoft.laser.service.payengine.domain.PePaymentDomain;
import com.yqbsoft.laser.service.payengine.domain.PePaymentOrderDomain;
import com.yqbsoft.laser.service.payengine.domain.PePaymentParticipantDomain;
import com.yqbsoft.laser.service.payengine.domain.PePaymentReorderDomain;
import com.yqbsoft.laser.service.payengine.domain.PeReorderDomain;
import com.yqbsoft.laser.service.payengine.enumc.PaymentType;
import com.yqbsoft.laser.service.payengine.model.PeClearOrder;
import com.yqbsoft.laser.service.payengine.model.PeClearResp;
import com.yqbsoft.laser.service.payengine.model.PePayment;
import com.yqbsoft.laser.service.payengine.model.PePaymentOrder;
import com.yqbsoft.laser.service.payengine.model.PePaymentParticipant;
import com.yqbsoft.laser.service.payengine.model.PePaymentReorder;
import com.yqbsoft.laser.service.payengine.service.PePaymentService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jsoup.helper.StringUtil;

public class PePaymentServiceImpl
extends BaseServiceImpl
implements PePaymentService {
    public static final String SYS_CODE = "pe.PePaymentServiceImpl";
    private PePaymentMapper pePaymentMapper;
    private PePaymentOrderMapper pePaymentOrderMapper;
    private PePaymentParticipantMapper pePaymentParticipantMapper;
    private PePaymentReorderMapper pePaymentReorderMapper;
    private PeProtClearinfoMapper peProtClearinfoMapper;
    private PeClearOrderMapper peClearOrderMapper;
    private PeClearRespMapper peClearRespMapper;
    private PeCflowPprocessMapper peCflowPprocessMapper;

    public void setPePaymentMapper(PePaymentMapper pePaymentMapper) {
        this.pePaymentMapper = pePaymentMapper;
    }

    public void setPePaymentOrderMapper(PePaymentOrderMapper pePaymentOrderMapper) {
        this.pePaymentOrderMapper = pePaymentOrderMapper;
    }

    public void setPePaymentParticipantMapper(PePaymentParticipantMapper pePaymentParticipantMapper) {
        this.pePaymentParticipantMapper = pePaymentParticipantMapper;
    }

    public void setPePaymentReorderMapper(PePaymentReorderMapper pePaymentReorderMapper) {
        this.pePaymentReorderMapper = pePaymentReorderMapper;
    }

    public void setPeProtClearinfoMapper(PeProtClearinfoMapper peProtClearinfoMapper) {
        this.peProtClearinfoMapper = peProtClearinfoMapper;
    }

    public void setPeClearOrderMapper(PeClearOrderMapper peClearOrderMapper) {
        this.peClearOrderMapper = peClearOrderMapper;
    }

    public void setPeClearRespMapper(PeClearRespMapper peClearRespMapper) {
        this.peClearRespMapper = peClearRespMapper;
    }

    public void setPeCflowPprocessMapper(PeCflowPprocessMapper peCflowPprocessMapper) {
        this.peCflowPprocessMapper = peCflowPprocessMapper;
    }

    private Date getSysDate() {
        try {
            return this.pePaymentMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("pe.PePaymentServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkPayment(PePaymentDomain pePaymentDomain) {
        if (null == pePaymentDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)pePaymentDomain.getPartnerCode())) {
            msg = msg + "PartnerCode\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)pePaymentDomain.getFchannelPmodeCode())) {
            msg = msg + "FchannelPmodeCode\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)pePaymentDomain.getPaymentType())) {
            msg = msg + "PaymentType\u4e3a\u7a7a;";
        }
        if (null == pePaymentDomain.getOrderDomainList() || pePaymentDomain.getOrderDomainList().isEmpty()) {
            msg = msg + "\u652f\u4ed8\u6307\u4ee4\u4e3a\u7a7a;";
        }
        if (PaymentType.AB.getCode().equals(pePaymentDomain.getPaymentType()) && StringUtils.isBlank((String)pePaymentDomain.getPaymentOldseqno())) {
            msg = msg + "PaymentOldseqno\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setPaymentDefault(PePayment pePayment) {
        if (null == pePayment) {
            return;
        }
        if (null == pePayment.getDataState()) {
            pePayment.setDataState(0);
        }
        if (null == pePayment.getGmtCreate()) {
            pePayment.setGmtCreate(this.getSysDate());
        }
        pePayment.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)pePayment.getPaymentSeqno())) {
            pePayment.setPaymentSeqno(this.createUUIDString());
        }
    }

    private int getMaxCode() {
        int code = 0;
        try {
            return this.pePaymentMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("pe.PePaymentServiceImpl.getMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setPaymentUpdataDefault(PePayment pePayment) {
        if (null == pePayment) {
            return;
        }
        pePayment.setGmtModified(this.getSysDate());
    }

    private void savePaymentModel(PePayment pePayment) throws ApiException {
        if (null == pePayment) {
            return;
        }
        try {
            this.pePaymentMapper.insert(pePayment);
        }
        catch (Exception e) {
            throw new ApiException("pe.PePaymentServiceImpl.savePaymentModel.ex", (Throwable)e);
        }
    }

    private PePayment getPaymentModelById(Integer paymentId) {
        if (null == paymentId) {
            return null;
        }
        try {
            return this.pePaymentMapper.selectByPrimaryKey(paymentId);
        }
        catch (Exception e) {
            this.logger.error("pe.PePaymentServiceImpl.getPaymentModelById", (Throwable)e);
            return null;
        }
    }

    public PePayment getPaymentModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.pePaymentMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("pe.PePaymentServiceImpl.getPaymentModelByCode", (Throwable)e);
            return null;
        }
    }

    public void delPaymentModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.pePaymentMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pe.PePaymentServiceImpl.delPaymentModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pe.PePaymentServiceImpl.delPaymentModelByCode.num");
        }
    }

    private void deletePaymentModel(Integer paymentId) throws ApiException {
        if (null == paymentId) {
            return;
        }
        int i = 0;
        try {
            i = this.pePaymentMapper.deleteByPrimaryKey(paymentId);
        }
        catch (Exception e) {
            throw new ApiException("pe.PePaymentServiceImpl.deletePaymentModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pe.PePaymentServiceImpl.deletePaymentModel.num");
        }
    }

    private void updatePaymentModel(PePayment pePayment) throws ApiException {
        if (null == pePayment) {
            return;
        }
        try {
            this.pePaymentMapper.updateByPrimaryKeySelective(pePayment);
        }
        catch (Exception e) {
            throw new ApiException("pe.PePaymentServiceImpl.updatePaymentModel.ex", (Throwable)e);
        }
    }

    private void updateStatePaymentModel(Integer paymentId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == paymentId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("paymentId", paymentId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.pePaymentMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("pe.PePaymentServiceImpl.updateStatePaymentModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pe.PePaymentServiceImpl.updateStatePaymentModel.null", ((Object)map).toString());
        }
    }

    private void updateStatePaymentModelByCode(String paymentSeqno, String fchannelCode, String orderBankseq, Integer dataState, String tenantCode) throws ApiException {
        if (StringUtils.isBlank((String)paymentSeqno) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("paymentSeqno", paymentSeqno);
        map.put("fchannelCode", fchannelCode);
        map.put("orderBankseq", orderBankseq);
        map.put("dataState", dataState);
        map.put("tenantCode", tenantCode);
        int i = 0;
        try {
            i = this.pePaymentMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pe.PePaymentServiceImpl.updateStatePaymentModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pe.PePaymentServiceImpl.updateStatePaymentModelByCode.null", ((Object)map).toString());
        }
    }

    private void updateModelProcessByCode(String paymentOrderSeqno, String cflowNodeCode, String tenantCode, String cflowPprocessCode) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("paymentOrderSeqno", paymentOrderSeqno);
        map.put("cflowNodeCode", cflowNodeCode);
        map.put("tenantCode", tenantCode);
        map.put("cflowPprocessCode", cflowPprocessCode);
        int i = 0;
        try {
            i = this.pePaymentOrderMapper.updateProcessByCode(map);
        }
        catch (Exception e) {
            this.logger.error("pe.PePaymentServiceImpl.updateModelProcessByCode", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pe.PePaymentServiceImpl.updateModelProcessByCode.null");
        }
    }

    private void updateModelFchannelByCode(String fchannelCode, String orderBankseq, String paymentSeqno, String tenantCode) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("fchannelCode", fchannelCode);
        map.put("orderBankseq", orderBankseq);
        map.put("paymentSeqno", paymentSeqno);
        map.put("tenantCode", tenantCode);
        int i = 0;
        try {
            i = this.pePaymentMapper.updateFchannelByCode(map);
        }
        catch (Exception e) {
            this.logger.error("pe.PePaymentServiceImpl.updateModelFchannelByCode", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pe.PePaymentServiceImpl.updateModelFchannelByCode.null");
        }
    }

    private PePayment makePayment(PePaymentDomain pePaymentDomain, PePayment pePayment) {
        if (null == pePaymentDomain) {
            return null;
        }
        if (null == pePayment) {
            pePayment = new PePayment();
        }
        try {
            BeanUtils.copyAllPropertys((Object)pePayment, (Object)pePaymentDomain);
            return pePayment;
        }
        catch (Exception e) {
            this.logger.error("pe.PePaymentServiceImpl.makePayment", (Throwable)e);
            return null;
        }
    }

    private PePaymentDomain makePaymentDomain(PePayment pePayment) {
        if (null == pePayment) {
            return null;
        }
        PePaymentDomain pePaymentDomain = new PePaymentDomain();
        try {
            BeanUtils.copyAllPropertys((Object)pePaymentDomain, (Object)pePayment);
            return pePaymentDomain;
        }
        catch (Exception e) {
            this.logger.error("pe.PePaymentServiceImpl.makePaymentDomain", (Throwable)e);
            return null;
        }
    }

    private List<PePayment> queryPaymentModelPage(Map<String, Object> parammap) {
        try {
            return this.pePaymentMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("pe.PePaymentServiceImpl.queryPaymentModel", (Throwable)e);
            return null;
        }
    }

    private int countPayment(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.pePaymentMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("pe.PePaymentServiceImpl.countPayment", (Throwable)e);
        }
        return i;
    }

    private String checkPaymentOrder(PePaymentOrderDomain pePaymentOrderDomain) {
        if (null == pePaymentOrderDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        return msg;
    }

    private void setPaymentOrderDefault(PePaymentOrder pePaymentOrder) {
        if (null == pePaymentOrder) {
            return;
        }
        if (null == pePaymentOrder.getDataState()) {
            pePaymentOrder.setDataState(0);
        }
        if (null == pePaymentOrder.getGmtCreate()) {
            pePaymentOrder.setGmtCreate(this.getSysDate());
        }
        pePaymentOrder.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)pePaymentOrder.getPaymentOrderSeqno())) {
            pePaymentOrder.setPaymentOrderSeqno(this.createUUIDString());
        }
    }

    private int getPaymentOrderMaxCode() {
        int code = 0;
        try {
            return this.pePaymentOrderMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("pe.PePaymentServiceImpl.getPaymentOrderMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setPaymentOrderUpdataDefault(PePaymentOrder pePaymentOrder) {
        if (null == pePaymentOrder) {
            return;
        }
        pePaymentOrder.setGmtModified(this.getSysDate());
    }

    private void savePaymentOrderModel(PePaymentOrder pePaymentOrder) throws ApiException {
        if (null == pePaymentOrder) {
            return;
        }
        try {
            this.pePaymentOrderMapper.insert(pePaymentOrder);
        }
        catch (Exception e) {
            throw new ApiException("pe.PePaymentServiceImpl.savePaymentOrderModel.ex", (Throwable)e);
        }
    }

    private void saveBatchPaymentOrderModel(List<PePaymentOrder> pePaymentOrderList) throws ApiException {
        if (null == pePaymentOrderList || pePaymentOrderList.isEmpty()) {
            return;
        }
        try {
            this.pePaymentOrderMapper.insertBatch(pePaymentOrderList);
        }
        catch (Exception e) {
            throw new ApiException("pe.PePaymentServiceImpl.saveBatchPaymentOrderModel.ex", (Throwable)e);
        }
    }

    private PePaymentOrder getPaymentOrderModelById(Integer paymentOrderId) {
        if (null == paymentOrderId) {
            return null;
        }
        try {
            return this.pePaymentOrderMapper.selectByPrimaryKey(paymentOrderId);
        }
        catch (Exception e) {
            this.logger.error("pe.PePaymentServiceImpl.getPaymentOrderModelById", (Throwable)e);
            return null;
        }
    }

    public PePaymentOrder getPaymentOrderModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.pePaymentOrderMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("pe.PePaymentServiceImpl.getPaymentOrderModelByCode", (Throwable)e);
            return null;
        }
    }

    public void delPaymentOrderModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.pePaymentOrderMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pe.PePaymentServiceImpl.delPaymentOrderModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pe.PePaymentServiceImpl.delPaymentOrderModelByCode.num");
        }
    }

    private void deletePaymentOrderModel(Integer paymentOrderId) throws ApiException {
        if (null == paymentOrderId) {
            return;
        }
        int i = 0;
        try {
            i = this.pePaymentOrderMapper.deleteByPrimaryKey(paymentOrderId);
        }
        catch (Exception e) {
            throw new ApiException("pe.PePaymentServiceImpl.deletePaymentOrderModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pe.PePaymentServiceImpl.deletePaymentOrderModel.num");
        }
    }

    private void updatePaymentOrderModel(PePaymentOrder pePaymentOrder) throws ApiException {
        if (null == pePaymentOrder) {
            return;
        }
        try {
            this.pePaymentOrderMapper.updateByPrimaryKeySelective(pePaymentOrder);
        }
        catch (Exception e) {
            throw new ApiException("pe.PePaymentServiceImpl.updatePaymentOrderModel.ex", (Throwable)e);
        }
    }

    private void updateStatePaymentOrderModel(Integer paymentOrderId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == paymentOrderId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("paymentOrderId", paymentOrderId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.pePaymentOrderMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("pe.PePaymentServiceImpl.updateStatePaymentOrderModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pe.PePaymentServiceImpl.updateStatePaymentOrderModel.null");
        }
    }

    private PePaymentOrder makePaymentOrder(PePaymentOrderDomain pePaymentOrderDomain, PePaymentOrder pePaymentOrder) {
        if (null == pePaymentOrderDomain) {
            return null;
        }
        if (null == pePaymentOrder) {
            pePaymentOrder = new PePaymentOrder();
        }
        try {
            BeanUtils.copyAllPropertys((Object)pePaymentOrder, (Object)pePaymentOrderDomain);
            return pePaymentOrder;
        }
        catch (Exception e) {
            this.logger.error("pe.PePaymentServiceImpl.makePaymentOrder", (Throwable)e);
            return null;
        }
    }

    private PePaymentOrderDomain makePaymentOrderDomain(PePaymentOrder pePaymentOrder) {
        if (null == pePaymentOrder) {
            return null;
        }
        PePaymentOrderDomain pePaymentOrderDomain = new PePaymentOrderDomain();
        try {
            BeanUtils.copyAllPropertys((Object)pePaymentOrderDomain, (Object)pePaymentOrder);
            return pePaymentOrderDomain;
        }
        catch (Exception e) {
            this.logger.error("pe.PePaymentServiceImpl.makePaymentOrderDomain", (Throwable)e);
            return null;
        }
    }

    private List<PePaymentOrder> queryPaymentOrderModelPage(Map<String, Object> parammap) {
        try {
            return this.pePaymentOrderMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("pe.PePaymentServiceImpl.queryPaymentOrderModel", (Throwable)e);
            return null;
        }
    }

    private int countPaymentOrder(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.pePaymentOrderMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("pe.PePaymentServiceImpl.countPaymentOrder", (Throwable)e);
        }
        return i;
    }

    private String checkPaymentParticipant(PePaymentParticipantDomain pePaymentParticipantDomain) {
        if (null == pePaymentParticipantDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        return msg;
    }

    private void setPaymentParticipantDefault(PePaymentParticipant pePaymentParticipant) {
        if (null == pePaymentParticipant) {
            return;
        }
        if (null == pePaymentParticipant.getDataState()) {
            pePaymentParticipant.setDataState(0);
        }
        if (null == pePaymentParticipant.getGmtCreate()) {
            pePaymentParticipant.setGmtCreate(this.getSysDate());
        }
        pePaymentParticipant.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)pePaymentParticipant.getPaymentParticipantCode())) {
            pePaymentParticipant.setPaymentParticipantCode(this.createUUIDString());
        }
    }

    private int getPaymentParticipantMaxCode() {
        int code = 0;
        try {
            return this.pePaymentParticipantMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("pe.PePaymentServiceImpl.getPaymentParticipantMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setPaymentParticipantUpdataDefault(PePaymentParticipant pePaymentParticipant) {
        if (null == pePaymentParticipant) {
            return;
        }
        pePaymentParticipant.setGmtModified(this.getSysDate());
    }

    private void savePaymentParticipantModel(PePaymentParticipant pePaymentParticipant) throws ApiException {
        if (null == pePaymentParticipant) {
            return;
        }
        try {
            this.pePaymentParticipantMapper.insert(pePaymentParticipant);
        }
        catch (Exception e) {
            throw new ApiException("pe.PePaymentServiceImpl.savePaymentParticipantModel.ex", (Throwable)e);
        }
    }

    private void saveBatchPaymentParticipantModel(List<PePaymentParticipant> pePaymentParticipantList) throws ApiException {
        if (null == pePaymentParticipantList || pePaymentParticipantList.isEmpty()) {
            return;
        }
        try {
            this.pePaymentParticipantMapper.insertBatch(pePaymentParticipantList);
        }
        catch (Exception e) {
            throw new ApiException("pe.PePaymentServiceImpl.saveBatchPaymentParticipantModel.ex", (Throwable)e);
        }
    }

    private PePaymentParticipant getPaymentParticipantModelById(Integer paymentParticipantId) {
        if (null == paymentParticipantId) {
            return null;
        }
        try {
            return this.pePaymentParticipantMapper.selectByPrimaryKey(paymentParticipantId);
        }
        catch (Exception e) {
            this.logger.error("pe.PePaymentServiceImpl.getPaymentParticipantModelById", (Throwable)e);
            return null;
        }
    }

    public PePaymentParticipant getPaymentParticipantModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.pePaymentParticipantMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("pe.PePaymentServiceImpl.getPaymentParticipantModelByCode", (Throwable)e);
            return null;
        }
    }

    public void delPaymentParticipantModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.pePaymentParticipantMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pe.PePaymentServiceImpl.delPaymentParticipantModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pe.PePaymentServiceImpl.delPaymentParticipantModelByCode.num");
        }
    }

    private void deletePaymentParticipantModel(Integer paymentParticipantId) throws ApiException {
        if (null == paymentParticipantId) {
            return;
        }
        int i = 0;
        try {
            i = this.pePaymentParticipantMapper.deleteByPrimaryKey(paymentParticipantId);
        }
        catch (Exception e) {
            throw new ApiException("pe.PePaymentServiceImpl.deletePaymentParticipantModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pe.PePaymentServiceImpl.deletePaymentParticipantModel.num");
        }
    }

    private void updatePaymentParticipantModel(PePaymentParticipant pePaymentParticipant) throws ApiException {
        if (null == pePaymentParticipant) {
            return;
        }
        try {
            this.pePaymentParticipantMapper.updateByPrimaryKeySelective(pePaymentParticipant);
        }
        catch (Exception e) {
            throw new ApiException("pe.PePaymentServiceImpl.updatePaymentParticipantModel.ex", (Throwable)e);
        }
    }

    private void updateStatePaymentParticipantModel(Integer paymentParticipantId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == paymentParticipantId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("paymentParticipantId", paymentParticipantId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.pePaymentParticipantMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("pe.PePaymentServiceImpl.updateStatePaymentParticipantModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pe.PePaymentServiceImpl.updateStatePaymentParticipantModel.null");
        }
    }

    private PePaymentParticipant makePaymentParticipant(PePaymentParticipantDomain pePaymentParticipantDomain, PePaymentParticipant pePaymentParticipant) {
        if (null == pePaymentParticipantDomain) {
            return null;
        }
        if (null == pePaymentParticipant) {
            pePaymentParticipant = new PePaymentParticipant();
        }
        try {
            BeanUtils.copyAllPropertys((Object)pePaymentParticipant, (Object)pePaymentParticipantDomain);
            return pePaymentParticipant;
        }
        catch (Exception e) {
            this.logger.error("pe.PePaymentServiceImpl.makePaymentParticipant", (Throwable)e);
            return null;
        }
    }

    private List<PePaymentParticipant> queryPaymentParticipantModelPage(Map<String, Object> parammap) {
        try {
            return this.pePaymentParticipantMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("pe.PePaymentServiceImpl.queryPaymentParticipantModel", (Throwable)e);
            return null;
        }
    }

    private int countPaymentParticipant(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.pePaymentParticipantMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("pe.PePaymentServiceImpl.countPaymentParticipant", (Throwable)e);
        }
        return i;
    }

    private String checkPaymentReorder(PePaymentReorderDomain pePaymentReorderDomain) {
        if (null == pePaymentReorderDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        return msg;
    }

    private void setPaymentReorderDefault(PePaymentReorder pePaymentReorder) {
        if (null == pePaymentReorder) {
            return;
        }
        if (null == pePaymentReorder.getDataState()) {
            pePaymentReorder.setDataState(0);
        }
        if (null == pePaymentReorder.getGmtCreate()) {
            pePaymentReorder.setGmtCreate(this.getSysDate());
        }
        if (null == pePaymentReorder.getPaymentReorderState()) {
            pePaymentReorder.setPaymentReorderState(0);
        }
        pePaymentReorder.setGmtModified(this.getSysDate());
        if (StringUtil.isBlank((String)pePaymentReorder.getPaymentReorderCode())) {
            pePaymentReorder.setPaymentReorderCode(this.createUUIDString());
        }
    }

    private int getPaymentReorderMaxCode() {
        int code = 0;
        try {
            return this.pePaymentReorderMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("pe.PePaymentServiceImpl.getPaymentReorderMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setPaymentReorderUpdataDefault(PePaymentReorder pePaymentReorder) {
        if (null == pePaymentReorder) {
            return;
        }
        pePaymentReorder.setGmtModified(this.getSysDate());
    }

    private void savePaymentReorderModel(PePaymentReorder pePaymentReorder) throws ApiException {
        if (null == pePaymentReorder) {
            return;
        }
        try {
            this.pePaymentReorderMapper.insert(pePaymentReorder);
        }
        catch (Exception e) {
            throw new ApiException("pe.PePaymentServiceImpl.savePaymentReorderModel.ex", (Throwable)e);
        }
    }

    private void savePaymentReorderBatchModel(List<PePaymentReorder> pePaymentReorderList) throws ApiException {
        if (null == pePaymentReorderList || pePaymentReorderList.isEmpty()) {
            return;
        }
        try {
            this.pePaymentReorderMapper.insertBatch(pePaymentReorderList);
        }
        catch (Exception e) {
            throw new ApiException("pe.PePaymentServiceImpl.savePaymentReorderModel.ex", (Throwable)e);
        }
    }

    private PePaymentReorder getPaymentReorderModelById(Integer paymentReorderId) {
        if (null == paymentReorderId) {
            return null;
        }
        try {
            return this.pePaymentReorderMapper.selectByPrimaryKey(paymentReorderId);
        }
        catch (Exception e) {
            this.logger.error("pe.PePaymentServiceImpl.getPaymentReorderModelById", (Throwable)e);
            return null;
        }
    }

    public PePaymentReorder getPaymentReorderModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.pePaymentReorderMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("pe.PePaymentServiceImpl.getPaymentReorderModelByCode", (Throwable)e);
            return null;
        }
    }

    public void delPaymentReorderModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.pePaymentReorderMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pe.PePaymentServiceImpl.delPaymentReorderModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pe.PePaymentServiceImpl.delPaymentReorderModelByCode.num");
        }
    }

    private void deletePaymentReorderModel(Integer paymentReorderId) throws ApiException {
        if (null == paymentReorderId) {
            return;
        }
        int i = 0;
        try {
            i = this.pePaymentReorderMapper.deleteByPrimaryKey(paymentReorderId);
        }
        catch (Exception e) {
            throw new ApiException("pe.PePaymentServiceImpl.deletePaymentReorderModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pe.PePaymentServiceImpl.deletePaymentReorderModel.num");
        }
    }

    private void updatePaymentReorderModel(PePaymentReorder pePaymentReorder) throws ApiException {
        if (null == pePaymentReorder) {
            return;
        }
        try {
            this.pePaymentReorderMapper.updateByPrimaryKeySelective(pePaymentReorder);
        }
        catch (Exception e) {
            throw new ApiException("pe.PePaymentServiceImpl.updatePaymentReorderModel.ex", (Throwable)e);
        }
    }

    private void updateStatePaymentReorderModel(Integer paymentReorderId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == paymentReorderId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("paymentReorderId", paymentReorderId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.pePaymentReorderMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("pe.PePaymentServiceImpl.updateStatePaymentReorderModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pe.PePaymentServiceImpl.updateStatePaymentReorderModel.null");
        }
    }

    private PePaymentReorder makePaymentReorder(PePaymentReorderDomain pePaymentReorderDomain, PePaymentReorder pePaymentReorder) {
        if (null == pePaymentReorderDomain) {
            return null;
        }
        if (null == pePaymentReorder) {
            pePaymentReorder = new PePaymentReorder();
        }
        try {
            BeanUtils.copyAllPropertys((Object)pePaymentReorder, (Object)pePaymentReorderDomain);
            return pePaymentReorder;
        }
        catch (Exception e) {
            this.logger.error("pe.PePaymentServiceImpl.makePaymentReorder", (Throwable)e);
            return null;
        }
    }

    private PePaymentReorder makePaymentReorder(PeReorderDomain peReorderDomain, PePaymentReorder pePaymentReorder) {
        if (null == peReorderDomain) {
            return null;
        }
        if (null == pePaymentReorder) {
            pePaymentReorder = new PePaymentReorder();
        }
        try {
            BeanUtils.copyAllPropertys((Object)pePaymentReorder, (Object)peReorderDomain);
            return pePaymentReorder;
        }
        catch (Exception e) {
            this.logger.error("pe.PePaymentServiceImpl.makePaymentReorder", (Throwable)e);
            return null;
        }
    }

    private List<PePaymentReorder> queryPaymentReorderModelPage(Map<String, Object> parammap) {
        try {
            return this.pePaymentReorderMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("pe.PePaymentServiceImpl.queryPaymentReorderModel", (Throwable)e);
            return null;
        }
    }

    private int countPaymentReorder(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.pePaymentReorderMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("pe.PePaymentServiceImpl.countPaymentReorder", (Throwable)e);
        }
        return i;
    }

    @Override
    public PePayment savePayment(PePaymentDomain pePaymentDomain) throws ApiException {
        return this.savePaymentBatch(pePaymentDomain);
    }

    private PePayment savePaymentBatch(PePaymentDomain pePaymentDomain) {
        String msg = this.checkPayment(pePaymentDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pe.PePaymentServiceImpl.savePayment.checkPayment", msg);
        }
        PePayment pePayment = this.makePayment(pePaymentDomain, null);
        this.setPaymentDefault(pePayment);
        this.savePaymentModel(pePayment);
        pePaymentDomain.setPaymentId(pePayment.getPaymentId());
        pePaymentDomain.setPaymentSeqno(pePayment.getPaymentSeqno());
        this.saveList(pePaymentDomain);
        return pePayment;
    }

    private PePaymentDomain saveList(PePaymentDomain pePaymentDomain) {
        if (null == pePaymentDomain) {
            throw new ApiException("pe.PePaymentServiceImpl.saveList.null", "null");
        }
        List<PePaymentOrderDomain> orderDomainList = pePaymentDomain.getOrderDomainList();
        if (null == orderDomainList || orderDomainList.isEmpty()) {
            throw new ApiException("pe.PePaymentServiceImpl.saveList.null", "null");
        }
        ArrayList<PePaymentOrder> pePaymentOrderList = new ArrayList<PePaymentOrder>();
        ArrayList<PePaymentParticipant> pePaymentParticipantList = new ArrayList<PePaymentParticipant>();
        for (PePaymentOrderDomain pePaymentOrderDomain : orderDomainList) {
            pePaymentOrderDomain.setPaymentSeqno(pePaymentDomain.getPaymentSeqno());
            pePaymentOrderDomain.setTenantCode(pePaymentDomain.getTenantCode());
            PePaymentOrder pePaymentOrder = this.createPaymentOrder(pePaymentOrderDomain);
            pePaymentOrderDomain.setPaymentOrderSeqno(pePaymentOrder.getPaymentOrderSeqno());
            pePaymentOrderList.add(pePaymentOrder);
            List<PePaymentParticipantDomain> participantDomainList = pePaymentOrderDomain.getParticipantDomainList();
            if (null == participantDomainList || participantDomainList.isEmpty()) {
                throw new ApiException("pe.PePaymentServiceImpl.saveList.participantDomainList", "null");
            }
            for (PePaymentParticipantDomain pePaymentParticipantDomain : participantDomainList) {
                pePaymentParticipantDomain.setPaymentSeqno(pePaymentDomain.getPaymentSeqno());
                pePaymentParticipantDomain.setTenantCode(pePaymentDomain.getTenantCode());
                pePaymentParticipantDomain.setPaymentOrderSeqno(pePaymentOrder.getPaymentOrderSeqno());
                pePaymentParticipantList.add(this.createPaymentParticipant(pePaymentParticipantDomain));
            }
        }
        this.saveBatchPaymentOrderModel(pePaymentOrderList);
        this.saveBatchPaymentParticipantModel(pePaymentParticipantList);
        return pePaymentDomain;
    }

    private void setParticipantDomain(PePaymentOrderDomain pePaymentOrderDomain, List<PePaymentParticipant> pePaymentParticipantList) {
        if (null == pePaymentOrderDomain || null == pePaymentParticipantList || pePaymentParticipantList.isEmpty()) {
            throw new ApiException("pe.PePaymentServiceImpl.setParticipantDomain.null", "null");
        }
        ArrayList<PePaymentParticipantDomain> participantDomainList = new ArrayList<PePaymentParticipantDomain>();
        for (PePaymentParticipant pePaymentParticipant : pePaymentParticipantList) {
            participantDomainList.add(this.makeParticipant(pePaymentParticipant));
        }
        pePaymentOrderDomain.setParticipantDomainList(participantDomainList);
    }

    private PePaymentParticipantDomain makeParticipant(PePaymentParticipant pePaymentParticipant) {
        if (null == pePaymentParticipant) {
            return null;
        }
        PePaymentParticipantDomain pePaymentParticipantDomain = new PePaymentParticipantDomain();
        try {
            BeanUtils.copyAllPropertys((Object)pePaymentParticipantDomain, (Object)pePaymentParticipant);
            return pePaymentParticipantDomain;
        }
        catch (Exception e) {
            this.logger.error("pe.PePaymentServiceImpl.makeParticipant", (Throwable)e);
            return null;
        }
    }

    private void setOrderDomain(PePaymentDomain pePaymentDomain, List<PePaymentOrder> pePaymentOrderList) {
        if (null == pePaymentDomain || null == pePaymentOrderList || pePaymentOrderList.isEmpty()) {
            throw new ApiException("pe.PePaymentServiceImpl.setOrderDomain.null", "null");
        }
        ArrayList<PePaymentOrderDomain> orderDomainList = new ArrayList<PePaymentOrderDomain>();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("paymentSeqno", pePaymentDomain.getPaymentSeqno());
        map.put("tenantCode", pePaymentDomain.getTenantCode());
        for (PePaymentOrder pePaymentOrder : pePaymentOrderList) {
            map.put("paymentOrderSeqno", pePaymentOrder.getPaymentOrderSeqno());
            List<PePaymentParticipant> pePaymentParticipantList = this.queryPaymentParticipantModelPage(map);
            PePaymentOrderDomain pePaymentOrderDomain = this.makeOrder(pePaymentOrder);
            this.setParticipantDomain(pePaymentOrderDomain, pePaymentParticipantList);
            orderDomainList.add(pePaymentOrderDomain);
        }
        pePaymentDomain.setOrderDomainList(orderDomainList);
    }

    private PePaymentOrderDomain makeOrder(PePaymentOrder pePaymentOrder) {
        if (null == pePaymentOrder) {
            return null;
        }
        PePaymentOrderDomain pePaymentOrderDomain = new PePaymentOrderDomain();
        try {
            BeanUtils.copyAllPropertys((Object)pePaymentOrderDomain, (Object)pePaymentOrder);
            return pePaymentOrderDomain;
        }
        catch (Exception e) {
            this.logger.error("pe.PePaymentServiceImpl.makeOrder", (Throwable)e);
            return null;
        }
    }

    @Override
    public void updatePaymentState(Integer paymentId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStatePaymentModel(paymentId, dataState, oldDataState);
    }

    @Override
    public void updatePayment(PePaymentDomain pePaymentDomain) throws ApiException {
        String msg = this.checkPayment(pePaymentDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pe.PePaymentServiceImpl.updatePayment.checkPayment", msg);
        }
        PePayment oldPePayment = this.getPaymentModelById(pePaymentDomain.getPaymentId());
        if (null == oldPePayment) {
            throw new ApiException("pe.PePaymentServiceImpl.updatePayment.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        PePayment pePayment = this.makePayment(pePaymentDomain, oldPePayment);
        this.setPaymentUpdataDefault(pePayment);
        this.updatePaymentModel(pePayment);
    }

    @Override
    public PePayment getPayment(Integer paymentId) {
        return this.getPaymentModelById(paymentId);
    }

    @Override
    public PePaymentDomain getPaymentByCode(String paymentSeqno, String tenantCode) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("paymentSeqno", paymentSeqno);
        map.put("tenantCode", tenantCode);
        PePayment pePayment = this.getPaymentModelByCode(map);
        PePaymentDomain pePaymentDomain = this.makePaymentDomain(pePayment);
        if (null == pePaymentDomain) {
            return null;
        }
        List<PePaymentOrder> pePaymentOrderList = this.queryPaymentOrderModelPage(map);
        this.setOrderDomain(pePaymentDomain, pePaymentOrderList);
        return pePaymentDomain;
    }

    @Override
    public void updateProcessByCode(String cflowPprocessCode, String cflowNodeCode, String paymentOrderSeqno, String tenantCode) {
        this.updateModelProcessByCode(paymentOrderSeqno, cflowNodeCode, tenantCode, cflowPprocessCode);
    }

    @Override
    public void updatePaymentFchannelByCode(String fchannelCode, String orderBankseq, String paymentSeqno, String tenantCode) {
        this.updateModelFchannelByCode(fchannelCode, orderBankseq, paymentSeqno, tenantCode);
    }

    @Override
    public void deletePayment(Integer paymentId) throws ApiException {
        this.deletePaymentModel(paymentId);
    }

    @Override
    public QueryResult<PePayment> queryPaymentPage(Map<String, Object> map) {
        List<PePayment> pePaymentList = this.queryPaymentModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countPayment(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(pePaymentList);
        return queryResult;
    }

    @Override
    public void savePaymentOrder(PePaymentOrderDomain pePaymentOrderDomain) throws ApiException {
        this.savePaymentOtderRe(pePaymentOrderDomain);
    }

    private PePaymentOrder savePaymentOtderRe(PePaymentOrderDomain pePaymentOrderDomain) {
        PePaymentOrder pePaymentOrder = this.createPaymentOrder(pePaymentOrderDomain);
        this.savePaymentOrderModel(pePaymentOrder);
        pePaymentOrderDomain.setPaymentOrderId(pePaymentOrder.getPaymentOrderId());
        pePaymentOrderDomain.setPaymentOrderSeqno(pePaymentOrder.getPaymentOrderSeqno());
        return pePaymentOrder;
    }

    private PePaymentOrder createPaymentOrder(PePaymentOrderDomain pePaymentOrderDomain) {
        String msg = this.checkPaymentOrder(pePaymentOrderDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pe.PePaymentServiceImpl.savePaymentOrder.checkPaymentOrder", msg);
        }
        PePaymentOrder pePaymentOrder = this.makePaymentOrder(pePaymentOrderDomain, null);
        this.setPaymentOrderDefault(pePaymentOrder);
        return pePaymentOrder;
    }

    @Override
    public void updatePaymentOrderState(Integer paymentOrderId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStatePaymentOrderModel(paymentOrderId, dataState, oldDataState);
    }

    @Override
    public void updatePaymentOrder(PePaymentOrderDomain pePaymentOrderDomain) throws ApiException {
        String msg = this.checkPaymentOrder(pePaymentOrderDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pe.PePaymentServiceImpl.updatePaymentOrder.checkPaymentOrder", msg);
        }
        PePaymentOrder oldPePaymentOrder = this.getPaymentOrderModelById(pePaymentOrderDomain.getPaymentOrderId());
        if (null == oldPePaymentOrder) {
            throw new ApiException("pe.PePaymentServiceImpl.updatePaymentOrder.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        PePaymentOrder pePaymentOrder = this.makePaymentOrder(pePaymentOrderDomain, oldPePaymentOrder);
        this.setPaymentOrderUpdataDefault(pePaymentOrder);
        this.updatePaymentOrderModel(pePaymentOrder);
    }

    @Override
    public PePaymentOrder getPaymentOrder(Integer paymentOrderId) {
        return this.getPaymentOrderModelById(paymentOrderId);
    }

    @Override
    public PePaymentOrderDomain getPaymentOrderByCode(String paymentOrderSeqno, String tenantCode) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("paymentOrderSeqno", paymentOrderSeqno);
        map.put("tenantCode", tenantCode);
        PePaymentOrder pePaymentOrder = this.getPaymentOrderModelByCode(map);
        PePaymentOrderDomain pePaymentOrderDomain = this.makePaymentOrderDomain(pePaymentOrder);
        if (null == pePaymentOrderDomain) {
            return null;
        }
        List<PePaymentParticipant> plist = this.queryPaymentParticipantModelPage(map);
        if (null == plist || plist.isEmpty()) {
            return pePaymentOrderDomain;
        }
        this.setParticipantDomain(pePaymentOrderDomain, plist);
        return pePaymentOrderDomain;
    }

    @Override
    public void deletePaymentOrder(Integer paymentOrderId) throws ApiException {
        this.deletePaymentOrderModel(paymentOrderId);
    }

    @Override
    public QueryResult<PePaymentOrder> queryPaymentOrderPage(Map<String, Object> map) {
        List<PePaymentOrder> pePaymentOrderList = this.queryPaymentOrderModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countPaymentOrder(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(pePaymentOrderList);
        return queryResult;
    }

    @Override
    public void savePaymentParticipant(PePaymentParticipantDomain pePaymentParticipantDomain) throws ApiException {
        PePaymentParticipant pePaymentParticipant = this.createPaymentParticipant(pePaymentParticipantDomain);
        this.savePaymentParticipantModel(pePaymentParticipant);
        pePaymentParticipantDomain.setPaymentParticipantId(pePaymentParticipant.getPaymentParticipantId());
        pePaymentParticipantDomain.setPaymentParticipantCode(pePaymentParticipant.getPaymentParticipantCode());
    }

    private PePaymentParticipant createPaymentParticipant(PePaymentParticipantDomain pePaymentParticipantDomain) {
        String msg = this.checkPaymentParticipant(pePaymentParticipantDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pe.PePaymentServiceImpl.savePaymentParticipant.checkPaymentParticipant", msg);
        }
        PePaymentParticipant pePaymentParticipant = this.makePaymentParticipant(pePaymentParticipantDomain, null);
        this.setPaymentParticipantDefault(pePaymentParticipant);
        return pePaymentParticipant;
    }

    @Override
    public void updatePaymentParticipantState(Integer paymentParticipantId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStatePaymentParticipantModel(paymentParticipantId, dataState, oldDataState);
    }

    @Override
    public void updatePaymentParticipant(PePaymentParticipantDomain pePaymentParticipantDomain) throws ApiException {
        String msg = this.checkPaymentParticipant(pePaymentParticipantDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pe.PePaymentServiceImpl.updatePaymentParticipant.checkPaymentParticipant", msg);
        }
        PePaymentParticipant oldPePaymentParticipant = this.getPaymentParticipantModelById(pePaymentParticipantDomain.getPaymentParticipantId());
        if (null == oldPePaymentParticipant) {
            throw new ApiException("pe.PePaymentServiceImpl.updatePaymentParticipant.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        PePaymentParticipant pePaymentParticipant = this.makePaymentParticipant(pePaymentParticipantDomain, oldPePaymentParticipant);
        this.setPaymentParticipantUpdataDefault(pePaymentParticipant);
        this.updatePaymentParticipantModel(pePaymentParticipant);
    }

    @Override
    public PePaymentParticipant getPaymentParticipant(Integer paymentParticipantId) {
        return this.getPaymentParticipantModelById(paymentParticipantId);
    }

    @Override
    public void deletePaymentParticipant(Integer paymentParticipantId) throws ApiException {
        this.deletePaymentParticipantModel(paymentParticipantId);
    }

    @Override
    public QueryResult<PePaymentParticipant> queryPaymentParticipantPage(Map<String, Object> map) {
        List<PePaymentParticipant> pePaymentParticipantList = this.queryPaymentParticipantModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countPaymentParticipant(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(pePaymentParticipantList);
        return queryResult;
    }

    @Override
    public CallbackResult savePaymentReorder(PePaymentReorderDomain pePaymentReorderDomain) throws ApiException {
        PayengineForm payengineForm;
        String msg = this.checkPaymentReorder(pePaymentReorderDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pe.PePaymentServiceImpl.savePaymentReorder.checkPaymentReorder", msg);
        }
        PePaymentReorder pePaymentReorder = this.makePaymentReorder(pePaymentReorderDomain, null);
        this.setPaymentReorderDefault(pePaymentReorder);
        this.savePaymentReorderModel(pePaymentReorder);
        String remsg = pePaymentReorder.getPaymentReorderMemo();
        boolean callflag = true;
        if (StringUtils.isNotBlank((String)remsg) && null != (payengineForm = (PayengineForm)JsonUtil.buildNormalBinder().getJsonToObject(remsg, PayengineForm.class)) && null != payengineForm.getCallmap() && null != payengineForm.getChannelRestForm()) {
            String dataStateStr = (String)payengineForm.getCallmap().get("paymentstate");
            if (StringUtils.isBlank((String)dataStateStr)) {
                throw new ApiException("pe.PePaymentServiceImpl.savePaymentReorder.paymentstate", "");
            }
            Integer dataState = Integer.valueOf(dataStateStr);
            String channelClearFchannel = null;
            String orderBankseq = null;
            if (null != payengineForm.getChannelRestForm()) {
                channelClearFchannel = payengineForm.getChannelRestForm().getChannelClearFchannel();
                if ("null".equals(channelClearFchannel)) {
                    channelClearFchannel = null;
                }
                orderBankseq = payengineForm.getChannelRestForm().getChannelClearSeqno();
            }
            this.updateStatePaymentModelByCode(pePaymentReorder.getPaymentSeqno(), channelClearFchannel, orderBankseq, dataState, pePaymentReorder.getTenantCode());
            if (StringUtils.isNotBlank((String)((String)payengineForm.getCallmap().get("call"))) && "false".equals(payengineForm.getCallmap().get("call"))) {
                callflag = false;
            }
        }
        CallbackResult callbackResult = null;
        callbackResult = callflag ? this.callBack(pePaymentReorder) : CallbackResult.SUCCESS;
        return callbackResult;
    }

    private CallbackResult callBack(PePaymentReorder pePaymentReorder) {
        if (StringUtils.isBlank((String)pePaymentReorder.getPaymentReorderUrl())) {
            this.logger.error("pe.PePaymentServiceImpl.callBack.null");
            return null;
        }
        HashMap<String, String> paramMap = new HashMap<String, String>();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ptradeSeqno", pePaymentReorder.getPtradeSeqno());
        map.put("paymentSeqno", pePaymentReorder.getPaymentSeqno());
        map.put("paymentReorderCode", pePaymentReorder.getPaymentReorderCode());
        map.put("partnerCode", pePaymentReorder.getPartnerCode());
        map.put("paymentOrderSeqno", pePaymentReorder.getPaymentOrderSeqno());
        map.put("paymentReorderMemo", pePaymentReorder.getPaymentReorderMemo());
        map.put("tenantCode", pePaymentReorder.getTenantCode());
        map.put("orderState", pePaymentReorder.getDataState());
        paramMap.put("map", JsonUtil.buildNormalBinder().toJson(map));
        String jsonResult = this.internalInvoke(pePaymentReorder.getPaymentReorderUrl(), paramMap);
        CallbackResult callbackResult = CallbackResult.SUCCESS;
        if (StringUtils.isNotBlank((String)jsonResult) && (callbackResult = (CallbackResult)JsonUtil.buildNormalBinder().getJsonToObject(jsonResult, CallbackResult.class)) == null) {
            this.logger.error("pe.PePaymentServiceImpl.callBack", (Object)"callbackResult is null");
            return CallbackResult.FAIL;
        }
        return callbackResult.polish();
    }

    @Override
    public void savePaymentReorderList(List<PeReorderDomain> peReorderDomainList) throws ApiException {
        if (null == peReorderDomainList || peReorderDomainList.isEmpty()) {
            throw new ApiException("pe.PePaymentServiceImpl.savePaymentReorderList.null", "null");
        }
        ArrayList<PePaymentReorder> pePaymentReorderList = new ArrayList<PePaymentReorder>();
        for (PeReorderDomain peReorderDomain : peReorderDomainList) {
            PePaymentReorder pePaymentReorder = this.makePaymentReorder(peReorderDomain, null);
            this.setPaymentReorderDefault(pePaymentReorder);
            pePaymentReorderList.add(pePaymentReorder);
        }
        this.savePaymentReorderBatchModel(pePaymentReorderList);
        for (PePaymentReorder pePaymentReorder1 : pePaymentReorderList) {
            this.callBack(pePaymentReorder1);
        }
    }

    @Override
    public void updatePaymentReorderState(Integer paymentReorderId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStatePaymentReorderModel(paymentReorderId, dataState, oldDataState);
    }

    @Override
    public void updatePaymentReorder(PePaymentReorderDomain pePaymentReorderDomain) throws ApiException {
        String msg = this.checkPaymentReorder(pePaymentReorderDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pe.PePaymentServiceImpl.updatePaymentReorder.checkPaymentReorder", msg);
        }
        PePaymentReorder oldPePaymentReorder = this.getPaymentReorderModelById(pePaymentReorderDomain.getPaymentReorderId());
        if (null == oldPePaymentReorder) {
            throw new ApiException("pe.PePaymentServiceImpl.updatePaymentReorder.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        PePaymentReorder pePaymentReorder = this.makePaymentReorder(pePaymentReorderDomain, oldPePaymentReorder);
        this.setPaymentReorderUpdataDefault(pePaymentReorder);
        this.updatePaymentReorderModel(pePaymentReorder);
    }

    @Override
    public PePaymentReorder getPaymentReorder(Integer paymentReorderId) {
        return this.getPaymentReorderModelById(paymentReorderId);
    }

    @Override
    public void deletePaymentReorder(Integer paymentReorderId) throws ApiException {
        this.deletePaymentReorderModel(paymentReorderId);
    }

    @Override
    public QueryResult<PePaymentReorder> queryPaymentReorderPage(Map<String, Object> map) {
        List<PePaymentReorder> pePaymentReorderList = this.queryPaymentReorderModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countPaymentReorder(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(pePaymentReorderList);
        return queryResult;
    }

    @Override
    public PeReorderDomain savePaymentNext(PeReorderDomain peReorderDomain) {
        return null;
    }

    @Override
    public List<PePayment> paymentUnionQuery(Map<String, Object> map) {
        try {
            List<PePayment> list = this.pePaymentMapper.query(map);
            if (list != null && list.size() > 0) {
                for (PePayment pePayment : list) {
                    HashMap<String, Object> paraMap = new HashMap<String, Object>();
                    paraMap.put("paymentSeqno", pePayment.getPaymentSeqno());
                    paraMap.put("tenantCode", pePayment.getTenantCode());
                    List<PePaymentOrder> paymentOrderList = this.pePaymentOrderMapper.query(paraMap);
                    pePayment.setPaymentOrderList(paymentOrderList);
                    pePayment.setPaymentParticipantList(this.pePaymentParticipantMapper.query(paraMap));
                    pePayment.setPaymentReorderList(this.pePaymentReorderMapper.query(paraMap));
                    pePayment.setProtClearinfoList(this.peProtClearinfoMapper.query(paraMap));
                    pePayment.setCflowPprocesseList(this.peCflowPprocessMapper.query(paraMap));
                    HashMap<String, Object> map2 = new HashMap<String, Object>();
                    map2.put("paymentOrderSeqno", paymentOrderList.get(0).getPaymentOrderSeqno());
                    map2.put("tenantCode", paymentOrderList.get(0).getTenantCode());
                    List<PeClearOrder> clearOrderList = this.peClearOrderMapper.query(map2);
                    ArrayList<PeClearResp> clearRespList = new ArrayList<PeClearResp>();
                    for (PeClearOrder clearOrder : clearOrderList) {
                        map2.clear();
                        map2.put("clearOrderSeqno", clearOrder.getClearOrderSeqno());
                        map2.put("tenantCode", clearOrder.getTenantCode());
                        List<PeClearResp> clearRespList2 = this.peClearRespMapper.query(map2);
                        if (clearRespList2 == null || clearRespList2.size() <= 0) continue;
                        for (PeClearResp peClearResp : clearRespList2) {
                            clearRespList.add(peClearResp);
                        }
                    }
                    pePayment.setClearOrderList(clearOrderList);
                    pePayment.setClearRespList(clearRespList);
                }
            }
            return list;
        }
        catch (Exception e) {
            this.logger.error("pe.PePaymentServiceImpl.paymentUnionQuery", (Throwable)e);
            return null;
        }
    }
}

