/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.payengine.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.log.performance.OpenPerfLogUtil;
import com.yqbsoft.laser.service.esb.core.spring.SpringApplicationContextUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.payengine.domain.PePaymentDomain;
import com.yqbsoft.laser.service.payengine.domain.PeReorderDomain;
import com.yqbsoft.laser.service.payengine.enumc.PaymentType;
import com.yqbsoft.laser.service.payengine.model.PePayment;
import com.yqbsoft.laser.service.payengine.model.PeProtClearinfo;
import com.yqbsoft.laser.service.payengine.service.PePayClearService;
import com.yqbsoft.laser.service.payengine.service.PePayEngineBaseService;
import com.yqbsoft.laser.service.payengine.service.PePayEngineService;
import com.yqbsoft.laser.service.payengine.service.PePaymentService;
import com.yqbsoft.laser.service.payengine.service.impl.PatmentBackPollThread;
import com.yqbsoft.laser.service.payengine.service.impl.PatmentPollThread;
import com.yqbsoft.laser.service.payengine.service.impl.PaymentBackPutThread;
import com.yqbsoft.laser.service.payengine.service.impl.PaymentBackService;
import com.yqbsoft.laser.service.payengine.service.impl.PaymentPutThread;
import com.yqbsoft.laser.service.payengine.service.impl.PaymentService;
import java.util.HashMap;
import java.util.List;

public class PePayEngineServiceImpl
extends BaseServiceImpl
implements PePayEngineService {
    public static final String SYS_CODE = "pe.PePayEngineServiceImpl";
    private PePaymentService pePaymentService;
    private PePayClearService pePayClearService;
    private PePayEngineBaseService pePayEngineBaseService;
    private static PaymentService paymentService;
    private static Object lock;
    private static PaymentBackService paymentBackService;
    private static Object backlock;

    public void setPePayEngineBaseService(PePayEngineBaseService pePayEngineBaseService) {
        this.pePayEngineBaseService = pePayEngineBaseService;
    }

    public void setPePayClearService(PePayClearService pePayClearService) {
        this.pePayClearService = pePayClearService;
    }

    public void setPePaymentService(PePaymentService pePaymentService) {
        this.pePaymentService = pePaymentService;
    }

    @Override
    public String sendPayment(PePaymentDomain pePaymentDomain) throws ApiException {
        this.logger.debug(SYS_CODE, (Object)"======sendPayment=====start=============");
        PePayment pePayment = this.pePaymentService.savePayment(pePaymentDomain);
        if (PaymentType.AB.getCode().equals(pePaymentDomain.getPaymentType())) {
            this.getPaymentBackService().putQueue(pePayment);
        } else {
            this.getPaymentService().putQueue(pePayment);
        }
        this.logger.debug(SYS_CODE, (Object)"======sendPayment=====end=============");
        return pePayment.getPaymentSeqno();
    }

    @Override
    public String sendFlowNext(PeReorderDomain peReorderDomain) {
        this.logger.debug(SYS_CODE, (Object)"======sendFlowNext=====start=============");
        List<PeProtClearinfo> peProtClearinfoList = this.pePayEngineBaseService.savePaymentNext(peReorderDomain);
        if (null != peProtClearinfoList && !peProtClearinfoList.isEmpty()) {
            this.pePayClearService.sendProtClearinfoBatch(peProtClearinfoList);
        }
        this.logger.debug(SYS_CODE, (Object)"======sendFlowNext=====end=============");
        return "success";
    }

    @Override
    public boolean sendPaymentNext(String paymentSeqno, String tenantCode) throws ApiException {
        List<PeProtClearinfo> peProtClearinfoList;
        this.logger.debug("pe.PePayEngineServiceImpl.savePaymentNext.start", (Object)("paymentSeqno:" + paymentSeqno + ";tenantCode:" + tenantCode));
        long start = System.currentTimeMillis();
        PePaymentDomain pePaymentDomain = this.pePaymentService.getPaymentByCode(paymentSeqno, tenantCode);
        if (null == pePaymentDomain) {
            throw new ApiException("pe.PePayEngineServiceImpl.savePaymentNext.pePaymentDomain", "null");
        }
        if (PaymentType.AB.getCode().equals(pePaymentDomain.getPaymentType())) {
            PePaymentDomain oldPePaymentDomain = this.pePaymentService.getPaymentByCode(pePaymentDomain.getPaymentOldseqno(), tenantCode);
            if (null == oldPePaymentDomain) {
                throw new ApiException("pe.PePayEngineServiceImpl.savePaymentNext.oldPePaymentDomain", "null");
            }
            if (5 != oldPePaymentDomain.getDataState()) {
                return false;
            }
            pePaymentDomain.setFchannelCode(oldPePaymentDomain.getFchannelCode());
            pePaymentDomain.setOrderOldbankseq(oldPePaymentDomain.getOrderBankseq());
            this.pePaymentService.updatePaymentFchannelByCode(oldPePaymentDomain.getFchannelCode(), oldPePaymentDomain.getOrderBankseq(), pePaymentDomain.getPaymentSeqno(), tenantCode);
        }
        if (null != (peProtClearinfoList = this.pePayEngineBaseService.savePaymentDomainNext(pePaymentDomain)) && !peProtClearinfoList.isEmpty()) {
            this.pePayClearService.sendProtClearinfoBatch(peProtClearinfoList);
        }
        OpenPerfLogUtil.debug((String)("pePayEngineService sendPaymentNext end time consuming:{}ms,paymentSeqno=" + paymentSeqno), (long)(System.currentTimeMillis() - start));
        return true;
    }

    @Override
    public void sendPaymentBack(String paymentSeqno, String tenantCode) throws ApiException {
        this.logger.debug("pe.PePayEngineServiceImpl.sendPaymentBack.start", (Object)("paymentSeqno:" + paymentSeqno + ";tenantCode:" + tenantCode));
        PePaymentDomain pePaymentDomain = this.pePaymentService.getPaymentByCode(paymentSeqno, tenantCode);
        if (null == pePaymentDomain) {
            throw new ApiException("pe.PePayEngineServiceImpl.savePaymentNext.pePaymentDomain", "null");
        }
        List<PeProtClearinfo> peProtClearinfoList = this.pePayEngineBaseService.savePaymentDomainBack(pePaymentDomain);
        if (null != peProtClearinfoList && !peProtClearinfoList.isEmpty()) {
            this.pePayClearService.sendProtClearinfoBatch(peProtClearinfoList);
        }
    }

    @Override
    public void loadPaymentProcess() {
        this.loadDb();
    }

    private void loadDb() {
        boolean flag;
        int startRow;
        QueryResult<PePayment> result;
        HashMap<String, Object> map;
        try {
            map = new HashMap<String, Object>();
            map.put("dataState", "0");
            map.put("paymentType", "AN");
            map.put("order", true);
            map.put("orderStr", "GMT_CREATE asc");
            result = null;
            startRow = 0;
            flag = true;
            do {
                startRow = this.getPaymentService().getStartRow();
                map.put("startRow", startRow);
                map.put("rows", this.getPaymentService().getPage());
                result = this.pePaymentService.queryPaymentPage(map);
                if (null != result && null != result.getPageTools() && null != result.getRows() && !result.getRows().isEmpty()) {
                    startRow = result.getPageTools().getRecordCountNo();
                    this.getPaymentService().addPutPool(new PaymentPutThread(this.getPaymentService(), result.getRows()));
                    if (result.getRows().size() == this.getPaymentService().getPage()) continue;
                    flag = false;
                    continue;
                }
                flag = false;
            } while (flag);
            this.getPaymentService().initStartRow();
        }
        catch (Exception e) {
            throw new ApiException("pe.PePayEngineServiceImpl.loadDb.an.e", (Throwable)e);
        }
        try {
            map = new HashMap();
            map.put("dataState", "0");
            map.put("paymentType", "AB");
            map.put("order", true);
            map.put("orderStr", "GMT_CREATE asc");
            result = null;
            startRow = 0;
            flag = true;
            do {
                startRow = this.getPaymentBackService().getStartRow();
                map.put("startRow", startRow);
                map.put("rows", this.getPaymentBackService().getPage());
                result = this.pePaymentService.queryPaymentPage(map);
                if (null != result && null != result.getPageTools() && null != result.getRows() && !result.getRows().isEmpty()) {
                    startRow = result.getPageTools().getRecordCountNo();
                    this.getPaymentBackService().addPutPool(new PaymentBackPutThread(this.getPaymentBackService(), result.getRows()));
                    if (result.getRows().size() == this.getPaymentBackService().getPage()) continue;
                    flag = false;
                    continue;
                }
                flag = false;
            } while (flag);
            this.getPaymentBackService().initStartRow();
        }
        catch (Exception e) {
            throw new ApiException("pe.PePayEngineServiceImpl.loadDb.ab.e", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PaymentService getPaymentService() {
        Object object = lock;
        synchronized (object) {
            if (null == paymentService) {
                paymentService = new PaymentService((PePayEngineService)SpringApplicationContextUtil.getBean((String)"pePayEngineService"));
                for (int i = 0; i < 20; ++i) {
                    paymentService.addPollPool(new PatmentPollThread(paymentService));
                }
            }
            return paymentService;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PaymentBackService getPaymentBackService() {
        Object object = backlock;
        synchronized (object) {
            if (null == paymentBackService) {
                paymentBackService = new PaymentBackService((PePayEngineService)SpringApplicationContextUtil.getBean((String)"pePayEngineService"));
                paymentBackService.addPollPool(new PatmentBackPollThread(paymentBackService));
                paymentBackService.addPollPool(new PatmentBackPollThread(paymentBackService));
                paymentBackService.addPollPool(new PatmentBackPollThread(paymentBackService));
                paymentBackService.addPollPool(new PatmentBackPollThread(paymentBackService));
                paymentBackService.addPollPool(new PatmentBackPollThread(paymentBackService));
                paymentBackService.addPollPool(new PatmentBackPollThread(paymentBackService));
                paymentBackService.addPollPool(new PatmentBackPollThread(paymentBackService));
                paymentBackService.addPollPool(new PatmentBackPollThread(paymentBackService));
            }
            return paymentBackService;
        }
    }

    static {
        lock = new Object();
        backlock = new Object();
    }
}

