/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.payengine.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.payengine.dao.PeProtEtcBackMapper;
import com.yqbsoft.laser.service.payengine.dao.PeProtEtcInfoMapper;
import com.yqbsoft.laser.service.payengine.dao.PeProtEtcMapper;
import com.yqbsoft.laser.service.payengine.domain.JobScheduleDomain;
import com.yqbsoft.laser.service.payengine.domain.PeProtEtcDomain;
import com.yqbsoft.laser.service.payengine.domain.PeProtEtcInfoDomain;
import com.yqbsoft.laser.service.payengine.enumc.PortEtcType;
import com.yqbsoft.laser.service.payengine.model.PeProtEtc;
import com.yqbsoft.laser.service.payengine.model.PeProtEtcBack;
import com.yqbsoft.laser.service.payengine.model.PeProtEtcInfo;
import com.yqbsoft.laser.service.payengine.service.PeProtEtcService;
import com.yqbsoft.laser.service.suppercore.point.ServletMain;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;

public class PeProtEtcServiceImpl
extends BaseServiceImpl
implements PeProtEtcService {
    public static final String SYS_CODE = "pe.PeProtEtcServiceImpl";
    private PeProtEtcMapper peProtEtcMapper;
    private PeProtEtcInfoMapper peProtEtcInfoMapper;
    private PeProtEtcBackMapper peProtEtcBackMapper;
    public static String CACHE_KEY_ETC = "PeProtEtc";

    public void setPeProtEtcBackMapper(PeProtEtcBackMapper peProtEtcBackMapper) {
        this.peProtEtcBackMapper = peProtEtcBackMapper;
    }

    public void setPeProtEtcMapper(PeProtEtcMapper peProtEtcMapper) {
        this.peProtEtcMapper = peProtEtcMapper;
    }

    public void setPeProtEtcInfoMapper(PeProtEtcInfoMapper peProtEtcInfoMapper) {
        this.peProtEtcInfoMapper = peProtEtcInfoMapper;
    }

    private Date getSysDate() {
        try {
            return this.peProtEtcMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("pe.PeProtEtcServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkProtEtc(PeProtEtcDomain peProtEtcDomain) {
        if (null == peProtEtcDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        return msg;
    }

    private void setProtEtcDefault(PeProtEtc peProtEtc) {
        if (null == peProtEtc) {
            return;
        }
        if (null == peProtEtc.getDataState()) {
            peProtEtc.setDataState(0);
        }
        if (null == peProtEtc.getGmtCreate()) {
            peProtEtc.setGmtCreate(this.getSysDate());
        }
        peProtEtc.setGmtModified(this.getSysDate());
    }

    private int getProtEtcMaxCode() {
        int code = 0;
        try {
            return this.peProtEtcMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("pe.PeProtEtcServiceImpl.getProtEtcMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setProtEtcUpdataDefault(PeProtEtc peProtEtc) {
        if (null == peProtEtc) {
            return;
        }
        peProtEtc.setGmtModified(this.getSysDate());
    }

    private void saveProtEtcModel(PeProtEtc peProtEtc) throws ApiException {
        if (null == peProtEtc) {
            return;
        }
        try {
            this.peProtEtcMapper.insert(peProtEtc);
        }
        catch (Exception e) {
            throw new ApiException("pe.PeProtEtcServiceImpl.saveProtEtcModel.ex", (Throwable)e);
        }
    }

    private PeProtEtc getProtEtcModelById(Integer protEtcId) {
        if (null == protEtcId) {
            return null;
        }
        try {
            return this.peProtEtcMapper.selectByPrimaryKey(protEtcId);
        }
        catch (Exception e) {
            this.logger.error("pe.PeProtEtcServiceImpl.getProtEtcModelById", (Throwable)e);
            return null;
        }
    }

    public PeProtEtc getProtEtcModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.peProtEtcMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("pe.PeProtEtcServiceImpl.getProtEtcModelByCode", (Throwable)e);
            return null;
        }
    }

    public void delProtEtcModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.peProtEtcMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pe.PeProtEtcServiceImpl.delProtEtcModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pe.PeProtEtcServiceImpl.delProtEtcModelByCode.num");
        }
    }

    private void deleteProtEtcModel(Integer protEtcId) throws ApiException {
        if (null == protEtcId) {
            return;
        }
        int i = 0;
        try {
            i = this.peProtEtcMapper.deleteByPrimaryKey(protEtcId);
        }
        catch (Exception e) {
            throw new ApiException("pe.PeProtEtcServiceImpl.deleteProtEtcModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pe.PeProtEtcServiceImpl.deleteProtEtcModel.num");
        }
    }

    private void updateProtEtcModel(PeProtEtc peProtEtc) throws ApiException {
        if (null == peProtEtc) {
            return;
        }
        try {
            this.peProtEtcMapper.updateByPrimaryKeySelective(peProtEtc);
        }
        catch (Exception e) {
            throw new ApiException("pe.PeProtEtcServiceImpl.updateProtEtcModel.ex", (Throwable)e);
        }
    }

    private void updateStateProtEtcModel(Integer protEtcId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == protEtcId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("protEtcId", protEtcId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.peProtEtcMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("pe.PeProtEtcServiceImpl.updateStateProtEtcModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pe.PeProtEtcServiceImpl.updateStateProtEtcModel.null");
        }
    }

    private PeProtEtc makeProtEtc(PeProtEtcDomain peProtEtcDomain, PeProtEtc peProtEtc) {
        if (null == peProtEtcDomain) {
            return null;
        }
        if (null == peProtEtc) {
            peProtEtc = new PeProtEtc();
        }
        try {
            BeanUtils.copyAllPropertys((Object)peProtEtc, (Object)peProtEtcDomain);
            return peProtEtc;
        }
        catch (Exception e) {
            this.logger.error("pe.PeProtEtcServiceImpl.makeProtEtc", (Throwable)e);
            return null;
        }
    }

    private List<PeProtEtc> queryProtEtcModelPage(Map<String, Object> parammap) {
        try {
            return this.peProtEtcMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("pe.PeProtEtcServiceImpl.queryProtEtcModel", (Throwable)e);
            return null;
        }
    }

    private int countProtEtc(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.peProtEtcMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("pe.PeProtEtcServiceImpl.countProtEtc", (Throwable)e);
        }
        return i;
    }

    private String checkProtEtcInfo(PeProtEtcInfoDomain peProtEtcInfoDomain) {
        if (null == peProtEtcInfoDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        return msg;
    }

    private void setProtEtcInfoDefault(PeProtEtcInfo peProtEtcInfo) {
        if (null == peProtEtcInfo) {
            return;
        }
        if (null == peProtEtcInfo.getDataState()) {
            peProtEtcInfo.setDataState(0);
        }
        if (null == peProtEtcInfo.getGmtCreate()) {
            peProtEtcInfo.setGmtCreate(this.getSysDate());
        }
        peProtEtcInfo.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)peProtEtcInfo.getProtEtcInfoSeqno())) {
            peProtEtcInfo.setProtEtcInfoSeqno(this.createUUIDString());
        }
    }

    private int getProtEtcInfoMaxCode() {
        int code = 0;
        try {
            return this.peProtEtcInfoMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("pe.PeProtEtcServiceImpl.getProtEtcInfoMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setProtEtcInfoUpdataDefault(PeProtEtcInfo peProtEtcInfo) {
        if (null == peProtEtcInfo) {
            return;
        }
        peProtEtcInfo.setGmtModified(this.getSysDate());
    }

    private void saveProtEtcInfoModel(PeProtEtcInfo peProtEtcInfo) throws ApiException {
        if (null == peProtEtcInfo) {
            return;
        }
        try {
            this.peProtEtcInfoMapper.insert(peProtEtcInfo);
        }
        catch (Exception e) {
            throw new ApiException("pe.PeProtEtcServiceImpl.saveProtEtcInfoModel.ex", (Throwable)e);
        }
    }

    private void saveProtEtcBackModel(PeProtEtcBack peProtEtcBack) throws ApiException {
        if (null == peProtEtcBack) {
            return;
        }
        try {
            this.peProtEtcBackMapper.insert(peProtEtcBack);
        }
        catch (Exception e) {
            throw new ApiException("pe.PeProtEtcServiceImpl.saveProtEtcBackModel.ex", (Throwable)e);
        }
    }

    private PeProtEtcInfo getProtEtcInfoModelById(Integer protEtcInfoId) {
        if (null == protEtcInfoId) {
            return null;
        }
        try {
            return this.peProtEtcInfoMapper.selectByPrimaryKey(protEtcInfoId);
        }
        catch (Exception e) {
            this.logger.error("pe.PeProtEtcServiceImpl.getProtEtcInfoModelById", (Throwable)e);
            return null;
        }
    }

    public PeProtEtcInfo getProtEtcInfoModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.peProtEtcInfoMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("pe.PeProtEtcServiceImpl.getProtEtcInfoModelByCode", (Throwable)e);
            return null;
        }
    }

    public void delProtEtcInfoModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.peProtEtcInfoMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pe.PeProtEtcServiceImpl.delProtEtcInfoModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pe.PeProtEtcServiceImpl.delProtEtcInfoModelByCode.num");
        }
    }

    private void deleteProtEtcInfoModel(Integer protEtcInfoId) throws ApiException {
        if (null == protEtcInfoId) {
            return;
        }
        int i = 0;
        try {
            i = this.peProtEtcInfoMapper.deleteByPrimaryKey(protEtcInfoId);
        }
        catch (Exception e) {
            throw new ApiException("pe.PeProtEtcServiceImpl.deleteProtEtcInfoModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pe.PeProtEtcServiceImpl.deleteProtEtcInfoModel.num");
        }
    }

    private void updateProtEtcInfoModel(PeProtEtcInfo peProtEtcInfo) throws ApiException {
        if (null == peProtEtcInfo) {
            return;
        }
        try {
            this.peProtEtcInfoMapper.updateByPrimaryKeySelective(peProtEtcInfo);
        }
        catch (Exception e) {
            throw new ApiException("pe.PeProtEtcServiceImpl.updateProtEtcInfoModel.ex", (Throwable)e);
        }
    }

    private void updateStateProtEtcInfoModel(Integer protEtcInfoId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == protEtcInfoId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("protEtcInfoId", protEtcInfoId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.peProtEtcInfoMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("pe.PeProtEtcServiceImpl.updateStateProtEtcInfoModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pe.PeProtEtcServiceImpl.updateStateProtEtcInfoModel.null");
        }
    }

    private PeProtEtcInfo makeProtEtcInfo(PeProtEtcInfoDomain peProtEtcInfoDomain, PeProtEtcInfo peProtEtcInfo) {
        if (null == peProtEtcInfoDomain) {
            return null;
        }
        if (null == peProtEtcInfo) {
            peProtEtcInfo = new PeProtEtcInfo();
        }
        try {
            BeanUtils.copyAllPropertys((Object)peProtEtcInfo, (Object)peProtEtcInfoDomain);
            return peProtEtcInfo;
        }
        catch (Exception e) {
            this.logger.error("pe.PeProtEtcServiceImpl.makeProtEtcInfo", (Throwable)e);
            return null;
        }
    }

    private PeProtEtcBack makeProtEtcBack(PeProtEtcInfo peProtEtcInfo) {
        if (null == peProtEtcInfo) {
            return null;
        }
        PeProtEtcBack peProtEtcBack = new PeProtEtcBack();
        try {
            BeanUtils.copyAllPropertys((Object)peProtEtcBack, (Object)peProtEtcInfo);
            return peProtEtcBack;
        }
        catch (Exception e) {
            this.logger.error("pe.PeProtEtcServiceImpl.makeProtEtcBack", (Throwable)e);
            return null;
        }
    }

    private List<PeProtEtcInfo> queryProtEtcInfoModelPage(Map<String, Object> parammap) {
        try {
            return this.peProtEtcInfoMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("pe.PeProtEtcServiceImpl.queryProtEtcInfoModel", (Throwable)e);
            return null;
        }
    }

    private int countProtEtcInfo(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.peProtEtcInfoMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("pe.PeProtEtcServiceImpl.countProtEtcInfo", (Throwable)e);
        }
        return i;
    }

    @Override
    public void saveProtEtc(PeProtEtcDomain peProtEtcDomain) throws ApiException {
        String msg = this.checkProtEtc(peProtEtcDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pe.PeProtEtcServiceImpl.saveProtEtc.checkProtEtc", msg);
        }
        PeProtEtc peProtEtc = this.makeProtEtc(peProtEtcDomain, null);
        this.setProtEtcDefault(peProtEtc);
        this.saveProtEtcModel(peProtEtc);
    }

    @Override
    public void updateProtEtcState(Integer protEtcId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateProtEtcModel(protEtcId, dataState, oldDataState);
    }

    @Override
    public void updateProtEtc(PeProtEtcDomain peProtEtcDomain) throws ApiException {
        String msg = this.checkProtEtc(peProtEtcDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pe.PeProtEtcServiceImpl.updateProtEtc.checkProtEtc", msg);
        }
        PeProtEtc oldPeProtEtc = this.getProtEtcModelById(peProtEtcDomain.getProtEtcId());
        if (null == oldPeProtEtc) {
            throw new ApiException("pe.PeProtEtcServiceImpl.updateProtEtc.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        PeProtEtc peProtEtc = this.makeProtEtc(peProtEtcDomain, oldPeProtEtc);
        this.setProtEtcUpdataDefault(peProtEtc);
        this.updateProtEtcModel(peProtEtc);
    }

    @Override
    public PeProtEtc getProtEtc(Integer protEtcId) {
        return this.getProtEtcModelById(protEtcId);
    }

    @Override
    public PeProtEtc getProtEtcByCode(String protEtcCode, String tenantCode) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("protEtcCode", protEtcCode);
        map.put("tenantCode", tenantCode);
        return this.getProtEtcModelByCode(map);
    }

    @Override
    public void deleteProtEtc(Integer protEtcId) throws ApiException {
        this.deleteProtEtcModel(protEtcId);
    }

    @Override
    public QueryResult<PeProtEtc> queryProtEtcPage(Map<String, Object> map) {
        List<PeProtEtc> peProtEtcList = this.queryProtEtcModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countProtEtc(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(peProtEtcList);
        return queryResult;
    }

    @Override
    public PeProtEtcInfo saveProtEtcInfo(PeProtEtcInfoDomain peProtEtcInfoDomain) throws ApiException {
        String msg = this.checkProtEtcInfo(peProtEtcInfoDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pe.PeProtEtcServiceImpl.saveProtEtcInfo.checkProtEtcInfo", msg);
        }
        PeProtEtcInfo peProtEtcInfo = this.makeProtEtcInfo(peProtEtcInfoDomain, null);
        this.setProtEtcInfoDefault(peProtEtcInfo);
        this.saveProtEtcInfoModel(peProtEtcInfo);
        this.saveJob(peProtEtcInfo);
        return peProtEtcInfo;
    }

    private void saveJob(PeProtEtcInfo peProtEtcInfo) {
        if (null == peProtEtcInfo) {
            throw new ApiException("pe.PeProtEtcServiceImpl.saveJob.null", "null");
        }
        JobScheduleDomain job = new JobScheduleDomain();
        if (ServletMain.getAppName().equals("laser")) {
            job.setAppmanageIcode(ServletMain.getAppName());
        } else {
            job.setAppmanageIcode("com-job");
        }
        job.setScheduleLevel(6);
        job.setDataState(1);
        job.setScheduleDes("\u6e05\u7b97\u670d\u52a1AUTO");
        job.setScheduleExjobId("http-pe-etcinfo");
        job.setScheduleGroup("peclean");
        job.setScheduleMethod("GET");
        job.setScheduleName(peProtEtcInfo.getProtEtcSeqno() + "-" + peProtEtcInfo.getTenantCode());
        job.setScheduleSync("1");
        job.setScheduleTappkey(ServletMain.getAppName());
        job.setScheduleTicode(ServletMain.getAppName());
        if (PortEtcType.RT.getCode().equals(peProtEtcInfo.getProtEtcType())) {
            job.setScheduleExp("1");
            job.setScheduleType("0");
        } else {
            job.setScheduleExp(peProtEtcInfo.getProtEtcTime());
            job.setScheduleType("1");
        }
        job.setScheduleUrl("http://{appIp}:{appPort}/{contextPath}/laserDirect/http/get?method=pe.clearOrder.defenderEtc&version=1.0&charset=utf-8");
        job.setScheduleParam("protEtcSeqno=" + peProtEtcInfo.getProtEtcSeqno() + "&tenantCode=" + peProtEtcInfo.getTenantCode());
        job.setTenantCode("00000000");
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("jobSchedule", JsonUtil.buildNormalBinder().toJson((Object)job));
        this.internalInvoke("job.job.saveSchedule", paramMap);
    }

    @Override
    public void updateProtEtcInfoState(Integer protEtcInfoId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateProtEtcInfoModel(protEtcInfoId, dataState, oldDataState);
    }

    @Override
    public void updateProtEtcInfo(PeProtEtcInfoDomain peProtEtcInfoDomain) throws ApiException {
        String msg = this.checkProtEtcInfo(peProtEtcInfoDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pe.PeProtEtcServiceImpl.updateProtEtcInfo.checkProtEtcInfo", msg);
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("protEtcSeqno", peProtEtcInfoDomain.getProtEtcSeqno());
        map.put("tenantCode", peProtEtcInfoDomain.getTenantCode());
        PeProtEtcInfo oldPeProtEtcInfo = this.getProtEtcInfoModelByCode(map);
        if (null == oldPeProtEtcInfo) {
            throw new ApiException("pe.PeProtEtcServiceImpl.updateProtEtcInfo.null", "\u6570\u636e\u4e3a\u7a7a:" + ((Object)map).toString());
        }
        this.saveProtEtcBackModel(this.makeProtEtcBack(oldPeProtEtcInfo));
        PeProtEtcInfo peProtEtcInfo = this.makeProtEtcInfo(peProtEtcInfoDomain, oldPeProtEtcInfo);
        this.setProtEtcInfoUpdataDefault(peProtEtcInfo);
        this.updateProtEtcInfoModel(peProtEtcInfo);
    }

    @Override
    public PeProtEtcInfo getProtEtcInfo(Integer protEtcInfoId) {
        return this.getProtEtcInfoModelById(protEtcInfoId);
    }

    @Override
    public PeProtEtcInfo getProtEtcInfoByCode(String protEtcSeqno, String tenantCode) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("protEtcSeqno", protEtcSeqno);
        map.put("tenantCode", tenantCode);
        return this.getProtEtcInfoModelByCode(map);
    }

    @Override
    public void deleteProtEtcInfo(Integer protEtcInfoId) throws ApiException {
        this.deleteProtEtcInfoModel(protEtcInfoId);
    }

    @Override
    public QueryResult<PeProtEtcInfo> queryProtEtcInfoPage(Map<String, Object> map) {
        List<PeProtEtcInfo> peProtEtcInfoList = this.queryProtEtcInfoModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countProtEtcInfo(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(peProtEtcInfoList);
        return queryResult;
    }

    @Override
    public void queryProtEtcCache() {
        this.info("pe.PeProtEtcServiceImpl.queryProtEtcCache.start", "=======\u8c03\u5ea6start=======");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("dataStates", 1L);
        List<PeProtEtc> etcList = this.queryProtEtcModelPage(params);
        if (CollectionUtils.isEmpty(etcList)) {
            DisUtil.delVer((String)CACHE_KEY_ETC);
            this.info("pe.PeProtEtcServiceImpl.queryProtEtcCache.null", "=======\u8c03\u5ea6end=======");
            return;
        }
        HashMap<String, String> mmap = new HashMap<String, String>();
        String key = "";
        for (PeProtEtc peProtEtc : etcList) {
            key = peProtEtc.getProtEtcCode() + "-" + peProtEtc.getTenantCode();
            mmap.put(key, JsonUtil.buildNormalBinder().toJson((Object)peProtEtc));
        }
        DisUtil.setMap((String)CACHE_KEY_ETC, mmap);
        this.info("pe.PeProtEtcServiceImpl.queryProtEtcCache.end", "=======\u8c03\u5ea6end=======");
    }

    @Override
    public void saveProtEtcInfo(PeProtEtcInfo peProtEtcInfo) {
        if (null == peProtEtcInfo) {
            return;
        }
        this.setProtEtcInfoDefault(peProtEtcInfo);
        this.saveProtEtcInfoModel(peProtEtcInfo);
    }
}

