/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.payengine.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseProcessService;
import com.yqbsoft.laser.service.payengine.domain.PeProtEtcInfoDomain;
import com.yqbsoft.laser.service.payengine.enumc.PortEtcType;
import com.yqbsoft.laser.service.payengine.model.PeClearOrder;
import com.yqbsoft.laser.service.payengine.model.PeProtEtcInfo;
import com.yqbsoft.laser.service.payengine.service.PeClearOrderService;
import com.yqbsoft.laser.service.payengine.service.PeProtClearagService;
import com.yqbsoft.laser.service.payengine.service.PeProtEtcService;
import com.yqbsoft.laser.service.payengine.service.impl.EtcInfoProcessService;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.quartz.CronExpression;

public class ClearProcessService
extends BaseProcessService<List<PeClearOrder>> {
    private PeProtClearagService peProtClearagService;
    private PeClearOrderService peClearOrderService;
    private PeProtEtcService peProtEtcService;
    private PeProtEtcInfo peProtEtcInfo;
    private EtcInfoProcessService etcInfoProcessService;

    public PeProtClearagService getPeProtClearagService() {
        return this.peProtClearagService;
    }

    public void setPeProtClearagService(PeProtClearagService peProtClearagService) {
        this.peProtClearagService = peProtClearagService;
    }

    public PeClearOrderService getPeClearOrderService() {
        return this.peClearOrderService;
    }

    public void setPeClearOrderService(PeClearOrderService peClearOrderService) {
        this.peClearOrderService = peClearOrderService;
    }

    public PeProtEtcService getPeProtEtcService() {
        return this.peProtEtcService;
    }

    public void setPeProtEtcService(PeProtEtcService peProtEtcService) {
        this.peProtEtcService = peProtEtcService;
    }

    public EtcInfoProcessService getEtcInfoProcessService() {
        return this.etcInfoProcessService;
    }

    public void setEtcInfoProcessService(EtcInfoProcessService etcInfoProcessService) {
        this.etcInfoProcessService = etcInfoProcessService;
    }

    public PeProtEtcInfo getPeProtEtcInfo() {
        return this.peProtEtcInfo;
    }

    public void setPeProtEtcInfo(PeProtEtcInfo peProtEtcInfo) {
        this.peProtEtcInfo = peProtEtcInfo;
    }

    ClearProcessService(PeProtEtcInfo peProtEtcInfo, PeProtClearagService peProtClearagService, PeClearOrderService peClearOrderService, PeProtEtcService peProtEtcService, EtcInfoProcessService etcInfoProcessService) {
        this.peProtEtcInfo = peProtEtcInfo;
        this.peProtClearagService = peProtClearagService;
        this.peClearOrderService = peClearOrderService;
        this.peProtEtcService = peProtEtcService;
        this.etcInfoProcessService = etcInfoProcessService;
        this.pollExecutor(80, 80, 30L, TimeUnit.SECONDS);
    }

    public void doStart(List<PeClearOrder> peClearOrderlist) {
        if (null == peClearOrderlist || peClearOrderlist.isEmpty()) {
            return;
        }
        this.peClearOrderService.saveClearOrderSend(peClearOrderlist);
    }

    protected void updateEnd() {
        try {
            this.updateEtc(this.peProtEtcInfo);
        }
        catch (Exception e) {
            this.logger.error("AbstractProcessService.updateEnd.e", (Throwable)e);
        }
        this.etcInfoProcessService.unLockExcute(this.peProtEtcInfo.getProtEtcSeqno(), this.peProtEtcInfo.getTenantCode());
        this.shutdownErrorExecutor();
        this.shutdownPollExecutor();
        this.shutdownPutExecutor();
    }

    private void updateEtc(PeProtEtcInfo peProtEtcInfo) {
        peProtEtcInfo.setProtEtcInfoSeqno(this.createUUIDString());
        if (PortEtcType.AS.getCode().equals(peProtEtcInfo.getProtEtcType()) && StringUtils.isNotBlank((String)peProtEtcInfo.getProtEtcTime())) {
            try {
                CronExpression cron = new CronExpression(peProtEtcInfo.getProtEtcTime());
                peProtEtcInfo.setProtEtcPreTime(cron.getNextValidTimeAfter(new Date()));
            }
            catch (Exception e) {
                this.logger.error("AbstractProcessService.updateEtcInfo.e", (Throwable)e);
            }
        } else {
            peProtEtcInfo.setProtEtcPreTime(new Date());
        }
        PeProtEtcInfoDomain peProtEtcInfoDomain = this.makeEtcInfoDomain(peProtEtcInfo);
        if (null == peProtEtcInfoDomain) {
            throw new ApiException("AbstractProcessService.updateEtcInfo.peProtEtcInfoDomain", "null");
        }
        this.peProtEtcService.updateProtEtcInfo(peProtEtcInfoDomain);
        this.etcInfoProcessService.addCache(peProtEtcInfo);
    }

    private PeProtEtcInfoDomain makeEtcInfoDomain(PeProtEtcInfo peProtEtcInfo) {
        if (null == peProtEtcInfo) {
            return null;
        }
        PeProtEtcInfoDomain peProtEtcInfoDomain = new PeProtEtcInfoDomain();
        try {
            BeanUtils.copyAllPropertys((Object)peProtEtcInfoDomain, (Object)peProtEtcInfo);
            peProtEtcInfoDomain.setProtEtcRelTime(new Date());
            return peProtEtcInfoDomain;
        }
        catch (Exception e) {
            this.logger.error("AbstractProcessService.makeEtcInfoDomain.e", (Throwable)e);
            return null;
        }
    }

    protected String getKey(List<PeClearOrder> t) {
        if (null == t || t.isEmpty()) {
            return "";
        }
        String key = t.get(0).getProtEtcInfoSeqno() + "-" + t.get(0).getTenantCode();
        return key;
    }

    protected boolean checkErrorEx(List<PeClearOrder> t) {
        return false;
    }
}

