/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.paytradeengine.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.paytradeengine.dao.PteBalancelistMapper;
import com.yqbsoft.laser.service.paytradeengine.domain.PteBalancelistDomain;
import com.yqbsoft.laser.service.paytradeengine.domain.PteBalancelistReDomain;
import com.yqbsoft.laser.service.paytradeengine.model.PteBalancelist;
import com.yqbsoft.laser.service.paytradeengine.service.PteBalancelistService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PteBalancelistServiceImpl
extends BaseServiceImpl
implements PteBalancelistService {
    private static final String SYS_CODE = "pte.PteBalancelistServiceImpl";
    private PteBalancelistMapper pteBalancelistMapper;

    public void setPteBalancelistMapper(PteBalancelistMapper pteBalancelistMapper) {
        this.pteBalancelistMapper = pteBalancelistMapper;
    }

    private Date getSysDate() {
        try {
            return this.pteBalancelistMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("pte.PteBalancelistServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkBalancelist(PteBalancelistDomain pteBalancelistDomain) {
        if (null == pteBalancelistDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)pteBalancelistDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setBalancelistDefault(PteBalancelist pteBalancelist) {
        if (null == pteBalancelist) {
            return;
        }
        if (null == pteBalancelist.getDataState()) {
            pteBalancelist.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == pteBalancelist.getGmtCreate()) {
            pteBalancelist.setGmtCreate(date);
        }
        pteBalancelist.setGmtModified(date);
        if (StringUtils.isBlank((String)pteBalancelist.getBalancelistCode())) {
            pteBalancelist.setBalancelistCode(this.getNo(null, "PteBalancelist", "pteBalancelist", pteBalancelist.getTenantCode()));
        }
    }

    private int getBalancelistMaxCode() {
        int code = 0;
        try {
            return this.pteBalancelistMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("pte.PteBalancelistServiceImpl.getBalancelistMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setBalancelistUpdataDefault(PteBalancelist pteBalancelist) {
        if (null == pteBalancelist) {
            return;
        }
        pteBalancelist.setGmtModified(this.getSysDate());
    }

    private void saveBalancelistModel(PteBalancelist pteBalancelist) throws ApiException {
        if (null == pteBalancelist) {
            return;
        }
        try {
            this.pteBalancelistMapper.insert(pteBalancelist);
        }
        catch (Exception e) {
            throw new ApiException("pte.PteBalancelistServiceImpl.saveBalancelistModel.ex", (Throwable)e);
        }
    }

    private void saveBalancelistBatchModel(List<PteBalancelist> pteBalancelistList) throws ApiException {
        if (null == pteBalancelistList || pteBalancelistList.isEmpty()) {
            return;
        }
        try {
            this.pteBalancelistMapper.insertBatch(pteBalancelistList);
        }
        catch (Exception e) {
            throw new ApiException("pte.PteBalancelistServiceImpl.saveBalancelistBatchModel.ex", (Throwable)e);
        }
    }

    private PteBalancelist getBalancelistModelById(Integer balancelistId) {
        if (null == balancelistId) {
            return null;
        }
        try {
            return this.pteBalancelistMapper.selectByPrimaryKey(balancelistId);
        }
        catch (Exception e) {
            this.logger.error("pte.PteBalancelistServiceImpl.getBalancelistModelById", (Throwable)e);
            return null;
        }
    }

    private PteBalancelist getBalancelistModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.pteBalancelistMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("pte.PteBalancelistServiceImpl.getBalancelistModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delBalancelistModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.pteBalancelistMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pte.PteBalancelistServiceImpl.delBalancelistModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pte.PteBalancelistServiceImpl.delBalancelistModelByCode.num");
        }
    }

    private void deleteBalancelistModel(Integer balancelistId) throws ApiException {
        if (null == balancelistId) {
            return;
        }
        int i = 0;
        try {
            i = this.pteBalancelistMapper.deleteByPrimaryKey(balancelistId);
        }
        catch (Exception e) {
            throw new ApiException("pte.PteBalancelistServiceImpl.deleteBalancelistModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pte.PteBalancelistServiceImpl.deleteBalancelistModel.num");
        }
    }

    private void updateBalancelistModel(PteBalancelist pteBalancelist) throws ApiException {
        if (null == pteBalancelist) {
            return;
        }
        int i = 0;
        try {
            i = this.pteBalancelistMapper.updateByPrimaryKey(pteBalancelist);
        }
        catch (Exception e) {
            throw new ApiException("pte.PteBalancelistServiceImpl.updateBalancelistModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pte.PteBalancelistServiceImpl.updateBalancelistModel.num");
        }
    }

    private void updateStateBalancelistModel(Integer balancelistId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == balancelistId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("balancelistId", balancelistId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.pteBalancelistMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("pte.PteBalancelistServiceImpl.updateStateBalancelistModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pte.PteBalancelistServiceImpl.updateStateBalancelistModel.null");
        }
    }

    private void updateStateBalancelistModelByCode(String tenantCode, String balancelistCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)balancelistCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("balancelistCode", balancelistCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.pteBalancelistMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pte.PteBalancelistServiceImpl.updateStateBalancelistModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pte.PteBalancelistServiceImpl.updateStateBalancelistModelByCode.null");
        }
    }

    private PteBalancelist makeBalancelist(PteBalancelistDomain pteBalancelistDomain, PteBalancelist pteBalancelist) {
        if (null == pteBalancelistDomain) {
            return null;
        }
        if (null == pteBalancelist) {
            pteBalancelist = new PteBalancelist();
        }
        try {
            BeanUtils.copyAllPropertys((Object)pteBalancelist, (Object)pteBalancelistDomain);
            return pteBalancelist;
        }
        catch (Exception e) {
            this.logger.error("pte.PteBalancelistServiceImpl.makeBalancelist", (Throwable)e);
            return null;
        }
    }

    private PteBalancelistReDomain makePteBalancelistReDomain(PteBalancelist pteBalancelist) {
        if (null == pteBalancelist) {
            return null;
        }
        PteBalancelistReDomain pteBalancelistReDomain = new PteBalancelistReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)pteBalancelistReDomain, (Object)pteBalancelist);
            return pteBalancelistReDomain;
        }
        catch (Exception e) {
            this.logger.error("pte.PteBalancelistServiceImpl.makePteBalancelistReDomain", (Throwable)e);
            return null;
        }
    }

    private List<PteBalancelist> queryBalancelistModelPage(Map<String, Object> parammap) {
        try {
            return this.pteBalancelistMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("pte.PteBalancelistServiceImpl.queryBalancelistModel", (Throwable)e);
            return null;
        }
    }

    private int countBalancelist(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.pteBalancelistMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("pte.PteBalancelistServiceImpl.countBalancelist", (Throwable)e);
        }
        return i;
    }

    private PteBalancelist createPteBalancelist(PteBalancelistDomain pteBalancelistDomain) {
        String msg = this.checkBalancelist(pteBalancelistDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pte.PteBalancelistServiceImpl.saveBalancelist.checkBalancelist", msg);
        }
        PteBalancelist pteBalancelist = this.makeBalancelist(pteBalancelistDomain, null);
        this.setBalancelistDefault(pteBalancelist);
        return pteBalancelist;
    }

    @Override
    public String saveBalancelist(PteBalancelistDomain pteBalancelistDomain) throws ApiException {
        PteBalancelist pteBalancelist = this.createPteBalancelist(pteBalancelistDomain);
        this.saveBalancelistModel(pteBalancelist);
        return pteBalancelist.getBalancelistCode();
    }

    @Override
    public String saveBalancelistBatch(List<PteBalancelistDomain> pteBalancelistDomainList) throws ApiException {
        if (null == pteBalancelistDomainList || pteBalancelistDomainList.isEmpty()) {
            return null;
        }
        ArrayList<PteBalancelist> pteBalancelistList = new ArrayList<PteBalancelist>();
        String code = "";
        for (PteBalancelistDomain pteBalancelistDomain : pteBalancelistDomainList) {
            PteBalancelist pteBalancelist = this.createPteBalancelist(pteBalancelistDomain);
            code = pteBalancelist.getBalancelistCode();
            pteBalancelistList.add(pteBalancelist);
        }
        this.saveBalancelistBatchModel(pteBalancelistList);
        return code;
    }

    @Override
    public void updateBalancelistState(Integer balancelistId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == balancelistId) {
            return;
        }
        this.updateStateBalancelistModel(balancelistId, dataState, oldDataState, map);
    }

    @Override
    public void updateBalancelistStateByCode(String tenantCode, String balancelistCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)balancelistCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateBalancelistModelByCode(tenantCode, balancelistCode, dataState, oldDataState, map);
    }

    @Override
    public void updateBalancelist(PteBalancelistDomain pteBalancelistDomain) throws ApiException {
        String msg = this.checkBalancelist(pteBalancelistDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pte.PteBalancelistServiceImpl.updateBalancelist.checkBalancelist", msg);
        }
        PteBalancelist oldPteBalancelist = this.getBalancelistModelById(pteBalancelistDomain.getBalancelistId());
        if (null == oldPteBalancelist) {
            throw new ApiException("pte.PteBalancelistServiceImpl.updateBalancelist.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        PteBalancelist pteBalancelist = this.makeBalancelist(pteBalancelistDomain, oldPteBalancelist);
        this.setBalancelistUpdataDefault(pteBalancelist);
        this.updateBalancelistModel(pteBalancelist);
    }

    @Override
    public PteBalancelist getBalancelist(Integer balancelistId) {
        if (null == balancelistId) {
            return null;
        }
        return this.getBalancelistModelById(balancelistId);
    }

    @Override
    public void deleteBalancelist(Integer balancelistId) throws ApiException {
        if (null == balancelistId) {
            return;
        }
        this.deleteBalancelistModel(balancelistId);
    }

    @Override
    public QueryResult<PteBalancelist> queryBalancelistPage(Map<String, Object> map) {
        List<PteBalancelist> pteBalancelistList = this.queryBalancelistModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countBalancelist(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(pteBalancelistList);
        return queryResult;
    }

    @Override
    public PteBalancelist getBalancelistByCode(String tenantCode, String balancelistCode) throws ApiException {
        if (StringUtils.isBlank((String)balancelistCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("balancelistCode", balancelistCode);
        return this.getBalancelistModelByCode(map);
    }

    @Override
    public void deleteBalancelistByCode(String tenantCode, String balancelistCode) throws ApiException {
        if (StringUtils.isBlank((String)balancelistCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("balancelistCode", balancelistCode);
        this.delBalancelistModelByCode(map);
    }
}

