/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.paytradeengine.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.paytradeengine.dao.PteBalanceMapper;
import com.yqbsoft.laser.service.paytradeengine.domain.PteBalanceDomain;
import com.yqbsoft.laser.service.paytradeengine.domain.PteBalanceReDomain;
import com.yqbsoft.laser.service.paytradeengine.model.PteBalance;
import com.yqbsoft.laser.service.paytradeengine.service.PteBalanceService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PteBalanceServiceImpl
extends BaseServiceImpl
implements PteBalanceService {
    private static final String SYS_CODE = "pte.PteBalanceServiceImpl";
    private PteBalanceMapper pteBalanceMapper;

    public void setPteBalanceMapper(PteBalanceMapper pteBalanceMapper) {
        this.pteBalanceMapper = pteBalanceMapper;
    }

    private Date getSysDate() {
        try {
            return this.pteBalanceMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("pte.PteBalanceServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkBalance(PteBalanceDomain pteBalanceDomain) {
        if (null == pteBalanceDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)pteBalanceDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setBalanceDefault(PteBalance pteBalance) {
        if (null == pteBalance) {
            return;
        }
        if (null == pteBalance.getDataState()) {
            pteBalance.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == pteBalance.getGmtCreate()) {
            pteBalance.setGmtCreate(date);
        }
        pteBalance.setGmtModified(date);
        if (StringUtils.isBlank((String)pteBalance.getBalanceCode())) {
            pteBalance.setBalanceCode(this.getNo(null, "PteBalance", "pteBalance", pteBalance.getTenantCode()));
        }
    }

    private int getBalanceMaxCode() {
        int code = 0;
        try {
            return this.pteBalanceMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("pte.PteBalanceServiceImpl.getBalanceMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setBalanceUpdataDefault(PteBalance pteBalance) {
        if (null == pteBalance) {
            return;
        }
        pteBalance.setGmtModified(this.getSysDate());
    }

    private void saveBalanceModel(PteBalance pteBalance) throws ApiException {
        if (null == pteBalance) {
            return;
        }
        try {
            this.pteBalanceMapper.insert(pteBalance);
        }
        catch (Exception e) {
            throw new ApiException("pte.PteBalanceServiceImpl.saveBalanceModel.ex", (Throwable)e);
        }
    }

    private void saveBalanceBatchModel(List<PteBalance> pteBalanceList) throws ApiException {
        if (null == pteBalanceList || pteBalanceList.isEmpty()) {
            return;
        }
        try {
            this.pteBalanceMapper.insertBatch(pteBalanceList);
        }
        catch (Exception e) {
            throw new ApiException("pte.PteBalanceServiceImpl.saveBalanceBatchModel.ex", (Throwable)e);
        }
    }

    private PteBalance getBalanceModelById(Integer balanceId) {
        if (null == balanceId) {
            return null;
        }
        try {
            return this.pteBalanceMapper.selectByPrimaryKey(balanceId);
        }
        catch (Exception e) {
            this.logger.error("pte.PteBalanceServiceImpl.getBalanceModelById", (Throwable)e);
            return null;
        }
    }

    private PteBalance getBalanceModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.pteBalanceMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("pte.PteBalanceServiceImpl.getBalanceModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delBalanceModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.pteBalanceMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pte.PteBalanceServiceImpl.delBalanceModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pte.PteBalanceServiceImpl.delBalanceModelByCode.num");
        }
    }

    private void deleteBalanceModel(Integer balanceId) throws ApiException {
        if (null == balanceId) {
            return;
        }
        int i = 0;
        try {
            i = this.pteBalanceMapper.deleteByPrimaryKey(balanceId);
        }
        catch (Exception e) {
            throw new ApiException("pte.PteBalanceServiceImpl.deleteBalanceModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pte.PteBalanceServiceImpl.deleteBalanceModel.num");
        }
    }

    private void updateBalanceModel(PteBalance pteBalance) throws ApiException {
        if (null == pteBalance) {
            return;
        }
        int i = 0;
        try {
            i = this.pteBalanceMapper.updateByPrimaryKey(pteBalance);
        }
        catch (Exception e) {
            throw new ApiException("pte.PteBalanceServiceImpl.updateBalanceModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pte.PteBalanceServiceImpl.updateBalanceModel.num");
        }
    }

    private void updateStateBalanceModel(Integer balanceId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == balanceId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("balanceId", balanceId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.pteBalanceMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("pte.PteBalanceServiceImpl.updateStateBalanceModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pte.PteBalanceServiceImpl.updateStateBalanceModel.null");
        }
    }

    private void updateStateBalanceModelByCode(String tenantCode, String balanceCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)balanceCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("balanceCode", balanceCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.pteBalanceMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pte.PteBalanceServiceImpl.updateStateBalanceModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pte.PteBalanceServiceImpl.updateStateBalanceModelByCode.null");
        }
    }

    private PteBalance makeBalance(PteBalanceDomain pteBalanceDomain, PteBalance pteBalance) {
        if (null == pteBalanceDomain) {
            return null;
        }
        if (null == pteBalance) {
            pteBalance = new PteBalance();
        }
        try {
            BeanUtils.copyAllPropertys((Object)pteBalance, (Object)pteBalanceDomain);
            return pteBalance;
        }
        catch (Exception e) {
            this.logger.error("pte.PteBalanceServiceImpl.makeBalance", (Throwable)e);
            return null;
        }
    }

    private PteBalanceReDomain makePteBalanceReDomain(PteBalance pteBalance) {
        if (null == pteBalance) {
            return null;
        }
        PteBalanceReDomain pteBalanceReDomain = new PteBalanceReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)pteBalanceReDomain, (Object)pteBalance);
            return pteBalanceReDomain;
        }
        catch (Exception e) {
            this.logger.error("pte.PteBalanceServiceImpl.makePteBalanceReDomain", (Throwable)e);
            return null;
        }
    }

    private List<PteBalance> queryBalanceModelPage(Map<String, Object> parammap) {
        try {
            return this.pteBalanceMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("pte.PteBalanceServiceImpl.queryBalanceModel", (Throwable)e);
            return null;
        }
    }

    private int countBalance(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.pteBalanceMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("pte.PteBalanceServiceImpl.countBalance", (Throwable)e);
        }
        return i;
    }

    private PteBalance createPteBalance(PteBalanceDomain pteBalanceDomain) {
        String msg = this.checkBalance(pteBalanceDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pte.PteBalanceServiceImpl.saveBalance.checkBalance", msg);
        }
        PteBalance pteBalance = this.makeBalance(pteBalanceDomain, null);
        this.setBalanceDefault(pteBalance);
        return pteBalance;
    }

    @Override
    public String saveBalance(PteBalanceDomain pteBalanceDomain) throws ApiException {
        PteBalance pteBalance = this.createPteBalance(pteBalanceDomain);
        this.saveBalanceModel(pteBalance);
        return pteBalance.getBalanceCode();
    }

    @Override
    public String saveBalanceBatch(List<PteBalanceDomain> pteBalanceDomainList) throws ApiException {
        if (null == pteBalanceDomainList || pteBalanceDomainList.isEmpty()) {
            return null;
        }
        ArrayList<PteBalance> pteBalanceList = new ArrayList<PteBalance>();
        String code = "";
        for (PteBalanceDomain pteBalanceDomain : pteBalanceDomainList) {
            PteBalance pteBalance = this.createPteBalance(pteBalanceDomain);
            code = pteBalance.getBalanceCode();
            pteBalanceList.add(pteBalance);
        }
        this.saveBalanceBatchModel(pteBalanceList);
        return code;
    }

    @Override
    public void updateBalanceState(Integer balanceId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == balanceId) {
            return;
        }
        this.updateStateBalanceModel(balanceId, dataState, oldDataState, map);
    }

    @Override
    public void updateBalanceStateByCode(String tenantCode, String balanceCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)balanceCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateBalanceModelByCode(tenantCode, balanceCode, dataState, oldDataState, map);
    }

    @Override
    public void updateBalance(PteBalanceDomain pteBalanceDomain) throws ApiException {
        String msg = this.checkBalance(pteBalanceDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pte.PteBalanceServiceImpl.updateBalance.checkBalance", msg);
        }
        PteBalance oldPteBalance = this.getBalanceModelById(pteBalanceDomain.getBalanceId());
        if (null == oldPteBalance) {
            throw new ApiException("pte.PteBalanceServiceImpl.updateBalance.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        PteBalance pteBalance = this.makeBalance(pteBalanceDomain, oldPteBalance);
        this.setBalanceUpdataDefault(pteBalance);
        this.updateBalanceModel(pteBalance);
    }

    @Override
    public PteBalance getBalance(Integer balanceId) {
        if (null == balanceId) {
            return null;
        }
        return this.getBalanceModelById(balanceId);
    }

    @Override
    public void deleteBalance(Integer balanceId) throws ApiException {
        if (null == balanceId) {
            return;
        }
        this.deleteBalanceModel(balanceId);
    }

    @Override
    public QueryResult<PteBalance> queryBalancePage(Map<String, Object> map) {
        List<PteBalance> pteBalanceList = this.queryBalanceModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countBalance(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(pteBalanceList);
        return queryResult;
    }

    @Override
    public PteBalance getBalanceByCode(String tenantCode, String balanceCode) throws ApiException {
        if (StringUtils.isBlank((String)balanceCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("balanceCode", balanceCode);
        return this.getBalanceModelByCode(map);
    }

    @Override
    public void deleteBalanceByCode(String tenantCode, String balanceCode) throws ApiException {
        if (StringUtils.isBlank((String)balanceCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("balanceCode", balanceCode);
        this.delBalanceModelByCode(map);
    }
}

