/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.permis.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.permis.PermisConstants;
import com.yqbsoft.laser.service.permis.dao.UpMenuMapper;
import com.yqbsoft.laser.service.permis.domain.UpMenuDomainBean;
import com.yqbsoft.laser.service.permis.model.UpMenu;
import com.yqbsoft.laser.service.permis.service.MenuService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MenuServiceImpl
extends BaseServiceImpl
implements MenuService {
    public static final String SYS_CODE = "up.PERMIS.MenuServiceImpl";
    private UpMenuMapper upMenuMapper;

    public UpMenuMapper getUpMenuMapper() {
        return this.upMenuMapper;
    }

    public void setUpMenuMapper(UpMenuMapper upMenuMapper) {
        this.upMenuMapper = upMenuMapper;
    }

    @Override
    public void saveMenu(UpMenu upMenu) throws ApiException {
        String msg = this.check(upMenu);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("up.PERMIS.MenuServiceImpl.saveMenu.null", msg);
        }
        this.setDefault(upMenu);
        this.saveMenuModel(upMenu);
    }

    private void saveMenuModel(UpMenu upMenu) throws ApiException {
        if (upMenu == null) {
            return;
        }
        try {
            this.upMenuMapper.insert(upMenu);
        }
        catch (Exception e) {
            throw new ApiException("up.PERMIS.MenuServiceImpl.saveMenuModel.ex");
        }
    }

    private String check(UpMenu upMenu) {
        if (null == upMenu) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)upMenu.getMenuName())) {
            msg = msg + "\u83dc\u5355\u540d\u79f0\u4e3a\u7a7a;";
        }
        return msg;
    }

    private Date getSysDate() {
        try {
            return this.upMenuMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("up.PERMIS.MenuServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private void setDefault(UpMenu upMenu) {
        if (null == upMenu) {
            return;
        }
        if (null == upMenu.getDataState()) {
            upMenu.setDataState(0);
        }
        if (null == upMenu.getGmtCreate()) {
            upMenu.setGmtCreate(this.getSysDate());
        }
        if (StringUtils.isBlank((String)upMenu.getMenuCode())) {
            int code = this.getMaxcode();
            upMenu.setMenuCode(this.makeMaxCode8(++code));
        }
    }

    private int getMaxcode() {
        int code = 0;
        try {
            code = this.upMenuMapper.getMaxCode();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return code;
    }

    private List<UpMenu> queryMenu(Map<String, Object> parammap) {
        try {
            return this.upMenuMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("", (Throwable)e);
            return null;
        }
    }

    @Override
    public UpMenu getMenu(Integer menuId) {
        return this.upMenuMapper.selectByPrimaryKey(menuId);
    }

    @Override
    public void updateMenu(UpMenuDomainBean upMenuDomainBean) throws ApiException {
        UpMenu upMenu = this.getMenu(upMenuDomainBean.getMenuId());
        if (upMenu == null) {
            throw new ApiException("up.PERMIS.MenuServiceImpl.updateMenu.exsit", "\u8bb0\u5f55\u4e0d\u5b58\u5728");
        }
        String msg = this.check(upMenu = this.makeModel(upMenu, upMenuDomainBean));
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("up.PERMIS.MenuServiceImpl.updateMenu.null", msg);
        }
        this.setUpDefault(upMenu);
        this.updateMenuModel(upMenu);
    }

    private void updateMenuModel(UpMenu upMenu) throws ApiException {
        if (null == upMenu) {
            return;
        }
        try {
            this.upMenuMapper.updateByPrimaryKey(upMenu);
        }
        catch (Exception e) {
            throw new ApiException("up.PERMIS.MenuServiceImpl.updateMenuModel.ex");
        }
    }

    private void setUpDefault(UpMenu upMenu) {
        if (null == upMenu) {
            return;
        }
        upMenu.setGmtModified(this.getSysDate());
    }

    private UpMenu makeModel(UpMenu upMenu, UpMenuDomainBean upMenuDomainBean) {
        if (upMenuDomainBean == null) {
            return null;
        }
        if (upMenu == null) {
            upMenu = new UpMenu();
        }
        try {
            BeanUtils.copyAllPropertys((Object)upMenu, (Object)upMenuDomainBean);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return upMenu;
    }

    @Override
    public List<UpMenu> queryUpMenu(Map<String, Object> map) {
        return this.queryMenu(map);
    }

    @Override
    public void deleteMenu(Integer menuId) {
        this.upMenuMapper.deleteByPrimaryKey(menuId);
    }

    @Override
    public QueryResult<UpMenu> queryUpMenuPage(Map<String, Object> map) {
        QueryResult queryResult = new QueryResult();
        List<UpMenu> list = this.queryMenu(map);
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.count(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(list);
        return queryResult;
    }

    private int count(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.upMenuMapper.count(map);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return i;
    }

    @Override
    public List<UpMenuDomainBean> queryUpMenuTree(String appmanageIcode, String menuParentCode) {
        ArrayList<UpMenuDomainBean> upMenuDomainBeanList = new ArrayList<UpMenuDomainBean>();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("appmanageIcode", appmanageIcode);
        map.put("menuParentCode", menuParentCode);
        map.put("order", true);
        map.put("menuShow", 0);
        List<UpMenu> upMenuList = this.queryMenu(map);
        if (upMenuList == null || upMenuList.isEmpty()) {
            return null;
        }
        for (UpMenu upMenu : upMenuList) {
            UpMenuDomainBean upMenuDomainBean = this.getUpMenuDomain(upMenu);
            upMenuDomainBean.setChildren(this.queryUpMenuTree(upMenu.getAppmanageIcode(), upMenu.getMenuCode()));
            upMenuDomainBeanList.add(upMenuDomainBean);
        }
        return upMenuDomainBeanList;
    }

    @Override
    public Map<String, String> queryMenuCodeByUrl(String appmanageIcode, String menuParentCode) {
        List<UpMenuDomainBean> list = this.queryUpMenuTree(appmanageIcode, menuParentCode);
        if (list == null || list.isEmpty()) {
            return null;
        }
        HashMap<String, String> menuCodeMap = new HashMap<String, String>();
        for (UpMenuDomainBean upMenuDomainBean : list) {
            this.putMenuCodeMap(upMenuDomainBean.getChildren(), menuCodeMap, upMenuDomainBean.getMenuCode() + "_" + upMenuDomainBean.getMenuAction());
            menuCodeMap.put(upMenuDomainBean.getMenuAction(), upMenuDomainBean.getMenuCode() + "_" + upMenuDomainBean.getMenuAction());
        }
        return menuCodeMap;
    }

    private void putMenuCodeMap(List<UpMenuDomainBean> list, Map<String, String> menuCodeMap, String parentMenuCode) {
        if (list == null || list.isEmpty()) {
            return;
        }
        for (UpMenuDomainBean upMenuDomainBean : list) {
            if (upMenuDomainBean.getChildren() != null && !upMenuDomainBean.getChildren().isEmpty()) {
                this.putMenuCodeMap(upMenuDomainBean.getChildren(), menuCodeMap, parentMenuCode);
            }
            if (!StringUtils.isNotBlank((String)upMenuDomainBean.getMenuAction())) continue;
            menuCodeMap.put(upMenuDomainBean.getMenuAction(), parentMenuCode);
        }
    }

    private UpMenuDomainBean getUpMenuDomain(UpMenu upMenu) {
        UpMenuDomainBean upMenuDomainBean = new UpMenuDomainBean();
        try {
            BeanUtils.copyAllPropertys((Object)upMenuDomainBean, (Object)upMenu);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return upMenuDomainBean;
    }

    @Override
    public void updateMenuRelease(Integer menuId) {
        UpMenu upMenu = this.getMenu(menuId);
        this.releaseMenu(upMenu);
    }

    @Override
    public void updateMenuReleaseByCode(Map<String, Object> map) {
        List<UpMenu> menuList = this.queryUpMenu(map);
        if (menuList != null && !menuList.isEmpty()) {
            this.releaseMenu(menuList.get(0));
        }
    }

    private void releaseMenu(UpMenu upMenu) {
        if (upMenu == null) {
            return;
        }
        upMenu.setDataState(PermisConstants.MENU_STATE_1);
        this.updateMenuModel(upMenu);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("modelCode", upMenu.getMenuDetailsCode());
        map.put("OUT_PUT", upMenu.getMenuJspath() + upMenu.getMenuAction());
        map.put("menuCode", upMenu.getMenuCode());
        map.put("menuType", upMenu.getMenuType());
        map.put("upMenu", upMenu);
        HashMap<String, String> paramsMap = new HashMap<String, String>();
        paramsMap.put("map", JsonUtil.buildNormalBinder().toJson(map));
        this.internalInvoke("cms.model.updateReleaseModel", paramsMap);
    }
}

