/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.permis.service.impl;

import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.permis.PermisConstants;
import com.yqbsoft.laser.service.permis.dao.UpOpPermissionMapper;
import com.yqbsoft.laser.service.permis.model.UpOpPermission;
import com.yqbsoft.laser.service.permis.service.OpPermissionService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class OpPermissionServiceImpl
extends BaseServiceImpl
implements OpPermissionService {
    public static final String SYS_CODE = "up.PERMIS.OpPermissionServiceImpl";
    private UpOpPermissionMapper upOpPermissionMapper;

    public UpOpPermissionMapper getUpOpPermissionMapper() {
        return this.upOpPermissionMapper;
    }

    public void setUpOpPermissionMapper(UpOpPermissionMapper upOpPermissionMapper) {
        this.upOpPermissionMapper = upOpPermissionMapper;
    }

    @Override
    public void saveOpPermission(UpOpPermission upOpPermission) {
        this.upOpPermissionMapper.insert(upOpPermission);
    }

    private List<UpOpPermission> queryOpPermission(Map<String, Object> parammap) {
        try {
            return this.upOpPermissionMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("", (Throwable)e);
            return null;
        }
    }

    @Override
    public UpOpPermission getOpPermission(Integer opPermissionId) {
        return this.upOpPermissionMapper.selectByPrimaryKey(opPermissionId);
    }

    @Override
    public void updateOpPermission(UpOpPermission upOpPermission) {
        this.upOpPermissionMapper.updateByPrimaryKey(upOpPermission);
    }

    @Override
    public List<UpOpPermission> queryUpOpPermission(Map<String, Object> map) {
        return this.queryOpPermission(map);
    }

    @Override
    public QueryResult<UpOpPermission> queryOpPermissionPage(Map<String, Object> map) {
        List<UpOpPermission> upOpPermissionInfo = this.queryOpPermission(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countOpPermissionList(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(upOpPermissionInfo);
        return queryResult;
    }

    private int countOpPermissionList(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.upOpPermissionMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("up.PERMIS.OpPermissionServiceImpl.countUser", (Throwable)e);
        }
        return i;
    }

    @Override
    public void deleteOpPermission(Integer opPermissionId) {
        this.upOpPermissionMapper.deleteByPrimaryKey(opPermissionId);
    }

    @Override
    public Map<String, String> queryMuserPermission(String appmanageIcode, String roleCode, String userCode) {
        List<UpOpPermission> muserPermisList = null;
        try {
            muserPermisList = this.upOpPermissionMapper.query(this.getQueryParamMap("appmanageIcode,opPermissionType,opPermissionCode", new Object[]{appmanageIcode, PermisConstants.PERMIS_TYPE_OPER, userCode}));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        List<UpOpPermission> rolePermisList = null;
        if (StringUtils.isNotBlank((String)roleCode)) {
            rolePermisList = this.upOpPermissionMapper.query(this.getQueryParamMap("appmanageIcode,opPermissionType,opPermissionCode", new Object[]{appmanageIcode, PermisConstants.PERMIS_TYPE_ROLE, roleCode}));
        }
        return this.setMuserPermis(muserPermisList, rolePermisList);
    }

    private Map<String, String> setMuserPermis(List<UpOpPermission> muserPermisList, List<UpOpPermission> rolePermisList) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (null != muserPermisList && !muserPermisList.isEmpty()) {
            Map<String, UpOpPermission> roleMap = this.getRoleMap(rolePermisList);
            this.setMuserPermission(map, muserPermisList, roleMap);
        }
        if (null != rolePermisList && !rolePermisList.isEmpty()) {
            for (UpOpPermission mod : rolePermisList) {
                if (null == mod.getOpPermissionState()) {
                    mod.setOpPermissionState(PermisConstants.USER_STATE_ROLE);
                }
                if (!PermisConstants.USER_STATE_ON.equals(mod.getOpPermissionState()) || !StringUtils.isBlank((String)((String)map.get(mod.getPermissionCode())))) continue;
                map.put(mod.getPermissionCode(), mod.getPermissionCode());
            }
        }
        return map;
    }

    private Map<String, UpOpPermission> getRoleMap(List<UpOpPermission> roleList) {
        HashMap<String, UpOpPermission> roleMap = new HashMap<String, UpOpPermission>();
        if (null != roleList && !roleList.isEmpty()) {
            for (UpOpPermission permission : roleList) {
                roleMap.put(permission.getPermissionCode(), permission);
            }
        }
        return roleMap;
    }

    private void setMuserPermission(Map<String, String> map, List<UpOpPermission> muserPermisList, Map<String, UpOpPermission> roleMap) {
        UpOpPermission roleMod = null;
        for (UpOpPermission mod : muserPermisList) {
            if (null != roleMap) {
                roleMod = roleMap.get(mod.getPermissionCode());
            }
            if (null == mod.getOpPermissionState()) {
                mod.setOpPermissionState(PermisConstants.USER_STATE_ROLE);
            }
            if (null != roleMod && PermisConstants.USER_STATE_ROLE.equals(mod.getOpPermissionState()) && PermisConstants.USER_STATE_ON.equals(roleMod.getOpPermissionState()) || PermisConstants.USER_STATE_ON.equals(mod.getOpPermissionState())) {
                map.put(mod.getPermissionCode(), mod.getPermissionCode());
            }
            if (null == roleMod) continue;
            roleMod.setOpPermissionState(mod.getOpPermissionState());
        }
    }

    @Override
    public void saveOpPermission(List<UpOpPermission> upOpPermissionList) {
        if (upOpPermissionList == null || upOpPermissionList.isEmpty()) {
            return;
        }
        for (UpOpPermission upOpPermission : upOpPermissionList) {
            this.saveOpPermission(upOpPermission);
        }
    }

    @Override
    public void updateOpPermission(List<UpOpPermission> upOpPermissionList) {
        if (upOpPermissionList == null || upOpPermissionList.isEmpty()) {
            return;
        }
        for (UpOpPermission upOpPermission : upOpPermissionList) {
            this.updateOpPermission(upOpPermission);
        }
    }
}

