/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.permis.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.permis.dao.UpRoleMapper;
import com.yqbsoft.laser.service.permis.domain.UpRoleDomainBean;
import com.yqbsoft.laser.service.permis.model.UpRole;
import com.yqbsoft.laser.service.permis.service.RoleService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RoleServiceImpl
extends BaseServiceImpl
implements RoleService {
    public static final String SYS_CODE = "up.PERMIS.RoleServiceImpl";
    private UpRoleMapper upRoleMapper;

    public UpRoleMapper getUpRoleMapper() {
        return this.upRoleMapper;
    }

    public void setUpRoleMapper(UpRoleMapper upRoleMapper) {
        this.upRoleMapper = upRoleMapper;
    }

    @Override
    public void saveRole(UpRoleDomainBean upRoleDomainBean) throws ApiException {
        UpRole upRole = new UpRole();
        String msg = this.check(upRole = this.makeModel(upRole, upRoleDomainBean));
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("up.PERMIS.RoleServiceImpl.saveRole.check", msg);
        }
        this.setInsertDefaultValue(upRole);
        this.insertRole(upRole);
    }

    private UpRole makeModel(UpRole upRole, UpRoleDomainBean upRoleDomainBean) {
        if (upRoleDomainBean == null) {
            return null;
        }
        if (upRole == null) {
            upRole = new UpRole();
        }
        try {
            BeanUtils.copyAllPropertys((Object)upRole, (Object)upRoleDomainBean);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return upRole;
    }

    private String check(UpRole upRole) {
        if (null == upRole) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)upRole.getRoleName())) {
            msg = msg + "RoleName\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setInsertDefaultValue(UpRole upRole) {
        if (null == upRole) {
            return;
        }
        if (null == upRole.getDataState()) {
            upRole.setDataState(0);
        }
        if (null == upRole.getGmtCreate()) {
            upRole.setGmtCreate(this.getSysDate());
        }
        if (StringUtils.isBlank((String)upRole.getRoleCode())) {
            int code = this.getMaxcode();
            upRole.setRoleCode(this.makeMaxCode(++code, 3));
        }
    }

    private int getMaxcode() {
        int code = 0;
        try {
            code = this.upRoleMapper.getMaxCode();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return code;
    }

    private Date getSysDate() {
        try {
            return this.upRoleMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("up.PERMIS.RoleServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private void insertRole(UpRole upRole) throws ApiException {
        try {
            this.upRoleMapper.insert(upRole);
        }
        catch (Exception e) {
            throw new ApiException("up.PERMIS.RoleServiceImpl.insertRole", "", (Throwable)e);
        }
    }

    private List<UpRole> queryRole(Map<String, Object> parammap) {
        try {
            return this.upRoleMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("", (Throwable)e);
            return null;
        }
    }

    @Override
    public UpRole getRole(Integer roleId) {
        return this.upRoleMapper.selectByPrimaryKey(roleId);
    }

    @Override
    public void updateRole(UpRoleDomainBean upRoleDomainBean) throws ApiException {
        UpRole upRole = this.getRole(upRoleDomainBean.getRoleId());
        if (upRole == null) {
            throw new ApiException("up.PERMIS.RoleServiceImpl.upRole.exsit", "\u8bb0\u5f55\u4e0d\u5b58\u5728");
        }
        String msg = this.check(upRole = this.makeModel(upRole, upRoleDomainBean));
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("up.PERMIS.RoleServiceImpl.updateRole.check", msg);
        }
        this.setUpdateDefaultValue(upRole);
        this.updateMqService(upRole);
    }

    private void setUpdateDefaultValue(UpRole upRole) {
        if (null == upRole) {
            return;
        }
        if (null == upRole.getDataState()) {
            upRole.setDataState(0);
        }
        if (null == upRole.getGmtModified()) {
            upRole.setGmtModified(this.getSysDate());
        }
    }

    private void updateMqService(UpRole upRole) throws ApiException {
        try {
            this.upRoleMapper.updateByPrimaryKey(upRole);
        }
        catch (Exception e) {
            throw new ApiException("up.PERMIS.RoleServiceImpl.updateMqService", "", (Throwable)e);
        }
    }

    @Override
    public QueryResult<UpRole> queryUpRoleList(Map<String, Object> map) {
        List<UpRole> UpRoleList = this.queryRole(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countRoleList(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(UpRoleList);
        return queryResult;
    }

    @Override
    public List<UpRole> queryUpRoleInfo(Map<String, Object> map) {
        List<UpRole> UpRoleList = this.queryRole(map);
        return UpRoleList;
    }

    private int countRoleList(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.upRoleMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("up.PERMIS.RoleServiceImpl.countRoleList", (Throwable)e);
        }
        return i;
    }

    @Override
    public void deleteRole(Integer roleId) {
        this.upRoleMapper.deleteByPrimaryKey(roleId);
    }

    @Override
    public void updateRoleState(Integer roleId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateRole(roleId, dataState, oldDataState);
    }

    private void updateStateRole(Integer roleId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == roleId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("roleId", roleId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.upRoleMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("up.PERMIS.RoleServiceImpl.updateStateMqserver.ex");
        }
        if (i <= 0) {
            throw new ApiException("up.PERMIS.RoleServiceImpl.updateStateMqserver.null");
        }
    }
}

