/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.permis.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.permis.PermisConstants;
import com.yqbsoft.laser.service.permis.dao.UpOpPermissionMapper;
import com.yqbsoft.laser.service.permis.domain.UpMenuDomainBean;
import com.yqbsoft.laser.service.permis.model.UpOpPermission;
import com.yqbsoft.laser.service.permis.model.UpRole;
import com.yqbsoft.laser.service.permis.service.OpPermissionService;
import com.yqbsoft.laser.service.permis.service.RoleService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.FreeMarkerTemplateUtils;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class OpPermissionServiceImpl
extends BaseServiceImpl
implements OpPermissionService {
    public static final String SYS_CODE = "up.PERMIS.OpPermissionServiceImpl";
    private UpOpPermissionMapper upOpPermissionMapper;
    private RoleService roleService;

    public void setRoleService(RoleService roleService) {
        this.roleService = roleService;
    }

    public UpOpPermissionMapper getUpOpPermissionMapper() {
        return this.upOpPermissionMapper;
    }

    public void setUpOpPermissionMapper(UpOpPermissionMapper upOpPermissionMapper) {
        this.upOpPermissionMapper = upOpPermissionMapper;
    }

    @Override
    public void saveOpPermission(UpOpPermission upOpPermission) {
        this.upOpPermissionMapper.insert(upOpPermission);
    }

    private List<UpOpPermission> queryOpPermission(Map<String, Object> parammap) {
        try {
            return this.upOpPermissionMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("", (Throwable)e);
            return null;
        }
    }

    @Override
    public UpOpPermission getOpPermission(Integer opPermissionId) {
        return this.upOpPermissionMapper.selectByPrimaryKey(opPermissionId);
    }

    @Override
    public void updateOpPermission(UpOpPermission upOpPermission) {
        this.upOpPermissionMapper.updateByPrimaryKey(upOpPermission);
    }

    @Override
    public List<UpOpPermission> queryUpOpPermission(Map<String, Object> map) {
        return this.queryOpPermission(map);
    }

    @Override
    public QueryResult<UpOpPermission> queryOpPermissionPage(Map<String, Object> map) {
        List<UpOpPermission> upOpPermissionInfo = this.queryOpPermission(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countOpPermissionList(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(upOpPermissionInfo);
        return queryResult;
    }

    private int countOpPermissionList(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.upOpPermissionMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("up.PERMIS.OpPermissionServiceImpl.countUser", (Throwable)e);
        }
        return i;
    }

    @Override
    public void deleteOpPermission(Integer opPermissionId) {
        this.upOpPermissionMapper.deleteByPrimaryKey(opPermissionId);
    }

    public Map<String, String> queryMuserPermissionAndAttach(Integer opPermissionApp, String roleCode, String userCode) {
        List<UpOpPermission> muserPermisList = null;
        try {
            muserPermisList = this.upOpPermissionMapper.query(this.getQueryParamMap("opPermissionApp,opPermissionType,opPermissionCode", new Object[]{opPermissionApp, PermisConstants.PERMIS_TYPE_OPER, userCode}));
        }
        catch (Exception e) {
            this.logger.error("up.PERMIS.OpPermissionServiceImpl.queryMuserPermissionTm.queryMuserPermissionTm", (Object)"e", (Throwable)e);
            return null;
        }
        List<UpOpPermission> rolePermisList = null;
        if (StringUtils.isNotBlank((String)roleCode)) {
            rolePermisList = this.upOpPermissionMapper.query(this.getQueryParamMap("opPermissionApp,opPermissionType,opPermissionCode", new Object[]{opPermissionApp, PermisConstants.PERMIS_TYPE_ROLE, roleCode}));
        }
        return this.permissionHandler(muserPermisList, rolePermisList, "menuCode,permissionAttach");
    }

    @Override
    public Map<String, String> queryMuserPermission(String tenantCode, String roleCode, String userCode) {
        return this.queryMuserPermissionTm(tenantCode, PermisConstants.PERMIS_APP_UM, roleCode, userCode);
    }

    @Override
    public Map<String, String> queryMuserPermissionTm(String tenantCode, String roleCode, String userCode) {
        return this.queryMuserPermissionTm(tenantCode, PermisConstants.PERMIS_APP_MM, roleCode, userCode);
    }

    private Map<String, String> queryMuserPermissionTm(String tenantCode, Integer opPermissionApp, String roleCode, String userCode) {
        Map<String, String> map;
        List<UpOpPermission> muserPermisList = null;
        try {
            muserPermisList = this.upOpPermissionMapper.query(this.getQueryParamMap("tenantCode,opPermissionApp,opPermissionType,opPermissionCode", new Object[]{tenantCode, opPermissionApp, PermisConstants.PERMIS_TYPE_OPER, userCode}));
        }
        catch (Exception e) {
            this.logger.error("up.PERMIS.OpPermissionServiceImpl.queryMuserPermissionTm.queryMuserPermissionTm", (Object)"e", (Throwable)e);
            return null;
        }
        List<UpOpPermission> rolePermisList = null;
        if (StringUtils.isNotBlank((String)roleCode) && ((rolePermisList = this.upOpPermissionMapper.query(this.getQueryParamMap("tenantCode,opPermissionApp,opPermissionType,opPermissionCode", new Object[]{tenantCode, opPermissionApp, PermisConstants.PERMIS_TYPE_ROLE, roleCode}))) == null || rolePermisList.isEmpty())) {
            rolePermisList = this.upOpPermissionMapper.query(this.getQueryParamMap("tenantCode,opPermissionApp,opPermissionType,opPermissionCode", new Object[]{"00000000", opPermissionApp, PermisConstants.PERMIS_TYPE_ROLE, roleCode}));
        }
        if ((map = this.permissionHandler(muserPermisList, rolePermisList, "menuCode")) == null || map.isEmpty()) {
            return map;
        }
        return this.permissionHandlerByTenant(tenantCode, opPermissionApp, map);
    }

    private Map<String, String> permissionHandlerByTenant(String tenantCode, Integer opPermissionApp, Map<String, String> map) {
        List<UpOpPermission> tenantPermisList = null;
        if (StringUtils.isNotBlank((String)tenantCode)) {
            tenantPermisList = this.upOpPermissionMapper.query(this.getQueryParamMap("tenantCode,opPermissionApp,opPermissionType,opPermissionCode", new Object[]{tenantCode, opPermissionApp, PermisConstants.PERMIS_TYPE_TENANT, tenantCode}));
        }
        if (tenantPermisList == null || tenantPermisList.isEmpty()) {
            return map;
        }
        HashMap<String, String> newMap = new HashMap<String, String>();
        for (UpOpPermission upOpPermission : tenantPermisList) {
            String menuCode = upOpPermission.getMenuCode();
            Integer opPermissionState = upOpPermission.getOpPermissionState();
            if (opPermissionState != PermisConstants.USER_STATE_ON) continue;
            newMap.put(menuCode, map.get(menuCode));
        }
        return newMap;
    }

    private Map<String, String> permissionHandler(List<UpOpPermission> muserPermisList, List<UpOpPermission> rolePermisList, String valueKey) {
        Map<String, Object> muserPermis = this.setMuserPermis(muserPermisList, rolePermisList);
        HashMap<String, String> retMap = new HashMap<String, String>();
        for (Map.Entry<String, Object> entry : muserPermis.entrySet()) {
            String[] valueKeys = valueKey.split(",");
            StringBuffer returnSb = new StringBuffer("");
            for (String key : valueKeys) {
                if (entry.getValue() == null) continue;
                Map map = (Map)entry.getValue();
                String value = (String)map.get(key);
                returnSb.append(value);
                returnSb.append("-");
            }
            if (returnSb.length() <= 0) continue;
            retMap.put(entry.getKey(), returnSb.substring(0, returnSb.lastIndexOf("-")));
        }
        return retMap;
    }

    private Map<String, Object> setMuserPermis(List<UpOpPermission> muserPermisList, List<UpOpPermission> rolePermisList) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (null != muserPermisList && !muserPermisList.isEmpty()) {
            Map<String, UpOpPermission> roleMap = this.getRoleMap(rolePermisList);
            this.setMuserPermission(map, muserPermisList, roleMap);
        }
        if (null != rolePermisList && !rolePermisList.isEmpty()) {
            for (UpOpPermission mod : rolePermisList) {
                if (null == mod.getOpPermissionState()) {
                    mod.setOpPermissionState(PermisConstants.USER_STATE_ROLE);
                }
                if (!PermisConstants.USER_STATE_ON.equals(mod.getOpPermissionState()) || map.get(mod.getMenuCode()) != null) continue;
                String permissionAttach = mod.getPermissionAttach();
                if (StringUtils.isBlank((String)permissionAttach)) {
                    permissionAttach = "";
                }
                HashMap<String, String> param = new HashMap<String, String>();
                param.put("permissionAttach", permissionAttach);
                param.put("menuCode", mod.getMenuCode());
                map.put(mod.getMenuCode(), param);
            }
        }
        return map;
    }

    private Map<String, UpOpPermission> getRoleMap(List<UpOpPermission> roleList) {
        HashMap<String, UpOpPermission> roleMap = new HashMap<String, UpOpPermission>();
        if (null != roleList && !roleList.isEmpty()) {
            for (UpOpPermission permission : roleList) {
                roleMap.put(permission.getMenuCode(), permission);
            }
        }
        return roleMap;
    }

    private void setMuserPermission(Map<String, Object> map, List<UpOpPermission> muserPermisList, Map<String, UpOpPermission> roleMap) {
        UpOpPermission roleMod = null;
        for (UpOpPermission mod : muserPermisList) {
            if (null != roleMap) {
                roleMod = roleMap.get(mod.getMenuCode());
            }
            if (null == mod.getOpPermissionState()) {
                mod.setOpPermissionState(PermisConstants.USER_STATE_ROLE);
            }
            if (null != roleMod && PermisConstants.USER_STATE_ROLE.equals(mod.getOpPermissionState()) && PermisConstants.USER_STATE_ON.equals(roleMod.getOpPermissionState()) || PermisConstants.USER_STATE_ON.equals(mod.getOpPermissionState())) {
                String permissionAttach = mod.getPermissionAttach();
                if (StringUtils.isBlank((String)permissionAttach)) {
                    permissionAttach = "";
                }
                HashMap<String, String> param = new HashMap<String, String>();
                param.put("permissionAttach", permissionAttach);
                param.put("menuCode", mod.getMenuCode());
                map.put(mod.getMenuCode(), param);
            }
            if (null == roleMod) continue;
            roleMod.setOpPermissionState(mod.getOpPermissionState());
        }
    }

    @Override
    public void saveOpPermission(List<UpOpPermission> upOpPermissionList) {
        if (upOpPermissionList == null || upOpPermissionList.isEmpty()) {
            return;
        }
        for (UpOpPermission upOpPermission : upOpPermissionList) {
            this.saveOpPermission(upOpPermission);
        }
    }

    @Override
    public void updateOpPermission(List<UpOpPermission> upOpPermissionList) {
        if (upOpPermissionList == null || upOpPermissionList.isEmpty()) {
            return;
        }
        for (UpOpPermission upOpPermission : upOpPermissionList) {
            this.updateOpPermission(upOpPermission);
        }
    }

    @Override
    public Map<String, Object> queryMuserPermissionDetail(String proappCode, String roleCode, String userCode) {
        return this.queryMuserPermissionDetailWrapper(proappCode, PermisConstants.PERMIS_APP_UM, roleCode, userCode, "");
    }

    public List<Map<String, Object>> makeChildren(List<UpMenuDomainBean> menuDomainList, Map<String, String> permisMap, Map<String, Object> paramMap) {
        if (ListUtil.isEmpty(menuDomainList)) {
            return new ArrayList<Map<String, Object>>();
        }
        ArrayList<Map<String, Object>> menuShowList = new ArrayList<Map<String, Object>>();
        for (UpMenuDomainBean menu : menuDomainList) {
            HashMap<String, Object> returnMenu = new HashMap<String, Object>();
            String permisValue = "";
            permisValue = permisMap.get(menu.getMenuCode());
            if (ListUtil.isNotEmpty(menu.getChildren())) {
                List<Map<String, Object>> childList = this.makeChildren(menu.getChildren(), permisMap, paramMap);
                if (null == childList || childList.isEmpty()) continue;
                returnMenu.put("children", childList);
            } else if (StringUtils.isEmpty((String)permisValue)) continue;
            if (StringUtils.isBlank((String)menu.getMenuDetailsCode())) {
                menu.setMenuDetailsCode(menu.getMenuCode());
            }
            try {
                BeanUtils.copyAllPropertys(returnMenu, (Object)menu);
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
            returnMenu.put("menuCode", menu.getMenuCode());
            returnMenu.put("menuName", menu.getMenuName());
            returnMenu.put("menuShow", menu.getMenuShow());
            returnMenu.put("menuOrder", menu.getMenuOrder());
            returnMenu.put("menuAction", menu.getMenuAction());
            returnMenu.put("menuDetailsCode", menu.getMenuDetailsCode());
            returnMenu.put("menuIcon", menu.getMenuJspath());
            String menuActionParam = "";
            try {
                String[] attachs;
                BeanUtils.copyAllPropertysNotNull(paramMap, (Object)menu);
                if (StringUtils.isNotBlank((String)permisValue) && (attachs = permisValue.split("-")) != null && attachs.length > 1 && StringUtils.isNotBlank((String)attachs[1])) {
                    HashMap<String, Object> amap = new HashMap<String, Object>();
                    menuActionParam = OpPermissionServiceImpl.getContent(amap, paramMap, attachs[1]);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            returnMenu.put("menuActionParam", menuActionParam);
            menuShowList.add(returnMenu);
        }
        return menuShowList;
    }

    private static String getContent(Map<String, Object> amap, Map<String, Object> paramMap, String manualContent) {
        if (MapUtil.isNotEmpty(paramMap)) {
            for (String key : paramMap.keySet()) {
                amap.put(key, paramMap.get(key));
            }
        }
        return FreeMarkerTemplateUtils.getContent(amap, (String)manualContent);
    }

    @Override
    public Map<String, Object> queryMuserPermissionDetailMap(Map<String, Object> map) {
        if (map == null || map.get("proappCode") == null || map.get("userCode") == null || map.get("tenantCode") == null) {
            return null;
        }
        String roleCode = String.valueOf(map.get("roleCode"));
        String userCode = String.valueOf(map.get("userCode"));
        String tenantCode = String.valueOf(map.get("tenantCode"));
        String proappCode = String.valueOf(map.get("proappCode"));
        return this.queryMuserPermissionDetailWrapper(proappCode, PermisConstants.PERMIS_APP_UM, roleCode, userCode, tenantCode);
    }

    @Override
    public Map<String, Object> queryMuserPermissionDetailMapTm(Map<String, Object> map) {
        if (map == null || map.get("proappCode") == null || map.get("userCode") == null || map.get("tenantCode") == null) {
            return null;
        }
        String roleCode = String.valueOf(map.get("roleCode"));
        String userCode = String.valueOf(map.get("userCode"));
        String tenantCode = String.valueOf(map.get("tenantCode"));
        String proappCode = String.valueOf(map.get("proappCode"));
        return this.queryMuserPermissionDetailWrapper(proappCode, PermisConstants.PERMIS_APP_MM, roleCode, userCode, tenantCode);
    }

    private Map<String, Object> queryMuserPermissionDetailWrapper(String proappCode, Integer opPermissionApp, String roleCode, String userCode, String tenantCode) {
        Map<String, String> permisMap;
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        if (StringUtils.isNotBlank((String)roleCode)) {
            List<UpRole> roleList = this.roleService.queryUpRoleInfo(this.getQueryParamMap("roleCode,tenantCode", new Object[]{roleCode, tenantCode}));
            if (ListUtil.isEmpty(roleList) && ListUtil.isEmpty(roleList = this.roleService.queryUpRoleInfo(this.getQueryParamMap("roleCode,tenantCode", new Object[]{roleCode, tenantCode})))) {
                this.logger.error("up.PERMIS.OpPermissionServiceImplqueryMuserPermissionDetail.error", (Object)"role is not exsit");
                throw new ApiException("up.PERMIS.OpPermissionServiceImplqueryMuserPermissionDetail.error", " \u89d2\u8272\u4e0d\u5b58\u5728 roleCode=" + roleCode + " ,tenantCode=" + tenantCode);
            }
            returnMap.put("role", roleList.get(0));
        }
        if (MapUtil.isEmpty(permisMap = this.queryMuserPermissionTm(tenantCode, opPermissionApp, roleCode, userCode))) {
            return returnMap;
        }
        List<UpMenuDomainBean> menuDomainList = this.getTenantMenu(tenantCode, proappCode);
        if (ListUtil.isEmpty(menuDomainList)) {
            return returnMap;
        }
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("roleCode", roleCode);
        List<Map<String, Object>> menuShowList = this.makeChildren(menuDomainList, permisMap, paramMap);
        returnMap.put("permis", permisMap);
        returnMap.put("menu", menuShowList);
        return returnMap;
    }

    private List<UpMenuDomainBean> getTenantMenu(String tenantCode, String proappCode) {
        String cachekeyOne = "TmProappMenuListOne-";
        String cachekeyChild = "TmProappMenuListChild-";
        List list = DisUtil.getListJson((String)(cachekeyOne + "-" + proappCode + "-" + tenantCode), UpMenuDomainBean.class);
        if (null == list || list.isEmpty()) {
            return null;
        }
        for (UpMenuDomainBean upMenuDomainBean : list) {
            List chirdlist = DisUtil.getListJson((String)(cachekeyChild + "-" + upMenuDomainBean.getProappMenuCode() + "-" + proappCode + "-" + tenantCode), UpMenuDomainBean.class);
            upMenuDomainBean.setChildren(chirdlist);
        }
        return list;
    }

    @Override
    public void updateUserPermission(List<UpOpPermission> upOpPermissionList) {
        String roleCode = upOpPermissionList.get(0).getOpPermissionCode();
        HashMap<String, Object> parammap = new HashMap<String, Object>();
        parammap.put("opPermissionCode", roleCode);
        parammap.put("opPermissionType", PermisConstants.PERMIS_TYPE_ROLE);
        List<UpOpPermission> upOpPermissions = this.queryOpPermission(parammap);
        for (UpOpPermission upOpPermission : upOpPermissions) {
            this.deleteOpPermission(upOpPermission.getOpPermissionId());
        }
        this.saveOpPermission(upOpPermissionList);
    }

    @Override
    public void deleteOpPermissionList(List<UpOpPermission> upOpPermissionList) {
        if (upOpPermissionList == null || upOpPermissionList.isEmpty()) {
            return;
        }
        for (UpOpPermission upOpPermission : upOpPermissionList) {
            this.deleteOpPermission(upOpPermission.getOpPermissionId());
        }
    }
}

