/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.permis.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.permis.PermisConstants;
import com.yqbsoft.laser.service.permis.dao.UpMenuMapper;
import com.yqbsoft.laser.service.permis.dao.UpOpPermissionMapper;
import com.yqbsoft.laser.service.permis.dao.UpPermissionMapper;
import com.yqbsoft.laser.service.permis.domain.UpMenuDomainBean;
import com.yqbsoft.laser.service.permis.model.UpMenu;
import com.yqbsoft.laser.service.permis.model.UpOpPermission;
import com.yqbsoft.laser.service.permis.model.UpPermission;
import com.yqbsoft.laser.service.permis.service.MenuService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jsoup.helper.StringUtil;

public class MenuServiceImpl
extends BaseServiceImpl
implements MenuService {
    public static final String SYS_CODE = "up.PERMIS.MenuServiceImpl";
    private UpMenuMapper upMenuMapper;
    private UpOpPermissionMapper upOpPermissionMapper;
    private UpPermissionMapper upPermissionMapper;
    private String cachekey = "UpMenu-permissionCode";
    private String cachekeymenu = "UpMenu-menuCode";
    private String cachekeyrouteClidmenu = "UpMenu-router-menuCode";

    public UpPermissionMapper getUpPermissionMapper() {
        return this.upPermissionMapper;
    }

    public void setUpPermissionMapper(UpPermissionMapper upPermissionMapper) {
        this.upPermissionMapper = upPermissionMapper;
    }

    public UpOpPermissionMapper getUpOpPermissionMapper() {
        return this.upOpPermissionMapper;
    }

    public void setUpOpPermissionMapper(UpOpPermissionMapper upOpPermissionMapper) {
        this.upOpPermissionMapper = upOpPermissionMapper;
    }

    public UpMenuMapper getUpMenuMapper() {
        return this.upMenuMapper;
    }

    public void setUpMenuMapper(UpMenuMapper upMenuMapper) {
        this.upMenuMapper = upMenuMapper;
    }

    @Override
    public void saveMenu(UpMenu upMenu) throws ApiException {
        String msg = this.check(upMenu);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("up.PERMIS.MenuServiceImpl.saveMenu.null", msg);
        }
        this.setDefault(upMenu);
        this.saveMenuModel(upMenu);
        this.reLoad(upMenu, null);
    }

    private void saveMenuModel(UpMenu upMenu) throws ApiException {
        if (upMenu == null) {
            return;
        }
        try {
            this.upMenuMapper.insert(upMenu);
        }
        catch (Exception e) {
            throw new ApiException("up.PERMIS.MenuServiceImpl.saveMenuModel.ex");
        }
    }

    private String check(UpMenu upMenu) {
        if (null == upMenu) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        if (StringUtils.isBlank((String)upMenu.getMenuCode())) {
            String menuCode = this.getNo("1", "UpMenu", "menuCode", upMenu.getTenantCode());
            upMenu.setMenuCode(menuCode);
        }
        String msg = "";
        if (StringUtils.isBlank((String)upMenu.getMenuName())) {
            msg = msg + "\u83dc\u5355\u540d\u79f0\u4e3a\u7a7a;";
        }
        return msg;
    }

    private Date getSysDate() {
        try {
            return this.upMenuMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("up.PERMIS.MenuServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private void setDefault(UpMenu upMenu) {
        if (null == upMenu) {
            return;
        }
        if (null == upMenu.getDataState()) {
            upMenu.setDataState(0);
        }
        if (null == upMenu.getGmtCreate()) {
            upMenu.setGmtCreate(this.getSysDate());
        }
        if (StringUtils.isBlank((String)upMenu.getMenuCode())) {
            int code = this.getMaxcode();
            upMenu.setMenuCode(this.makeMaxCode8(++code));
        }
    }

    private int getMaxcode() {
        int code = 0;
        try {
            code = this.upMenuMapper.getMaxCode();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return code;
    }

    private List<UpMenu> queryMenu(Map<String, Object> parammap) {
        try {
            return this.upMenuMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("", (Throwable)e);
            return null;
        }
    }

    private UpMenu getMenuModel(Integer menuId) {
        try {
            return this.upMenuMapper.selectByPrimaryKey(menuId);
        }
        catch (Exception e) {
            this.logger.error("up.PERMIS.MenuServiceImpl.getMenuModel", (Throwable)e);
            return null;
        }
    }

    @Override
    public UpMenu getMenu(Integer menuId) {
        return this.getMenuModel(menuId);
    }

    @Override
    public UpMenu getUpMenuByCode(Map<String, Object> map) {
        List<UpMenu> list = this.queryMenu(map);
        if (null == list || list.isEmpty()) {
            return null;
        }
        return list.get(0);
    }

    @Override
    public void updateMenu(UpMenuDomainBean upMenuDomainBean) throws ApiException {
        UpMenu oldUpMenu = this.getMenu(upMenuDomainBean.getMenuId());
        if (oldUpMenu == null) {
            throw new ApiException("up.PERMIS.MenuServiceImpl.updateMenu.exsit", "\u8bb0\u5f55\u4e0d\u5b58\u5728");
        }
        UpMenu upMenu = this.makeModel(oldUpMenu, upMenuDomainBean);
        String msg = this.check(upMenu);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("up.PERMIS.MenuServiceImpl.updateMenu.null", msg);
        }
        this.setUpDefault(upMenu);
        this.updateMenuModel(upMenu);
        this.reLoad(upMenu, oldUpMenu);
    }

    private void updateMenuModel(UpMenu upMenu) throws ApiException {
        if (null == upMenu) {
            return;
        }
        try {
            this.upMenuMapper.updateByPrimaryKey(upMenu);
        }
        catch (Exception e) {
            throw new ApiException("up.PERMIS.MenuServiceImpl.updateMenuModel.ex", (Throwable)e);
        }
    }

    private void setUpDefault(UpMenu upMenu) {
        if (null == upMenu) {
            return;
        }
        upMenu.setGmtModified(this.getSysDate());
    }

    private UpMenu makeModel(UpMenu upMenu, UpMenuDomainBean upMenuDomainBean) {
        if (upMenuDomainBean == null) {
            return null;
        }
        if (upMenu == null) {
            upMenu = new UpMenu();
        }
        UpMenu reupMenu = new UpMenu();
        try {
            BeanUtils.copyAllPropertys((Object)reupMenu, (Object)upMenu);
            BeanUtils.copyAllPropertys((Object)reupMenu, (Object)upMenuDomainBean);
        }
        catch (Exception e) {
            // empty catch block
        }
        return reupMenu;
    }

    @Override
    public List<UpMenu> queryUpMenu(Map<String, Object> map) {
        return this.queryMenu(map);
    }

    private void reLoad(UpMenu upMenu, UpMenu oldUpMenu) {
        List<UpMenu> oldList;
        String jsonb;
        if (null == upMenu) {
            return;
        }
        DisUtil.setMap((String)this.cachekey, (String)(upMenu.getPermissionCode() + "-" + upMenu.getTenantCode()), (String)JsonUtil.buildNormalBinder().toJson((Object)upMenu));
        DisUtil.setMap((String)this.cachekeymenu, (String)(upMenu.getMenuCode() + "-" + upMenu.getTenantCode()), (String)JsonUtil.buildNormalBinder().toJson((Object)upMenu));
        if (null != oldUpMenu && StringUtils.isNotBlank((String)oldUpMenu.getMenuParentCode()) && StringUtils.isNotBlank((String)(jsonb = DisUtil.getMap((String)this.cachekeyrouteClidmenu, (String)(oldUpMenu.getMenuParentCode() + "-" + oldUpMenu.getTenantCode())))) && ListUtil.isNotEmpty((Collection)(oldList = (ArrayList<UpMenu>)JsonUtil.buildNormalBinder().getJsonToList(jsonb, UpMenu.class)))) {
            for (UpMenu upMenu2 : oldList) {
                if (!upMenu2.getMenuCode().equals(oldUpMenu.getMenuCode())) continue;
                oldList.remove(upMenu2);
                break;
            }
            DisUtil.setMap((String)this.cachekeyrouteClidmenu, (String)(oldUpMenu.getMenuParentCode() + "-" + oldUpMenu.getTenantCode()), (String)JsonUtil.buildNormalBinder().toJson(oldList));
        }
        if (StringUtils.isNotBlank((String)upMenu.getMenuParentCode()) && StringUtils.isNotBlank((String)(jsonb = DisUtil.getMap((String)this.cachekeyrouteClidmenu, (String)(upMenu.getMenuParentCode() + "-" + upMenu.getTenantCode()))))) {
            oldList = (List)JsonUtil.buildNormalBinder().getJsonToList(jsonb, UpMenu.class);
            if (null == oldList) {
                oldList = new ArrayList<UpMenu>();
            }
            oldList.add(upMenu);
            DisUtil.setMap((String)this.cachekeyrouteClidmenu, (String)(upMenu.getMenuParentCode() + "-" + upMenu.getTenantCode()), (String)JsonUtil.buildNormalBinder().toJson(oldList));
        }
    }

    @Override
    public void queryMenuLoad() {
        this.logger.info("MenuService.queryMenuLoad", (Object)"===========start==========");
        ConcurrentHashMap<String, Object> param = new ConcurrentHashMap<String, Object>();
        param.put("dataState", 1);
        param.put("order", true);
        List<UpMenu> list = this.queryMenu(param);
        if (null == list || list.isEmpty()) {
            DisUtil.delVer((String)this.cachekey);
            DisUtil.delVer((String)this.cachekeymenu);
            DisUtil.delVer((String)this.cachekeyrouteClidmenu);
            this.logger.info("MenuService.queryMenuLoad", (Object)"===========del-end==========");
            return;
        }
        ConcurrentHashMap<String, String> perMap = new ConcurrentHashMap<String, String>();
        ConcurrentHashMap<String, String> menuMap = new ConcurrentHashMap<String, String>();
        ConcurrentHashMap<String, ArrayList<UpMenu>> menurouteChildMap = new ConcurrentHashMap<String, ArrayList<UpMenu>>();
        ConcurrentHashMap<String, String> menuparentMap = new ConcurrentHashMap<String, String>();
        for (UpMenu upMenu : list) {
            String menuCodeStr;
            if (StringUtils.isNotBlank((String)upMenu.getMenuParentCode())) {
                menuparentMap.put(upMenu.getMenuCode(), upMenu.getMenuParentCode());
                ArrayList<UpMenu> routeChildList = (ArrayList<UpMenu>)menurouteChildMap.get(upMenu.getMenuParentCode() + "-" + upMenu.getTenantCode());
                if (null == routeChildList) {
                    routeChildList = new ArrayList<UpMenu>();
                    menurouteChildMap.put(upMenu.getMenuParentCode() + "-" + upMenu.getTenantCode(), routeChildList);
                }
                routeChildList.add(upMenu);
            }
            if (StringUtils.isBlank((String)(menuCodeStr = (String)perMap.get(upMenu.getPermissionCode() + "-" + upMenu.getTenantCode())))) {
                menuCodeStr = "";
            }
            if (StringUtils.isNotBlank((String)menuCodeStr)) {
                menuCodeStr = menuCodeStr + ",";
            }
            menuCodeStr = menuCodeStr + upMenu.getMenuCode();
            perMap.put(upMenu.getPermissionCode() + "-" + upMenu.getTenantCode(), menuCodeStr);
            menuMap.put(upMenu.getMenuCode() + "-" + upMenu.getTenantCode(), JsonUtil.buildNormalBinder().toJson((Object)upMenu));
        }
        ConcurrentHashMap<String, String> menurouteChildStrMap = new ConcurrentHashMap<String, String>();
        for (String key : menurouteChildMap.keySet()) {
            menurouteChildStrMap.put(key, JsonUtil.buildNormalBinder().toJson(menurouteChildMap.get(key)));
        }
        ConcurrentHashMap<String, String> menuparentCacheMap = new ConcurrentHashMap<String, String>();
        String codeStr = null;
        for (String key : menuparentMap.keySet()) {
            codeStr = this.getMenuParStr(key, menuparentMap);
            if (!StringUtils.isNotBlank((String)codeStr)) continue;
            menuparentCacheMap.put(key, codeStr);
        }
        DisUtil.setMapVer((String)"UpMenu-menuCode-parent", menuparentCacheMap);
        DisUtil.setMapVer((String)this.cachekey, perMap);
        DisUtil.setMapVer((String)this.cachekeymenu, menuMap);
        DisUtil.setMapVer((String)this.cachekeyrouteClidmenu, menurouteChildStrMap);
        this.logger.info("MenuService.queryMenuLoad", (Object)"===========add-end==========");
    }

    private String getMenuParStr(String menuCode, Map<String, String> menuparentMap) {
        if (StringUtils.isBlank((String)menuCode) || null == menuparentMap || menuparentMap.isEmpty()) {
            return "";
        }
        String p = menuparentMap.get(menuCode);
        if (StringUtils.isBlank((String)p)) {
            return "";
        }
        String str = p;
        String np = this.getMenuParStr(p, menuparentMap);
        if (StringUtils.isNotBlank((String)np)) {
            str = str + "," + np;
        }
        return str;
    }

    @Override
    public void deleteMenu(Integer menuId) {
        List oldList;
        String jsonb;
        UpMenu upMenu = this.getMenu(menuId);
        if (null == upMenu) {
            throw new ApiException("up.PERMIS.MenuServiceImpl.deleteMenu.null");
        }
        this.deleteMenuModel(menuId);
        DisUtil.delMap((String)this.cachekey, (String[])new String[]{upMenu.getPermissionCode() + "-" + upMenu.getTenantCode()});
        DisUtil.delMap((String)this.cachekeymenu, (String[])new String[]{upMenu.getMenuCode() + "-" + upMenu.getTenantCode()});
        if (null != upMenu && StringUtils.isNotBlank((String)upMenu.getMenuParentCode()) && StringUtils.isNotBlank((String)(jsonb = DisUtil.getMap((String)this.cachekeyrouteClidmenu, (String)(upMenu.getMenuParentCode() + "-" + upMenu.getTenantCode())))) && ListUtil.isNotEmpty((Collection)(oldList = (List)JsonUtil.buildNormalBinder().getJsonToList(jsonb, UpMenu.class)))) {
            for (UpMenu upMenu2 : oldList) {
                if (!upMenu2.getMenuCode().equals(upMenu.getMenuCode())) continue;
                oldList.remove(upMenu2);
                break;
            }
            DisUtil.setMap((String)this.cachekeyrouteClidmenu, (String)(upMenu.getMenuParentCode() + "-" + upMenu.getTenantCode()), (String)JsonUtil.buildNormalBinder().toJson((Object)oldList));
        }
    }

    private void deleteMenuModel(Integer menuId) {
        int i = 0;
        try {
            i = this.upMenuMapper.deleteByPrimaryKey(menuId);
        }
        catch (Exception e) {
            throw new ApiException("up.PERMIS.MenuServiceImpl.deleteMenuModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("up.PERMIS.MenuServiceImpl.deleteMenuModel.num");
        }
    }

    @Override
    public QueryResult<UpMenu> queryUpMenuPage(Map<String, Object> map) {
        QueryResult queryResult = new QueryResult();
        List<UpMenu> list = this.queryMenu(map);
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.count(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(list);
        return queryResult;
    }

    private int count(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.upMenuMapper.count(map);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return i;
    }

    @Override
    public List<UpMenuDomainBean> queryUpMenuTree(String tenantCode, String menuParentCode) {
        ArrayList<UpMenuDomainBean> upMenuDomainBeanList = new ArrayList<UpMenuDomainBean>();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("menuParentCode", menuParentCode);
        map.put("order", true);
        map.put("menuShow", 0);
        List<UpMenu> upMenuList = this.queryMenu(map);
        if (upMenuList == null || upMenuList.isEmpty()) {
            return null;
        }
        for (UpMenu upMenu : upMenuList) {
            UpMenuDomainBean upMenuDomainBean = this.getUpMenuDomain(upMenu);
            upMenuDomainBean.setChildren(this.queryUpMenuTree(upMenu.getAppmanageIcode(), upMenu.getMenuCode()));
            upMenuDomainBeanList.add(upMenuDomainBean);
        }
        return upMenuDomainBeanList;
    }

    @Override
    public List<UpMenuDomainBean> queryUpMenuPermisTree(String menuParentCode, String tenantCode) {
        List<UpMenuDomainBean> upMenuDomainBeanList = this.queryUpMenuTree(tenantCode, menuParentCode);
        if (upMenuDomainBeanList == null || upMenuDomainBeanList.isEmpty()) {
            return null;
        }
        List<UpPermission> permissionList = this.upPermissionMapper.query(this.getQueryParamMap("permissionSort", new Object[]{PermisConstants.PERMIS_SORT_OPER}));
        HashMap<String, String> permissionMap = null;
        if (permissionList != null && !permissionList.isEmpty()) {
            permissionMap = new HashMap<String, String>();
            for (UpPermission upPermission : permissionList) {
                permissionMap.put(upPermission.getPermissionCode(), upPermission.getPermissionCode());
            }
        }
        List<UpOpPermission> tenantPermisList = this.upOpPermissionMapper.query(this.getQueryParamMap("tenantCode,opPermissionType,opPermissionCode", new Object[]{tenantCode, PermisConstants.PERMIS_TYPE_TENANT, tenantCode}));
        HashMap<String, String> tenantPerMap = null;
        if (tenantPermisList != null && !tenantPermisList.isEmpty()) {
            tenantPerMap = new HashMap<String, String>();
            for (UpOpPermission upOpPermission : tenantPermisList) {
                tenantPerMap.put(upOpPermission.getMenuCode(), upOpPermission.getMenuCode());
            }
        }
        return this.makePermisMenu(upMenuDomainBeanList, permissionMap, tenantPerMap);
    }

    private List<UpMenuDomainBean> makePermisMenu(List<UpMenuDomainBean> upMenuDomainBeanList, Map<String, String> permissionMap, Map<String, String> tenantPerMap) {
        if (upMenuDomainBeanList == null || upMenuDomainBeanList.isEmpty()) {
            return null;
        }
        ArrayList<UpMenuDomainBean> menuList = new ArrayList<UpMenuDomainBean>();
        for (UpMenuDomainBean upMenuDomainBean : upMenuDomainBeanList) {
            String permissionCode = upMenuDomainBean.getPermissionCode();
            String menuCode = upMenuDomainBean.getMenuCode();
            List<UpMenuDomainBean> childen = upMenuDomainBean.getChildren();
            if (childen == null || childen.isEmpty()) {
                if (StringUtil.isBlank((String)permissionCode) || permissionMap != null && StringUtil.isBlank((String)permissionMap.get(permissionCode)) || tenantPerMap != null && StringUtil.isBlank((String)tenantPerMap.get(menuCode))) continue;
                menuList.add(upMenuDomainBean);
                continue;
            }
            childen = this.makePermisMenu(upMenuDomainBean.getChildren(), permissionMap, tenantPerMap);
            if (childen == null || childen.isEmpty()) continue;
            upMenuDomainBean.setChildren(childen);
            menuList.add(upMenuDomainBean);
        }
        return menuList;
    }

    @Override
    public Map<String, String> queryMenuCodeByUrl(String tenantCode, String menuParentCode) {
        List<UpMenuDomainBean> list = this.queryUpMenuTree(tenantCode, menuParentCode);
        return this.queryMenuCodeByUrlWrapper(list);
    }

    private Map<String, String> queryMenuCodeByUrlWrapper(List<UpMenuDomainBean> list) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        HashMap<String, String> menuCodeMap = new HashMap<String, String>();
        for (UpMenuDomainBean upMenuDomainBean : list) {
            this.putMenuCodeMap(upMenuDomainBean.getChildren(), menuCodeMap, upMenuDomainBean.getMenuCode() + "_" + upMenuDomainBean.getMenuAction());
            menuCodeMap.put(upMenuDomainBean.getMenuAction(), upMenuDomainBean.getMenuCode() + "_" + upMenuDomainBean.getMenuAction());
        }
        return menuCodeMap;
    }

    private void putMenuCodeMap(List<UpMenuDomainBean> list, Map<String, String> menuCodeMap, String parentMenuCode) {
        if (list == null || list.isEmpty()) {
            return;
        }
        for (UpMenuDomainBean upMenuDomainBean : list) {
            if (upMenuDomainBean.getChildren() != null && !upMenuDomainBean.getChildren().isEmpty()) {
                this.putMenuCodeMap(upMenuDomainBean.getChildren(), menuCodeMap, parentMenuCode);
            }
            if (!StringUtils.isNotBlank((String)upMenuDomainBean.getMenuAction())) continue;
            menuCodeMap.put(upMenuDomainBean.getMenuAction(), parentMenuCode);
        }
    }

    private UpMenuDomainBean getUpMenuDomain(UpMenu upMenu) {
        UpMenuDomainBean upMenuDomainBean = new UpMenuDomainBean();
        try {
            BeanUtils.copyAllPropertys((Object)upMenuDomainBean, (Object)upMenu);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return upMenuDomainBean;
    }

    @Override
    public void updateMenuRelease(Integer menuId) {
        UpMenu upMenu = this.getMenu(menuId);
        this.releaseMenu(upMenu, null, null, false);
    }

    @Override
    public void updateMenuReleaseByCode(Map<String, Object> map) {
        String doclistCode;
        List<UpMenu> menuList = this.queryUpMenu(map);
        String string = doclistCode = map.get("doclistCode") == null ? null : map.get("doclistCode").toString();
        if (menuList != null && !menuList.isEmpty()) {
            this.releaseMenu(menuList.get(0), doclistCode, map.get("OUT_PUT"), true);
        }
    }

    private void releaseMenu(UpMenu upMenu, String doclistCode, Object outPut, boolean flag) {
        if (upMenu == null) {
            return;
        }
        upMenu.setDataState(PermisConstants.MENU_STATE_1);
        this.updateMenuModel(upMenu);
        HashMap<String, Object> map = new HashMap<String, Object>();
        String fileName = upMenu.getMenuAction();
        if (StringUtil.isBlank((String)doclistCode)) {
            map.put("OUT_PUT", upMenu.getMenuJspath() + upMenu.getMenuAction());
            if (StringUtil.isBlank((String)upMenu.getMenuIndexCode())) {
                return;
            }
            map.put("modelCode", upMenu.getMenuIndexCode());
        } else {
            fileName = doclistCode + ".html";
            if (outPut == null) {
                map.put("OUT_PUT", doclistCode + ".html");
            } else {
                map.put("OUT_PUT", outPut);
            }
            if (StringUtil.isBlank((String)upMenu.getMenuDetailsCode())) {
                this.logger.error("releaseMenu is error, menuDetailCode is null, menuCode ==> \u3010" + upMenu.getMenuCode() + "\u3011");
                return;
            }
            map.put("modelCode", upMenu.getMenuDetailsCode());
        }
        map.put("menuCode", upMenu.getMenuCode());
        map.put("menuType", upMenu.getMenuType());
        map.put("doclistCode", doclistCode);
        map.put("tenantCode", upMenu.getTenantCode());
        map.put("menuDetailsCode", upMenu.getMenuDetailsCode());
        map.put("fileName", fileName);
        map.put("flag", flag);
        map.put(UpMenu.class.getSimpleName(), upMenu);
        HashMap<String, String> paramsMap = new HashMap<String, String>();
        paramsMap.put("map", JsonUtil.buildNormalBinder().toJson(map));
        this.internalInvoke("cms.model.updateReleaseModel", paramsMap);
    }

    @Override
    public List<UpMenu> queryUpMenuByCode(String tenantCode, List<String> menuCodeList) {
        return this.queryUpMenuModelByCode(tenantCode, menuCodeList);
    }

    private List<UpMenu> queryUpMenuModelByCode(String tenantCode, List<String> menuCodeList) {
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("tenantCode", tenantCode);
            map.put("menuCodes", menuCodeList);
            return this.upMenuMapper.queryByCodes(map);
        }
        catch (Exception e) {
            this.logger.error("", (Throwable)e);
            return null;
        }
    }

    @Override
    public String updateMenuReleaseAll(Map<String, Object> map) {
        List<UpMenu> menuList = this.queryUpMenu(map);
        if (menuList == null || menuList.size() == 0) {
            return "\u67e5\u8be2\u83dc\u5355\u5931\u8d25";
        }
        String rs = "";
        for (UpMenu menu : menuList) {
            try {
                this.updateMenuRelease(menu.getMenuId());
            }
            catch (Exception e) {
                rs = rs + menu.getMenuName() + "\u53d1\u5e03\u5931\u8d25!";
            }
        }
        return rs;
    }

    @Override
    public List<UpMenuDomainBean> queryUpMenuTreeByMap(Map<String, Object> map) {
        if (map == null || map.get("appmanageIcode") == null || map.get("menuParentCode") == null || map.get("tenantCode") == null) {
            return null;
        }
        String appmanageIcode = String.valueOf(map.get("appmanageIcode"));
        String menuParentCode = String.valueOf(map.get("menuParentCode"));
        String tenantCode = String.valueOf(map.get("tenantCode"));
        return this.queryUpMenuTree(appmanageIcode, menuParentCode, tenantCode);
    }

    @Override
    public Map<String, String> queryMenuCodeByUrlMap(Map<String, Object> map) {
        String appmanageIcode = String.valueOf(map.get("appmanageIcode"));
        String menuParentCode = String.valueOf(map.get("menuParentCode"));
        String tenantCode = String.valueOf(map.get("tenantCode"));
        List<UpMenuDomainBean> list = this.queryUpMenuTree(appmanageIcode, menuParentCode, tenantCode);
        return this.queryMenuCodeByUrlWrapper(list);
    }

    private List<UpMenuDomainBean> queryUpMenuTree(String appmanageIcode, String menuParentCode, String tenantCode) {
        ArrayList<UpMenuDomainBean> upMenuDomainBeanList = new ArrayList<UpMenuDomainBean>();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("menuParentCode", menuParentCode);
        map.put("tenantCode", tenantCode);
        map.put("order", true);
        map.put("menuShow", 0);
        List<UpMenu> upMenuList = this.queryMenu(map);
        if (upMenuList == null || upMenuList.isEmpty()) {
            return null;
        }
        for (UpMenu upMenu : upMenuList) {
            UpMenuDomainBean upMenuDomainBean = this.getUpMenuDomain(upMenu);
            upMenuDomainBean.setChildren(this.queryUpMenuTree(upMenu.getAppmanageIcode(), upMenu.getMenuCode(), upMenu.getTenantCode()));
            upMenuDomainBeanList.add(upMenuDomainBean);
        }
        return upMenuDomainBeanList;
    }
}

