/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.permis.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.permis.dao.UpAppMapper;
import com.yqbsoft.laser.service.permis.dao.UpAppOpMapper;
import com.yqbsoft.laser.service.permis.domain.UpAppDomain;
import com.yqbsoft.laser.service.permis.domain.UpAppOpDomain;
import com.yqbsoft.laser.service.permis.model.UpApp;
import com.yqbsoft.laser.service.permis.model.UpAppOp;
import com.yqbsoft.laser.service.permis.service.UpAppService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class UpAppServiceImpl
extends BaseServiceImpl
implements UpAppService {
    private static final String SYS_CODE = "up.PERMIS.UpAppServiceImpl";
    private UpAppMapper upAppMapper;
    private UpAppOpMapper upAppOpMapper;

    public void setUpAppMapper(UpAppMapper upAppMapper) {
        this.upAppMapper = upAppMapper;
    }

    public void setUpAppOpMapper(UpAppOpMapper upAppOpMapper) {
        this.upAppOpMapper = upAppOpMapper;
    }

    private Date getSysDate() {
        try {
            return this.upAppMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("up.PERMIS.UpAppServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkApp(UpAppDomain upAppDomain) {
        if (null == upAppDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        return msg;
    }

    private void setAppDefault(UpApp upApp) {
        if (null == upApp) {
            return;
        }
        if (null == upApp.getDataState()) {
            upApp.setDataState(0);
        }
        if (null == upApp.getGmtCreate()) {
            upApp.setGmtCreate(this.getSysDate());
        }
        upApp.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)upApp.getAppCode())) {
            upApp.setAppCode(this.createUUIDString());
        }
    }

    private int getAppMaxCode() {
        int code = 0;
        try {
            return this.upAppMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("up.PERMIS.UpAppServiceImpl.getAppMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setAppUpdataDefault(UpApp upApp) {
        if (null == upApp) {
            return;
        }
        upApp.setGmtModified(this.getSysDate());
    }

    private void saveAppModel(UpApp upApp) throws ApiException {
        if (null == upApp) {
            return;
        }
        try {
            this.upAppMapper.insert(upApp);
        }
        catch (Exception e) {
            throw new ApiException("up.PERMIS.UpAppServiceImpl.saveAppModel.ex", (Throwable)e);
        }
    }

    private UpApp getAppModelById(Integer appId) {
        if (null == appId) {
            return null;
        }
        try {
            return this.upAppMapper.selectByPrimaryKey(appId);
        }
        catch (Exception e) {
            this.logger.error("up.PERMIS.UpAppServiceImpl.getAppModelById", (Throwable)e);
            return null;
        }
    }

    public UpApp getAppModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.upAppMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("up.PERMIS.UpAppServiceImpl.getAppModelByCode", (Throwable)e);
            return null;
        }
    }

    public void delAppModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.upAppMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("up.PERMIS.UpAppServiceImpl.delAppModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("up.PERMIS.UpAppServiceImpl.delAppModelByCode.num");
        }
    }

    private void deleteAppModel(Integer appId) throws ApiException {
        if (null == appId) {
            return;
        }
        int i = 0;
        try {
            i = this.upAppMapper.deleteByPrimaryKey(appId);
        }
        catch (Exception e) {
            throw new ApiException("up.PERMIS.UpAppServiceImpl.deleteAppModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("up.PERMIS.UpAppServiceImpl.deleteAppModel.num");
        }
    }

    private void updateAppModel(UpApp upApp) throws ApiException {
        if (null == upApp) {
            return;
        }
        try {
            this.upAppMapper.updateByPrimaryKeySelective(upApp);
        }
        catch (Exception e) {
            throw new ApiException("up.PERMIS.UpAppServiceImpl.updateAppModel.ex", (Throwable)e);
        }
    }

    private void updateStateAppModel(Integer appId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == appId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("appId", appId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.upAppMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("up.PERMIS.UpAppServiceImpl.updateStateAppModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("up.PERMIS.UpAppServiceImpl.updateStateAppModel.null");
        }
    }

    private UpApp makeApp(UpAppDomain upAppDomain, UpApp upApp) {
        if (null == upAppDomain) {
            return null;
        }
        if (null == upApp) {
            upApp = new UpApp();
        }
        try {
            BeanUtils.copyAllPropertys((Object)upApp, (Object)upAppDomain);
            return upApp;
        }
        catch (Exception e) {
            this.logger.error("up.PERMIS.UpAppServiceImpl.makeApp", (Throwable)e);
            return null;
        }
    }

    private List<UpApp> queryAppModelPage(Map<String, Object> parammap) {
        try {
            return this.upAppMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("up.PERMIS.UpAppServiceImpl.queryAppModel", (Throwable)e);
            return null;
        }
    }

    private int countApp(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.upAppMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("up.PERMIS.UpAppServiceImpl.countApp", (Throwable)e);
        }
        return i;
    }

    private String checkAppOp(UpAppOpDomain upAppOpDomain) {
        if (null == upAppOpDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        return msg;
    }

    private void setAppOpDefault(UpAppOp upAppOp) {
        if (null == upAppOp) {
            return;
        }
        if (null == upAppOp.getDataState()) {
            upAppOp.setDataState(0);
        }
        if (null == upAppOp.getGmtCreate()) {
            upAppOp.setGmtCreate(this.getSysDate());
        }
        upAppOp.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)upAppOp.getAppOpCode())) {
            upAppOp.setAppOpCode(this.createUUIDString());
        }
    }

    private int getAppOpMaxCode() {
        int code = 0;
        try {
            return this.upAppOpMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("up.PERMIS.UpAppServiceImpl.getAppOpMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setAppOpUpdataDefault(UpAppOp upAppOp) {
        if (null == upAppOp) {
            return;
        }
        upAppOp.setGmtModified(this.getSysDate());
    }

    private void saveAppOpModel(UpAppOp upAppOp) throws ApiException {
        if (null == upAppOp) {
            return;
        }
        try {
            this.upAppOpMapper.insert(upAppOp);
        }
        catch (Exception e) {
            throw new ApiException("up.PERMIS.UpAppServiceImpl.saveAppOpModel.ex", (Throwable)e);
        }
    }

    private UpAppOp getAppOpModelById(Integer appOpId) {
        if (null == appOpId) {
            return null;
        }
        try {
            return this.upAppOpMapper.selectByPrimaryKey(appOpId);
        }
        catch (Exception e) {
            this.logger.error("up.PERMIS.UpAppServiceImpl.getAppOpModelById", (Throwable)e);
            return null;
        }
    }

    public UpAppOp getAppOpModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.upAppOpMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("up.PERMIS.UpAppServiceImpl.getAppOpModelByCode", (Throwable)e);
            return null;
        }
    }

    public void delAppOpModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.upAppOpMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("up.PERMIS.UpAppServiceImpl.delAppOpModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("up.PERMIS.UpAppServiceImpl.delAppOpModelByCode.num");
        }
    }

    private void deleteAppOpModel(Integer appOpId) throws ApiException {
        if (null == appOpId) {
            return;
        }
        int i = 0;
        try {
            i = this.upAppOpMapper.deleteByPrimaryKey(appOpId);
        }
        catch (Exception e) {
            throw new ApiException("up.PERMIS.UpAppServiceImpl.deleteAppOpModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("up.PERMIS.UpAppServiceImpl.deleteAppOpModel.num");
        }
    }

    private void updateAppOpModel(UpAppOp upAppOp) throws ApiException {
        if (null == upAppOp) {
            return;
        }
        try {
            this.upAppOpMapper.updateByPrimaryKeySelective(upAppOp);
        }
        catch (Exception e) {
            throw new ApiException("up.PERMIS.UpAppServiceImpl.updateAppOpModel.ex", (Throwable)e);
        }
    }

    private void updateStateAppOpModel(Integer appOpId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == appOpId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("appOpId", appOpId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.upAppOpMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("up.PERMIS.UpAppServiceImpl.updateStateAppOpModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("up.PERMIS.UpAppServiceImpl.updateStateAppOpModel.null");
        }
    }

    private UpAppOp makeAppOp(UpAppOpDomain upAppOpDomain, UpAppOp upAppOp) {
        if (null == upAppOpDomain) {
            return null;
        }
        if (null == upAppOp) {
            upAppOp = new UpAppOp();
        }
        try {
            BeanUtils.copyAllPropertys((Object)upAppOp, (Object)upAppOpDomain);
            return upAppOp;
        }
        catch (Exception e) {
            this.logger.error("up.PERMIS.UpAppServiceImpl.makeAppOp", (Throwable)e);
            return null;
        }
    }

    private List<UpAppOp> queryAppOpModelPage(Map<String, Object> parammap) {
        try {
            return this.upAppOpMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("up.PERMIS.UpAppServiceImpl.queryAppOpModel", (Throwable)e);
            return null;
        }
    }

    private int countAppOp(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.upAppOpMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("up.PERMIS.UpAppServiceImpl.countAppOp", (Throwable)e);
        }
        return i;
    }

    @Override
    public String saveApp(UpAppDomain upAppDomain) throws ApiException {
        String msg = this.checkApp(upAppDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("up.PERMIS.UpAppServiceImpl.saveApp.checkApp", msg);
        }
        UpApp upApp = this.makeApp(upAppDomain, null);
        this.setAppDefault(upApp);
        this.saveAppModel(upApp);
        return upApp.getAppCode();
    }

    @Override
    public void updateAppState(Integer appId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateAppModel(appId, dataState, oldDataState);
    }

    @Override
    public void updateApp(UpAppDomain upAppDomain) throws ApiException {
        String msg = this.checkApp(upAppDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("up.PERMIS.UpAppServiceImpl.updateApp.checkApp", msg);
        }
        UpApp oldUpApp = this.getAppModelById(upAppDomain.getAppId());
        if (null == oldUpApp) {
            throw new ApiException("up.PERMIS.UpAppServiceImpl.updateApp.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        UpApp upApp = this.makeApp(upAppDomain, oldUpApp);
        this.setAppUpdataDefault(upApp);
        this.updateAppModel(upApp);
    }

    @Override
    public UpApp getApp(Integer appId) {
        return this.getAppModelById(appId);
    }

    @Override
    public void deleteApp(Integer appId) throws ApiException {
        this.deleteAppModel(appId);
    }

    @Override
    public QueryResult<UpApp> queryAppPage(Map<String, Object> map) {
        List<UpApp> upAppList = this.queryAppModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countApp(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(upAppList);
        return queryResult;
    }

    @Override
    public UpApp getAppByCode(Map<String, Object> map) {
        return this.getAppModelByCode(map);
    }

    @Override
    public void delAppByCode(Map<String, Object> map) throws ApiException {
        this.delAppModelByCode(map);
    }

    @Override
    public String saveAppOp(UpAppOpDomain upAppOpDomain) throws ApiException {
        String msg = this.checkAppOp(upAppOpDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("up.PERMIS.UpAppServiceImpl.saveAppOp.checkAppOp", msg);
        }
        UpAppOp upAppOp = this.makeAppOp(upAppOpDomain, null);
        this.setAppOpDefault(upAppOp);
        this.saveAppOpModel(upAppOp);
        return upAppOp.getAppOpCode();
    }

    @Override
    public void updateAppOpState(Integer appOpId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateAppOpModel(appOpId, dataState, oldDataState);
    }

    @Override
    public void updateAppOp(UpAppOpDomain upAppOpDomain) throws ApiException {
        String msg = this.checkAppOp(upAppOpDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("up.PERMIS.UpAppServiceImpl.updateAppOp.checkAppOp", msg);
        }
        UpAppOp oldUpAppOp = this.getAppOpModelById(upAppOpDomain.getAppOpId());
        if (null == oldUpAppOp) {
            throw new ApiException("up.PERMIS.UpAppServiceImpl.updateAppOp.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        UpAppOp upAppOp = this.makeAppOp(upAppOpDomain, oldUpAppOp);
        this.setAppOpUpdataDefault(upAppOp);
        this.updateAppOpModel(upAppOp);
    }

    @Override
    public UpAppOp getAppOp(Integer appOpId) {
        return this.getAppOpModelById(appOpId);
    }

    @Override
    public void deleteAppOp(Integer appOpId) throws ApiException {
        this.deleteAppOpModel(appOpId);
    }

    @Override
    public QueryResult<UpAppOp> queryAppOpPage(Map<String, Object> map) {
        List<UpAppOp> upAppOpList = this.queryAppOpModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countAppOp(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(upAppOpList);
        return queryResult;
    }

    @Override
    public UpAppOp getAppOpByCode(Map<String, Object> map) {
        return this.getAppOpModelByCode(map);
    }

    @Override
    public void delAppOpByCode(Map<String, Object> map) throws ApiException {
        this.delAppOpModelByCode(map);
    }

    @Override
    public Map<String, Object> queryAppPermission(Map<String, Object> map) {
        if (map == null || map.get("appmanageIcode") == null || map.get("roleCode") == null || map.get("userCode") == null || map.get("loginTenantCode") == null) {
            return null;
        }
        return null;
    }
}

