/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.permis.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.permis.dao.UpPermissionListMapper;
import com.yqbsoft.laser.service.permis.dao.UpPermissionMapper;
import com.yqbsoft.laser.service.permis.domain.UpPermissionDomainBean;
import com.yqbsoft.laser.service.permis.domain.UpPermissionListDomainBean;
import com.yqbsoft.laser.service.permis.model.UpPermission;
import com.yqbsoft.laser.service.permis.model.UpPermissionList;
import com.yqbsoft.laser.service.permis.service.PermissionService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class PermissionServiceImpl
extends BaseServiceImpl
implements PermissionService {
    private static final String CACHE_KEY = "permission-flag";
    public static final String SYS_CODE = "up.PERMIS.PermissionServiceImpl";
    private UpPermissionMapper upPermissionMapper;
    private UpPermissionListMapper upPermissionListMapper;

    public UpPermissionMapper getUpPermissionMapper() {
        return this.upPermissionMapper;
    }

    public void setUpPermissionMapper(UpPermissionMapper upPermissionMapper) {
        this.upPermissionMapper = upPermissionMapper;
    }

    public UpPermissionListMapper getUpPermissionListMapper() {
        return this.upPermissionListMapper;
    }

    public void setUpPermissionListMapper(UpPermissionListMapper upPermissionListMapper) {
        this.upPermissionListMapper = upPermissionListMapper;
    }

    @Override
    public UpPermission savePermission(UpPermissionDomainBean upPermissionDomainBean) throws ApiException {
        UpPermission upPermission = this.makeModel(null, upPermissionDomainBean);
        String msg = this.check(upPermission);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("up.PERMIS.PermissionServiceImpl.savePermission.null", msg);
        }
        this.setDefault(upPermission);
        this.savePermissionModel(upPermission);
        List<UpPermissionListDomainBean> permisslist = upPermissionDomainBean.getPermisslist();
        if (null == permisslist || permisslist.isEmpty()) {
            return upPermission;
        }
        for (UpPermissionListDomainBean upPermissionListDomainBean : permisslist) {
            upPermissionListDomainBean.setAppmanageIcode(upPermission.getAppmanageIcode());
            upPermissionListDomainBean.setPermissionCode(upPermission.getPermissionCode());
            if (null == upPermissionListDomainBean.getPermissionListType()) {
                upPermissionListDomainBean.setPermissionListType(upPermission.getPermissionType());
            }
            if (null == upPermissionListDomainBean.getPermissionListSort()) {
                upPermissionListDomainBean.setPermissionListSort(upPermission.getPermissionSort());
            }
            this.savePermissionList(upPermissionListDomainBean);
        }
        this.setMpermissionFlag();
        return upPermission;
    }

    private void setMpermissionFlag() {
        DisUtil.setVer((String)CACHE_KEY, (String)"1");
    }

    private void savePermissionModel(UpPermission upPermission) throws ApiException {
        if (null == upPermission) {
            return;
        }
        try {
            this.upPermissionMapper.insert(upPermission);
        }
        catch (Exception e) {
            throw new ApiException("up.PERMIS.PermissionServiceImpl.savePermissionMode.ex");
        }
    }

    private String check(UpPermission upPermission) {
        if (null == upPermission) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)upPermission.getPermissionName())) {
            msg = msg + "\u6743\u9650\u540d\u79f0\u4e3a\u7a7a;";
        }
        return msg;
    }

    private String check(UpPermissionList upPermissionList) {
        if (null == upPermissionList) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)upPermissionList.getPermissionCode())) {
            msg = msg + "\u6743\u9650\u4ee3\u7801\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)upPermissionList.getPermissionListName())) {
            msg = msg + "\u6743\u9650\u540d\u79f0\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setDefault(UpPermission upPermission) {
        if (null == upPermission) {
            return;
        }
        if (null == upPermission.getDataState()) {
            upPermission.setDataState(0);
        }
        if (null == upPermission.getGmtCreate()) {
            upPermission.setGmtCreate(this.getSysDate());
        }
        if (StringUtils.isBlank((String)upPermission.getPermissionCode())) {
            int code = this.getMaxcode();
            upPermission.setPermissionCode(this.makeMaxCode8(++code));
        }
    }

    private int getMaxcode() {
        int code = 0;
        try {
            code = this.upPermissionMapper.getMaxCode();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return code;
    }

    private void setUpDefault(UpPermission upPermission) {
        if (null == upPermission) {
            return;
        }
        upPermission.setGmtModified(this.getSysDate());
    }

    private void setUpDefault(UpPermissionList upPermissionList) {
        if (null == upPermissionList) {
            return;
        }
        upPermissionList.setGmtModified(this.getSysDate());
    }

    private void setDefault(UpPermissionList upPermissionList) {
        if (null == upPermissionList) {
            return;
        }
        if (null == upPermissionList.getDataState()) {
            upPermissionList.setDataState(0);
        }
        if (null == upPermissionList.getGmtCreate()) {
            upPermissionList.setGmtCreate(this.getSysDate());
        }
        if (StringUtils.isBlank((String)upPermissionList.getPermissionListCode())) {
            int code = this.getMaxCodeList();
            upPermissionList.setPermissionListCode(this.makeMaxCode8(++code));
        }
    }

    private int getMaxCodeList() {
        int code = 0;
        try {
            code = this.upPermissionListMapper.getMaxCode();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return code;
    }

    private Date getSysDate() {
        try {
            return this.upPermissionMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("up.PERMIS.PermissionServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private List<UpPermission> queryPermission(Map<String, Object> parammap) {
        try {
            return this.upPermissionMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("", (Throwable)e);
            return null;
        }
    }

    @Override
    public UpPermission getPermission(Integer permissionId) {
        return this.upPermissionMapper.selectByPrimaryKey(permissionId);
    }

    @Override
    public void updatePermission(UpPermissionDomainBean upPermissionDomainBean) throws ApiException {
        UpPermission upPermission = this.getPermission(upPermissionDomainBean.getPermissionId());
        if (upPermission == null) {
            throw new ApiException("up.PERMIS.PermissionServiceImpl.updatePermission.exsit", "\u8bb0\u5f55\u4e0d\u5b58\u5728");
        }
        String msg = this.check(upPermission = this.makeModel(upPermission, upPermissionDomainBean));
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("up.PERMIS.PermissionServiceImpl.updatePermission.null", msg);
        }
        this.setUpDefault(upPermission);
        this.updatePermissionModel(upPermission);
        this.setMpermissionFlag();
    }

    private void updatePermissionModel(UpPermission upPermission) throws ApiException {
        if (null == upPermission) {
            return;
        }
        try {
            this.upPermissionMapper.updateByPrimaryKey(upPermission);
        }
        catch (Exception e) {
            throw new ApiException("up.PERMIS.PermissionServiceImpl.updatePermissionModel.ex");
        }
    }

    private void updatePermissionListModel(UpPermissionList upPermissionList) throws ApiException {
        if (null == upPermissionList) {
            return;
        }
        try {
            this.upPermissionListMapper.updateByPrimaryKey(upPermissionList);
        }
        catch (Exception e) {
            throw new ApiException("up.PERMIS.PermissionServiceImpl.updatePermissionListModel.ex");
        }
    }

    private UpPermission makeModel(UpPermission upPermission, UpPermissionDomainBean upPermissionDomainBean) {
        if (upPermissionDomainBean == null) {
            return null;
        }
        if (upPermission == null) {
            upPermission = new UpPermission();
        }
        try {
            BeanUtils.copyAllPropertys((Object)upPermission, (Object)upPermissionDomainBean);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return upPermission;
    }

    private UpPermissionList makeModel(UpPermissionList upPermissionList, UpPermissionListDomainBean upPermissionListDomainBean) {
        if (upPermissionListDomainBean == null) {
            return null;
        }
        if (upPermissionList == null) {
            upPermissionList = new UpPermissionList();
        }
        try {
            BeanUtils.copyAllPropertys((Object)upPermissionList, (Object)upPermissionListDomainBean);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return upPermissionList;
    }

    @Override
    public List<UpPermission> queryUpPermission(Map<String, Object> map) {
        return this.queryPermission(map);
    }

    @Override
    public void deletePermission(Integer permissionId) {
        this.upPermissionMapper.deleteByPrimaryKey(permissionId);
        this.setMpermissionFlag();
    }

    @Override
    public void savePermissionList(UpPermissionListDomainBean upPermissionListDomainBean) throws ApiException {
        UpPermissionList upPermissionList = this.makeModel(null, upPermissionListDomainBean);
        String msg = this.check(upPermissionList);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("up.PERMIS.PermissionServiceImpl.savePermissionList.null", msg);
        }
        this.setDefault(upPermissionList);
        this.savePermissionListModel(upPermissionList);
        this.setMpermissionFlag();
    }

    private void savePermissionListModel(UpPermissionList upPermissionList) throws ApiException {
        if (null == upPermissionList) {
            return;
        }
        try {
            this.upPermissionListMapper.insert(upPermissionList);
        }
        catch (Exception e) {
            throw new ApiException("up.PERMIS.PermissionServiceImpl.savePermissionListModel.ex", (Throwable)e);
        }
    }

    private List<UpPermissionList> queryPermissionList(Map<String, Object> parammap) {
        try {
            return this.upPermissionListMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("", (Throwable)e);
            return null;
        }
    }

    @Override
    public UpPermissionList getPermissionList(Integer permissionListId) {
        return this.upPermissionListMapper.selectByPrimaryKey(permissionListId);
    }

    @Override
    public void updatePermissionList(UpPermissionListDomainBean upPermissionListDomainBean) throws ApiException {
        UpPermissionList upPermissionList = this.getPermissionList(upPermissionListDomainBean.getPermissionListId());
        if (upPermissionList == null) {
            throw new ApiException("up.PERMIS.PermissionServiceImpl.updatePermissionList.exsit", "\u8bb0\u5f55\u4e0d\u5b58\u5728");
        }
        String msg = this.check(upPermissionList = this.makeModel(upPermissionList, upPermissionListDomainBean));
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("up.PERMIS.PermissionServiceImpl.updatePermissionList.null", msg);
        }
        this.setUpDefault(upPermissionList);
        this.updatePermissionListModel(upPermissionList);
        this.setMpermissionFlag();
    }

    @Override
    public List<UpPermissionList> queryUpPermissionList(Map<String, Object> map) {
        return this.queryPermissionList(map);
    }

    @Override
    public void deletePermissionList(Integer permissionListId) {
        this.upPermissionListMapper.deleteByPrimaryKey(permissionListId);
        this.setMpermissionFlag();
    }

    @Override
    public QueryResult<UpPermission> queryUpPermissionPage(Map<String, Object> map) {
        List<UpPermission> upPermissionList = this.queryPermission(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countPermission(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(upPermissionList);
        return queryResult;
    }

    private int countPermission(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.upPermissionMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("up.PERMIS.PermissionServiceImpl.countPermission", (Throwable)e);
        }
        return i;
    }

    @Override
    public QueryResult<UpPermissionList> queryUpPermissionListPage(Map<String, Object> map) {
        List<UpPermissionList> upPermissionListList = this.queryPermissionList(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countPermissionList(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(upPermissionListList);
        return queryResult;
    }

    private int countPermissionList(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.upPermissionListMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("up.PERMIS.PermissionServiceImpl.countPermissionList", (Throwable)e);
        }
        return i;
    }

    @Override
    public void queryLocalCache() {
        String cachekey = "UpPermission-permission";
        String cachekeylist = "UpPermissionList-permissionList";
        String appkey = "UpPermissionList-appcode";
        this.logger.info("PermissionService.queryLocalCache", (Object)"===========start==========");
        List<UpPermission> list = this.queryPermission(null);
        ConcurrentHashMap<String, String> perAppMap = new ConcurrentHashMap<String, String>();
        if (null == list || list.isEmpty()) {
            DisUtil.delVer((String)cachekey);
            DisUtil.delVer((String)appkey);
            this.logger.info("PermissionService.queryLocalCache", (Object)"===========del-end==========");
            return;
        }
        ConcurrentHashMap<String, String> perMap = new ConcurrentHashMap<String, String>();
        for (UpPermission upPermission : list) {
            perMap.put(upPermission.getPermissionCode() + "-" + upPermission.getTenantCode(), JsonUtil.buildNormalBinder().toJson((Object)upPermission));
            if (!StringUtils.isNotBlank((String)upPermission.getAppmanageIcode())) continue;
            perAppMap.put(upPermission.getPermissionCode() + "-" + upPermission.getTenantCode(), upPermission.getAppmanageIcode());
        }
        DisUtil.setMapVer((String)cachekey, perMap);
        List<UpPermissionList> llist = this.queryPermissionList(null);
        if (null == llist || llist.isEmpty()) {
            DisUtil.delVer((String)cachekeylist);
            DisUtil.delVer((String)appkey);
            this.logger.info("PermissionService.queryLocalCache", (Object)"===========dellist-end==========");
        } else {
            ConcurrentHashMap<String, String> perMap2 = new ConcurrentHashMap<String, String>();
            ConcurrentHashMap<String, String> perListAppMap = new ConcurrentHashMap<String, String>();
            String appCode = null;
            for (UpPermissionList upPermissionList : llist) {
                perMap2.put(upPermissionList.getPermissionListAction() + "-" + upPermissionList.getPermissionListMethod() + "-" + upPermissionList.getTenantCode(), JsonUtil.buildNormalBinder().toJson((Object)upPermissionList));
                appCode = (String)perAppMap.get(upPermissionList.getPermissionCode() + "-" + upPermissionList.getTenantCode());
                if (!StringUtils.isNotBlank((String)appCode)) continue;
                perListAppMap.put(upPermissionList.getPermissionListAction() + "-" + upPermissionList.getTenantCode(), appCode);
            }
            DisUtil.setMapVer((String)cachekeylist, perMap2);
            DisUtil.setMapVer((String)appkey, perListAppMap);
        }
        this.logger.info("PermissionService.queryLocalCache", (Object)"===========add-end==========");
    }
}

