/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.plugin;

import freemarker.ext.beans.BeansWrapper;
import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.ClassPathResource;

public class FtlTranslationService {
    public static final String UTF_8 = "UTF-8";
    private static Log logger = LogFactory.getLog(FtlTranslationService.class);
    private Configuration conf = new Configuration();

    public void init() throws Exception {
        this.conf.setOutputEncoding(UTF_8);
        this.conf.setDefaultEncoding(UTF_8);
        this.conf.setClassForTemplateLoading(FtlTranslationService.class, "/freemarker/");
        try {
            ClassPathResource res = new ClassPathResource("freemarker/prop/freemarker.properties");
            this.conf.setSettings(res.getInputStream());
        }
        catch (Exception ex) {
            logger.warn((Object)"freemarker setting file error!  please check /META-INF/freemarker/prop/freemarker.properties!");
        }
    }

    public void translate(Object data, String tplName, String output) throws Exception {
        HashMap<String, Object> rootObj = new HashMap<String, Object>(3);
        rootObj.put("enums", BeansWrapper.getDefaultInstance().getEnumModels());
        rootObj.put("static", BeansWrapper.getDefaultInstance().getStaticModels());
        rootObj.put("data", data);
        Template t = this.conf.getTemplate(tplName, UTF_8);
        File outputFile = new File(output);
        outputFile.getParentFile().mkdirs();
        FileWriter writer = new FileWriter(outputFile);
        t.process(rootObj, (Writer)writer);
        rootObj.clear();
    }

    public void translateByString(Object data, String templateStr, String output) throws Exception {
        HashMap<String, Object> rootObj = new HashMap<String, Object>(3);
        rootObj.put("enums", BeansWrapper.getDefaultInstance().getEnumModels());
        rootObj.put("static", BeansWrapper.getDefaultInstance().getStaticModels());
        rootObj.put("data", data);
        Template template = new Template("template", (Reader)new StringReader(templateStr), this.conf);
        template.setEncoding(UTF_8);
        File outputFile = new File(output);
        outputFile.getParentFile().mkdirs();
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outputFile), UTF_8));
        template.process(rootObj, (Writer)writer);
        rootObj.clear();
    }

    public String returnTranslateByString(Object data, String templateStr) throws Exception {
        HashMap<String, Object> rootObj = new HashMap<String, Object>(3);
        rootObj.put("enums", BeansWrapper.getDefaultInstance().getEnumModels());
        rootObj.put("static", BeansWrapper.getDefaultInstance().getStaticModels());
        rootObj.put("data", data);
        Template template = new Template("template", (Reader)new StringReader(templateStr), this.conf);
        template.setEncoding(UTF_8);
        StringWriter writer = new StringWriter();
        template.process(rootObj, (Writer)writer);
        rootObj.clear();
        return ((Object)writer).toString();
    }
}

