<#include '/common/copyright.ftl' />
<#assign serverConfig={}>
<#if data??>
	<#if data.serverConfig??>
			<#assign serverConfig=data.serverConfig>
	</#if>
</#if>
<#if serverConfig.serverPkg??>
package ${serverConfig.serverPkg}.service.impl;
</#if>

<#if serverConfig.importslist??>
<#list serverConfig.importslist as importClass>
<#if importClass??>
import ${importClass};
</#if>
</#list>
</#if>
public class ${serverConfig.implementsStr}  extends BaseServiceImpl <#if serverConfig.interfaceStr??>implements ${serverConfig.interfaceStr}</#if>{
	private static final String SYS_CODE = ${serverConfig.constants}.SYS_CODE+".${serverConfig.implementsStr}";
<#list serverConfig.proList as pro>
	private ${pro.dao} ${pro.ldao};
</#list>
<#list serverConfig.proList as pro>
	public void set${pro.dao}(${pro.dao} ${pro.ldao}) {
		this.${pro.ldao} = ${pro.ldao};
	}
</#list>
<#if serverConfig.getsysdateDao??>
    /**
	 * 获取系统时间
	 * @return
	 */
	private Date getSysDate(){
		try{
			return ${serverConfig.getsysdateDao}.selectSysDate();
		}catch(Exception e){
			logger.error(SYS_CODE+".getSysDate", e);
		}
		return null;
	}
</#if>
<#list serverConfig.proList as pro>
	/**
	 * 检测${pro.daoName}参数
	 * @param ${pro.lname}${pro.domainName}
	 * @return
	 */
	private String check${pro.nick}(${pro.name}${pro.domainName} ${pro.lname}${pro.domainName}){
		if(null==${pro.lname}${pro.domainName}){
			return "参数为空";
		}
		String msg="";
		//TODO 需要根据当前对象做修改
		//if(StringUtils.isBlank(${pro.lname}${pro.domainName}.getFtpserverCode())){
		//	msg+= "FtpserverCode为空;";
		//}
		if(StringUtils.isBlank(${pro.lname}${pro.domainName}.getTenantCode())){
			msg+= "TenantCode为空;";
		}
		return msg;
	}
	
	/**
	 * 设置${pro.daoName}新增默认值
	 * @param ${pro.lname}
	 */
	private void set${pro.nick}Default(${pro.name} ${pro.lname}){
		if(null==${pro.lname})return;
		if(null==${pro.lname}.getDataState())${pro.lname}.setDataState(0);
		if(null==${pro.lname}.getGmtCreate())${pro.lname}.setGmtCreate(getSysDate());
		${pro.lname}.setGmtModified(getSysDate());
		if(StringUtils.isBlank(${pro.lname}.get${pro.uCodeName}())){
			${pro.lname}.set${pro.uCodeName}(createUUIDString());
		}
	}
	/**
     * 获取最大号
     * @return
     */
    @SuppressWarnings("unused")
    private int get${pro.nick}MaxCode() {
        int code = 0;
        try {
            return ${pro.ldao}.getMaxCode();
        } catch (Exception e) {
            logger.error(SYS_CODE + ".get${pro.nick}MaxCode", e);
        }
        return code;
    }
	
	/**
	 * 设置${pro.daoName}修改默认值
	 * @param ${pro.lname}
	 */
	private void set${pro.nick}UpdataDefault(${pro.name} ${pro.lname}){
		if(null==${pro.lname})return;
		${pro.lname}.setGmtModified(getSysDate());
	}
	
	/**
	 * 保存${pro.daoName}对象
	 * @param ${pro.lname}
	 * @throws ApiException
	 */
	private void save${pro.nick}Model(${pro.name} ${pro.lname}) throws ApiException{
		if(null==${pro.lname})return;
		try{
			${pro.ldao}.insert(${pro.lname});
		}catch(Exception e){
			throw new ApiException(SYS_CODE+".save${pro.nick}Model.ex", e);
		}
	}
	/**
	 * 批量保存${pro.daoName}对象
	 * @param ${pro.lname}List
	 * @throws ApiException
	 */
	private void save${pro.nick}BatchModel(List<${pro.name}> ${pro.lname}List) throws ApiException{
		if(null==${pro.lname}List||${pro.lname}List.isEmpty())return;
		try{
			${pro.ldao}.insertBatch(${pro.lname}List);
		}catch(Exception e){
			throw new ApiException(SYS_CODE+".save${pro.nick}BatchModel.ex", e);
		}
	}
	/**
	 * 获取${pro.daoName}信息
	 * @param ${pro.idName}
	 * @return ${pro.name}
	 */
	private ${pro.name} get${pro.nick}ModelById(Integer ${pro.idName}){
		if(null==${pro.idName})return null;
		try{
			return ${pro.ldao}.selectByPrimaryKey(${pro.idName});
		}catch(Exception e){
			logger.error(SYS_CODE+".get${pro.nick}ModelById", e);
		}
		return null;
	}
	
	/**
	 * 获取${pro.daoName}信息
	 * @param map<${pro.codeName},tenantCode(可以为空)>
	 * @return ${pro.name}
	 */
	public ${pro.name} get${pro.nick}ModelByCode(Map<String,Object> map){
		if(null==map||map.isEmpty())return null;
		try{
			return ${pro.ldao}.getByCode(map);
		}catch(Exception e){
			logger.error(SYS_CODE+".get${pro.nick}ModelByCode", e);
		}
		return null;
	}
	
	
	/**
	 * 删除${pro.daoName}信息
	 * @param map<${pro.codeName},tenantCode(可以为空)>
	 */
	public void del${pro.nick}ModelByCode(Map<String,Object> map){
		if(null==map||map.isEmpty())return;
		int i=0;
		try{
			i= ${pro.ldao}.delByCode(map);
		}catch(Exception e){
			throw new ApiException(SYS_CODE+".del${pro.nick}ModelByCode.ex", e);
		}
		if(1!=i){
			throw new ApiException(SYS_CODE+".del${pro.nick}ModelByCode.num");
		}
	}
	
	
	/**
	 * 删除${pro.daoName}信息
	 * @param ${pro.idName}
	 * @throws ApiException
	 */
	private void delete${pro.nick}Model(Integer ${pro.idName}) throws ApiException{
		if(null==${pro.idName})return;
		int i=0;
		try{
			i= ${pro.ldao}.deleteByPrimaryKey(${pro.idName});
		}catch(Exception e){
			throw new ApiException(SYS_CODE+".delete${pro.nick}Model.ex", e);
		}
		if(1!=i){
			throw new ApiException(SYS_CODE+".delete${pro.nick}Model.num");
		}
	}
	/**
	 * 更新${pro.daoName}对象
	 * @param ${pro.lname}
	 * @throws ApiException
	 */
	private void update${pro.nick}Model(${pro.name} ${pro.lname}) throws ApiException{
		if(null==${pro.lname})return;
		int i=0;
		try{
			i=${pro.ldao}.updateByPrimaryKeySelective(${pro.lname});
		}catch(Exception e){
			throw new ApiException(SYS_CODE+".update${pro.nick}Model.ex", e);
		}
		if(1!=i){
			throw new ApiException(SYS_CODE+".update${pro.nick}Model.num");
		}
	}
	/**
	 * 更新${pro.daoName}状态
	 * @param ${pro.idName}
	 * @param dataState
	 * @param oldDataState
	 * @throws ApiException
	 */
	private void updateState${pro.nick}Model(Integer ${pro.idName}, Integer dataState, Integer oldDataState) throws ApiException{
		if(null==${pro.idName}||null==dataState)return;
		Map<String,Object> map=new HashMap<String, Object>();
		map.put("${pro.idName}", ${pro.idName});
		map.put("dataState", dataState);
		map.put("oldDataState", oldDataState);
		int i=0;
		try{
			i=${pro.ldao}.updateStateByPrimaryKey(map);
		}catch(Exception e){
			throw new ApiException(SYS_CODE+".updateState${pro.nick}Model.ex", e);
		}
		if(i<=0){
			throw new ApiException(SYS_CODE+".updateState${pro.nick}Model.null");
		}
	}
	/**
	 * 更新${pro.daoName}状态
	 * @param tenantCode
	 * @param ${pro.codeName}
	 * @param dataState
	 * @param oldDataState
	 * @throws ApiException
	 */
	private void updateState${pro.nick}ModelByCode(String tenantCode,String ${pro.codeName}, Integer dataState, Integer oldDataState) throws ApiException{
		if(StringUtils.isBlank(${pro.codeName})||null==dataState)return;
		Map<String,Object> map=new HashMap<String, Object>();
		map.put("tenantCode",tenantCode);
		map.put("${pro.codeName}",${pro.codeName});
		map.put("dataState", dataState);
		map.put("oldDataState", oldDataState);
		int i=0;
		try{
			i=${pro.ldao}.updateStateByCode(map);
		}catch(Exception e){
			throw new ApiException(SYS_CODE+".updateState${pro.nick}ModelByCode.ex", e);
		}
		if(i<=0){
			throw new ApiException(SYS_CODE+".updateState${pro.nick}ModelByCode.null");
		}
	}
	
	/**
	 * domain转成${pro.daoName}MODEL
	 * @param ${pro.lname}${pro.domainName}
	 * @return ${pro.name}
	 */
	private ${pro.name} make${pro.nick}(${pro.name}${pro.domainName} ${pro.lname}${pro.domainName},${pro.name} ${pro.lname}){
		if(null==${pro.lname}${pro.domainName})return null;
		if(null==${pro.lname}) ${pro.lname}=new ${pro.name}();
		try {
			BeanUtils.copyAllPropertys(${pro.lname}, ${pro.lname}${pro.domainName});
			return ${pro.lname};
		} catch (Exception e) {
			logger.error(SYS_CODE+".make${pro.nick}", e);
		}
		return null;
	}
	
	/**
	 * ${pro.daoName}MODEL转成Redomain
	 * @param ${pro.name}
	 * @return ${pro.domainName}
	 */
	@SuppressWarnings("unused")
	private ${pro.name}Re${pro.domainName} make${pro.name}Re${pro.domainName}(${pro.name} ${pro.lname}){
		if(null==${pro.lname})return null;
		${pro.name}Re${pro.domainName} ${pro.lname}Re${pro.domainName}=new ${pro.name}Re${pro.domainName}();
		try {
			BeanUtils.copyAllPropertys(${pro.lname}Re${pro.domainName}, ${pro.lname});
			return ${pro.lname}Re${pro.domainName};
		} catch (Exception e) {
			logger.error(SYS_CODE+".make${pro.name}Re${pro.domainName}", e);
		}
		return null;
	}
	
	/**
	 * 分页查询${pro.daoName}
	 * @param parammap
	 * @return ${pro.name}
	 */
	private List<${pro.name}> query${pro.nick}ModelPage(Map<String, Object> parammap) {
		try{
			return ${pro.ldao}.query(parammap);
		}catch(Exception e){
			logger.error(SYS_CODE+".query${pro.nick}Model", e);
		}
		return null;
	}
	/**
	 * 获取记录数
	 * @param map
	 * @return 记录数
	 */
	private int count${pro.nick}(Map<String, Object> map) {
		int i = 0;
		try {
			i = ${pro.ldao}.count(map);
		} catch (Exception e) {
			logger.error(SYS_CODE+".count${pro.nick}", e);
		}
		return i;
	}
	/**
	 * ${pro.lname}${pro.domainName}转成${pro.name}
	 * @param ${pro.lname}${pro.domainName}
	 * @return ${pro.name}
	 */
	private ${pro.name} create${pro.name}(${pro.name}${pro.domainName} ${pro.lname}${pro.domainName}) {
		//1.检测
		String msg=check${pro.nick}(${pro.lname}${pro.domainName});
		if(StringUtils.isNotBlank(msg)){
			throw new ApiException(SYS_CODE+".save${pro.nick}.check${pro.nick}", msg);
		}
		//2.转成MODEL
		${pro.name} ${pro.lname}=make${pro.nick}(${pro.lname}${pro.domainName}, null);
		//3.默认值
		set${pro.nick}Default(${pro.lname});
		return ${pro.lname};
	}
</#list>

	
<#list serverConfig.proList as pro>
	@Override
	public String save${pro.nick}(${pro.name}${pro.domainName} ${pro.lname}${pro.domainName}) throws ApiException {
		${pro.name} ${pro.lname}=create${pro.name}(${pro.lname}${pro.domainName});
		//4.保存
		save${pro.nick}Model(${pro.lname});
		return ${pro.lname}.get${pro.uCodeName}();
	}

	@Override
	public String save${pro.nick}Batch(List<${pro.name}${pro.domainName}> ${pro.lname}${pro.domainName}List) throws ApiException{
		if(null==${pro.lname}${pro.domainName}List||${pro.lname}${pro.domainName}List.isEmpty())return null;
		List<${pro.name}> ${pro.lname}List=new ArrayList<${pro.name}>();
		${pro.name} ${pro.lname};
		String code="";
		for (${pro.name}${pro.domainName} ${pro.lname}${pro.domainName} : ${pro.lname}${pro.domainName}List) {
			${pro.lname}=create${pro.name}(${pro.lname}${pro.domainName});
			code=${pro.lname}.get${pro.uCodeName}();
			${pro.lname}List.add(${pro.lname});
		}
		save${pro.nick}BatchModel(${pro.lname}List);
		return code;
	}
	
	@Override
	public void update${pro.nick}State(Integer ${pro.idName}, Integer dataState, Integer oldDataState)
			throws ApiException {
		updateState${pro.nick}Model(${pro.idName}, dataState, oldDataState);
	}
	
	@Override
	public void update${pro.nick}StateByCode(String tenantCode,String ${pro.codeName}, Integer dataState, Integer oldDataState)
			throws ApiException {
		updateState${pro.nick}ModelByCode(tenantCode,${pro.codeName}, dataState, oldDataState);
	}
	

	@Override
	public void update${pro.nick}(${pro.name}${pro.domainName} ${pro.lname}${pro.domainName}) throws ApiException {
		//1.检测
		String msg=check${pro.nick}(${pro.lname}${pro.domainName});
		if(StringUtils.isNotBlank(msg)){
			throw new ApiException(SYS_CODE+".update${pro.nick}.check${pro.nick}", msg);
		}
		//2.获取MODEL
		${pro.name} old${pro.name}=get${pro.nick}ModelById(${pro.lname}${pro.domainName}.${pro.getidName}());
		if(null==old${pro.name}){
			throw new ApiException(SYS_CODE+".update${pro.nick}.null", "数据为空");
		}
		//3.转成MODEL
		${pro.name} ${pro.lname}=make${pro.nick}(${pro.lname}${pro.domainName}, old${pro.name});
		//4.默认值
		set${pro.nick}UpdataDefault(${pro.lname});
		//5.保存
		update${pro.nick}Model(${pro.lname});
	}

	@Override
	public ${pro.name} get${pro.nick}(Integer ${pro.idName}) {
		return get${pro.nick}ModelById(${pro.idName});
	}

	@Override
	public void delete${pro.nick}(Integer ${pro.idName}) throws ApiException {
		delete${pro.nick}Model(${pro.idName});
	}

	@Override
	public QueryResult<${pro.name}> query${pro.nick}Page(Map<String, Object> map) {
		List<${pro.name}> ${pro.lname}List = query${pro.nick}ModelPage(map);
		QueryResult<${pro.name}> queryResult = new QueryResult<${pro.name}>();
		PageTools pageTools = new PageTools();
		pageTools.setRecordCount(count${pro.nick}(map));
		queryResult.setPageTools(pageTools);
		queryResult.setList(${pro.lname}List);
		return queryResult;
	}
	
	@Override
	public ${pro.name} get${pro.nick}ByCode(String tenantCode,String ${pro.codeName}) throws ApiException{
		Map<String, Object> map = new HashMap<String, Object>();
		map.put("tenantCode", tenantCode);
		map.put("${pro.codeName}", ${pro.codeName});
		return get${pro.nick}ModelByCode(map);
	}

	@Override
	public void del${pro.nick}ByCode(String tenantCode,String ${pro.codeName}) throws ApiException {
		Map<String, Object> map = new HashMap<String, Object>();
		map.put("tenantCode", tenantCode);
		map.put("${pro.codeName}", ${pro.codeName});
		del${pro.nick}ModelByCode(map);
	}

</#list>

}
