/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.plugin;

import com.yqbsoft.laser.service.plugin.FtlTranslationService;
import com.yqbsoft.laser.service.plugin.ServerConfig;
import com.yqbsoft.laser.service.plugin.ServerProConfig;
import com.yqbsoft.laser.service.tool.util.FileUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;

public class SpringXml {
    public static String outputDir = "src\\main\\resources\\";

    public static void addPom(String filepath, String app) {
        File servicefile = new File(filepath);
        if (servicefile.exists()) {
            SpringXml.addpom(servicefile, app);
        }
    }

    public static void add(FtlTranslationService ftlTranslationService, ServerConfig serverConfig, Map<String, Object> data) {
        if (null == serverConfig) {
            return;
        }
        String pakge = serverConfig.getServerPkg().replace(".", "/");
        String xmlpath = outputDir + pakge + "/springxml/";
        String dao = xmlpath + "applicationContext-dao.xml";
        String service = xmlpath + "applicationContext-service.xml";
        File servicefile = new File(service);
        if (!servicefile.exists()) {
            try {
                ftlTranslationService.translate(data, "servicexml.ftl", service);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            SpringXml.addservice(servicefile, serverConfig);
        }
        File daofile = new File(dao);
        if (!daofile.exists()) {
            try {
                ftlTranslationService.translate(data, "daoxml.ftl", dao);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            SpringXml.addDao(daofile, serverConfig);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addpom(File file, String app) {
        if (null == file || null == app) {
            System.out.println("null");
            return;
        }
        String strContent = "";
        boolean flag = false;
        boolean jarflag = false;
        boolean proflag = false;
        boolean depflag = false;
        boolean modflag = false;
        if (file.exists()) {
            int i;
            InputStreamReader read = null;
            BufferedReader br = null;
            try {
                String s;
                read = new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8");
                br = new BufferedReader(read);
                while ((s = br.readLine()) != null) {
                    String olds = s;
                    if ("".equals(s = s.trim())) continue;
                    if (s.indexOf("<qjsoft-laser-controller-facade-" + app + ".version>") >= 0) {
                        proflag = true;
                    }
                    if (s.indexOf("<artifactId>qjsoft-laser-controller-facade-" + app + "</artifactId>") >= 0) {
                        depflag = true;
                    }
                    if (s.indexOf("<module>qjsoft-laser-controller-facade-" + app + "</module>") >= 0) {
                        modflag = true;
                    }
                    if (!proflag && s.indexOf("</properties>") == 0) {
                        strContent = strContent + "\t    <qjsoft-laser-controller-facade-" + app + ".version>1.0.0</qjsoft-laser-controller-facade-" + app + ".version>" + "\n";
                        flag = true;
                    }
                    if (!depflag && s.indexOf("</dependencies>") == 0 && !jarflag) {
                        strContent = strContent + "\t\t\t<dependency>\n";
                        strContent = strContent + "\t\t\t\t<groupId>com.qjsoft.laser.controller</groupId>\n";
                        strContent = strContent + "\t\t\t\t<artifactId>qjsoft-laser-controller-facade-" + app + "</artifactId>" + "\n";
                        strContent = strContent + "\t\t\t\t<version>${qjsoft-laser-controller-facade-" + app + ".version}</version>" + "\n";
                        strContent = strContent + "\t\t\t</dependency>\n";
                        flag = true;
                        jarflag = true;
                        depflag = true;
                    }
                    if (!modflag && s.indexOf("</modules>") == 0) {
                        strContent = strContent + "    \t<module>qjsoft-laser-controller-facade-" + app + "</module>" + "\n";
                        flag = true;
                        modflag = true;
                    }
                    strContent = strContent + olds + "\n";
                }
            }
            catch (Exception e) {
                System.out.println("==============\u5f02\u5e38=============");
                e.printStackTrace();
            }
            finally {
                try {
                    read.close();
                    br.close();
                }
                catch (IOException e) {}
            }
            if (flag && -1 == (i = FileUtil.writeFile((File)file, (String)strContent, (String)"utf-8"))) {
                System.out.println("==============\u5f02\u5e381=============");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addservice(File file, ServerConfig serverConfig) {
        if (null == file || null == serverConfig) {
            System.out.println("null");
            return;
        }
        String strContent = "";
        HashMap<String, String> daomap = new HashMap<String, String>();
        daomap.put(serverConfig.getLinterfaceStr(), serverConfig.getImplementsStr());
        boolean flag = false;
        if (file.exists()) {
            int i;
            InputStreamReader read = null;
            BufferedReader br = null;
            try {
                String s;
                read = new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8");
                br = new BufferedReader(read);
                while ((s = br.readLine()) != null) {
                    String olds = s;
                    if ("".equals(s = s.trim())) continue;
                    if (s.indexOf("<bean ") == 0) {
                        for (String key : daomap.keySet()) {
                            if (s.indexOf(key) <= 0) continue;
                            daomap.remove(key);
                        }
                    } else if (s.indexOf("</beans>") == 0 && !daomap.isEmpty()) {
                        for (String key : daomap.keySet()) {
                            strContent = strContent + "\t   <bean id=\"" + key + "\" parent=\"baseTransactionProxy\">" + "\n";
                            strContent = strContent + "\t\t  <property name=\"target\">\n";
                            strContent = strContent + "\t         <bean class=\"" + serverConfig.getServerPkg() + ".service.impl." + (String)daomap.get(key) + "\">" + "\n";
                            strContent = strContent + "\t         </bean>\n";
                            strContent = strContent + "       </property>\n";
                            strContent = strContent + "    </bean>\n";
                            flag = true;
                        }
                    }
                    strContent = strContent + olds + "\n";
                }
            }
            catch (Exception e) {
                System.out.println("==============\u5f02\u5e38=============");
                e.printStackTrace();
            }
            finally {
                try {
                    read.close();
                    br.close();
                }
                catch (IOException e) {}
            }
            if (flag && -1 == (i = FileUtil.writeFile((File)file, (String)strContent, (String)"utf-8"))) {
                System.out.println("==============\u5f02\u5e381=============");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addDao(File file, ServerConfig serverConfig) {
        if (null == file || null == serverConfig) {
            System.out.println("null");
            return;
        }
        String strContent = "";
        HashMap<String, String> daomap = new HashMap<String, String>();
        for (ServerProConfig serverProConfig : serverConfig.getProList()) {
            daomap.put(serverProConfig.getLdao(), serverProConfig.getDao());
        }
        HashMap ndaomap = new HashMap();
        boolean flag = false;
        if (file.exists()) {
            int i;
            InputStreamReader read = null;
            BufferedReader br = null;
            try {
                String s;
                read = new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8");
                br = new BufferedReader(read);
                while ((s = br.readLine()) != null) {
                    String olds = s;
                    if ("".equals(s = s.trim())) continue;
                    if (s.indexOf("<bean ") == 0) {
                        for (String key : daomap.keySet()) {
                            if (s.indexOf(key) <= 0) continue;
                            ndaomap.put(key, daomap.get(key));
                        }
                    } else if (s.indexOf("</beans>") == 0 && !daomap.isEmpty()) {
                        for (String key : daomap.keySet()) {
                            if (ndaomap.containsKey(key)) continue;
                            strContent = strContent + "\t   <bean id=\"" + key + "\" class=\"org.mybatis.spring.mapper.MapperFactoryBean\">" + "\n";
                            strContent = strContent + "\t   \t   <property name=\"mapperInterface\" value=\"" + serverConfig.getServerPkg() + ".dao." + (String)daomap.get(key) + "\"></property>" + "\n";
                            strContent = strContent + "\t   </bean>\n";
                            flag = true;
                        }
                    }
                    strContent = strContent + olds + "\n";
                }
            }
            catch (Exception e) {
                System.out.println("==============\u5f02\u5e38=============");
                e.printStackTrace();
            }
            finally {
                try {
                    read.close();
                    br.close();
                }
                catch (IOException e) {}
            }
            if (flag && -1 == (i = FileUtil.writeFile((File)file, (String)strContent, (String)"utf-8"))) {
                System.out.println("==============\u5f02\u5e381=============");
            }
        }
    }
}

