/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.plugin;

import com.yqbsoft.laser.service.plugin.FtlTranslationService;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.mybatis.generator.api.IntrospectedColumn;
import org.mybatis.generator.api.IntrospectedTable;
import org.mybatis.generator.api.Plugin;
import org.mybatis.generator.api.PluginAdapter;
import org.mybatis.generator.api.dom.java.Field;
import org.mybatis.generator.api.dom.java.TopLevelClass;
import org.mybatis.generator.config.Context;
import org.mybatis.generator.config.TableConfiguration;
import org.mybatis.generator.internal.util.StringUtility;
import org.mybatis.generator.logging.Log;
import org.mybatis.generator.logging.LogFactory;

public class DomainClassPlugin
extends PluginAdapter {
    private static final String ALL = "*";
    private static final String COMMA = "[,]";
    private static final String DOMAIN_SUFFIX = "Domain";
    private static final String CONVERTER_SUFFIX = "Converter";
    private Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    protected List<String> tableNames = new ArrayList<String>();
    protected List<String> defaultExcludeColumns = new ArrayList<String>();
    protected String defaultPackage;
    private boolean allTables = false;
    private String rootClass = null;
    private String rootInterface = null;
    private List<DomainConfig> domainConfigs = new ArrayList<DomainConfig>();
    private boolean generateConverter = false;
    private String outputDir;
    private FtlTranslationService ftlTranslationService = new FtlTranslationService();
    private Set<String> imports = new HashSet<String>();

    public boolean validate(List<String> warnings) {
        String importConfig;
        String rootInterface;
        String defaultPkg;
        String domainTables = this.properties.getProperty("tableNames");
        if (!StringUtility.stringHasValue((String)domainTables)) {
            this.log.error("property tableNames can not be null.");
            return false;
        }
        if (ALL.equals(domainTables)) {
            this.allTables = true;
        } else {
            List<String> tableNameDefs = Arrays.asList(domainTables.toUpperCase().split(COMMA));
            for (String tableName : tableNameDefs) {
                this.tableNames.add(tableName.trim());
            }
        }
        String defaultExcludeColumn = this.properties.getProperty("defaultExcludeFields");
        if (StringUtility.stringHasValue((String)defaultExcludeColumn)) {
            this.defaultExcludeColumns = Arrays.asList(defaultExcludeColumn.split(COMMA));
        }
        if (!StringUtility.stringHasValue((String)(defaultPkg = this.properties.getProperty("defaultPackage")))) {
            this.log.error("property defaultPackage can not be null.");
            return false;
        }
        String output = this.properties.getProperty("outputDir");
        if (!StringUtility.stringHasValue((String)output)) {
            this.log.error("property outputDir can not be null.");
            return false;
        }
        this.outputDir = output;
        this.defaultPackage = defaultPkg;
        String rootClass = this.properties.getProperty("rootClass");
        if (StringUtility.stringHasValue((String)rootClass)) {
            this.rootClass = rootClass;
        }
        if (StringUtility.stringHasValue((String)(rootInterface = this.properties.getProperty("rootInterface")))) {
            this.rootInterface = rootInterface;
        }
        if (StringUtility.stringHasValue((String)(importConfig = this.properties.getProperty("imports")))) {
            String[] importsArray;
            for (String importsStr : importsArray = importConfig.split(COMMA)) {
                this.imports.add(importsStr);
            }
        }
        String gconverter = this.properties.getProperty("generateConverter");
        this.generateConverter = StringUtility.isTrue((String)gconverter);
        try {
            this.ftlTranslationService.init();
        }
        catch (Exception e) {
            this.log.error("\u521d\u59cb\u5316\u6a21\u677f\u5931\u8d25." + e.getMessage());
        }
        return true;
    }

    public boolean modelFieldGenerated(Field field, TopLevelClass topLevelClass, IntrospectedColumn introspectedColumn, IntrospectedTable introspectedTable, Plugin.ModelClassType modelClassType) {
        String remark = introspectedColumn.getRemarks();
        if (remark != null && remark.trim().length() > 0 && !"null".equals(remark) && field.getJavaDocLines().isEmpty()) {
            field.addJavaDocLine("/**");
            field.addJavaDocLine(" * " + remark.replaceAll("\r|\n|\r\n", ""));
            field.addJavaDocLine(" */");
        }
        return super.modelFieldGenerated(field, topLevelClass, introspectedColumn, introspectedTable, modelClassType);
    }

    public boolean modelBaseRecordClassGenerated(TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        block10: {
            try {
                if (this.allTables || this.tableNames.contains(introspectedTable.getTableConfiguration().getTableName().toUpperCase())) {
                    DomainConfig domainConfig = this.generateDomainConfig(introspectedTable, topLevelClass);
                    this.domainConfigs.add(domainConfig);
                    if (this.generateConverter) {
                        // empty if block
                    }
                    HashMap<String, DomainConfig> data = new HashMap<String, DomainConfig>();
                    data.put("domainConfig", domainConfig);
                    try {
                        this.ftlTranslationService.translate(data, "domain.ftl", this.outputDir + "/" + domainConfig.getFilePath());
                        List<String> imports = domainConfig.getImports();
                        imports.remove("com.yqbsoft.laser.service.esb.core.transformer.BaseDomain");
                        if (imports.indexOf("java.util.Date") < 0) {
                            imports.add("java.util.Date");
                        }
                        domainConfig.setSuperClass(domainConfig.getDomainClass());
                        domainConfig.setDomainClass(domainConfig.getDomainClass().replace(DOMAIN_SUFFIX, "ReDomain"));
                        this.ftlTranslationService.translate(data, "redomain.ftl", this.outputDir + "/" + domainConfig.getFilePath());
                    }
                    catch (Exception e) {
                        this.log.error("\u5904\u7406\u6a21\u677f\u5931\u8d25." + e.getMessage());
                    }
                    List<DomainColumnConfig> domainColumnConfigs = domainConfig.getDomainColumnConfigs();
                    for (DomainColumnConfig domainColumnConfig : domainColumnConfigs) {
                        File enumFilePath;
                        if (domainColumnConfig.getType() == null || !domainColumnConfig.getType().equals("enum") || (enumFilePath = new File(this.outputDir + "/" + domainColumnConfig.getFilePath())).exists()) continue;
                        HashMap<String, DomainColumnConfig> columnData = new HashMap<String, DomainColumnConfig>();
                        columnData.put("domainColumnConfig", domainColumnConfig);
                        try {
                            this.ftlTranslationService.translate(columnData, "enum.ftl", this.outputDir + "/" + domainColumnConfig.getFilePath());
                        }
                        catch (Exception e) {
                            this.log.error("\u5904\u7406\u6a21\u677f\u5931\u8d25." + e.getMessage());
                        }
                    }
                    break block10;
                }
                this.log.debug(introspectedTable.getTableConfiguration().getTableName().toUpperCase() + "\u4e0d\u9700\u8981\u751f\u6210domain\u5bf9\u8c61");
            }
            catch (Exception e) {
                this.log.error("\u5904\u7406Domain\u5931\u8d25." + e.getMessage());
            }
        }
        return true;
    }

    private DomainConfig generateDomainConfig(IntrospectedTable introspectedTable, TopLevelClass topLevelClass) {
        DomainConfig domainConfig = null;
        TableConfiguration tableConfiguration = this.getTableConfig(introspectedTable.getFullyQualifiedTable().getIntrospectedTableName());
        String tableDomainPkg = this.getTableProperty(tableConfiguration, "domainClass.package", this.defaultPackage);
        String className = this.getTableProperty(tableConfiguration, "domainClass.className", topLevelClass.getType().getShortName() + DOMAIN_SUFFIX);
        String subPkg = this.getTableProperty(tableConfiguration, "domainClass.subpackage", null);
        String domainExcludeColumn = this.getTableProperty(tableConfiguration, "domainClass.domainExcludeFields", null);
        String superClass = this.getTableProperty(tableConfiguration, "domainClass.rootClass", this.rootClass);
        String superInterface = this.getTableProperty(tableConfiguration, "domainClass.rootInterface", this.rootInterface);
        String codeColumn = this.getTableProperty(tableConfiguration, "codeColumn", null);
        domainConfig = new DomainConfig();
        domainConfig.setDomainClass(className);
        domainConfig.setDomainPkg(tableDomainPkg);
        domainConfig.setDomainSubPkg(subPkg);
        domainConfig.setDoClass(topLevelClass);
        domainConfig.setCodeColumn(codeColumn);
        List<String> excludeFields = this.generateExcludeDomainColumn(domainExcludeColumn);
        domainConfig.setExcludeDomainColumn(excludeFields);
        domainConfig.setInterfaceClass(superInterface);
        domainConfig.setSuperClass(superClass);
        ArrayList<String> importsSet = new ArrayList<String>();
        importsSet.addAll(this.imports);
        if ("Serializable".equals(superInterface) && !importsSet.contains("java.io.Serializable")) {
            importsSet.add("java.io.Serializable");
        }
        if ("BaseDomain".equals(superClass) && !superClass.contains("com.yqbsoft.laser.service.esb.core.transformer.BaseDomain")) {
            importsSet.add("com.yqbsoft.laser.service.esb.core.transformer.BaseDomain");
        }
        ArrayList<DomainColumnConfig> domainColumnConfigMap = new ArrayList<DomainColumnConfig>();
        for (Field field : topLevelClass.getFields()) {
            if (excludeFields.contains(field.getName())) {
                this.log.debug(field.getName() + "\u88ab\u5ffd\u7565.");
                continue;
            }
            DomainColumnConfig domainColumnConfig = this.generateDomainColumnConfig(tableConfiguration, field, domainConfig);
            domainColumnConfigMap.add(domainColumnConfig);
            String typeClass = domainColumnConfig.getTypeClass();
            if (typeClass.startsWith("java.lang.") || importsSet.contains(typeClass)) continue;
            importsSet.add(typeClass);
        }
        domainConfig.setImports(importsSet);
        domainConfig.setDomainColumnConfigs(domainColumnConfigMap);
        String converterClass = this.getTableProperty(tableConfiguration, "domainClass.converter", topLevelClass.getType().getShortName() + CONVERTER_SUFFIX);
        domainConfig.setConverter(converterClass);
        return domainConfig;
    }

    private DomainColumnConfig generateDomainColumnConfig(TableConfiguration tableConfiguration, Field field, DomainConfig domainConfig) {
        DomainColumnConfig domainColumnConfig = new DomainColumnConfig();
        domainColumnConfig.setDoFeild(field);
        String fieldName = field.getName();
        domainColumnConfig.setName(fieldName);
        String typeClass = null;
        String type = this.getTableProperty(tableConfiguration, fieldName + "." + "type", null);
        if (type != null) {
            if (type.startsWith("enum:")) {
                String enumName = type.substring("enum:".length());
                if (enumName.trim().length() == 0) {
                    String enumPkg = domainConfig.getDomainPkg();
                    if (domainConfig.getDomainSubPkg() != null) {
                        enumPkg = enumPkg + "." + domainConfig.getDomainSubPkg();
                    }
                    String enumClassName = Character.toUpperCase(fieldName.charAt(0)) + fieldName.substring(1);
                    enumName = enumPkg + "." + enumClassName + "Kind";
                }
                domainColumnConfig.setTypeClass(enumName);
                domainColumnConfig.setType("enum");
                String simpleTypeClass = enumName;
                String pkg = "";
                if (enumName.indexOf(".") != -1) {
                    simpleTypeClass = enumName.substring(enumName.lastIndexOf(".") + 1);
                    pkg = enumName.substring(0, enumName.lastIndexOf("."));
                }
                domainColumnConfig.setPkg(pkg);
                domainColumnConfig.setSimpleTypeClass(simpleTypeClass);
                typeClass = simpleTypeClass;
                String enumDef = this.getTableProperty(tableConfiguration, field.getName() + "." + "enumDef", null);
                domainColumnConfig.setEnumDef(this.generateEnumDef(enumDef));
            } else if (type.startsWith("ref:")) {
                String enumName = type.substring(type.indexOf("ref:"));
                domainColumnConfig.setTypeClass(enumName);
                domainColumnConfig.setType("ref");
                String simpleTypeClass = enumName;
                if (simpleTypeClass.indexOf(".") != -1) {
                    simpleTypeClass = simpleTypeClass.substring(simpleTypeClass.indexOf(".") + 1);
                }
                domainColumnConfig.setSimpleTypeClass(simpleTypeClass);
                typeClass = simpleTypeClass;
            }
        } else {
            domainColumnConfig.setType(null);
            typeClass = field.getType().getFullyQualifiedName();
            domainColumnConfig.setTypeClass(typeClass);
            String simpleTypeClass = field.getType().getShortName();
            domainColumnConfig.setSimpleTypeClass(simpleTypeClass);
            domainColumnConfig.setJavaDocLines(field.getJavaDocLines());
            domainColumnConfig.setGetterName(this.getGetterMethodName(field.getName(), typeClass));
            domainColumnConfig.setSetterName(this.getSetterMethodName(field.getName()));
        }
        domainColumnConfig.setGetterName(this.getGetterMethodName(field.getName(), typeClass));
        domainColumnConfig.setSetterName(this.getSetterMethodName(field.getName()));
        return domainColumnConfig;
    }

    public EnumDef generateEnumDef(String enumDefStr) {
        if (enumDefStr == null || enumDefStr.trim().length() == 0) {
            return null;
        }
        EnumDef enumDef = new EnumDef();
        String[] columns = enumDefStr.split(COMMA);
        if (columns.length < 2) {
            return null;
        }
        enumDef.setAttributes(Arrays.asList(columns[0].split("[:]")));
        ArrayList<List<String>> attributeValues = new ArrayList<List<String>>();
        for (int i = 1; i < columns.length; ++i) {
            String column = columns[i];
            attributeValues.add(Arrays.asList(column.split("[:]")));
        }
        enumDef.setAttributeValues(attributeValues);
        return enumDef;
    }

    public String getGetterMethodName(String property, String type) {
        StringBuilder sb = new StringBuilder();
        sb.append(property);
        if (Character.isLowerCase(sb.charAt(0)) && (sb.length() == 1 || !Character.isUpperCase(sb.charAt(1)))) {
            sb.setCharAt(0, Character.toUpperCase(sb.charAt(0)));
        }
        if (type.equals("boolean")) {
            sb.insert(0, "is");
        } else {
            sb.insert(0, "get");
        }
        return sb.toString();
    }

    public String getSetterMethodName(String property) {
        StringBuilder sb = new StringBuilder();
        sb.append(property);
        if (Character.isLowerCase(sb.charAt(0)) && (sb.length() == 1 || !Character.isUpperCase(sb.charAt(1)))) {
            sb.setCharAt(0, Character.toUpperCase(sb.charAt(0)));
        }
        sb.insert(0, "set");
        return sb.toString();
    }

    private List<String> generateExcludeDomainColumn(String domainExcludeColumn) {
        ArrayList<String> excludeColumnList = new ArrayList<String>();
        if (StringUtility.stringHasValue((String)domainExcludeColumn)) {
            excludeColumnList.addAll(Arrays.asList(domainExcludeColumn.split(COMMA)));
        }
        excludeColumnList.addAll(this.defaultExcludeColumns);
        ArrayList<String> ret = new ArrayList<String>();
        for (String c : excludeColumnList) {
            if (ret.contains(c)) continue;
            ret.add(c);
        }
        return ret;
    }

    private String getTableProperty(TableConfiguration tableConfiguration, String name, String defaultValue) {
        String value = tableConfiguration.getProperty(name);
        if (!StringUtility.stringHasValue((String)value)) {
            return defaultValue;
        }
        return value;
    }

    private TableConfiguration getTableConfig(String tableName) {
        Context context = this.getContext();
        List tableConfigurations = context.getTableConfigurations();
        for (TableConfiguration tableConfiguration : tableConfigurations) {
            if (!tableName.equalsIgnoreCase(tableConfiguration.getTableName())) continue;
            return tableConfiguration;
        }
        return null;
    }

    public static class EnumDef {
        private List<String> attributes;
        private List<List<String>> attributeValues;

        public List<String> getAttributes() {
            return this.attributes;
        }

        public void setAttributes(List<String> attributes) {
            this.attributes = attributes;
        }

        public List<List<String>> getAttributeValues() {
            return this.attributeValues;
        }

        public void setAttributeValues(List<List<String>> attributeValues) {
            this.attributeValues = attributeValues;
        }

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
        }
    }

    public static class DomainColumnConfig {
        private String name;
        private String typeClass;
        private String type;
        private Field doFeild;
        private String simpleTypeClass;
        private String getterName;
        private String setterName;
        private String pkg;
        private EnumDef enumDef;
        private List<String> imports;
        private List<String> javaDocLines;

        public List<String> getJavaDocLines() {
            return this.javaDocLines;
        }

        public void setJavaDocLines(List<String> javaDocLines) {
            this.javaDocLines = javaDocLines;
        }

        public List<String> getImports() {
            return this.imports;
        }

        public void setImports(List<String> imports) {
            this.imports = imports;
        }

        public EnumDef getEnumDef() {
            return this.enumDef;
        }

        public void setEnumDef(EnumDef enumDef) {
            this.enumDef = enumDef;
        }

        public String getPkg() {
            return this.pkg;
        }

        public void setPkg(String pkg) {
            this.pkg = pkg;
        }

        public String getGetterName() {
            return this.getterName;
        }

        public void setGetterName(String getterName) {
            this.getterName = getterName;
        }

        public String getSetterName() {
            return this.setterName;
        }

        public void setSetterName(String setterName) {
            this.setterName = setterName;
        }

        public String getSimpleTypeClass() {
            return this.simpleTypeClass;
        }

        public void setSimpleTypeClass(String simpleTypeClass) {
            this.simpleTypeClass = simpleTypeClass;
        }

        public Field getDoFeild() {
            return this.doFeild;
        }

        public void setDoFeild(Field doFeild) {
            this.doFeild = doFeild;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getTypeClass() {
            return this.typeClass;
        }

        public void setTypeClass(String typeClass) {
            this.typeClass = typeClass;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
        }

        public String getFilePath() {
            StringBuilder s = new StringBuilder();
            s.append(this.pkg.replaceAll("[.]", "/"));
            s.append("/").append(this.simpleTypeClass).append(".java");
            return s.toString();
        }
    }

    public static class DomainConfig {
        private String codeColumn;
        private String domainPkg;
        private String domainSubPkg;
        private String domainClass;
        private String converter;
        private List<String> excludeDomainColumn;
        private List<DomainColumnConfig> domainColumnConfigs;
        private TopLevelClass doClass;
        private String interfaceClass;
        private String superClass;
        private List<String> imports;

        public String getCodeColumn() {
            return this.codeColumn;
        }

        public void setCodeColumn(String codeColumn) {
            this.codeColumn = codeColumn;
        }

        public List<String> getImports() {
            return this.imports;
        }

        public void setImports(List<String> imports) {
            this.imports = imports;
        }

        public String getDomainPkg() {
            return this.domainPkg;
        }

        public void setDomainPkg(String domainPkg) {
            this.domainPkg = domainPkg;
        }

        public String getInterfaceClass() {
            return this.interfaceClass;
        }

        public void setInterfaceClass(String interfaceClass) {
            this.interfaceClass = interfaceClass;
        }

        public String getSuperClass() {
            return this.superClass;
        }

        public void setSuperClass(String superClass) {
            this.superClass = superClass;
        }

        public TopLevelClass getDoClass() {
            return this.doClass;
        }

        public void setDoClass(TopLevelClass doClass) {
            this.doClass = doClass;
        }

        public String getDomainSubPkg() {
            return this.domainSubPkg;
        }

        public void setDomainSubPkg(String domainSubPkg) {
            this.domainSubPkg = domainSubPkg;
        }

        public String getDomainClass() {
            return this.domainClass;
        }

        public void setDomainClass(String domainClass) {
            this.domainClass = domainClass;
        }

        public String getConverter() {
            return this.converter;
        }

        public void setConverter(String converter) {
            this.converter = converter;
        }

        public List<String> getExcludeDomainColumn() {
            return this.excludeDomainColumn;
        }

        public void setExcludeDomainColumn(List<String> excludeDomainColumn) {
            this.excludeDomainColumn = excludeDomainColumn;
        }

        public List<DomainColumnConfig> getDomainColumnConfigs() {
            return this.domainColumnConfigs;
        }

        public void setDomainColumnConfigs(List<DomainColumnConfig> domainColumnConfigs) {
            this.domainColumnConfigs = domainColumnConfigs;
        }

        public String getFilePath() {
            StringBuilder s = new StringBuilder();
            s.append(this.domainPkg.replaceAll("[.]", "/"));
            if (this.domainSubPkg != null && this.domainSubPkg.trim().length() > 0) {
                s.append("/");
                s.append(this.domainSubPkg);
            }
            s.append("/").append(this.domainClass).append(".java");
            return s.toString();
        }

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
        }
    }
}

