/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.pm.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.pm.dao.PmPromotionConditionMapper;
import com.yqbsoft.laser.service.pm.domain.PmPromotionConditionDomain;
import com.yqbsoft.laser.service.pm.domain.PmPromotionConditionReDomain;
import com.yqbsoft.laser.service.pm.model.PmPromotionCondition;
import com.yqbsoft.laser.service.pm.service.PmPromotionConditionService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PmPromotionConditionServiceImpl
extends BaseServiceImpl
implements PmPromotionConditionService {
    private static final String SYS_CODE = "pm.PROMOTION.PmPromotionConditionServiceImpl";
    private PmPromotionConditionMapper pmPromotionConditionMapper;

    public void setPmPromotionConditionMapper(PmPromotionConditionMapper pmPromotionConditionMapper) {
        this.pmPromotionConditionMapper = pmPromotionConditionMapper;
    }

    private Date getSysDate() {
        try {
            return this.pmPromotionConditionMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmPromotionConditionServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkPromotionCondition(PmPromotionConditionDomain pmPromotionConditionDomain) {
        if (null == pmPromotionConditionDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)pmPromotionConditionDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setPromotionConditionDefault(PmPromotionCondition pmPromotionCondition) {
        if (null == pmPromotionCondition) {
            return;
        }
        if (null == pmPromotionCondition.getDataState()) {
            pmPromotionCondition.setDataState(0);
        }
        if (null == pmPromotionCondition.getGmtCreate()) {
            pmPromotionCondition.setGmtCreate(this.getSysDate());
        }
        pmPromotionCondition.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)pmPromotionCondition.getPpcCode())) {
            pmPromotionCondition.setPpcCode(this.createUUIDString());
        }
    }

    private int getPromotionConditionMaxCode() {
        int code = 0;
        try {
            return this.pmPromotionConditionMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmPromotionConditionServiceImpl.getPromotionConditionMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setPromotionConditionUpdataDefault(PmPromotionCondition pmPromotionCondition) {
        if (null == pmPromotionCondition) {
            return;
        }
        pmPromotionCondition.setGmtModified(this.getSysDate());
    }

    private void savePromotionConditionModel(PmPromotionCondition pmPromotionCondition) throws ApiException {
        if (null == pmPromotionCondition) {
            return;
        }
        try {
            this.pmPromotionConditionMapper.insert(pmPromotionCondition);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmPromotionConditionServiceImpl.savePromotionConditionModel.ex", (Throwable)e);
        }
    }

    private void savePromotionConditionBatchModel(List<PmPromotionCondition> pmPromotionConditionList) throws ApiException {
        if (null == pmPromotionConditionList || pmPromotionConditionList.isEmpty()) {
            return;
        }
        try {
            this.pmPromotionConditionMapper.insertBatch(pmPromotionConditionList);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmPromotionConditionServiceImpl.savePromotionConditionBatchModel.ex", (Throwable)e);
        }
    }

    private PmPromotionCondition getPromotionConditionModelById(Integer ppcId) {
        if (null == ppcId) {
            return null;
        }
        try {
            return this.pmPromotionConditionMapper.selectByPrimaryKey(ppcId);
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmPromotionConditionServiceImpl.getPromotionConditionModelById", (Throwable)e);
            return null;
        }
    }

    private PmPromotionCondition getPromotionConditionModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.pmPromotionConditionMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmPromotionConditionServiceImpl.getPromotionConditionModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delPromotionConditionModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        try {
            this.pmPromotionConditionMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmPromotionConditionServiceImpl.delPromotionConditionModelByCode.ex", (Throwable)e);
        }
    }

    private void deletePromotionConditionModel(Integer ppcId) throws ApiException {
        if (null == ppcId) {
            return;
        }
        int i = 0;
        try {
            i = this.pmPromotionConditionMapper.deleteByPrimaryKey(ppcId);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmPromotionConditionServiceImpl.deletePromotionConditionModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pm.PROMOTION.PmPromotionConditionServiceImpl.deletePromotionConditionModel.num");
        }
    }

    private void updatePromotionConditionModel(PmPromotionCondition pmPromotionCondition) throws ApiException {
        if (null == pmPromotionCondition) {
            return;
        }
        int i = 0;
        try {
            i = this.pmPromotionConditionMapper.updateByPrimaryKeySelective(pmPromotionCondition);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmPromotionConditionServiceImpl.updatePromotionConditionModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pm.PROMOTION.PmPromotionConditionServiceImpl.updatePromotionConditionModel.num");
        }
    }

    private void updateStatePromotionConditionModel(Integer ppcId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == ppcId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ppcId", ppcId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.pmPromotionConditionMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmPromotionConditionServiceImpl.updateStatePromotionConditionModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pm.PROMOTION.PmPromotionConditionServiceImpl.updateStatePromotionConditionModel.null");
        }
    }

    private void updateStatePromotionConditionModelByCode(String tenantCode, String ppcCode, Integer dataState, Integer oldDataState) throws ApiException {
        if (StringUtils.isBlank((String)ppcCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("ppcCode", ppcCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.pmPromotionConditionMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmPromotionConditionServiceImpl.updateStatePromotionConditionModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pm.PROMOTION.PmPromotionConditionServiceImpl.updateStatePromotionConditionModelByCode.null");
        }
    }

    private PmPromotionCondition makePromotionCondition(PmPromotionConditionDomain pmPromotionConditionDomain, PmPromotionCondition pmPromotionCondition) {
        if (null == pmPromotionConditionDomain) {
            return null;
        }
        if (null == pmPromotionCondition) {
            pmPromotionCondition = new PmPromotionCondition();
        }
        try {
            BeanUtils.copyAllPropertys((Object)pmPromotionCondition, (Object)pmPromotionConditionDomain);
            return pmPromotionCondition;
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmPromotionConditionServiceImpl.makePromotionCondition", (Throwable)e);
            return null;
        }
    }

    private PmPromotionConditionReDomain makePmPromotionConditionReDomain(PmPromotionCondition pmPromotionCondition) {
        if (null == pmPromotionCondition) {
            return null;
        }
        PmPromotionConditionReDomain pmPromotionConditionReDomain = new PmPromotionConditionReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)pmPromotionConditionReDomain, (Object)pmPromotionCondition);
            return pmPromotionConditionReDomain;
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmPromotionConditionServiceImpl.makePmPromotionConditionReDomain", (Throwable)e);
            return null;
        }
    }

    private List<PmPromotionCondition> queryPromotionConditionModelPage(Map<String, Object> parammap) {
        try {
            return this.pmPromotionConditionMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmPromotionConditionServiceImpl.queryPromotionConditionModel", (Throwable)e);
            return null;
        }
    }

    private int countPromotionCondition(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.pmPromotionConditionMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmPromotionConditionServiceImpl.countPromotionCondition", (Throwable)e);
        }
        return i;
    }

    private PmPromotionCondition createPmPromotionCondition(PmPromotionConditionDomain pmPromotionConditionDomain) {
        String msg = this.checkPromotionCondition(pmPromotionConditionDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pm.PROMOTION.PmPromotionConditionServiceImpl.savePromotionCondition.checkPromotionCondition", msg);
        }
        PmPromotionCondition pmPromotionCondition = this.makePromotionCondition(pmPromotionConditionDomain, null);
        this.setPromotionConditionDefault(pmPromotionCondition);
        return pmPromotionCondition;
    }

    @Override
    public String savePromotionCondition(PmPromotionConditionDomain pmPromotionConditionDomain) throws ApiException {
        PmPromotionCondition pmPromotionCondition = this.createPmPromotionCondition(pmPromotionConditionDomain);
        this.savePromotionConditionModel(pmPromotionCondition);
        return pmPromotionCondition.getPpcCode();
    }

    @Override
    public String savePromotionConditionBatch(List<PmPromotionConditionDomain> pmPromotionConditionDomainList) throws ApiException {
        if (null == pmPromotionConditionDomainList || pmPromotionConditionDomainList.isEmpty()) {
            return null;
        }
        ArrayList<PmPromotionCondition> pmPromotionConditionList = new ArrayList<PmPromotionCondition>();
        String code = "";
        for (PmPromotionConditionDomain pmPromotionConditionDomain : pmPromotionConditionDomainList) {
            PmPromotionCondition pmPromotionCondition = this.createPmPromotionCondition(pmPromotionConditionDomain);
            code = pmPromotionCondition.getPpcCode();
            pmPromotionConditionList.add(pmPromotionCondition);
        }
        this.savePromotionConditionBatchModel(pmPromotionConditionList);
        return code;
    }

    @Override
    public void updatePromotionConditionState(Integer ppcId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStatePromotionConditionModel(ppcId, dataState, oldDataState);
    }

    @Override
    public void updatePromotionConditionStateByCode(String tenantCode, String ppcCode, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStatePromotionConditionModelByCode(tenantCode, ppcCode, dataState, oldDataState);
    }

    @Override
    public void updatePromotionCondition(PmPromotionConditionDomain pmPromotionConditionDomain) throws ApiException {
        String msg = this.checkPromotionCondition(pmPromotionConditionDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pm.PROMOTION.PmPromotionConditionServiceImpl.updatePromotionCondition.checkPromotionCondition", msg);
        }
        PmPromotionCondition oldPmPromotionCondition = this.getPromotionConditionModelById(pmPromotionConditionDomain.getPpcId());
        if (null == oldPmPromotionCondition) {
            throw new ApiException("pm.PROMOTION.PmPromotionConditionServiceImpl.updatePromotionCondition.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        PmPromotionCondition pmPromotionCondition = this.makePromotionCondition(pmPromotionConditionDomain, oldPmPromotionCondition);
        this.setPromotionConditionUpdataDefault(pmPromotionCondition);
        this.updatePromotionConditionModel(pmPromotionCondition);
    }

    @Override
    public PmPromotionCondition getPromotionCondition(Integer ppcId) {
        return this.getPromotionConditionModelById(ppcId);
    }

    @Override
    public void deletePromotionCondition(Integer ppcId) throws ApiException {
        this.deletePromotionConditionModel(ppcId);
    }

    @Override
    public QueryResult<PmPromotionCondition> queryPromotionConditionPage(Map<String, Object> map) {
        List<PmPromotionCondition> pmPromotionConditionList = this.queryPromotionConditionModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countPromotionCondition(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(pmPromotionConditionList);
        return queryResult;
    }

    @Override
    public PmPromotionCondition getPromotionConditionByCode(String tenantCode, String ppcCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("ppcCode", ppcCode);
        return this.getPromotionConditionModelByCode(map);
    }

    @Override
    public void deletePromotionConditionByCode(String tenantCode, String promotionCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("promotionCode", promotionCode);
        this.delPromotionConditionModelByCode(map);
    }
}

