/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.pm.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.spring.ApplicationContextUtil;
import com.yqbsoft.laser.service.esb.core.spring.SpringApplicationContextUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.pm.PromotionConstants;
import com.yqbsoft.laser.service.pm.batchcoupon.BatchCouponPollThread;
import com.yqbsoft.laser.service.pm.batchcoupon.BatchCouponPutThread;
import com.yqbsoft.laser.service.pm.batchcoupon.BatchCouponService;
import com.yqbsoft.laser.service.pm.dao.PmPromotionMapper;
import com.yqbsoft.laser.service.pm.domain.DiscountDataDomain;
import com.yqbsoft.laser.service.pm.domain.OcCflowReDomain;
import com.yqbsoft.laser.service.pm.domain.OcContractSettlDomain;
import com.yqbsoft.laser.service.pm.domain.PmCalcDomain;
import com.yqbsoft.laser.service.pm.domain.PmContractGoodsDomain;
import com.yqbsoft.laser.service.pm.domain.PmInfoBean;
import com.yqbsoft.laser.service.pm.domain.PmPromotionCalcDomain;
import com.yqbsoft.laser.service.pm.domain.PmPromotionConditionDomain;
import com.yqbsoft.laser.service.pm.domain.PmPromotionCouponDomain;
import com.yqbsoft.laser.service.pm.domain.PmPromotionDiscountDomain;
import com.yqbsoft.laser.service.pm.domain.PmPromotionDomain;
import com.yqbsoft.laser.service.pm.domain.PmPromotionInDomain;
import com.yqbsoft.laser.service.pm.domain.PmPromotionRangelistDomain;
import com.yqbsoft.laser.service.pm.domain.PmPromotionReDomain;
import com.yqbsoft.laser.service.pm.domain.PmPromotionTargetlistDomain;
import com.yqbsoft.laser.service.pm.domain.PmPromotionTerminalDomain;
import com.yqbsoft.laser.service.pm.domain.TypeBean;
import com.yqbsoft.laser.service.pm.domain.ocshop.OcShoppingDomain;
import com.yqbsoft.laser.service.pm.domain.ocshop.OcShoppingGoodsDomain;
import com.yqbsoft.laser.service.pm.domain.ocshop.PromotionForOcReDomain;
import com.yqbsoft.laser.service.pm.model.PmPromotion;
import com.yqbsoft.laser.service.pm.model.PmPromotionBase;
import com.yqbsoft.laser.service.pm.model.PmPromotionCondition;
import com.yqbsoft.laser.service.pm.model.PmPromotionDiscount;
import com.yqbsoft.laser.service.pm.model.PmPromotionDiscountlist;
import com.yqbsoft.laser.service.pm.model.PmPromotionIn;
import com.yqbsoft.laser.service.pm.model.PmPromotionRangelist;
import com.yqbsoft.laser.service.pm.model.PmPromotionTargetlist;
import com.yqbsoft.laser.service.pm.model.PmPromotionTerminal;
import com.yqbsoft.laser.service.pm.model.PmUserCoupon;
import com.yqbsoft.laser.service.pm.model.PmUserOrder;
import com.yqbsoft.laser.service.pm.model.RsResourceGoods;
import com.yqbsoft.laser.service.pm.model.RsSku;
import com.yqbsoft.laser.service.pm.service.PmPromotionBaseService;
import com.yqbsoft.laser.service.pm.service.PmPromotionConditionService;
import com.yqbsoft.laser.service.pm.service.PmPromotionCouponService;
import com.yqbsoft.laser.service.pm.service.PmPromotionDiscountService;
import com.yqbsoft.laser.service.pm.service.PmPromotionDiscountlistService;
import com.yqbsoft.laser.service.pm.service.PmPromotionInService;
import com.yqbsoft.laser.service.pm.service.PmPromotionRangelistService;
import com.yqbsoft.laser.service.pm.service.PmPromotionService;
import com.yqbsoft.laser.service.pm.service.PmPromotionTargetlistService;
import com.yqbsoft.laser.service.pm.service.PmPromotionTerminalService;
import com.yqbsoft.laser.service.pm.service.PmUserCouponService;
import com.yqbsoft.laser.service.pm.service.PmUserOrderService;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.DateUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PmPromotionServiceImpl
extends BaseServiceImpl
implements PmPromotionService {
    private static final String SYS_CODE = "pm.PROMOTION.PmPromotionServiceImpl";
    private PmPromotionMapper pmPromotionMapper;
    private PmPromotionTargetlistService pmPromotionTargetlistService;
    private PmPromotionTerminalService pmPromotionTerminalService;
    private PmPromotionRangelistService pmPromotionRangelistService;
    private PmPromotionConditionService pmPromotionConditionService;
    private PmPromotionDiscountService pmPromotionDiscountService;
    private PmPromotionDiscountlistService pmPromotionDiscountlistService;
    private PmUserOrderService pmUserOrderService;
    private PmPromotionBaseService pmPromotionBaseService;
    private PmUserCouponService pmUserCouponService;
    private PmPromotionInService pmPromotionInService;
    private PmPromotionCouponService pmPromotionCouponService;
    private static BatchCouponService batchCouponService;
    private static Object lock;
    String CACHE_KEY_CFLOW = "ocProtCflow";

    public void setPmPromotionInService(PmPromotionInService pmPromotionInService) {
        this.pmPromotionInService = pmPromotionInService;
    }

    public void setPmPromotionBaseService(PmPromotionBaseService pmPromotionBaseService) {
        this.pmPromotionBaseService = pmPromotionBaseService;
    }

    public PmUserCouponService getPmUserCouponService() {
        if (null == this.pmUserCouponService) {
            this.pmUserCouponService = (PmUserCouponService)ApplicationContextUtil.getService((String)"pmUserCouponService");
        }
        return this.pmUserCouponService;
    }

    public void setPmPromotionCouponService(PmPromotionCouponService pmPromotionCouponService) {
        this.pmPromotionCouponService = pmPromotionCouponService;
    }

    public void setPmUserOrderService(PmUserOrderService pmUserOrderService) {
        this.pmUserOrderService = pmUserOrderService;
    }

    public void setPmPromotionDiscountlistService(PmPromotionDiscountlistService pmPromotionDiscountlistService) {
        this.pmPromotionDiscountlistService = pmPromotionDiscountlistService;
    }

    public void setPmPromotionDiscountService(PmPromotionDiscountService pmPromotionDiscountService) {
        this.pmPromotionDiscountService = pmPromotionDiscountService;
    }

    public void setPmPromotionTerminalService(PmPromotionTerminalService pmPromotionTerminalService) {
        this.pmPromotionTerminalService = pmPromotionTerminalService;
    }

    public void setPmPromotionConditionService(PmPromotionConditionService pmPromotionConditionService) {
        this.pmPromotionConditionService = pmPromotionConditionService;
    }

    public void setPmPromotionRangelistService(PmPromotionRangelistService pmPromotionRangelistService) {
        this.pmPromotionRangelistService = pmPromotionRangelistService;
    }

    public void setPmPromotionTargetlistService(PmPromotionTargetlistService pmPromotionTargetlistService) {
        this.pmPromotionTargetlistService = pmPromotionTargetlistService;
    }

    public void setPmPromotionMapper(PmPromotionMapper pmPromotionMapper) {
        this.pmPromotionMapper = pmPromotionMapper;
    }

    private Date getSysDate() {
        try {
            return this.pmPromotionMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmPromotionServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkPromotion(PmPromotionDomain pmPromotionDomain) {
        if (null == pmPromotionDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)pmPromotionDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setPromotionDefault(PmPromotion pmPromotion) {
        if (null == pmPromotion) {
            return;
        }
        if (null == pmPromotion.getDataState()) {
            pmPromotion.setDataState(0);
        }
        if (null == pmPromotion.getGmtCreate()) {
            pmPromotion.setGmtCreate(this.getSysDate());
        }
        pmPromotion.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)pmPromotion.getPromotionCode())) {
            pmPromotion.setPromotionCode(this.createUUIDString());
        }
    }

    private int getPromotionMaxCode() {
        int code = 0;
        try {
            return this.pmPromotionMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmPromotionServiceImpl.getPromotionMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setPromotionUpdataDefault(PmPromotion pmPromotion) {
        if (null == pmPromotion) {
            return;
        }
        pmPromotion.setGmtModified(this.getSysDate());
    }

    private void savePromotionModel(PmPromotion pmPromotion) throws ApiException {
        if (null == pmPromotion) {
            return;
        }
        try {
            this.pmPromotionMapper.insert(pmPromotion);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmPromotionServiceImpl.savePromotionModel.ex", (Throwable)e);
        }
    }

    private void savePromotionBatchModel(List<PmPromotion> pmPromotionList) throws ApiException {
        if (null == pmPromotionList || pmPromotionList.isEmpty()) {
            return;
        }
        try {
            this.pmPromotionMapper.insertBatch(pmPromotionList);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmPromotionServiceImpl.savePromotionBatchModel.ex", (Throwable)e);
        }
    }

    private PmPromotion getPromotionModelById(Integer promotionId) {
        if (null == promotionId) {
            return null;
        }
        try {
            return this.pmPromotionMapper.selectByPrimaryKey(promotionId);
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmPromotionServiceImpl.getPromotionModelById", (Throwable)e);
            return null;
        }
    }

    private PmPromotion getPromotionModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.pmPromotionMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmPromotionServiceImpl.getPromotionModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delPromotionModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.pmPromotionMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmPromotionServiceImpl.delPromotionModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pm.PROMOTION.PmPromotionServiceImpl.delPromotionModelByCode.num");
        }
    }

    private void deletePromotionModel(Integer promotionId) throws ApiException {
        if (null == promotionId) {
            return;
        }
        int i = 0;
        try {
            i = this.pmPromotionMapper.deleteByPrimaryKey(promotionId);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmPromotionServiceImpl.deletePromotionModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pm.PROMOTION.PmPromotionServiceImpl.deletePromotionModel.num");
        }
    }

    private void updatePromotionModel(PmPromotion pmPromotion) throws ApiException {
        if (null == pmPromotion) {
            return;
        }
        int i = 0;
        try {
            i = this.pmPromotionMapper.updateByPrimaryKeySelective(pmPromotion);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmPromotionServiceImpl.updatePromotionModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pm.PROMOTION.PmPromotionServiceImpl.updatePromotionModel.num");
        }
    }

    private void updateStatePromotionModel(Integer promotionId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == promotionId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("promotionId", promotionId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.pmPromotionMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmPromotionServiceImpl.updateStatePromotionModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pm.PROMOTION.PmPromotionServiceImpl.updateStatePromotionModel.null");
        }
    }

    private void updateStatePromotionModelByCode(String tenantCode, String promotionCode, Integer dataState, Integer oldDataState) throws ApiException {
        if (StringUtils.isBlank((String)promotionCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("promotionCode", promotionCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.pmPromotionMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmPromotionServiceImpl.updateStatePromotionModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pm.PROMOTION.PmPromotionServiceImpl.updateStatePromotionModelByCode.null");
        }
    }

    private PmPromotion makePromotion(PmPromotionDomain pmPromotionDomain, PmPromotion pmPromotion) {
        if (null == pmPromotionDomain) {
            return null;
        }
        if (null == pmPromotion) {
            pmPromotion = new PmPromotion();
        }
        try {
            BeanUtils.copyAllPropertys((Object)pmPromotion, (Object)pmPromotionDomain);
            return pmPromotion;
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmPromotionServiceImpl.makePromotion", (Throwable)e);
            return null;
        }
    }

    private PmPromotionReDomain makePmPromotionReDomain(PmPromotion pmPromotion) {
        if (null == pmPromotion) {
            return null;
        }
        PmPromotionReDomain pmPromotionReDomain = new PmPromotionReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)pmPromotionReDomain, (Object)pmPromotion);
            return pmPromotionReDomain;
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmPromotionServiceImpl.makePmPromotionReDomain", (Throwable)e);
            return null;
        }
    }

    private List<PmPromotion> queryPromotionModelPage(Map<String, Object> parammap) {
        try {
            return this.pmPromotionMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmPromotionServiceImpl.queryPromotionModel", (Throwable)e);
            return null;
        }
    }

    private int countPromotion(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.pmPromotionMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmPromotionServiceImpl.countPromotion", (Throwable)e);
        }
        return i;
    }

    private PmPromotion createPmPromotion(PmPromotionDomain pmPromotionDomain) {
        String msg = this.checkPromotion(pmPromotionDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pm.PROMOTION.PmPromotionServiceImpl.savePromotion.checkPromotion", msg);
        }
        PmPromotion pmPromotion = this.makePromotion(pmPromotionDomain, null);
        this.setPromotionDefault(pmPromotion);
        return pmPromotion;
    }

    @Override
    public String savePromotion(PmPromotionDomain pmPromotionDomain) throws ApiException {
        PmPromotion pmPromotion = this.createPmPromotion(pmPromotionDomain);
        String pbCode = pmPromotionDomain.getPbCode();
        PmPromotionBase pmPromotionBase = this.pmPromotionBaseService.getPromotionBaseByCode(pmPromotionDomain.getTenantCode(), pbCode);
        if (null != pmPromotionBase) {
            pmPromotion.setPriority(pmPromotionBase.getPriority());
        }
        this.savePromotionModel(pmPromotion);
        String promotionCode = pmPromotion.getPromotionCode();
        this.getBatchCouponService().putQueue(pmPromotion);
        this.savePromotionReRelatedData(pmPromotionDomain, promotionCode);
        return promotionCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BatchCouponService getBatchCouponService() {
        Object object = lock;
        synchronized (object) {
            if (null == batchCouponService) {
                batchCouponService = new BatchCouponService((PmPromotionService)SpringApplicationContextUtil.getBean((String)"pmPromotionService"));
                for (int i = 0; i < 10; ++i) {
                    batchCouponService.addPollPool(new BatchCouponPollThread(batchCouponService));
                }
            }
            return batchCouponService;
        }
    }

    @Override
    public void saveCouponBatch(PmPromotion pmPromotion) {
        if (null == pmPromotion) {
            return;
        }
        if (PromotionConstants.DATA_STATE_0.intValue() == pmPromotion.getDataState().intValue()) {
            Date nowDate = this.getSysDate();
            if (DateUtils.compareDate((Date)pmPromotion.getPromotionBegintime(), (Date)nowDate) >= 0) {
                String couponBatch = this.getNo("0", "PmPromotionCoupon", "couponBatchNo", pmPromotion.getTenantCode());
                pmPromotion.setCouponBatch(couponBatch);
                String pbCode = pmPromotion.getPbCode();
                if ("0003".equals(pbCode) || "0004".equals(pbCode) || "0005".equals(pbCode)) {
                    int couponOnceNums = pmPromotion.getCouponOnceNums();
                    ArrayList<PmPromotionCouponDomain> pmPromotionCouponDomainList = new ArrayList<PmPromotionCouponDomain>();
                    for (int a = 0; a < couponOnceNums; ++a) {
                        PmPromotionCouponDomain pmPromotionCouponDomain = new PmPromotionCouponDomain();
                        try {
                            BeanUtils.copyAllPropertys((Object)pmPromotionCouponDomain, (Object)pmPromotion);
                        }
                        catch (Exception e) {
                            this.logger.error("pm.PROMOTION.PmPromotionServiceImpl.saveCouponBatch.e", (Throwable)e);
                        }
                        String couponNo = this.getNo("0", "PmPromotionCouponNo", "couponNo", pmPromotion.getTenantCode());
                        pmPromotionCouponDomain.setCouponNo(couponNo);
                        pmPromotionCouponDomain.setCouponStart(pmPromotion.getPromotionBegintime());
                        pmPromotionCouponDomain.setCouponEnd(pmPromotion.getPromotionEndtime());
                        pmPromotionCouponDomainList.add(pmPromotionCouponDomain);
                    }
                    this.pmPromotionCouponService.savePromotionCouponBatch(pmPromotionCouponDomainList);
                }
                this.updateStatePromotionModelByCode(pmPromotion.getTenantCode(), pmPromotion.getPromotionCode(), PromotionConstants.DATA_STATE_1, PromotionConstants.DATA_STATE_0);
                pmPromotion.setDataState(PromotionConstants.DATA_STATE_1);
                this.savePromotionIn(pmPromotion);
            }
        } else {
            Date nowDate = this.getSysDate();
            if (DateUtils.compareDate((Date)pmPromotion.getPromotionEndtime(), (Date)nowDate) <= 0) {
                this.delPromotionIn(pmPromotion);
                this.updateStatePromotionModelByCode(pmPromotion.getTenantCode(), pmPromotion.getPromotionCode(), PromotionConstants.DATA_STATE_2, PromotionConstants.DATA_STATE_1);
            }
        }
    }

    private void delPromotionIn(PmPromotion pmPromotion) {
        if (null == pmPromotion) {
            return;
        }
        if (StringUtils.isBlank((String)pmPromotion.getPbCode())) {
            this.logger.error("pm.PROMOTION.PmPromotionServiceImpl.delPromotionIn.PbCode");
            return;
        }
        String cacheKey = pmPromotion.getPromotionCode() + "-" + pmPromotion.getTenantCode();
        DisUtil.delMap((String)"pm-promotion_condition", (String[])new String[]{cacheKey});
        DisUtil.delMap((String)"pm-promotion_discount", (String[])new String[]{cacheKey});
        DisUtil.delMap((String)"pm-promotion_discountlist", (String[])new String[]{cacheKey});
        DisUtil.delMap((String)"pm-promotion_rangelist", (String[])new String[]{cacheKey});
        DisUtil.delMap((String)"pm-promotion_targetlist", (String[])new String[]{cacheKey});
        DisUtil.delMap((String)"pm-promotion_terminal", (String[])new String[]{cacheKey});
        DisUtil.delMap((String)"pm-promotion", (String[])new String[]{cacheKey});
        String json = DisUtil.getMap((String)"pm-promotionin", (String)pmPromotion.getTenantCode());
        if (StringUtils.isBlank((String)json)) {
            List inList = (List)JsonUtil.buildNormalBinder().getJsonToList(json, PmPromotionInDomain.class);
            if (ListUtil.isNotEmpty((Collection)inList)) {
                for (PmPromotionInDomain pmPromotionInDomain2 : inList) {
                    if (!pmPromotionInDomain2.getPromotionCode().equals(pmPromotion.getPromotionCode())) continue;
                    inList.remove(pmPromotionInDomain2);
                    break;
                }
            }
            DisUtil.setMapVer((String)"pm-promotionin", (String)pmPromotion.getTenantCode(), (String)JsonUtil.buildNormalBinder().toJson((Object)inList));
        }
        this.pmPromotionInService.deletePromotionInByPromotionCode(pmPromotion.getTenantCode(), pmPromotion.getPromotionCode());
    }

    private void savePromotionIn(PmPromotion pmPromotion) {
        QueryResult<PmPromotionTerminal> qterminalList;
        QueryResult<PmPromotionTargetlist> qtargetList;
        QueryResult<PmPromotionDiscount> qdiscontList;
        if (null == pmPromotion) {
            return;
        }
        if (StringUtils.isBlank((String)pmPromotion.getPbCode())) {
            this.logger.error("pm.PROMOTION.PmPromotionServiceImpl.savePromotionIn.PbCode");
            return;
        }
        PmPromotionInDomain pmPromotionInDomain = new PmPromotionInDomain();
        try {
            BeanUtils.copyAllPropertys((Object)pmPromotionInDomain, (Object)pmPromotion);
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmPromotionServiceImpl.savePromotionIn.e", (Throwable)e);
        }
        if (pmPromotion.getPbCode().equals("0001") || pmPromotion.getPbCode().equals("0002")) {
            pmPromotionInDomain.setPromotionInType("0");
        } else {
            pmPromotionInDomain.setPromotionInType("1");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", pmPromotionInDomain.getTenantCode());
        map.put("promotionCode", pmPromotionInDomain.getPromotionCode());
        String cacheKey = pmPromotionInDomain.getPromotionCode() + "-" + pmPromotionInDomain.getTenantCode();
        QueryResult<PmPromotionCondition> qconditionList = this.pmPromotionConditionService.queryPromotionConditionPage(map);
        if (null != qconditionList && ListUtil.isNotEmpty((Collection)qconditionList.getList())) {
            DisUtil.setMapVer((String)"pm-promotion_condition", (String)cacheKey, (String)JsonUtil.buildNormalBinder().toJson((Object)qconditionList.getList()));
        }
        if (null != (qdiscontList = this.pmPromotionDiscountService.queryPromotionDiscountPage(map)) && ListUtil.isNotEmpty((Collection)qdiscontList.getList())) {
            pmPromotionInDomain.setDiscType(((PmPromotionDiscount)qdiscontList.getList().get(0)).getDiscType());
            pmPromotionInDomain.setDiscAmount(((PmPromotionDiscount)qdiscontList.getList().get(0)).getDiscAmount());
            pmPromotionInDomain.setDiscStart(((PmPromotionDiscount)qdiscontList.getList().get(0)).getDiscStart());
            pmPromotionInDomain.setDiscEnd(((PmPromotionDiscount)qdiscontList.getList().get(0)).getDiscEnd());
            DisUtil.setMapVer((String)"pm-promotion_discount", (String)cacheKey, (String)JsonUtil.buildNormalBinder().toJson((Object)qdiscontList.getList()));
            QueryResult<PmPromotionDiscountlist> qlist = this.pmPromotionDiscountlistService.queryPromotionDiscountlistPage(map);
            if (null != qlist && ListUtil.isNotEmpty((Collection)qlist.getList())) {
                String cke = "";
                for (PmPromotionDiscountlist pmPromotionDiscountlist : qlist.getList()) {
                    cke = cacheKey + "-" + pmPromotionDiscountlist.getPpdCode();
                    String cstr = DisUtil.getMap((String)"pm-promotion_discountlist", (String)cke);
                    List<PmPromotionDiscountlist> alist = StringUtils.isNotBlank((String)cstr) ? (List)JsonUtil.buildNormalBinder().getJsonToList(cstr, PmPromotionDiscountlist.class) : new ArrayList<PmPromotionDiscountlist>();
                    alist.add(pmPromotionDiscountlist);
                    DisUtil.setMapVer((String)"pm-promotion_discountlist", (String)cke, (String)JsonUtil.buildNormalBinder().toJson(alist));
                }
            }
        }
        QueryResult<PmPromotionRangelist> qrangeList = this.pmPromotionRangelistService.queryPromotionRangelistPage(map);
        if (null != qdiscontList && ListUtil.isNotEmpty((Collection)qrangeList.getList())) {
            String rangeCodeStr = "";
            for (PmPromotionRangelist pmPromotionRangelist : qrangeList.getList()) {
                if (StringUtils.isNotBlank((String)rangeCodeStr)) {
                    rangeCodeStr = rangeCodeStr + ",";
                }
                rangeCodeStr = rangeCodeStr + pmPromotionRangelist.getRangeCode();
            }
            pmPromotionInDomain.setRangeCode(rangeCodeStr);
            DisUtil.setMapVer((String)"pm-promotion_rangelist", (String)cacheKey, (String)JsonUtil.buildNormalBinder().toJson((Object)qrangeList.getList()));
        }
        if (null != (qtargetList = this.pmPromotionTargetlistService.queryPromotionTargetlistPage(map)) && ListUtil.isNotEmpty((Collection)qtargetList.getList())) {
            String targetStr = "";
            for (PmPromotionTargetlist pmPromotionTargetlist : qtargetList.getList()) {
                if (StringUtils.isNotBlank((String)targetStr)) {
                    targetStr = targetStr + ",";
                }
                targetStr = targetStr + pmPromotionTargetlist.getTargetCode();
            }
            pmPromotionInDomain.setTargetCode(targetStr);
            DisUtil.setMapVer((String)"pm-promotion_targetlist", (String)cacheKey, (String)JsonUtil.buildNormalBinder().toJson((Object)qtargetList.getList()));
        }
        if (null != (qterminalList = this.pmPromotionTerminalService.queryPromotionTerminalPage(map)) && ListUtil.isNotEmpty((Collection)qterminalList.getList())) {
            String terminalTypeStr = "";
            for (PmPromotionTerminal pmPromotionTerminal : qterminalList.getList()) {
                if (StringUtils.isNotBlank((String)terminalTypeStr)) {
                    terminalTypeStr = terminalTypeStr + ",";
                }
                terminalTypeStr = terminalTypeStr + pmPromotionTerminal.getTerminalType();
            }
            pmPromotionInDomain.setTerminalType(terminalTypeStr);
            DisUtil.setMapVer((String)"pm-promotion_terminal", (String)cacheKey, (String)JsonUtil.buildNormalBinder().toJson((Object)qterminalList.getList()));
        }
        String listStr = DisUtil.getMap((String)"pm-promotionin", (String)pmPromotionInDomain.getTenantCode());
        ArrayList<PmPromotionInDomain> inList = null;
        if (StringUtils.isNotBlank((String)listStr)) {
            inList = (ArrayList<PmPromotionInDomain>)JsonUtil.buildNormalBinder().getJsonToList(listStr, PmPromotionInDomain.class);
        }
        if (null == inList) {
            inList = new ArrayList<PmPromotionInDomain>();
        }
        inList.add(pmPromotionInDomain);
        Collections.sort(inList, new Comparator<PmPromotionInDomain>(){

            @Override
            public int compare(PmPromotionInDomain arg0, PmPromotionInDomain arg1) {
                if (arg0.getPriority() > arg1.getPriority()) {
                    return 1;
                }
                if (arg0.getPriority() < arg1.getPriority()) {
                    return -1;
                }
                return arg0.getPriority().compareTo(arg0.getPriority());
            }
        });
        DisUtil.setMapVer((String)"pm-promotionin", (String)pmPromotionInDomain.getTenantCode(), (String)JsonUtil.buildNormalBinder().toJson(inList));
        DisUtil.setMapVer((String)"pm-promotion", (String)cacheKey, (String)JsonUtil.buildNormalBinder().toJson((Object)pmPromotionInDomain));
        this.pmPromotionInService.savePromotionIn(pmPromotionInDomain);
    }

    private Integer checkPromotionDataState(Date beginTime, Date endTime) {
        Integer dataState = PromotionConstants.DATA_STATE_0;
        Date nowDate = new Date();
        if (DateUtils.compareDate((Date)nowDate, (Date)beginTime) < 0 && DateUtils.compareDate((Date)nowDate, (Date)endTime) > 0) {
            dataState = PromotionConstants.DATA_STATE_1;
        } else if (DateUtils.compareDate((Date)nowDate, (Date)endTime) < 0) {
            dataState = PromotionConstants.DATA_STATE_2;
        }
        return dataState;
    }

    private void savePromotionReRelatedData(PmPromotionDomain pmPromotionDomain, String promotionCode) {
        List<PmPromotionDiscountDomain> discountDomainList;
        List<PmPromotionConditionDomain> conditionDomainList;
        List<PmPromotionTerminalDomain> terminalDomainList;
        List<PmPromotionRangelistDomain> rangelistDomainList;
        List<PmPromotionTargetlistDomain> targetlistDomainList = pmPromotionDomain.getPmPromotionTargetList();
        if (null != targetlistDomainList && targetlistDomainList.size() > 0) {
            for (PmPromotionTargetlistDomain targetlistDomain : targetlistDomainList) {
                targetlistDomain.setAppmanageIcode(pmPromotionDomain.getAppmanageIcode());
                targetlistDomain.setTenantCode(pmPromotionDomain.getTenantCode());
                targetlistDomain.setMemberName(pmPromotionDomain.getMemberName());
                targetlistDomain.setMemberCode(pmPromotionDomain.getMemberCode());
                targetlistDomain.setPromotionCode(promotionCode);
            }
            this.pmPromotionTargetlistService.savePromotionTargetlistBatch(targetlistDomainList);
        }
        if (null != (rangelistDomainList = pmPromotionDomain.getPmPromotionRangeList()) && rangelistDomainList.size() > 0) {
            for (PmPromotionRangelistDomain rangelistDomain : rangelistDomainList) {
                rangelistDomain.setAppmanageIcode(pmPromotionDomain.getAppmanageIcode());
                rangelistDomain.setTenantCode(pmPromotionDomain.getTenantCode());
                rangelistDomain.setMemberName(pmPromotionDomain.getMemberName());
                rangelistDomain.setMemberCode(pmPromotionDomain.getMemberCode());
                rangelistDomain.setPromotionCode(promotionCode);
            }
            this.pmPromotionRangelistService.savePromotionRangelistBatch(rangelistDomainList);
        }
        if (null != (terminalDomainList = pmPromotionDomain.getPmPromotionTerminalList()) && terminalDomainList.size() > 0) {
            for (PmPromotionTerminalDomain terminalDomain : terminalDomainList) {
                terminalDomain.setAppmanageIcode(pmPromotionDomain.getAppmanageIcode());
                terminalDomain.setTenantCode(pmPromotionDomain.getTenantCode());
                terminalDomain.setMemberName(pmPromotionDomain.getMemberName());
                terminalDomain.setMemberCode(pmPromotionDomain.getMemberCode());
                terminalDomain.setPromotionCode(promotionCode);
            }
            this.pmPromotionTerminalService.savePromotionTerminalBatch(terminalDomainList);
        }
        if (null != (conditionDomainList = pmPromotionDomain.getPmPromotionConditionList()) && conditionDomainList.size() > 0) {
            for (PmPromotionConditionDomain conditionDomain : conditionDomainList) {
                conditionDomain.setAppmanageIcode(pmPromotionDomain.getAppmanageIcode());
                conditionDomain.setTenantCode(pmPromotionDomain.getTenantCode());
                conditionDomain.setMemberName(pmPromotionDomain.getMemberName());
                conditionDomain.setMemberCode(pmPromotionDomain.getMemberCode());
                conditionDomain.setPromotionCode(promotionCode);
            }
            this.pmPromotionConditionService.savePromotionConditionBatch(conditionDomainList);
        }
        if (null != (discountDomainList = pmPromotionDomain.getPmPromotionDiscountList()) && discountDomainList.size() > 0) {
            for (PmPromotionDiscountDomain discountDomain : discountDomainList) {
                discountDomain.setAppmanageIcode(pmPromotionDomain.getAppmanageIcode());
                discountDomain.setTenantCode(pmPromotionDomain.getTenantCode());
                discountDomain.setMemberName(pmPromotionDomain.getMemberName());
                discountDomain.setMemberCode(pmPromotionDomain.getMemberCode());
                discountDomain.setPromotionCode(promotionCode);
            }
            this.pmPromotionDiscountService.savePromotionDiscountBatch(discountDomainList);
        }
    }

    private void delPromotionReRelatedData(String tenantCode, String promotionCode) {
        this.pmPromotionTargetlistService.deletePromotionTargetlistByCode(tenantCode, promotionCode);
        this.pmPromotionRangelistService.deletePromotionRangelistByCode(tenantCode, promotionCode);
        this.pmPromotionTerminalService.deletePromotionTerminalByCode(tenantCode, promotionCode);
        this.pmPromotionConditionService.deletePromotionConditionByCode(tenantCode, promotionCode);
        this.pmPromotionDiscountService.deletePromotionDiscountByCode(tenantCode, promotionCode);
        this.pmPromotionDiscountlistService.deletePromotionDiscountlistByCode(tenantCode, promotionCode);
    }

    private void getPromotionReRelatedData(PmPromotion pmPromotion) {
        QueryResult<PmPromotionCondition> conditionQueryResult;
        QueryResult<PmPromotionTerminal> terminalQueryResult;
        QueryResult<PmPromotionRangelist> rangelistQueryResult;
        if (null == pmPromotion) {
            return;
        }
        String tenantCode = pmPromotion.getTenantCode();
        String promotionCode = pmPromotion.getPromotionCode();
        Map paramMap = this.getQueryParamMap("promotionCode,tenantCode", new Object[]{promotionCode, tenantCode});
        QueryResult<PmPromotionTargetlist> targetlistQueryResult = this.pmPromotionTargetlistService.queryPromotionTargetlistPage(paramMap);
        if (null != targetlistQueryResult && null != targetlistQueryResult.getList()) {
            pmPromotion.setPmPromotionTargetList(targetlistQueryResult.getList());
        }
        if (null != (rangelistQueryResult = this.pmPromotionRangelistService.queryPromotionRangelistPage(paramMap)) && null != rangelistQueryResult.getList()) {
            pmPromotion.setPmPromotionRangeList(rangelistQueryResult.getList());
        }
        if (null != (terminalQueryResult = this.pmPromotionTerminalService.queryPromotionTerminalPage(paramMap)) && null != terminalQueryResult.getList()) {
            pmPromotion.setPmPromotionTerminalList(terminalQueryResult.getList());
        }
        if (null != (conditionQueryResult = this.pmPromotionConditionService.queryPromotionConditionPage(paramMap)) && null != conditionQueryResult.getList()) {
            pmPromotion.setPmPromotionConditionList(conditionQueryResult.getList());
        }
        this.processDiscountInfo(pmPromotion, tenantCode);
    }

    @Override
    public String savePromotionBatch(List<PmPromotionDomain> pmPromotionDomainList) throws ApiException {
        if (null == pmPromotionDomainList || pmPromotionDomainList.isEmpty()) {
            return null;
        }
        ArrayList<PmPromotion> pmPromotionList = new ArrayList<PmPromotion>();
        String code = "";
        for (PmPromotionDomain pmPromotionDomain : pmPromotionDomainList) {
            PmPromotion pmPromotion = this.createPmPromotion(pmPromotionDomain);
            code = pmPromotion.getPromotionCode();
            pmPromotionList.add(pmPromotion);
        }
        this.savePromotionBatchModel(pmPromotionList);
        return code;
    }

    @Override
    public void updatePromotionState(Integer promotionId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStatePromotionModel(promotionId, dataState, oldDataState);
    }

    @Override
    public void updatePromotionStateByCode(String tenantCode, String promotionCode, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStatePromotionModelByCode(tenantCode, promotionCode, dataState, oldDataState);
    }

    @Override
    public void updatePromotion(PmPromotionDomain pmPromotionDomain) throws ApiException {
        String msg = this.checkPromotion(pmPromotionDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pm.PROMOTION.PmPromotionServiceImpl.updatePromotion.checkPromotion", msg);
        }
        PmPromotion oldPmPromotion = this.getPromotionModelById(pmPromotionDomain.getPromotionId());
        if (null == oldPmPromotion) {
            throw new ApiException("pm.PROMOTION.PmPromotionServiceImpl.updatePromotion.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        PmPromotion pmPromotion = this.makePromotion(pmPromotionDomain, oldPmPromotion);
        this.setPromotionUpdataDefault(pmPromotion);
        pmPromotion.setDataState(this.checkPromotionDataState(pmPromotionDomain.getPromotionBegintime(), pmPromotionDomain.getPromotionEndtime()));
        String pbCode = pmPromotionDomain.getPbCode();
        String tenantCode = pmPromotionDomain.getTenantCode();
        PmPromotionBase pmPromotionBase = this.pmPromotionBaseService.getPromotionBaseByCode(pmPromotionDomain.getTenantCode(), pbCode);
        if (null != pmPromotionBase) {
            pmPromotion.setPriority(pmPromotionBase.getPriority());
        }
        if ("0003".equals(pbCode) || "0004".equals(pbCode) || "0005".equals(pbCode)) {
            this.pmPromotionCouponService.deletePromotionCouponByPromotionCode(tenantCode, pmPromotion.getPromotionCode());
            this.saveCouponBatch(pmPromotion);
        }
        this.updatePromotionModel(pmPromotion);
        this.delPromotionReRelatedData(pmPromotion.getTenantCode(), pmPromotion.getPromotionCode());
        this.savePromotionReRelatedData(pmPromotionDomain, pmPromotion.getPromotionCode());
    }

    @Override
    public PmPromotion getPromotion(Integer promotionId) {
        PmPromotion pmPromotion = this.getPromotionModelById(promotionId);
        this.getPromotionReRelatedData(pmPromotion);
        return pmPromotion;
    }

    @Override
    public void deletePromotion(Integer promotionId) throws ApiException {
        this.deletePromotionModel(promotionId);
    }

    @Override
    public QueryResult<PmPromotion> queryPromotionPage(Map<String, Object> map) {
        List<PmPromotion> pmPromotionList = this.queryPromotionModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countPromotion(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(pmPromotionList);
        return queryResult;
    }

    @Override
    public QueryResult<PmPromotion> checkPromotionListByGoodsCode(String tenantCode, String skuCode, String userCode, String terminalType) {
        List<PmPromotionIn> inlist = this.caPmpromotion(tenantCode, skuCode, null);
        if (ListUtil.isEmpty(inlist)) {
            return null;
        }
        ArrayList<PmPromotion> list = new ArrayList<PmPromotion>();
        for (PmPromotionIn pmPromotionIn : inlist) {
            PmPromotion pmPromotion = new PmPromotion();
            try {
                BeanUtils.copyAllPropertys((Object)pmPromotion, (Object)pmPromotionIn);
                list.add(pmPromotion);
            }
            catch (Exception e) {}
        }
        QueryResult qlist = new QueryResult();
        qlist.setList(list);
        return qlist;
    }

    private List<PmPromotionIn> caPmpromotion(String tenantCode, String skuCode, OcShoppingGoodsDomain ocShoppingGoodsDomain) {
        String str = DisUtil.getMap((String)"pm-promotionin", (String)tenantCode);
        if (StringUtils.isBlank((String)str)) {
            return null;
        }
        ArrayList<PmPromotionIn> resultPromotionList = new ArrayList<PmPromotionIn>();
        List pmPromotionList = (List)JsonUtil.buildNormalBinder().getJsonToList(str, PmPromotionIn.class);
        if (null != pmPromotionList && pmPromotionList.size() > 0) {
            Date nowDate = this.getSysDate();
            for (PmPromotionIn pmPromotion : pmPromotionList) {
                if (DateUtils.compareDate((Date)nowDate, (Date)pmPromotion.getPromotionEndtime()) < 0) continue;
                Integer rangeType = pmPromotion.getRangeType();
                Integer sendType = pmPromotion.getSendtype();
                if (!sendType.equals(PromotionConstants.SEND_TYPE_1) && !sendType.equals(PromotionConstants.SEND_TYPE_3)) continue;
                if (rangeType.equals(PromotionConstants.RANGE_TYPE_0)) {
                    resultPromotionList.add(pmPromotion);
                    continue;
                }
                if (rangeType.equals(PromotionConstants.RANGE_TYPE_1) || !rangeType.equals(PromotionConstants.RANGE_TYPE_2) && !rangeType.equals(PromotionConstants.RANGE_TYPE_3) && !rangeType.equals(PromotionConstants.RANGE_TYPE_4) && !rangeType.equals(PromotionConstants.RANGE_TYPE_5) || !this.checkPromotionRangeBySkuCode(pmPromotion, skuCode, tenantCode, rangeType, ocShoppingGoodsDomain)) continue;
                resultPromotionList.add(pmPromotion);
            }
        }
        return resultPromotionList;
    }

    @Override
    public QueryResult<PmPromotion> checkCouponListBySkuCode(String tenantCode, String skuCode, String userCode, String terminalType) {
        QueryResult queryResult = new QueryResult();
        String str = DisUtil.getMap((String)"pm-promotionin", (String)tenantCode);
        if (StringUtils.isBlank((String)str)) {
            return null;
        }
        List pmPromotionList = (List)JsonUtil.buildNormalBinder().getJsonToList(str, PmPromotionIn.class);
        ArrayList<PmPromotion> resultPromotionList = new ArrayList<PmPromotion>();
        if (null != pmPromotionList && pmPromotionList.size() > 0) {
            OcShoppingGoodsDomain ocShoppingGoodsDomain = this.getGoodsDomain(skuCode, tenantCode);
            if (null == ocShoppingGoodsDomain) {
                return null;
            }
            Date nowDate = this.getSysDate();
            for (PmPromotionIn pmPromotionIn : pmPromotionList) {
                PmPromotion pmPromotion = new PmPromotion();
                try {
                    BeanUtils.copyAllPropertys((Object)pmPromotion, (Object)pmPromotionIn);
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (DateUtils.compareDate((Date)nowDate, (Date)pmPromotion.getPromotionEndtime()) < 0) continue;
                Integer rangeType = pmPromotion.getRangeType();
                Integer sendType = pmPromotion.getSendtype();
                if (!sendType.equals(PromotionConstants.SEND_TYPE_1) && !sendType.equals(PromotionConstants.SEND_TYPE_3)) continue;
                if (rangeType.equals(PromotionConstants.RANGE_TYPE_0)) {
                    resultPromotionList.add(pmPromotion);
                    continue;
                }
                if (rangeType.equals(PromotionConstants.RANGE_TYPE_1) || !rangeType.equals(PromotionConstants.RANGE_TYPE_2) && !rangeType.equals(PromotionConstants.RANGE_TYPE_3) && !rangeType.equals(PromotionConstants.RANGE_TYPE_4) && !rangeType.equals(PromotionConstants.RANGE_TYPE_5) || !this.checkPromotionRangeBySkuCode(pmPromotionIn, skuCode, tenantCode, rangeType, ocShoppingGoodsDomain)) continue;
                resultPromotionList.add(pmPromotion);
            }
        }
        if (null != resultPromotionList && resultPromotionList.size() > 0) {
            for (PmPromotion pmPromotion : resultPromotionList) {
                List list;
                String strcon = DisUtil.getMap((String)"pm-promotion_condition", (String)(pmPromotion.getPromotionCode() + "-" + tenantCode));
                if (StringUtils.isBlank((String)strcon) || ListUtil.isEmpty((Collection)(list = (List)JsonUtil.buildNormalBinder().getJsonToList(strcon, PmPromotionCondition.class)))) continue;
                pmPromotion.setPmPromotionConditionList(list);
                this.processDiscountInfo(pmPromotion, tenantCode);
            }
        }
        queryResult.setList(resultPromotionList);
        queryResult.setTotal((long)resultPromotionList.size());
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(resultPromotionList.size());
        queryResult.setPageTools((SupPageTools)pageTools);
        return queryResult;
    }

    private void processDiscountInfo(PmPromotion pmPromotion, String tenantCode) {
        String strcon = DisUtil.getMap((String)"pm-promotion_discount", (String)(pmPromotion.getPromotionCode() + "-" + tenantCode));
        if (StringUtils.isBlank((String)strcon)) {
            return;
        }
        List pmPromotionDiscountList = (List)JsonUtil.buildNormalBinder().getJsonToList(strcon, PmPromotionDiscount.class);
        if (ListUtil.isEmpty((Collection)pmPromotionDiscountList)) {
            return;
        }
        pmPromotion.setPmPromotionDiscountList(pmPromotionDiscountList);
        for (PmPromotionDiscount pmPromotionDiscount : pmPromotionDiscountList) {
            QueryResult<PmPromotionDiscountlist> discountlistQueryResult = this.pmPromotionDiscountlistService.queryPromotionDiscountlistPage(this.getQueryParamMap("ppdCode,tenantCode", new Object[]{pmPromotionDiscount.getPpdCode(), tenantCode}));
            List promotionDiscountlists = discountlistQueryResult.getList();
            if (pmPromotionDiscount.getDiscType() == PromotionConstants.DISCOUNT_TYPE_5 && null != promotionDiscountlists && null != promotionDiscountlists) {
                for (PmPromotionDiscountlist pmPromotionDiscountlist : promotionDiscountlists) {
                    RsSku rsSku = this.getRsSku(pmPromotionDiscountlist.getDiscountCode(), pmPromotionDiscountlist.getTenantCode());
                    if (null == rsSku) continue;
                    RsResourceGoods rsResourceGoods = this.getRsourcesGoods(rsSku.getGoodsCode(), pmPromotionDiscountlist.getTenantCode());
                    if (null != rsResourceGoods) {
                        rsSku.setGoodsName(rsResourceGoods.getGoodsName());
                    }
                    pmPromotionDiscountlist.setRsSku(rsSku);
                }
            }
            pmPromotionDiscount.setPmPromotionDiscountlistList(promotionDiscountlists);
        }
    }

    @Override
    public Map<String, Object> calcPromotionByOrder(List<PmPromotionCalcDomain> calcDomainList, String contractBillCode, String tenantCode, String userCode, String terminalType) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        DecimalFormat df2 = new DecimalFormat("#.00");
        BigDecimal discountAmount = BigDecimal.ZERO;
        BigDecimal selectedAllAmount = BigDecimal.ZERO;
        BigDecimal pefAllAmount = BigDecimal.ZERO;
        ArrayList<PmUserOrder> pmUserOrderList = new ArrayList<PmUserOrder>();
        ArrayList<Map<String, Object>> promotionResultInfo = new ArrayList<Map<String, Object>>();
        for (PmPromotionCalcDomain pmPromotionCalcDomain : calcDomainList) {
            PmUserOrder pmUserOrder;
            PmPromotion pmPromotion;
            String promotionCode = pmPromotionCalcDomain.getPromotionCode();
            BigDecimal promotionAllAmount = BigDecimal.ZERO;
            BigDecimal selectedPromotionAllAmount = BigDecimal.ZERO;
            BigDecimal promotionAllBuyAmount = BigDecimal.ZERO;
            BigDecimal selectedPromotionAllBuyAmount = BigDecimal.ZERO;
            List<OcShoppingGoodsDomain> skuInfoDomainList = pmPromotionCalcDomain.getSkuList();
            HashMap<String, BigDecimal> skuPriceMap = new HashMap<String, BigDecimal>();
            if (null != skuInfoDomainList && skuInfoDomainList.size() > 0) {
                for (OcShoppingGoodsDomain skuInfoDomain : skuInfoDomainList) {
                    BigDecimal price = skuInfoDomain.getGoodsCamount().multiply(skuInfoDomain.getPricesetNprice());
                    skuPriceMap.put(skuInfoDomain.getSkuCode(), price);
                    if (null == skuInfoDomain.getPricesetRefrice()) {
                        skuInfoDomain.setPricesetRefrice(BigDecimal.ZERO);
                    }
                    BigDecimal pefprice = skuInfoDomain.getGoodsCamount().multiply(skuInfoDomain.getPricesetRefrice());
                    selectedAllAmount = selectedAllAmount.add(price);
                    pefAllAmount = pefAllAmount.add(pefprice);
                    if (!StringUtils.isNotBlank((String)promotionCode)) continue;
                    promotionAllAmount = promotionAllAmount.add(price);
                    promotionAllBuyAmount = promotionAllBuyAmount.add(skuInfoDomain.getGoodsCamount());
                    if (skuInfoDomain.getShoppingGoodsCheck() != 0) continue;
                    selectedPromotionAllAmount = selectedPromotionAllAmount.add(price);
                    selectedPromotionAllBuyAmount = selectedPromotionAllBuyAmount.add(skuInfoDomain.getGoodsCamount());
                }
            }
            if (!StringUtils.isNotBlank((String)promotionCode) || null == (pmPromotion = this.getPromotionByCodeWithoutRelatatedData(tenantCode, promotionCode)) || pmPromotion.getDataState() != PromotionConstants.DATA_STATE_1) continue;
            HashMap<String, Object> map1 = new HashMap<String, Object>();
            map1.put("promotionCode", promotionCode);
            map1.put("pbCode", pmPromotion.getPbCode());
            if ("0001".equals(pmPromotion.getPbCode())) {
                PmPromotionDiscount pmPromotionDiscount;
                PmPromotionCondition pmPromotionCondition = null;
                String strdiscon = DisUtil.getMap((String)"pm-promotion_condition", (String)(pmPromotion.getPromotionCode() + "-" + tenantCode));
                List conditionList = (List)JsonUtil.buildNormalBinder().getJsonToList(strdiscon, PmPromotionCondition.class);
                if (ListUtil.isNotEmpty((Collection)conditionList)) {
                    pmPromotionCondition = (PmPromotionCondition)conditionList.get(0);
                    if (pmPromotionCondition.getCondType() == PromotionConstants.CONDITION_TYPE_0) {
                        if (pmPromotionCondition.getCondConstraint() == PromotionConstants.CONDITION_CONSTRAINT_TYPE_0 ? selectedPromotionAllAmount.compareTo(pmPromotionCondition.getCondAmount()) < 0 : pmPromotionCondition.getCondConstraint() == PromotionConstants.CONDITION_CONSTRAINT_TYPE_1 && selectedPromotionAllBuyAmount.compareTo(pmPromotionCondition.getCondAmount()) < 0) {
                            continue;
                        }
                    } else if (pmPromotionCondition.getCondType() == PromotionConstants.CONDITION_TYPE_1) {
                        // empty if block
                    }
                }
                if (null == pmPromotionCondition) continue;
                String strconucon = DisUtil.getMap((String)"pm-promotion_discount", (String)(pmPromotion.getPromotionCode() + "-" + tenantCode));
                List cisList = (List)JsonUtil.buildNormalBinder().getJsonToList(strconucon, PmPromotionDiscount.class);
                if (ListUtil.isNotEmpty((Collection)cisList) && (pmPromotionDiscount = (PmPromotionDiscount)cisList.get(0)).getDiscType() == PromotionConstants.DISCOUNT_TYPE_5) {
                    String strlistconucon = DisUtil.getMap((String)"pm-promotion_discountlist", (String)(pmPromotion.getPromotionCode() + "-" + tenantCode + "-" + pmPromotionDiscount.getPpdCode()));
                    List promotionDiscountlists = (List)JsonUtil.buildNormalBinder().getJsonToList(strlistconucon, PmPromotionDiscountlist.class);
                    if (ListUtil.isNotEmpty((Collection)promotionDiscountlists)) {
                        ArrayList<RsSku> rsSkuList = new ArrayList<RsSku>();
                        for (PmPromotionDiscountlist pmPromotionDiscountlist : promotionDiscountlists) {
                            RsSku rsSku = this.getRsSku(pmPromotionDiscountlist.getDiscountCode(), pmPromotionDiscountlist.getTenantCode());
                            if (null == rsSku) continue;
                            RsResourceGoods rsResourceGoods = this.getRsourcesGoods(rsSku.getGoodsCode(), pmPromotionDiscountlist.getTenantCode());
                            if (null != rsResourceGoods) {
                                rsSku.setGoodsName(rsResourceGoods.getGoodsName());
                            }
                            rsSkuList.add(rsSku);
                        }
                        map1.put("pmName", pmPromotion.getPromotionName());
                        map1.put("discountGoods", rsSkuList);
                        promotionResultInfo.add(map1);
                    }
                }
                pmUserOrder = new PmUserOrder();
                pmUserOrder.setPromotionCode(pmPromotion.getPromotionCode());
                pmUserOrder.setTenantCode(pmPromotion.getTenantCode());
                pmUserOrder.setUserCode(userCode);
                pmUserOrder.setOriginalAmount(promotionAllAmount);
                pmUserOrder.setDiscountAmount(discountAmount);
                pmUserOrderList.add(pmUserOrder);
                continue;
            }
            if (!"0002".equals(pmPromotion.getPbCode())) continue;
            BigDecimal disAmount = this.calcManJianForOrder(promotionResultInfo, pmPromotion, promotionAllAmount, promotionAllBuyAmount, selectedPromotionAllAmount, selectedPromotionAllBuyAmount, tenantCode);
            disAmount = pmPromotion.getPromotionMoling() == PromotionConstants.MOLING_1 ? new BigDecimal(disAmount.intValue()) : new BigDecimal(df2.format(disAmount));
            ArrayList<DiscountDataDomain> discountDataDomains = new ArrayList<DiscountDataDomain>();
            int size = skuInfoDomainList.size();
            BigDecimal tempDisAmount = disAmount;
            for (int a = 0; a < size; ++a) {
                DiscountDataDomain discountDataDomain = new DiscountDataDomain();
                OcShoppingGoodsDomain skuInfoDomain = skuInfoDomainList.get(a);
                if (a == size - 1) {
                    discountDataDomain.setSkuCode(skuInfoDomain.getSkuCode());
                    discountDataDomain.setDiscountAmount(new BigDecimal(df2.format(tempDisAmount)));
                    discountDataDomains.add(discountDataDomain);
                    break;
                }
                BigDecimal skuPrice = (BigDecimal)skuPriceMap.get(skuInfoDomain.getSkuCode());
                BigDecimal rate = skuPrice.divide(selectedAllAmount, 2, 4);
                BigDecimal skuDiscount = tempDisAmount.multiply(rate);
                discountDataDomain.setSkuCode(skuInfoDomain.getSkuCode());
                discountDataDomain.setDiscountAmount(new BigDecimal(df2.format(skuDiscount)));
                tempDisAmount = tempDisAmount.subtract(skuDiscount);
                discountDataDomains.add(discountDataDomain);
            }
            String discountData = JsonUtil.buildNormalBinder().jsonObject(discountDataDomains);
            pmUserOrder = new PmUserOrder();
            pmUserOrder.setPromotionCode(pmPromotion.getPromotionCode());
            pmUserOrder.setTenantCode(pmPromotion.getTenantCode());
            pmUserOrder.setUserCode(userCode);
            pmUserOrder.setDiscountData(discountData);
            pmUserOrder.setOriginalAmount(promotionAllAmount);
            pmUserOrder.setDiscountAmount(disAmount);
            pmUserOrderList.add(pmUserOrder);
            discountAmount = discountAmount.add(disAmount);
        }
        resultMap.put("promotionResultInfo", promotionResultInfo);
        resultMap.put("discountAmount", new BigDecimal(df2.format(discountAmount)));
        resultMap.put("totalAmount", new BigDecimal(df2.format(selectedAllAmount)));
        resultMap.put("totalPefAmount", new BigDecimal(df2.format(pefAllAmount)));
        return resultMap;
    }

    private Map<String, Object> calcPm(List<PmCalcDomain> pmCalcDomainList) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        DecimalFormat df2 = new DecimalFormat("#.00");
        BigDecimal discountAmount = BigDecimal.ZERO;
        BigDecimal selectedAllAmount = BigDecimal.ZERO;
        BigDecimal pefAllAmount = BigDecimal.ZERO;
        ArrayList<Map<String, Object>> promotionResultInfo = new ArrayList<Map<String, Object>>();
        for (PmCalcDomain pmCalcDomain : pmCalcDomainList) {
            String tenantCode = pmCalcDomain.getTenantCode();
            String promotionCode = pmCalcDomain.getPromotionCode();
            BigDecimal promotionAllAmount = BigDecimal.ZERO;
            BigDecimal selectedPromotionAllAmount = BigDecimal.ZERO;
            BigDecimal promotionAllBuyAmount = BigDecimal.ZERO;
            BigDecimal selectedPromotionAllBuyAmount = BigDecimal.ZERO;
            List<PmContractGoodsDomain> pmContractGoodsDomainList = pmCalcDomain.getPmContractGoodsDomainList();
            HashMap<String, BigDecimal> skuPriceMap = new HashMap<String, BigDecimal>();
            if (null != pmContractGoodsDomainList && pmContractGoodsDomainList.size() > 0) {
                for (PmContractGoodsDomain pmContractGoodsDomain : pmContractGoodsDomainList) {
                    BigDecimal price = pmContractGoodsDomain.getContractGoodsMoney();
                    skuPriceMap.put(pmContractGoodsDomain.getSkuCode(), price);
                    if (null == pmContractGoodsDomain.getPricesetRefrice()) {
                        pmContractGoodsDomain.setPricesetRefrice(BigDecimal.ZERO);
                    }
                    BigDecimal pefprice = pmContractGoodsDomain.getGoodsCamount().multiply(pmContractGoodsDomain.getPricesetRefrice());
                    selectedAllAmount = selectedAllAmount.add(price);
                    pefAllAmount = pefAllAmount.add(pefprice);
                    if (!StringUtils.isNotBlank((String)promotionCode)) continue;
                    promotionAllAmount = promotionAllAmount.add(price);
                    promotionAllBuyAmount = promotionAllBuyAmount.add(pmContractGoodsDomain.getGoodsCamount());
                    selectedPromotionAllAmount = selectedPromotionAllAmount.add(price);
                    selectedPromotionAllBuyAmount = selectedPromotionAllBuyAmount.add(pmContractGoodsDomain.getGoodsCamount());
                }
            }
            if (!StringUtils.isNotBlank((String)promotionCode)) continue;
            String pmstr = DisUtil.getMap((String)"pm-promotion", (String)(promotionCode + "-" + tenantCode));
            PmPromotion pmPromotion = (PmPromotion)JsonUtil.buildNormalBinder().getJsonToObject(pmstr, PmPromotion.class);
            if (null == pmPromotion || pmPromotion.getDataState() != PromotionConstants.DATA_STATE_1) continue;
            HashMap<String, Object> map1 = new HashMap<String, Object>();
            map1.put("promotionCode", promotionCode);
            map1.put("pbCode", pmPromotion.getPbCode());
            if ("0001".equals(pmPromotion.getPbCode())) {
                PmPromotionDiscount pmPromotionDiscount;
                PmPromotionCondition pmPromotionCondition = null;
                String strcon = DisUtil.getMap((String)"pm-promotion_condition", (String)(pmPromotion.getPromotionCode() + "-" + tenantCode));
                List list = (List)JsonUtil.buildNormalBinder().getJsonToList(strcon, PmPromotionCondition.class);
                if (ListUtil.isNotEmpty((Collection)list)) {
                    pmPromotionCondition = (PmPromotionCondition)list.get(0);
                    if (pmPromotionCondition.getCondType() == PromotionConstants.CONDITION_TYPE_0) {
                        if (pmPromotionCondition.getCondConstraint() == PromotionConstants.CONDITION_CONSTRAINT_TYPE_0 ? selectedPromotionAllAmount.compareTo(pmPromotionCondition.getCondAmount()) < 0 : pmPromotionCondition.getCondConstraint() == PromotionConstants.CONDITION_CONSTRAINT_TYPE_1 && selectedPromotionAllBuyAmount.compareTo(pmPromotionCondition.getCondAmount()) < 0) {
                            continue;
                        }
                    } else if (pmPromotionCondition.getCondType() == PromotionConstants.CONDITION_TYPE_1) {
                        // empty if block
                    }
                }
                if (null == pmPromotionCondition) continue;
                String strdiscon = DisUtil.getMap((String)"pm-promotion_discount", (String)(pmPromotion.getPromotionCode() + "-" + tenantCode));
                List dislists = (List)JsonUtil.buildNormalBinder().getJsonToList(strdiscon, PmPromotionDiscount.class);
                if (!ListUtil.isNotEmpty((Collection)dislists) || (pmPromotionDiscount = (PmPromotionDiscount)dislists.get(0)).getDiscType() != PromotionConstants.DISCOUNT_TYPE_5) continue;
                String strlistcon = DisUtil.getMap((String)"pm-promotion_discountlist", (String)(pmPromotion.getPromotionCode() + "-" + tenantCode + "-" + pmPromotionDiscount.getPpdCode()));
                List promotionDiscountlists = (List)JsonUtil.buildNormalBinder().getJsonToList(strlistcon, PmPromotionDiscountlist.class);
                if (!ListUtil.isNotEmpty((Collection)promotionDiscountlists)) continue;
                ArrayList<RsSku> rsSkuList = new ArrayList<RsSku>();
                for (PmPromotionDiscountlist pmPromotionDiscountlist : promotionDiscountlists) {
                    RsSku rsSku = this.getRsSku(pmPromotionDiscountlist.getDiscountCode(), pmPromotionDiscountlist.getTenantCode());
                    if (null == rsSku) continue;
                    RsResourceGoods rsResourceGoods = this.getRsourcesGoods(rsSku.getGoodsCode(), pmPromotionDiscountlist.getTenantCode());
                    if (null != rsResourceGoods) {
                        rsSku.setGoodsName(rsResourceGoods.getGoodsName());
                    }
                    rsSkuList.add(rsSku);
                }
                map1.put("pmName", pmPromotion.getPromotionName());
                map1.put("discountGoods", rsSkuList);
                promotionResultInfo.add(map1);
                continue;
            }
            if (!"0002".equals(pmPromotion.getPbCode())) continue;
            BigDecimal disAmount = this.calcManJianForOrder(promotionResultInfo, pmPromotion, promotionAllAmount, promotionAllBuyAmount, selectedPromotionAllAmount, selectedPromotionAllBuyAmount, tenantCode);
            disAmount = pmPromotion.getPromotionMoling() == PromotionConstants.MOLING_1 ? new BigDecimal(disAmount.intValue()) : new BigDecimal(df2.format(disAmount));
            int size = pmContractGoodsDomainList.size();
            BigDecimal tempDisAmount = disAmount;
            for (int a = 0; a < size; ++a) {
                PmContractGoodsDomain pmContractGoodsDomain = pmContractGoodsDomainList.get(a);
                if (a == size - 1) {
                    pmContractGoodsDomain.setContractGoodsMoney(pmContractGoodsDomain.getContractGoodsMoney().subtract(new BigDecimal(df2.format(tempDisAmount))));
                    break;
                }
                BigDecimal skuPrice = (BigDecimal)skuPriceMap.get(pmContractGoodsDomain.getSkuCode());
                BigDecimal rate = skuPrice.divide(selectedAllAmount, 2, 4);
                BigDecimal skuDiscount = tempDisAmount.multiply(rate);
                pmContractGoodsDomain.setContractGoodsMoney(pmContractGoodsDomain.getContractGoodsMoney().subtract(new BigDecimal(df2.format(skuDiscount))));
                tempDisAmount = tempDisAmount.subtract(skuDiscount);
            }
            discountAmount = discountAmount.add(disAmount);
        }
        resultMap.put("promotionResultInfo", promotionResultInfo);
        resultMap.put("discountAmount", new BigDecimal(df2.format(discountAmount)));
        resultMap.put("totalAmount", new BigDecimal(df2.format(selectedAllAmount)));
        resultMap.put("totalPefAmount", new BigDecimal(df2.format(pefAllAmount)));
        return resultMap;
    }

    private Map<String, Object> calcCoupon(List<PmCalcDomain> pmCalcDomainList, List<OcContractSettlDomain> ocContractSettlDomainList) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        DecimalFormat df2 = new DecimalFormat("#.00");
        BigDecimal discountAmount = BigDecimal.ZERO;
        BigDecimal allAmount = BigDecimal.ZERO;
        HashMap<String, BigDecimal> skuPriceMap = new HashMap<String, BigDecimal>();
        String tenantCode = "";
        ArrayList<PmContractGoodsDomain> pmContractGoodsDomainListAll = new ArrayList<PmContractGoodsDomain>();
        for (PmCalcDomain pmCalcDomain : pmCalcDomainList) {
            tenantCode = pmCalcDomain.getTenantCode();
            List<PmContractGoodsDomain> pmContractGoodsDomainList = pmCalcDomain.getPmContractGoodsDomainList();
            pmContractGoodsDomainListAll.addAll(pmContractGoodsDomainList);
            if (null == pmContractGoodsDomainList || pmContractGoodsDomainList.size() <= 0) continue;
            for (PmContractGoodsDomain pmContractGoodsDomain : pmContractGoodsDomainList) {
                BigDecimal price = pmContractGoodsDomain.getContractGoodsMoney();
                skuPriceMap.put(pmContractGoodsDomain.getSkuCode(), price);
                allAmount = allAmount.add(price);
            }
        }
        for (OcContractSettlDomain ocContractSettlDomain : ocContractSettlDomainList) {
            List<PmPromotionDiscount> pmPromotionDiscountList;
            List pmPromotionConditionList;
            String tionstr;
            this.logger.error(ocContractSettlDomain.getContractSettlOpno() + "======" + tenantCode, (Object)"==============");
            PmUserCoupon pmUserCoupon = this.getPmUserCouponService().getUserCouponByCode(tenantCode, ocContractSettlDomain.getContractSettlOpno());
            if (null == pmUserCoupon || pmUserCoupon.getDataState() == PromotionConstants.USERCOUPON_DATA_STATE_1) continue;
            String pmstr = DisUtil.getMap((String)"pm-promotion", (String)(pmUserCoupon.getPromotionCode() + "-" + tenantCode));
            PmPromotion pmPromotion = (PmPromotion)JsonUtil.buildNormalBinder().getJsonToObject(pmstr, PmPromotion.class);
            if (null == pmPromotion || pmPromotion.getDataState() != PromotionConstants.DATA_STATE_1) continue;
            String listKey = pmUserCoupon.getPromotionCode() + "-" + tenantCode;
            if ("0003".equals(pmPromotion.getPbCode())) {
                tionstr = DisUtil.getMap((String)"pm-promotion_discount", (String)(pmUserCoupon.getPromotionCode() + "-" + tenantCode));
                List pmPromotionDiscountList2 = (List)JsonUtil.buildNormalBinder().getJsonToList(tionstr, PmPromotionDiscount.class);
                if (null == pmPromotionDiscountList2 || pmPromotionDiscountList2.size() <= 0) continue;
                discountAmount = discountAmount.add(((PmPromotionDiscount)pmPromotionDiscountList2.get(0)).getDiscAmount());
                continue;
            }
            if ("0004".equals(pmPromotion.getPbCode())) {
                PmPromotionCondition pmPromotionCondition;
                tionstr = DisUtil.getMap((String)"pm-promotion_condition", (String)(pmUserCoupon.getPromotionCode() + "-" + tenantCode));
                pmPromotionConditionList = (List)JsonUtil.buildNormalBinder().getJsonToList(tionstr, PmPromotionCondition.class);
                if (null == pmPromotionConditionList || pmPromotionConditionList.size() <= 0 || allAmount.compareTo((pmPromotionCondition = (PmPromotionCondition)pmPromotionConditionList.get(0)).getCondAmount()) < 0) continue;
                discountAmount = discountAmount.add(pmPromotionCondition.getCondResultAmount());
                continue;
            }
            if (!"0005".equals(pmPromotion.getPbCode())) continue;
            tionstr = DisUtil.getMap((String)"pm-promotion_condition", (String)(pmUserCoupon.getPromotionCode() + "-" + tenantCode));
            pmPromotionConditionList = (List)JsonUtil.buildNormalBinder().getJsonToList(tionstr, PmPromotionCondition.class);
            if (null == pmPromotionConditionList || pmPromotionConditionList.size() <= 0 || null == (pmPromotionDiscountList = pmPromotion.getPmPromotionDiscountList())) continue;
            discountAmount = discountAmount.add(allAmount.multiply(new BigDecimal(100).subtract(pmPromotionDiscountList.get(0).getDiscAmount()).divide(new BigDecimal(100))));
        }
        int size = pmContractGoodsDomainListAll.size();
        BigDecimal tempDisAmount = discountAmount;
        if (tempDisAmount.compareTo(BigDecimal.ZERO) > 0) {
            for (int a = 0; a < size; ++a) {
                PmContractGoodsDomain pmContractGoodsDomain = (PmContractGoodsDomain)pmContractGoodsDomainListAll.get(a);
                if (a == size - 1) {
                    pmContractGoodsDomain.setContractGoodsMoney(pmContractGoodsDomain.getContractGoodsMoney().subtract(new BigDecimal(df2.format(tempDisAmount))));
                    break;
                }
                BigDecimal skuPrice = (BigDecimal)skuPriceMap.get(pmContractGoodsDomain.getSkuCode());
                BigDecimal rate = skuPrice.divide(allAmount, 2, 4);
                BigDecimal skuDiscount = tempDisAmount.multiply(rate);
                pmContractGoodsDomain.setContractGoodsMoney(pmContractGoodsDomain.getContractGoodsMoney().subtract(new BigDecimal(df2.format(skuDiscount))));
                pmContractGoodsDomain.setContractGoodsPrice(pmContractGoodsDomain.getContractGoodsMoney().divide(pmContractGoodsDomain.getGoodsCamount(), 2, 4));
                tempDisAmount = tempDisAmount.subtract(skuDiscount);
            }
        }
        resultMap.put("discountAmount", new BigDecimal(df2.format(discountAmount)));
        resultMap.put("pmContractGoodsDomainListAll", pmContractGoodsDomainListAll);
        return resultMap;
    }

    private TypeBean getOcSetting(String shoppingType, String tenantCode) {
        String memo;
        OcCflowReDomain ocCflowReDomain;
        TypeBean typeBean = null;
        String json = SupDisUtil.getMap((String)this.CACHE_KEY_CFLOW, (String)(shoppingType + "-" + tenantCode));
        if (StringUtils.isBlank((String)json)) {
            json = SupDisUtil.getMap((String)this.CACHE_KEY_CFLOW, (String)(shoppingType + "-" + "00000000"));
        }
        if (StringUtils.isNotBlank((String)json) && null != (ocCflowReDomain = (OcCflowReDomain)JsonUtil.buildNormalBinder().getJsonToObject(json, OcCflowReDomain.class)) && StringUtils.isNotBlank((String)(memo = ocCflowReDomain.getMemo()))) {
            typeBean = (TypeBean)JsonUtil.buildNormalBinder().getJsonToObject(memo, TypeBean.class);
        }
        return typeBean;
    }

    @Override
    public List<OcShoppingDomain> addPromotionForShoppingGoods(List<OcShoppingDomain> ocShoppingDomainList, String userCode, String terminalType) {
        ArrayList<OcShoppingGoodsDomain> ocShoppingGoodsDomainList1;
        HashMap ocPmMap = new HashMap();
        HashMap<String, ArrayList<OcShoppingGoodsDomain>> pmGoodsMap = new HashMap<String, ArrayList<OcShoppingGoodsDomain>>();
        HashMap<String, PmPromotionIn> pmMap = new HashMap<String, PmPromotionIn>();
        HashMap<String, List<OcShoppingGoodsDomain>> noPmGoodsMap = new HashMap<String, List<OcShoppingGoodsDomain>>();
        if (null != ocShoppingDomainList && ocShoppingDomainList.size() > 0) {
            TypeBean typeBean = null;
            for (OcShoppingDomain ocShoppingDomain : ocShoppingDomainList) {
                List<OcShoppingGoodsDomain> ocShoppingGoodsDomainList = ocShoppingDomain.getList();
                String shoppingCode = ocShoppingDomain.getShoppingCode();
                String tenantCode = ocShoppingDomain.getTenantCode();
                typeBean = this.getOcSetting(ocShoppingDomain.getShoppingType(), ocShoppingDomain.getTenantCode());
                if (null != typeBean) {
                    ocShoppingDomain.setScontractBlance(typeBean.getBlance());
                    ocShoppingDomain.setScontractPmode(typeBean.getPmode());
                    ocShoppingDomain.setIntpay(typeBean.getIntpay());
                    ocShoppingDomain.setPmpay(typeBean.getPmpay());
                }
                if (null != typeBean && !"0".equals(typeBean.getPmpay())) {
                    ocShoppingDomain.setNoPmList(ocShoppingDomain.getList());
                    noPmGoodsMap.put(shoppingCode, ocShoppingDomain.getList());
                    continue;
                }
                if (null == ocShoppingGoodsDomainList || ocShoppingGoodsDomainList.size() <= 0) continue;
                for (OcShoppingGoodsDomain ocShoppingGoodsDomain : ocShoppingGoodsDomainList) {
                    String skuCode = ocShoppingGoodsDomain.getSkuCode();
                    List<PmPromotionIn> pmPromotionList = this.caPmpromotion(tenantCode, skuCode, ocShoppingGoodsDomain);
                    String shoppingGoodsPmCode = ocShoppingGoodsDomain.getShoppingGoodsPm();
                    String defaultPmCode = "";
                    ArrayList<PromotionForOcReDomain> promotionForOcReDomainList = new ArrayList<PromotionForOcReDomain>();
                    if (null != pmPromotionList && pmPromotionList.size() > 0) {
                        defaultPmCode = pmPromotionList.get(0).getPromotionCode();
                        for (PmPromotionIn pmPromotion : pmPromotionList) {
                            pmMap.put(shoppingCode + pmPromotion.getPromotionCode(), pmPromotion);
                            PromotionForOcReDomain promotionForOcReDomain = new PromotionForOcReDomain();
                            promotionForOcReDomain.setPbCode(pmPromotion.getPbCode());
                            promotionForOcReDomain.setPromotionCode(pmPromotion.getPromotionCode());
                            promotionForOcReDomain.setPromotionName(pmPromotion.getPromotionName());
                            promotionForOcReDomainList.add(promotionForOcReDomain);
                        }
                    }
                    ocShoppingGoodsDomain.setPmPromotionList(promotionForOcReDomainList);
                    if (StringUtils.isEmpty((String)defaultPmCode)) {
                        ocShoppingGoodsDomain.setShoppingGoodsPm("");
                        this.updateShoppingGoods(ocShoppingGoodsDomain);
                        ArrayList<OcShoppingGoodsDomain> noPmGoodsList = (ArrayList<OcShoppingGoodsDomain>)noPmGoodsMap.get(shoppingCode);
                        if (null != noPmGoodsList && noPmGoodsList.size() > 0) {
                            noPmGoodsList.add(ocShoppingGoodsDomain);
                        } else {
                            noPmGoodsList = new ArrayList<OcShoppingGoodsDomain>();
                            noPmGoodsList.add(ocShoppingGoodsDomain);
                        }
                        noPmGoodsMap.put(shoppingCode, noPmGoodsList);
                        continue;
                    }
                    if (!StringUtils.isEmpty((String)shoppingGoodsPmCode)) {
                        if (!pmMap.keySet().contains(shoppingCode + shoppingGoodsPmCode)) {
                            shoppingGoodsPmCode = defaultPmCode;
                            ocShoppingGoodsDomain.setShoppingGoodsPm(shoppingGoodsPmCode);
                            this.updateShoppingGoods(ocShoppingGoodsDomain);
                        }
                    } else {
                        shoppingGoodsPmCode = defaultPmCode;
                        ocShoppingGoodsDomain.setShoppingGoodsPm(defaultPmCode);
                        this.updateShoppingGoods(ocShoppingGoodsDomain);
                    }
                    if (null != (ocShoppingGoodsDomainList1 = (List)pmGoodsMap.get(shoppingCode + shoppingGoodsPmCode)) && ocShoppingGoodsDomainList1.size() > 0) {
                        ocShoppingGoodsDomainList1.add(ocShoppingGoodsDomain);
                    } else {
                        ocShoppingGoodsDomainList1 = new ArrayList<OcShoppingGoodsDomain>();
                        ocShoppingGoodsDomainList1.add(ocShoppingGoodsDomain);
                    }
                    pmGoodsMap.put(shoppingCode + shoppingGoodsPmCode, ocShoppingGoodsDomainList1);
                    ArrayList<String> pmPromotionCodeList = (ArrayList<String>)ocPmMap.get(shoppingCode);
                    if (null != pmPromotionCodeList && pmPromotionCodeList.size() > 0) {
                        if (!pmPromotionCodeList.contains(shoppingGoodsPmCode)) {
                            pmPromotionCodeList.add(shoppingGoodsPmCode);
                        }
                    } else {
                        pmPromotionCodeList = new ArrayList<String>();
                        pmPromotionCodeList.add(shoppingGoodsPmCode);
                    }
                    ocPmMap.put(shoppingCode, pmPromotionCodeList);
                }
            }
        }
        if (null != ocShoppingDomainList && ocShoppingDomainList.size() > 0) {
            for (OcShoppingDomain ocShoppingDomain : ocShoppingDomainList) {
                List pmPromotionCodeList;
                String tenantCode = ocShoppingDomain.getTenantCode();
                ocShoppingDomain.setList(null);
                ArrayList<PmPromotionCalcDomain> calcDomainList = new ArrayList<PmPromotionCalcDomain>();
                ArrayList<PmPromotion> pmPromotionList = new ArrayList<PmPromotion>();
                String shoppingCode = ocShoppingDomain.getShoppingCode();
                List noPmGoodsList = (List)noPmGoodsMap.get(shoppingCode);
                if (null != noPmGoodsList && noPmGoodsList.size() > 0) {
                    PmPromotionCalcDomain pmPromotionCalcDomain = new PmPromotionCalcDomain();
                    pmPromotionCalcDomain.setPromotionCode("");
                    List skuList = noPmGoodsList;
                    pmPromotionCalcDomain.setSkuList(skuList);
                    calcDomainList.add(pmPromotionCalcDomain);
                    ocShoppingDomain.setNoPmList(noPmGoodsList);
                }
                if (null != (pmPromotionCodeList = (List)ocPmMap.get(shoppingCode)) && pmPromotionCodeList.size() > 0) {
                    for (String pmPromotionCode : pmPromotionCodeList) {
                        PmPromotionIn pmPromotionIn = (PmPromotionIn)pmMap.get(shoppingCode + pmPromotionCode);
                        PmPromotion pmPromotion = new PmPromotion();
                        try {
                            BeanUtils.copyAllPropertys((Object)pmPromotion, (Object)pmPromotionIn);
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        PmPromotionCalcDomain pmPromotionCalcDomain = new PmPromotionCalcDomain();
                        pmPromotionCalcDomain.setPromotionCode(pmPromotion.getPromotionCode());
                        ocShoppingGoodsDomainList1 = (ArrayList<OcShoppingGoodsDomain>)pmGoodsMap.get(shoppingCode + pmPromotionCode);
                        if (null != ocShoppingGoodsDomainList1 && ocShoppingGoodsDomainList1.size() > 0) {
                            pmPromotion.setOcShoppingGoodsList(ocShoppingGoodsDomainList1);
                            pmPromotionCalcDomain.setSkuList(ocShoppingGoodsDomainList1);
                        }
                        pmPromotionList.add(pmPromotion);
                        calcDomainList.add(pmPromotionCalcDomain);
                    }
                }
                Map<Object, Object> calcResult = new HashMap();
                if (null != calcDomainList && calcDomainList.size() > 0) {
                    calcResult = this.calcPromotionForShoppingGoods(calcDomainList, "", tenantCode, userCode, terminalType);
                }
                ocShoppingDomain.setCalcResult(calcResult);
                ocShoppingDomain.setPmPromotionList(pmPromotionList);
            }
        }
        return ocShoppingDomainList;
    }

    private void updateShoppingGoods(OcShoppingGoodsDomain ocShoppingGoodsDomain) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("ocShoppingGoodsDomain", JsonUtil.buildNormalBinder().toJson((Object)ocShoppingGoodsDomain));
        this.inAsyncInvoke("oc.shopping.updateShoppingGoods", paramMap);
    }

    @Override
    public Map<String, Object> calcPromotionForShoppingGoods(List<PmPromotionCalcDomain> calcDomainList, String contractBillCode, String tenantCode, String userCode, String terminalType) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        DecimalFormat df2 = new DecimalFormat("#.00");
        BigDecimal discountAmount = BigDecimal.ZERO;
        BigDecimal selectedAllAmount = BigDecimal.ZERO;
        BigDecimal pefAllAmount = BigDecimal.ZERO;
        ArrayList<RsSku> rsSkuList = new ArrayList<RsSku>();
        ArrayList<Map<String, String>> promotionResultInfo = new ArrayList<Map<String, String>>();
        for (PmPromotionCalcDomain pmPromotionCalcDomain : calcDomainList) {
            PmPromotion pmPromotion;
            String promotionCode = pmPromotionCalcDomain.getPromotionCode();
            BigDecimal promotionAllAmount = BigDecimal.ZERO;
            BigDecimal selectedPromotionAllAmount = BigDecimal.ZERO;
            BigDecimal promotionAllBuyAmount = BigDecimal.ZERO;
            BigDecimal selectedPromotionAllBuyAmount = BigDecimal.ZERO;
            List<OcShoppingGoodsDomain> skuInfoDomainList = pmPromotionCalcDomain.getSkuList();
            if (null != skuInfoDomainList && skuInfoDomainList.size() > 0) {
                for (OcShoppingGoodsDomain skuInfoDomain : skuInfoDomainList) {
                    BigDecimal price = skuInfoDomain.getGoodsCamount().multiply(skuInfoDomain.getPricesetNprice());
                    if (null == skuInfoDomain.getPricesetRefrice()) {
                        skuInfoDomain.setPricesetRefrice(BigDecimal.ZERO);
                    }
                    BigDecimal pefprice = skuInfoDomain.getGoodsCamount().multiply(skuInfoDomain.getPricesetRefrice());
                    if (skuInfoDomain.getShoppingGoodsCheck() == 0) {
                        selectedAllAmount = selectedAllAmount.add(price);
                        pefAllAmount = pefAllAmount.add(pefprice);
                    }
                    if (!StringUtils.isNotBlank((String)promotionCode)) continue;
                    promotionAllAmount = promotionAllAmount.add(price);
                    promotionAllBuyAmount = promotionAllBuyAmount.add(skuInfoDomain.getGoodsCamount());
                    if (skuInfoDomain.getShoppingGoodsCheck() != 0) continue;
                    selectedPromotionAllAmount = selectedPromotionAllAmount.add(price);
                    selectedPromotionAllBuyAmount = selectedPromotionAllBuyAmount.add(skuInfoDomain.getGoodsCamount());
                }
            }
            if (!StringUtils.isNotBlank((String)promotionCode) || null == (pmPromotion = this.getPromotionByCodeWithoutRelatatedData(tenantCode, promotionCode)) || pmPromotion.getDataState() != PromotionConstants.DATA_STATE_1) continue;
            HashMap<String, String> map1 = new HashMap<String, String>();
            map1.put("promotionCode", promotionCode);
            map1.put("pbCode", pmPromotion.getPbCode());
            if ("0001".equals(pmPromotion.getPbCode())) {
                BigDecimal condAmount;
                PmPromotionDiscount pmPromotionDiscount;
                PmPromotionCondition pmPromotionCondition = null;
                String strcon = DisUtil.getMap((String)"pm-promotion_condition", (String)(pmPromotion.getPromotionCode() + "-" + tenantCode));
                List list = (List)JsonUtil.buildNormalBinder().getJsonToList(strcon, PmPromotionCondition.class);
                if (ListUtil.isNotEmpty((Collection)list)) {
                    pmPromotionCondition = (PmPromotionCondition)list.get(0);
                    if (pmPromotionCondition.getCondType() == PromotionConstants.CONDITION_TYPE_0) {
                        String disDesc;
                        BigDecimal condAmount2;
                        BigDecimal needAmount;
                        if (pmPromotionCondition.getCondConstraint() == PromotionConstants.CONDITION_CONSTRAINT_TYPE_0) {
                            if (selectedPromotionAllAmount.compareTo(pmPromotionCondition.getCondAmount()) < 0) {
                                needAmount = pmPromotionCondition.getCondAmount().subtract(selectedPromotionAllAmount);
                                needAmount = new BigDecimal(df2.format(needAmount));
                                condAmount2 = new BigDecimal(df2.format(pmPromotionCondition.getCondAmount()));
                                map1.put("disAmonut", "-" + needAmount);
                                disDesc = "\u8d2d\u4e70" + condAmount2 + "\u5143\u9001\u8d60\u54c1,\u8fd8\u5dee" + needAmount + "\u5143";
                                map1.put("disDesc", disDesc);
                                promotionResultInfo.add(map1);
                                continue;
                            }
                        } else if (pmPromotionCondition.getCondConstraint() == PromotionConstants.CONDITION_CONSTRAINT_TYPE_1 && selectedPromotionAllBuyAmount.compareTo(pmPromotionCondition.getCondAmount()) < 0) {
                            needAmount = pmPromotionCondition.getCondAmount().subtract(selectedPromotionAllBuyAmount);
                            needAmount = new BigDecimal(needAmount.intValue());
                            condAmount2 = new BigDecimal(pmPromotionCondition.getCondAmount().intValue());
                            map1.put("disAmonut", "-" + needAmount);
                            disDesc = "\u8d2d\u4e70" + condAmount2 + "\u4ef6\u9001\u8d60\u54c1,\u8fd8\u5dee" + needAmount + "\u4ef6";
                            map1.put("disAmonut", "-" + needAmount);
                            map1.put("disDesc", disDesc);
                            promotionResultInfo.add(map1);
                            continue;
                        }
                    } else if (pmPromotionCondition.getCondType() == PromotionConstants.CONDITION_TYPE_1) {
                        // empty if block
                    }
                }
                if (null == pmPromotionCondition) continue;
                String strdiscon = DisUtil.getMap((String)"pm-promotion_discount", (String)(pmPromotion.getPromotionCode() + "-" + tenantCode));
                List dislist = (List)JsonUtil.buildNormalBinder().getJsonToList(strdiscon, PmPromotionDiscount.class);
                if (!ListUtil.isNotEmpty((Collection)dislist) || (pmPromotionDiscount = (PmPromotionDiscount)dislist.get(0)).getDiscType() != PromotionConstants.DISCOUNT_TYPE_5) continue;
                String strlistcon = DisUtil.getMap((String)"pm-promotion_discountlist", (String)(pmPromotion.getPromotionCode() + "-" + tenantCode + "-" + pmPromotionDiscount.getPpdCode()));
                List promotionDiscountlists = (List)JsonUtil.buildNormalBinder().getJsonToList(strlistcon, PmPromotionDiscountlist.class);
                if (!ListUtil.isNotEmpty((Collection)promotionDiscountlists)) continue;
                for (PmPromotionDiscountlist pmPromotionDiscountlist : promotionDiscountlists) {
                    RsSku rsSku = this.getRsSku(pmPromotionDiscountlist.getDiscountCode(), pmPromotionDiscountlist.getTenantCode());
                    if (null == rsSku) continue;
                    RsResourceGoods rsResourceGoods = this.getRsourcesGoods(rsSku.getGoodsCode(), pmPromotionDiscountlist.getTenantCode());
                    if (null != rsResourceGoods) {
                        rsSku.setGoodsName(rsResourceGoods.getGoodsName());
                    }
                    rsSkuList.add(rsSku);
                }
                String disDesc = "\u5df2\u8d2d\u6ee1";
                if (pmPromotionCondition.getCondConstraint() == PromotionConstants.CONDITION_CONSTRAINT_TYPE_0) {
                    condAmount = new BigDecimal(df2.format(pmPromotionCondition.getCondAmount()));
                    disDesc = disDesc + condAmount + "\u5143,\u5df2\u83b7\u5f97\u8d60\u54c1";
                } else if (pmPromotionCondition.getCondConstraint() == PromotionConstants.CONDITION_CONSTRAINT_TYPE_1) {
                    condAmount = new BigDecimal(pmPromotionCondition.getCondAmount().intValue());
                    disDesc = disDesc + condAmount + "\u4ef6,\u5df2\u83b7\u5f97\u8d60\u54c1";
                }
                map1.put("disAmonut", "-");
                map1.put("disDesc", disDesc);
                promotionResultInfo.add(map1);
                continue;
            }
            if (!"0002".equals(pmPromotion.getPbCode())) continue;
            BigDecimal disAmount = this.calcManJian(promotionResultInfo, pmPromotion.getPbCode(), promotionAllAmount, promotionAllBuyAmount, selectedPromotionAllAmount, selectedPromotionAllBuyAmount, promotionCode, tenantCode);
            disAmount = pmPromotion.getPromotionMoling() == PromotionConstants.MOLING_1 ? new BigDecimal(disAmount.intValue()) : new BigDecimal(df2.format(disAmount));
            discountAmount = discountAmount.add(disAmount);
        }
        resultMap.put("promotionResultInfo", promotionResultInfo);
        resultMap.put("discountAmount", new BigDecimal(df2.format(discountAmount)));
        resultMap.put("totalAmount", new BigDecimal(df2.format(selectedAllAmount)));
        resultMap.put("totalPefAmount", new BigDecimal(df2.format(pefAllAmount)));
        resultMap.put("discountGoods", rsSkuList);
        return resultMap;
    }

    private BigDecimal calcManJianForOrder(List<Map<String, Object>> promotionResultInfo, PmPromotion pmPromotion, BigDecimal promotionAllAmount, BigDecimal promotionAllBuyAmount, BigDecimal selectedPromotionAllAmount, BigDecimal selectedPromotionAllBuyAmount, String tenantCode) {
        DecimalFormat df2 = new DecimalFormat("#.00");
        String strdiscon = DisUtil.getMap((String)"pm-promotion_condition", (String)(pmPromotion.getPromotionCode() + "-" + tenantCode));
        List conditionList = (List)JsonUtil.buildNormalBinder().getJsonToList(strdiscon, PmPromotionCondition.class);
        HashMap<String, String> map1 = new HashMap<String, String>();
        map1.put("promotionCode", pmPromotion.getPromotionCode());
        map1.put("pbCode", pmPromotion.getPbCode());
        map1.put("pmName", pmPromotion.getPromotionName());
        if (ListUtil.isNotEmpty((Collection)conditionList)) {
            PmPromotionCondition finalCondition = null;
            for (PmPromotionCondition condition : conditionList) {
                if (condition.getCondType() == PromotionConstants.CONDITION_TYPE_0) {
                    int resultAmount = promotionAllAmount.compareTo(condition.getCondAmount());
                    int resultBuyAmount = promotionAllBuyAmount.compareTo(condition.getCondAmount());
                    if (condition.getCondConstraint() == PromotionConstants.CONDITION_CONSTRAINT_TYPE_0) {
                        if (resultAmount >= 0) {
                            finalCondition = condition;
                            continue;
                        }
                        promotionResultInfo.add(map1);
                        break;
                    }
                    if (condition.getCondConstraint() != PromotionConstants.CONDITION_CONSTRAINT_TYPE_1) continue;
                    if (resultBuyAmount >= 0) {
                        finalCondition = condition;
                        continue;
                    }
                    promotionResultInfo.add(map1);
                    break;
                }
                if (condition.getCondType() != PromotionConstants.CONDITION_TYPE_1) continue;
            }
            BigDecimal disAmonut = new BigDecimal(0);
            if (null != finalCondition) {
                int resultBuyAmount;
                if (finalCondition.getCondConstraint() == PromotionConstants.CONDITION_CONSTRAINT_TYPE_0) {
                    int resultAmount = selectedPromotionAllAmount.compareTo(finalCondition.getCondAmount());
                    if (resultAmount < 0) {
                        promotionResultInfo.add(map1);
                        return disAmonut;
                    }
                } else if (finalCondition.getCondConstraint() == PromotionConstants.CONDITION_CONSTRAINT_TYPE_1 && (resultBuyAmount = selectedPromotionAllBuyAmount.compareTo(finalCondition.getCondAmount())) < 0) {
                    promotionResultInfo.add(map1);
                    return disAmonut;
                }
                BigDecimal discountAmount = BigDecimal.ZERO;
                if (finalCondition.getCondResultAmountType() == PromotionConstants.CONDITION_RESULTAMOUNT_TYPE_0) {
                    if (finalCondition.getCondLimit() == PromotionConstants.CONDITION_LIMIT_1) {
                        BigDecimal times = selectedPromotionAllAmount.divideToIntegralValue(finalCondition.getCondAmount());
                        discountAmount = selectedPromotionAllAmount.subtract(finalCondition.getCondResultAmount().multiply(times));
                    } else {
                        discountAmount = selectedPromotionAllAmount.subtract(finalCondition.getCondResultAmount());
                    }
                    disAmonut = new BigDecimal(df2.format(selectedPromotionAllAmount.subtract(discountAmount)));
                } else if (finalCondition.getCondResultAmountType() == PromotionConstants.CONDITION_RESULTAMOUNT_TYPE_1) {
                    discountAmount = selectedPromotionAllAmount.multiply(finalCondition.getCondResultAmount().divide(new BigDecimal(100)));
                    disAmonut = new BigDecimal(df2.format(selectedPromotionAllAmount.subtract(discountAmount)));
                }
                promotionResultInfo.add(map1);
                return disAmonut;
            }
        }
        return BigDecimal.ZERO;
    }

    private BigDecimal calcManJian(List<Map<String, String>> promotionResultInfo, String pbCode, BigDecimal promotionAllAmount, BigDecimal promotionAllBuyAmount, BigDecimal selectedPromotionAllAmount, BigDecimal selectedPromotionAllBuyAmount, String promotionCode, String tenantCode) {
        DecimalFormat df2 = new DecimalFormat("#.00");
        String strlistcon = DisUtil.getMap((String)"pm-promotion_condition", (String)(promotionCode + "-" + tenantCode));
        List conditionList = (List)JsonUtil.buildNormalBinder().getJsonToList(strlistcon, PmPromotionCondition.class);
        HashMap<String, String> map1 = new HashMap<String, String>();
        map1.put("promotionCode", promotionCode);
        map1.put("pbCode", pbCode);
        if (ListUtil.isNotEmpty((Collection)conditionList)) {
            int resultAmount;
            PmPromotionCondition finalCondition = null;
            for (PmPromotionCondition condition : conditionList) {
                if (condition.getCondType() == PromotionConstants.CONDITION_TYPE_0) {
                    resultAmount = promotionAllAmount.compareTo(condition.getCondAmount());
                    int resultBuyAmount = promotionAllBuyAmount.compareTo(condition.getCondAmount());
                    if (condition.getCondConstraint() == PromotionConstants.CONDITION_CONSTRAINT_TYPE_0) {
                        if (resultAmount >= 0) {
                            finalCondition = condition;
                            continue;
                        }
                        map1.put("disDesc", this.showPmDisDescForType0(condition, selectedPromotionAllAmount, map1));
                        promotionResultInfo.add(map1);
                        break;
                    }
                    if (condition.getCondConstraint() != PromotionConstants.CONDITION_CONSTRAINT_TYPE_1) continue;
                    if (resultBuyAmount >= 0) {
                        finalCondition = condition;
                        continue;
                    }
                    map1.put("disDesc", this.showPmDisDescForType1(condition, selectedPromotionAllBuyAmount, map1));
                    promotionResultInfo.add(map1);
                    break;
                }
                if (condition.getCondType() != PromotionConstants.CONDITION_TYPE_1) continue;
            }
            BigDecimal disAmonut = new BigDecimal(0);
            if (null != finalCondition) {
                String disDesc = "\u5df2\u8d2d\u6ee1";
                if (finalCondition.getCondConstraint() == PromotionConstants.CONDITION_CONSTRAINT_TYPE_0) {
                    resultAmount = selectedPromotionAllAmount.compareTo(finalCondition.getCondAmount());
                    if (resultAmount < 0) {
                        map1.put("disDesc", this.showPmDisDescForType0(finalCondition, selectedPromotionAllAmount, map1));
                        promotionResultInfo.add(map1);
                        return disAmonut;
                    }
                    BigDecimal condAmount = new BigDecimal(df2.format(finalCondition.getCondAmount()));
                    disDesc = disDesc + condAmount + "\u5143,";
                } else if (finalCondition.getCondConstraint() == PromotionConstants.CONDITION_CONSTRAINT_TYPE_1) {
                    int resultBuyAmount = selectedPromotionAllBuyAmount.compareTo(finalCondition.getCondAmount());
                    if (resultBuyAmount < 0) {
                        map1.put("disDesc", this.showPmDisDescForType1(finalCondition, selectedPromotionAllBuyAmount, map1));
                        promotionResultInfo.add(map1);
                        return disAmonut;
                    }
                    BigDecimal condAmount = new BigDecimal(finalCondition.getCondAmount().intValue());
                    disDesc = disDesc + condAmount + "\u4ef6,";
                }
                BigDecimal discountAmount = new BigDecimal(0);
                if (finalCondition.getCondResultAmountType() == PromotionConstants.CONDITION_RESULTAMOUNT_TYPE_0) {
                    if (finalCondition.getCondLimit() == PromotionConstants.CONDITION_LIMIT_1) {
                        BigDecimal times = selectedPromotionAllAmount.divideToIntegralValue(finalCondition.getCondAmount());
                        discountAmount = selectedPromotionAllAmount.subtract(finalCondition.getCondResultAmount().multiply(times));
                    } else {
                        discountAmount = selectedPromotionAllAmount.subtract(finalCondition.getCondResultAmount());
                    }
                    disAmonut = new BigDecimal(df2.format(selectedPromotionAllAmount.subtract(discountAmount)));
                    disDesc = disDesc + "\u5df2\u51cf" + disAmonut + "\u5143";
                } else if (finalCondition.getCondResultAmountType() == PromotionConstants.CONDITION_RESULTAMOUNT_TYPE_1) {
                    discountAmount = selectedPromotionAllAmount.multiply(finalCondition.getCondResultAmount().divide(new BigDecimal(100)));
                    BigDecimal zhe = finalCondition.getCondResultAmount().divide(new BigDecimal(10));
                    disDesc = disDesc + "\u5df2\u6253" + zhe.stripTrailingZeros().toPlainString() + "\u6298";
                    disAmonut = new BigDecimal(df2.format(selectedPromotionAllAmount.subtract(discountAmount)));
                }
                map1.put("disAmonut", "" + disAmonut);
                map1.put("disDesc", disDesc);
                promotionResultInfo.add(map1);
                return disAmonut;
            }
        }
        return new BigDecimal(0);
    }

    private String showPmDisDescForType0(PmPromotionCondition finalCondition, BigDecimal selectedPromotionAllAmount, Map<String, String> map1) {
        BigDecimal needAmount = finalCondition.getCondAmount().subtract(selectedPromotionAllAmount);
        DecimalFormat df2 = new DecimalFormat("#.00");
        needAmount = new BigDecimal(df2.format(needAmount));
        BigDecimal condAmount = new BigDecimal(df2.format(finalCondition.getCondAmount()));
        map1.put("disAmonut", "-" + needAmount);
        String disDesc = "\u8d2d\u6ee1" + condAmount + "\u5143" + this.processPmDisDesc(finalCondition) + ",\u8fd8\u5dee" + needAmount + "\u5143";
        return disDesc;
    }

    private String processPmDisDesc(PmPromotionCondition finalCondition) {
        String disDesc = "";
        if (finalCondition.getCondResultAmountType() == PromotionConstants.CONDITION_RESULTAMOUNT_TYPE_0) {
            DecimalFormat df2 = new DecimalFormat("#.00");
            BigDecimal condResultAmount = new BigDecimal(df2.format(finalCondition.getCondResultAmount()));
            disDesc = disDesc + "\u51cf" + condResultAmount + "\u5143";
        } else if (finalCondition.getCondResultAmountType() == PromotionConstants.CONDITION_RESULTAMOUNT_TYPE_1) {
            BigDecimal zhe = finalCondition.getCondResultAmount().divide(new BigDecimal(10));
            disDesc = disDesc + "\u6253" + zhe.stripTrailingZeros().toPlainString() + "\u6298";
        }
        return disDesc;
    }

    private String showPmDisDescForType1(PmPromotionCondition finalCondition, BigDecimal selectedPromotionAllBuyAmount, Map<String, String> map1) {
        BigDecimal needAmount = finalCondition.getCondAmount().subtract(selectedPromotionAllBuyAmount);
        needAmount = new BigDecimal(needAmount.intValue());
        BigDecimal condAmount = new BigDecimal(finalCondition.getCondAmount().intValue());
        map1.put("disAmonut", "-" + needAmount);
        String disDesc = "\u8d2d\u6ee1" + condAmount + "\u4ef6" + this.processPmDisDesc(finalCondition) + ",\u8fd8\u5dee" + needAmount + "\u4ef6";
        return disDesc;
    }

    @Override
    public PmInfoBean checkPm(List<PmCalcDomain> pmCalcDomainList, List<OcContractSettlDomain> ocContractSettlDomainList) {
        PmInfoBean pmInfoBean = new PmInfoBean();
        pmInfoBean.setFlag("true");
        if (null == pmCalcDomainList || pmCalcDomainList.size() == 0) {
            pmInfoBean.setFlag("error");
            pmInfoBean.setMsg("\u6ca1\u6709sku\u4fe1\u606f");
            return pmInfoBean;
        }
        if (null == ocContractSettlDomainList || ocContractSettlDomainList.size() == 0) {
            pmInfoBean.setMsg("\u6ca1\u6709\u8425\u9500\u4fe1\u606f");
            ArrayList<PmContractGoodsDomain> pmContractGoodsDomainList = new ArrayList<PmContractGoodsDomain>();
            for (PmCalcDomain pmCalcDomain : pmCalcDomainList) {
                pmContractGoodsDomainList.addAll(pmCalcDomain.getPmContractGoodsDomainList());
            }
            pmInfoBean.setPmContractGoodsDomainList(pmContractGoodsDomainList);
            return pmInfoBean;
        }
        BigDecimal pmSettlBlance = BigDecimal.ZERO;
        BigDecimal copSettlBlance = BigDecimal.ZERO;
        for (OcContractSettlDomain ocContractSettlDomain : ocContractSettlDomainList) {
            if (ocContractSettlDomain.getContractSettlBlance().equals("PM")) {
                pmSettlBlance = pmSettlBlance.add(ocContractSettlDomain.getContractSettlPmoney());
                continue;
            }
            if (!ocContractSettlDomain.getContractSettlBlance().equals("COP")) continue;
            copSettlBlance = copSettlBlance.add(ocContractSettlDomain.getContractSettlPmoney());
        }
        Map<String, Object> pmMap = this.calcPm(pmCalcDomainList);
        BigDecimal pmDiscount = (BigDecimal)pmMap.get("discountAmount");
        Map<String, Object> couponMap = this.calcCoupon(pmCalcDomainList, ocContractSettlDomainList);
        BigDecimal couponDiscount = (BigDecimal)couponMap.get("discountAmount");
        if (pmSettlBlance.compareTo(pmDiscount) != 0) {
            pmInfoBean.setFlag("error");
            pmInfoBean.setMsg("\u6d3b\u52a8\u8425\u9500\u6570\u636e\u51fa\u9519 " + pmSettlBlance + " == " + pmDiscount);
            return pmInfoBean;
        }
        if (copSettlBlance.compareTo(couponDiscount) != 0) {
            pmInfoBean.setFlag("error");
            pmInfoBean.setMsg("\u4f18\u60e0\u5238\u6570\u636e\u51fa\u9519 " + copSettlBlance + "== " + couponDiscount);
            return pmInfoBean;
        }
        List pmContractGoodsDomainList = (List)couponMap.get("pmContractGoodsDomainListAll");
        pmInfoBean.setPmContractGoodsDomainList(pmContractGoodsDomainList);
        pmInfoBean.setPmMap(pmMap);
        return pmInfoBean;
    }

    @Override
    public Map<String, Object> checkPromotionUserOrder(String contractBillCode, String tenantCode, String userorderCode) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        PmUserOrder pmUserOrder = this.pmUserOrderService.getUserOrderByCode(tenantCode, userorderCode);
        BigDecimal discountAmount = new BigDecimal(0);
        if (null != pmUserOrder) {
            discountAmount = pmUserOrder.getDiscountAmount();
        }
        resultMap.put("discountAmount", discountAmount);
        return resultMap;
    }

    @Override
    public Map<String, Object> promotionByFinishOrder(String contractBillCode, String tenantCode, String userCode) {
        QueryResult<PmUserOrder> userOrderQueryResult = this.pmUserOrderService.queryUserOrderPage(this.getQueryParamMap("contractBillcode,userCode,tenantCode", new Object[]{contractBillCode, userCode, tenantCode}));
        if (null != userOrderQueryResult && null != userOrderQueryResult.getList()) {
            PmUserOrder pmUserOrder = (PmUserOrder)userOrderQueryResult.getList().get(0);
            PmPromotion pmPromotion = this.getPromotionByCodeWithoutRelatatedData(tenantCode, pmUserOrder.getPromotionCode());
            if (null != pmPromotion && pmPromotion.getDataState() != PromotionConstants.DATA_STATE_1) {
                return null;
            }
            if (pmPromotion.getPbCode().equals("0001")) {
                // empty if block
            }
            this.pmUserOrderService.updateUserOrderStateByCode(pmUserOrder.getTenantCode(), pmUserOrder.getUserorderCode(), PromotionConstants.USERORDER_DATA_STATE_1, PromotionConstants.USERORDER_DATA_STATE_0);
        }
        return null;
    }

    private RsResourceGoods getRsourcesGoods(String goodsCode, String tenantCode) {
        HashMap<String, String> pmap = new HashMap<String, String>();
        pmap.put("map", JsonUtil.buildNormalBinder().toJson((Object)this.getQueryMapParam("goodsCode,tenantCode", new Object[]{goodsCode, tenantCode})));
        Object goodsObj = this.getInternalRouter().inInvoke("rs.resourceGoods.getResourceGoodsByCode", pmap);
        if (null != goodsObj) {
            return (RsResourceGoods)JsonUtil.buildNormalBinder().getJsonToObject(goodsObj.toString(), RsResourceGoods.class);
        }
        return null;
    }

    private RsSku getRsSku(String skuCode, String tenantCode) {
        HashMap<String, String> pmap = new HashMap<String, String>();
        pmap.put("map", JsonUtil.buildNormalBinder().toJson((Object)this.getQueryParamMap("skuCode,tenantCode", new Object[]{skuCode, tenantCode})));
        Object obj = this.getInternalRouter().inInvoke("rs.sku.getSkuByCode", pmap);
        if (null != obj) {
            return (RsSku)JsonUtil.buildNormalBinder().getJsonToObject(obj.toString(), RsSku.class);
        }
        return null;
    }

    private boolean checkPromotionRangeBySkuCode(PmPromotionIn pmPromotion, String skuCode, String tenantCode, Integer rangeType, OcShoppingGoodsDomain ocShoppingGoodsDomain) {
        if (StringUtils.isBlank((String)pmPromotion.getRangeCode())) {
            return true;
        }
        if (null == ocShoppingGoodsDomain && null == (ocShoppingGoodsDomain = this.getGoodsDomain(skuCode, tenantCode))) {
            return false;
        }
        String rangeCode = "";
        if (rangeType.equals(PromotionConstants.RANGE_TYPE_2)) {
            rangeCode = ocShoppingGoodsDomain.getPntreeCode();
        } else if (rangeType.equals(PromotionConstants.RANGE_TYPE_3)) {
            rangeCode = ocShoppingGoodsDomain.getBrandCode();
        } else if (rangeType.equals(PromotionConstants.RANGE_TYPE_4)) {
            rangeCode = ocShoppingGoodsDomain.getClasstreeCode();
        } else if (rangeType.equals(PromotionConstants.RANGE_TYPE_5)) {
            rangeCode = skuCode;
        }
        if (StringUtils.isBlank((String)rangeCode)) {
            return false;
        }
        return StringUtils.isNotBlank((String)rangeCode) || pmPromotion.getRangeCode().indexOf(rangeCode + ",") >= 0;
    }

    private OcShoppingGoodsDomain getGoodsDomain(String skuCode, String tenantCode) {
        RsSku rsSku = this.getRsSku(skuCode, tenantCode);
        if (null == rsSku) {
            return null;
        }
        RsResourceGoods rsResourceGoods = this.getRsourcesGoods(rsSku.getGoodsCode(), tenantCode);
        if (null == rsResourceGoods) {
            return null;
        }
        OcShoppingGoodsDomain ocShoppingGoodsDomain = new OcShoppingGoodsDomain();
        try {
            BeanUtils.copyAllPropertys((Object)ocShoppingGoodsDomain, (Object)rsResourceGoods);
            BeanUtils.copyAllPropertys((Object)ocShoppingGoodsDomain, (Object)rsSku);
        }
        catch (Exception e) {
            return null;
        }
        return ocShoppingGoodsDomain;
    }

    private PmPromotion getPromotionByCodeWithoutRelatatedData(String tenantCode, String promotionCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("promotionCode", promotionCode);
        PmPromotion pmPromotion = this.getPromotionModelByCode(map);
        return pmPromotion;
    }

    public PmPromotion getPromotionByIdWithoutRelatatedData(Integer promotionId) throws ApiException {
        PmPromotion pmPromotion = this.getPromotionModelById(promotionId);
        return pmPromotion;
    }

    @Override
    public PmPromotion getPromotionByCode(String tenantCode, String promotionCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("promotionCode", promotionCode);
        PmPromotion pmPromotion = this.getPromotionModelByCode(map);
        this.getPromotionReRelatedData(pmPromotion);
        return pmPromotion;
    }

    @Override
    public void deletePromotionByCode(String tenantCode, String promotionCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("promotionCode", promotionCode);
        this.delPromotionModelByCode(map);
    }

    @Override
    public void loadPromotionState() {
        Map param = this.getQueryMapParam("dataState", new Object[]{PromotionConstants.DATA_STATE_0});
        QueryResult<PmPromotion> queryResult = this.queryPromotionPage(param);
        List pmPromotionList = queryResult.getList();
        if (null != pmPromotionList && !pmPromotionList.isEmpty()) {
            for (PmPromotion pmPromotion : pmPromotionList) {
                this.getBatchCouponService().addPutPool(new BatchCouponPutThread(this.getBatchCouponService(), pmPromotion));
            }
        }
        param = this.getQueryMapParam("dataState", new Object[]{PromotionConstants.DATA_STATE_1});
        queryResult = this.queryPromotionPage(param);
        if (null != pmPromotionList && !pmPromotionList.isEmpty()) {
            for (PmPromotion pmPromotion : pmPromotionList) {
                this.getBatchCouponService().addPutPool(new BatchCouponPutThread(this.getBatchCouponService(), pmPromotion));
            }
        }
    }

    @Override
    public Map<String, Object> getPromotionGoods(Map<String, Object> map) {
        String promotionCode;
        HashMap<String, Object> result = new HashMap<String, Object>();
        ArrayList skuList = new ArrayList();
        ArrayList<RsSku> giftGoodsList = new ArrayList<RsSku>();
        String tenantCode = map.get("tenantCode").toString();
        PmPromotion pmPromotion = this.getPromotionByCodeWithoutRelatatedData(tenantCode, promotionCode = map.get("promotionCode").toString());
        if (null != pmPromotion) {
            QueryResult<PmPromotionDiscountlist> discountlistQueryResult;
            PmPromotionDiscount pmPromotionDiscount;
            QueryResult<PmPromotionDiscount> discountQueryResult;
            List rsSkuList;
            Integer rangeType = pmPromotion.getRangeType();
            HashMap<String, Object> goodsMap = new HashMap<String, Object>();
            String page = map.get("page").toString();
            String rows = map.get("rows").toString();
            goodsMap.put("page", Long.valueOf(page).intValue());
            goodsMap.put("rows", Long.valueOf(rows).intValue());
            goodsMap.put("startRow", Long.valueOf(Long.valueOf(rows).intValue() * (Long.valueOf(page).intValue() - 1)).intValue());
            goodsMap.put("endRow", Long.valueOf(Long.valueOf(rows).intValue() * Long.valueOf(page).intValue()).intValue());
            goodsMap.put("order", true);
            goodsMap.put("fuzzy", true);
            goodsMap.put("tenantCode", tenantCode);
            ArrayList<String> rangeCodeList = new ArrayList<String>();
            if (!rangeType.equals(PromotionConstants.RANGE_TYPE_0)) {
                QueryResult<PmPromotionRangelist> rangelistQueryResult = this.pmPromotionRangelistService.queryPromotionRangelistPage(this.getQueryMapParam("promotionCode,tenantCode", new Object[]{promotionCode, tenantCode}));
                if (null != rangelistQueryResult && null != rangelistQueryResult.getList() && rangelistQueryResult.getList().size() > 0) {
                    for (PmPromotionRangelist pmPromotionRangelist : rangelistQueryResult.getList()) {
                        rangeCodeList.add(pmPromotionRangelist.getRangeCode());
                    }
                }
                if (rangeCodeList.size() > 0) {
                    if (rangeType.equals(PromotionConstants.RANGE_TYPE_1)) {
                        goodsMap.put("memberCode", rangeCodeList);
                    } else if (rangeType.equals(PromotionConstants.RANGE_TYPE_2)) {
                        goodsMap.put("pntreeCode", rangeCodeList);
                    } else if (rangeType.equals(PromotionConstants.RANGE_TYPE_3)) {
                        goodsMap.put("brandCode", rangeCodeList);
                    } else if (rangeType.equals(PromotionConstants.RANGE_TYPE_4)) {
                        goodsMap.put("classtreeCode", rangeCodeList);
                    } else if (rangeType.equals(PromotionConstants.RANGE_TYPE_5)) {
                        goodsMap.put("skuCode", rangeCodeList);
                    }
                }
            }
            HashMap<String, String> pmap = new HashMap<String, String>();
            pmap.put("map", JsonUtil.buildNormalBinder().toJson(goodsMap));
            Object obj = this.getInternalRouter().inInvoke("rs.sku.querySkuByPntreeCode", pmap);
            if (null != obj && null != (rsSkuList = (List)JsonUtil.buildNormalBinder().getJsonToList(obj.toString(), RsSku.class)) && rsSkuList.size() > 0) {
                for (RsSku rsSku : rsSkuList) {
                    RsResourceGoods rsResourceGoods = this.getRsourcesGoods(rsSku.getGoodsCode(), rsSku.getTenantCode());
                    if (null == rsResourceGoods) continue;
                    rsSku.setGoodsName(rsResourceGoods.getGoodsName());
                }
                skuList.addAll(rsSkuList);
            }
            if ("0001".equals(pmPromotion.getPbCode()) && null != (discountQueryResult = this.pmPromotionDiscountService.queryPromotionDiscountPage(this.getQueryParamMap("promotionCode,tenantCode", new Object[]{promotionCode, tenantCode}))) && null != discountQueryResult.getList() && (pmPromotionDiscount = (PmPromotionDiscount)discountQueryResult.getList().get(0)).getDiscType() == PromotionConstants.DISCOUNT_TYPE_5 && null != (discountlistQueryResult = this.pmPromotionDiscountlistService.queryPromotionDiscountlistPage(this.getQueryParamMap("ppdCode,tenantCode", new Object[]{pmPromotionDiscount.getPpdCode(), tenantCode}))) && null != discountlistQueryResult.getList()) {
                List promotionDiscountlists = discountlistQueryResult.getList();
                for (PmPromotionDiscountlist pmPromotionDiscountlist : promotionDiscountlists) {
                    RsSku rsSku = this.getRsSku(pmPromotionDiscountlist.getDiscountCode(), pmPromotionDiscountlist.getTenantCode());
                    if (null == rsSku) continue;
                    RsResourceGoods rsResourceGoods = this.getRsourcesGoods(rsSku.getGoodsCode(), pmPromotionDiscountlist.getTenantCode());
                    if (null != rsResourceGoods) {
                        rsSku.setGoodsName(rsResourceGoods.getGoodsName());
                    }
                    giftGoodsList.add(rsSku);
                }
            }
        }
        result.put("promotion", pmPromotion);
        result.put("skuList", skuList);
        result.put("giftGoods", giftGoodsList);
        return result;
    }

    @Override
    public void loadPromotionIn() {
        QueryResult<PmPromotionIn> qpmlist = this.pmPromotionInService.queryPromotionInPage(null);
        if (null == qpmlist || ListUtil.isEmpty((Collection)qpmlist.getList())) {
            DisUtil.delMap((String)"pm-promotion_condition", (String[])new String[0]);
            DisUtil.delMap((String)"pm-promotion_discount", (String[])new String[0]);
            DisUtil.delMap((String)"pm-promotion_discountlist", (String[])new String[0]);
            DisUtil.delMap((String)"pm-promotion_rangelist", (String[])new String[0]);
            DisUtil.delMap((String)"pm-promotion_targetlist", (String[])new String[0]);
            DisUtil.delMap((String)"pm-promotion_terminal", (String[])new String[0]);
            DisUtil.delMap((String)"pm-promotion", (String[])new String[0]);
            DisUtil.delMap((String)"pm-promotionin", (String[])new String[0]);
            return;
        }
        String cacheKey = "";
        for (PmPromotionIn pmPromotionIn : qpmlist.getList()) {
            QueryResult<PmPromotionTerminal> qterminalList;
            QueryResult<PmPromotionTargetlist> qtargetList;
            QueryResult<PmPromotionDiscount> qdiscontList;
            cacheKey = pmPromotionIn.getPromotionCode() + "-" + pmPromotionIn.getTenantCode();
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("tenantCode", pmPromotionIn.getTenantCode());
            map.put("promotionCode", pmPromotionIn.getPromotionCode());
            QueryResult<PmPromotionCondition> qconditionList = this.pmPromotionConditionService.queryPromotionConditionPage(map);
            if (null != qconditionList && ListUtil.isNotEmpty((Collection)qconditionList.getList())) {
                DisUtil.setMapVer((String)"pm-promotion_condition", (String)cacheKey, (String)JsonUtil.buildNormalBinder().toJson((Object)qconditionList.getList()));
            }
            if (null != (qdiscontList = this.pmPromotionDiscountService.queryPromotionDiscountPage(map)) && ListUtil.isNotEmpty((Collection)qdiscontList.getList())) {
                DisUtil.setMapVer((String)"pm-promotion_discount", (String)cacheKey, (String)JsonUtil.buildNormalBinder().toJson((Object)qdiscontList.getList()));
                QueryResult<PmPromotionDiscountlist> qlist = this.pmPromotionDiscountlistService.queryPromotionDiscountlistPage(map);
                if (null != qlist && ListUtil.isNotEmpty((Collection)qlist.getList())) {
                    String cke = "";
                    for (PmPromotionDiscountlist pmPromotionDiscountlist : qlist.getList()) {
                        cke = cacheKey + "-" + pmPromotionDiscountlist.getPpdCode();
                        String cstr = DisUtil.getMap((String)"pm-promotion_discountlist", (String)cke);
                        List<PmPromotionDiscountlist> alist = StringUtils.isNotBlank((String)cstr) ? (List)JsonUtil.buildNormalBinder().getJsonToList(cstr, PmPromotionDiscountlist.class) : new ArrayList<PmPromotionDiscountlist>();
                        alist.add(pmPromotionDiscountlist);
                        DisUtil.setMapVer((String)"pm-promotion_discountlist", (String)cke, (String)JsonUtil.buildNormalBinder().toJson(alist));
                    }
                }
            }
            QueryResult<PmPromotionRangelist> qrangeList = this.pmPromotionRangelistService.queryPromotionRangelistPage(map);
            if (null != qdiscontList && ListUtil.isNotEmpty((Collection)qrangeList.getList())) {
                String rangeCodeStr = "";
                for (PmPromotionRangelist pmPromotionRangelist : qrangeList.getList()) {
                    if (StringUtils.isNotBlank((String)rangeCodeStr)) {
                        rangeCodeStr = rangeCodeStr + ",";
                    }
                    rangeCodeStr = rangeCodeStr + pmPromotionRangelist.getRangeCode();
                }
                pmPromotionIn.setRangeCode(rangeCodeStr);
                DisUtil.setMapVer((String)"pm-promotion_rangelist", (String)cacheKey, (String)JsonUtil.buildNormalBinder().toJson((Object)qrangeList.getList()));
            }
            if (null != (qtargetList = this.pmPromotionTargetlistService.queryPromotionTargetlistPage(map)) && ListUtil.isNotEmpty((Collection)qtargetList.getList())) {
                String targetStr = "";
                for (PmPromotionTargetlist pmPromotionTargetlist : qtargetList.getList()) {
                    if (StringUtils.isNotBlank((String)targetStr)) {
                        targetStr = targetStr + ",";
                    }
                    targetStr = targetStr + pmPromotionTargetlist.getTargetCode();
                }
                pmPromotionIn.setTargetCode(targetStr);
                DisUtil.setMapVer((String)"pm-promotion_targetlist", (String)cacheKey, (String)JsonUtil.buildNormalBinder().toJson((Object)qtargetList.getList()));
            }
            if (null != (qterminalList = this.pmPromotionTerminalService.queryPromotionTerminalPage(map)) && ListUtil.isNotEmpty((Collection)qterminalList.getList())) {
                String terminalTypeStr = "";
                for (PmPromotionTerminal pmPromotionTerminal : qterminalList.getList()) {
                    if (StringUtils.isNotBlank((String)terminalTypeStr)) {
                        terminalTypeStr = terminalTypeStr + ",";
                    }
                    terminalTypeStr = terminalTypeStr + pmPromotionTerminal.getTerminalType();
                }
                pmPromotionIn.setTerminalType(terminalTypeStr);
                DisUtil.setMapVer((String)"pm-promotion_terminal", (String)cacheKey, (String)JsonUtil.buildNormalBinder().toJson((Object)qterminalList.getList()));
            }
            String listStr = DisUtil.getMap((String)"pm-promotionin", (String)pmPromotionIn.getTenantCode());
            ArrayList<PmPromotionIn> inList = null;
            if (StringUtils.isNotBlank((String)listStr)) {
                inList = (ArrayList<PmPromotionIn>)JsonUtil.buildNormalBinder().getJsonToList(listStr, PmPromotionIn.class);
            }
            if (null == inList) {
                inList = new ArrayList<PmPromotionIn>();
            }
            inList.add(pmPromotionIn);
            Collections.sort(inList, new Comparator<PmPromotionIn>(){

                @Override
                public int compare(PmPromotionIn arg0, PmPromotionIn arg1) {
                    if (arg0.getPriority() > arg1.getPriority()) {
                        return 1;
                    }
                    if (arg0.getPriority() < arg1.getPriority()) {
                        return -1;
                    }
                    return arg0.getPriority().compareTo(arg0.getPriority());
                }
            });
            DisUtil.setMapVer((String)"pm-promotionin", (String)pmPromotionIn.getTenantCode(), (String)JsonUtil.buildNormalBinder().toJson(inList));
            DisUtil.setMapVer((String)"pm-promotion", (String)cacheKey, (String)JsonUtil.buildNormalBinder().toJson((Object)pmPromotionIn));
        }
    }

    static {
        lock = new Object();
    }
}

