/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.pm.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.pm.PromotionConstants;
import com.yqbsoft.laser.service.pm.dao.PmUserCouponMapper;
import com.yqbsoft.laser.service.pm.domain.OrderCallBackBean;
import com.yqbsoft.laser.service.pm.domain.PmUserCouponDomain;
import com.yqbsoft.laser.service.pm.domain.PmUserCouponReDomain;
import com.yqbsoft.laser.service.pm.domain.PmUserCouponlistDomain;
import com.yqbsoft.laser.service.pm.model.PmPromotion;
import com.yqbsoft.laser.service.pm.model.PmPromotionCoupon;
import com.yqbsoft.laser.service.pm.model.PmUserCoupon;
import com.yqbsoft.laser.service.pm.service.PmPromotionCouponService;
import com.yqbsoft.laser.service.pm.service.PmPromotionService;
import com.yqbsoft.laser.service.pm.service.PmUserCouponService;
import com.yqbsoft.laser.service.pm.service.PmUserCouponlistService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PmUserCouponServiceImpl
extends BaseServiceImpl
implements PmUserCouponService {
    private static final String SYS_CODE = "pm.PROMOTION.PmUserCouponServiceImpl";
    private PmUserCouponMapper pmUserCouponMapper;
    private PmUserCouponlistService pmUserCouponlistService;
    private PmPromotionService pmPromotionService;
    private PmPromotionCouponService pmPromotionCouponService;

    public void setPmPromotionService(PmPromotionService pmPromotionService) {
        this.pmPromotionService = pmPromotionService;
    }

    public void setPmUserCouponlistService(PmUserCouponlistService pmUserCouponlistService) {
        this.pmUserCouponlistService = pmUserCouponlistService;
    }

    public void setPmUserCouponMapper(PmUserCouponMapper pmUserCouponMapper) {
        this.pmUserCouponMapper = pmUserCouponMapper;
    }

    public void setPmPromotionCouponService(PmPromotionCouponService pmPromotionCouponService) {
        this.pmPromotionCouponService = pmPromotionCouponService;
    }

    private Date getSysDate() {
        try {
            return this.pmUserCouponMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmUserCouponServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkUserCoupon(PmUserCouponDomain pmUserCouponDomain) {
        if (null == pmUserCouponDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)pmUserCouponDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setUserCouponDefault(PmUserCoupon pmUserCoupon) {
        if (null == pmUserCoupon) {
            return;
        }
        if (null == pmUserCoupon.getDataState()) {
            pmUserCoupon.setDataState(0);
        }
        if (null == pmUserCoupon.getGmtCreate()) {
            pmUserCoupon.setGmtCreate(this.getSysDate());
        }
        pmUserCoupon.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)pmUserCoupon.getUsercouponCode())) {
            pmUserCoupon.setUsercouponCode(this.createUUIDString());
        }
    }

    private int getUserCouponMaxCode() {
        int code = 0;
        try {
            return this.pmUserCouponMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmUserCouponServiceImpl.getUserCouponMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setUserCouponUpdataDefault(PmUserCoupon pmUserCoupon) {
        if (null == pmUserCoupon) {
            return;
        }
        pmUserCoupon.setGmtModified(this.getSysDate());
    }

    private void saveUserCouponModel(PmUserCoupon pmUserCoupon) throws ApiException {
        if (null == pmUserCoupon) {
            return;
        }
        try {
            this.pmUserCouponMapper.insert(pmUserCoupon);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmUserCouponServiceImpl.saveUserCouponModel.ex", (Throwable)e);
        }
    }

    private void saveUserCouponBatchModel(List<PmUserCoupon> pmUserCouponList) throws ApiException {
        if (null == pmUserCouponList || pmUserCouponList.isEmpty()) {
            return;
        }
        try {
            this.pmUserCouponMapper.insertBatch(pmUserCouponList);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmUserCouponServiceImpl.saveUserCouponBatchModel.ex", (Throwable)e);
        }
    }

    private PmUserCoupon getUserCouponModelById(Integer usercouponId) {
        if (null == usercouponId) {
            return null;
        }
        try {
            return this.pmUserCouponMapper.selectByPrimaryKey(usercouponId);
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmUserCouponServiceImpl.getUserCouponModelById", (Throwable)e);
            return null;
        }
    }

    private PmUserCoupon getUserCouponModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.pmUserCouponMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmUserCouponServiceImpl.getUserCouponModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delUserCouponModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.pmUserCouponMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmUserCouponServiceImpl.delUserCouponModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pm.PROMOTION.PmUserCouponServiceImpl.delUserCouponModelByCode.num");
        }
    }

    private void deleteUserCouponModel(Integer usercouponId) throws ApiException {
        if (null == usercouponId) {
            return;
        }
        int i = 0;
        try {
            i = this.pmUserCouponMapper.deleteByPrimaryKey(usercouponId);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmUserCouponServiceImpl.deleteUserCouponModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pm.PROMOTION.PmUserCouponServiceImpl.deleteUserCouponModel.num");
        }
    }

    private void updateUserCouponModel(PmUserCoupon pmUserCoupon) throws ApiException {
        if (null == pmUserCoupon) {
            return;
        }
        int i = 0;
        try {
            i = this.pmUserCouponMapper.updateByPrimaryKeySelective(pmUserCoupon);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmUserCouponServiceImpl.updateUserCouponModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pm.PROMOTION.PmUserCouponServiceImpl.updateUserCouponModel.num");
        }
    }

    private void updateStateUserCouponModel(Integer usercouponId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == usercouponId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("usercouponId", usercouponId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.pmUserCouponMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmUserCouponServiceImpl.updateStateUserCouponModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pm.PROMOTION.PmUserCouponServiceImpl.updateStateUserCouponModel.null");
        }
    }

    private void updateStateUserCouponModelByCode(String tenantCode, String usercouponCode, Integer dataState, Integer oldDataState) throws ApiException {
        if (StringUtils.isBlank((String)usercouponCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("usercouponCode", usercouponCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.pmUserCouponMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmUserCouponServiceImpl.updateStateUserCouponModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pm.PROMOTION.PmUserCouponServiceImpl.updateStateUserCouponModelByCode.null");
        }
    }

    private PmUserCoupon makeUserCoupon(PmUserCouponDomain pmUserCouponDomain, PmUserCoupon pmUserCoupon) {
        if (null == pmUserCouponDomain) {
            return null;
        }
        if (null == pmUserCoupon) {
            pmUserCoupon = new PmUserCoupon();
        }
        try {
            BeanUtils.copyAllPropertys((Object)pmUserCoupon, (Object)pmUserCouponDomain);
            return pmUserCoupon;
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmUserCouponServiceImpl.makeUserCoupon", (Throwable)e);
            return null;
        }
    }

    private PmUserCouponReDomain makePmUserCouponReDomain(PmUserCoupon pmUserCoupon) {
        if (null == pmUserCoupon) {
            return null;
        }
        PmUserCouponReDomain pmUserCouponReDomain = new PmUserCouponReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)pmUserCouponReDomain, (Object)pmUserCoupon);
            return pmUserCouponReDomain;
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmUserCouponServiceImpl.makePmUserCouponReDomain", (Throwable)e);
            return null;
        }
    }

    private List<PmUserCoupon> queryUserCouponModelPage(Map<String, Object> parammap) {
        try {
            return this.pmUserCouponMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmUserCouponServiceImpl.queryUserCouponModel", (Throwable)e);
            return null;
        }
    }

    private int countUserCoupon(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.pmUserCouponMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmUserCouponServiceImpl.countUserCoupon", (Throwable)e);
        }
        return i;
    }

    private PmUserCoupon createPmUserCoupon(PmUserCouponDomain pmUserCouponDomain) {
        String msg = this.checkUserCoupon(pmUserCouponDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pm.PROMOTION.PmUserCouponServiceImpl.saveUserCoupon.checkUserCoupon", msg);
        }
        PmUserCoupon pmUserCoupon = this.makeUserCoupon(pmUserCouponDomain, null);
        this.setUserCouponDefault(pmUserCoupon);
        return pmUserCoupon;
    }

    @Override
    public String saveUserCoupon(PmUserCouponDomain pmUserCouponDomain) throws ApiException {
        Integer promotionFrequency;
        if (null == pmUserCouponDomain) {
            return null;
        }
        String pmstr = DisUtil.getMap((String)"pm-promotion", (String)(pmUserCouponDomain.getPromotionCode() + "-" + pmUserCouponDomain.getTenantCode()));
        if (StringUtils.isBlank((String)pmstr)) {
            throw new ApiException("pm.PROMOTION.PmUserCouponServiceImpl.saveUserCoupon.pmstr", "\u5df2\u53d1\u653e\u5b8c");
        }
        PmPromotion pmPromotion = (PmPromotion)JsonUtil.buildNormalBinder().getJsonToObject(pmstr, PmPromotion.class);
        if (null == pmPromotion) {
            throw new ApiException("pm.PROMOTION.PmUserCouponServiceImpl.saveUserCoupon.pmPromotion", "\u5df2\u53d1\u653e\u5b8c");
        }
        long nowTime = new Date().getTime();
        if (null != pmPromotion.getReceiveStart() && nowTime < pmPromotion.getReceiveStart().getTime()) {
            throw new ApiException("pm.PROMOTION.PmUserCouponServiceImpl.saveUserCoupon.ReceiveStart", "\u9886\u53d6\u4f18\u60e0\u5238\u672a\u5f00\u59cb");
        }
        if (null != pmPromotion.getReceiveEnd() && nowTime > pmPromotion.getReceiveEnd().getTime()) {
            throw new ApiException("pm.PROMOTION.PmUserCouponServiceImpl.saveUserCoupon.ReceiveEnd", "\u9886\u53d6\u4f18\u60e0\u5238\u5df2\u7ecf\u7ed3\u675f");
        }
        pmUserCouponDomain.setPbCode(pmPromotion.getPbCode());
        pmUserCouponDomain.setPromotionCode(pmPromotion.getPromotionCode());
        pmUserCouponDomain.setPromotionName(pmPromotion.getPromotionName());
        pmUserCouponDomain.setCouponBatch(pmPromotion.getCouponBatch());
        pmUserCouponDomain.setPbCode(pmPromotion.getPbCode());
        pmUserCouponDomain.setMemberCode(pmPromotion.getMemberCode());
        pmUserCouponDomain.setMemberName(pmPromotion.getMemberName());
        pmUserCouponDomain.setCouponStart(pmPromotion.getPromotionBegintime());
        pmUserCouponDomain.setCouponEnd(pmPromotion.getPromotionEndtime());
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("promotionCode", pmUserCouponDomain.getPromotionCode());
        map.put("tenantCode", pmUserCouponDomain.getTenantCode());
        map.put("dataState", 0);
        map.put("startRow", 0);
        map.put("rows", 1);
        QueryResult<PmPromotionCoupon> pmPromotionCouponQueryResult = this.pmPromotionCouponService.queryPromotionCouponPage(map);
        PmPromotionCoupon pmPromotionCoupon = null;
        if (null != pmPromotionCouponQueryResult && null != pmPromotionCouponQueryResult.getList() && pmPromotionCouponQueryResult.getList().size() > 0) {
            pmPromotionCoupon = (PmPromotionCoupon)pmPromotionCouponQueryResult.getList().get(0);
        }
        if (null == pmPromotionCoupon) {
            throw new ApiException("pm.PROMOTION.PmUserCouponServiceImpl.saveUserCoupon.pmPromotionCoupon", "\u5df2\u53d1\u653e\u5b8c");
        }
        HashMap<String, Object> param1 = new HashMap<String, Object>();
        param1.put("memberBcode", pmUserCouponDomain.getMemberBcode());
        param1.put("promotionCode", pmUserCouponDomain.getPromotionCode());
        param1.put("tenantCode", pmUserCouponDomain.getTenantCode());
        Integer res1 = this.getCount(param1);
        if (res1 > 0 && null != (promotionFrequency = pmPromotion.getPromotionFrequency()) && 0 != promotionFrequency && 0 != res1 && res1 >= promotionFrequency) {
            throw new ApiException("pm.PROMOTION.PmUserCouponServiceImpl.saveUserCoupon.pmPromotionCoupon", "\u5df2\u5230\u9886\u53d6\u4e0a\u9650");
        }
        this.pmPromotionCouponService.updatePromotionCouponState(pmPromotionCoupon.getPromotioncouponId(), 1, 0);
        PmUserCoupon pmUserCoupon = this.createPmUserCoupon(pmUserCouponDomain);
        if (null == pmUserCoupon) {
            throw new ApiException("pm.PROMOTION.PmUserCouponServiceImpl.saveUserCoupon.pmUserCoupon");
        }
        pmUserCoupon.setCouponNo(pmPromotionCoupon.getCouponNo());
        this.saveUserCouponModel(pmUserCoupon);
        PmUserCouponlistDomain pmUserCouponlistDomain = new PmUserCouponlistDomain();
        try {
            BeanUtils.copyAllPropertys((Object)pmUserCouponlistDomain, (Object)pmUserCoupon);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmUserCouponServiceImpl.saveUserCoupon.e", (Throwable)e);
        }
        this.pmUserCouponlistService.saveUserCouponlist(pmUserCouponlistDomain);
        return pmUserCoupon.getUsercouponCode();
    }

    @Override
    public String saveUserCouponBatch(List<PmUserCouponDomain> pmUserCouponDomainList) throws ApiException {
        if (null == pmUserCouponDomainList || pmUserCouponDomainList.isEmpty()) {
            return null;
        }
        ArrayList<PmUserCoupon> pmUserCouponList = new ArrayList<PmUserCoupon>();
        String code = "";
        for (PmUserCouponDomain pmUserCouponDomain : pmUserCouponDomainList) {
            PmUserCoupon pmUserCoupon = this.createPmUserCoupon(pmUserCouponDomain);
            code = pmUserCoupon.getUsercouponCode();
            pmUserCouponList.add(pmUserCoupon);
        }
        this.saveUserCouponBatchModel(pmUserCouponList);
        return code;
    }

    @Override
    public void updateUserCouponState(Integer usercouponId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateUserCouponModel(usercouponId, dataState, oldDataState);
    }

    @Override
    public void updateUserCouponStateByCode(String tenantCode, String usercouponCode, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateUserCouponModelByCode(tenantCode, usercouponCode, dataState, oldDataState);
    }

    @Override
    public void updateUserCoupon(PmUserCouponDomain pmUserCouponDomain) throws ApiException {
        String msg = this.checkUserCoupon(pmUserCouponDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pm.PROMOTION.PmUserCouponServiceImpl.updateUserCoupon.checkUserCoupon", msg);
        }
        PmUserCoupon oldPmUserCoupon = this.getUserCouponModelById(pmUserCouponDomain.getUsercouponId());
        if (null == oldPmUserCoupon) {
            throw new ApiException("pm.PROMOTION.PmUserCouponServiceImpl.updateUserCoupon.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        PmUserCoupon pmUserCoupon = this.makeUserCoupon(pmUserCouponDomain, oldPmUserCoupon);
        this.setUserCouponUpdataDefault(pmUserCoupon);
        this.updateUserCouponModel(pmUserCoupon);
    }

    @Override
    public PmUserCoupon getUserCoupon(Integer usercouponId) {
        return this.getUserCouponModelById(usercouponId);
    }

    @Override
    public void deleteUserCoupon(Integer usercouponId) throws ApiException {
        this.deleteUserCouponModel(usercouponId);
    }

    @Override
    public QueryResult<PmUserCoupon> queryUserCouponPage(Map<String, Object> map) {
        List<PmUserCoupon> pmUserCouponList = this.queryUserCouponModelPage(map);
        if (null != pmUserCouponList && pmUserCouponList.size() > 0) {
            for (PmUserCoupon pmUserCoupon : pmUserCouponList) {
                PmPromotion pmPromotion = this.pmPromotionService.getPromotionByCode(pmUserCoupon.getTenantCode(), pmUserCoupon.getPromotionCode());
                pmUserCoupon.setPmPromotion(pmPromotion);
            }
        }
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countUserCoupon(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(pmUserCouponList);
        return queryResult;
    }

    @Override
    public PmUserCoupon getUserCouponByCode(String tenantCode, String usercouponCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("usercouponCode", usercouponCode);
        return this.getUserCouponModelByCode(map);
    }

    @Override
    public void deleteUserCouponByCode(String tenantCode, String usercouponCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("usercouponCode", usercouponCode);
        this.delUserCouponModelByCode(map);
    }

    @Override
    public BigDecimal checkUseCoupon(String tenantCode, String couponNo, String memberBcode) throws ApiException {
        BigDecimal result = BigDecimal.ZERO;
        return result;
    }

    @Override
    public String updateUserCouponByOrderCallBack(List<OrderCallBackBean> orderCallBackBeanList) throws ApiException {
        if (null == orderCallBackBeanList || orderCallBackBeanList.size() == 0) {
            return "ERROR";
        }
        for (OrderCallBackBean orderCallBackBean : orderCallBackBeanList) {
            PmUserCoupon pmUserCoupon = this.getUserCouponByCode(orderCallBackBean.getTenantCode(), orderCallBackBean.getUsercouponCode());
            if (null == pmUserCoupon) continue;
            pmUserCoupon.setDataState(PromotionConstants.USERCOUPON_DATA_STATE_1);
            pmUserCoupon.setContractBillcode(orderCallBackBean.getContractBillcode());
            this.updateUserCouponModel(pmUserCoupon);
        }
        return "SUCCESS";
    }

    @Override
    public void updateUsercouponDataStateJob() {
        this.updateUsercouponDataState();
    }

    @Override
    public int getCount(Map<String, Object> map) {
        int res = this.countUserCoupon(map);
        return res;
    }

    private void updateUsercouponDataState() {
        try {
            this.pmUserCouponMapper.updateUsercouponDataState();
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmUserCouponServiceImpl.updateUsercouponDataState", (Throwable)e);
        }
    }
}

