/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.pm.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.spring.ApplicationContextUtil;
import com.yqbsoft.laser.service.esb.core.spring.SpringApplicationContextUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.pm.PromotionConstants;
import com.yqbsoft.laser.service.pm.batchcoupon.BatchCouponPollThread;
import com.yqbsoft.laser.service.pm.batchcoupon.BatchCouponPutThread;
import com.yqbsoft.laser.service.pm.batchcoupon.BatchCouponService;
import com.yqbsoft.laser.service.pm.dao.PmPromotionMapper;
import com.yqbsoft.laser.service.pm.domain.OcCflowReDomain;
import com.yqbsoft.laser.service.pm.domain.OcContractSettlDomain;
import com.yqbsoft.laser.service.pm.domain.PmCalcBean;
import com.yqbsoft.laser.service.pm.domain.PmCheckBean;
import com.yqbsoft.laser.service.pm.domain.PmContractGoodsDomain;
import com.yqbsoft.laser.service.pm.domain.PmGoodsBean;
import com.yqbsoft.laser.service.pm.domain.PmInfoBean;
import com.yqbsoft.laser.service.pm.domain.PmPromotionBaseDomain;
import com.yqbsoft.laser.service.pm.domain.PmPromotionConditionDomain;
import com.yqbsoft.laser.service.pm.domain.PmPromotionDisDomain;
import com.yqbsoft.laser.service.pm.domain.PmPromotionDiscountDomain;
import com.yqbsoft.laser.service.pm.domain.PmPromotionDomain;
import com.yqbsoft.laser.service.pm.domain.PmPromotionInDomain;
import com.yqbsoft.laser.service.pm.domain.PmPromotionMemDomain;
import com.yqbsoft.laser.service.pm.domain.PmPromotionRangelistDomain;
import com.yqbsoft.laser.service.pm.domain.PmPromotionReDomain;
import com.yqbsoft.laser.service.pm.domain.PmPromotionTargetlistDomain;
import com.yqbsoft.laser.service.pm.domain.PmPromotionTerminalDomain;
import com.yqbsoft.laser.service.pm.domain.SkuBean;
import com.yqbsoft.laser.service.pm.domain.TypeBean;
import com.yqbsoft.laser.service.pm.domain.ocshop.OcShoppingDomain;
import com.yqbsoft.laser.service.pm.domain.ocshop.OcShoppingGoodsDomain;
import com.yqbsoft.laser.service.pm.domain.ocshop.OcShoppingpackgeDomain;
import com.yqbsoft.laser.service.pm.domain.ocshop.PromotionForOcReDomain;
import com.yqbsoft.laser.service.pm.model.PmPromotion;
import com.yqbsoft.laser.service.pm.model.PmPromotionCondition;
import com.yqbsoft.laser.service.pm.model.PmPromotionDis;
import com.yqbsoft.laser.service.pm.model.PmPromotionDiscount;
import com.yqbsoft.laser.service.pm.model.PmPromotionDiscountlist;
import com.yqbsoft.laser.service.pm.model.PmPromotionIn;
import com.yqbsoft.laser.service.pm.model.PmPromotionMem;
import com.yqbsoft.laser.service.pm.model.PmPromotionRangelist;
import com.yqbsoft.laser.service.pm.model.PmPromotionTargetlist;
import com.yqbsoft.laser.service.pm.model.PmPromotionTerminal;
import com.yqbsoft.laser.service.pm.model.PmUserCoupon;
import com.yqbsoft.laser.service.pm.model.RsResourceGoods;
import com.yqbsoft.laser.service.pm.model.RsSku;
import com.yqbsoft.laser.service.pm.service.PmPromotionConditionService;
import com.yqbsoft.laser.service.pm.service.PmPromotionDisService;
import com.yqbsoft.laser.service.pm.service.PmPromotionDiscountService;
import com.yqbsoft.laser.service.pm.service.PmPromotionDiscountlistService;
import com.yqbsoft.laser.service.pm.service.PmPromotionInService;
import com.yqbsoft.laser.service.pm.service.PmPromotionMemService;
import com.yqbsoft.laser.service.pm.service.PmPromotionRangelistService;
import com.yqbsoft.laser.service.pm.service.PmPromotionService;
import com.yqbsoft.laser.service.pm.service.PmPromotionTargetlistService;
import com.yqbsoft.laser.service.pm.service.PmPromotionTerminalService;
import com.yqbsoft.laser.service.pm.service.PmUserCouponService;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.DateUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.ibatis.annotations.Delete;

public class PmPromotionServiceImpl
extends BaseServiceImpl
implements PmPromotionService {
    private static final String SYS_CODE = "pm.PROMOTION.PmPromotionServiceImpl";
    private PmPromotionMapper pmPromotionMapper;
    private PmPromotionTargetlistService pmPromotionTargetlistService;
    private PmPromotionTerminalService pmPromotionTerminalService;
    private PmPromotionRangelistService pmPromotionRangelistService;
    private PmPromotionConditionService pmPromotionConditionService;
    private PmPromotionDiscountService pmPromotionDiscountService;
    private PmPromotionDiscountlistService pmPromotionDiscountlistService;
    private PmUserCouponService pmUserCouponService;
    private PmPromotionInService pmPromotionInService;
    private PmPromotionDisService pmPromotionDisService;
    private PmPromotionMemService pmPromotionMemService;
    private static BatchCouponService batchCouponService;
    private static Object lock;
    String CACHE_KEY_CFLOW = "ocProtCflow";

    public void setPmPromotionDisService(PmPromotionDisService pmPromotionDisService) {
        this.pmPromotionDisService = pmPromotionDisService;
    }

    public void setPmPromotionMemService(PmPromotionMemService pmPromotionMemService) {
        this.pmPromotionMemService = pmPromotionMemService;
    }

    public void setPmPromotionInService(PmPromotionInService pmPromotionInService) {
        this.pmPromotionInService = pmPromotionInService;
    }

    public PmUserCouponService getPmUserCouponService() {
        if (null == this.pmUserCouponService) {
            this.pmUserCouponService = (PmUserCouponService)ApplicationContextUtil.getService((String)"pmUserCouponService");
        }
        return this.pmUserCouponService;
    }

    public void setPmPromotionDiscountlistService(PmPromotionDiscountlistService pmPromotionDiscountlistService) {
        this.pmPromotionDiscountlistService = pmPromotionDiscountlistService;
    }

    public void setPmPromotionDiscountService(PmPromotionDiscountService pmPromotionDiscountService) {
        this.pmPromotionDiscountService = pmPromotionDiscountService;
    }

    public void setPmPromotionTerminalService(PmPromotionTerminalService pmPromotionTerminalService) {
        this.pmPromotionTerminalService = pmPromotionTerminalService;
    }

    public void setPmPromotionConditionService(PmPromotionConditionService pmPromotionConditionService) {
        this.pmPromotionConditionService = pmPromotionConditionService;
    }

    public void setPmPromotionRangelistService(PmPromotionRangelistService pmPromotionRangelistService) {
        this.pmPromotionRangelistService = pmPromotionRangelistService;
    }

    public void setPmPromotionTargetlistService(PmPromotionTargetlistService pmPromotionTargetlistService) {
        this.pmPromotionTargetlistService = pmPromotionTargetlistService;
    }

    public void setPmPromotionMapper(PmPromotionMapper pmPromotionMapper) {
        this.pmPromotionMapper = pmPromotionMapper;
    }

    private Date getSysDate() {
        try {
            return this.pmPromotionMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmPromotionServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkPromotion(PmPromotionDomain pmPromotionDomain) {
        if (null == pmPromotionDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)pmPromotionDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setPromotionDefault(PmPromotion pmPromotion) {
        if (null == pmPromotion) {
            return;
        }
        Date date = this.getSysDate();
        if (null == pmPromotion.getDataState()) {
            pmPromotion.setDataState(0);
        }
        if (null == pmPromotion.getGmtCreate()) {
            pmPromotion.setGmtCreate(date);
        }
        pmPromotion.setGmtModified(date);
        if (null == pmPromotion.getCouponOnceNumd()) {
            pmPromotion.setCouponOnceNumd(0);
        }
        if (null == pmPromotion.getCouponOnceNums()) {
            pmPromotion.setCouponOnceNums(0);
        }
        if (StringUtils.isBlank((String)pmPromotion.getPromotionCode())) {
            pmPromotion.setPromotionCode(this.getNo("0", "PmPromotion", "promotionCode", pmPromotion.getTenantCode()));
        }
        if (StringUtils.isBlank((String)pmPromotion.getCouponBatch())) {
            pmPromotion.setCouponBatch(this.getNo("0", "PmPromotion", "couponBatch", pmPromotion.getTenantCode()));
        }
    }

    private int getPromotionMaxCode() {
        int code = 0;
        try {
            return this.pmPromotionMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmPromotionServiceImpl.getPromotionMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setPromotionUpdataDefault(PmPromotion pmPromotion) {
        if (null == pmPromotion) {
            return;
        }
        pmPromotion.setGmtModified(this.getSysDate());
    }

    private void savePromotionModel(PmPromotion pmPromotion) throws ApiException {
        if (null == pmPromotion) {
            return;
        }
        try {
            this.pmPromotionMapper.insert(pmPromotion);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmPromotionServiceImpl.savePromotionModel.ex", (Throwable)e);
        }
    }

    private void savePromotionBatchModel(List<PmPromotion> pmPromotionList) throws ApiException {
        if (null == pmPromotionList || pmPromotionList.isEmpty()) {
            return;
        }
        try {
            this.pmPromotionMapper.insertBatch(pmPromotionList);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmPromotionServiceImpl.savePromotionBatchModel.ex", (Throwable)e);
        }
    }

    private PmPromotion getPromotionModelById(Integer promotionId) {
        if (null == promotionId) {
            return null;
        }
        try {
            return this.pmPromotionMapper.selectByPrimaryKey(promotionId);
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmPromotionServiceImpl.getPromotionModelById", (Throwable)e);
            return null;
        }
    }

    private PmPromotion getPromotionModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.pmPromotionMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmPromotionServiceImpl.getPromotionModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delPromotionModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.pmPromotionMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmPromotionServiceImpl.delPromotionModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pm.PROMOTION.PmPromotionServiceImpl.delPromotionModelByCode.num");
        }
    }

    private void deletePromotionModel(Integer promotionId) throws ApiException {
        if (null == promotionId) {
            return;
        }
        int i = 0;
        try {
            i = this.pmPromotionMapper.deleteByPrimaryKey(promotionId);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmPromotionServiceImpl.deletePromotionModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pm.PROMOTION.PmPromotionServiceImpl.deletePromotionModel.num");
        }
    }

    private void updatePromotionModel(PmPromotion pmPromotion) throws ApiException {
        if (null == pmPromotion) {
            return;
        }
        int i = 0;
        try {
            i = this.pmPromotionMapper.updateByPrimaryKeySelective(pmPromotion);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmPromotionServiceImpl.updatePromotionModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pm.PROMOTION.PmPromotionServiceImpl.updatePromotionModel.num");
        }
    }

    private void updateStatePromotionModel(Integer promotionId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == promotionId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("promotionId", promotionId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.pmPromotionMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmPromotionServiceImpl.updateStatePromotionModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pm.PROMOTION.PmPromotionServiceImpl.updateStatePromotionModel.null");
        }
    }

    public void updateSendNumPromotionModel(String tenantCode, String promotionCode, int num) {
        if (StringUtils.isBlank((String)promotionCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("promotionCode", promotionCode);
        map.put("couponOnceNumd", num);
        int i = 0;
        try {
            i = this.pmPromotionMapper.updateSendNum(map);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmPromotionServiceImpl.updateSendNumPromotionModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pm.PROMOTION.PmPromotionServiceImpl.updateSendNumPromotionModel.null", "\u5df2\u53d1\u653e\u5b8c");
        }
    }

    private void updateStatePromotionModelByCode(String tenantCode, String promotionCode, Integer dataState, Integer oldDataState) throws ApiException {
        if (StringUtils.isBlank((String)promotionCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("promotionCode", promotionCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.pmPromotionMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmPromotionServiceImpl.updateStatePromotionModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pm.PROMOTION.PmPromotionServiceImpl.updateStatePromotionModelByCode.null");
        }
    }

    private PmPromotion makePromotion(PmPromotionDomain pmPromotionDomain, PmPromotion pmPromotion) {
        if (null == pmPromotionDomain) {
            return null;
        }
        if (null == pmPromotion) {
            pmPromotion = new PmPromotion();
        }
        try {
            BeanUtils.copyAllPropertys((Object)pmPromotion, (Object)pmPromotionDomain);
            return pmPromotion;
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmPromotionServiceImpl.makePromotion", (Throwable)e);
            return null;
        }
    }

    private PmPromotionReDomain makePmPromotionReDomain(PmPromotion pmPromotion) {
        if (null == pmPromotion) {
            return null;
        }
        PmPromotionReDomain pmPromotionReDomain = new PmPromotionReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)pmPromotionReDomain, (Object)pmPromotion);
            return pmPromotionReDomain;
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmPromotionServiceImpl.makePmPromotionReDomain", (Throwable)e);
            return null;
        }
    }

    private List<PmPromotion> queryPromotionModelPage(Map<String, Object> parammap) {
        try {
            return this.pmPromotionMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmPromotionServiceImpl.queryPromotionModel", (Throwable)e);
            return null;
        }
    }

    private int countPromotion(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.pmPromotionMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmPromotionServiceImpl.countPromotion", (Throwable)e);
        }
        return i;
    }

    private PmPromotion createPmPromotion(PmPromotionDomain pmPromotionDomain) {
        String msg = this.checkPromotion(pmPromotionDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pm.PROMOTION.PmPromotionServiceImpl.savePromotion.checkPromotion", msg);
        }
        PmPromotion pmPromotion = this.makePromotion(pmPromotionDomain, null);
        this.setPromotionDefault(pmPromotion);
        return pmPromotion;
    }

    @Override
    public String savePromotion(PmPromotionDomain pmPromotionDomain) throws ApiException {
        PmPromotion pmPromotion = this.createPmPromotion(pmPromotionDomain);
        String pbCode = pmPromotionDomain.getPbCode();
        PmPromotionBaseDomain pmPromotionBaseDomain = (PmPromotionBaseDomain)DisUtil.getMapJson((String)"pm-promotion-base", (String)(pbCode + "-" + pmPromotionDomain.getTenantCode()), PmPromotionBaseDomain.class);
        if (null == pmPromotionBaseDomain) {
            pmPromotionBaseDomain = (PmPromotionBaseDomain)DisUtil.getMapJson((String)"pm-promotion-base", (String)(pbCode + "-" + "00000000"), PmPromotionBaseDomain.class);
        }
        if (null != pmPromotionBaseDomain) {
            pmPromotion.setPriority(pmPromotionBaseDomain.getPriority());
            pmPromotion.setPromotionInType(pmPromotionBaseDomain.getPromotionInType());
            pmPromotion.setPbName(pmPromotionBaseDomain.getPbName());
        }
        this.savePromotionModel(pmPromotion);
        String promotionCode = pmPromotion.getPromotionCode();
        this.savePromotionReRelatedData(pmPromotionDomain, promotionCode);
        return promotionCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BatchCouponService getBatchCouponService() {
        Object object = lock;
        synchronized (object) {
            if (null == batchCouponService) {
                batchCouponService = new BatchCouponService((PmPromotionService)SpringApplicationContextUtil.getBean((String)"pmPromotionService"));
                for (int i = 0; i < 10; ++i) {
                    batchCouponService.addPollPool(new BatchCouponPollThread(batchCouponService));
                }
            }
            return batchCouponService;
        }
    }

    @Override
    public void saveCouponBatch(PmPromotion pmPromotion) {
        if (null == pmPromotion) {
            return;
        }
        Date nowDate = this.getSysDate();
        if (PromotionConstants.DATA_STATE_0.intValue() == pmPromotion.getDataState().intValue()) {
            if (DateUtils.compareDate((Date)pmPromotion.getPromotionBegintime(), (Date)nowDate) >= 0) {
                this.updateStatePromotionModelByCode(pmPromotion.getTenantCode(), pmPromotion.getPromotionCode(), PromotionConstants.DATA_STATE_1, PromotionConstants.DATA_STATE_0);
                pmPromotion.setDataState(PromotionConstants.DATA_STATE_1);
                this.savePromotionIn(pmPromotion);
            }
        } else if (PromotionConstants.DATA_STATE_1.intValue() == pmPromotion.getDataState().intValue() && DateUtils.compareDate((Date)pmPromotion.getPromotionEndtime(), (Date)nowDate) >= 0) {
            this.delPromotionIn(pmPromotion);
            this.updateStatePromotionModelByCode(pmPromotion.getTenantCode(), pmPromotion.getPromotionCode(), PromotionConstants.DATA_STATE_2, PromotionConstants.DATA_STATE_1);
        }
    }

    private void delPromotionIn(PmPromotion pmPromotion) {
        if (null == pmPromotion) {
            return;
        }
        if (StringUtils.isBlank((String)pmPromotion.getPbCode())) {
            this.logger.error("pm.PROMOTION.PmPromotionServiceImpl.delPromotionIn.PbCode");
            return;
        }
        String cacheKey = pmPromotion.getPromotionCode() + "-" + pmPromotion.getTenantCode();
        this.pmPromotionInService.deletePromotionInByPromotionCode(pmPromotion.getTenantCode(), pmPromotion.getPromotionCode());
        DisUtil.delMap((String)"pm-promotion_condition", (String[])new String[]{cacheKey});
        DisUtil.delMap((String)"pm-promotion_discount", (String[])new String[]{cacheKey});
        DisUtil.delMap((String)"pm-promotion_discountlist", (String[])new String[]{cacheKey});
        DisUtil.delMap((String)"pm-promotion_rangelist", (String[])new String[]{cacheKey});
        DisUtil.delMap((String)"pm-promotion_targetlist", (String[])new String[]{cacheKey});
        DisUtil.delMap((String)"pm-promotion_terminal", (String[])new String[]{cacheKey});
        DisUtil.delMap((String)"pm-promotion", (String[])new String[]{cacheKey});
        DisUtil.delMap((String)"pm-promotion_dis", (String[])new String[]{cacheKey});
        DisUtil.delMap((String)"pm-promotion_mem", (String[])new String[]{cacheKey});
        String promotionInListKey = pmPromotion.getTenantCode() + "-" + pmPromotion.getPromotionInType();
        if (pmPromotion.getPromotionMem() == 1) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("tenantCode", pmPromotion.getTenantCode());
            map.put("promotionCode", pmPromotion.getPromotionCode());
            QueryResult<PmPromotionMem> qpomotionMemlList = this.pmPromotionMemService.queryPromotionMemPage(map);
            if (null != qpomotionMemlList && ListUtil.isNotEmpty((Collection)qpomotionMemlList.getList())) {
                String pomotionMemStr = "";
                for (PmPromotionMem pmPromotionMem : qpomotionMemlList.getList()) {
                    if (StringUtils.isNotBlank((String)pomotionMemStr)) {
                        pomotionMemStr = pomotionMemStr + ",";
                    }
                    pomotionMemStr = pomotionMemStr + pmPromotionMem.getPpmemMemcode();
                    this.delInCache(pmPromotion, promotionInListKey + "-" + pmPromotionMem.getPpmemMemcode());
                }
            }
        } else {
            promotionInListKey = promotionInListKey + "-all";
            this.delInCache(pmPromotion, promotionInListKey);
        }
    }

    private void delInCache(PmPromotion pmPromotion, String promotionInListKey) {
        if (null == pmPromotion || StringUtils.isBlank((String)promotionInListKey)) {
            return;
        }
        String json = DisUtil.getMap((String)"pm-promotionin", (String)promotionInListKey);
        if (StringUtils.isNotBlank((String)json)) {
            List inList = (List)JsonUtil.buildNormalBinder().getJsonToList(json, PmPromotionInDomain.class);
            if (ListUtil.isNotEmpty((Collection)inList)) {
                for (PmPromotionInDomain pmPromotionInDomain2 : inList) {
                    if (!pmPromotionInDomain2.getPromotionCode().equals(pmPromotion.getPromotionCode())) continue;
                    inList.remove(pmPromotionInDomain2);
                    break;
                }
            }
            DisUtil.setMapVer((String)"pm-promotionin", (String)promotionInListKey, (String)JsonUtil.buildNormalBinder().toJson((Object)inList));
        }
    }

    private void savePromotionIn(PmPromotion pmPromotion) {
        if (null == pmPromotion) {
            return;
        }
        if (StringUtils.isBlank((String)pmPromotion.getPbCode())) {
            this.logger.error("pm.PROMOTION.PmPromotionServiceImpl.savePromotionIn.PbCode");
            return;
        }
        PmPromotionInDomain pmPromotionInDomain = new PmPromotionInDomain();
        try {
            BeanUtils.copyAllPropertys((Object)pmPromotionInDomain, (Object)pmPromotion);
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmPromotionServiceImpl.savePromotionIn.e", (Throwable)e);
            return;
        }
        this.loadInDomainCache(pmPromotionInDomain);
        this.pmPromotionInService.savePromotionIn(pmPromotionInDomain);
    }

    private void loadInDomainCache(PmPromotionInDomain pmPromotionInDomain) {
        QueryResult<PmPromotionDis> qpromotionDisList;
        QueryResult<PmPromotionTerminal> qterminalList;
        QueryResult<PmPromotionTargetlist> qtargetList;
        int targetType;
        QueryResult<PmPromotionDiscount> qdiscontList;
        if (null == pmPromotionInDomain) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", pmPromotionInDomain.getTenantCode());
        map.put("promotionCode", pmPromotionInDomain.getPromotionCode());
        String cacheKey = pmPromotionInDomain.getPromotionCode() + "-" + pmPromotionInDomain.getTenantCode();
        QueryResult<PmPromotionCondition> qconditionList = this.pmPromotionConditionService.queryPromotionConditionPage(map);
        if (null != qconditionList && ListUtil.isNotEmpty((Collection)qconditionList.getList())) {
            DisUtil.setMapVer((String)"pm-promotion_condition", (String)cacheKey, (String)JsonUtil.buildNormalBinder().toJson((Object)qconditionList.getList()));
        }
        if (null != (qdiscontList = this.pmPromotionDiscountService.queryPromotionDiscountPage(map)) && ListUtil.isNotEmpty((Collection)qdiscontList.getList())) {
            pmPromotionInDomain.setDiscType(((PmPromotionDiscount)qdiscontList.getList().get(0)).getDiscType());
            pmPromotionInDomain.setDiscAmount(((PmPromotionDiscount)qdiscontList.getList().get(0)).getDiscAmount());
            pmPromotionInDomain.setDiscStart(((PmPromotionDiscount)qdiscontList.getList().get(0)).getDiscStart());
            pmPromotionInDomain.setDiscEnd(((PmPromotionDiscount)qdiscontList.getList().get(0)).getDiscEnd());
            DisUtil.setMapVer((String)"pm-promotion_discount", (String)cacheKey, (String)JsonUtil.buildNormalBinder().toJson((Object)qdiscontList.getList()));
            QueryResult<PmPromotionDiscountlist> qlist = this.pmPromotionDiscountlistService.queryPromotionDiscountlistPage(map);
            if (null != qlist && ListUtil.isNotEmpty((Collection)qlist.getList())) {
                String cke = "";
                for (PmPromotionDiscountlist pmPromotionDiscountlist : qlist.getList()) {
                    cke = cacheKey + "-" + pmPromotionDiscountlist.getPpdCode();
                    String cstr = DisUtil.getMap((String)"pm-promotion_discountlist", (String)cke);
                    List<PmPromotionDiscountlist> alist = StringUtils.isNotBlank((String)cstr) ? (List)JsonUtil.buildNormalBinder().getJsonToList(cstr, PmPromotionDiscountlist.class) : new ArrayList<PmPromotionDiscountlist>();
                    alist.add(pmPromotionDiscountlist);
                    DisUtil.setMapVer((String)"pm-promotion_discountlist", (String)cke, (String)JsonUtil.buildNormalBinder().toJson(alist));
                }
            }
        }
        QueryResult<PmPromotionRangelist> qrangeList = this.pmPromotionRangelistService.queryPromotionRangelistPage(map);
        if (null != qdiscontList && ListUtil.isNotEmpty((Collection)qrangeList.getList())) {
            String rangeCodeStr = "|";
            for (PmPromotionRangelist pmPromotionRangelist : qrangeList.getList()) {
                rangeCodeStr = rangeCodeStr + pmPromotionRangelist.getRangeCode() + "|";
            }
            pmPromotionInDomain.setRangeCode(rangeCodeStr);
            DisUtil.setMapVer((String)"pm-promotion_rangelist", (String)cacheKey, (String)JsonUtil.buildNormalBinder().toJson((Object)qrangeList.getList()));
        }
        if ((targetType = pmPromotionInDomain.getTargetType().intValue()) == PromotionConstants.TARGET_TYPE_0 && null != (qtargetList = this.pmPromotionTargetlistService.queryPromotionTargetlistPage(map)) && ListUtil.isNotEmpty((Collection)qtargetList.getList())) {
            String targetStr = "|";
            for (PmPromotionTargetlist pmPromotionTargetlist : qtargetList.getList()) {
                targetStr = targetStr + pmPromotionTargetlist.getTargetCode() + "|";
            }
            pmPromotionInDomain.setTargetCode(targetStr);
            DisUtil.setMapVer((String)"pm-promotion_targetlist", (String)cacheKey, (String)JsonUtil.buildNormalBinder().toJson((Object)qtargetList.getList()));
        }
        if (null != pmPromotionInDomain.getPromotionTer() && pmPromotionInDomain.getPromotionTer() == 1 && null != (qterminalList = this.pmPromotionTerminalService.queryPromotionTerminalPage(map)) && ListUtil.isNotEmpty((Collection)qterminalList.getList())) {
            String terminalTypeStr = "|";
            for (PmPromotionTerminal pmPromotionTerminal : qterminalList.getList()) {
                terminalTypeStr = terminalTypeStr + pmPromotionTerminal.getTerminalType() + "|";
            }
            pmPromotionInDomain.setPromotionTerstr(terminalTypeStr);
            DisUtil.setMapVer((String)"pm-promotion_terminal", (String)cacheKey, (String)JsonUtil.buildNormalBinder().toJson((Object)qterminalList.getList()));
        }
        if (null != pmPromotionInDomain.getPromotionDis() && pmPromotionInDomain.getPromotionDis() == 1 && null != (qpromotionDisList = this.pmPromotionDisService.queryPromotionDisPage(map)) && ListUtil.isNotEmpty((Collection)qpromotionDisList.getList())) {
            String promotionDisStr = "|";
            for (PmPromotionDis pmPromotionDis : qpromotionDisList.getList()) {
                promotionDisStr = promotionDisStr + pmPromotionDis.getChannelCode() + "|";
            }
            pmPromotionInDomain.setChannelCode(promotionDisStr);
            DisUtil.setMapVer((String)"pm-promotion_dis", (String)cacheKey, (String)JsonUtil.buildNormalBinder().toJson((Object)qpromotionDisList.getList()));
        }
        String promotionInListKey = pmPromotionInDomain.getTenantCode() + "-" + pmPromotionInDomain.getPromotionInType();
        if (null != pmPromotionInDomain.getPromotionMem() && pmPromotionInDomain.getPromotionMem() == 1) {
            QueryResult<PmPromotionMem> qpomotionMemlList = this.pmPromotionMemService.queryPromotionMemPage(map);
            if (null != qpomotionMemlList && ListUtil.isNotEmpty((Collection)qpomotionMemlList.getList())) {
                String pomotionMemStr = "|";
                for (PmPromotionMem pmPromotionMem : qpomotionMemlList.getList()) {
                    pomotionMemStr = pomotionMemStr + pmPromotionMem.getPpmemMemcode() + "|";
                    this.updateInListCache(pmPromotionInDomain, promotionInListKey + "-" + pmPromotionMem.getPpmemMemcode());
                }
                pmPromotionInDomain.setPpmemMemcode(pomotionMemStr);
                DisUtil.setMapVer((String)"pm-promotion_mem", (String)cacheKey, (String)JsonUtil.buildNormalBinder().toJson((Object)qpomotionMemlList.getList()));
            }
        } else {
            promotionInListKey = promotionInListKey + "-all";
            this.updateInListCache(pmPromotionInDomain, promotionInListKey);
        }
        DisUtil.setMapVer((String)"pm-promotion", (String)cacheKey, (String)JsonUtil.buildNormalBinder().toJson((Object)pmPromotionInDomain));
    }

    private void updateInListCache(PmPromotionInDomain pmPromotionInDomain, String promotionInListKey) {
        if (null == pmPromotionInDomain || StringUtils.isBlank((String)promotionInListKey)) {
            return;
        }
        String listStr = DisUtil.getRemotMap((String)"pm-promotionin", (String)promotionInListKey);
        ArrayList<PmPromotionInDomain> inList = null;
        if (StringUtils.isNotBlank((String)listStr)) {
            inList = (ArrayList<PmPromotionInDomain>)JsonUtil.buildNormalBinder().getJsonToList(listStr, PmPromotionInDomain.class);
            for (PmPromotionInDomain pmPromotionInDomain2 : inList) {
                if (!(pmPromotionInDomain2.getPromotionCode() + "-" + pmPromotionInDomain2.getTenantCode()).equals(pmPromotionInDomain.getPromotionCode() + "-" + pmPromotionInDomain.getTenantCode())) continue;
                inList.remove(pmPromotionInDomain2);
                break;
            }
        }
        if (null == inList) {
            inList = new ArrayList<PmPromotionInDomain>();
        }
        inList.add(pmPromotionInDomain);
        Collections.sort(inList, new Comparator<PmPromotionInDomain>(){

            @Override
            public int compare(PmPromotionInDomain arg0, PmPromotionInDomain arg1) {
                if (arg0.getPriority() > arg1.getPriority()) {
                    return 1;
                }
                if (arg0.getPriority() < arg1.getPriority()) {
                    return -1;
                }
                return arg0.getPriority().compareTo(arg0.getPriority());
            }
        });
        DisUtil.setMapVer((String)"pm-promotionin", (String)promotionInListKey, (String)JsonUtil.buildNormalBinder().toJson(inList));
    }

    private Integer checkPromotionDataState(Date beginTime, Date endTime) {
        Integer dataState = PromotionConstants.DATA_STATE_0;
        Date nowDate = new Date();
        if (DateUtils.compareDate((Date)nowDate, (Date)beginTime) < 0 && DateUtils.compareDate((Date)nowDate, (Date)endTime) > 0) {
            dataState = PromotionConstants.DATA_STATE_1;
        } else if (DateUtils.compareDate((Date)nowDate, (Date)endTime) < 0) {
            dataState = PromotionConstants.DATA_STATE_2;
        }
        return dataState;
    }

    private void savePromotionReRelatedData(PmPromotionDomain pmPromotionDomain, String promotionCode) {
        List<PmPromotionMemDomain> pmPromotionMemList;
        List<PmPromotionDisDomain> pmPromotionDisList;
        List<PmPromotionDiscountDomain> discountDomainList;
        List<PmPromotionConditionDomain> conditionDomainList;
        List<PmPromotionTerminalDomain> terminalDomainList;
        List<PmPromotionRangelistDomain> rangelistDomainList;
        List<PmPromotionTargetlistDomain> targetlistDomainList = pmPromotionDomain.getPmPromotionTargetList();
        if (null != targetlistDomainList && targetlistDomainList.size() > 0) {
            for (PmPromotionTargetlistDomain targetlistDomain : targetlistDomainList) {
                targetlistDomain.setAppmanageIcode(pmPromotionDomain.getAppmanageIcode());
                targetlistDomain.setTenantCode(pmPromotionDomain.getTenantCode());
                targetlistDomain.setMemberName(pmPromotionDomain.getMemberName());
                targetlistDomain.setMemberCode(pmPromotionDomain.getMemberCode());
                targetlistDomain.setPromotionCode(promotionCode);
            }
            this.pmPromotionTargetlistService.savePromotionTargetlistBatch(targetlistDomainList);
        }
        if (null != (rangelistDomainList = pmPromotionDomain.getPmPromotionRangeList()) && rangelistDomainList.size() > 0) {
            for (PmPromotionRangelistDomain rangelistDomain : rangelistDomainList) {
                rangelistDomain.setAppmanageIcode(pmPromotionDomain.getAppmanageIcode());
                rangelistDomain.setTenantCode(pmPromotionDomain.getTenantCode());
                rangelistDomain.setMemberName(pmPromotionDomain.getMemberName());
                rangelistDomain.setMemberCode(pmPromotionDomain.getMemberCode());
                rangelistDomain.setPromotionCode(promotionCode);
            }
            this.pmPromotionRangelistService.savePromotionRangelistBatch(rangelistDomainList);
        }
        if (null != (terminalDomainList = pmPromotionDomain.getPmPromotionTerminalList()) && terminalDomainList.size() > 0) {
            for (PmPromotionTerminalDomain terminalDomain : terminalDomainList) {
                terminalDomain.setAppmanageIcode(pmPromotionDomain.getAppmanageIcode());
                terminalDomain.setTenantCode(pmPromotionDomain.getTenantCode());
                terminalDomain.setMemberName(pmPromotionDomain.getMemberName());
                terminalDomain.setMemberCode(pmPromotionDomain.getMemberCode());
                terminalDomain.setPromotionCode(promotionCode);
            }
            this.pmPromotionTerminalService.savePromotionTerminalBatch(terminalDomainList);
        }
        if (null != (conditionDomainList = pmPromotionDomain.getPmPromotionConditionList()) && conditionDomainList.size() > 0) {
            for (PmPromotionConditionDomain conditionDomain : conditionDomainList) {
                conditionDomain.setAppmanageIcode(pmPromotionDomain.getAppmanageIcode());
                conditionDomain.setTenantCode(pmPromotionDomain.getTenantCode());
                conditionDomain.setMemberName(pmPromotionDomain.getMemberName());
                conditionDomain.setMemberCode(pmPromotionDomain.getMemberCode());
                conditionDomain.setPromotionCode(promotionCode);
            }
            this.pmPromotionConditionService.savePromotionConditionBatch(conditionDomainList);
        }
        if (null != (discountDomainList = pmPromotionDomain.getPmPromotionDiscountList()) && discountDomainList.size() > 0) {
            for (PmPromotionDiscountDomain discountDomain : discountDomainList) {
                discountDomain.setAppmanageIcode(pmPromotionDomain.getAppmanageIcode());
                discountDomain.setTenantCode(pmPromotionDomain.getTenantCode());
                discountDomain.setMemberName(pmPromotionDomain.getMemberName());
                discountDomain.setMemberCode(pmPromotionDomain.getMemberCode());
                discountDomain.setPromotionCode(promotionCode);
            }
            this.pmPromotionDiscountService.savePromotionDiscountBatch(discountDomainList);
        }
        if (ListUtil.isNotEmpty(pmPromotionDisList = pmPromotionDomain.getPmPromotionDisList())) {
            for (PmPromotionDisDomain pmPromotionDisDomain : pmPromotionDisList) {
                pmPromotionDisDomain.setAppmanageIcode(pmPromotionDomain.getAppmanageIcode());
                pmPromotionDisDomain.setTenantCode(pmPromotionDomain.getTenantCode());
                pmPromotionDisDomain.setMemberName(pmPromotionDomain.getMemberName());
                pmPromotionDisDomain.setMemberCode(pmPromotionDomain.getMemberCode());
                pmPromotionDisDomain.setPromotionCode(promotionCode);
            }
            this.pmPromotionDisService.savePromotionDisBatch(pmPromotionDisList);
        }
        if (ListUtil.isNotEmpty(pmPromotionMemList = pmPromotionDomain.getPmPromotionMemList())) {
            for (PmPromotionMemDomain pmPromotionMemDomain : pmPromotionMemList) {
                pmPromotionMemDomain.setAppmanageIcode(pmPromotionDomain.getAppmanageIcode());
                pmPromotionMemDomain.setTenantCode(pmPromotionDomain.getTenantCode());
                pmPromotionMemDomain.setMemberName(pmPromotionDomain.getMemberName());
                pmPromotionMemDomain.setMemberCode(pmPromotionDomain.getMemberCode());
                pmPromotionMemDomain.setPromotionCode(promotionCode);
            }
            this.pmPromotionMemService.savePromotionMemBatch(pmPromotionMemList);
        }
    }

    private void delPromotionReRelatedData(String tenantCode, String promotionCode) {
        this.pmPromotionTargetlistService.deletePromotionTargetlistByCode(tenantCode, promotionCode);
        this.pmPromotionRangelistService.deletePromotionRangelistByCode(tenantCode, promotionCode);
        this.pmPromotionTerminalService.deletePromotionTerminalByCode(tenantCode, promotionCode);
        this.pmPromotionConditionService.deletePromotionConditionByCode(tenantCode, promotionCode);
        this.pmPromotionDiscountService.deletePromotionDiscountByCode(tenantCode, promotionCode);
        this.pmPromotionDiscountlistService.deletePromotionDiscountlistByCode(tenantCode, promotionCode);
        this.pmPromotionDisService.deletePromotionDisByPromotionCode(tenantCode, promotionCode);
        this.pmPromotionMemService.deletePromotionMemByPromotionCode(tenantCode, promotionCode);
    }

    private void getPromotionReRelatedData(PmPromotion pmPromotion) {
        QueryResult<PmPromotionDis> disQueryResult;
        QueryResult<PmPromotionMem> memQueryResult;
        QueryResult<PmPromotionDiscount> promotionDiscountResult;
        QueryResult<PmPromotionCondition> conditionQueryResult;
        QueryResult<PmPromotionTerminal> terminalQueryResult;
        QueryResult<PmPromotionRangelist> rangelistQueryResult;
        if (null == pmPromotion) {
            return;
        }
        String tenantCode = pmPromotion.getTenantCode();
        String promotionCode = pmPromotion.getPromotionCode();
        Map paramMap = this.getQueryParamMap("promotionCode,tenantCode", new Object[]{promotionCode, tenantCode});
        QueryResult<PmPromotionTargetlist> targetlistQueryResult = this.pmPromotionTargetlistService.queryPromotionTargetlistPage(paramMap);
        if (null != targetlistQueryResult && null != targetlistQueryResult.getList()) {
            pmPromotion.setPmPromotionTargetList(targetlistQueryResult.getList());
        }
        if (null != (rangelistQueryResult = this.pmPromotionRangelistService.queryPromotionRangelistPage(paramMap)) && null != rangelistQueryResult.getList()) {
            pmPromotion.setPmPromotionRangeList(rangelistQueryResult.getList());
        }
        if (null != (terminalQueryResult = this.pmPromotionTerminalService.queryPromotionTerminalPage(paramMap)) && null != terminalQueryResult.getList()) {
            pmPromotion.setPmPromotionTerminalList(terminalQueryResult.getList());
        }
        if (null != (conditionQueryResult = this.pmPromotionConditionService.queryPromotionConditionPage(paramMap)) && null != conditionQueryResult.getList()) {
            pmPromotion.setPmPromotionConditionList(conditionQueryResult.getList());
        }
        if (null != (promotionDiscountResult = this.pmPromotionDiscountService.queryPromotionDiscountPage(paramMap)) && null != promotionDiscountResult.getList()) {
            pmPromotion.setPmPromotionDiscountList(promotionDiscountResult.getList());
            QueryResult<PmPromotionDiscountlist> qdiscountlist = null;
            for (PmPromotionDiscount pmPromotionDiscount : promotionDiscountResult.getList()) {
                paramMap.put("ppdCode", pmPromotionDiscount.getPpdCode());
                qdiscountlist = this.pmPromotionDiscountlistService.queryPromotionDiscountlistPage(paramMap);
                if (null == qdiscountlist) continue;
                pmPromotionDiscount.setPmPromotionDiscountlistList(qdiscountlist.getList());
            }
        }
        if (null != (memQueryResult = this.pmPromotionMemService.queryPromotionMemPage(paramMap)) && null != memQueryResult.getList()) {
            pmPromotion.setPmPromotionMemList(memQueryResult.getList());
        }
        if (null != (disQueryResult = this.pmPromotionDisService.queryPromotionDisPage(paramMap)) && null != disQueryResult.getList()) {
            pmPromotion.setPmPromotionDisList(disQueryResult.getList());
        }
    }

    @Override
    public String savePromotionBatch(List<PmPromotionDomain> pmPromotionDomainList) throws ApiException {
        if (null == pmPromotionDomainList || pmPromotionDomainList.isEmpty()) {
            return null;
        }
        ArrayList<PmPromotion> pmPromotionList = new ArrayList<PmPromotion>();
        String code = "";
        for (PmPromotionDomain pmPromotionDomain : pmPromotionDomainList) {
            PmPromotion pmPromotion = this.createPmPromotion(pmPromotionDomain);
            code = pmPromotion.getPromotionCode();
            pmPromotionList.add(pmPromotion);
        }
        this.savePromotionBatchModel(pmPromotionList);
        return code;
    }

    @Override
    public void updatePromotionState(Integer promotionId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStatePromotionModel(promotionId, dataState, oldDataState);
    }

    @Override
    public void updatePromotionStateByCode(String tenantCode, String promotionCode, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStatePromotionModelByCode(tenantCode, promotionCode, dataState, oldDataState);
    }

    @Override
    public void updatePromotion(PmPromotionDomain pmPromotionDomain) throws ApiException {
        String msg = this.checkPromotion(pmPromotionDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pm.PROMOTION.PmPromotionServiceImpl.updatePromotion.checkPromotion", msg);
        }
        PmPromotion oldPmPromotion = this.getPromotionModelById(pmPromotionDomain.getPromotionId());
        if (null == oldPmPromotion) {
            throw new ApiException("pm.PROMOTION.PmPromotionServiceImpl.updatePromotion.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        PmPromotion pmPromotion = this.makePromotion(pmPromotionDomain, oldPmPromotion);
        this.setPromotionUpdataDefault(pmPromotion);
        pmPromotion.setDataState(this.checkPromotionDataState(pmPromotionDomain.getPromotionBegintime(), pmPromotionDomain.getPromotionEndtime()));
        String pbCode = pmPromotionDomain.getPbCode();
        PmPromotionBaseDomain pmPromotionBaseDomain = (PmPromotionBaseDomain)DisUtil.getMapJson((String)"pm-promotion-base", (String)(pbCode + "-" + pmPromotionDomain.getTenantCode()), PmPromotionBaseDomain.class);
        if (null == pmPromotionBaseDomain) {
            pmPromotionBaseDomain = (PmPromotionBaseDomain)DisUtil.getMapJson((String)"pm-promotion-base", (String)(pbCode + "-" + "00000000"), PmPromotionBaseDomain.class);
        }
        if (null != pmPromotionBaseDomain) {
            pmPromotion.setPriority(pmPromotionBaseDomain.getPriority());
            pmPromotion.setPromotionInType(pmPromotionBaseDomain.getPromotionInType());
        }
        this.updatePromotionModel(pmPromotion);
        this.delPromotionReRelatedData(pmPromotion.getTenantCode(), pmPromotion.getPromotionCode());
        this.savePromotionReRelatedData(pmPromotionDomain, pmPromotion.getPromotionCode());
    }

    @Override
    public PmPromotion getPromotion(Integer promotionId) {
        PmPromotion pmPromotion = this.getPromotionModelById(promotionId);
        this.getPromotionReRelatedData(pmPromotion);
        return pmPromotion;
    }

    @Override
    public void deletePromotion(Integer promotionId) throws ApiException {
        this.deletePromotionModel(promotionId);
    }

    @Override
    public QueryResult<PmPromotion> queryPromotionPage(Map<String, Object> map) {
        List<PmPromotion> pmPromotionList = this.queryPromotionModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countPromotion(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(pmPromotionList);
        return queryResult;
    }

    public void processDiscountInfo(PmPromotion pmPromotion, String tenantCode) {
        String strcon = DisUtil.getMap((String)"pm-promotion_discount", (String)(pmPromotion.getPromotionCode() + "-" + tenantCode));
        if (StringUtils.isBlank((String)strcon)) {
            return;
        }
        List pmPromotionDiscountList = (List)JsonUtil.buildNormalBinder().getJsonToList(strcon, PmPromotionDiscount.class);
        if (ListUtil.isEmpty((Collection)pmPromotionDiscountList)) {
            return;
        }
        pmPromotion.setPmPromotionDiscountList(pmPromotionDiscountList);
        for (PmPromotionDiscount pmPromotionDiscount : pmPromotionDiscountList) {
            String cstr = DisUtil.getMap((String)"pm-promotion_discountlist", (String)(pmPromotion.getPromotionCode() + "-" + pmPromotion.getTenantCode() + "-" + pmPromotionDiscount.getPpdCode()));
            List promotionDiscountlists = null;
            if (StringUtils.isNotBlank((String)cstr)) {
                promotionDiscountlists = (List)JsonUtil.buildNormalBinder().getJsonToList(cstr, PmPromotionDiscountlist.class);
            }
            if (pmPromotionDiscount.getDiscType() != PromotionConstants.DISCOUNT_TYPE_5 || ListUtil.isNotEmpty((Collection)promotionDiscountlists)) {
                // empty if block
            }
            pmPromotionDiscount.setPmPromotionDiscountlistList(promotionDiscountlists);
        }
    }

    private SkuBean makeSkuBean(PmCheckBean pmCheckBean, PmGoodsBean pmGoodsBean) {
        if (null == pmCheckBean || null == pmGoodsBean) {
            return null;
        }
        SkuBean skuBean = new SkuBean();
        skuBean.setPmCheckBean(pmCheckBean);
        skuBean.setBrandCode(pmGoodsBean.getBrandCode());
        skuBean.setClasstreeCode(pmGoodsBean.getClasstreeCode());
        skuBean.setClasstreeShopcode(pmGoodsBean.getClasstreeShopcode());
        skuBean.setGoodsNum(pmGoodsBean.getGoodsCamount());
        skuBean.setGoodsWeight(pmGoodsBean.getGoodsCweight());
        skuBean.setMemberCode(pmGoodsBean.getMemberCode());
        skuBean.setPntreeCode(pmGoodsBean.getPntreeCode());
        skuBean.setPricesetNprice(pmGoodsBean.getPricesetNprice());
        skuBean.setPricesetRefrice(pmGoodsBean.getPricesetRefrice());
        skuBean.setSkuCode(pmGoodsBean.getSkuCode());
        skuBean.setSkuNo(pmGoodsBean.getSkuNo());
        skuBean.setTenantCode(pmGoodsBean.getTenantCode());
        return skuBean;
    }

    private Map<String, BigDecimal> calcPm(Map<String, PmCalcBean> pmCalcBeanMap, PmCheckBean pmCheckBean, List<PmContractGoodsDomain> avgList) {
        if (MapUtil.isEmpty(pmCalcBeanMap) || null == pmCheckBean) {
            return null;
        }
        BigDecimal discountPmAmount = BigDecimal.ZERO;
        BigDecimal discountCopAmount = BigDecimal.ZERO;
        BigDecimal sumDisMoney = BigDecimal.ZERO;
        BigDecimal sumAveMoney = BigDecimal.ZERO;
        for (String promotionCode : pmCalcBeanMap.keySet()) {
            PmCalcBean pmCalcDomain = pmCalcBeanMap.get(promotionCode);
            if (null == pmCalcDomain) continue;
            if (StringUtils.isBlank((String)promotionCode)) {
                this.logger.error("========2===========");
                continue;
            }
            if (null == this.calBasePm(pmCalcDomain, true)) {
                this.logger.error("========1===========");
                continue;
            }
            if (null == pmCalcDomain.getDisMoney()) {
                pmCalcDomain.setDisMoney(BigDecimal.ZERO);
            }
            sumDisMoney = sumDisMoney.add(pmCalcDomain.getDisMoney());
            if ("0".equals(pmCalcDomain.getPromotionInType())) {
                discountPmAmount = discountPmAmount.add(pmCalcDomain.getDisMoney());
            } else {
                discountCopAmount = discountCopAmount.add(pmCalcDomain.getDisMoney());
            }
            if (null == pmCalcDomain.getSumAveMoney()) {
                pmCalcDomain.setSumAveMoney(BigDecimal.ZERO);
            }
            sumAveMoney = sumAveMoney.add(pmCalcDomain.getSumAveMoney());
        }
        this.aveGoodList(sumAveMoney, sumDisMoney, avgList);
        HashMap<String, BigDecimal> remap = new HashMap<String, BigDecimal>();
        remap.put("discountPmAmount", discountPmAmount);
        remap.put("discounCopAmount", discountCopAmount);
        return remap;
    }

    private void aveGoodList(BigDecimal sumMoney, BigDecimal sumDisMoney, List<PmContractGoodsDomain> avgList) {
        if (ListUtil.isEmpty(avgList) || null == sumDisMoney || sumDisMoney.compareTo(BigDecimal.ZERO) == 0) {
            return;
        }
        DecimalFormat df2 = new DecimalFormat("#.00");
        int size = avgList.size();
        BigDecimal tempDisAmount = sumDisMoney;
        for (int a = 0; a < size; ++a) {
            PmContractGoodsDomain pmContractGoodsDomain = avgList.get(a);
            if (a == size - 1) {
                pmContractGoodsDomain.setContractGoodsMoney(pmContractGoodsDomain.getContractGoodsMoney().subtract(new BigDecimal(df2.format(tempDisAmount))));
                pmContractGoodsDomain.setContractGoodsPrice(pmContractGoodsDomain.getContractGoodsMoney().divide(pmContractGoodsDomain.getGoodsAhweight()));
                break;
            }
            BigDecimal skuPrice = pmContractGoodsDomain.getContractGoodsMoney();
            BigDecimal rate = skuPrice.divide(sumMoney, 2, 4);
            BigDecimal skuDiscount = sumDisMoney.multiply(rate);
            pmContractGoodsDomain.setContractGoodsMoney(pmContractGoodsDomain.getContractGoodsMoney().subtract(new BigDecimal(df2.format(skuDiscount))));
            pmContractGoodsDomain.setContractGoodsPrice(pmContractGoodsDomain.getContractGoodsMoney().divide(pmContractGoodsDomain.getGoodsAhweight()));
            tempDisAmount = tempDisAmount.subtract(skuDiscount);
        }
    }

    private void makeCheckPm(SkuBean skuBean, List<PmContractGoodsDomain> avgList, Map<String, PmCalcBean> pmCalcBeanMap, String promotionCode, PmContractGoodsDomain pmContractGoodsDomain) {
        if (null == skuBean || null == avgList || null == pmCalcBeanMap || null == pmContractGoodsDomain || StringUtils.isBlank((String)promotionCode)) {
            return;
        }
        PmPromotionInDomain pmPromotionInDomain = (PmPromotionInDomain)DisUtil.getMapJson((String)"pm-promotion", (String)(promotionCode + "-" + pmContractGoodsDomain.getTenantCode()), PmPromotionInDomain.class);
        if (this.checkPm(pmPromotionInDomain, skuBean)) {
            PmCalcBean pmCalcBean = pmCalcBeanMap.get(promotionCode);
            if (null == pmCalcBean) {
                pmCalcBean = new PmCalcBean();
                pmCalcBeanMap.put(promotionCode, pmCalcBean);
                pmCalcBean.setDiscType(pmPromotionInDomain.getDiscType());
                pmCalcBean.setPromotionInType(pmPromotionInDomain.getPromotionInType());
                pmCalcBean.setPromotionCode(promotionCode);
                pmCalcBean.setTenantCode(pmContractGoodsDomain.getTenantCode());
                if (null == pmContractGoodsDomain.getGoodsCamount()) {
                    pmContractGoodsDomain.setGoodsCamount(BigDecimal.ZERO);
                }
                if (null == pmContractGoodsDomain.getGoodsCweight()) {
                    pmContractGoodsDomain.setGoodsCweight(BigDecimal.ZERO);
                }
                if (null == pmContractGoodsDomain.getPricesetNprice()) {
                    pmContractGoodsDomain.setPricesetNprice(BigDecimal.ZERO);
                }
                if (null == pmContractGoodsDomain.getPricesetRefrice()) {
                    pmContractGoodsDomain.setPricesetRefrice(BigDecimal.ZERO);
                }
                if (null == pmCalcBean.getSumMoney()) {
                    pmCalcBean.setSumMoney(BigDecimal.ZERO);
                }
                if (null == pmCalcBean.getSumNum()) {
                    pmCalcBean.setSumNum(BigDecimal.ZERO);
                }
                if (null == pmCalcBean.getSumWeight()) {
                    pmCalcBean.setSumWeight(BigDecimal.ZERO);
                }
                if (null == pmCalcBean.getSumRefMoney()) {
                    pmCalcBean.setSumRefMoney(BigDecimal.ZERO);
                }
                if (null == pmCalcBean.getSumAveMoney()) {
                    pmCalcBean.setSumAveMoney(BigDecimal.ZERO);
                }
            }
            pmCalcBean.setSumMoney(pmCalcBean.getSumMoney().add(pmContractGoodsDomain.getPricesetNprice().multiply(pmContractGoodsDomain.getGoodsCamount())));
            pmCalcBean.setSumNum(pmCalcBean.getSumNum().add(pmContractGoodsDomain.getGoodsCamount()));
            pmCalcBean.setSumWeight(pmCalcBean.getSumWeight().add(pmContractGoodsDomain.getGoodsCweight()));
            pmCalcBean.setSumRefMoney(pmCalcBean.getSumRefMoney().add(pmContractGoodsDomain.getPricesetRefrice().multiply(pmContractGoodsDomain.getGoodsCamount())));
            if (!(pmPromotionInDomain.getDiscType() != PromotionConstants.DISCOUNT_TYPE_0 && pmPromotionInDomain.getDiscType() != PromotionConstants.DISCOUNT_TYPE_1 && pmPromotionInDomain.getDiscType() != PromotionConstants.DISCOUNT_TYPE_2 && pmPromotionInDomain.getDiscType() != PromotionConstants.DISCOUNT_TYPE_3 || avgList.contains(pmContractGoodsDomain))) {
                avgList.add(pmContractGoodsDomain);
                pmCalcBean.setSumAveMoney(pmCalcBean.getSumAveMoney().add(pmContractGoodsDomain.getPricesetNprice().multiply(pmContractGoodsDomain.getGoodsCamount())));
            }
            this.logger.error("pm.PROMOTION.PmPromotionServiceImpl.makeCheckPm.checkPm.2", (Object)pmCalcBean.getSumMoney());
        } else {
            this.logger.error("pm.PROMOTION.PmPromotionServiceImpl.makeCheckPm.checkPm.1", (Object)promotionCode);
        }
    }

    @Delete(value={"\u4e0d\u9700\u8981"})
    private void updateShoppingGoods(OcShoppingGoodsDomain ocShoppingGoodsDomain) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("ocShoppingGoodsDomain", JsonUtil.buildNormalBinder().toJson((Object)ocShoppingGoodsDomain));
        this.inAsyncInvoke("oc.shopping.updateShoppingGoods", paramMap);
    }

    private Map<String, PmCalcBean> makePmcal(List<PmContractGoodsDomain> pmContractGoodsDomainList, Map<String, String> promotionPmMap, Map<String, String> promotionCopMap, PmCheckBean pmCheckBean, List<PmContractGoodsDomain> avgList) {
        if (ListUtil.isEmpty(pmContractGoodsDomainList) || null == pmCheckBean || null == avgList) {
            return null;
        }
        HashMap<String, PmCalcBean> pmCalcBeanMap = new HashMap<String, PmCalcBean>();
        for (PmContractGoodsDomain pmContractGoodsDomain : pmContractGoodsDomainList) {
            String promotionCode = pmContractGoodsDomain.getShoppingGoodsPm();
            this.logger.error("pm.PROMOTION.PmPromotionServiceImpl.makePmcal.1", (Object)(promotionCode + "=" + pmContractGoodsDomain.getContractGoodsMoney()));
            if (null == pmContractGoodsDomain.getContractGoodsMoney() || pmContractGoodsDomain.getContractGoodsMoney().compareTo(BigDecimal.ZERO) == 0) {
                Map<String, String> skuNoMap;
                PmCalcBean pmCalcBean = (PmCalcBean)pmCalcBeanMap.get(promotionCode);
                if (null == pmCalcBean) {
                    pmCalcBean = new PmCalcBean();
                    pmCalcBean.setPromotionCode(promotionCode);
                    pmCalcBean.setTenantCode(pmContractGoodsDomain.getTenantCode());
                    skuNoMap = new HashMap<String, String>();
                    pmCalcBean.setSkuNoMap(skuNoMap);
                    pmCalcBeanMap.put(promotionCode, pmCalcBean);
                }
                skuNoMap = pmCalcBean.getSkuNoMap();
                skuNoMap.put(pmContractGoodsDomain.getSkuNo(), pmContractGoodsDomain.getShoppingGoodsPm());
                continue;
            }
            SkuBean skuBean = this.makeSkuBean(pmCheckBean, pmContractGoodsDomain);
            if (null == skuBean) {
                return null;
            }
            if (StringUtils.isNotBlank((String)promotionCode) && StringUtils.isNotBlank((String)promotionPmMap.get(promotionCode))) {
                this.makeCheckPm(skuBean, avgList, pmCalcBeanMap, promotionCode, pmContractGoodsDomain);
                this.logger.error("pm.PROMOTION.PmPromotionServiceImpl.makePmcal.2", (Object)promotionCode);
            }
            if (!MapUtil.isNotEmpty(promotionCopMap)) continue;
            for (String key : promotionCopMap.keySet()) {
                this.makeCheckPm(skuBean, avgList, pmCalcBeanMap, key, pmContractGoodsDomain);
            }
        }
        return pmCalcBeanMap;
    }

    @Override
    public PmInfoBean checkPm(List<PmContractGoodsDomain> pmContractGoodsDomainList, List<OcContractSettlDomain> ocContractSettlDomainList, PmCheckBean pmCheckBean) {
        PmInfoBean pmInfoBean = new PmInfoBean();
        pmInfoBean.setFlag("true");
        if (ListUtil.isEmpty(ocContractSettlDomainList)) {
            return pmInfoBean;
        }
        if (ListUtil.isEmpty(pmContractGoodsDomainList) || null == pmCheckBean) {
            pmInfoBean.setFlag("error");
            pmInfoBean.setMsg("\u6ca1\u6709sku\u4fe1\u606f");
            return pmInfoBean;
        }
        boolean checkPmFlag = false;
        boolean checkCopFlag = false;
        BigDecimal pmSettlBlance = BigDecimal.ZERO;
        BigDecimal copSettlBlance = BigDecimal.ZERO;
        HashMap<String, String> promotionPmMap = new HashMap<String, String>();
        HashMap<String, String> promotionCopMap = new HashMap<String, String>();
        for (OcContractSettlDomain ocContractSettlDomain : ocContractSettlDomainList) {
            if (ocContractSettlDomain.getContractSettlBlance().equals("PM")) {
                pmSettlBlance = pmSettlBlance.add(ocContractSettlDomain.getContractSettlPmoney());
                promotionPmMap.put(ocContractSettlDomain.getContractSettlOpno(), ocContractSettlDomain.getContractSettlOpno());
                checkPmFlag = true;
                continue;
            }
            if (!ocContractSettlDomain.getContractSettlBlance().equals("COP")) continue;
            copSettlBlance = copSettlBlance.add(ocContractSettlDomain.getContractSettlPmoney());
            promotionCopMap.put(ocContractSettlDomain.getContractSettlOpno(), ocContractSettlDomain.getContractSettlOpno());
            checkCopFlag = true;
        }
        if (!checkPmFlag && !checkCopFlag) {
            return pmInfoBean;
        }
        ArrayList<PmContractGoodsDomain> avgList = new ArrayList<PmContractGoodsDomain>();
        Map<String, PmCalcBean> pmCalcBeanMap = this.makePmcal(pmContractGoodsDomainList, promotionPmMap, promotionCopMap, pmCheckBean, avgList);
        if (MapUtil.isEmpty(pmCalcBeanMap)) {
            pmInfoBean.setFlag("error");
            pmInfoBean.setMsg("\u4fe1\u606f\u5f02\u5e38");
            this.logger.error("pm.PROMOTION.PmPromotionServiceImpl.checkPm.pmCalcBeanMap", (Object)((Object)promotionPmMap).toString());
            this.logger.error("pm.PROMOTION.PmPromotionServiceImpl.checkPm.pmCalcBeanMap", (Object)((Object)promotionCopMap).toString());
            return pmInfoBean;
        }
        Map<String, BigDecimal> remap = this.calcPm(pmCalcBeanMap, pmCheckBean, avgList);
        if (checkPmFlag) {
            if (null == remap) {
                pmInfoBean.setFlag("error");
                pmInfoBean.setMsg("\u4f18\u60e0\u6d3b\u52a8\u6570\u636e\u51fa\u9519 " + pmSettlBlance + "== null");
                return pmInfoBean;
            }
            BigDecimal discountPmAmount = remap.get("discountPmAmount");
            if (pmSettlBlance.compareTo(discountPmAmount) != 0) {
                pmInfoBean.setFlag("error");
                pmInfoBean.setMsg("\u4f18\u60e0\u6d3b\u52a8\u6570\u636e\u51fa\u9519 " + pmSettlBlance + "== " + discountPmAmount);
                return pmInfoBean;
            }
        }
        if (checkCopFlag) {
            if (null == remap) {
                pmInfoBean.setFlag("error");
                pmInfoBean.setMsg("\u4f18\u60e0\u5238\u6570\u636e\u51fa\u9519 " + copSettlBlance + "== null");
                return pmInfoBean;
            }
            BigDecimal discountCopAmount = remap.get("discountCopAmount");
            if (copSettlBlance.compareTo(discountCopAmount) != 0) {
                pmInfoBean.setFlag("error");
                pmInfoBean.setMsg("\u4f18\u60e0\u5238\u6570\u636e\u51fa\u9519 " + copSettlBlance + "== " + discountCopAmount);
                return pmInfoBean;
            }
        }
        pmInfoBean.setPmContractGoodsDomainList(pmContractGoodsDomainList);
        return pmInfoBean;
    }

    private RsResourceGoods getRsourcesGoods(String goodsCode, String tenantCode) {
        HashMap<String, String> pmap = new HashMap<String, String>();
        pmap.put("map", JsonUtil.buildNormalBinder().toJson((Object)this.getQueryMapParam("goodsCode,tenantCode,unwantedRelatedData", new Object[]{goodsCode, tenantCode, "unwantedRelatedData"})));
        Object goodsObj = this.getInternalRouter().inInvoke("rs.resourceGoods.getResourceGoodsByCode", pmap);
        if (null != goodsObj) {
            return (RsResourceGoods)JsonUtil.buildNormalBinder().getJsonToObject(goodsObj.toString(), RsResourceGoods.class);
        }
        return null;
    }

    private RsSku getRsSku(String skuCode, String tenantCode) {
        HashMap<String, String> pmap = new HashMap<String, String>();
        pmap.put("map", JsonUtil.buildNormalBinder().toJson((Object)this.getQueryParamMap("skuCode,tenantCode", new Object[]{skuCode, tenantCode})));
        Object obj = this.getInternalRouter().inInvoke("rs.sku.getSkuByCode", pmap);
        if (null != obj) {
            return (RsSku)JsonUtil.buildNormalBinder().getJsonToObject(obj.toString(), RsSku.class);
        }
        return null;
    }

    private RsSku getRsSkuByno(String skuNo, String tenantCode) {
        HashMap<String, String> pmap = new HashMap<String, String>();
        pmap.put("skuNo", skuNo);
        pmap.put("tenantCode", tenantCode);
        Object obj = this.getInternalRouter().inInvoke("rs.sku.getSkuBySkuNo", pmap);
        if (null != obj) {
            return (RsSku)JsonUtil.buildNormalBinder().getJsonToObject(obj.toString(), RsSku.class);
        }
        return null;
    }

    public OcShoppingGoodsDomain getGoodsDomain(String skuCode, String tenantCode) {
        RsSku rsSku = this.getRsSku(skuCode, tenantCode);
        if (null == rsSku) {
            return null;
        }
        RsResourceGoods rsResourceGoods = this.getRsourcesGoods(rsSku.getGoodsCode(), tenantCode);
        if (null == rsResourceGoods) {
            return null;
        }
        OcShoppingGoodsDomain ocShoppingGoodsDomain = new OcShoppingGoodsDomain();
        try {
            BeanUtils.copyAllPropertys((Object)ocShoppingGoodsDomain, (Object)rsResourceGoods);
            BeanUtils.copyAllPropertys((Object)ocShoppingGoodsDomain, (Object)rsSku);
        }
        catch (Exception e) {
            return null;
        }
        return ocShoppingGoodsDomain;
    }

    private PmPromotion getPromotionByCodeWithoutRelatatedData(String tenantCode, String promotionCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("promotionCode", promotionCode);
        PmPromotion pmPromotion = this.getPromotionModelByCode(map);
        return pmPromotion;
    }

    public PmPromotion getPromotionByIdWithoutRelatatedData(Integer promotionId) throws ApiException {
        PmPromotion pmPromotion = this.getPromotionModelById(promotionId);
        return pmPromotion;
    }

    @Override
    public PmPromotion getPromotionByCode(String tenantCode, String promotionCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("promotionCode", promotionCode);
        PmPromotion pmPromotion = this.getPromotionModelByCode(map);
        this.getPromotionReRelatedData(pmPromotion);
        return pmPromotion;
    }

    @Override
    public void deletePromotionByCode(String tenantCode, String promotionCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("promotionCode", promotionCode);
        this.delPromotionModelByCode(map);
    }

    @Override
    public void loadPromotionState() {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("dataState", PromotionConstants.DATA_STATE_0);
        QueryResult<PmPromotion> queryResult = this.queryPromotionPage(param);
        List pmPromotionList = queryResult.getList();
        if (null != pmPromotionList && !pmPromotionList.isEmpty()) {
            for (PmPromotion pmPromotion : pmPromotionList) {
                this.getBatchCouponService().addPutPool(new BatchCouponPutThread(this.getBatchCouponService(), pmPromotion));
            }
        }
        param.put("dataState", PromotionConstants.DATA_STATE_1);
        pmPromotionList = this.queryPromotionPage(param).getList();
        if (null != pmPromotionList && !pmPromotionList.isEmpty()) {
            for (PmPromotion pmPromotion : pmPromotionList) {
                this.getBatchCouponService().addPutPool(new BatchCouponPutThread(this.getBatchCouponService(), pmPromotion));
            }
        }
    }

    @Override
    public Map<String, Object> getPromotionGoods(Map<String, Object> map) {
        String promotionCode;
        HashMap<String, Object> result = new HashMap<String, Object>();
        ArrayList skuList = new ArrayList();
        ArrayList<RsSku> giftGoodsList = new ArrayList<RsSku>();
        String tenantCode = map.get("tenantCode").toString();
        PmPromotion pmPromotion = this.getPromotionByCodeWithoutRelatatedData(tenantCode, promotionCode = map.get("promotionCode").toString());
        if (null != pmPromotion) {
            QueryResult<PmPromotionDiscountlist> discountlistQueryResult;
            PmPromotionDiscount pmPromotionDiscount;
            QueryResult<PmPromotionDiscount> discountQueryResult;
            List rsSkuList;
            Integer rangeType = pmPromotion.getRangeType();
            HashMap<String, Object> goodsMap = new HashMap<String, Object>();
            String page = map.get("page").toString();
            String rows = map.get("rows").toString();
            goodsMap.put("page", Long.valueOf(page).intValue());
            goodsMap.put("rows", Long.valueOf(rows).intValue());
            goodsMap.put("startRow", Long.valueOf(Long.valueOf(rows).intValue() * (Long.valueOf(page).intValue() - 1)).intValue());
            goodsMap.put("endRow", Long.valueOf(Long.valueOf(rows).intValue() * Long.valueOf(page).intValue()).intValue());
            goodsMap.put("order", true);
            goodsMap.put("fuzzy", true);
            goodsMap.put("tenantCode", tenantCode);
            ArrayList<String> rangeCodeList = new ArrayList<String>();
            if (!rangeType.equals(PromotionConstants.RANGE_TYPE_0)) {
                QueryResult<PmPromotionRangelist> rangelistQueryResult = this.pmPromotionRangelistService.queryPromotionRangelistPage(this.getQueryMapParam("promotionCode,tenantCode", new Object[]{promotionCode, tenantCode}));
                if (null != rangelistQueryResult && null != rangelistQueryResult.getList() && rangelistQueryResult.getList().size() > 0) {
                    for (PmPromotionRangelist pmPromotionRangelist : rangelistQueryResult.getList()) {
                        rangeCodeList.add(pmPromotionRangelist.getRangeCode());
                    }
                }
                if (rangeCodeList.size() > 0) {
                    if (rangeType.equals(PromotionConstants.RANGE_TYPE_1)) {
                        goodsMap.put("memberCode", rangeCodeList);
                    } else if (rangeType.equals(PromotionConstants.RANGE_TYPE_2)) {
                        goodsMap.put("pntreeCode", rangeCodeList);
                    } else if (rangeType.equals(PromotionConstants.RANGE_TYPE_3)) {
                        goodsMap.put("brandCode", rangeCodeList);
                    } else if (rangeType.equals(PromotionConstants.RANGE_TYPE_4)) {
                        goodsMap.put("classtreeCode", rangeCodeList);
                    } else if (rangeType.equals(PromotionConstants.RANGE_TYPE_5)) {
                        goodsMap.put("skuCode", rangeCodeList);
                    }
                }
            }
            HashMap<String, String> pmap = new HashMap<String, String>();
            pmap.put("map", JsonUtil.buildNormalBinder().toJson(goodsMap));
            Object obj = this.getInternalRouter().inInvoke("rs.sku.querySkuByPntreeCode", pmap);
            if (null != obj && null != (rsSkuList = (List)JsonUtil.buildNormalBinder().getJsonToList(obj.toString(), RsSku.class)) && rsSkuList.size() > 0) {
                for (RsSku rsSku : rsSkuList) {
                    RsResourceGoods rsResourceGoods = this.getRsourcesGoods(rsSku.getGoodsCode(), rsSku.getTenantCode());
                    if (null == rsResourceGoods) continue;
                    rsSku.setGoodsName(rsResourceGoods.getGoodsName());
                }
                skuList.addAll(rsSkuList);
            }
            if ("0001".equals(pmPromotion.getPbCode()) && null != (discountQueryResult = this.pmPromotionDiscountService.queryPromotionDiscountPage(this.getQueryParamMap("promotionCode,tenantCode", new Object[]{promotionCode, tenantCode}))) && null != discountQueryResult.getList() && (pmPromotionDiscount = (PmPromotionDiscount)discountQueryResult.getList().get(0)).getDiscType() == PromotionConstants.DISCOUNT_TYPE_5 && null != (discountlistQueryResult = this.pmPromotionDiscountlistService.queryPromotionDiscountlistPage(this.getQueryParamMap("ppdCode,tenantCode", new Object[]{pmPromotionDiscount.getPpdCode(), tenantCode}))) && null != discountlistQueryResult.getList()) {
                List promotionDiscountlists = discountlistQueryResult.getList();
                for (PmPromotionDiscountlist pmPromotionDiscountlist : promotionDiscountlists) {
                    RsSku rsSku = this.getRsSku(pmPromotionDiscountlist.getDiscountCode(), pmPromotionDiscountlist.getTenantCode());
                    if (null == rsSku) continue;
                    RsResourceGoods rsResourceGoods = this.getRsourcesGoods(rsSku.getGoodsCode(), pmPromotionDiscountlist.getTenantCode());
                    if (null != rsResourceGoods) {
                        rsSku.setGoodsName(rsResourceGoods.getGoodsName());
                    }
                    giftGoodsList.add(rsSku);
                }
            }
        }
        result.put("promotion", pmPromotion);
        result.put("skuList", skuList);
        result.put("giftGoods", giftGoodsList);
        return result;
    }

    @Override
    public void loadPromotionIn() {
        QueryResult<PmPromotionIn> qpmlist = this.pmPromotionInService.queryPromotionInPage(null);
        if (null == qpmlist || ListUtil.isEmpty((Collection)qpmlist.getList())) {
            DisUtil.delMap((String)"pm-promotion_condition", (String[])new String[0]);
            DisUtil.delMap((String)"pm-promotion_discount", (String[])new String[0]);
            DisUtil.delMap((String)"pm-promotion_discountlist", (String[])new String[0]);
            DisUtil.delMap((String)"pm-promotion_rangelist", (String[])new String[0]);
            DisUtil.delMap((String)"pm-promotion_targetlist", (String[])new String[0]);
            DisUtil.delMap((String)"pm-promotion_terminal", (String[])new String[0]);
            DisUtil.delMap((String)"pm-promotion", (String[])new String[0]);
            DisUtil.delMap((String)"pm-promotionin", (String[])new String[0]);
            DisUtil.delMap((String)"pm-promotion_mem", (String[])new String[0]);
            DisUtil.delMap((String)"pm-promotion_dis", (String[])new String[0]);
            return;
        }
        for (PmPromotionIn pmPromotionIn : qpmlist.getList()) {
            String cacheKey = pmPromotionIn.getPromotionCode() + "-" + pmPromotionIn.getTenantCode();
            String json = DisUtil.getRemotMap((String)"pm-promotion", (String)cacheKey);
            if (StringUtils.isNotBlank((String)json)) continue;
            PmPromotionInDomain pmPromotionInDomain = new PmPromotionInDomain();
            try {
                BeanUtils.copyAllPropertys((Object)pmPromotionInDomain, (Object)pmPromotionIn);
            }
            catch (Exception e) {
                this.logger.error("pm.PROMOTION.PmPromotionServiceImpl.loadPromotionIn.pmPromotionInDomain", (Throwable)e);
                return;
            }
            this.loadInDomainCache(pmPromotionInDomain);
        }
    }

    private List<PmPromotionInDomain> queryPmBySku(SkuBean skuBean, String promotionInType) {
        if (null == skuBean) {
            return null;
        }
        if (StringUtils.isBlank((String)promotionInType)) {
            promotionInType = "0";
        }
        String promotionInListKey = skuBean.getTenantCode() + "-" + promotionInType;
        ArrayList<PmPromotionInDomain> pmPromotionInDomainList = new ArrayList<PmPromotionInDomain>();
        List memPmPromotionInDomainList = DisUtil.getMapListJson((String)"pm-promotionin", (String)(promotionInListKey + "-" + skuBean.getMemberCode()), PmPromotionInDomain.class);
        this.makeReList(pmPromotionInDomainList, memPmPromotionInDomainList, skuBean);
        memPmPromotionInDomainList = DisUtil.getMapListJson((String)"pm-promotionin", (String)(promotionInListKey + "-all"), PmPromotionInDomain.class);
        this.makeReList(pmPromotionInDomainList, memPmPromotionInDomainList, skuBean);
        if (ListUtil.isEmpty(pmPromotionInDomainList)) {
            return null;
        }
        return pmPromotionInDomainList;
    }

    private void makeReList(List<PmPromotionInDomain> pmPromotionInDomainList, List<PmPromotionInDomain> memPmPromotionInDomainList, SkuBean skuBean) {
        if (ListUtil.isEmpty(memPmPromotionInDomainList) || null == pmPromotionInDomainList) {
            return;
        }
        for (PmPromotionInDomain pmPromotionInDomain : memPmPromotionInDomainList) {
            if (!this.checkPm(pmPromotionInDomain, skuBean)) continue;
            pmPromotionInDomainList.add(pmPromotionInDomain);
        }
    }

    private boolean checkPm(PmPromotionInDomain pmPromotionInDomain, SkuBean skuBean) {
        if (null == pmPromotionInDomain) {
            return false;
        }
        if (null == skuBean) {
            return true;
        }
        if (DateUtils.compareDate((Date)pmPromotionInDomain.getPromotionEndtime(), (Date)this.getSysDate()) >= 0) {
            this.logger.error("pm.PROMOTION.PmPromotionServiceImpl.checkPm.date", (Object)(pmPromotionInDomain.getPromotionCode() + "-" + pmPromotionInDomain.getTargetCode()));
            return true;
        }
        if (!this.checkBasePm(pmPromotionInDomain, skuBean.getPmCheckBean())) {
            this.logger.error("pm.PROMOTION.PmPromotionServiceImpl.checkPm.checkBasePm", (Object)(pmPromotionInDomain.getPromotionCode() + "-" + pmPromotionInDomain.getTargetCode()));
            return false;
        }
        if (null != pmPromotionInDomain.getRangeType() && pmPromotionInDomain.getRangeType().intValue() != PromotionConstants.RANGE_TYPE_0.intValue()) {
            String value = "";
            String rangeCode = pmPromotionInDomain.getRangeCode();
            if (pmPromotionInDomain.getRangeType().intValue() != PromotionConstants.RANGE_TYPE_1.intValue()) {
                if (pmPromotionInDomain.getRangeType().intValue() == PromotionConstants.RANGE_TYPE_2.intValue()) {
                    value = skuBean.getPntreeCode();
                } else if (pmPromotionInDomain.getRangeType().intValue() == PromotionConstants.RANGE_TYPE_3.intValue()) {
                    value = skuBean.getBrandCode();
                } else if (pmPromotionInDomain.getRangeType().intValue() == PromotionConstants.RANGE_TYPE_4.intValue()) {
                    value = skuBean.getClasstreeCode();
                } else if (pmPromotionInDomain.getRangeType().intValue() == PromotionConstants.RANGE_TYPE_5.intValue()) {
                    value = skuBean.getSkuNo();
                }
            }
            if (StringUtils.isBlank((String)value)) {
                this.logger.error("pm.PROMOTION.PmPromotionServiceImpl.checkPm.rangeCodevaluenull");
                return true;
            }
            if (StringUtils.isBlank((String)rangeCode)) {
                this.logger.error("pm.PROMOTION.PmPromotionServiceImpl.checkPm.rangeCodenull");
                return false;
            }
            if (rangeCode.indexOf("|" + value + "|") < 0) {
                this.logger.error("pm.PROMOTION.PmPromotionServiceImpl.checkPm.rangeCodecheck", (Object)(pmPromotionInDomain.getPromotionCode() + "-" + pmPromotionInDomain.getTenantCode() + "=" + value + "=" + rangeCode));
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean checkBasePm(PmPromotionInDomain pmPromotionInDomain, PmCheckBean pmCheckBean) {
        if (null == pmCheckBean || null == pmPromotionInDomain) {
            return false;
        }
        if (null != pmPromotionInDomain.getTargetType() && pmPromotionInDomain.getTargetType().intValue() != PromotionConstants.TARGET_TYPE_0.intValue()) {
            String value;
            if (null == pmCheckBean.getUserBean() || MapUtil.isEmpty(pmCheckBean.getUserBean().getUserMap())) {
                this.logger.error("pm.PROMOTION.PmPromotionServiceImpl.checkBasePm.userMap", (Object)(pmPromotionInDomain.getPromotionCode() + "-" + pmPromotionInDomain.getTargetCode()));
                return false;
            }
            String targetCode = pmPromotionInDomain.getTargetCode();
            if (StringUtils.isBlank((String)targetCode)) {
                this.logger.error("pm.PROMOTION.PmPromotionServiceImpl.checkBasePm.targetCode", (Object)(pmPromotionInDomain.getPromotionCode() + "-" + pmPromotionInDomain.getTargetCode()));
                return false;
            }
            if (pmPromotionInDomain.getTargetType().intValue() == PromotionConstants.TARGET_TYPE_5.intValue()) {
                value = pmCheckBean.getUserBean() == null ? "" : pmCheckBean.getUserBean().getMemberCode();
            } else {
                String cacheKey = pmPromotionInDomain.getPromotionCode() + "-" + pmPromotionInDomain.getTenantCode();
                List pmPromotionTargetlistList = DisUtil.getMapListJson((String)"pm-promotion_targetlist", (String)cacheKey, PmPromotionTargetlist.class);
                if (ListUtil.isEmpty((Collection)pmPromotionTargetlistList)) {
                    this.logger.error("pm.PROMOTION.PmPromotionServiceImpl.checkBasePm.pmPromotionTargetlistList", (Object)(pmPromotionInDomain.getPromotionCode() + "-" + pmPromotionInDomain.getTargetCode()));
                    return false;
                }
                value = (String)pmCheckBean.getUserBean().getUserMap().get(((PmPromotionTargetlist)pmPromotionTargetlistList.get(0)).getPptlType());
            }
            if (StringUtils.isBlank((String)value)) {
                this.logger.error("pm.PROMOTION.PmPromotionServiceImpl.checkBasePm.value", (Object)(pmPromotionInDomain.getPromotionCode() + "-" + pmPromotionInDomain.getTargetCode() + "=" + pmCheckBean.getUserBean().getUserMap().toString()));
                return false;
            }
            if (targetCode.indexOf("|" + value + "|") < 0) {
                this.logger.error("pm.PROMOTION.PmPromotionServiceImpl.checkBasePm.value", (Object)(pmPromotionInDomain.getPromotionCode() + "-" + pmPromotionInDomain.getTargetCode() + "=" + value + "=" + pmCheckBean.getUserBean().getUserMap().toString()));
                return false;
            }
        }
        if (null != pmPromotionInDomain.getPromotionDis() && pmPromotionInDomain.getPromotionDis() == 1) {
            String channelCode = pmPromotionInDomain.getChannelCode();
            if (StringUtils.isBlank((String)channelCode)) {
                this.logger.error("pm.PROMOTION.PmPromotionServiceImpl.checkBasePm.channelCodenull");
                return false;
            }
            if (StringUtils.isBlank((String)pmCheckBean.getChannelCode())) {
                this.logger.error("pm.PROMOTION.PmPromotionServiceImpl.checkBasePm.skunull");
                return false;
            }
            if (channelCode.indexOf("|" + pmCheckBean.getChannelCode() + "|") < 0) {
                this.logger.error("pm.PROMOTION.PmPromotionServiceImpl.checkBasePm.channelCodecheck", (Object)(pmPromotionInDomain.getPromotionCode() + "-" + pmPromotionInDomain.getTargetCode() + "=" + pmCheckBean.getChannelCode() + "=" + channelCode));
                return false;
            }
        }
        if (null != pmPromotionInDomain.getPromotionTer() && pmPromotionInDomain.getPromotionTer() == 1) {
            String promotionTerstr = pmPromotionInDomain.getPromotionTerstr();
            if (StringUtils.isBlank((String)promotionTerstr)) {
                this.logger.error("pm.PROMOTION.PmPromotionServiceImpl.checkBasePm.promotionTerstrnull");
                return false;
            }
            if (StringUtils.isBlank((String)pmCheckBean.getProappCode())) {
                this.logger.error("pm.PROMOTION.PmPromotionServiceImpl.checkBasePm.proappCodenull");
                return false;
            }
            if (promotionTerstr.indexOf("|" + pmCheckBean.getProappCode() + "|") < 0) {
                this.logger.error("pm.PROMOTION.PmPromotionServiceImpl.checkBasePm.promotionTerstrcheck", (Object)(pmPromotionInDomain.getPromotionCode() + "-" + pmPromotionInDomain.getTargetCode() + "=" + pmCheckBean.getProappCode() + "=" + promotionTerstr));
                return false;
            }
        }
        return true;
    }

    @Override
    public List<PmPromotionInDomain> queryPromotionPmBySku(SkuBean skuBean) {
        if (null == skuBean) {
            return null;
        }
        return this.queryPmBySku(skuBean, "0");
    }

    @Override
    public List<PmPromotionInDomain> queryPromotionConBySku(SkuBean skuBean) {
        if (null == skuBean) {
            return null;
        }
        return this.queryPmBySku(skuBean, "1");
    }

    @Override
    public void updateSendNum(String tenantCode, String promotionCode, int num) throws ApiException {
        this.updateSendNumPromotionModel(tenantCode, promotionCode, num);
        this.pmPromotionInService.updateSendNum(tenantCode, promotionCode, num);
        String cacheKey = promotionCode + "-" + tenantCode;
        PmPromotionInDomain pmPromotionInDomain = (PmPromotionInDomain)DisUtil.getMapJson((String)"pm-promotion", (String)cacheKey, PmPromotionInDomain.class);
        if (null != pmPromotionInDomain) {
            if (null == pmPromotionInDomain.getCouponOnceNumd()) {
                pmPromotionInDomain.setCouponOnceNumd(0);
            }
            pmPromotionInDomain.setCouponOnceNumd(pmPromotionInDomain.getCouponOnceNumd() + 1);
            DisUtil.setMapVer((String)"pm-promotion", (String)cacheKey, (String)JsonUtil.buildNormalBinder().toJson((Object)pmPromotionInDomain));
        }
    }

    private List<PromotionForOcReDomain> makePromotionList(List<PmPromotionInDomain> pmPromotionInDomainList) {
        if (ListUtil.isEmpty(pmPromotionInDomainList)) {
            return null;
        }
        ArrayList<PromotionForOcReDomain> pmPromotionList = new ArrayList<PromotionForOcReDomain>();
        for (PmPromotionInDomain pmPromotionInDomain : pmPromotionInDomainList) {
            PromotionForOcReDomain promotionForOcReDomain = new PromotionForOcReDomain();
            promotionForOcReDomain.setPbCode(pmPromotionInDomain.getPbCode());
            promotionForOcReDomain.setPbName(pmPromotionInDomain.getPbName());
            promotionForOcReDomain.setPromotionCode(pmPromotionInDomain.getPromotionCode());
            promotionForOcReDomain.setPromotionName(pmPromotionInDomain.getPromotionName());
            promotionForOcReDomain.setTenantCode(pmPromotionInDomain.getTenantCode());
            pmPromotionList.add(promotionForOcReDomain);
        }
        return pmPromotionList;
    }

    @Override
    public List<OcShoppingDomain> checkPromotionForShoppingList(List<OcShoppingDomain> ocShoppingDomainList, PmCheckBean pmCheckBean) {
        if (ListUtil.isEmpty(ocShoppingDomainList) || null == pmCheckBean) {
            return null;
        }
        if (ListUtil.isEmpty(ocShoppingDomainList = this.makePmGoods(ocShoppingDomainList, pmCheckBean))) {
            return null;
        }
        for (OcShoppingDomain ocShoppingDomain : ocShoppingDomainList) {
            if (null == ocShoppingDomain || ListUtil.isEmpty(ocShoppingDomain.getShoppingpackageList())) continue;
            for (OcShoppingpackgeDomain ocShoppingpackgeDomain : ocShoppingDomain.getShoppingpackageList()) {
                ocShoppingpackgeDomain.setPmCheckBean(pmCheckBean);
                if (null == this.calcPm(ocShoppingpackgeDomain)) continue;
                ocShoppingpackgeDomain.setGoodsPmoney(ocShoppingpackgeDomain.getDisMoney());
            }
        }
        return ocShoppingDomainList;
    }

    private String getNextMsg(PmPromotionDiscount pmPromotionDiscount, BigDecimal amout, String op) {
        if (null == pmPromotionDiscount) {
            return "";
        }
        DecimalFormat df2 = new DecimalFormat("#.00");
        String disNextMsg = "\u8fd8\u5dee" + df2.format(pmPromotionDiscount.getDiscStart().subtract(amout)) + op + ",\u53ef\u4eab\u53d7";
        if (pmPromotionDiscount.getDiscType() == PromotionConstants.DISCOUNT_TYPE_0) {
            disNextMsg = disNextMsg + df2.format(pmPromotionDiscount.getDiscAmount()) + "\u4e00\u53e3\u4ef7";
        } else if (pmPromotionDiscount.getDiscType() == PromotionConstants.DISCOUNT_TYPE_1) {
            disNextMsg = disNextMsg + df2.format(pmPromotionDiscount.getDiscAmount().multiply(new BigDecimal("100"))) + "\u6298";
        } else if (pmPromotionDiscount.getDiscType() == PromotionConstants.DISCOUNT_TYPE_2) {
            disNextMsg = disNextMsg + df2.format(pmPromotionDiscount.getDiscAmount()) + "\u8fd4\u73b0";
        } else if (pmPromotionDiscount.getDiscType() == PromotionConstants.DISCOUNT_TYPE_3) {
            disNextMsg = disNextMsg + df2.format(pmPromotionDiscount.getDiscAmount()) + "\u4f18\u60e0";
        } else if (pmPromotionDiscount.getDiscType() == PromotionConstants.DISCOUNT_TYPE_4) {
            disNextMsg = disNextMsg + "\u5305\u90ae";
        } else if (pmPromotionDiscount.getDiscType() == PromotionConstants.DISCOUNT_TYPE_5) {
            disNextMsg = disNextMsg + "\u8d60\u54c1";
        }
        return disNextMsg;
    }

    private OcShoppingpackgeDomain calcPm(OcShoppingpackgeDomain ocShoppingpackgeDomain) {
        if (null == ocShoppingpackgeDomain || StringUtils.isBlank((String)ocShoppingpackgeDomain.getPromotionCode())) {
            return ocShoppingpackgeDomain;
        }
        this.calBasePm(ocShoppingpackgeDomain, false);
        return ocShoppingpackgeDomain;
    }

    private PmCalcBean calBasePm(PmCalcBean pmCalcBean, boolean checkFlag) {
        PmPromotionDiscount nextPmPromotionDiscount;
        PmPromotionInDomain pmPromotionInDomain;
        BigDecimal sumNum;
        if (null == pmCalcBean) {
            return null;
        }
        if (StringUtils.isBlank((String)pmCalcBean.getPromotionCode())) {
            return pmCalcBean;
        }
        String cacheKey = pmCalcBean.getPromotionCode() + "-" + pmCalcBean.getTenantCode();
        BigDecimal sumMoney = pmCalcBean.getSumMoney();
        if (null == sumMoney) {
            sumMoney = BigDecimal.ZERO;
        }
        if (null == (sumNum = pmCalcBean.getSumNum())) {
            sumNum = BigDecimal.ZERO;
        }
        if (null == (pmPromotionInDomain = (PmPromotionInDomain)DisUtil.getMapJson((String)"pm-promotion", (String)cacheKey, PmPromotionInDomain.class))) {
            pmCalcBean.setPromotionCode("");
            this.logger.error("========1.1===========");
            return null;
        }
        PmPromotionCondition pmPromotionCondition = null;
        List list = DisUtil.getMapListJson((String)"pm-promotion_condition", (String)cacheKey, PmPromotionCondition.class);
        if (ListUtil.isNotEmpty((Collection)list)) {
            pmPromotionCondition = (PmPromotionCondition)list.get(0);
        }
        if (null == pmPromotionCondition) {
            return null;
        }
        BigDecimal amout = BigDecimal.ZERO;
        if (pmPromotionCondition.getCondConstraint() == PromotionConstants.CONDITION_CONSTRAINT_TYPE_0) {
            amout = sumMoney;
        } else if (pmPromotionCondition.getCondConstraint() == PromotionConstants.CONDITION_CONSTRAINT_TYPE_1) {
            amout = sumNum;
        }
        if (null == amout) {
            amout = BigDecimal.ZERO;
        }
        if (null == pmPromotionCondition.getCondAmount()) {
            pmPromotionCondition.setCondAmount(BigDecimal.ZERO);
        }
        String op = "\u5143";
        String opmsg = "";
        List dislists = DisUtil.getMapListJson((String)"pm-promotion_discount", (String)cacheKey, PmPromotionDiscount.class);
        if (ListUtil.isEmpty((Collection)dislists)) {
            return null;
        }
        if (pmPromotionCondition.getCondType() == PromotionConstants.CONDITION_TYPE_0) {
            op = "\u5143";
            if (amout.compareTo(pmPromotionCondition.getCondAmount()) < 0) {
                PmPromotionDiscount nextPmPromotionDiscount2 = (PmPromotionDiscount)dislists.get(0);
                pmCalcBean.setDisNextMsg(this.getNextMsg(nextPmPromotionDiscount2, amout, op));
                this.logger.error("========1.8===========");
                return null;
            }
        } else if (pmPromotionCondition.getCondType() == PromotionConstants.CONDITION_TYPE_1) {
            op = "\u4ef6";
            if (sumNum.compareTo(pmPromotionCondition.getCondAmount()) <= 0) {
                PmPromotionDiscount nextPmPromotionDiscount3 = (PmPromotionDiscount)dislists.get(0);
                pmCalcBean.setDisNextMsg(this.getNextMsg(nextPmPromotionDiscount3, amout, op));
                this.logger.error("========1.9===========");
                return null;
            }
        }
        PmPromotionDiscount nowPmPromotionDiscount = null;
        for (int i = 0; i < dislists.size(); ++i) {
            PmPromotionDiscount pmPromotionDiscount = (PmPromotionDiscount)dislists.get(i);
            if (null == pmPromotionDiscount.getDiscStart()) {
                pmPromotionDiscount.setDiscStart(BigDecimal.ZERO);
            }
            if (null == pmPromotionDiscount.getDiscEnd()) {
                pmPromotionDiscount.setDiscEnd(BigDecimal.ZERO);
            }
            if (pmPromotionDiscount.getDiscStart().compareTo(new BigDecimal("-1")) != 0 && (amout.compareTo(pmPromotionDiscount.getDiscStart()) < 0 || amout.compareTo(pmPromotionDiscount.getDiscEnd()) >= 0 && pmPromotionDiscount.getDiscEnd().compareTo(new BigDecimal("-1")) != 0)) continue;
            nowPmPromotionDiscount = pmPromotionDiscount;
            if (i >= dislists.size() - 1) break;
            nextPmPromotionDiscount = (PmPromotionDiscount)dislists.get(i + 1);
            pmCalcBean.setDisNextMsg(this.getNextMsg(nextPmPromotionDiscount, amout, op));
            break;
        }
        if (null == nowPmPromotionDiscount) {
            nextPmPromotionDiscount = (PmPromotionDiscount)dislists.get(0);
            pmCalcBean.setDisNextMsg(this.getNextMsg(nextPmPromotionDiscount, amout, op));
            this.logger.error("========1.10===========");
            return null;
        }
        DecimalFormat df2 = new DecimalFormat("#.00");
        if (null == nowPmPromotionDiscount.getDiscAmount()) {
            nowPmPromotionDiscount.setDiscAmount(BigDecimal.ZERO);
        }
        pmCalcBean.setDiscType(nowPmPromotionDiscount.getDiscType());
        pmCalcBean.setAve(true);
        if (nowPmPromotionDiscount.getDiscType() == PromotionConstants.DISCOUNT_TYPE_0) {
            pmCalcBean.setDisMoney(pmCalcBean.getSumMoney().subtract(nowPmPromotionDiscount.getDiscAmount()));
            opmsg = opmsg + df2.format(nowPmPromotionDiscount.getDiscAmount()) + "\u4e00\u53e3\u4ef7";
        } else if (nowPmPromotionDiscount.getDiscType() == PromotionConstants.DISCOUNT_TYPE_1) {
            pmCalcBean.setDisMoney(pmCalcBean.getSumMoney().subtract(pmCalcBean.getSumMoney().multiply(nowPmPromotionDiscount.getDiscAmount())));
            opmsg = opmsg + df2.format(nowPmPromotionDiscount.getDiscAmount().multiply(new BigDecimal("100"))) + "\u6298";
        } else if (nowPmPromotionDiscount.getDiscType() == PromotionConstants.DISCOUNT_TYPE_2) {
            pmCalcBean.setDisMoney(nowPmPromotionDiscount.getDiscAmount());
            opmsg = opmsg + df2.format(nowPmPromotionDiscount.getDiscAmount()) + "\u8fd4\u73b0";
        } else if (nowPmPromotionDiscount.getDiscType() == PromotionConstants.DISCOUNT_TYPE_3) {
            pmCalcBean.setDisMoney(nowPmPromotionDiscount.getDiscAmount());
            opmsg = opmsg + df2.format(nowPmPromotionDiscount.getDiscAmount()) + "\u4f18\u60e0";
        } else if (nowPmPromotionDiscount.getDiscType() == PromotionConstants.DISCOUNT_TYPE_4) {
            pmCalcBean.setAve(false);
            opmsg = opmsg + "\u5305\u90ae";
        } else if (nowPmPromotionDiscount.getDiscType() == PromotionConstants.DISCOUNT_TYPE_5) {
            pmCalcBean.setAve(false);
            opmsg = opmsg + "\u8d60\u54c1";
            List promotionDiscountlists = DisUtil.getMapListJson((String)"pm-promotion_discountlist", (String)(cacheKey + "-" + nowPmPromotionDiscount.getPpdCode()), PmPromotionDiscountlist.class);
            if (ListUtil.isEmpty((Collection)promotionDiscountlists)) {
                return pmCalcBean;
            }
            if (checkFlag) {
                if (MapUtil.isEmpty(pmCalcBean.getSkuNoMap())) {
                    return null;
                }
                for (PmPromotionDiscountlist pmPromotionDiscountlist : promotionDiscountlists) {
                    if (!StringUtils.isBlank((String)pmCalcBean.getSkuNoMap().remove(pmPromotionDiscountlist.getDiscountCode()))) continue;
                    return null;
                }
                if (MapUtil.isNotEmpty(pmCalcBean.getSkuNoMap())) {
                    return null;
                }
            } else {
                pmCalcBean.setGiftList(this.makeShopGiftGoodsList(promotionDiscountlists));
            }
        }
        if (pmPromotionInDomain.getPromotionMoling() == PromotionConstants.MOLING_1) {
            pmCalcBean.setDisMoney(new BigDecimal(df2.format(pmCalcBean.getDisMoney().intValue())));
        } else {
            pmCalcBean.setDisMoney(new BigDecimal(df2.format(pmCalcBean.getDisMoney())));
        }
        pmCalcBean.setDisMsg(opmsg);
        return pmCalcBean;
    }

    private List<PmGoodsBean> makeShopGiftGoodsList(List<PmPromotionDiscountlist> promotionDiscountlists) {
        if (ListUtil.isEmpty(promotionDiscountlists)) {
            return null;
        }
        ArrayList<PmGoodsBean> pmGoodsBeanList = new ArrayList<PmGoodsBean>();
        for (PmPromotionDiscountlist pmPromotionDiscountlist : promotionDiscountlists) {
            RsSku rsSku = this.getRsSkuByno(pmPromotionDiscountlist.getDiscountCode(), pmPromotionDiscountlist.getTenantCode());
            if (null == rsSku) continue;
            RsResourceGoods rsResourceGoods = this.getRsourcesGoods(rsSku.getGoodsCode(), pmPromotionDiscountlist.getTenantCode());
            PmGoodsBean pmGoodsBean = new PmGoodsBean();
            try {
                BeanUtils.copyAllPropertys((Object)pmGoodsBean, (Object)rsResourceGoods);
                BeanUtils.copyAllPropertys((Object)pmGoodsBean, (Object)rsSku);
                pmGoodsBean.setPricesetNprice(null);
                pmGoodsBean.setPricesetPrefprice(null);
                pmGoodsBeanList.add(pmGoodsBean);
            }
            catch (Exception e) {}
        }
        return pmGoodsBeanList;
    }

    private void makePmGoods(OcShoppingpackgeDomain ocShoppingpackgeDomain, OcShoppingDomain ocShoppingDomain, Map<String, OcShoppingpackgeDomain> pmMap, PmCheckBean pmCheckBean, List<OcShoppingpackgeDomain> pmshoppingpackageList) {
        if (null == ocShoppingpackgeDomain || null == pmCheckBean || null == pmMap || null == ocShoppingDomain || null == pmshoppingpackageList) {
            return;
        }
        List<OcShoppingGoodsDomain> ocShoppingGoodsDomainList = ocShoppingpackgeDomain.getShoppingGoodsList();
        if (ListUtil.isEmpty(ocShoppingGoodsDomainList)) {
            return;
        }
        List<PmPromotionInDomain> pmPromotionInDomainList = null;
        String promotionCode = "";
        String key = "";
        String promotionName = "";
        String pbName = "";
        String pbCode = "";
        String promotionInType = "";
        boolean zp = false;
        for (OcShoppingGoodsDomain ocShoppingGoodsDomain : ocShoppingGoodsDomainList) {
            List<OcShoppingGoodsDomain> pmList;
            zp = false;
            if (null == ocShoppingGoodsDomain.getPricesetNprice() || ocShoppingGoodsDomain.getPricesetNprice().compareTo(BigDecimal.ZERO) == 0) {
                zp = true;
            }
            if (!zp) {
                SkuBean skuBean = this.makeSkuBean(pmCheckBean, ocShoppingGoodsDomain);
                if (null == skuBean) {
                    return;
                }
                pmPromotionInDomainList = this.queryPmBySku(skuBean, "0");
            }
            promotionCode = ocShoppingGoodsDomain.getShoppingGoodsPm();
            if (!zp && ListUtil.isEmpty(pmPromotionInDomainList)) {
                key = "";
            } else {
                if (StringUtils.isBlank((String)promotionCode)) {
                    promotionCode = ((PmPromotionInDomain)pmPromotionInDomainList.get(0)).getPromotionCode();
                    promotionName = pmPromotionInDomainList.get(0).getPromotionName();
                    pbCode = pmPromotionInDomainList.get(0).getPbCode();
                    pbName = pmPromotionInDomainList.get(0).getPbName();
                    promotionInType = pmPromotionInDomainList.get(0).getPromotionInType();
                    ocShoppingGoodsDomain.setShoppingGoodsPm(promotionCode);
                } else {
                    PmPromotionInDomain pmPromotionInDomain = (PmPromotionInDomain)DisUtil.getMapJson((String)"pm-promotion", (String)(promotionCode + "-" + ocShoppingGoodsDomain.getTenantCode()), PmPromotionInDomain.class);
                    if (null == pmPromotionInDomain) {
                        key = "";
                        promotionCode = "";
                    } else {
                        promotionName = pmPromotionInDomain.getPromotionName();
                        pbCode = pmPromotionInDomain.getPbCode();
                        pbName = pmPromotionInDomain.getPbName();
                        promotionInType = pmPromotionInDomain.getPromotionInType();
                    }
                }
                key = promotionCode;
            }
            OcShoppingpackgeDomain pmOcShoppingpackgeDomain = pmMap.get(key);
            if (null == pmOcShoppingpackgeDomain) {
                pmOcShoppingpackgeDomain = new OcShoppingpackgeDomain();
                try {
                    BeanUtils.copyAllPropertys((Object)pmOcShoppingpackgeDomain, (Object)ocShoppingDomain);
                    BeanUtils.copyAllPropertys((Object)pmOcShoppingpackgeDomain, (Object)ocShoppingpackgeDomain);
                    pmOcShoppingpackgeDomain.setGoodsPmoney(BigDecimal.ZERO);
                    pmOcShoppingpackgeDomain.setGoodsMoney(BigDecimal.ZERO);
                    pmOcShoppingpackgeDomain.setGoodsNum(BigDecimal.ZERO);
                    pmOcShoppingpackgeDomain.setGoodsWeight(BigDecimal.ZERO);
                    pmOcShoppingpackgeDomain.setPricesetRefrice(BigDecimal.ZERO);
                    pmOcShoppingpackgeDomain.setSumMoney(BigDecimal.ZERO);
                    pmOcShoppingpackgeDomain.setSumWeight(BigDecimal.ZERO);
                    pmOcShoppingpackgeDomain.setSumAveMoney(BigDecimal.ZERO);
                    pmOcShoppingpackgeDomain.setSumRefMoney(BigDecimal.ZERO);
                }
                catch (Exception e) {
                    // empty catch block
                }
                pmshoppingpackageList.add(pmOcShoppingpackgeDomain);
                pmList = new ArrayList<OcShoppingGoodsDomain>();
                pmOcShoppingpackgeDomain.setShoppingGoodsList(pmList);
                pmMap.put(key, pmOcShoppingpackgeDomain);
            } else {
                pmList = pmOcShoppingpackgeDomain.getShoppingGoodsList();
                if (null == pmList) {
                    pmList = new ArrayList<OcShoppingGoodsDomain>();
                    pmOcShoppingpackgeDomain.setShoppingGoodsList(pmList);
                }
            }
            pmOcShoppingpackgeDomain.setPromotionCode(promotionCode);
            pmOcShoppingpackgeDomain.setPromotionName(promotionName);
            pmOcShoppingpackgeDomain.setPbCode(pbCode);
            pmOcShoppingpackgeDomain.setPbName(pbName);
            pmOcShoppingpackgeDomain.setPromotionInType(promotionInType);
            if (null == ocShoppingGoodsDomain.getGoodsCamount()) {
                ocShoppingGoodsDomain.setGoodsCamount(BigDecimal.ZERO);
            }
            if (null == ocShoppingGoodsDomain.getGoodsCweight()) {
                ocShoppingGoodsDomain.setGoodsCweight(BigDecimal.ZERO);
            }
            if (null == ocShoppingGoodsDomain.getPricesetNprice()) {
                ocShoppingGoodsDomain.setPricesetNprice(BigDecimal.ZERO);
            }
            if (null == ocShoppingGoodsDomain.getPricesetRefrice()) {
                ocShoppingGoodsDomain.setPricesetRefrice(BigDecimal.ZERO);
            }
            if (null == pmOcShoppingpackgeDomain.getSumMoney()) {
                pmOcShoppingpackgeDomain.setSumMoney(BigDecimal.ZERO);
            }
            if (null == pmOcShoppingpackgeDomain.getSumNum()) {
                pmOcShoppingpackgeDomain.setSumNum(BigDecimal.ZERO);
            }
            if (null == pmOcShoppingpackgeDomain.getSumWeight()) {
                pmOcShoppingpackgeDomain.setSumWeight(BigDecimal.ZERO);
            }
            if (null == pmOcShoppingpackgeDomain.getSumRefMoney()) {
                pmOcShoppingpackgeDomain.setSumRefMoney(BigDecimal.ZERO);
            }
            if (null == pmOcShoppingpackgeDomain.getGoodsMoney()) {
                pmOcShoppingpackgeDomain.setGoodsMoney(BigDecimal.ZERO);
            }
            if (null == pmOcShoppingpackgeDomain.getPricesetRefrice()) {
                pmOcShoppingpackgeDomain.setPricesetRefrice(BigDecimal.ZERO);
            }
            if (null == pmOcShoppingpackgeDomain.getGoodsNum()) {
                pmOcShoppingpackgeDomain.setGoodsNum(BigDecimal.ZERO);
            }
            if (null == pmOcShoppingpackgeDomain.getGoodsWeight()) {
                pmOcShoppingpackgeDomain.setGoodsWeight(BigDecimal.ZERO);
            }
            if (null == pmOcShoppingpackgeDomain.getGoodsPmoney()) {
                pmOcShoppingpackgeDomain.setGoodsPmoney(BigDecimal.ZERO);
            }
            pmOcShoppingpackgeDomain.setGoodsMoney(pmOcShoppingpackgeDomain.getGoodsMoney().add(ocShoppingGoodsDomain.getPricesetNprice().multiply(ocShoppingGoodsDomain.getGoodsCamount())));
            pmOcShoppingpackgeDomain.setPricesetRefrice(pmOcShoppingpackgeDomain.getPricesetRefrice().add(ocShoppingGoodsDomain.getPricesetRefrice().multiply(ocShoppingGoodsDomain.getGoodsCamount())));
            pmOcShoppingpackgeDomain.setGoodsNum(pmOcShoppingpackgeDomain.getGoodsNum().add(ocShoppingGoodsDomain.getGoodsCamount()));
            pmOcShoppingpackgeDomain.setGoodsWeight(pmOcShoppingpackgeDomain.getGoodsWeight().add(ocShoppingGoodsDomain.getGoodsCweight()));
            if (null == ocShoppingGoodsDomain.getShoppingGoodsCheck() || 0 == ocShoppingGoodsDomain.getShoppingGoodsCheck()) {
                pmOcShoppingpackgeDomain.setSumMoney(pmOcShoppingpackgeDomain.getSumMoney().add(ocShoppingGoodsDomain.getPricesetNprice().multiply(ocShoppingGoodsDomain.getGoodsCamount())));
                pmOcShoppingpackgeDomain.setSumNum(pmOcShoppingpackgeDomain.getSumNum().add(ocShoppingGoodsDomain.getGoodsCamount()));
                pmOcShoppingpackgeDomain.setSumWeight(pmOcShoppingpackgeDomain.getSumWeight().add(ocShoppingGoodsDomain.getGoodsCweight()));
                pmOcShoppingpackgeDomain.setSumRefMoney(pmOcShoppingpackgeDomain.getSumRefMoney().add(ocShoppingGoodsDomain.getPricesetRefrice().multiply(ocShoppingGoodsDomain.getGoodsCamount())));
            }
            pmList.add(ocShoppingGoodsDomain);
            if (zp) continue;
            ocShoppingGoodsDomain.setPmPromotionList(this.makePromotionList(pmPromotionInDomainList));
        }
    }

    public TypeBean getOcSetting(String shoppingType, String tenantCode) {
        String memo;
        OcCflowReDomain ocCflowReDomain;
        TypeBean typeBean = null;
        String json = SupDisUtil.getMap((String)this.CACHE_KEY_CFLOW, (String)(shoppingType + "-" + tenantCode));
        if (StringUtils.isBlank((String)json)) {
            json = SupDisUtil.getMap((String)this.CACHE_KEY_CFLOW, (String)(shoppingType + "-" + "00000000"));
        }
        if (StringUtils.isNotBlank((String)json) && null != (ocCflowReDomain = (OcCflowReDomain)JsonUtil.buildNormalBinder().getJsonToObject(json, OcCflowReDomain.class)) && StringUtils.isNotBlank((String)(memo = ocCflowReDomain.getMemo()))) {
            typeBean = (TypeBean)JsonUtil.buildNormalBinder().getJsonToObject(memo, TypeBean.class);
        }
        return typeBean;
    }

    public boolean checkPm(TypeBean typeBean) {
        if (null == typeBean) {
            return true;
        }
        return StringUtils.isBlank((String)typeBean.getPmpay()) || "0".equals(typeBean.getPmpay());
    }

    private List<OcShoppingDomain> makePmGoods(List<OcShoppingDomain> ocShoppingDomainList, PmCheckBean pmCheckBean) {
        if (ListUtil.isEmpty(ocShoppingDomainList) || null == pmCheckBean) {
            return null;
        }
        for (OcShoppingDomain ocShoppingDomain : ocShoppingDomainList) {
            TypeBean typeBean = this.getOcSetting(ocShoppingDomain.getShoppingType(), ocShoppingDomain.getTenantCode());
            if (null != typeBean) {
                ocShoppingDomain.setScontractBlance(typeBean.getBlance());
                ocShoppingDomain.setScontractPmode(typeBean.getPmode());
                ocShoppingDomain.setIntpay(typeBean.getIntpay());
                ocShoppingDomain.setPmpay(typeBean.getPmpay());
                ocShoppingDomain.setBlance(typeBean.getBlance());
                ocShoppingDomain.setPmode(typeBean.getPmode());
                ocShoppingDomain.setFreight(typeBean.getFreight());
                ocShoppingDomain.setCoppay(typeBean.getCoppay());
                ocShoppingDomain.setUrpay(typeBean.getUrpay());
                ocShoppingDomain.setInvp(typeBean.getInvp());
                ocShoppingDomain.setRef(typeBean.getRef());
                ocShoppingDomain.setReg(typeBean.getReg());
            }
            if (!this.checkPm(typeBean)) continue;
            this.makePackgePmGoods(ocShoppingDomain.getShoppingpackageList(), ocShoppingDomain, pmCheckBean);
        }
        return ocShoppingDomainList;
    }

    private OcShoppingDomain makePackgePmGoods(List<OcShoppingpackgeDomain> ocShoppingpackgeDomainList, OcShoppingDomain ocShoppingDomain, PmCheckBean pmCheckBean) {
        if (ListUtil.isEmpty(ocShoppingpackgeDomainList) || null == ocShoppingDomain || null == pmCheckBean) {
            return null;
        }
        HashMap<String, OcShoppingpackgeDomain> pmMap = new HashMap<String, OcShoppingpackgeDomain>();
        ArrayList<OcShoppingpackgeDomain> pmshoppingpackageList = new ArrayList<OcShoppingpackgeDomain>();
        for (OcShoppingpackgeDomain ocShoppingpackgeDomain : ocShoppingpackgeDomainList) {
            List<OcShoppingGoodsDomain> ocShoppingGoodsDomainList = ocShoppingpackgeDomain.getShoppingGoodsList();
            if (ListUtil.isEmpty(ocShoppingGoodsDomainList)) continue;
            this.makePmGoods(ocShoppingpackgeDomain, ocShoppingDomain, pmMap, pmCheckBean, pmshoppingpackageList);
        }
        ocShoppingDomain.setShoppingpackageList(pmshoppingpackageList);
        return ocShoppingDomain;
    }

    @Override
    public List<PmUserCoupon> checkUserPm(List<PmContractGoodsDomain> pmContractGoodsDomainList, List<PmUserCoupon> pmUserCouponList, PmCheckBean pmCheckBean) {
        if (ListUtil.isEmpty(pmUserCouponList) || null == pmCheckBean || ListUtil.isEmpty(pmContractGoodsDomainList)) {
            return null;
        }
        ArrayList<PmUserCoupon> reList = new ArrayList<PmUserCoupon>();
        for (PmUserCoupon pmUserCoupon : pmUserCouponList) {
            if (null == this.makePmUserCoup(pmContractGoodsDomainList, pmUserCoupon, pmCheckBean)) continue;
            reList.add(pmUserCoupon);
        }
        return reList;
    }

    private PmUserCoupon makePmUserCoup(List<PmContractGoodsDomain> pmContractGoodsDomainList, PmUserCoupon pmUserCoupon, PmCheckBean pmCheckBean) {
        if (null == pmUserCoupon || null == pmCheckBean || ListUtil.isEmpty(pmContractGoodsDomainList)) {
            return null;
        }
        String promotionCode = pmUserCoupon.getPromotionCode();
        if (StringUtils.isBlank((String)promotionCode)) {
            return null;
        }
        HashMap<String, PmCalcBean> pmCalcBeanMap = new HashMap<String, PmCalcBean>();
        ArrayList<PmContractGoodsDomain> avgList = new ArrayList<PmContractGoodsDomain>();
        for (PmContractGoodsDomain pmContractGoodsDomain : pmContractGoodsDomainList) {
            SkuBean skuBean = this.makeSkuBean(pmCheckBean, pmContractGoodsDomain);
            if (null == skuBean) continue;
            this.makeCheckPm(skuBean, avgList, pmCalcBeanMap, promotionCode, pmContractGoodsDomain);
        }
        PmCalcBean pmCalcBean = (PmCalcBean)pmCalcBeanMap.get(promotionCode);
        if (null == pmCalcBean) {
            return null;
        }
        if (null == this.calBasePm(pmCalcBean, true)) {
            return null;
        }
        pmUserCoupon.setCouponAmount(pmCalcBean.getDisMoney());
        return pmUserCoupon;
    }

    static {
        lock = new Object();
    }
}

