/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.pm.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.pm.domain.OcContractSettlDomain;
import com.yqbsoft.laser.service.pm.domain.OrderCallBackBean;
import com.yqbsoft.laser.service.pm.domain.PmCheckBean;
import com.yqbsoft.laser.service.pm.domain.PmContractGoodsDomain;
import com.yqbsoft.laser.service.pm.domain.PmInfoBean;
import com.yqbsoft.laser.service.pm.domain.PmPromotionBaseDomain;
import com.yqbsoft.laser.service.pm.domain.PmPromotionInDomain;
import com.yqbsoft.laser.service.pm.domain.PmUserBean;
import com.yqbsoft.laser.service.pm.domain.PmUserCouponDomain;
import com.yqbsoft.laser.service.pm.domain.PmUserUsecouponDomain;
import com.yqbsoft.laser.service.pm.domain.SkuBean;
import com.yqbsoft.laser.service.pm.domain.ocshop.OcShoppingDomain;
import com.yqbsoft.laser.service.pm.model.PmUserCoupon;
import com.yqbsoft.laser.service.pm.service.PmPromotionEngineService;
import com.yqbsoft.laser.service.pm.service.PmPromotionService;
import com.yqbsoft.laser.service.pm.service.PmUserCouponService;
import com.yqbsoft.laser.service.pm.service.PmUserUsecouponService;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

public class PmPromotionEngineServiceImpl
extends BaseServiceImpl
implements PmPromotionEngineService {
    private static final String SYS_CODE = "pm.PROMOTION.PmPromotionEngineServiceImpl";
    private PmPromotionService pmPromotionService;
    private PmUserCouponService pmUserCouponService;
    private PmUserUsecouponService pmUserUsecouponService;

    public void setPmUserCouponService(PmUserCouponService pmUserCouponService) {
        this.pmUserCouponService = pmUserCouponService;
    }

    public void setPmUserUsecouponService(PmUserUsecouponService pmUserUsecouponService) {
        this.pmUserUsecouponService = pmUserUsecouponService;
    }

    public PmPromotionService getPmPromotionService() {
        return this.pmPromotionService;
    }

    public void setPmPromotionService(PmPromotionService pmPromotionService) {
        this.pmPromotionService = pmPromotionService;
    }

    @Override
    public List<PmPromotionInDomain> queryPromotionPmBySku(SkuBean skuBean) {
        if (null == skuBean) {
            return null;
        }
        return this.pmPromotionService.queryPromotionPmBySku(skuBean);
    }

    @Override
    public List<PmPromotionInDomain> queryPromotionConBySku(SkuBean skuBean) {
        return this.pmPromotionService.queryPromotionConBySku(skuBean);
    }

    @Override
    public String savePromotionUser(PmUserBean pmUserBean) {
        if (null == pmUserBean || null == pmUserBean.getPmCheckBean() || null == pmUserBean.getPmCheckBean().getUserBean()) {
            return null;
        }
        PmPromotionInDomain pmPromotionInDomain = (PmPromotionInDomain)DisUtil.getMapJson((String)"pm-promotion", (String)(pmUserBean.getPromotionCode() + "-" + pmUserBean.getTenantCode()), PmPromotionInDomain.class);
        if (null == pmPromotionInDomain) {
            throw new ApiException("pm.PROMOTION.PmPromotionEngineServiceImpl.savePromotionUser.pmPromotion", "\u5df2\u7ed3\u675f");
        }
        long nowTime = new Date().getTime();
        if (null != pmPromotionInDomain.getReceiveStart() && nowTime < pmPromotionInDomain.getReceiveStart().getTime()) {
            throw new ApiException("pm.PROMOTION.PmPromotionEngineServiceImpl.savePromotionUser.ReceiveStart", "\u9886\u53d6\u4f18\u60e0\u5238\u672a\u5f00\u59cb");
        }
        if (null != pmPromotionInDomain.getReceiveEnd() && nowTime > pmPromotionInDomain.getReceiveEnd().getTime()) {
            throw new ApiException("pm.PROMOTION.PmPromotionEngineServiceImpl.savePromotionUser.ReceiveEnd", "\u9886\u53d6\u4f18\u60e0\u5238\u5df2\u7ecf\u7ed3\u675f");
        }
        PmCheckBean pmCheckBean = pmUserBean.getPmCheckBean();
        if (!this.pmPromotionService.checkBasePm(pmPromotionInDomain, pmCheckBean)) {
            throw new ApiException("pm.PROMOTION.PmPromotionEngineServiceImpl.savePromotionUser.checkBasePm", "\u4fe1\u606f\u4e0d\u5339\u914d");
        }
        PmUserCouponDomain pmUserCouponDomain = this.makeUserCoupon(pmUserBean, pmPromotionInDomain, pmCheckBean);
        if (null == pmUserCouponDomain) {
            throw new ApiException("pm.PROMOTION.PmPromotionEngineServiceImpl.savePromotionUser.pmUserCouponDomain");
        }
        Integer promotionFrequency = pmPromotionInDomain.getPromotionFrequency();
        if (null != promotionFrequency && 0 != promotionFrequency) {
            HashMap<String, Object> param1 = new HashMap<String, Object>();
            param1.put("memberBcode", pmUserCouponDomain.getMemberBcode());
            param1.put("promotionCode", pmPromotionInDomain.getPromotionCode());
            param1.put("tenantCode", pmPromotionInDomain.getTenantCode());
            Integer res1 = this.pmUserCouponService.getCount(param1);
            if (res1 > 0 && res1 >= promotionFrequency) {
                throw new ApiException("pm.PROMOTION.PmPromotionEngineServiceImpl.savePromotionUser.pmPromotionCoupon", "\u5df2\u5230\u9886\u53d6\u4e0a\u9650");
            }
        }
        int num = pmUserBean.getNum();
        this.pmPromotionService.updateSendNum(pmUserBean.getTenantCode(), pmUserBean.getPromotionCode(), num);
        return this.pmUserCouponService.saveUserCoupon(pmUserCouponDomain);
    }

    private PmUserCouponDomain makeUserCoupon(PmUserBean pmUserBean, PmPromotionInDomain pmPromotionInDomain, PmCheckBean pmCheckBean) {
        if (null == pmUserBean || null == pmPromotionInDomain || null == pmCheckBean) {
            return null;
        }
        PmPromotionBaseDomain pmPromotionBaseDomain = (PmPromotionBaseDomain)DisUtil.getMapJson((String)"pm-promotion-base", (String)(pmPromotionInDomain.getPbCode() + "-" + pmUserBean.getTenantCode()), PmPromotionBaseDomain.class);
        if (null == pmPromotionBaseDomain) {
            pmPromotionBaseDomain = (PmPromotionBaseDomain)DisUtil.getMapJson((String)"pm-promotion-base", (String)(pmPromotionInDomain.getPbCode() + "-" + "00000000"), PmPromotionBaseDomain.class);
        }
        if (null == pmPromotionBaseDomain) {
            return null;
        }
        Integer sendtype = pmPromotionInDomain.getSendtype();
        if (null == sendtype) {
            sendtype = 0;
        }
        PmUserCouponDomain pmUserCouponDomain = new PmUserCouponDomain();
        pmUserCouponDomain.setDiscType(pmPromotionInDomain.getDiscType());
        pmUserCouponDomain.setPbLogo(pmPromotionBaseDomain.getPbLogo());
        pmUserCouponDomain.setPbName(pmPromotionBaseDomain.getPbName());
        if (sendtype != 0) {
            pmUserCouponDomain.setCouponAmount(pmUserBean.getAmonut());
        } else {
            pmUserCouponDomain.setCouponAmount(pmPromotionInDomain.getDiscAmount());
        }
        if (null == pmUserBean.getPmCheckBean()) {
            pmUserCouponDomain.setChannelCode(pmUserBean.getPmCheckBean().getChannelCode());
            pmUserCouponDomain.setChannelName(pmUserBean.getPmCheckBean().getChannelName());
        }
        pmUserCouponDomain.setPromotionDis(pmPromotionInDomain.getPromotionDis());
        pmUserCouponDomain.setPromotionDisstr(pmPromotionInDomain.getChannelCode());
        pmUserCouponDomain.setPbCode(pmPromotionInDomain.getPbCode());
        pmUserCouponDomain.setPromotionCode(pmPromotionInDomain.getPromotionCode());
        pmUserCouponDomain.setPromotionName(pmPromotionInDomain.getPromotionName());
        pmUserCouponDomain.setCouponBatch(pmPromotionInDomain.getCouponBatch());
        pmUserCouponDomain.setMemberCode(pmPromotionInDomain.getMemberCode());
        pmUserCouponDomain.setMemberName(pmPromotionInDomain.getMemberName());
        pmUserCouponDomain.setCouponStart(pmPromotionInDomain.getPromotionBegintime());
        pmUserCouponDomain.setCouponEnd(pmPromotionInDomain.getPromotionEndtime());
        pmUserCouponDomain.setChannelCode(pmCheckBean.getChannelCode());
        pmUserCouponDomain.setChannelName(pmCheckBean.getChannelName());
        pmUserCouponDomain.setMemberBcode(pmCheckBean.getUserBean().getMemberCode());
        pmUserCouponDomain.setMemberBname(pmCheckBean.getUserBean().getMemberName());
        pmUserCouponDomain.setUserCode(pmCheckBean.getUserBean().getUserCode());
        pmUserCouponDomain.setUserName(pmCheckBean.getUserBean().getUserName());
        pmUserCouponDomain.setProappCode(pmCheckBean.getProappCode());
        pmUserCouponDomain.setTenantCode(pmCheckBean.getTenantCode());
        return pmUserCouponDomain;
    }

    @Override
    public PmInfoBean checkPm(List<PmContractGoodsDomain> pmContractGoodsDomainList, List<OcContractSettlDomain> ocContractSettlDomainList, PmCheckBean pmCheckBean) {
        return this.pmPromotionService.checkPm(pmContractGoodsDomainList, ocContractSettlDomainList, pmCheckBean);
    }

    @Override
    public List<OcShoppingDomain> checkPromotionForShoppingList(List<OcShoppingDomain> ocShoppingDomainList, PmCheckBean pmCheckBean) {
        return this.pmPromotionService.checkPromotionForShoppingList(ocShoppingDomainList, pmCheckBean);
    }

    @Override
    public List<OcShoppingDomain> checkPromotionForShopping(OcShoppingDomain ocShoppingDomain, PmCheckBean pmCheckBean) {
        if (null == ocShoppingDomain) {
            return null;
        }
        ArrayList<OcShoppingDomain> ocShoppingDomainList = new ArrayList<OcShoppingDomain>();
        ocShoppingDomainList.add(ocShoppingDomain);
        return this.pmPromotionService.checkPromotionForShoppingList(ocShoppingDomainList, pmCheckBean);
    }

    @Override
    public List<PmUserCoupon> queryUserCon(List<PmContractGoodsDomain> pmContractGoodsDomainList, PmCheckBean pmCheckBean) {
        if (null == pmCheckBean || null == pmCheckBean.getUserBean() || StringUtils.isBlank((String)pmCheckBean.getTenantCode())) {
            return null;
        }
        QueryResult<PmUserCoupon> qlist = this.pmUserCouponService.queryUserCouponPage(this.getQueryParamMap("tenantCode,memberCode,dataState", new Object[]{pmCheckBean.getTenantCode(), pmCheckBean.getUserBean().getMemberCode(), 0}));
        if (null == qlist || ListUtil.isEmpty((Collection)qlist.getList())) {
            return null;
        }
        return this.pmPromotionService.checkUserPm(pmContractGoodsDomainList, qlist.getList(), pmCheckBean);
    }

    private List<PmUserUsecouponDomain> makeUsecoupList(List<OrderCallBackBean> orderCallBackBeanList, boolean checkPm) {
        if (ListUtil.isEmpty(orderCallBackBeanList)) {
            return null;
        }
        ArrayList<PmUserUsecouponDomain> pmUserUsecouponDomainList = new ArrayList<PmUserUsecouponDomain>();
        for (OrderCallBackBean orderCallBackBean : orderCallBackBeanList) {
            pmUserUsecouponDomainList.add(this.makeUsecoup(orderCallBackBean, checkPm));
        }
        return pmUserUsecouponDomainList;
    }

    private PmUserUsecouponDomain makeUsecoup(OrderCallBackBean orderCallBackBean, boolean checkPm) {
        if (null == orderCallBackBean) {
            return null;
        }
        PmUserUsecouponDomain pmUserUsecouponDomain = new PmUserUsecouponDomain();
        try {
            if (!checkPm) {
                PmUserCoupon pmUserCoupon = this.pmUserCouponService.getUserCouponByCode(orderCallBackBean.getTenantCode(), orderCallBackBean.getUsercouponCode());
                if (null != pmUserCoupon) {
                    BeanUtils.copyAllPropertys((Object)pmUserUsecouponDomain, (Object)pmUserCoupon);
                }
            } else {
                PmPromotionInDomain pmPromotionInDomain = (PmPromotionInDomain)DisUtil.getMapJson((String)"pm-promotion", (String)(orderCallBackBean.getUsercouponCode() + "-" + orderCallBackBean.getTenantCode()), PmPromotionInDomain.class);
                if (null != pmPromotionInDomain) {
                    BeanUtils.copyAllPropertys((Object)pmUserUsecouponDomain, (Object)pmPromotionInDomain);
                }
            }
            BeanUtils.copyAllPropertys((Object)pmUserUsecouponDomain, (Object)orderCallBackBean);
            PmPromotionBaseDomain pmPromotionBaseDomain = (PmPromotionBaseDomain)DisUtil.getMapJson((String)"pm-promotion-base", (String)(pmUserUsecouponDomain.getPbCode() + "-" + pmUserUsecouponDomain.getTenantCode()), PmPromotionBaseDomain.class);
            if (null == pmPromotionBaseDomain) {
                pmPromotionBaseDomain = (PmPromotionBaseDomain)DisUtil.getMapJson((String)"pm-promotion-base", (String)(pmUserUsecouponDomain.getPbCode() + "-" + "00000000"), PmPromotionBaseDomain.class);
            }
            if (null != pmPromotionBaseDomain) {
                pmUserUsecouponDomain.setPbName(pmPromotionBaseDomain.getPbName());
            }
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmPromotionEngineServiceImpl.makeUsecoup.e", (Throwable)e);
        }
        return pmUserUsecouponDomain;
    }

    @Override
    public String updateUserCouponByOrderCallBack(List<OrderCallBackBean> orderCallBackBeanList) {
        this.pmUserUsecouponService.saveUserUsecouponBatch(this.makeUsecoupList(orderCallBackBeanList, false));
        return this.pmUserCouponService.updateUserCouponByOrderCallBack(orderCallBackBeanList);
    }

    @Override
    public String updateUserPmByOrderCallBack(List<OrderCallBackBean> orderCallBackBeanList) {
        if (ListUtil.isEmpty(orderCallBackBeanList)) {
            return "ERROR";
        }
        this.pmUserUsecouponService.saveUserUsecouponBatch(this.makeUsecoupList(orderCallBackBeanList, true));
        return "SUCCESS";
    }
}

