/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.pm.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.pm.dao.PmPromotionRangelistMapper;
import com.yqbsoft.laser.service.pm.domain.PmPromotionRangelistDomain;
import com.yqbsoft.laser.service.pm.domain.PmPromotionRangelistReDomain;
import com.yqbsoft.laser.service.pm.model.PmPromotionRangelist;
import com.yqbsoft.laser.service.pm.service.PmPromotionRangelistService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PmPromotionRangelistServiceImpl
extends BaseServiceImpl
implements PmPromotionRangelistService {
    private static final String SYS_CODE = "pm.PROMOTION.PmPromotionRangelistServiceImpl";
    private PmPromotionRangelistMapper pmPromotionRangelistMapper;

    public void setPmPromotionRangelistMapper(PmPromotionRangelistMapper pmPromotionRangelistMapper) {
        this.pmPromotionRangelistMapper = pmPromotionRangelistMapper;
    }

    private Date getSysDate() {
        try {
            return this.pmPromotionRangelistMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmPromotionRangelistServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkPromotionRangelist(PmPromotionRangelistDomain pmPromotionRangelistDomain) {
        if (null == pmPromotionRangelistDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)pmPromotionRangelistDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setPromotionRangelistDefault(PmPromotionRangelist pmPromotionRangelist) {
        if (null == pmPromotionRangelist) {
            return;
        }
        if (null == pmPromotionRangelist.getDataState()) {
            pmPromotionRangelist.setDataState(0);
        }
        if (null == pmPromotionRangelist.getGmtCreate()) {
            pmPromotionRangelist.setGmtCreate(this.getSysDate());
        }
        pmPromotionRangelist.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)pmPromotionRangelist.getPprlCode())) {
            pmPromotionRangelist.setPprlCode(this.createUUIDString());
        }
    }

    private int getPromotionRangelistMaxCode() {
        int code = 0;
        try {
            return this.pmPromotionRangelistMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmPromotionRangelistServiceImpl.getPromotionRangelistMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setPromotionRangelistUpdataDefault(PmPromotionRangelist pmPromotionRangelist) {
        if (null == pmPromotionRangelist) {
            return;
        }
        pmPromotionRangelist.setGmtModified(this.getSysDate());
    }

    private void savePromotionRangelistModel(PmPromotionRangelist pmPromotionRangelist) throws ApiException {
        if (null == pmPromotionRangelist) {
            return;
        }
        try {
            this.pmPromotionRangelistMapper.insert(pmPromotionRangelist);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmPromotionRangelistServiceImpl.savePromotionRangelistModel.ex", (Throwable)e);
        }
    }

    private void savePromotionRangelistBatchModel(List<PmPromotionRangelist> pmPromotionRangelistList) throws ApiException {
        if (null == pmPromotionRangelistList || pmPromotionRangelistList.isEmpty()) {
            return;
        }
        try {
            this.pmPromotionRangelistMapper.insertBatch(pmPromotionRangelistList);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmPromotionRangelistServiceImpl.savePromotionRangelistBatchModel.ex", (Throwable)e);
        }
    }

    private PmPromotionRangelist getPromotionRangelistModelById(Integer pprlId) {
        if (null == pprlId) {
            return null;
        }
        try {
            return this.pmPromotionRangelistMapper.selectByPrimaryKey(pprlId);
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmPromotionRangelistServiceImpl.getPromotionRangelistModelById", (Throwable)e);
            return null;
        }
    }

    private PmPromotionRangelist getPromotionRangelistModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.pmPromotionRangelistMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmPromotionRangelistServiceImpl.getPromotionRangelistModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delPromotionRangelistModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        try {
            this.pmPromotionRangelistMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmPromotionRangelistServiceImpl.delPromotionRangelistModelByCode.ex", (Throwable)e);
        }
    }

    private void deletePromotionRangelistModel(Integer pprlId) throws ApiException {
        if (null == pprlId) {
            return;
        }
        try {
            this.pmPromotionRangelistMapper.deleteByPrimaryKey(pprlId);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmPromotionRangelistServiceImpl.deletePromotionRangelistModel.ex", (Throwable)e);
        }
    }

    private void deletePromotionRangelistPromotionModel(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        try {
            this.pmPromotionRangelistMapper.delByPromotionCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmPromotionRangelistServiceImpl.deletePromotionRangelistPromotionModel.ex", (Throwable)e);
        }
    }

    private void updatePromotionRangelistModel(PmPromotionRangelist pmPromotionRangelist) throws ApiException {
        if (null == pmPromotionRangelist) {
            return;
        }
        int i = 0;
        try {
            i = this.pmPromotionRangelistMapper.updateByPrimaryKeySelective(pmPromotionRangelist);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmPromotionRangelistServiceImpl.updatePromotionRangelistModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pm.PROMOTION.PmPromotionRangelistServiceImpl.updatePromotionRangelistModel.num");
        }
    }

    private void updateStatePromotionRangelistModel(Integer pprlId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == pprlId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("pprlId", pprlId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.pmPromotionRangelistMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmPromotionRangelistServiceImpl.updateStatePromotionRangelistModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pm.PROMOTION.PmPromotionRangelistServiceImpl.updateStatePromotionRangelistModel.null");
        }
    }

    private void updateStatePromotionRangelistModelByCode(String tenantCode, String pprlCode, Integer dataState, Integer oldDataState) throws ApiException {
        if (StringUtils.isBlank((String)pprlCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("pprlCode", pprlCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.pmPromotionRangelistMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmPromotionRangelistServiceImpl.updateStatePromotionRangelistModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pm.PROMOTION.PmPromotionRangelistServiceImpl.updateStatePromotionRangelistModelByCode.null");
        }
    }

    private PmPromotionRangelist makePromotionRangelist(PmPromotionRangelistDomain pmPromotionRangelistDomain, PmPromotionRangelist pmPromotionRangelist) {
        if (null == pmPromotionRangelistDomain) {
            return null;
        }
        if (null == pmPromotionRangelist) {
            pmPromotionRangelist = new PmPromotionRangelist();
        }
        try {
            BeanUtils.copyAllPropertys((Object)pmPromotionRangelist, (Object)pmPromotionRangelistDomain);
            return pmPromotionRangelist;
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmPromotionRangelistServiceImpl.makePromotionRangelist", (Throwable)e);
            return null;
        }
    }

    private PmPromotionRangelistReDomain makePmPromotionRangelistReDomain(PmPromotionRangelist pmPromotionRangelist) {
        if (null == pmPromotionRangelist) {
            return null;
        }
        PmPromotionRangelistReDomain pmPromotionRangelistReDomain = new PmPromotionRangelistReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)pmPromotionRangelistReDomain, (Object)pmPromotionRangelist);
            return pmPromotionRangelistReDomain;
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmPromotionRangelistServiceImpl.makePmPromotionRangelistReDomain", (Throwable)e);
            return null;
        }
    }

    private List<PmPromotionRangelist> queryPromotionRangelistModelPage(Map<String, Object> parammap) {
        try {
            return this.pmPromotionRangelistMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmPromotionRangelistServiceImpl.queryPromotionRangelistModel", (Throwable)e);
            return null;
        }
    }

    private int countPromotionRangelist(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.pmPromotionRangelistMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmPromotionRangelistServiceImpl.countPromotionRangelist", (Throwable)e);
        }
        return i;
    }

    private PmPromotionRangelist createPmPromotionRangelist(PmPromotionRangelistDomain pmPromotionRangelistDomain) {
        String msg = this.checkPromotionRangelist(pmPromotionRangelistDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pm.PROMOTION.PmPromotionRangelistServiceImpl.savePromotionRangelist.checkPromotionRangelist", msg);
        }
        PmPromotionRangelist pmPromotionRangelist = this.makePromotionRangelist(pmPromotionRangelistDomain, null);
        this.setPromotionRangelistDefault(pmPromotionRangelist);
        return pmPromotionRangelist;
    }

    @Override
    public String savePromotionRangelist(PmPromotionRangelistDomain pmPromotionRangelistDomain) throws ApiException {
        PmPromotionRangelist pmPromotionRangelist = this.createPmPromotionRangelist(pmPromotionRangelistDomain);
        this.savePromotionRangelistModel(pmPromotionRangelist);
        return pmPromotionRangelist.getPprlCode();
    }

    @Override
    public String savePromotionRangelistBatch(List<PmPromotionRangelistDomain> pmPromotionRangelistDomainList) throws ApiException {
        if (null == pmPromotionRangelistDomainList || pmPromotionRangelistDomainList.isEmpty()) {
            return null;
        }
        ArrayList<PmPromotionRangelist> pmPromotionRangelistList = new ArrayList<PmPromotionRangelist>();
        String code = "";
        for (PmPromotionRangelistDomain pmPromotionRangelistDomain : pmPromotionRangelistDomainList) {
            PmPromotionRangelist pmPromotionRangelist = this.createPmPromotionRangelist(pmPromotionRangelistDomain);
            code = pmPromotionRangelist.getPprlCode();
            pmPromotionRangelistList.add(pmPromotionRangelist);
        }
        this.savePromotionRangelistBatchModel(pmPromotionRangelistList);
        return code;
    }

    @Override
    public void updatePromotionRangelistState(Integer pprlId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStatePromotionRangelistModel(pprlId, dataState, oldDataState);
    }

    @Override
    public void updatePromotionRangelistStateByCode(String tenantCode, String pprlCode, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStatePromotionRangelistModelByCode(tenantCode, pprlCode, dataState, oldDataState);
    }

    @Override
    public void updatePromotionRangelist(PmPromotionRangelistDomain pmPromotionRangelistDomain) throws ApiException {
        String msg = this.checkPromotionRangelist(pmPromotionRangelistDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pm.PROMOTION.PmPromotionRangelistServiceImpl.updatePromotionRangelist.checkPromotionRangelist", msg);
        }
        PmPromotionRangelist oldPmPromotionRangelist = this.getPromotionRangelistModelById(pmPromotionRangelistDomain.getPprlId());
        if (null == oldPmPromotionRangelist) {
            throw new ApiException("pm.PROMOTION.PmPromotionRangelistServiceImpl.updatePromotionRangelist.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        PmPromotionRangelist pmPromotionRangelist = this.makePromotionRangelist(pmPromotionRangelistDomain, oldPmPromotionRangelist);
        this.setPromotionRangelistUpdataDefault(pmPromotionRangelist);
        this.updatePromotionRangelistModel(pmPromotionRangelist);
    }

    @Override
    public PmPromotionRangelist getPromotionRangelist(Integer pprlId) {
        return this.getPromotionRangelistModelById(pprlId);
    }

    @Override
    public void deletePromotionRangelist(Integer pprlId) throws ApiException {
        this.deletePromotionRangelistModel(pprlId);
    }

    @Override
    public QueryResult<PmPromotionRangelist> queryPromotionRangelistPage(Map<String, Object> map) {
        List<PmPromotionRangelist> pmPromotionRangelistList = this.queryPromotionRangelistModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countPromotionRangelist(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(pmPromotionRangelistList);
        return queryResult;
    }

    @Override
    public PmPromotionRangelist getPromotionRangelistByCode(String tenantCode, String pprlCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("pprlCode", pprlCode);
        return this.getPromotionRangelistModelByCode(map);
    }

    @Override
    public void deletePromotionRangelistByCode(String tenantCode, String promotionCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("promotionCode", promotionCode);
        this.deletePromotionRangelistPromotionModel(map);
    }

    @Override
    public void updatePrDataStateByCode(Map<String, Object> map) throws ApiException {
        this.logger.error("pm.PROMOTION.PmPromotionRangelistServiceImpl.updatePrDataStateByCode", (Object)JsonUtil.buildNonDefaultBinder().toJson(map));
        if (null == map || map.isEmpty()) {
            return;
        }
        try {
            this.pmPromotionRangelistMapper.updatePrDataStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmPromotionRangelistServiceImpl.updatePrDataStateByCode.ex", (Throwable)e);
        }
    }

    @Override
    public void updatePrGoodsCodeByCode(String tenantCode, String promotionCode, String rangeCode, String goodsCode) throws ApiException {
        if (StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)promotionCode) || StringUtils.isBlank((String)rangeCode)) {
            this.logger.error("pm.PROMOTION.PmPromotionRangelistServiceImpl.sendUpdatePromotionOcodeByCode.null");
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("promotionCode", promotionCode);
        map.put("rangeCode", rangeCode);
        map.put("goodsCode", goodsCode);
        this.pmPromotionRangelistMapper.updatePrGoodsCodeByCode(map);
    }
}

