/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.pm.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.pm.dao.PmActivityGiftPackMapper;
import com.yqbsoft.laser.service.pm.domain.PmActivityGiftPackDomain;
import com.yqbsoft.laser.service.pm.domain.PmActivityGiftPackReDomain;
import com.yqbsoft.laser.service.pm.model.PmActivityGiftPack;
import com.yqbsoft.laser.service.pm.service.PmActivityGiftPackService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PmActivityGiftPackServiceImpl
extends BaseServiceImpl
implements PmActivityGiftPackService {
    private static final String SYS_CODE = "pm.PROMOTION.PmActivityGiftPackServiceImpl";
    private PmActivityGiftPackMapper pmActivityGiftPackMapper;

    public void setPmActivityGiftPackMapper(PmActivityGiftPackMapper pmActivityGiftPackMapper) {
        this.pmActivityGiftPackMapper = pmActivityGiftPackMapper;
    }

    private Date getSysDate() {
        try {
            return this.pmActivityGiftPackMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmActivityGiftPackServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkActivityGiftPack(PmActivityGiftPackDomain pmActivityGiftPackDomain) {
        if (null == pmActivityGiftPackDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        return msg;
    }

    private void setActivityGiftPackDefault(PmActivityGiftPack pmActivityGiftPack) {
        if (null == pmActivityGiftPack) {
            return;
        }
        if (null == pmActivityGiftPack.getDataState()) {
            pmActivityGiftPack.setDataState(1);
        }
        Date date = this.getSysDate();
        if (null == pmActivityGiftPack.getGmtCreate()) {
            pmActivityGiftPack.setGmtCreate(date);
        }
        pmActivityGiftPack.setGmtModified(date);
        if (StringUtils.isBlank((String)pmActivityGiftPack.getGiftPackCode())) {
            pmActivityGiftPack.setGiftPackCode(this.createUUIDString());
        }
        if (StringUtils.isBlank((String)pmActivityGiftPack.getTenantCode())) {
            pmActivityGiftPack.setTenantCode("2020021100000063");
        }
    }

    private int getActivityGiftPackMaxCode() {
        int code = 0;
        try {
            return this.pmActivityGiftPackMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmActivityGiftPackServiceImpl.getActivityGiftPackMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setActivityGiftPackUpdataDefault(PmActivityGiftPack pmActivityGiftPack) {
        if (null == pmActivityGiftPack) {
            return;
        }
        pmActivityGiftPack.setGmtModified(this.getSysDate());
    }

    private void saveActivityGiftPackModel(PmActivityGiftPack pmActivityGiftPack) throws ApiException {
        if (null == pmActivityGiftPack) {
            return;
        }
        try {
            this.pmActivityGiftPackMapper.insert(pmActivityGiftPack);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmActivityGiftPackServiceImpl.saveActivityGiftPackModel.ex", (Throwable)e);
        }
    }

    private void saveActivityGiftPackBatchModel(List<PmActivityGiftPack> pmActivityGiftPackList) throws ApiException {
        if (null == pmActivityGiftPackList || pmActivityGiftPackList.isEmpty()) {
            return;
        }
        try {
            this.pmActivityGiftPackMapper.insertBatch(pmActivityGiftPackList);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmActivityGiftPackServiceImpl.saveActivityGiftPackBatchModel.ex", (Throwable)e);
        }
    }

    private PmActivityGiftPack getActivityGiftPackModelById(Integer giftPackId) {
        if (null == giftPackId) {
            return null;
        }
        try {
            return this.pmActivityGiftPackMapper.selectByPrimaryKey(giftPackId);
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmActivityGiftPackServiceImpl.getActivityGiftPackModelById", (Throwable)e);
            return null;
        }
    }

    private PmActivityGiftPack getActivityGiftPackModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.pmActivityGiftPackMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmActivityGiftPackServiceImpl.getActivityGiftPackModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delActivityGiftPackModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.pmActivityGiftPackMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmActivityGiftPackServiceImpl.delActivityGiftPackModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pm.PROMOTION.PmActivityGiftPackServiceImpl.delActivityGiftPackModelByCode.num");
        }
    }

    private void deleteActivityGiftPackModel(Integer giftPackId) throws ApiException {
        if (null == giftPackId) {
            return;
        }
        int i = 0;
        try {
            i = this.pmActivityGiftPackMapper.deleteByPrimaryKey(giftPackId);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmActivityGiftPackServiceImpl.deleteActivityGiftPackModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pm.PROMOTION.PmActivityGiftPackServiceImpl.deleteActivityGiftPackModel.num");
        }
    }

    private void updateActivityGiftPackModel(PmActivityGiftPack pmActivityGiftPack) throws ApiException {
        if (null == pmActivityGiftPack) {
            return;
        }
        int i = 0;
        try {
            i = this.pmActivityGiftPackMapper.updateByPrimaryKey(pmActivityGiftPack);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmActivityGiftPackServiceImpl.updateActivityGiftPackModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pm.PROMOTION.PmActivityGiftPackServiceImpl.updateActivityGiftPackModel.num");
        }
    }

    private void updateStateActivityGiftPackModel(Integer giftPackId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == giftPackId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("giftPackId", giftPackId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.pmActivityGiftPackMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmActivityGiftPackServiceImpl.updateStateActivityGiftPackModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pm.PROMOTION.PmActivityGiftPackServiceImpl.updateStateActivityGiftPackModel.null");
        }
    }

    private void updateStateActivityGiftPackModelByCode(String tenantCode, String giftPackCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)giftPackCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("giftPackCode", giftPackCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.pmActivityGiftPackMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmActivityGiftPackServiceImpl.updateStateActivityGiftPackModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pm.PROMOTION.PmActivityGiftPackServiceImpl.updateStateActivityGiftPackModelByCode.null");
        }
    }

    private PmActivityGiftPack makeActivityGiftPack(PmActivityGiftPackDomain pmActivityGiftPackDomain, PmActivityGiftPack pmActivityGiftPack) {
        if (null == pmActivityGiftPackDomain) {
            return null;
        }
        if (null == pmActivityGiftPack) {
            pmActivityGiftPack = new PmActivityGiftPack();
        }
        try {
            BeanUtils.copyAllPropertys((Object)pmActivityGiftPack, (Object)pmActivityGiftPackDomain);
            return pmActivityGiftPack;
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmActivityGiftPackServiceImpl.makeActivityGiftPack", (Throwable)e);
            return null;
        }
    }

    private PmActivityGiftPackReDomain makePmActivityGiftPackReDomain(PmActivityGiftPack pmActivityGiftPack) {
        if (null == pmActivityGiftPack) {
            return null;
        }
        PmActivityGiftPackReDomain pmActivityGiftPackReDomain = new PmActivityGiftPackReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)pmActivityGiftPackReDomain, (Object)pmActivityGiftPack);
            return pmActivityGiftPackReDomain;
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmActivityGiftPackServiceImpl.makePmActivityGiftPackReDomain", (Throwable)e);
            return null;
        }
    }

    private List<PmActivityGiftPack> queryActivityGiftPackModelPage(Map<String, Object> parammap) {
        try {
            return this.pmActivityGiftPackMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmActivityGiftPackServiceImpl.queryActivityGiftPackModel", (Throwable)e);
            return null;
        }
    }

    private int countActivityGiftPack(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.pmActivityGiftPackMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmActivityGiftPackServiceImpl.countActivityGiftPack", (Throwable)e);
        }
        return i;
    }

    private PmActivityGiftPack createPmActivityGiftPack(PmActivityGiftPackDomain pmActivityGiftPackDomain) {
        String msg = this.checkActivityGiftPack(pmActivityGiftPackDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pm.PROMOTION.PmActivityGiftPackServiceImpl.saveActivityGiftPack.checkActivityGiftPack", msg);
        }
        PmActivityGiftPack pmActivityGiftPack = this.makeActivityGiftPack(pmActivityGiftPackDomain, null);
        this.setActivityGiftPackDefault(pmActivityGiftPack);
        return pmActivityGiftPack;
    }

    @Override
    public String saveActivityGiftPack(PmActivityGiftPackDomain pmActivityGiftPackDomain) throws ApiException {
        PmActivityGiftPack pmActivityGiftPack = this.createPmActivityGiftPack(pmActivityGiftPackDomain);
        this.saveActivityGiftPackModel(pmActivityGiftPack);
        return pmActivityGiftPack.getGiftPackCode();
    }

    @Override
    public String saveActivityGiftPackBatch(List<PmActivityGiftPackDomain> pmActivityGiftPackDomainList) throws ApiException {
        if (null == pmActivityGiftPackDomainList || pmActivityGiftPackDomainList.isEmpty()) {
            return null;
        }
        ArrayList<PmActivityGiftPack> pmActivityGiftPackList = new ArrayList<PmActivityGiftPack>();
        String code = "";
        for (PmActivityGiftPackDomain pmActivityGiftPackDomain : pmActivityGiftPackDomainList) {
            PmActivityGiftPack pmActivityGiftPack = this.createPmActivityGiftPack(pmActivityGiftPackDomain);
            code = pmActivityGiftPack.getGiftPackCode();
            pmActivityGiftPackList.add(pmActivityGiftPack);
        }
        this.saveActivityGiftPackBatchModel(pmActivityGiftPackList);
        return code;
    }

    @Override
    public void updateActivityGiftPackState(Integer giftPackId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == giftPackId) {
            return;
        }
        this.updateStateActivityGiftPackModel(giftPackId, dataState, oldDataState, map);
    }

    @Override
    public void updateActivityGiftPackStateByCode(String tenantCode, String giftPackCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)giftPackCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateActivityGiftPackModelByCode(tenantCode, giftPackCode, dataState, oldDataState, map);
    }

    @Override
    public void updateActivityGiftPack(PmActivityGiftPackDomain pmActivityGiftPackDomain) throws ApiException {
        String msg = this.checkActivityGiftPack(pmActivityGiftPackDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pm.PROMOTION.PmActivityGiftPackServiceImpl.updateActivityGiftPack.checkActivityGiftPack", msg);
        }
        PmActivityGiftPack oldPmActivityGiftPack = this.getActivityGiftPackModelById(pmActivityGiftPackDomain.getGiftPackId());
        if (null == oldPmActivityGiftPack) {
            throw new ApiException("pm.PROMOTION.PmActivityGiftPackServiceImpl.updateActivityGiftPack.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        PmActivityGiftPack pmActivityGiftPack = this.makeActivityGiftPack(pmActivityGiftPackDomain, oldPmActivityGiftPack);
        this.setActivityGiftPackUpdataDefault(pmActivityGiftPack);
        this.updateActivityGiftPackModel(pmActivityGiftPack);
    }

    @Override
    public PmActivityGiftPack getActivityGiftPack(Integer giftPackId) {
        if (null == giftPackId) {
            return null;
        }
        return this.getActivityGiftPackModelById(giftPackId);
    }

    @Override
    public void deleteActivityGiftPack(Integer giftPackId) throws ApiException {
        if (null == giftPackId) {
            return;
        }
        this.deleteActivityGiftPackModel(giftPackId);
    }

    @Override
    public QueryResult<PmActivityGiftPack> queryActivityGiftPackPage(Map<String, Object> map) {
        List<PmActivityGiftPack> pmActivityGiftPackList = this.queryActivityGiftPackModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countActivityGiftPack(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(pmActivityGiftPackList);
        return queryResult;
    }

    @Override
    public PmActivityGiftPack getActivityGiftPackByCode(String tenantCode, String giftPackCode) throws ApiException {
        if (StringUtils.isBlank((String)giftPackCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("giftPackCode", giftPackCode);
        return this.getActivityGiftPackModelByCode(map);
    }

    @Override
    public void deleteActivityGiftPackByCode(String tenantCode, String giftPackCode) throws ApiException {
        if (StringUtils.isBlank((String)giftPackCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("giftPackCode", giftPackCode);
        this.delActivityGiftPackModelByCode(map);
    }
}

