/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.pm.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.pm.dao.PmBiddingSourceMapper;
import com.yqbsoft.laser.service.pm.domain.PmBiddingInformationDomain;
import com.yqbsoft.laser.service.pm.domain.PmBiddingSourceDomain;
import com.yqbsoft.laser.service.pm.domain.PmBiddingSourceReDomain;
import com.yqbsoft.laser.service.pm.model.PmBiddingSource;
import com.yqbsoft.laser.service.pm.service.PmBiddingInformationService;
import com.yqbsoft.laser.service.pm.service.PmBiddingSourceService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.json.JSONArray;
import com.yqbsoft.laser.service.tool.json.JSONObject;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.DateUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import com.yqbsoft.laser.service.tool.util.WebUtils;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringEscapeUtils;

public class PmBiddingSourceServiceImpl
extends BaseServiceImpl
implements PmBiddingSourceService {
    private static final String SYS_CODE = "pm.PROMOTION.PmBiddingSourceServiceImpl";
    private PmBiddingSourceMapper pmBiddingSourceMapper;
    private PmBiddingInformationService pmBiddingInformationService;

    public void setPmBiddingInformationService(PmBiddingInformationService pmBiddingInformationService) {
        this.pmBiddingInformationService = pmBiddingInformationService;
    }

    public void setPmBiddingSourceMapper(PmBiddingSourceMapper pmBiddingSourceMapper) {
        this.pmBiddingSourceMapper = pmBiddingSourceMapper;
    }

    private Date getSysDate() {
        try {
            return this.pmBiddingSourceMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmBiddingSourceServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkBiddingSource(PmBiddingSourceDomain pmBiddingSourceDomain) {
        if (null == pmBiddingSourceDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)pmBiddingSourceDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setBiddingSourceDefault(PmBiddingSource pmBiddingSource) {
        if (null == pmBiddingSource) {
            return;
        }
        if (null == pmBiddingSource.getDataState()) {
            pmBiddingSource.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == pmBiddingSource.getGmtCreate()) {
            pmBiddingSource.setGmtCreate(date);
        }
        pmBiddingSource.setGmtModified(date);
        if (StringUtils.isBlank((String)pmBiddingSource.getSourceCode())) {
            pmBiddingSource.setSourceCode(this.getNo(null, "PmBiddingSource", "pmBiddingSource", pmBiddingSource.getTenantCode()));
        }
    }

    private int getBiddingSourceMaxCode() {
        int code = 0;
        try {
            return this.pmBiddingSourceMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmBiddingSourceServiceImpl.getBiddingSourceMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setBiddingSourceUpdataDefault(PmBiddingSource pmBiddingSource) {
        if (null == pmBiddingSource) {
            return;
        }
        pmBiddingSource.setGmtModified(this.getSysDate());
    }

    private void saveBiddingSourceModel(PmBiddingSource pmBiddingSource) throws ApiException {
        if (null == pmBiddingSource) {
            return;
        }
        try {
            this.pmBiddingSourceMapper.insert(pmBiddingSource);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmBiddingSourceServiceImpl.saveBiddingSourceModel.ex", (Throwable)e);
        }
    }

    private void saveBiddingSourceBatchModel(List<PmBiddingSource> pmBiddingSourceList) throws ApiException {
        if (null == pmBiddingSourceList || pmBiddingSourceList.isEmpty()) {
            return;
        }
        try {
            this.pmBiddingSourceMapper.insertBatch(pmBiddingSourceList);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmBiddingSourceServiceImpl.saveBiddingSourceBatchModel.ex", (Throwable)e);
        }
    }

    private PmBiddingSource getBiddingSourceModelById(Integer sourceId) {
        if (null == sourceId) {
            return null;
        }
        try {
            return this.pmBiddingSourceMapper.selectByPrimaryKey(sourceId);
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmBiddingSourceServiceImpl.getBiddingSourceModelById", (Throwable)e);
            return null;
        }
    }

    private PmBiddingSource getBiddingSourceModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.pmBiddingSourceMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmBiddingSourceServiceImpl.getBiddingSourceModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delBiddingSourceModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.pmBiddingSourceMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmBiddingSourceServiceImpl.delBiddingSourceModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pm.PROMOTION.PmBiddingSourceServiceImpl.delBiddingSourceModelByCode.num");
        }
    }

    private void deleteBiddingSourceModel(Integer sourceId) throws ApiException {
        if (null == sourceId) {
            return;
        }
        int i = 0;
        try {
            i = this.pmBiddingSourceMapper.deleteByPrimaryKey(sourceId);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmBiddingSourceServiceImpl.deleteBiddingSourceModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pm.PROMOTION.PmBiddingSourceServiceImpl.deleteBiddingSourceModel.num");
        }
    }

    private void updateBiddingSourceModel(PmBiddingSource pmBiddingSource) throws ApiException {
        if (null == pmBiddingSource) {
            return;
        }
        int i = 0;
        try {
            i = this.pmBiddingSourceMapper.updateByPrimaryKey(pmBiddingSource);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmBiddingSourceServiceImpl.updateBiddingSourceModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pm.PROMOTION.PmBiddingSourceServiceImpl.updateBiddingSourceModel.num");
        }
    }

    private void updateStateBiddingSourceModel(Integer sourceId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == sourceId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("sourceId", sourceId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.pmBiddingSourceMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmBiddingSourceServiceImpl.updateStateBiddingSourceModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pm.PROMOTION.PmBiddingSourceServiceImpl.updateStateBiddingSourceModel.null");
        }
    }

    private void updateStateBiddingSourceModelByCode(String tenantCode, String sourceCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)sourceCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("sourceCode", sourceCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.pmBiddingSourceMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmBiddingSourceServiceImpl.updateStateBiddingSourceModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pm.PROMOTION.PmBiddingSourceServiceImpl.updateStateBiddingSourceModelByCode.null");
        }
    }

    private PmBiddingSource makeBiddingSource(PmBiddingSourceDomain pmBiddingSourceDomain, PmBiddingSource pmBiddingSource) {
        if (null == pmBiddingSourceDomain) {
            return null;
        }
        if (null == pmBiddingSource) {
            pmBiddingSource = new PmBiddingSource();
        }
        try {
            BeanUtils.copyAllPropertys((Object)pmBiddingSource, (Object)pmBiddingSourceDomain);
            return pmBiddingSource;
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmBiddingSourceServiceImpl.makeBiddingSource", (Throwable)e);
            return null;
        }
    }

    private PmBiddingSourceReDomain makePmBiddingSourceReDomain(PmBiddingSource pmBiddingSource) {
        if (null == pmBiddingSource) {
            return null;
        }
        PmBiddingSourceReDomain pmBiddingSourceReDomain = new PmBiddingSourceReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)pmBiddingSourceReDomain, (Object)pmBiddingSource);
            return pmBiddingSourceReDomain;
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmBiddingSourceServiceImpl.makePmBiddingSourceReDomain", (Throwable)e);
            return null;
        }
    }

    private List<PmBiddingSource> queryBiddingSourceModelPage(Map<String, Object> parammap) {
        try {
            return this.pmBiddingSourceMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmBiddingSourceServiceImpl.queryBiddingSourceModel", (Throwable)e);
            return null;
        }
    }

    private int countBiddingSource(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.pmBiddingSourceMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmBiddingSourceServiceImpl.countBiddingSource", (Throwable)e);
        }
        return i;
    }

    private PmBiddingSource createPmBiddingSource(PmBiddingSourceDomain pmBiddingSourceDomain) {
        String msg = this.checkBiddingSource(pmBiddingSourceDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pm.PROMOTION.PmBiddingSourceServiceImpl.saveBiddingSource.checkBiddingSource", msg);
        }
        PmBiddingSource pmBiddingSource = this.makeBiddingSource(pmBiddingSourceDomain, null);
        this.setBiddingSourceDefault(pmBiddingSource);
        return pmBiddingSource;
    }

    @Override
    public String saveBiddingSource(PmBiddingSourceDomain pmBiddingSourceDomain) throws ApiException {
        PmBiddingSource pmBiddingSource = this.createPmBiddingSource(pmBiddingSourceDomain);
        this.saveBiddingSourceModel(pmBiddingSource);
        return pmBiddingSource.getSourceCode();
    }

    @Override
    public String saveBiddingSourceBatch(List<PmBiddingSourceDomain> pmBiddingSourceDomainList) throws ApiException {
        if (null == pmBiddingSourceDomainList || pmBiddingSourceDomainList.isEmpty()) {
            return null;
        }
        ArrayList<PmBiddingSource> pmBiddingSourceList = new ArrayList<PmBiddingSource>();
        String code = "";
        for (PmBiddingSourceDomain pmBiddingSourceDomain : pmBiddingSourceDomainList) {
            PmBiddingSource pmBiddingSource = this.createPmBiddingSource(pmBiddingSourceDomain);
            code = pmBiddingSource.getSourceCode();
            pmBiddingSourceList.add(pmBiddingSource);
        }
        this.saveBiddingSourceBatchModel(pmBiddingSourceList);
        return code;
    }

    @Override
    public void updateBiddingSourceState(Integer sourceId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == sourceId) {
            return;
        }
        this.updateStateBiddingSourceModel(sourceId, dataState, oldDataState, map);
    }

    @Override
    public void updateBiddingSourceStateByCode(String tenantCode, String sourceCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)sourceCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateBiddingSourceModelByCode(tenantCode, sourceCode, dataState, oldDataState, map);
    }

    @Override
    public void updateBiddingSource(PmBiddingSourceDomain pmBiddingSourceDomain) throws ApiException {
        String msg = this.checkBiddingSource(pmBiddingSourceDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pm.PROMOTION.PmBiddingSourceServiceImpl.updateBiddingSource.checkBiddingSource", msg);
        }
        PmBiddingSource oldPmBiddingSource = this.getBiddingSourceModelById(pmBiddingSourceDomain.getSourceId());
        if (null == oldPmBiddingSource) {
            throw new ApiException("pm.PROMOTION.PmBiddingSourceServiceImpl.updateBiddingSource.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        PmBiddingSource pmBiddingSource = this.makeBiddingSource(pmBiddingSourceDomain, oldPmBiddingSource);
        this.setBiddingSourceUpdataDefault(pmBiddingSource);
        this.updateBiddingSourceModel(pmBiddingSource);
    }

    @Override
    public PmBiddingSource getBiddingSource(Integer sourceId) {
        if (null == sourceId) {
            return null;
        }
        return this.getBiddingSourceModelById(sourceId);
    }

    @Override
    public void deleteBiddingSource(Integer sourceId) throws ApiException {
        if (null == sourceId) {
            return;
        }
        this.deleteBiddingSourceModel(sourceId);
    }

    @Override
    public QueryResult<PmBiddingSource> queryBiddingSourcePage(Map<String, Object> map) {
        List<PmBiddingSource> pmBiddingSourceList = this.queryBiddingSourceModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countBiddingSource(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(pmBiddingSourceList);
        return queryResult;
    }

    @Override
    public PmBiddingSource getBiddingSourceByCode(String tenantCode, String sourceCode) throws ApiException {
        if (StringUtils.isBlank((String)sourceCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("sourceCode", sourceCode);
        return this.getBiddingSourceModelByCode(map);
    }

    @Override
    public void deleteBiddingSourceByCode(String tenantCode, String sourceCode) throws ApiException {
        if (StringUtils.isBlank((String)sourceCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("sourceCode", sourceCode);
        this.delBiddingSourceModelByCode(map);
    }

    @Override
    public void timeCreateInfo() throws ApiException {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("dataState", 1);
        List<PmBiddingSource> pmBiddingSourceList = this.queryBiddingSourceModelPage(paramMap);
        for (PmBiddingSource pmBiddingSource : pmBiddingSourceList) {
            this.saveInfo(pmBiddingSource);
        }
    }

    @Override
    public void saveInfo(PmBiddingSource pmBiddingSource) throws ApiException {
        this.createBiddingInfo(pmBiddingSource, 2);
    }

    private void createBiddingInfo(PmBiddingSource pmBiddingSource, Integer page) {
        Boolean getNextPage = false;
        String httpData = this.getHttpData(pmBiddingSource, page);
        if (StringUtils.isNotBlank((String)httpData)) {
            getNextPage = this.saveHttpData(httpData, pmBiddingSource);
        }
        if (getNextPage.booleanValue()) {
            Integer n = page;
            Integer n2 = page = Integer.valueOf(page + 1);
            this.createBiddingInfo(pmBiddingSource, page);
        }
    }

    private Boolean saveHttpData(String httpData, PmBiddingSource pmBiddingSource) {
        String listData = this.getList(httpData, pmBiddingSource.getListPath());
        listData = StringEscapeUtils.unescapeJava((String)listData);
        JSONArray jsonArray = null;
        jsonArray = pmBiddingSource.getResponseType() == 0 ? JSONArray.json2array((String)listData) : this.createJson(listData, pmBiddingSource.getObjectMatch());
        List<PmBiddingInformationDomain> pmBiddingInformationList = this.createPmBiddingInfo(jsonArray, pmBiddingSource);
        return this.savePmBiddingInformationList(pmBiddingInformationList);
    }

    private JSONArray createJson(String listData, String objectMatch) {
        JSONArray jsonArray = new JSONArray();
        Pattern r = Pattern.compile(objectMatch, 34);
        Matcher m = r.matcher(listData);
        while (m.find()) {
            JSONObject jsonObject = new JSONObject();
            for (int i = 0; i <= m.groupCount(); ++i) {
                jsonObject.put("MATCH" + String.valueOf(i), (Object)m.group(i));
            }
            jsonArray.add(jsonObject);
        }
        return jsonArray;
    }

    private Boolean savePmBiddingInformationList(List<PmBiddingInformationDomain> pmBiddingInformationList) {
        if (ListUtil.isEmpty(pmBiddingInformationList)) {
            return false;
        }
        Boolean exitNew = false;
        Boolean allTop = true;
        ArrayList<PmBiddingInformationDomain> pmBiddingInformationDomainListNew = new ArrayList<PmBiddingInformationDomain>();
        for (PmBiddingInformationDomain pmBiddingInformationDomain : pmBiddingInformationList) {
            if (!this.pmBiddingInformationService.existBiddingInformation(pmBiddingInformationDomain)) {
                pmBiddingInformationDomainListNew.add(pmBiddingInformationDomain);
                exitNew = true;
                continue;
            }
            if (pmBiddingInformationDomain.getTopValue().booleanValue()) continue;
            allTop = false;
        }
        this.pmBiddingInformationService.saveBiddingInformationBatch(pmBiddingInformationDomainListNew);
        return exitNew != false || allTop != false;
    }

    private List<PmBiddingInformationDomain> createPmBiddingInfo(JSONArray jsonArray, PmBiddingSource pmBiddingSource) {
        ArrayList<PmBiddingInformationDomain> pmBiddingInformationList = new ArrayList<PmBiddingInformationDomain>();
        if (jsonArray != null && jsonArray.size() > 0) {
            for (JSONObject jsonObject : jsonArray) {
                PmBiddingInformationDomain pmBiddingInformationDomain = new PmBiddingInformationDomain();
                this.setPmBiddingInformationValue(pmBiddingInformationDomain, jsonObject, pmBiddingSource.getCodeMap());
                if (StringUtils.isNotBlank((String)pmBiddingInformationDomain.getInformationDate())) {
                    try {
                        pmBiddingInformationDomain.setInformationDateFormate(DateUtils.parseDate((String)pmBiddingInformationDomain.getInformationDate(), (String[])new String[]{"yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd", "yyyy-MM-dd HH:mm"}));
                    }
                    catch (ParseException e) {
                        e.printStackTrace();
                    }
                }
                if (StringUtils.isBlank((String)pmBiddingInformationDomain.getShowUrl()) && StringUtils.isNotBlank((String)pmBiddingSource.getShowUrl())) {
                    String showUrl = this.createShowUrl(pmBiddingSource.getShowUrl(), jsonObject);
                    pmBiddingInformationDomain.setShowUrl(showUrl);
                }
                if (jsonObject.containsKey((Object)pmBiddingSource.getTopKey()) && jsonObject.getString(pmBiddingSource.getTopKey()).equals(pmBiddingSource.getTopValue())) {
                    pmBiddingInformationDomain.setTopValue(true);
                }
                pmBiddingInformationDomain.setOriginalInfo(JsonUtil.buildNonDefaultBinder().toJson((Object)jsonObject));
                pmBiddingInformationDomain.setSourceId(pmBiddingSource.getSourceId());
                pmBiddingInformationDomain.setSourceCode(pmBiddingSource.getSourceCode());
                pmBiddingInformationDomain.setSourceName(pmBiddingSource.getSourceName());
                pmBiddingInformationDomain.setSourceUrl(pmBiddingSource.getSourceUrl());
                pmBiddingInformationList.add(pmBiddingInformationDomain);
            }
        }
        return pmBiddingInformationList;
    }

    private String createShowUrl(String showUrl, JSONObject jsonObject) {
        Pattern r = Pattern.compile("\\{([^\\}]*)\\}");
        Matcher m = r.matcher(showUrl);
        while (m.find()) {
            String matchKey = m.group(1);
            String reValue = "";
            reValue = matchKey.startsWith("#") ? jsonObject.getString(matchKey.replace("#", "")).replace("-", "") : jsonObject.getString(matchKey);
            showUrl = showUrl.replaceFirst("\\{" + matchKey + "\\}", reValue);
        }
        return showUrl;
    }

    private void setPmBiddingInformationValue(PmBiddingInformationDomain pmBiddingInformationDomain, JSONObject jsonObject, String codeMapStr) {
        HashMap codeMap = (HashMap)JsonUtil.buildNonDefaultBinder().getJsonToMap(codeMapStr, String.class, Object.class);
        Iterator iterator = codeMap.keySet().iterator();
        while (iterator.hasNext()) {
            String key = iterator.next().toString();
            String value = codeMap.get(key).toString();
            if (!jsonObject.containsKey((Object)key)) continue;
            BeanUtils.setObjValue((Object)pmBiddingInformationDomain, (String)value, (String)jsonObject.getString(key));
        }
    }

    private String getList(String httpData, String listPattern) {
        Pattern r = Pattern.compile(listPattern, 34);
        Matcher m = r.matcher(httpData);
        if (m.find()) {
            return m.group(1);
        }
        return "";
    }

    private String getHttpData(PmBiddingSource pmBiddingSource, Integer page) {
        String result = "";
        try {
            if ("POSTJSON".equals(pmBiddingSource.getRequestMethod())) {
                HashMap jsonToObject = (HashMap)JsonUtil.buildNonDefaultBinder().getJsonToMap(pmBiddingSource.getCollectionParameter(), String.class, Object.class);
                if (jsonToObject.containsKey(pmBiddingSource.getPageKey())) {
                    jsonToObject.put(pmBiddingSource.getPageKey(), page);
                }
                result = WebUtils.doPostJson((String)pmBiddingSource.getCollectionUrl(), (Map)jsonToObject, (int)30000, (int)30000);
            } else if ("GET".equals(pmBiddingSource.getRequestMethod())) {
                HashMap jsonToObject = (HashMap)JsonUtil.buildNonDefaultBinder().getJsonToMap(pmBiddingSource.getCollectionParameter(), String.class, String.class);
                if (jsonToObject.containsKey(pmBiddingSource.getPageKey())) {
                    jsonToObject.put(pmBiddingSource.getPageKey(), String.valueOf(page));
                }
                result = WebUtils.doGet((String)pmBiddingSource.getCollectionUrl(), (Map)jsonToObject, (int)30000, (int)30000);
            } else if ("POST".equals(pmBiddingSource.getRequestMethod())) {
                HashMap jsonToObject = (HashMap)JsonUtil.buildNonDefaultBinder().getJsonToMap(pmBiddingSource.getCollectionParameter(), String.class, String.class);
                if (jsonToObject.containsKey(pmBiddingSource.getPageKey())) {
                    jsonToObject.put(pmBiddingSource.getPageKey(), String.valueOf(page));
                }
                result = WebUtils.doPost((String)pmBiddingSource.getCollectionUrl(), (Map)jsonToObject, (int)30000, (int)30000);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }
}

