/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.pm.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.pm.dao.PmBiddingInformationMapper;
import com.yqbsoft.laser.service.pm.domain.PmBiddingInformationDomain;
import com.yqbsoft.laser.service.pm.domain.PmBiddingInformationReDomain;
import com.yqbsoft.laser.service.pm.model.PmBiddingInformation;
import com.yqbsoft.laser.service.pm.service.PmBiddingInformationService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PmBiddingInformationServiceImpl
extends BaseServiceImpl
implements PmBiddingInformationService {
    private static final String SYS_CODE = "pm.PROMOTION.PmBiddingInformationServiceImpl";
    private PmBiddingInformationMapper pmBiddingInformationMapper;

    public void setPmBiddingInformationMapper(PmBiddingInformationMapper pmBiddingInformationMapper) {
        this.pmBiddingInformationMapper = pmBiddingInformationMapper;
    }

    private Date getSysDate() {
        try {
            return this.pmBiddingInformationMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmBiddingInformationServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkBiddingInformation(PmBiddingInformationDomain pmBiddingInformationDomain) {
        if (null == pmBiddingInformationDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        return msg;
    }

    private void setBiddingInformationDefault(PmBiddingInformation pmBiddingInformation) {
        if (null == pmBiddingInformation) {
            return;
        }
        if (null == pmBiddingInformation.getDataState()) {
            pmBiddingInformation.setDataState(1);
        }
        Date date = this.getSysDate();
        if (null == pmBiddingInformation.getGmtCreate()) {
            pmBiddingInformation.setGmtCreate(date);
        }
        pmBiddingInformation.setGmtModified(date);
        if (StringUtils.isBlank((String)pmBiddingInformation.getInformationCode())) {
            pmBiddingInformation.setInformationCode(this.createUUIDString());
        }
        if (StringUtils.isBlank((String)pmBiddingInformation.getTenantCode())) {
            pmBiddingInformation.setTenantCode("2020021100000063");
        }
    }

    private int getBiddingInformationMaxCode() {
        int code = 0;
        try {
            return this.pmBiddingInformationMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmBiddingInformationServiceImpl.getBiddingInformationMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setBiddingInformationUpdataDefault(PmBiddingInformation pmBiddingInformation) {
        if (null == pmBiddingInformation) {
            return;
        }
        pmBiddingInformation.setGmtModified(this.getSysDate());
    }

    private void saveBiddingInformationModel(PmBiddingInformation pmBiddingInformation) throws ApiException {
        if (null == pmBiddingInformation) {
            return;
        }
        try {
            this.pmBiddingInformationMapper.insert(pmBiddingInformation);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmBiddingInformationServiceImpl.saveBiddingInformationModel.ex", (Throwable)e);
        }
    }

    private void saveBiddingInformationBatchModel(List<PmBiddingInformation> pmBiddingInformationList) throws ApiException {
        if (null == pmBiddingInformationList || pmBiddingInformationList.isEmpty()) {
            return;
        }
        try {
            this.pmBiddingInformationMapper.insertBatch(pmBiddingInformationList);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmBiddingInformationServiceImpl.saveBiddingInformationBatchModel.ex", (Throwable)e);
        }
    }

    private PmBiddingInformation getBiddingInformationModelById(Integer informationId) {
        if (null == informationId) {
            return null;
        }
        try {
            return this.pmBiddingInformationMapper.selectByPrimaryKey(informationId);
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmBiddingInformationServiceImpl.getBiddingInformationModelById", (Throwable)e);
            return null;
        }
    }

    private PmBiddingInformation getBiddingInformationModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.pmBiddingInformationMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmBiddingInformationServiceImpl.getBiddingInformationModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delBiddingInformationModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.pmBiddingInformationMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmBiddingInformationServiceImpl.delBiddingInformationModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pm.PROMOTION.PmBiddingInformationServiceImpl.delBiddingInformationModelByCode.num");
        }
    }

    private void deleteBiddingInformationModel(Integer informationId) throws ApiException {
        if (null == informationId) {
            return;
        }
        int i = 0;
        try {
            i = this.pmBiddingInformationMapper.deleteByPrimaryKey(informationId);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmBiddingInformationServiceImpl.deleteBiddingInformationModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pm.PROMOTION.PmBiddingInformationServiceImpl.deleteBiddingInformationModel.num");
        }
    }

    private void updateBiddingInformationModel(PmBiddingInformation pmBiddingInformation) throws ApiException {
        if (null == pmBiddingInformation) {
            return;
        }
        int i = 0;
        try {
            i = this.pmBiddingInformationMapper.updateByPrimaryKey(pmBiddingInformation);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmBiddingInformationServiceImpl.updateBiddingInformationModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pm.PROMOTION.PmBiddingInformationServiceImpl.updateBiddingInformationModel.num");
        }
    }

    private void updateStateBiddingInformationModel(Integer informationId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == informationId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("informationId", informationId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.pmBiddingInformationMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmBiddingInformationServiceImpl.updateStateBiddingInformationModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pm.PROMOTION.PmBiddingInformationServiceImpl.updateStateBiddingInformationModel.null");
        }
    }

    private void updateStateBiddingInformationModelByCode(String tenantCode, String informationCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)informationCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("informationCode", informationCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.pmBiddingInformationMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmBiddingInformationServiceImpl.updateStateBiddingInformationModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pm.PROMOTION.PmBiddingInformationServiceImpl.updateStateBiddingInformationModelByCode.null");
        }
    }

    private PmBiddingInformation makeBiddingInformation(PmBiddingInformationDomain pmBiddingInformationDomain, PmBiddingInformation pmBiddingInformation) {
        if (null == pmBiddingInformationDomain) {
            return null;
        }
        if (null == pmBiddingInformation) {
            pmBiddingInformation = new PmBiddingInformation();
        }
        try {
            BeanUtils.copyAllPropertys((Object)pmBiddingInformation, (Object)pmBiddingInformationDomain);
            return pmBiddingInformation;
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmBiddingInformationServiceImpl.makeBiddingInformation", (Throwable)e);
            return null;
        }
    }

    private PmBiddingInformationReDomain makePmBiddingInformationReDomain(PmBiddingInformation pmBiddingInformation) {
        if (null == pmBiddingInformation) {
            return null;
        }
        PmBiddingInformationReDomain pmBiddingInformationReDomain = new PmBiddingInformationReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)pmBiddingInformationReDomain, (Object)pmBiddingInformation);
            return pmBiddingInformationReDomain;
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmBiddingInformationServiceImpl.makePmBiddingInformationReDomain", (Throwable)e);
            return null;
        }
    }

    private List<PmBiddingInformation> queryBiddingInformationModelPage(Map<String, Object> parammap) {
        try {
            return this.pmBiddingInformationMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmBiddingInformationServiceImpl.queryBiddingInformationModel", (Throwable)e);
            return null;
        }
    }

    private int countBiddingInformation(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.pmBiddingInformationMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmBiddingInformationServiceImpl.countBiddingInformation", (Throwable)e);
        }
        return i;
    }

    private PmBiddingInformation createPmBiddingInformation(PmBiddingInformationDomain pmBiddingInformationDomain) {
        String msg = this.checkBiddingInformation(pmBiddingInformationDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pm.PROMOTION.PmBiddingInformationServiceImpl.saveBiddingInformation.checkBiddingInformation", msg);
        }
        PmBiddingInformation pmBiddingInformation = this.makeBiddingInformation(pmBiddingInformationDomain, null);
        this.setBiddingInformationDefault(pmBiddingInformation);
        return pmBiddingInformation;
    }

    @Override
    public String saveBiddingInformation(PmBiddingInformationDomain pmBiddingInformationDomain) throws ApiException {
        PmBiddingInformation pmBiddingInformation = this.createPmBiddingInformation(pmBiddingInformationDomain);
        this.saveBiddingInformationModel(pmBiddingInformation);
        return pmBiddingInformation.getInformationCode();
    }

    @Override
    public String saveBiddingInformationBatch(List<PmBiddingInformationDomain> pmBiddingInformationDomainList) throws ApiException {
        if (null == pmBiddingInformationDomainList || pmBiddingInformationDomainList.isEmpty()) {
            return null;
        }
        ArrayList<PmBiddingInformation> pmBiddingInformationList = new ArrayList<PmBiddingInformation>();
        String code = "";
        for (PmBiddingInformationDomain pmBiddingInformationDomain : pmBiddingInformationDomainList) {
            PmBiddingInformation pmBiddingInformation = this.createPmBiddingInformation(pmBiddingInformationDomain);
            code = pmBiddingInformation.getInformationCode();
            pmBiddingInformationList.add(pmBiddingInformation);
        }
        this.saveBiddingInformationBatchModel(pmBiddingInformationList);
        return code;
    }

    @Override
    public void updateBiddingInformationState(Integer informationId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == informationId) {
            return;
        }
        this.updateStateBiddingInformationModel(informationId, dataState, oldDataState, map);
    }

    @Override
    public void updateBiddingInformationStateByCode(String tenantCode, String informationCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)informationCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateBiddingInformationModelByCode(tenantCode, informationCode, dataState, oldDataState, map);
    }

    @Override
    public void updateBiddingInformation(PmBiddingInformationDomain pmBiddingInformationDomain) throws ApiException {
        String msg = this.checkBiddingInformation(pmBiddingInformationDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pm.PROMOTION.PmBiddingInformationServiceImpl.updateBiddingInformation.checkBiddingInformation", msg);
        }
        PmBiddingInformation oldPmBiddingInformation = this.getBiddingInformationModelById(pmBiddingInformationDomain.getInformationId());
        if (null == oldPmBiddingInformation) {
            throw new ApiException("pm.PROMOTION.PmBiddingInformationServiceImpl.updateBiddingInformation.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        PmBiddingInformation pmBiddingInformation = this.makeBiddingInformation(pmBiddingInformationDomain, oldPmBiddingInformation);
        this.setBiddingInformationUpdataDefault(pmBiddingInformation);
        this.updateBiddingInformationModel(pmBiddingInformation);
    }

    @Override
    public PmBiddingInformation getBiddingInformation(Integer informationId) {
        if (null == informationId) {
            return null;
        }
        return this.getBiddingInformationModelById(informationId);
    }

    @Override
    public void deleteBiddingInformation(Integer informationId) throws ApiException {
        if (null == informationId) {
            return;
        }
        this.deleteBiddingInformationModel(informationId);
    }

    @Override
    public QueryResult<PmBiddingInformation> queryBiddingInformationPage(Map<String, Object> map) {
        List<PmBiddingInformation> pmBiddingInformationList = this.queryBiddingInformationModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countBiddingInformation(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(pmBiddingInformationList);
        return queryResult;
    }

    @Override
    public PmBiddingInformation getBiddingInformationByCode(String tenantCode, String informationCode) throws ApiException {
        if (StringUtils.isBlank((String)informationCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("informationCode", informationCode);
        return this.getBiddingInformationModelByCode(map);
    }

    @Override
    public void deleteBiddingInformationByCode(String tenantCode, String informationCode) throws ApiException {
        if (StringUtils.isBlank((String)informationCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("informationCode", informationCode);
        this.delBiddingInformationModelByCode(map);
    }

    @Override
    public boolean existBiddingInformation(PmBiddingInformationDomain pmBiddingInformationDomain) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (StringUtils.isNotBlank((String)pmBiddingInformationDomain.getUuIdValue())) {
            map.put("uuIdValue", pmBiddingInformationDomain.getUuIdValue());
            map.put("informationDate", pmBiddingInformationDomain.getInformationDate());
            map.put("sourceCode", pmBiddingInformationDomain.getSourceCode());
        } else {
            map.put("showUrl", pmBiddingInformationDomain.getShowUrl());
            map.put("informationTitle", pmBiddingInformationDomain.getInformationTitle());
            map.put("informationDate", pmBiddingInformationDomain.getInformationDate());
            map.put("sourceCode", pmBiddingInformationDomain.getSourceCode());
        }
        return this.pmBiddingInformationMapper.count(map) > 0;
    }
}

