/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.pm.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.pm.dao.PmActivityDiscountGoodsMapper;
import com.yqbsoft.laser.service.pm.dao.PmActivityDiscountMapper;
import com.yqbsoft.laser.service.pm.domain.PmActivityDiscountDomain;
import com.yqbsoft.laser.service.pm.domain.PmActivityDiscountGoodsDomain;
import com.yqbsoft.laser.service.pm.domain.PmActivityDiscountReDomain;
import com.yqbsoft.laser.service.pm.model.PmActivityDiscount;
import com.yqbsoft.laser.service.pm.model.PmActivityDiscountGoods;
import com.yqbsoft.laser.service.pm.service.PmActivityDiscountGoodsService;
import com.yqbsoft.laser.service.pm.service.PmActivityDiscountService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PmActivityDiscountServiceImpl
extends BaseServiceImpl
implements PmActivityDiscountService {
    private static final String SYS_CODE = "pm.PROMOTION.PmActivityDiscountServiceImpl";
    private PmActivityDiscountMapper pmActivityDiscountMapper;
    private PmActivityDiscountGoodsService pmActivityDiscountGoodsService;
    private PmActivityDiscountGoodsMapper pmActivityDiscountGoodsMapper;

    public void setPmActivityDiscountGoodsMapper(PmActivityDiscountGoodsMapper pmActivityDiscountGoodsMapper) {
        this.pmActivityDiscountGoodsMapper = pmActivityDiscountGoodsMapper;
    }

    public void setPmActivityDiscountGoodsService(PmActivityDiscountGoodsService pmActivityDiscountGoodsService) {
        this.pmActivityDiscountGoodsService = pmActivityDiscountGoodsService;
    }

    public void setPmActivityDiscountMapper(PmActivityDiscountMapper pmActivityDiscountMapper) {
        this.pmActivityDiscountMapper = pmActivityDiscountMapper;
    }

    private Date getSysDate() {
        try {
            return this.pmActivityDiscountMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmActivityDiscountServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkActivityDiscount(PmActivityDiscountDomain pmActivityDiscountDomain) {
        if (null == pmActivityDiscountDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        return msg;
    }

    private void setActivityDiscountDefault(PmActivityDiscount pmActivityDiscount) {
        if (null == pmActivityDiscount) {
            return;
        }
        if (null == pmActivityDiscount.getDataState()) {
            pmActivityDiscount.setDataState(1);
        }
        Date date = this.getSysDate();
        if (null == pmActivityDiscount.getGmtCreate()) {
            pmActivityDiscount.setGmtCreate(date);
        }
        pmActivityDiscount.setGmtModified(date);
        if (StringUtils.isBlank((String)pmActivityDiscount.getTenantCode())) {
            pmActivityDiscount.setTenantCode("2020021100000063");
        }
        pmActivityDiscount.setPurchaseDiscountNumRemainder(pmActivityDiscount.getPurchaseDiscountNumTotle());
        if (StringUtils.isBlank((String)pmActivityDiscount.getActivityDiscountCode())) {
            pmActivityDiscount.setActivityDiscountCode(this.createUUIDString());
        }
    }

    private int getActivityDiscountMaxCode() {
        int code = 0;
        try {
            return this.pmActivityDiscountMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmActivityDiscountServiceImpl.getActivityDiscountMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setActivityDiscountUpdataDefault(PmActivityDiscount pmActivityDiscount) {
        if (null == pmActivityDiscount) {
            return;
        }
        pmActivityDiscount.setGmtModified(this.getSysDate());
    }

    private void saveActivityDiscountModel(PmActivityDiscount pmActivityDiscount) throws ApiException {
        if (null == pmActivityDiscount) {
            return;
        }
        try {
            this.pmActivityDiscountMapper.insert(pmActivityDiscount);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmActivityDiscountServiceImpl.saveActivityDiscountModel.ex", (Throwable)e);
        }
    }

    private void saveActivityDiscountBatchModel(List<PmActivityDiscount> pmActivityDiscountList) throws ApiException {
        if (null == pmActivityDiscountList || pmActivityDiscountList.isEmpty()) {
            return;
        }
        try {
            this.pmActivityDiscountMapper.insertBatch(pmActivityDiscountList);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmActivityDiscountServiceImpl.saveActivityDiscountBatchModel.ex", (Throwable)e);
        }
    }

    private PmActivityDiscount getActivityDiscountModelById(Integer activityDiscountId) {
        if (null == activityDiscountId) {
            return null;
        }
        try {
            return this.pmActivityDiscountMapper.selectByPrimaryKey(activityDiscountId);
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmActivityDiscountServiceImpl.getActivityDiscountModelById", (Throwable)e);
            return null;
        }
    }

    private PmActivityDiscount getActivityDiscountModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.pmActivityDiscountMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmActivityDiscountServiceImpl.getActivityDiscountModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delActivityDiscountModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.pmActivityDiscountMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmActivityDiscountServiceImpl.delActivityDiscountModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pm.PROMOTION.PmActivityDiscountServiceImpl.delActivityDiscountModelByCode.num");
        }
    }

    private void deleteActivityDiscountModel(Integer activityDiscountId) throws ApiException {
        if (null == activityDiscountId) {
            return;
        }
        int i = 0;
        try {
            i = this.pmActivityDiscountMapper.deleteByPrimaryKey(activityDiscountId);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmActivityDiscountServiceImpl.deleteActivityDiscountModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pm.PROMOTION.PmActivityDiscountServiceImpl.deleteActivityDiscountModel.num");
        }
    }

    private void updateActivityDiscountModel(PmActivityDiscount pmActivityDiscount) throws ApiException {
        if (null == pmActivityDiscount) {
            return;
        }
        int i = 0;
        try {
            i = this.pmActivityDiscountMapper.updateByPrimaryKey(pmActivityDiscount);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmActivityDiscountServiceImpl.updateActivityDiscountModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pm.PROMOTION.PmActivityDiscountServiceImpl.updateActivityDiscountModel.num");
        }
    }

    private void updateStateActivityDiscountModel(Integer activityDiscountId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == activityDiscountId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("activityDiscountId", activityDiscountId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.pmActivityDiscountMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmActivityDiscountServiceImpl.updateStateActivityDiscountModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pm.PROMOTION.PmActivityDiscountServiceImpl.updateStateActivityDiscountModel.null");
        }
    }

    private void updateStateActivityDiscountModelByCode(String tenantCode, String activityDiscountCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)activityDiscountCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("activityDiscountCode", activityDiscountCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.pmActivityDiscountMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmActivityDiscountServiceImpl.updateStateActivityDiscountModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pm.PROMOTION.PmActivityDiscountServiceImpl.updateStateActivityDiscountModelByCode.null");
        }
    }

    private PmActivityDiscount makeActivityDiscount(PmActivityDiscountDomain pmActivityDiscountDomain, PmActivityDiscount pmActivityDiscount) {
        if (null == pmActivityDiscountDomain) {
            return null;
        }
        if (null == pmActivityDiscount) {
            pmActivityDiscount = new PmActivityDiscount();
        }
        try {
            BeanUtils.copyAllPropertys((Object)pmActivityDiscount, (Object)pmActivityDiscountDomain);
            return pmActivityDiscount;
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmActivityDiscountServiceImpl.makeActivityDiscount", (Throwable)e);
            return null;
        }
    }

    private PmActivityDiscountReDomain makePmActivityDiscountReDomain(PmActivityDiscount pmActivityDiscount) {
        if (null == pmActivityDiscount) {
            return null;
        }
        PmActivityDiscountReDomain pmActivityDiscountReDomain = new PmActivityDiscountReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)pmActivityDiscountReDomain, (Object)pmActivityDiscount);
            return pmActivityDiscountReDomain;
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmActivityDiscountServiceImpl.makePmActivityDiscountReDomain", (Throwable)e);
            return null;
        }
    }

    private List<PmActivityDiscount> queryActivityDiscountModelPage(Map<String, Object> parammap) {
        try {
            return this.pmActivityDiscountMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmActivityDiscountServiceImpl.queryActivityDiscountModel", (Throwable)e);
            return null;
        }
    }

    private int countActivityDiscount(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.pmActivityDiscountMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmActivityDiscountServiceImpl.countActivityDiscount", (Throwable)e);
        }
        return i;
    }

    private PmActivityDiscount createPmActivityDiscount(PmActivityDiscountDomain pmActivityDiscountDomain) {
        String msg = this.checkActivityDiscount(pmActivityDiscountDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pm.PROMOTION.PmActivityDiscountServiceImpl.saveActivityDiscount.checkActivityDiscount", msg);
        }
        PmActivityDiscount pmActivityDiscount = this.makeActivityDiscount(pmActivityDiscountDomain, null);
        this.setActivityDiscountDefault(pmActivityDiscount);
        return pmActivityDiscount;
    }

    @Override
    public String saveActivityDiscount(PmActivityDiscountDomain pmActivityDiscountDomain) throws ApiException {
        PmActivityDiscount pmActivityDiscount = this.createPmActivityDiscount(pmActivityDiscountDomain);
        this.saveActivityDiscountModel(pmActivityDiscount);
        this.saveActivityDiscountModelRelatedData(pmActivityDiscountDomain, pmActivityDiscount);
        return pmActivityDiscount.getActivityDiscountCode();
    }

    private void saveActivityDiscountModelRelatedData(PmActivityDiscountDomain pmActivityDiscountDomain, PmActivityDiscount pmActivityDiscount) {
        List<PmActivityDiscountGoodsDomain> pmActivityDiscountGoodsList = pmActivityDiscountDomain.getPmActivityDiscountGoodsList();
        if (ListUtil.isNotEmpty(pmActivityDiscountGoodsList)) {
            for (PmActivityDiscountGoodsDomain pmActivityDiscountGoodsDomain : pmActivityDiscountGoodsList) {
                pmActivityDiscountGoodsDomain.setActivityDiscountCode(pmActivityDiscount.getActivityDiscountCode());
                pmActivityDiscountGoodsDomain.setGmtCreatePer(pmActivityDiscount.getGmtCreatePer());
                pmActivityDiscountGoodsDomain.setActivityDiscountName(pmActivityDiscount.getActivityDiscountName());
            }
            this.pmActivityDiscountGoodsService.saveActivityDiscountGoodsBatch(pmActivityDiscountGoodsList);
        }
    }

    @Override
    public String saveActivityDiscountBatch(List<PmActivityDiscountDomain> pmActivityDiscountDomainList) throws ApiException {
        if (null == pmActivityDiscountDomainList || pmActivityDiscountDomainList.isEmpty()) {
            return null;
        }
        ArrayList<PmActivityDiscount> pmActivityDiscountList = new ArrayList<PmActivityDiscount>();
        String code = "";
        for (PmActivityDiscountDomain pmActivityDiscountDomain : pmActivityDiscountDomainList) {
            PmActivityDiscount pmActivityDiscount = this.createPmActivityDiscount(pmActivityDiscountDomain);
            code = pmActivityDiscount.getActivityDiscountCode();
            pmActivityDiscountList.add(pmActivityDiscount);
        }
        this.saveActivityDiscountBatchModel(pmActivityDiscountList);
        return code;
    }

    @Override
    public void updateActivityDiscountState(Integer activityDiscountId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == activityDiscountId) {
            return;
        }
        this.updateStateActivityDiscountModel(activityDiscountId, dataState, oldDataState, map);
    }

    @Override
    public void updateActivityDiscountStateByCode(String tenantCode, String activityDiscountCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)activityDiscountCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateActivityDiscountModelByCode(tenantCode, activityDiscountCode, dataState, oldDataState, map);
    }

    @Override
    public void updateActivityDiscount(PmActivityDiscountDomain pmActivityDiscountDomain) throws ApiException {
        String msg = this.checkActivityDiscount(pmActivityDiscountDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pm.PROMOTION.PmActivityDiscountServiceImpl.updateActivityDiscount.checkActivityDiscount", msg);
        }
        PmActivityDiscount oldPmActivityDiscount = this.getActivityDiscountModelById(pmActivityDiscountDomain.getActivityDiscountId());
        if (null == oldPmActivityDiscount) {
            throw new ApiException("pm.PROMOTION.PmActivityDiscountServiceImpl.updateActivityDiscount.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        PmActivityDiscount pmActivityDiscount = this.makeActivityDiscount(pmActivityDiscountDomain, oldPmActivityDiscount);
        this.setActivityDiscountUpdataDefault(pmActivityDiscount);
        this.updateActivityDiscountModel(pmActivityDiscount);
    }

    @Override
    public PmActivityDiscount getActivityDiscount(Integer activityDiscountId) {
        if (null == activityDiscountId) {
            return null;
        }
        PmActivityDiscount activityDiscount = this.getActivityDiscountModelById(activityDiscountId);
        this.getPmActivityDiscountRelatedData(activityDiscount);
        return activityDiscount;
    }

    private void getPmActivityDiscountRelatedData(PmActivityDiscount activityDiscount) {
        if (null == activityDiscount) {
            return;
        }
        Map paramMap = this.getQueryParamMap("activityDiscountCode", new Object[]{activityDiscount.getActivityDiscountCode()});
        QueryResult<PmActivityDiscountGoods> pmActivityDiscountGoodsQueryResult = this.pmActivityDiscountGoodsService.queryActivityDiscountGoodsPage(paramMap);
        if (null != pmActivityDiscountGoodsQueryResult && null != pmActivityDiscountGoodsQueryResult.getList()) {
            activityDiscount.setPmActivityDiscountGoodsList(pmActivityDiscountGoodsQueryResult.getList());
        }
    }

    @Override
    public void deleteActivityDiscount(Integer activityDiscountId) throws ApiException {
        if (null == activityDiscountId) {
            return;
        }
        this.deleteActivityDiscountModel(activityDiscountId);
    }

    @Override
    public QueryResult<PmActivityDiscount> queryActivityDiscountPage(Map<String, Object> map) {
        List<PmActivityDiscount> pmActivityDiscountList = this.queryActivityDiscountModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countActivityDiscount(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(pmActivityDiscountList);
        return queryResult;
    }

    @Override
    public PmActivityDiscount getActivityDiscountByCode(String tenantCode, String activityDiscountCode) throws ApiException {
        if (StringUtils.isBlank((String)activityDiscountCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("activityDiscountCode", activityDiscountCode);
        return this.getActivityDiscountModelByCode(map);
    }

    @Override
    public void deleteActivityDiscountByCode(String tenantCode, String activityDiscountCode) throws ApiException {
        if (StringUtils.isBlank((String)activityDiscountCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("activityDiscountCode", activityDiscountCode);
        this.delActivityDiscountModelByCode(map);
    }

    @Override
    public void updateActivityDiscountNum(String activityDiscountCode, String goodsNumStr) throws ApiException {
        List goodsNumList = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)goodsNumStr.split(",")), BigDecimal.class);
        PmActivityDiscount activityDiscount = this.getActivityDiscountByCode("2020021100000063", activityDiscountCode);
        if (activityDiscount.getActivityDiscountType() == 0) {
            Map paramMap = this.getQueryParamMap("activityDiscountCode", new Object[]{activityDiscountCode});
            QueryResult<PmActivityDiscountGoods> pmActivityDiscountGoodsQueryResult = this.pmActivityDiscountGoodsService.queryActivityDiscountGoodsPage(paramMap);
            List pmActivityDiscountGoodsList = pmActivityDiscountGoodsQueryResult.getList();
            for (int i = 0; i < pmActivityDiscountGoodsList.size(); ++i) {
                if (((PmActivityDiscountGoods)pmActivityDiscountGoodsList.get(i)).getGoodsOrdnumTotle() == null) continue;
                this.pmActivityDiscountGoodsService.updateNum(((PmActivityDiscountGoods)pmActivityDiscountGoodsList.get(i)).getActivityDiscountGoodsCode(), (BigDecimal)goodsNumList.get(i));
            }
        } else if (activityDiscount.getPurchaseDiscountNumTotle() != null) {
            this.updateNum(activityDiscountCode, (BigDecimal)goodsNumList.get(0));
        }
    }

    @Override
    public void updateNum(String activityDiscountCode, BigDecimal bigDecimal) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("purchaseDiscountNum", bigDecimal);
        param.put("activityDiscountCode", activityDiscountCode);
        int i = 0;
        try {
            i = this.pmActivityDiscountMapper.updateRemainderNum(param);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmActivityDiscountServiceImpl.updateNum.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pm.PROMOTION.PmActivityDiscountServiceImpl.updateNum.null", "\u66f4\u65b0\u6570\u91cf\u5931\u8d25");
        }
    }

    @Override
    public String checkActivityDiscountNum(String activityDiscountCode, String goodsNumStr, String userCode) throws ApiException {
        List goodsNumList = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)goodsNumStr.split(",")), BigDecimal.class);
        PmActivityDiscount activityDiscount = this.getActivityDiscountByCode("2020021100000063", activityDiscountCode);
        if (activityDiscount.getDiscountNum() != null) {
            String result = this.internalInvoke("oc.contract.countUserActivity", this.getQueryMapParam("activityDiscountCode,userCode", new Object[]{activityDiscountCode, userCode}));
            BigDecimal num = (BigDecimal)JsonUtil.buildNormalBinder().getJsonToObject(result, BigDecimal.class);
            if (activityDiscount.getDiscountNum().compareTo(num.add(new BigDecimal(1))) < 0) {
                return "\u8d85\u8fc7\u5957\u9910\u8d2d\u4e70\u6b21\u6570";
            }
        }
        if (activityDiscount.getActivityDiscountType() == 0) {
            Map paramMap = this.getQueryParamMap("activityDiscountCode", new Object[]{activityDiscountCode});
            QueryResult<PmActivityDiscountGoods> pmActivityDiscountGoodsQueryResult = this.pmActivityDiscountGoodsService.queryActivityDiscountGoodsPage(paramMap);
            List pmActivityDiscountGoodsList = pmActivityDiscountGoodsQueryResult.getList();
            for (int i = 0; i < pmActivityDiscountGoodsList.size(); ++i) {
                PmActivityDiscountGoods pmActivityDiscountGoods = (PmActivityDiscountGoods)pmActivityDiscountGoodsList.get(i);
                if (((BigDecimal)goodsNumList.get(i)).compareTo(pmActivityDiscountGoods.getGoodsOrdnum()) < 0) {
                    return "\u7b2c" + i + "\u4e2a\u5546\u54c1\u8d2d\u4e70\u6570\u91cf\u5c0f\u4e8e\u8d77\u8ba2\u91cf";
                }
                if (pmActivityDiscountGoods.getGoodsOrdnumMax() != null && ((BigDecimal)goodsNumList.get(i)).compareTo(pmActivityDiscountGoods.getGoodsOrdnumMax()) > 0) {
                    return "\u7b2c" + i + "\u4e2a\u5546\u54c1\u8d2d\u4e70\u6570\u91cf\u5927\u4e8e\u6700\u5927\u8d2d\u4e70\u91cf";
                }
                if (pmActivityDiscountGoods.getGoodsOrdnumRemainder() == null || ((BigDecimal)goodsNumList.get(i)).compareTo(pmActivityDiscountGoods.getGoodsOrdnumRemainder()) <= 0) continue;
                return "\u7b2c" + i + "\u4e2a\u5546\u54c1\u8d2d\u4e70\u6570\u91cf\u8d85\u8fc7\u7d2f\u8ba1\u8d2d\u4e70\u91cf";
            }
        } else {
            if (((BigDecimal)goodsNumList.get(0)).compareTo(activityDiscount.getPurchaseDiscountNum()) < 0) {
                return "\u8d2d\u4e70\u6570\u91cf\u5c0f\u4e8e\u8d77\u8ba2\u91cf";
            }
            if (activityDiscount.getPurchaseDiscountNumOnce() != null && ((BigDecimal)goodsNumList.get(0)).compareTo(activityDiscount.getPurchaseDiscountNumOnce()) > 0) {
                return "\u8d2d\u4e70\u6570\u91cf\u5927\u4e8e\u6700\u5927\u8d2d\u4e70\u91cf";
            }
            if (activityDiscount.getPurchaseDiscountNumRemainder() != null && ((BigDecimal)goodsNumList.get(0)).compareTo(activityDiscount.getPurchaseDiscountNumRemainder()) > 0) {
                return "\u8d2d\u4e70\u6570\u91cf\u8d85\u8fc7\u7d2f\u8ba1\u8d2d\u4e70\u91cf";
            }
        }
        return null;
    }
}

