/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.pm.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.pm.dao.PmActivityRegisterGiftMapper;
import com.yqbsoft.laser.service.pm.domain.PmActivityRegisterGiftCouponDomain;
import com.yqbsoft.laser.service.pm.domain.PmActivityRegisterGiftDomain;
import com.yqbsoft.laser.service.pm.domain.PmActivityRegisterGiftReDomain;
import com.yqbsoft.laser.service.pm.domain.PmPromotionBaseDomain;
import com.yqbsoft.laser.service.pm.domain.PmReceiveUserBean;
import com.yqbsoft.laser.service.pm.domain.PmRegisterUserBean;
import com.yqbsoft.laser.service.pm.domain.PmUserCouponDomain;
import com.yqbsoft.laser.service.pm.model.PmActivityRegisterGift;
import com.yqbsoft.laser.service.pm.model.PmActivityRegisterGiftCoupon;
import com.yqbsoft.laser.service.pm.model.PmPromotion;
import com.yqbsoft.laser.service.pm.model.PmPromotionBase;
import com.yqbsoft.laser.service.pm.model.PmPromotionDiscount;
import com.yqbsoft.laser.service.pm.service.PmActivityRegisterGiftCouponService;
import com.yqbsoft.laser.service.pm.service.PmActivityRegisterGiftService;
import com.yqbsoft.laser.service.pm.service.PmPromotionBaseService;
import com.yqbsoft.laser.service.pm.service.PmPromotionDiscountService;
import com.yqbsoft.laser.service.pm.service.PmPromotionService;
import com.yqbsoft.laser.service.pm.service.PmUserCouponService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PmActivityRegisterGiftServiceImpl
extends BaseServiceImpl
implements PmActivityRegisterGiftService {
    private static final String SYS_CODE = "pm.PROMOTION.PmActivityRegisterGiftServiceImpl";
    private PmActivityRegisterGiftMapper pmActivityRegisterGiftMapper;
    private PmActivityRegisterGiftCouponService pmActivityRegisterGiftCouponService;
    private PmPromotionService pmPromotionService;
    private PmUserCouponService pmUserCouponService;
    private PmPromotionDiscountService pmPromotionDiscountService;
    private PmPromotionBaseService pmPromotionBaseService;

    public void setPmPromotionBaseService(PmPromotionBaseService pmPromotionBaseService) {
        this.pmPromotionBaseService = pmPromotionBaseService;
    }

    public void setPmPromotionDiscountService(PmPromotionDiscountService pmPromotionDiscountService) {
        this.pmPromotionDiscountService = pmPromotionDiscountService;
    }

    public void setPmUserCouponService(PmUserCouponService pmUserCouponService) {
        this.pmUserCouponService = pmUserCouponService;
    }

    public void setPmActivityRegisterGiftCouponService(PmActivityRegisterGiftCouponService pmActivityRegisterGiftCouponService) {
        this.pmActivityRegisterGiftCouponService = pmActivityRegisterGiftCouponService;
    }

    public void setPmPromotionService(PmPromotionService pmPromotionService) {
        this.pmPromotionService = pmPromotionService;
    }

    public void setPmActivityRegisterGiftMapper(PmActivityRegisterGiftMapper pmActivityRegisterGiftMapper) {
        this.pmActivityRegisterGiftMapper = pmActivityRegisterGiftMapper;
    }

    private Date getSysDate() {
        try {
            return this.pmActivityRegisterGiftMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmActivityRegisterGiftServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkActivityRegisterGift(PmActivityRegisterGiftDomain pmActivityRegisterGiftDomain) {
        if (null == pmActivityRegisterGiftDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        return msg;
    }

    private void setActivityRegisterGiftDefault(PmActivityRegisterGift pmActivityRegisterGift) {
        if (null == pmActivityRegisterGift) {
            return;
        }
        if (null == pmActivityRegisterGift.getDataState()) {
            pmActivityRegisterGift.setDataState(1);
        }
        Date date = this.getSysDate();
        if (null == pmActivityRegisterGift.getGmtCreate()) {
            pmActivityRegisterGift.setGmtCreate(date);
        }
        if (null == pmActivityRegisterGift.getPermanentType()) {
            pmActivityRegisterGift.setPermanentType(0);
        }
        pmActivityRegisterGift.setGmtModified(date);
        if (StringUtils.isBlank((String)pmActivityRegisterGift.getRegisterGiftCode())) {
            pmActivityRegisterGift.setRegisterGiftCode(this.createUUIDString());
        }
    }

    private int getActivityRegisterGiftMaxCode() {
        int code = 0;
        try {
            return this.pmActivityRegisterGiftMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmActivityRegisterGiftServiceImpl.getActivityRegisterGiftMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setActivityRegisterGiftUpdataDefault(PmActivityRegisterGift pmActivityRegisterGift) {
        if (null == pmActivityRegisterGift) {
            return;
        }
        pmActivityRegisterGift.setGmtModified(this.getSysDate());
    }

    private void saveActivityRegisterGiftModel(PmActivityRegisterGift pmActivityRegisterGift) throws ApiException {
        if (null == pmActivityRegisterGift) {
            return;
        }
        try {
            this.pmActivityRegisterGiftMapper.insert(pmActivityRegisterGift);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmActivityRegisterGiftServiceImpl.saveActivityRegisterGiftModel.ex", (Throwable)e);
        }
    }

    private void saveActivityRegisterGiftBatchModel(List<PmActivityRegisterGift> pmActivityRegisterGiftList) throws ApiException {
        if (null == pmActivityRegisterGiftList || pmActivityRegisterGiftList.isEmpty()) {
            return;
        }
        try {
            this.pmActivityRegisterGiftMapper.insertBatch(pmActivityRegisterGiftList);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmActivityRegisterGiftServiceImpl.saveActivityRegisterGiftBatchModel.ex", (Throwable)e);
        }
    }

    private PmActivityRegisterGift getActivityRegisterGiftModelById(Integer registerGiftId) {
        if (null == registerGiftId) {
            return null;
        }
        try {
            return this.pmActivityRegisterGiftMapper.selectByPrimaryKey(registerGiftId);
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmActivityRegisterGiftServiceImpl.getActivityRegisterGiftModelById", (Throwable)e);
            return null;
        }
    }

    private PmActivityRegisterGift getActivityRegisterGiftModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.pmActivityRegisterGiftMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmActivityRegisterGiftServiceImpl.getActivityRegisterGiftModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delActivityRegisterGiftModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.pmActivityRegisterGiftMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmActivityRegisterGiftServiceImpl.delActivityRegisterGiftModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pm.PROMOTION.PmActivityRegisterGiftServiceImpl.delActivityRegisterGiftModelByCode.num");
        }
    }

    private void deleteActivityRegisterGiftModel(Integer registerGiftId) throws ApiException {
        if (null == registerGiftId) {
            return;
        }
        int i = 0;
        try {
            i = this.pmActivityRegisterGiftMapper.deleteByPrimaryKey(registerGiftId);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmActivityRegisterGiftServiceImpl.deleteActivityRegisterGiftModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pm.PROMOTION.PmActivityRegisterGiftServiceImpl.deleteActivityRegisterGiftModel.num");
        }
    }

    private void updateActivityRegisterGiftModel(PmActivityRegisterGift pmActivityRegisterGift) throws ApiException {
        if (null == pmActivityRegisterGift) {
            return;
        }
        int i = 0;
        try {
            i = this.pmActivityRegisterGiftMapper.updateByPrimaryKey(pmActivityRegisterGift);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmActivityRegisterGiftServiceImpl.updateActivityRegisterGiftModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pm.PROMOTION.PmActivityRegisterGiftServiceImpl.updateActivityRegisterGiftModel.num");
        }
    }

    private void updateStateActivityRegisterGiftModel(Integer registerGiftId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == registerGiftId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("registerGiftId", registerGiftId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.pmActivityRegisterGiftMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmActivityRegisterGiftServiceImpl.updateStateActivityRegisterGiftModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pm.PROMOTION.PmActivityRegisterGiftServiceImpl.updateStateActivityRegisterGiftModel.null");
        }
    }

    private void updateStateActivityRegisterGiftModelByCode(String tenantCode, String registerGiftCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)registerGiftCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("registerGiftCode", registerGiftCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.pmActivityRegisterGiftMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmActivityRegisterGiftServiceImpl.updateStateActivityRegisterGiftModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pm.PROMOTION.PmActivityRegisterGiftServiceImpl.updateStateActivityRegisterGiftModelByCode.null");
        }
    }

    private PmActivityRegisterGift makeActivityRegisterGift(PmActivityRegisterGiftDomain pmActivityRegisterGiftDomain, PmActivityRegisterGift pmActivityRegisterGift) {
        if (null == pmActivityRegisterGiftDomain) {
            return null;
        }
        if (null == pmActivityRegisterGift) {
            pmActivityRegisterGift = new PmActivityRegisterGift();
        }
        try {
            BeanUtils.copyAllPropertys((Object)pmActivityRegisterGift, (Object)pmActivityRegisterGiftDomain);
            return pmActivityRegisterGift;
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmActivityRegisterGiftServiceImpl.makeActivityRegisterGift", (Throwable)e);
            return null;
        }
    }

    private PmActivityRegisterGiftReDomain makePmActivityRegisterGiftReDomain(PmActivityRegisterGift pmActivityRegisterGift) {
        if (null == pmActivityRegisterGift) {
            return null;
        }
        PmActivityRegisterGiftReDomain pmActivityRegisterGiftReDomain = new PmActivityRegisterGiftReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)pmActivityRegisterGiftReDomain, (Object)pmActivityRegisterGift);
            return pmActivityRegisterGiftReDomain;
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmActivityRegisterGiftServiceImpl.makePmActivityRegisterGiftReDomain", (Throwable)e);
            return null;
        }
    }

    private List<PmActivityRegisterGift> queryActivityRegisterGiftModelPage(Map<String, Object> parammap) {
        try {
            return this.pmActivityRegisterGiftMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmActivityRegisterGiftServiceImpl.queryActivityRegisterGiftModel", (Throwable)e);
            return null;
        }
    }

    private int countActivityRegisterGift(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.pmActivityRegisterGiftMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmActivityRegisterGiftServiceImpl.countActivityRegisterGift", (Throwable)e);
        }
        return i;
    }

    private PmActivityRegisterGift createPmActivityRegisterGift(PmActivityRegisterGiftDomain pmActivityRegisterGiftDomain) {
        String msg = this.checkActivityRegisterGift(pmActivityRegisterGiftDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pm.PROMOTION.PmActivityRegisterGiftServiceImpl.saveActivityRegisterGift.checkActivityRegisterGift", msg);
        }
        PmActivityRegisterGift pmActivityRegisterGift = this.makeActivityRegisterGift(pmActivityRegisterGiftDomain, null);
        this.setActivityRegisterGiftDefault(pmActivityRegisterGift);
        return pmActivityRegisterGift;
    }

    @Override
    public String saveActivityRegisterGift(PmActivityRegisterGiftDomain pmActivityRegisterGiftDomain) throws ApiException {
        PmActivityRegisterGift pmActivityRegisterGift = this.createPmActivityRegisterGift(pmActivityRegisterGiftDomain);
        this.saveActivityRegisterGiftModel(pmActivityRegisterGift);
        this.saveActivityRegisterGiftRelatedData(pmActivityRegisterGiftDomain, pmActivityRegisterGift);
        return pmActivityRegisterGift.getRegisterGiftCode();
    }

    private void saveActivityRegisterGiftRelatedData(PmActivityRegisterGiftDomain pmActivityRegisterGiftDomain, PmActivityRegisterGift pmActivityRegisterGift) {
        List<PmActivityRegisterGiftCouponDomain> pmActivityRegisterGiftCouponList = pmActivityRegisterGiftDomain.getPmActivityRegisterGiftCouponList();
        if (null != pmActivityRegisterGiftCouponList && pmActivityRegisterGiftCouponList.size() > 0) {
            for (PmActivityRegisterGiftCouponDomain pmActivityRegisterGiftCouponDomain : pmActivityRegisterGiftCouponList) {
                pmActivityRegisterGiftCouponDomain.setGmtCreatePer(pmActivityRegisterGift.getGmtCreatePer());
                pmActivityRegisterGiftCouponDomain.setRegisterGiftId(pmActivityRegisterGift.getRegisterGiftId());
                pmActivityRegisterGiftCouponDomain.setRegisterGiftCode(pmActivityRegisterGift.getRegisterGiftCode());
                pmActivityRegisterGiftCouponDomain.setTenantCode(pmActivityRegisterGift.getTenantCode());
            }
            this.pmActivityRegisterGiftCouponService.saveActivityRegisterGiftCouponBatch(pmActivityRegisterGiftCouponList);
        }
    }

    @Override
    public String saveActivityRegisterGiftBatch(List<PmActivityRegisterGiftDomain> pmActivityRegisterGiftDomainList) throws ApiException {
        if (null == pmActivityRegisterGiftDomainList || pmActivityRegisterGiftDomainList.isEmpty()) {
            return null;
        }
        ArrayList<PmActivityRegisterGift> pmActivityRegisterGiftList = new ArrayList<PmActivityRegisterGift>();
        String code = "";
        for (PmActivityRegisterGiftDomain pmActivityRegisterGiftDomain : pmActivityRegisterGiftDomainList) {
            PmActivityRegisterGift pmActivityRegisterGift = this.createPmActivityRegisterGift(pmActivityRegisterGiftDomain);
            code = pmActivityRegisterGift.getRegisterGiftCode();
            pmActivityRegisterGiftList.add(pmActivityRegisterGift);
        }
        this.saveActivityRegisterGiftBatchModel(pmActivityRegisterGiftList);
        return code;
    }

    @Override
    public void updateActivityRegisterGiftState(Integer registerGiftId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == registerGiftId) {
            return;
        }
        this.updateStateActivityRegisterGiftModel(registerGiftId, dataState, oldDataState, map);
    }

    @Override
    public void updateActivityRegisterGiftStateByCode(String tenantCode, String registerGiftCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)registerGiftCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateActivityRegisterGiftModelByCode(tenantCode, registerGiftCode, dataState, oldDataState, map);
    }

    @Override
    public void updateActivityRegisterGift(PmActivityRegisterGiftDomain pmActivityRegisterGiftDomain) throws ApiException {
        String msg = this.checkActivityRegisterGift(pmActivityRegisterGiftDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pm.PROMOTION.PmActivityRegisterGiftServiceImpl.updateActivityRegisterGift.checkActivityRegisterGift", msg);
        }
        PmActivityRegisterGift oldPmActivityRegisterGift = this.getActivityRegisterGiftModelById(pmActivityRegisterGiftDomain.getRegisterGiftId());
        if (null == oldPmActivityRegisterGift) {
            throw new ApiException("pm.PROMOTION.PmActivityRegisterGiftServiceImpl.updateActivityRegisterGift.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        PmActivityRegisterGift pmActivityRegisterGift = this.makeActivityRegisterGift(pmActivityRegisterGiftDomain, oldPmActivityRegisterGift);
        this.setActivityRegisterGiftUpdataDefault(pmActivityRegisterGift);
        this.updateActivityRegisterGiftModel(pmActivityRegisterGift);
    }

    @Override
    public PmActivityRegisterGift getActivityRegisterGift(Integer registerGiftId) {
        if (null == registerGiftId) {
            return null;
        }
        PmActivityRegisterGift activityRegisterGift = this.getActivityRegisterGiftModelById(registerGiftId);
        this.getPmActivityRegisterGiftRelatedData(activityRegisterGift);
        return activityRegisterGift;
    }

    private void getPmActivityRegisterGiftRelatedData(PmActivityRegisterGift activityRegisterGift) {
        if (null == activityRegisterGift) {
            return;
        }
        Map paramMap = this.getQueryParamMap("registerGiftCode,tenantCode", new Object[]{activityRegisterGift.getRegisterGiftCode(), activityRegisterGift.getTenantCode()});
        QueryResult<PmActivityRegisterGiftCoupon> pmActivityRegisterGiftCouponQueryResult = this.pmActivityRegisterGiftCouponService.queryActivityRegisterGiftCouponPage(paramMap);
        if (null != pmActivityRegisterGiftCouponQueryResult && null != pmActivityRegisterGiftCouponQueryResult.getList()) {
            activityRegisterGift.setPmActivityRegisterGiftCouponList(pmActivityRegisterGiftCouponQueryResult.getList());
        }
    }

    @Override
    public void deleteActivityRegisterGift(Integer registerGiftId) throws ApiException {
        if (null == registerGiftId) {
            return;
        }
        this.deleteActivityRegisterGiftModel(registerGiftId);
    }

    @Override
    public QueryResult<PmActivityRegisterGift> queryActivityRegisterGiftPage(Map<String, Object> map) {
        List<PmActivityRegisterGift> pmActivityRegisterGiftList = this.queryActivityRegisterGiftModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countActivityRegisterGift(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(pmActivityRegisterGiftList);
        return queryResult;
    }

    @Override
    public PmActivityRegisterGift getActivityRegisterGiftByCode(String tenantCode, String registerGiftCode) throws ApiException {
        if (StringUtils.isBlank((String)registerGiftCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("registerGiftCode", registerGiftCode);
        return this.getActivityRegisterGiftModelByCode(map);
    }

    @Override
    public void deleteActivityRegisterGiftByCode(String tenantCode, String registerGiftCode) throws ApiException {
        if (StringUtils.isBlank((String)registerGiftCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("registerGiftCode", registerGiftCode);
        this.delActivityRegisterGiftModelByCode(map);
    }

    @Override
    public String savePromotionUser(PmRegisterUserBean pmRegisterUserBean) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("drawStatus", pmRegisterUserBean.getDrawStatus());
        map.put("dataState", 1);
        List<PmActivityRegisterGift> pmActivityRegisterGifts = this.queryActivityRegisterGiftModelPage(map);
        if (pmActivityRegisterGifts != null && pmActivityRegisterGifts.size() > 0) {
            for (PmActivityRegisterGift pmActivityRegisterGift : pmActivityRegisterGifts) {
                PmReceiveUserBean receiveUserBean;
                if (!this.checkActivityRegisterGiftStatus(pmActivityRegisterGift) || (receiveUserBean = this.createReceiveUser(pmActivityRegisterGift.getDrawType(), pmRegisterUserBean)) == null) continue;
                this.sentUserCoupon(pmActivityRegisterGift, receiveUserBean);
            }
        }
        return null;
    }

    private boolean checkIsSendCoupon(String memberBcode) {
        HashMap<String, Object> param1 = new HashMap<String, Object>();
        param1.put("memberBcode", memberBcode);
        param1.put("usercouponOrgin", "5");
        Integer res1 = this.pmUserCouponService.getCount(param1);
        return res1 > 0;
    }

    private boolean checkActivityRegisterGiftStatus(PmActivityRegisterGift pmActivityRegisterGift) {
        long nowTime = new Date().getTime();
        if (pmActivityRegisterGift.getPermanentType() == 1) {
            return true;
        }
        return nowTime >= pmActivityRegisterGift.getActivityBeginTime().getTime() && nowTime <= pmActivityRegisterGift.getActivityEndTime().getTime();
    }

    private void sentUserCoupon(PmActivityRegisterGift pmActivityRegisterGift, PmReceiveUserBean receiveUserBean) {
        ArrayList<PmUserCouponDomain> pmUserCouponDomainArrayList = new ArrayList<PmUserCouponDomain>();
        List<PmActivityRegisterGiftCoupon> pmActivityRegisterGiftCoupons = this.pmActivityRegisterGiftCouponService.queryPageByRegisterGiftCode(pmActivityRegisterGift.getRegisterGiftCode());
        if (pmActivityRegisterGiftCoupons != null && pmActivityRegisterGiftCoupons.size() > 0) {
            for (PmActivityRegisterGiftCoupon pmActivityRegisterGiftCoupon : pmActivityRegisterGiftCoupons) {
                PmUserCouponDomain pmUserCouponDomain = this.makeUserCoupon(pmActivityRegisterGiftCoupon, receiveUserBean);
                pmUserCouponDomainArrayList.add(pmUserCouponDomain);
            }
        }
        if (pmUserCouponDomainArrayList.size() > 0) {
            this.pmUserCouponService.saveUserCouponBatch(pmUserCouponDomainArrayList);
        }
    }

    private PmUserCouponDomain makeUserCoupon(PmActivityRegisterGiftCoupon pmActivityRegisterGiftCoupon, PmReceiveUserBean receiveUserBean) {
        if (null == pmActivityRegisterGiftCoupon || null == receiveUserBean) {
            return null;
        }
        PmPromotion pmPromotion = this.pmPromotionService.getPromotionByCode(pmActivityRegisterGiftCoupon.getTenantCode(), pmActivityRegisterGiftCoupon.getPromotionCode());
        PmPromotionBaseDomain pmPromotionBaseDomain = (PmPromotionBaseDomain)DisUtil.getMapJson((String)"pm-promotion-base", (String)(pmPromotion.getPbCode() + "-" + pmActivityRegisterGiftCoupon.getTenantCode()), PmPromotionBaseDomain.class);
        if (null == pmPromotionBaseDomain) {
            pmPromotionBaseDomain = (PmPromotionBaseDomain)DisUtil.getMapJson((String)"pm-promotion-base", (String)(pmPromotion.getPbCode() + "-" + "00000000"), PmPromotionBaseDomain.class);
        }
        if (null == pmPromotionBaseDomain) {
            try {
                PmPromotionBase promotionBaseByCode = this.pmPromotionBaseService.getPromotionBaseByCode("00000000", pmPromotion.getPbCode());
                if (null == promotionBaseByCode) {
                    return null;
                }
                pmPromotionBaseDomain = new PmPromotionBaseDomain();
                BeanUtils.copyAllPropertys((Object)pmPromotionBaseDomain, (Object)promotionBaseByCode);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        PmUserCouponDomain pmUserCouponDomain = new PmUserCouponDomain();
        pmUserCouponDomain.setUsercouponOrgin("5");
        pmUserCouponDomain.setPbCode(pmPromotion.getPbCode());
        pmUserCouponDomain.setPromotionCode(pmPromotion.getPromotionCode());
        pmUserCouponDomain.setPromotionName(pmPromotion.getPromotionName());
        pmUserCouponDomain.setCouponBatch(pmPromotion.getCouponBatch());
        pmUserCouponDomain.setPbName(pmPromotionBaseDomain.getPbName());
        pmUserCouponDomain.setTenantCode(pmActivityRegisterGiftCoupon.getTenantCode());
        pmUserCouponDomain.setPbLogo(pmPromotionBaseDomain.getPbLogo());
        pmUserCouponDomain.setMemberCode(pmPromotion.getMemberCode());
        pmUserCouponDomain.setMemberName(pmPromotion.getMemberName());
        pmUserCouponDomain.setPromotionDis(pmPromotion.getPromotionDis());
        pmUserCouponDomain.setPromotionDisstr(pmPromotion.getChannelCode());
        pmUserCouponDomain.setMemberBcode(receiveUserBean.getMemberBcode());
        pmUserCouponDomain.setMemberBname(receiveUserBean.getUserName());
        pmUserCouponDomain.setUserCode(receiveUserBean.getUserCode());
        pmUserCouponDomain.setUserName(receiveUserBean.getUserName());
        pmUserCouponDomain.setProappCode("029");
        Date couponStart = new Date();
        pmUserCouponDomain.setCouponStart(couponStart);
        pmUserCouponDomain.setCouponEnd(this.createCouponEnd(couponStart, pmPromotion));
        HashMap<String, Object> objectObjectHashMap = new HashMap<String, Object>();
        objectObjectHashMap.put("promotionCode", pmPromotion.getPromotionCode());
        QueryResult<PmPromotionDiscount> pmPromotionDiscountQueryResult = this.pmPromotionDiscountService.queryPromotionDiscountPage(objectObjectHashMap);
        if (pmPromotionDiscountQueryResult.getTotal() > 0L) {
            List list = pmPromotionDiscountQueryResult.getList();
            pmUserCouponDomain.setDiscType(((PmPromotionDiscount)list.get(0)).getDiscType());
            pmUserCouponDomain.setDiscAmount(((PmPromotionDiscount)list.get(0)).getDiscAmount());
            pmUserCouponDomain.setDiscName(((PmPromotionDiscount)list.get(0)).getDiscName());
            pmUserCouponDomain.setDiscStart(((PmPromotionDiscount)list.get(0)).getDiscStart());
            pmUserCouponDomain.setDiscEnd(((PmPromotionDiscount)list.get(0)).getDiscEnd());
        }
        return pmUserCouponDomain;
    }

    private Date createCouponEnd(Date couponStart, PmPromotion pmPromotion) {
        Date couponEnd = null;
        GregorianCalendar calendar = new GregorianCalendar();
        switch (pmPromotion.getEffectiveTimeType()) {
            case 0: {
                calendar.setTime(couponStart);
                ((Calendar)calendar).add(1, 100);
                couponEnd = calendar.getTime();
                break;
            }
            case 1: {
                calendar.setTime(couponStart);
                ((Calendar)calendar).add(2, 1);
                couponEnd = calendar.getTime();
                break;
            }
            case 2: {
                calendar.setTime(couponStart);
                ((Calendar)calendar).add(2, 2);
                couponEnd = calendar.getTime();
                break;
            }
            case 3: {
                calendar.setTime(couponStart);
                ((Calendar)calendar).add(2, 3);
                couponEnd = calendar.getTime();
                break;
            }
            case 4: {
                calendar.setTime(couponStart);
                ((Calendar)calendar).add(2, 6);
                couponEnd = calendar.getTime();
                break;
            }
            case 5: {
                if (pmPromotion.getEffectiveTimeUnit() == 0) {
                    calendar.setTime(couponStart);
                    ((Calendar)calendar).add(5, pmPromotion.getEffectiveTimeNum());
                    couponEnd = calendar.getTime();
                    break;
                }
                calendar.setTime(couponStart);
                ((Calendar)calendar).add(2, pmPromotion.getEffectiveTimeNum());
                couponEnd = calendar.getTime();
            }
        }
        return couponEnd;
    }

    private PmReceiveUserBean createReceiveUser(Integer drawType, PmRegisterUserBean pmRegisterUserBean) {
        if (null == drawType || null == pmRegisterUserBean) {
            return null;
        }
        PmReceiveUserBean receiveUserBean = new PmReceiveUserBean();
        receiveUserBean.setTenantCode(pmRegisterUserBean.getTenantCode());
        receiveUserBean.setDrawStatus(pmRegisterUserBean.getDrawStatus());
        if (drawType == 0) {
            receiveUserBean.setUserId(pmRegisterUserBean.getUserId());
            receiveUserBean.setUserCode(pmRegisterUserBean.getUserCode());
            receiveUserBean.setUserName(pmRegisterUserBean.getUserName());
            receiveUserBean.setMemberBcode(pmRegisterUserBean.getUserPcode());
        } else {
            if (StringUtils.isBlank((String)pmRegisterUserBean.getPuserPcode())) {
                return null;
            }
            receiveUserBean.setUserId(pmRegisterUserBean.getPuserId());
            receiveUserBean.setUserCode(pmRegisterUserBean.getPuserCode());
            receiveUserBean.setUserName(pmRegisterUserBean.getPuserName());
            receiveUserBean.setMemberBcode(pmRegisterUserBean.getPuserPcode());
        }
        return receiveUserBean;
    }
}

