/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.pm.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.pm.PromotionConstants;
import com.yqbsoft.laser.service.pm.dao.PmDistributeMapper;
import com.yqbsoft.laser.service.pm.domain.PmDistributeCouponDomain;
import com.yqbsoft.laser.service.pm.domain.PmDistributeDomain;
import com.yqbsoft.laser.service.pm.domain.PmDistributeReDomain;
import com.yqbsoft.laser.service.pm.domain.PmDistributeUserDomain;
import com.yqbsoft.laser.service.pm.domain.PmPromotionBaseDomain;
import com.yqbsoft.laser.service.pm.domain.PmUserCouponDomain;
import com.yqbsoft.laser.service.pm.model.PmDistribute;
import com.yqbsoft.laser.service.pm.model.PmDistributeCoupon;
import com.yqbsoft.laser.service.pm.model.PmDistributeUser;
import com.yqbsoft.laser.service.pm.model.PmPromotion;
import com.yqbsoft.laser.service.pm.model.PmPromotionBase;
import com.yqbsoft.laser.service.pm.model.PmPromotionDiscount;
import com.yqbsoft.laser.service.pm.model.PmUserCoupon;
import com.yqbsoft.laser.service.pm.service.PmDistributeCouponService;
import com.yqbsoft.laser.service.pm.service.PmDistributeService;
import com.yqbsoft.laser.service.pm.service.PmDistributeUserService;
import com.yqbsoft.laser.service.pm.service.PmPromotionBaseService;
import com.yqbsoft.laser.service.pm.service.PmPromotionDiscountService;
import com.yqbsoft.laser.service.pm.service.PmPromotionService;
import com.yqbsoft.laser.service.pm.service.PmUserCouponService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PmDistributeServiceImpl
extends BaseServiceImpl
implements PmDistributeService {
    private static final String SYS_CODE = "pm.PROMOTION.PmDistributeServiceImpl";
    private PmDistributeMapper pmDistributeMapper;
    private PmPromotionService pmPromotionService;
    private PmDistributeUserService pmDistributeUserService;
    private PmUserCouponService pmUserCouponService;
    private PmDistributeCouponService pmDistributeCouponService;
    private PmPromotionBaseService pmPromotionBaseService;
    private PmPromotionDiscountService pmPromotionDiscountService;

    public void setPmPromotionDiscountService(PmPromotionDiscountService pmPromotionDiscountService) {
        this.pmPromotionDiscountService = pmPromotionDiscountService;
    }

    public void setPmPromotionBaseService(PmPromotionBaseService pmPromotionBaseService) {
        this.pmPromotionBaseService = pmPromotionBaseService;
    }

    public void setPmPromotionService(PmPromotionService pmPromotionService) {
        this.pmPromotionService = pmPromotionService;
    }

    public void setPmDistributeUserService(PmDistributeUserService pmDistributeUserService) {
        this.pmDistributeUserService = pmDistributeUserService;
    }

    public void setPmUserCouponService(PmUserCouponService pmUserCouponService) {
        this.pmUserCouponService = pmUserCouponService;
    }

    public void setPmDistributeMapper(PmDistributeMapper pmDistributeMapper) {
        this.pmDistributeMapper = pmDistributeMapper;
    }

    public void setPmDistributeCouponService(PmDistributeCouponService pmDistributeCouponService) {
        this.pmDistributeCouponService = pmDistributeCouponService;
    }

    private Date getSysDate() {
        try {
            return this.pmDistributeMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmDistributeServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkDistribute(PmDistributeDomain pmDistributeDomain) {
        if (null == pmDistributeDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        return msg;
    }

    private void setDistributeDefault(PmDistribute pmDistribute) {
        if (null == pmDistribute) {
            return;
        }
        if (null == pmDistribute.getDataState()) {
            pmDistribute.setDataState(1);
        }
        if (null == pmDistribute.getUserNum()) {
            pmDistribute.setUserNum(0);
        }
        Date date = this.getSysDate();
        if (null == pmDistribute.getGmtCreate()) {
            pmDistribute.setGmtCreate(date);
        }
        pmDistribute.setGmtModified(date);
        if (StringUtils.isBlank((String)pmDistribute.getDistributeCode())) {
            pmDistribute.setDistributeCode(this.createUUIDString());
        }
        if (StringUtils.isBlank((String)pmDistribute.getTenantCode())) {
            pmDistribute.setTenantCode("2020021100000063");
        }
    }

    private int getDistributeMaxCode() {
        int code = 0;
        try {
            return this.pmDistributeMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmDistributeServiceImpl.getDistributeMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setDistributeUpdataDefault(PmDistribute pmDistribute) {
        if (null == pmDistribute) {
            return;
        }
        pmDistribute.setGmtModified(this.getSysDate());
    }

    private void saveDistributeModel(PmDistribute pmDistribute) throws ApiException {
        if (null == pmDistribute) {
            return;
        }
        try {
            this.pmDistributeMapper.insert(pmDistribute);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmDistributeServiceImpl.saveDistributeModel.ex", (Throwable)e);
        }
    }

    private void saveDistributeBatchModel(List<PmDistribute> pmDistributeList) throws ApiException {
        if (null == pmDistributeList || pmDistributeList.isEmpty()) {
            return;
        }
        try {
            this.pmDistributeMapper.insertBatch(pmDistributeList);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmDistributeServiceImpl.saveDistributeBatchModel.ex", (Throwable)e);
        }
    }

    private PmDistribute getDistributeModelById(Integer distributeId) {
        if (null == distributeId) {
            return null;
        }
        try {
            return this.pmDistributeMapper.selectByPrimaryKey(distributeId);
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmDistributeServiceImpl.getDistributeModelById", (Throwable)e);
            return null;
        }
    }

    private PmDistribute getDistributeModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.pmDistributeMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmDistributeServiceImpl.getDistributeModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delDistributeModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.pmDistributeMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmDistributeServiceImpl.delDistributeModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pm.PROMOTION.PmDistributeServiceImpl.delDistributeModelByCode.num");
        }
    }

    private void deleteDistributeModel(Integer distributeId) throws ApiException {
        if (null == distributeId) {
            return;
        }
        int i = 0;
        try {
            i = this.pmDistributeMapper.deleteByPrimaryKey(distributeId);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmDistributeServiceImpl.deleteDistributeModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pm.PROMOTION.PmDistributeServiceImpl.deleteDistributeModel.num");
        }
    }

    private void updateDistributeModel(PmDistribute pmDistribute) throws ApiException {
        if (null == pmDistribute) {
            return;
        }
        int i = 0;
        try {
            i = this.pmDistributeMapper.updateByPrimaryKey(pmDistribute);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmDistributeServiceImpl.updateDistributeModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pm.PROMOTION.PmDistributeServiceImpl.updateDistributeModel.num");
        }
    }

    private void updateStateDistributeModel(Integer distributeId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == distributeId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("distributeId", distributeId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.pmDistributeMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmDistributeServiceImpl.updateStateDistributeModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pm.PROMOTION.PmDistributeServiceImpl.updateStateDistributeModel.null");
        }
    }

    private void updateStateDistributeModelByCode(String tenantCode, String distributeCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)distributeCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("distributeCode", distributeCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.pmDistributeMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmDistributeServiceImpl.updateStateDistributeModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pm.PROMOTION.PmDistributeServiceImpl.updateStateDistributeModelByCode.null");
        }
    }

    private PmDistribute makeDistribute(PmDistributeDomain pmDistributeDomain, PmDistribute pmDistribute) {
        if (null == pmDistributeDomain) {
            return null;
        }
        if (null == pmDistribute) {
            pmDistribute = new PmDistribute();
        }
        try {
            BeanUtils.copyAllPropertys((Object)pmDistribute, (Object)pmDistributeDomain);
            return pmDistribute;
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmDistributeServiceImpl.makeDistribute", (Throwable)e);
            return null;
        }
    }

    private PmDistributeReDomain makePmDistributeReDomain(PmDistribute pmDistribute) {
        if (null == pmDistribute) {
            return null;
        }
        PmDistributeReDomain pmDistributeReDomain = new PmDistributeReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)pmDistributeReDomain, (Object)pmDistribute);
            return pmDistributeReDomain;
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmDistributeServiceImpl.makePmDistributeReDomain", (Throwable)e);
            return null;
        }
    }

    private List<PmDistribute> queryDistributeModelPage(Map<String, Object> parammap) {
        try {
            return this.pmDistributeMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmDistributeServiceImpl.queryDistributeModel", (Throwable)e);
            return null;
        }
    }

    private int countDistribute(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.pmDistributeMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmDistributeServiceImpl.countDistribute", (Throwable)e);
        }
        return i;
    }

    private PmDistribute createPmDistribute(PmDistributeDomain pmDistributeDomain) {
        String msg = this.checkDistribute(pmDistributeDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pm.PROMOTION.PmDistributeServiceImpl.saveDistribute.checkDistribute", msg);
        }
        PmDistribute pmDistribute = this.makeDistribute(pmDistributeDomain, null);
        this.setDistributeDefault(pmDistribute);
        return pmDistribute;
    }

    @Override
    public String saveDistribute(PmDistributeDomain pmDistributeDomain) throws ApiException {
        PmDistribute pmDistribute = this.createPmDistribute(pmDistributeDomain);
        this.saveDistributeModel(pmDistribute);
        this.saveDistributeUser(pmDistributeDomain.getPmDistributeUserList(), pmDistribute);
        this.saveDistributeCoupon(pmDistributeDomain.getPmDistributeCouponList(), pmDistribute);
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("distributeCode", pmDistribute.getDistributeCode());
        this.inAsyncInvoke("pm.distribute.saveSendDistributeCoupon", paramMap);
        return pmDistribute.getDistributeCode();
    }

    @Override
    public String saveSendDistributeCoupon(String distributeCode) throws ApiException {
        PmDistribute distribute = this.getLockDistributeByC(distributeCode);
        this.getCouponeData(distribute);
        this.getUserData(distribute);
        if (ListUtil.isNotEmpty(distribute.getPmDistributeUserList()) && ListUtil.isNotEmpty(distribute.getPmDistributeCouponList())) {
            ArrayList<PmUserCouponDomain> pmUserCouponList = new ArrayList<PmUserCouponDomain>();
            for (PmDistributeUser pmDistributeUser : distribute.getPmDistributeUserList()) {
                pmDistributeUser.setDataState(1);
                for (PmDistributeCoupon pmDistributeCoupon : distribute.getPmDistributeCouponList()) {
                    this.logger.error("pm.PROMOTION.PmDistributeServiceImpl.saveSendDistributeCoupon", (Object)"\u4f18\u60e0\u5238\u53d1\u653e\u4e2d0");
                    PmUserCouponDomain pmUserCouponDomain = this.createUserCoupon(pmDistributeUser, pmDistributeCoupon);
                    if (null == pmUserCouponDomain) continue;
                    pmUserCouponList.add(pmUserCouponDomain);
                }
            }
            this.pmUserCouponService.saveUserCouponBatch(pmUserCouponList);
        }
        return null;
    }

    private PmUserCouponDomain createUserCoupon(PmDistributeUser pmDistributeUser, PmDistributeCoupon pmDistributeCoupon) {
        this.logger.error("pm.PROMOTION.PmDistributeServiceImpl.saveSendDistributeCoupon", (Object)"\u4f18\u60e0\u5238\u53d1\u653e\u4e2d1");
        PmPromotion pmPromotion = this.pmPromotionService.getPromotionByCode(pmDistributeCoupon.getTenantCode(), pmDistributeCoupon.getPromotionCode());
        this.logger.error("pm.PROMOTION.PmDistributeServiceImpl.saveSendDistributeCoupon", (Object)"\u4f18\u60e0\u5238\u53d1\u653e\u4e2d2");
        PmPromotionBaseDomain pmPromotionBaseDomain = (PmPromotionBaseDomain)DisUtil.getMapJson((String)"pm-promotion-base", (String)(pmPromotion.getPbCode() + "-" + pmDistributeCoupon.getTenantCode()), PmPromotionBaseDomain.class);
        if (null == pmPromotionBaseDomain) {
            pmPromotionBaseDomain = (PmPromotionBaseDomain)DisUtil.getMapJson((String)"pm-promotion-base", (String)(pmPromotion.getPbCode() + "-" + "00000000"), PmPromotionBaseDomain.class);
        }
        if (null == pmPromotionBaseDomain) {
            try {
                PmPromotionBase promotionBaseByCode = this.pmPromotionBaseService.getPromotionBaseByCode("00000000", pmPromotion.getPbCode());
                if (null == promotionBaseByCode) {
                    return null;
                }
                pmPromotionBaseDomain = new PmPromotionBaseDomain();
                BeanUtils.copyAllPropertys((Object)pmPromotionBaseDomain, (Object)promotionBaseByCode);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.logger.error("pm.PROMOTION.PmDistributeServiceImpl.saveSendDistributeCoupon", (Object)"\u4f18\u60e0\u5238\u53d1\u653e\u4e2d3");
        PmUserCouponDomain pmUserCouponDomain = new PmUserCouponDomain();
        pmUserCouponDomain.setPbCode(pmPromotion.getPbCode());
        pmUserCouponDomain.setPromotionCode(pmPromotion.getPromotionCode());
        pmUserCouponDomain.setPromotionName(pmPromotion.getPromotionName());
        pmUserCouponDomain.setCouponBatch(pmPromotion.getCouponBatch());
        pmUserCouponDomain.setPbName(pmPromotionBaseDomain.getPbName());
        pmUserCouponDomain.setTenantCode(pmDistributeCoupon.getTenantCode());
        pmUserCouponDomain.setPbLogo(pmPromotionBaseDomain.getPbLogo());
        pmUserCouponDomain.setMemberCode(pmPromotion.getMemberCode());
        pmUserCouponDomain.setMemberName(pmPromotion.getMemberName());
        pmUserCouponDomain.setPromotionDis(pmPromotion.getPromotionDis());
        pmUserCouponDomain.setPromotionDisstr(pmPromotion.getChannelCode());
        pmUserCouponDomain.setMemberBcode(pmDistributeUser.getUserinfoCode());
        pmUserCouponDomain.setMemberBname(pmDistributeUser.getUserName());
        pmUserCouponDomain.setUserCode(pmDistributeUser.getUserinfoCode());
        pmUserCouponDomain.setUserName(pmDistributeUser.getUserName());
        pmUserCouponDomain.setProappCode("029");
        Date couponStart = new Date();
        pmUserCouponDomain.setCouponStart(couponStart);
        pmUserCouponDomain.setCouponEnd(this.createCouponEnd(couponStart, pmPromotion));
        List<PmPromotionDiscount> pmPromotionDiscountList = pmPromotion.getPmPromotionDiscountList();
        if (ListUtil.isNotEmpty(pmPromotionDiscountList)) {
            pmUserCouponDomain.setDiscType(pmPromotionDiscountList.get(0).getDiscType());
            pmUserCouponDomain.setDiscAmount(pmPromotionDiscountList.get(0).getDiscAmount());
            pmUserCouponDomain.setDiscName(pmPromotionDiscountList.get(0).getDiscName());
            pmUserCouponDomain.setDiscStart(pmPromotionDiscountList.get(0).getDiscStart());
            pmUserCouponDomain.setDiscEnd(pmPromotionDiscountList.get(0).getDiscEnd());
        }
        pmUserCouponDomain.setUsercouponOrgin("7");
        pmUserCouponDomain.setDrawCouponPlayCouponCode(pmDistributeCoupon.getDistributeCode());
        this.logger.error("pm.PROMOTION.PmDistributeServiceImpl.saveSendDistributeCoupon", (Object)"\u4f18\u60e0\u5238\u53d1\u653e\u4e2d4");
        return pmUserCouponDomain;
    }

    private Date createCouponEnd(Date couponStart, PmPromotion pmPromotion) {
        Date couponEnd = null;
        GregorianCalendar calendar = new GregorianCalendar();
        switch (pmPromotion.getEffectiveTimeType()) {
            case 0: {
                calendar.setTime(couponStart);
                ((Calendar)calendar).add(1, 100);
                couponEnd = calendar.getTime();
                break;
            }
            case 1: {
                calendar.setTime(couponStart);
                ((Calendar)calendar).add(2, 1);
                couponEnd = calendar.getTime();
                break;
            }
            case 2: {
                calendar.setTime(couponStart);
                ((Calendar)calendar).add(2, 2);
                couponEnd = calendar.getTime();
                break;
            }
            case 3: {
                calendar.setTime(couponStart);
                ((Calendar)calendar).add(2, 3);
                couponEnd = calendar.getTime();
                break;
            }
            case 4: {
                calendar.setTime(couponStart);
                ((Calendar)calendar).add(2, 6);
                couponEnd = calendar.getTime();
                break;
            }
            case 5: {
                if (pmPromotion.getEffectiveTimeUnit() == 0) {
                    calendar.setTime(couponStart);
                    ((Calendar)calendar).add(5, pmPromotion.getEffectiveTimeNum());
                    couponEnd = calendar.getTime();
                    break;
                }
                calendar.setTime(couponStart);
                ((Calendar)calendar).add(2, pmPromotion.getEffectiveTimeNum());
                couponEnd = calendar.getTime();
            }
        }
        return couponEnd;
    }

    @Override
    public String saveCancelDistributeCoupon(String distributeCode) throws ApiException {
        this.logger.error("pm.PROMOTION.PmDistributeServiceImpl.saveSendDistributeCoupon", (Object)"\u4f18\u60e0\u5238\u64a4\u9500\u4e2d");
        PmDistribute distribute = this.getLockDistributeByC(distributeCode);
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("usercouponOrgin", "7");
        param.put("drawCouponPlayCouponCode", distribute.getDistributeCode());
        QueryResult<PmUserCoupon> pmUserCouponQueryResult = this.pmUserCouponService.queryUserCouponPage(param);
        List userCouponList = pmUserCouponQueryResult.getList();
        if (ListUtil.isNotEmpty((Collection)userCouponList)) {
            for (PmUserCoupon pmUserCoupon : userCouponList) {
                if (!pmUserCoupon.getDataState().equals(PromotionConstants.USERCOUPON_DATA_STATE_0)) continue;
                pmUserCoupon.setDataState(PromotionConstants.USERCOUPON_DATA_STATE);
                try {
                    this.pmUserCouponService.updateUserCouponStateByCode(pmUserCoupon.getTenantCode(), pmUserCoupon.getUsercouponCode(), PromotionConstants.USERCOUPON_DATA_STATE, PromotionConstants.USERCOUPON_DATA_STATE_0);
                }
                catch (Exception exception) {}
            }
        }
        return null;
    }

    private void saveDistributeCoupon(List<PmDistributeCouponDomain> pmDistributeCouponList, PmDistribute pmDistribute) {
        if (ListUtil.isNotEmpty(pmDistributeCouponList)) {
            for (PmDistributeCouponDomain pmDistributeCouponDomain : pmDistributeCouponList) {
                pmDistributeCouponDomain.setDistributeCode(pmDistribute.getDistributeCode());
                pmDistributeCouponDomain.setTenantCode(pmDistribute.getTenantCode());
            }
            this.pmDistributeCouponService.saveDistributeCouponBatch(pmDistributeCouponList);
        }
    }

    private void saveDistributeUser(List<PmDistributeUserDomain> pmDistributeUserList, PmDistribute pmDistribute) {
        if (ListUtil.isNotEmpty(pmDistributeUserList)) {
            for (PmDistributeUserDomain pmDistributeUserDomain : pmDistributeUserList) {
                pmDistributeUserDomain.setDistributeCode(pmDistribute.getDistributeCode());
                pmDistributeUserDomain.setTenantCode(pmDistribute.getTenantCode());
            }
            this.pmDistributeUserService.saveDistributeUserBatch(pmDistributeUserList);
        }
    }

    @Override
    public String saveDistributeBatch(List<PmDistributeDomain> pmDistributeDomainList) throws ApiException {
        if (null == pmDistributeDomainList || pmDistributeDomainList.isEmpty()) {
            return null;
        }
        ArrayList<PmDistribute> pmDistributeList = new ArrayList<PmDistribute>();
        String code = "";
        for (PmDistributeDomain pmDistributeDomain : pmDistributeDomainList) {
            PmDistribute pmDistribute = this.createPmDistribute(pmDistributeDomain);
            code = pmDistribute.getDistributeCode();
            pmDistributeList.add(pmDistribute);
        }
        this.saveDistributeBatchModel(pmDistributeList);
        return code;
    }

    @Override
    public void updateDistributeState(Integer distributeId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == distributeId) {
            return;
        }
        this.updateStateDistributeModel(distributeId, dataState, oldDataState, map);
    }

    @Override
    public void updateDistributeStateByCode(String tenantCode, String distributeCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)distributeCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateDistributeModelByCode(tenantCode, distributeCode, dataState, oldDataState, map);
        if (dataState == 2) {
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put("distributeCode", distributeCode);
            this.inAsyncInvoke("pm.distribute.saveCancelDistributeCoupon", paramMap);
        }
    }

    @Override
    public void updateDistribute(PmDistributeDomain pmDistributeDomain) throws ApiException {
        String msg = this.checkDistribute(pmDistributeDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pm.PROMOTION.PmDistributeServiceImpl.updateDistribute.checkDistribute", msg);
        }
        PmDistribute oldPmDistribute = this.getDistributeModelById(pmDistributeDomain.getDistributeId());
        if (null == oldPmDistribute) {
            throw new ApiException("pm.PROMOTION.PmDistributeServiceImpl.updateDistribute.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        PmDistribute pmDistribute = this.makeDistribute(pmDistributeDomain, oldPmDistribute);
        this.setDistributeUpdataDefault(pmDistribute);
        this.updateDistributeModel(pmDistribute);
    }

    @Override
    public PmDistribute getDistribute(Integer distributeId) {
        if (null == distributeId) {
            return null;
        }
        PmDistribute distribute = this.getDistributeModelById(distributeId);
        this.getCouponeData(distribute);
        return distribute;
    }

    private void getUserData(PmDistribute distribute) {
        if (null == distribute) {
            return;
        }
        Map paramMap = this.getQueryParamMap("distributeCode,tenantCode", new Object[]{distribute.getDistributeCode(), distribute.getTenantCode()});
        QueryResult<PmDistributeUser> pmDistributeUserQueryResult = this.pmDistributeUserService.queryDistributeUserPage(paramMap);
        if (null != pmDistributeUserQueryResult && null != pmDistributeUserQueryResult.getList()) {
            distribute.setPmDistributeUserList(pmDistributeUserQueryResult.getList());
        }
    }

    private void getCouponeData(PmDistribute distribute) {
        if (null == distribute) {
            return;
        }
        Map paramMap = this.getQueryParamMap("distributeCode,tenantCode", new Object[]{distribute.getDistributeCode(), distribute.getTenantCode()});
        QueryResult<PmDistributeCoupon> pmDistributeCouponQueryResult = this.pmDistributeCouponService.queryDistributeCouponPage(paramMap);
        if (null != pmDistributeCouponQueryResult && null != pmDistributeCouponQueryResult.getList()) {
            distribute.setPmDistributeCouponList(pmDistributeCouponQueryResult.getList());
        }
    }

    @Override
    public void deleteDistribute(Integer distributeId) throws ApiException {
        if (null == distributeId) {
            return;
        }
        this.deleteDistributeModel(distributeId);
    }

    @Override
    public QueryResult<PmDistribute> queryDistributePage(Map<String, Object> map) {
        List<PmDistribute> pmDistributeList = this.queryDistributeModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countDistribute(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(pmDistributeList);
        return queryResult;
    }

    @Override
    public PmDistribute getDistributeByCode(String tenantCode, String distributeCode) throws ApiException {
        if (StringUtils.isBlank((String)distributeCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("distributeCode", distributeCode);
        return this.getDistributeModelByCode(map);
    }

    @Override
    public PmDistribute getLockDistributeByC(String distributeCode) throws ApiException {
        if (StringUtils.isBlank((String)distributeCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("distributeCode", distributeCode);
        return this.pmDistributeMapper.getLockByCode(map);
    }

    @Override
    public void deleteDistributeByCode(String tenantCode, String distributeCode) throws ApiException {
        if (StringUtils.isBlank((String)distributeCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("distributeCode", distributeCode);
        this.delDistributeModelByCode(map);
    }
}

