/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.pm.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.pm.PromotionConstants;
import com.yqbsoft.laser.service.pm.dao.PmUserCouponMapper;
import com.yqbsoft.laser.service.pm.domain.OrderCallBackBean;
import com.yqbsoft.laser.service.pm.domain.PmUserCouponDomain;
import com.yqbsoft.laser.service.pm.domain.PmUserCouponReDomain;
import com.yqbsoft.laser.service.pm.model.PmUserCoupon;
import com.yqbsoft.laser.service.pm.service.PmUserCouponService;
import com.yqbsoft.laser.service.pm.service.PmUserCouponlistService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PmUserCouponServiceImpl
extends BaseServiceImpl
implements PmUserCouponService {
    private static final String SYS_CODE = "pm.PROMOTION.PmUserCouponServiceImpl";
    private PmUserCouponMapper pmUserCouponMapper;
    PmUserCouponlistService pmUserCouponlistService;

    public void setPmUserCouponMapper(PmUserCouponMapper pmUserCouponMapper) {
        this.pmUserCouponMapper = pmUserCouponMapper;
    }

    public PmUserCouponlistService getPmUserCouponlistService() {
        return this.pmUserCouponlistService;
    }

    public void setPmUserCouponlistService(PmUserCouponlistService pmUserCouponlistService) {
        this.pmUserCouponlistService = pmUserCouponlistService;
    }

    private Date getSysDate() {
        try {
            return this.pmUserCouponMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmUserCouponServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkUserCoupon(PmUserCouponDomain pmUserCouponDomain) {
        if (null == pmUserCouponDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)pmUserCouponDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setUserCouponDefault(PmUserCoupon pmUserCoupon) {
        if (null == pmUserCoupon) {
            return;
        }
        if (null == pmUserCoupon.getDataState()) {
            pmUserCoupon.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == pmUserCoupon.getGmtCreate()) {
            pmUserCoupon.setGmtCreate(date);
        }
        pmUserCoupon.setGmtModified(date);
        if (StringUtils.isBlank((String)pmUserCoupon.getUsercouponCode())) {
            pmUserCoupon.setUsercouponCode(this.getNo(null, "PmUserCoupon", "usercouponCode", pmUserCoupon.getTenantCode()));
        }
        if (StringUtils.isBlank((String)pmUserCoupon.getCouponNo())) {
            pmUserCoupon.setCouponNo(this.getNo(null, "PmUserCoupon", "couponNo", pmUserCoupon.getTenantCode()));
        }
    }

    private int getUserCouponMaxCode() {
        int code = 0;
        try {
            return this.pmUserCouponMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmUserCouponServiceImpl.getUserCouponMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setUserCouponUpdataDefault(PmUserCoupon pmUserCoupon) {
        if (null == pmUserCoupon) {
            return;
        }
        pmUserCoupon.setGmtModified(this.getSysDate());
    }

    private void saveUserCouponModel(PmUserCoupon pmUserCoupon) throws ApiException {
        if (null == pmUserCoupon) {
            return;
        }
        try {
            this.pmUserCouponMapper.insert(pmUserCoupon);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmUserCouponServiceImpl.saveUserCouponModel.ex", (Throwable)e);
        }
    }

    private void saveUserCouponBatchModel(List<PmUserCoupon> pmUserCouponList) throws ApiException {
        if (null == pmUserCouponList || pmUserCouponList.isEmpty()) {
            return;
        }
        try {
            this.pmUserCouponMapper.insertBatch(pmUserCouponList);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmUserCouponServiceImpl.saveUserCouponBatchModel.ex", (Throwable)e);
        }
    }

    private PmUserCoupon getUserCouponModelById(Integer usercouponId) {
        if (null == usercouponId) {
            return null;
        }
        try {
            return this.pmUserCouponMapper.selectByPrimaryKey(usercouponId);
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmUserCouponServiceImpl.getUserCouponModelById", (Throwable)e);
            return null;
        }
    }

    private PmUserCoupon getUserCouponModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.pmUserCouponMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmUserCouponServiceImpl.getUserCouponModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delUserCouponModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.pmUserCouponMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmUserCouponServiceImpl.delUserCouponModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pm.PROMOTION.PmUserCouponServiceImpl.delUserCouponModelByCode.num");
        }
    }

    private void deleteUserCouponModel(Integer usercouponId) throws ApiException {
        if (null == usercouponId) {
            return;
        }
        int i = 0;
        try {
            i = this.pmUserCouponMapper.deleteByPrimaryKey(usercouponId);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmUserCouponServiceImpl.deleteUserCouponModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pm.PROMOTION.PmUserCouponServiceImpl.deleteUserCouponModel.num");
        }
    }

    private void updateUserCouponModel(PmUserCoupon pmUserCoupon) throws ApiException {
        if (null == pmUserCoupon) {
            return;
        }
        int i = 0;
        try {
            i = this.pmUserCouponMapper.updateByPrimaryKeySelective(pmUserCoupon);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmUserCouponServiceImpl.updateUserCouponModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pm.PROMOTION.PmUserCouponServiceImpl.updateUserCouponModel.num");
        }
    }

    private void updateStateUserCouponModel(Integer usercouponId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == usercouponId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("usercouponId", usercouponId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.pmUserCouponMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmUserCouponServiceImpl.updateStateUserCouponModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pm.PROMOTION.PmUserCouponServiceImpl.updateStateUserCouponModel.null");
        }
    }

    private void updateStateUserCouponModelByCode(String tenantCode, String usercouponCode, Integer dataState, Integer oldDataState) throws ApiException {
        if (StringUtils.isBlank((String)usercouponCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("usercouponCode", usercouponCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.pmUserCouponMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmUserCouponServiceImpl.updateStateUserCouponModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pm.PROMOTION.PmUserCouponServiceImpl.updateStateUserCouponModelByCode.null");
        }
    }

    private PmUserCoupon makeUserCoupon(PmUserCouponDomain pmUserCouponDomain, PmUserCoupon pmUserCoupon) {
        if (null == pmUserCouponDomain) {
            return null;
        }
        if (null == pmUserCoupon) {
            pmUserCoupon = new PmUserCoupon();
        }
        try {
            BeanUtils.copyAllPropertys((Object)pmUserCoupon, (Object)pmUserCouponDomain);
            return pmUserCoupon;
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmUserCouponServiceImpl.makeUserCoupon", (Throwable)e);
            return null;
        }
    }

    private PmUserCouponReDomain makePmUserCouponReDomain(PmUserCoupon pmUserCoupon) {
        if (null == pmUserCoupon) {
            return null;
        }
        PmUserCouponReDomain pmUserCouponReDomain = new PmUserCouponReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)pmUserCouponReDomain, (Object)pmUserCoupon);
            return pmUserCouponReDomain;
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmUserCouponServiceImpl.makePmUserCouponReDomain", (Throwable)e);
            return null;
        }
    }

    private List<PmUserCoupon> queryUserCouponModelPage(Map<String, Object> parammap) {
        try {
            return this.pmUserCouponMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmUserCouponServiceImpl.queryUserCouponModel", (Throwable)e);
            return null;
        }
    }

    private int countUserCoupon(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.pmUserCouponMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmUserCouponServiceImpl.countUserCoupon", (Throwable)e);
        }
        return i;
    }

    private PmUserCoupon createPmUserCoupon(PmUserCouponDomain pmUserCouponDomain) {
        String msg = this.checkUserCoupon(pmUserCouponDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pm.PROMOTION.PmUserCouponServiceImpl.saveUserCoupon.checkUserCoupon", msg);
        }
        PmUserCoupon pmUserCoupon = this.makeUserCoupon(pmUserCouponDomain, null);
        this.setUserCouponDefault(pmUserCoupon);
        return pmUserCoupon;
    }

    @Override
    public String saveUserCoupon(PmUserCouponDomain pmUserCouponDomain) throws ApiException {
        if (null == pmUserCouponDomain) {
            return null;
        }
        PmUserCoupon pmUserCoupon = this.createPmUserCoupon(pmUserCouponDomain);
        if (null == pmUserCoupon) {
            throw new ApiException("pm.PROMOTION.PmUserCouponServiceImpl.saveUserCoupon.pmUserCoupon");
        }
        this.saveUserCouponModel(pmUserCoupon);
        return pmUserCoupon.getUsercouponCode();
    }

    @Override
    public String saveUserCouponBatch(List<PmUserCouponDomain> pmUserCouponDomainList) throws ApiException {
        if (null == pmUserCouponDomainList || pmUserCouponDomainList.isEmpty()) {
            return null;
        }
        ArrayList<PmUserCoupon> pmUserCouponList = new ArrayList<PmUserCoupon>();
        String code = "";
        for (PmUserCouponDomain pmUserCouponDomain : pmUserCouponDomainList) {
            PmUserCoupon pmUserCoupon = this.createPmUserCoupon(pmUserCouponDomain);
            code = pmUserCoupon.getUsercouponCode();
            pmUserCouponList.add(pmUserCoupon);
        }
        this.saveUserCouponBatchModel(pmUserCouponList);
        return code;
    }

    @Override
    public void updateUserCouponState(Integer usercouponId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateUserCouponModel(usercouponId, dataState, oldDataState);
    }

    @Override
    public void updateUserCouponStateByCode(String tenantCode, String usercouponCode, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateUserCouponModelByCode(tenantCode, usercouponCode, dataState, oldDataState);
    }

    @Override
    public void updateUserCoupon(PmUserCouponDomain pmUserCouponDomain) throws ApiException {
        String msg = this.checkUserCoupon(pmUserCouponDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pm.PROMOTION.PmUserCouponServiceImpl.updateUserCoupon.checkUserCoupon", msg);
        }
        PmUserCoupon oldPmUserCoupon = this.getUserCouponModelById(pmUserCouponDomain.getUsercouponId());
        if (null == oldPmUserCoupon) {
            throw new ApiException("pm.PROMOTION.PmUserCouponServiceImpl.updateUserCoupon.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        PmUserCoupon pmUserCoupon = this.makeUserCoupon(pmUserCouponDomain, oldPmUserCoupon);
        this.setUserCouponUpdataDefault(pmUserCoupon);
        this.updateUserCouponModel(pmUserCoupon);
    }

    @Override
    public PmUserCoupon getUserCoupon(Integer usercouponId) {
        return this.getUserCouponModelById(usercouponId);
    }

    @Override
    public void deleteUserCoupon(Integer usercouponId) throws ApiException {
        this.deleteUserCouponModel(usercouponId);
    }

    @Override
    public QueryResult<PmUserCoupon> queryUserCouponPage(Map<String, Object> map) {
        List<PmUserCoupon> pmUserCouponList = this.queryUserCouponModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countUserCoupon(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(pmUserCouponList);
        return queryResult;
    }

    @Override
    public PmUserCoupon getUserCouponByCode(String tenantCode, String usercouponCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("usercouponCode", usercouponCode);
        return this.getUserCouponModelByCode(map);
    }

    @Override
    public void deleteUserCouponByCode(String tenantCode, String usercouponCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("usercouponCode", usercouponCode);
        this.delUserCouponModelByCode(map);
    }

    @Override
    public BigDecimal checkUseCoupon(String tenantCode, String couponNo, String memberBcode) throws ApiException {
        BigDecimal result = BigDecimal.ZERO;
        return result;
    }

    @Override
    public String updateUserCouponByOrderCallBack(List<OrderCallBackBean> orderCallBackBeanList) throws ApiException {
        if (ListUtil.isEmpty(orderCallBackBeanList)) {
            return "ERROR";
        }
        for (OrderCallBackBean orderCallBackBean : orderCallBackBeanList) {
            this.updateStateUserCouponModelByCode(orderCallBackBean.getTenantCode(), orderCallBackBean.getUsercouponCode(), PromotionConstants.USERCOUPON_DATA_STATE_1, PromotionConstants.USERCOUPON_DATA_STATE_0);
        }
        return "SUCCESS";
    }

    @Override
    public void updateUsercouponDataStateJob() {
        this.updateUsercouponDataState();
    }

    @Override
    public int getCount(Map<String, Object> map) {
        int res = this.countUserCoupon(map);
        return res;
    }

    private void updateUsercouponDataState() {
        try {
            this.pmUserCouponMapper.updateUsercouponDataState();
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmUserCouponServiceImpl.updateUsercouponDataState", (Throwable)e);
        }
    }

    private void updateUserCouponModelStateByPromotin(String tenantCode, String promotionCode, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)promotionCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("promotionCode", promotionCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        try {
            this.pmUserCouponMapper.updateUserCouponStateByPromotin(map);
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmUserCouponServiceImpl.updateUserCouponModelStateByPromotin", (Throwable)e);
        }
    }

    @Override
    public void updateUserCouponStateByPromotin(String tenantCode, String promotionCode) throws ApiException {
        this.updateUserCouponModelStateByPromotin(tenantCode, promotionCode, 2, 0);
    }

    @Override
    public void updateUserCouponNump(String tenantCode, String usercouponCode, int num) throws ApiException {
        this.updateSendNumPromotionModel(tenantCode, usercouponCode, num);
    }

    @Override
    public void saveForwardUserCoupon(PmUserCouponDomain pmUserCouponDomain) throws ApiException {
        if (null == pmUserCouponDomain) {
            throw new ApiException("pm.PROMOTION.PmUserCouponServiceImpl.saveForwardUserCoupon.null", "pmUserCouponDomain is null");
        }
        PmUserCoupon olduUserCouponByCode = this.getUserCouponByCode(pmUserCouponDomain.getTenantCode(), pmUserCouponDomain.getUsercouponCode());
        if (null == olduUserCouponByCode) {
            throw new ApiException("pm.PROMOTION.PmUserCouponServiceImpl.saveForwardUserCoupon.userCouponByCode", "\u4f18\u60e0\u5377\u4e0d\u5b58\u5728");
        }
        if (PromotionConstants.USERCOUPON_DATA_STATE_0 != olduUserCouponByCode.getDataState()) {
            throw new ApiException("pm.PROMOTION.PmUserCouponServiceImpl.saveForwardUserCoupon.userCouponByCode", "\u53ea\u6709\u672a\u4f7f\u7528\u7684\u4f18\u60e0\u5377\u53ef\u4ee5\u8f6c\u589e");
        }
        PmUserCouponDomain userCouponDomain = new PmUserCouponDomain();
        try {
            BeanUtils.copyAllPropertys((Object)userCouponDomain, (Object)olduUserCouponByCode);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        userCouponDomain.setUsercouponId(null);
        userCouponDomain.setUsercouponCode(null);
        userCouponDomain.setUsercouponOrgin("2");
        userCouponDomain.setUserCode(pmUserCouponDomain.getUserCode());
        userCouponDomain.setUserName(pmUserCouponDomain.getUserName());
        userCouponDomain.setMemberBcode(pmUserCouponDomain.getMemberBcode());
        userCouponDomain.setMemberBname(pmUserCouponDomain.getMemberBname());
        userCouponDomain.setMemberMcode(olduUserCouponByCode.getMemberBcode());
        userCouponDomain.setMemberMname(olduUserCouponByCode.getMemberBname());
        this.updateUserCouponStateByCode(olduUserCouponByCode.getTenantCode(), olduUserCouponByCode.getUsercouponCode(), PromotionConstants.USERCOUPON_DATA_STATE_DEL, PromotionConstants.USERCOUPON_DATA_STATE_0);
        this.saveUserCoupon(userCouponDomain);
    }

    @Override
    public String saveUserCouponByOrderCallBack(List<OrderCallBackBean> orderCallBackBeanList) {
        this.logger.error("pm.PROMOTION.PmUserCouponServiceImpl.saveUserCouponByOrderCallBack.orderCallBackBeanList");
        if (ListUtil.isEmpty(orderCallBackBeanList)) {
            return "ERROR";
        }
        for (OrderCallBackBean orderCallBackBean : orderCallBackBeanList) {
            this.updateStateUserCouponModelByCode(orderCallBackBean.getTenantCode(), orderCallBackBean.getUsercouponCode(), PromotionConstants.USERCOUPON_DATA_STATE_1, PromotionConstants.USERCOUPON_DATA_STATE_0);
        }
        return "SUCCESS";
    }

    public void updateSendNumPromotionModel(String tenantCode, String usercouponCode, int num) {
        if (StringUtils.isBlank((String)usercouponCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("usercouponCode", usercouponCode);
        map.put("couponOnceNump", num);
        int i = 0;
        try {
            i = this.pmUserCouponMapper.updateSendNump(map);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmUserCouponServiceImpl.updateSendNumPromotionModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pm.PROMOTION.PmUserCouponServiceImpl.updateSendNumPromotionModel.null", "\u5df2\u53d1\u653e\u5b8c" + ((Object)map).toString());
        }
    }
}

