/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.pm.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.pm.domain.OcContractSettlDomain;
import com.yqbsoft.laser.service.pm.domain.OrderCallBackBean;
import com.yqbsoft.laser.service.pm.domain.PmCheckBean;
import com.yqbsoft.laser.service.pm.domain.PmContractGoodsDomain;
import com.yqbsoft.laser.service.pm.domain.PmInfoBean;
import com.yqbsoft.laser.service.pm.domain.PmPromotionBaseDomain;
import com.yqbsoft.laser.service.pm.domain.PmPromotionInDomain;
import com.yqbsoft.laser.service.pm.domain.PmUserBean;
import com.yqbsoft.laser.service.pm.domain.PmUserCouponDomain;
import com.yqbsoft.laser.service.pm.domain.PmUserUsecouponDomain;
import com.yqbsoft.laser.service.pm.domain.SkuBean;
import com.yqbsoft.laser.service.pm.domain.UlLevelClearDomain;
import com.yqbsoft.laser.service.pm.domain.UpmUpointsClearDomain;
import com.yqbsoft.laser.service.pm.domain.UserBean;
import com.yqbsoft.laser.service.pm.domain.ocshop.OcShoppingDomain;
import com.yqbsoft.laser.service.pm.model.PmPromotion;
import com.yqbsoft.laser.service.pm.model.PmPromotionDiscount;
import com.yqbsoft.laser.service.pm.model.PmUserCoupon;
import com.yqbsoft.laser.service.pm.model.PmUserCouponsend;
import com.yqbsoft.laser.service.pm.service.PmPromotionEngineService;
import com.yqbsoft.laser.service.pm.service.PmPromotionService;
import com.yqbsoft.laser.service.pm.service.PmUserCouponService;
import com.yqbsoft.laser.service.pm.service.PmUserUsecouponService;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PmPromotionEngineServiceImpl
extends BaseServiceImpl
implements PmPromotionEngineService {
    private static final String SYS_CODE = "pm.PROMOTION.PmPromotionEngineServiceImpl";
    private PmPromotionService pmPromotionService;
    private PmUserCouponService pmUserCouponService;
    private PmUserUsecouponService pmUserUsecouponService;

    public void setPmUserCouponService(PmUserCouponService pmUserCouponService) {
        this.pmUserCouponService = pmUserCouponService;
    }

    public void setPmUserUsecouponService(PmUserUsecouponService pmUserUsecouponService) {
        this.pmUserUsecouponService = pmUserUsecouponService;
    }

    public PmPromotionService getPmPromotionService() {
        return this.pmPromotionService;
    }

    public void setPmPromotionService(PmPromotionService pmPromotionService) {
        this.pmPromotionService = pmPromotionService;
    }

    @Override
    public List<PmPromotionInDomain> queryPromotionPmBySku(SkuBean skuBean) {
        if (null == skuBean) {
            return null;
        }
        return this.pmPromotionService.queryPromotionPmBySku(skuBean);
    }

    @Override
    public List<PmPromotionInDomain> queryPromotionConBySku(SkuBean skuBean) {
        return this.pmPromotionService.queryPromotionConBySku(skuBean);
    }

    @Override
    public String savePromotionUser(PmUserBean pmUserBean) {
        this.logger.error("pm.PROMOTION.PmPromotionEngineServiceImpl.savePromotionUser.pmUserBean", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)pmUserBean));
        if (null == pmUserBean || null == pmUserBean.getPmCheckBean() || null == pmUserBean.getPmCheckBean().getUserBean()) {
            return null;
        }
        PmPromotionInDomain pmPromotionInDomain = (PmPromotionInDomain)DisUtil.getMapJson((String)"pm-promotion", (String)(pmUserBean.getPromotionCode() + "-" + pmUserBean.getTenantCode()), PmPromotionInDomain.class);
        if (null == pmPromotionInDomain) {
            throw new ApiException("pm.PROMOTION.PmPromotionEngineServiceImpl.savePromotionUser.pmPromotion", "\u5df2\u7ed3\u675f");
        }
        long nowTime = new Date().getTime();
        if (null != pmPromotionInDomain.getReceiveStart() && nowTime < pmPromotionInDomain.getReceiveStart().getTime()) {
            throw new ApiException("pm.PROMOTION.PmPromotionEngineServiceImpl.savePromotionUser.ReceiveStart", "\u9886\u53d6\u4f18\u60e0\u5238\u672a\u5f00\u59cb");
        }
        if (null != pmPromotionInDomain.getReceiveEnd() && nowTime > pmPromotionInDomain.getReceiveEnd().getTime()) {
            throw new ApiException("pm.PROMOTION.PmPromotionEngineServiceImpl.savePromotionUser.ReceiveEnd", "\u9886\u53d6\u4f18\u60e0\u5238\u5df2\u7ecf\u7ed3\u675f");
        }
        PmCheckBean pmCheckBean = pmUserBean.getPmCheckBean();
        if (!this.pmPromotionService.checkBasePm(pmPromotionInDomain, pmCheckBean)) {
            throw new ApiException("pm.PROMOTION.PmPromotionEngineServiceImpl.savePromotionUser.checkBasePm", "\u4fe1\u606f\u4e0d\u5339\u914d");
        }
        PmUserCouponDomain pmUserCouponDomain = this.makeUserCoupon(pmUserBean, pmPromotionInDomain, pmCheckBean);
        if (null == pmUserCouponDomain) {
            throw new ApiException("pm.PROMOTION.PmPromotionEngineServiceImpl.savePromotionUser.pmUserCouponDomain");
        }
        Integer promotionFrequency = pmPromotionInDomain.getPromotionFrequency();
        if (null != promotionFrequency && 0 != promotionFrequency) {
            HashMap<String, Object> param1 = new HashMap<String, Object>();
            param1.put("memberBcode", pmUserCouponDomain.getMemberBcode());
            param1.put("promotionCode", pmPromotionInDomain.getPromotionCode());
            param1.put("tenantCode", pmPromotionInDomain.getTenantCode());
            Integer res1 = this.pmUserCouponService.getCount(param1);
            if (res1 > 0 && res1 >= promotionFrequency) {
                throw new ApiException("pm.PROMOTION.PmPromotionEngineServiceImpl.savePromotionUser.pmPromotionCoupon", "\u5df2\u5230\u9886\u53d6\u4e0a\u9650");
            }
        }
        int num = pmUserBean.getNum();
        this.pmPromotionService.updateSendNum(pmUserBean.getTenantCode(), pmUserBean.getPromotionCode(), num);
        return this.pmUserCouponService.saveUserCoupon(pmUserCouponDomain);
    }

    private PmUserCouponDomain makeUserCoupon(PmUserBean pmUserBean, PmPromotionInDomain pmPromotionInDomain, PmCheckBean pmCheckBean) {
        if (null == pmUserBean || null == pmPromotionInDomain || null == pmCheckBean) {
            return null;
        }
        PmPromotionBaseDomain pmPromotionBaseDomain = (PmPromotionBaseDomain)DisUtil.getMapJson((String)"pm-promotion-base", (String)(pmPromotionInDomain.getPbCode() + "-" + pmUserBean.getTenantCode()), PmPromotionBaseDomain.class);
        if (null == pmPromotionBaseDomain) {
            pmPromotionBaseDomain = (PmPromotionBaseDomain)DisUtil.getMapJson((String)"pm-promotion-base", (String)(pmPromotionInDomain.getPbCode() + "-" + "00000000"), PmPromotionBaseDomain.class);
        }
        if (null == pmPromotionBaseDomain) {
            return null;
        }
        Integer sendtype = pmPromotionInDomain.getSendtype();
        if (null == sendtype) {
            sendtype = 0;
        }
        PmUserCouponDomain pmUserCouponDomain = new PmUserCouponDomain();
        pmUserCouponDomain.setDiscType(pmPromotionInDomain.getDiscType());
        pmUserCouponDomain.setPbLogo(pmPromotionBaseDomain.getPbLogo());
        pmUserCouponDomain.setPbName(pmPromotionBaseDomain.getPbName());
        if (sendtype != 0) {
            pmUserCouponDomain.setCouponAmount(pmUserBean.getAmonut());
        } else {
            pmUserCouponDomain.setCouponAmount(pmPromotionInDomain.getDiscAmount());
        }
        if (null == pmUserBean.getPmCheckBean()) {
            pmUserCouponDomain.setChannelCode(pmUserBean.getPmCheckBean().getChannelCode());
            pmUserCouponDomain.setChannelName(pmUserBean.getPmCheckBean().getChannelName());
        }
        pmUserCouponDomain.setPromotionDis(pmPromotionInDomain.getPromotionDis());
        pmUserCouponDomain.setPromotionDisstr(pmPromotionInDomain.getChannelCode());
        pmUserCouponDomain.setPbCode(pmPromotionInDomain.getPbCode());
        pmUserCouponDomain.setPromotionCode(pmPromotionInDomain.getPromotionCode());
        pmUserCouponDomain.setPromotionName(pmPromotionInDomain.getPromotionName());
        pmUserCouponDomain.setCouponBatch(pmPromotionInDomain.getCouponBatch());
        pmUserCouponDomain.setMemberCode(pmPromotionInDomain.getMemberCode());
        pmUserCouponDomain.setMemberName(pmPromotionInDomain.getMemberName());
        pmUserCouponDomain.setCouponStart(pmPromotionInDomain.getPromotionBegintime());
        pmUserCouponDomain.setCouponEnd(pmPromotionInDomain.getPromotionEndtime());
        pmUserCouponDomain.setDiscAmount(pmPromotionInDomain.getDiscAmount());
        if ("0003".equals(pmPromotionInDomain.getPbCode())) {
            PmPromotion promotionByCode = this.pmPromotionService.getPromotionByCode(pmPromotionInDomain.getTenantCode(), pmPromotionInDomain.getPromotionCode());
            if (null == promotionByCode) {
                return null;
            }
            PmPromotionDiscount pmPromotionDiscount = promotionByCode.getPmPromotionDiscountList().get(0);
            Integer discSort = pmPromotionDiscount.getDiscSort();
            if (null == discSort || 0 == discSort) {
                pmUserCouponDomain.setDiscAmount(pmPromotionInDomain.getDiscAmount());
            } else if (0 == discSort) {
                int min = pmPromotionDiscount.getDiscSnium().intValue();
                int max = pmPromotionDiscount.getDiscEnum().intValue();
                int a = 0;
                for (int i = 0; i < 10; ++i) {
                    a = (int)Math.round(Math.random() * (double)(max - min) + (double)min);
                }
                pmUserCouponDomain.setCouponAmount(new BigDecimal(a));
            } else if (0 == discSort) {
                BigDecimal discAmount = pmPromotionDiscount.getDiscSnium().divide(new BigDecimal(100));
                pmUserCouponDomain.setCouponAmount(discAmount.multiply(pmCheckBean.getContractMoney()));
            }
        }
        pmUserCouponDomain.setDiscName(pmPromotionInDomain.getDiscName());
        pmUserCouponDomain.setDiscStart(pmPromotionInDomain.getDiscStart());
        pmUserCouponDomain.setDiscEnd(pmPromotionInDomain.getDiscEnd());
        pmUserCouponDomain.setChannelCode(pmCheckBean.getChannelCode());
        pmUserCouponDomain.setChannelName(pmCheckBean.getChannelName());
        pmUserCouponDomain.setMemberBcode(pmCheckBean.getUserBean().getMemberCode());
        pmUserCouponDomain.setMemberBname(pmCheckBean.getUserBean().getMemberName());
        pmUserCouponDomain.setUserCode(pmCheckBean.getUserBean().getUserCode());
        pmUserCouponDomain.setUserName(pmCheckBean.getUserBean().getUserName());
        pmUserCouponDomain.setProappCode(pmCheckBean.getProappCode());
        pmUserCouponDomain.setTenantCode(pmCheckBean.getTenantCode());
        return pmUserCouponDomain;
    }

    @Override
    public PmInfoBean checkPm(List<PmContractGoodsDomain> pmContractGoodsDomainList, List<OcContractSettlDomain> ocContractSettlDomainList, PmCheckBean pmCheckBean) {
        return this.pmPromotionService.checkPm(pmContractGoodsDomainList, ocContractSettlDomainList, pmCheckBean);
    }

    @Override
    public List<OcShoppingDomain> checkPromotionForShoppingList(List<OcShoppingDomain> ocShoppingDomainList, PmCheckBean pmCheckBean) {
        return this.pmPromotionService.checkPromotionForShoppingList(ocShoppingDomainList, pmCheckBean);
    }

    @Override
    public List<OcShoppingDomain> checkPromotionForShopping(OcShoppingDomain ocShoppingDomain, PmCheckBean pmCheckBean) {
        if (null == ocShoppingDomain) {
            return null;
        }
        ArrayList<OcShoppingDomain> ocShoppingDomainList = new ArrayList<OcShoppingDomain>();
        ocShoppingDomainList.add(ocShoppingDomain);
        return this.pmPromotionService.checkPromotionForShoppingList(ocShoppingDomainList, pmCheckBean);
    }

    @Override
    public List<PmUserCoupon> queryUserCon(List<PmContractGoodsDomain> pmContractGoodsDomainList, PmCheckBean pmCheckBean) {
        if (null == pmCheckBean || null == pmCheckBean.getUserBean() || StringUtils.isBlank((String)pmCheckBean.getTenantCode())) {
            this.logger.error("pm.PROMOTION.PmPromotionEngineServiceImpl.queryUserCon.param");
            return null;
        }
        Map map = this.getQueryParamMap("tenantCode,memberBcode,dataState", new Object[]{pmCheckBean.getTenantCode(), pmCheckBean.getUserBean().getMemberCode(), 0});
        QueryResult<PmUserCoupon> qlist = this.pmUserCouponService.queryUserCouponPage(map);
        if (null == qlist || ListUtil.isEmpty((Collection)qlist.getList())) {
            this.logger.error("pm.PROMOTION.PmPromotionEngineServiceImpl.queryUserCon.qlist", (Object)map.toString());
            return null;
        }
        return this.pmPromotionService.checkUserPm(pmContractGoodsDomainList, qlist.getList(), pmCheckBean);
    }

    private List<PmUserUsecouponDomain> makeUsecoupList(List<OrderCallBackBean> orderCallBackBeanList, boolean checkPm) {
        if (ListUtil.isEmpty(orderCallBackBeanList)) {
            return null;
        }
        ArrayList<PmUserUsecouponDomain> pmUserUsecouponDomainList = new ArrayList<PmUserUsecouponDomain>();
        for (OrderCallBackBean orderCallBackBean : orderCallBackBeanList) {
            pmUserUsecouponDomainList.add(this.makeUsecoup(orderCallBackBean, checkPm));
        }
        return pmUserUsecouponDomainList;
    }

    private PmUserUsecouponDomain makeUsecoup(OrderCallBackBean orderCallBackBean, boolean checkPm) {
        if (null == orderCallBackBean) {
            return null;
        }
        PmUserUsecouponDomain pmUserUsecouponDomain = new PmUserUsecouponDomain();
        try {
            if (!checkPm) {
                PmUserCoupon pmUserCoupon = this.pmUserCouponService.getUserCouponByCode(orderCallBackBean.getTenantCode(), orderCallBackBean.getUsercouponCode());
                if (null != pmUserCoupon) {
                    BeanUtils.copyAllPropertys((Object)pmUserUsecouponDomain, (Object)pmUserCoupon);
                }
            } else {
                PmPromotionInDomain pmPromotionInDomain = (PmPromotionInDomain)DisUtil.getMapJson((String)"pm-promotion", (String)(orderCallBackBean.getUsercouponCode() + "-" + orderCallBackBean.getTenantCode()), PmPromotionInDomain.class);
                if (null != pmPromotionInDomain) {
                    BeanUtils.copyAllPropertys((Object)pmUserUsecouponDomain, (Object)pmPromotionInDomain);
                }
            }
            BeanUtils.copyAllPropertys((Object)pmUserUsecouponDomain, (Object)orderCallBackBean);
            PmPromotionBaseDomain pmPromotionBaseDomain = (PmPromotionBaseDomain)DisUtil.getMapJson((String)"pm-promotion-base", (String)(pmUserUsecouponDomain.getPbCode() + "-" + pmUserUsecouponDomain.getTenantCode()), PmPromotionBaseDomain.class);
            if (null == pmPromotionBaseDomain) {
                pmPromotionBaseDomain = (PmPromotionBaseDomain)DisUtil.getMapJson((String)"pm-promotion-base", (String)(pmUserUsecouponDomain.getPbCode() + "-" + "00000000"), PmPromotionBaseDomain.class);
            }
            if (null != pmPromotionBaseDomain) {
                pmUserUsecouponDomain.setPbName(pmPromotionBaseDomain.getPbName());
            }
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmPromotionEngineServiceImpl.makeUsecoup.e", (Throwable)e);
        }
        return pmUserUsecouponDomain;
    }

    @Override
    public String updateUserCouponByOrderCallBack(List<OrderCallBackBean> orderCallBackBeanList) {
        this.pmUserUsecouponService.saveUserUsecouponBatch(this.makeUsecoupList(orderCallBackBeanList, false));
        return this.pmUserCouponService.updateUserCouponByOrderCallBack(orderCallBackBeanList);
    }

    @Override
    public String updateUserPmByOrderCallBack(List<OrderCallBackBean> orderCallBackBeanList) {
        if (ListUtil.isEmpty(orderCallBackBeanList)) {
            return "ERROR";
        }
        this.pmUserUsecouponService.saveUserUsecouponBatch(this.makeUsecoupList(orderCallBackBeanList, true));
        return "SUCCESS";
    }

    @Override
    public String savePromotionSystem(PmUserCouponsend pmUserCouponsend) {
        this.logger.error("pm.PROMOTION.PmPromotionEngineServiceImpl.savePromotionSystem.pmUserCouponsend", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)pmUserCouponsend));
        if (null == pmUserCouponsend) {
            this.logger.error("pm.PROMOTION.PmPromotionEngineServiceImpl.savePromotionSystem.pmUserCouponsend.null");
        }
        switch (pmUserCouponsend.getDiscType()) {
            case 8: {
                PmUserBean pmUserBean = new PmUserBean();
                pmUserBean.setAmonut(null);
                pmUserBean.setNum(1);
                pmUserBean.setPmCheckBean(this.getPmCheckBean(pmUserCouponsend));
                try {
                    BeanUtils.copyAllPropertys((Object)pmUserBean, (Object)pmUserCouponsend);
                }
                catch (Exception e) {
                    this.logger.error("pm.PROMOTION.PmPromotionEngineServiceImpl.savePromotionSystem.copyAllPropertys", (Throwable)e);
                }
                pmUserBean.setPromotionCode(pmUserCouponsend.getUsercouponCode());
                this.savePromotionUser(pmUserBean);
                break;
            }
            case 9: {
                UlLevelClearDomain ulLevelClearDomain = new UlLevelClearDomain();
                ulLevelClearDomain.setLevelRuleApi("pm.pmPromotionEngine.savePromotionSystem");
                ulLevelClearDomain.setTenantCode(pmUserCouponsend.getTenantCode());
                ulLevelClearDomain.setLevelClearDirection("0");
                ulLevelClearDomain.setMemberCode(pmUserCouponsend.getMemberBcode());
                ulLevelClearDomain.setMemberName(pmUserCouponsend.getMemberBname());
                ulLevelClearDomain.setLevelType("0");
                ulLevelClearDomain.setLevelUserqua("buy");
                ulLevelClearDomain.setLevelClearNum(pmUserCouponsend.getCouponAmount());
                ulLevelClearDomain.setLevelClearOpcode(pmUserCouponsend.getUserCouponsendCode());
                HashMap<String, String> umUserParamMap = new HashMap<String, String>();
                umUserParamMap.put("ulLevelClearDomain", JsonUtil.buildNormalBinder().toJson((Object)ulLevelClearDomain));
                this.internalInvoke("ul.levelClearBase.sendLevelClear", umUserParamMap);
                break;
            }
            case 6: {
                UpmUpointsClearDomain upmUpointsClearDomain = new UpmUpointsClearDomain();
                try {
                    BeanUtils.copyAllPropertys((Object)upmUpointsClearDomain, (Object)pmUserCouponsend);
                }
                catch (Exception e) {
                    this.logger.error("pm.PROMOTION.PmPromotionEngineServiceImpl.savePromotionSystem.copyAllPropertys", (Throwable)e);
                }
                upmUpointsClearDomain.setUpointsClearNum(pmUserCouponsend.getCouponAmount());
                upmUpointsClearDomain.setPointsRuleApi("pm.pmPromotionEngine.savePromotionSystem");
                upmUpointsClearDomain.setUpointsClearDirection("7");
                upmUpointsClearDomain.setUpointsType("1");
                upmUpointsClearDomain.setMemberCode(pmUserCouponsend.getMemberBcode());
                upmUpointsClearDomain.setMemberName(pmUserCouponsend.getMemberBname());
                upmUpointsClearDomain.setTenantCode(pmUserCouponsend.getTenantCode());
                upmUpointsClearDomain.setUpointsClearOpcode(pmUserCouponsend.getUsercouponCode());
                upmUpointsClearDomain.setUpointsClearDirection("7");
                upmUpointsClearDomain.setUpointsListExcode(pmUserCouponsend.getMemberMcode());
                upmUpointsClearDomain.setUpointsListExname(pmUserCouponsend.getMemberMname());
                upmUpointsClearDomain.setUpointsType("1");
                HashMap<String, String> pmap = new HashMap<String, String>();
                pmap.put("upmUpointsClearDomain", JsonUtil.buildNormalBinder().toJson((Object)upmUpointsClearDomain));
                String s = this.internalInvoke("upm.upointsClearBase.sendUpointsClear", pmap);
                this.logger.info("pm.PROMOTION.PmPromotionEngineServiceImpl.savePromotionSystem.internalInvoke.sendUpointsClear", (Object)s);
            }
        }
        return "success";
    }

    public PmCheckBean getPmCheckBean(PmUserCouponsend pmUserCouponsend) {
        PmCheckBean pmCheckBean = new PmCheckBean();
        pmCheckBean.setTenantCode(pmUserCouponsend.getTenantCode());
        pmCheckBean.setChannelCode(pmUserCouponsend.getChannelCode());
        pmCheckBean.setChannelCode(pmUserCouponsend.getChannelName());
        pmCheckBean.setProappCode(pmUserCouponsend.getProappCode());
        UserBean userBean = new UserBean();
        pmCheckBean.setUserBean(userBean);
        userBean.setMemberCode(pmUserCouponsend.getMemberBcode());
        userBean.setMemberName(pmUserCouponsend.getMemberBname());
        userBean.setProappCode(pmCheckBean.getChannelCode());
        userBean.setTenantCode(pmCheckBean.getTenantCode());
        userBean.setUserName(pmUserCouponsend.getUserName());
        return pmCheckBean;
    }

    public static void main(String[] args) {
        String s = "{\"userCouponsendId\":0,\"usercouponCode\":\"\u6210\u957f\u503c\",\"userCouponsendCode\":\"0006ecec3745410c85d529cac7755df3\",\"userCouponsendType\":1,\"userCouponsendDir\":0,\"pbCode\":\"0018\",\"pbName\":\"\u4e0b\u5355\u6709\u793c\",\"usercouponOrgin\":\"1\",\"promotionInType\":\"3\",\"couponBatch\":\"2020082000000074\",\"promotionCode\":\"2020082000000096\",\"promotionName\":\"\u6d4b\u8bd5\",\"promotionPcode\":\"-1\",\"promotionType\":\"0\",\"couponOnceNump\":0,\"couponOnceNums\":0,\"couponOnceNumso\":0,\"couponOddamount\":0,\"discType\":9,\"discAmount\":11.00000000,\"dataState\":0,\"gmtCreate\":\"2020-08-20 17:37:18\",\"gmtModified\":\"2020-08-20 17:37:18\",\"memberCode\":\"20000210325220\",\"memberName\":\"\u5e73\u53f0\",\"appmanageIcode\":\"001\",\"userCode\":\"2020062400000001\",\"userName\":\"18516532129\",\"promotionDis\":0,\"channelCode\":\"\u5e73\u53f0\u6e20\u9053\",\"channelName\":\"\u5e73\u53f0\u6e20\u9053\",\"tenantCode\":\"2020060600000001\",\"memberBcode\":\"10000210326537\",\"memberBname\":\"10000210326537\",\"usercouponNum\":0}\n";
        PmUserCouponsend pmUserCouponsend = (PmUserCouponsend)JsonUtil.buildNonEmptyBinder().getJsonToObject(s, PmUserCouponsend.class);
        UlLevelClearDomain ulLevelClearDomain = new UlLevelClearDomain();
        ulLevelClearDomain.setLevelRuleApi("pm.pmPromotionEngine.savePromotionSystem");
        ulLevelClearDomain.setTenantCode(pmUserCouponsend.getTenantCode());
        ulLevelClearDomain.setLevelClearDirection("0");
        ulLevelClearDomain.setMemberCode(pmUserCouponsend.getMemberBcode());
        ulLevelClearDomain.setMemberName(pmUserCouponsend.getMemberBname());
        ulLevelClearDomain.setLevelType("0");
        ulLevelClearDomain.setLevelUserqua("buy");
        ulLevelClearDomain.setLevelClearNum(pmUserCouponsend.getCouponAmount());
        HashMap<String, String> umUserParamMap = new HashMap<String, String>();
        umUserParamMap.put("ulLevelClearDomain", JsonUtil.buildNormalBinder().toJson((Object)ulLevelClearDomain));
        System.out.println(JsonUtil.buildNonDefaultBinder().toJson((Object)ulLevelClearDomain));
    }
}

