/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.pm.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.pm.dao.PmCouponBatchMapper;
import com.yqbsoft.laser.service.pm.domain.PmCouponBatchDomain;
import com.yqbsoft.laser.service.pm.domain.PmCouponBatchReDomain;
import com.yqbsoft.laser.service.pm.model.PmCouponBatch;
import com.yqbsoft.laser.service.pm.service.PmCouponBatchService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PmCouponBatchServiceImpl
extends BaseServiceImpl
implements PmCouponBatchService {
    private static final String SYS_CODE = "pm.PROMOTION.PmCouponBatchServiceImpl";
    private PmCouponBatchMapper pmCouponBatchMapper;

    public void setPmCouponBatchMapper(PmCouponBatchMapper pmCouponBatchMapper) {
        this.pmCouponBatchMapper = pmCouponBatchMapper;
    }

    private Date getSysDate() {
        try {
            return this.pmCouponBatchMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmCouponBatchServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkCouponBatch(PmCouponBatchDomain pmCouponBatchDomain) {
        if (null == pmCouponBatchDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)pmCouponBatchDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setCouponBatchDefault(PmCouponBatch pmCouponBatch) {
        if (null == pmCouponBatch) {
            return;
        }
        if (null == pmCouponBatch.getDataState()) {
            pmCouponBatch.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == pmCouponBatch.getGmtCreate()) {
            pmCouponBatch.setGmtCreate(date);
        }
        pmCouponBatch.setGmtModified(date);
        if (StringUtils.isBlank((String)pmCouponBatch.getCouponBatchCode())) {
            pmCouponBatch.setCouponBatchCode(this.getNo(null, "PmCouponBatch", "pmCouponBatch", pmCouponBatch.getTenantCode()));
        }
    }

    private int getCouponBatchMaxCode() {
        int code = 0;
        try {
            return this.pmCouponBatchMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmCouponBatchServiceImpl.getCouponBatchMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setCouponBatchUpdataDefault(PmCouponBatch pmCouponBatch) {
        if (null == pmCouponBatch) {
            return;
        }
        pmCouponBatch.setGmtModified(this.getSysDate());
    }

    private void saveCouponBatchModel(PmCouponBatch pmCouponBatch) throws ApiException {
        if (null == pmCouponBatch) {
            return;
        }
        try {
            this.pmCouponBatchMapper.insert(pmCouponBatch);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmCouponBatchServiceImpl.saveCouponBatchModel.ex", (Throwable)e);
        }
    }

    private void saveCouponBatchBatchModel(List<PmCouponBatch> pmCouponBatchList) throws ApiException {
        if (null == pmCouponBatchList || pmCouponBatchList.isEmpty()) {
            return;
        }
        try {
            this.pmCouponBatchMapper.insertBatch(pmCouponBatchList);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmCouponBatchServiceImpl.saveCouponBatchBatchModel.ex", (Throwable)e);
        }
    }

    private PmCouponBatch getCouponBatchModelById(Integer couponBatchId) {
        if (null == couponBatchId) {
            return null;
        }
        try {
            return this.pmCouponBatchMapper.selectByPrimaryKey(couponBatchId);
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmCouponBatchServiceImpl.getCouponBatchModelById", (Throwable)e);
            return null;
        }
    }

    private PmCouponBatch getCouponBatchModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.pmCouponBatchMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmCouponBatchServiceImpl.getCouponBatchModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delCouponBatchModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.pmCouponBatchMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmCouponBatchServiceImpl.delCouponBatchModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pm.PROMOTION.PmCouponBatchServiceImpl.delCouponBatchModelByCode.num");
        }
    }

    private void deleteCouponBatchModel(Integer couponBatchId) throws ApiException {
        if (null == couponBatchId) {
            return;
        }
        int i = 0;
        try {
            i = this.pmCouponBatchMapper.deleteByPrimaryKey(couponBatchId);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmCouponBatchServiceImpl.deleteCouponBatchModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pm.PROMOTION.PmCouponBatchServiceImpl.deleteCouponBatchModel.num");
        }
    }

    private void updateCouponBatchModel(PmCouponBatch pmCouponBatch) throws ApiException {
        if (null == pmCouponBatch) {
            return;
        }
        int i = 0;
        try {
            i = this.pmCouponBatchMapper.updateByPrimaryKey(pmCouponBatch);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmCouponBatchServiceImpl.updateCouponBatchModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pm.PROMOTION.PmCouponBatchServiceImpl.updateCouponBatchModel.num");
        }
    }

    private void updateStateCouponBatchModel(Integer couponBatchId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == couponBatchId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("couponBatchId", couponBatchId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.pmCouponBatchMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmCouponBatchServiceImpl.updateStateCouponBatchModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pm.PROMOTION.PmCouponBatchServiceImpl.updateStateCouponBatchModel.null");
        }
    }

    private void updateStateCouponBatchModelByCode(String tenantCode, String couponBatchCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)couponBatchCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("couponBatchCode", couponBatchCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.pmCouponBatchMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmCouponBatchServiceImpl.updateStateCouponBatchModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pm.PROMOTION.PmCouponBatchServiceImpl.updateStateCouponBatchModelByCode.null");
        }
    }

    private PmCouponBatch makeCouponBatch(PmCouponBatchDomain pmCouponBatchDomain, PmCouponBatch pmCouponBatch) {
        if (null == pmCouponBatchDomain) {
            return null;
        }
        if (null == pmCouponBatch) {
            pmCouponBatch = new PmCouponBatch();
        }
        try {
            BeanUtils.copyAllPropertys((Object)pmCouponBatch, (Object)pmCouponBatchDomain);
            return pmCouponBatch;
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmCouponBatchServiceImpl.makeCouponBatch", (Throwable)e);
            return null;
        }
    }

    private PmCouponBatchReDomain makePmCouponBatchReDomain(PmCouponBatch pmCouponBatch) {
        if (null == pmCouponBatch) {
            return null;
        }
        PmCouponBatchReDomain pmCouponBatchReDomain = new PmCouponBatchReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)pmCouponBatchReDomain, (Object)pmCouponBatch);
            return pmCouponBatchReDomain;
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmCouponBatchServiceImpl.makePmCouponBatchReDomain", (Throwable)e);
            return null;
        }
    }

    private List<PmCouponBatch> queryCouponBatchModelPage(Map<String, Object> parammap) {
        try {
            return this.pmCouponBatchMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmCouponBatchServiceImpl.queryCouponBatchModel", (Throwable)e);
            return null;
        }
    }

    private int countCouponBatch(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.pmCouponBatchMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmCouponBatchServiceImpl.countCouponBatch", (Throwable)e);
        }
        return i;
    }

    private PmCouponBatch createPmCouponBatch(PmCouponBatchDomain pmCouponBatchDomain) {
        String msg = this.checkCouponBatch(pmCouponBatchDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pm.PROMOTION.PmCouponBatchServiceImpl.saveCouponBatch.checkCouponBatch", msg);
        }
        PmCouponBatch pmCouponBatch = this.makeCouponBatch(pmCouponBatchDomain, null);
        this.setCouponBatchDefault(pmCouponBatch);
        return pmCouponBatch;
    }

    @Override
    public String saveCouponBatch(PmCouponBatchDomain pmCouponBatchDomain) throws ApiException {
        PmCouponBatch pmCouponBatch = this.createPmCouponBatch(pmCouponBatchDomain);
        this.saveCouponBatchModel(pmCouponBatch);
        return pmCouponBatch.getCouponBatchCode();
    }

    @Override
    public String saveCouponBatchBatch(List<PmCouponBatchDomain> pmCouponBatchDomainList) throws ApiException {
        if (null == pmCouponBatchDomainList || pmCouponBatchDomainList.isEmpty()) {
            return null;
        }
        ArrayList<PmCouponBatch> pmCouponBatchList = new ArrayList<PmCouponBatch>();
        String code = "";
        for (PmCouponBatchDomain pmCouponBatchDomain : pmCouponBatchDomainList) {
            PmCouponBatch pmCouponBatch = this.createPmCouponBatch(pmCouponBatchDomain);
            code = pmCouponBatch.getCouponBatchCode();
            pmCouponBatchList.add(pmCouponBatch);
        }
        this.saveCouponBatchBatchModel(pmCouponBatchList);
        return code;
    }

    @Override
    public void updateCouponBatchState(Integer couponBatchId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == couponBatchId) {
            return;
        }
        this.updateStateCouponBatchModel(couponBatchId, dataState, oldDataState, map);
    }

    @Override
    public void updateCouponBatchStateByCode(String tenantCode, String couponBatchCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)couponBatchCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateCouponBatchModelByCode(tenantCode, couponBatchCode, dataState, oldDataState, map);
    }

    @Override
    public void updateCouponBatch(PmCouponBatchDomain pmCouponBatchDomain) throws ApiException {
        String msg = this.checkCouponBatch(pmCouponBatchDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pm.PROMOTION.PmCouponBatchServiceImpl.updateCouponBatch.checkCouponBatch", msg);
        }
        PmCouponBatch oldPmCouponBatch = this.getCouponBatchModelById(pmCouponBatchDomain.getCouponBatchId());
        if (null == oldPmCouponBatch) {
            throw new ApiException("pm.PROMOTION.PmCouponBatchServiceImpl.updateCouponBatch.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        PmCouponBatch pmCouponBatch = this.makeCouponBatch(pmCouponBatchDomain, oldPmCouponBatch);
        this.setCouponBatchUpdataDefault(pmCouponBatch);
        this.updateCouponBatchModel(pmCouponBatch);
    }

    @Override
    public PmCouponBatch getCouponBatch(Integer couponBatchId) {
        if (null == couponBatchId) {
            return null;
        }
        return this.getCouponBatchModelById(couponBatchId);
    }

    @Override
    public void deleteCouponBatch(Integer couponBatchId) throws ApiException {
        if (null == couponBatchId) {
            return;
        }
        this.deleteCouponBatchModel(couponBatchId);
    }

    @Override
    public QueryResult<PmCouponBatch> queryCouponBatchPage(Map<String, Object> map) {
        List<PmCouponBatch> pmCouponBatchList = this.queryCouponBatchModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countCouponBatch(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(pmCouponBatchList);
        return queryResult;
    }

    @Override
    public PmCouponBatch getCouponBatchByCode(String tenantCode, String couponBatchCode) throws ApiException {
        if (StringUtils.isBlank((String)couponBatchCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("couponBatchCode", couponBatchCode);
        return this.getCouponBatchModelByCode(map);
    }

    @Override
    public void deleteCouponBatchByCode(String tenantCode, String couponBatchCode) throws ApiException {
        if (StringUtils.isBlank((String)couponBatchCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("couponBatchCode", couponBatchCode);
        this.delCouponBatchModelByCode(map);
    }
}

