/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.pm.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.pm.PromotionConstants;
import com.yqbsoft.laser.service.pm.dao.PmCouponBatchMapper;
import com.yqbsoft.laser.service.pm.dao.PmCouponBatchlistMapper;
import com.yqbsoft.laser.service.pm.dao.PmOfflineActivityTripMapper;
import com.yqbsoft.laser.service.pm.domain.ActCommonDomain;
import com.yqbsoft.laser.service.pm.domain.PmCouponBatchDomain;
import com.yqbsoft.laser.service.pm.domain.PmCouponBatchReDomain;
import com.yqbsoft.laser.service.pm.domain.PmCouponBatchlistDomain;
import com.yqbsoft.laser.service.pm.domain.PmOfflineActivityTripDomain;
import com.yqbsoft.laser.service.pm.model.PmCouponBatch;
import com.yqbsoft.laser.service.pm.model.PmCouponBatchlist;
import com.yqbsoft.laser.service.pm.model.PmOfflineActivityTrip;
import com.yqbsoft.laser.service.pm.service.PmCouponBatchService;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import com.yqbsoft.laser.service.tool.util.YsEmailUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PmCouponBatchServiceImpl
extends BaseServiceImpl
implements PmCouponBatchService {
    private static final String SYS_CODE = "pm.PROMOTION.PmCouponBatchServiceImpl";
    private PmCouponBatchMapper pmCouponBatchMapper;
    private PmCouponBatchlistMapper pmCouponBatchlistMapper;
    private PmOfflineActivityTripMapper pmOfflineActivityTripMapper;

    public void setPmCouponBatchMapper(PmCouponBatchMapper pmCouponBatchMapper) {
        this.pmCouponBatchMapper = pmCouponBatchMapper;
    }

    public void setPmCouponBatchlistMapper(PmCouponBatchlistMapper pmCouponBatchlistMapper) {
        this.pmCouponBatchlistMapper = pmCouponBatchlistMapper;
    }

    public void setPmOfflineActivityTripMapper(PmOfflineActivityTripMapper pmOfflineActivityTripMapper) {
        this.pmOfflineActivityTripMapper = pmOfflineActivityTripMapper;
    }

    private Date getSysDate() {
        try {
            return this.pmCouponBatchMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmCouponBatchServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkCouponBatch(PmCouponBatchDomain pmCouponBatchDomain) {
        if (null == pmCouponBatchDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)pmCouponBatchDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setCouponBatchDefault(PmCouponBatch pmCouponBatch) {
        if (null == pmCouponBatch) {
            return;
        }
        if (null == pmCouponBatch.getDataState()) {
            pmCouponBatch.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == pmCouponBatch.getGmtCreate()) {
            pmCouponBatch.setGmtCreate(date);
        }
        pmCouponBatch.setGmtModified(date);
        if (StringUtils.isBlank((String)pmCouponBatch.getCouponBatchCode())) {
            pmCouponBatch.setCouponBatchCode(this.getNo(null, "PmCouponBatch", "pmCouponBatch", pmCouponBatch.getTenantCode()));
        }
    }

    private int getCouponBatchMaxCode() {
        int code = 0;
        try {
            return this.pmCouponBatchMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmCouponBatchServiceImpl.getCouponBatchMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setCouponBatchUpdataDefault(PmCouponBatch pmCouponBatch) {
        if (null == pmCouponBatch) {
            return;
        }
        pmCouponBatch.setGmtModified(this.getSysDate());
    }

    private void saveCouponBatchModel(PmCouponBatch pmCouponBatch) throws ApiException {
        if (null == pmCouponBatch) {
            return;
        }
        try {
            this.pmCouponBatchMapper.insert(pmCouponBatch);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmCouponBatchServiceImpl.saveCouponBatchModel.ex", (Throwable)e);
        }
    }

    private void saveCouponBatchBatchModel(List<PmCouponBatch> pmCouponBatchList) throws ApiException {
        if (null == pmCouponBatchList || pmCouponBatchList.isEmpty()) {
            return;
        }
        try {
            this.pmCouponBatchMapper.insertBatch(pmCouponBatchList);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmCouponBatchServiceImpl.saveCouponBatchBatchModel.ex", (Throwable)e);
        }
    }

    private PmCouponBatch getCouponBatchModelById(Integer couponBatchId) {
        if (null == couponBatchId) {
            return null;
        }
        try {
            return this.pmCouponBatchMapper.selectByPrimaryKey(couponBatchId);
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmCouponBatchServiceImpl.getCouponBatchModelById", (Throwable)e);
            return null;
        }
    }

    private PmCouponBatch getCouponBatchModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.pmCouponBatchMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmCouponBatchServiceImpl.getCouponBatchModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delCouponBatchModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.pmCouponBatchMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmCouponBatchServiceImpl.delCouponBatchModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pm.PROMOTION.PmCouponBatchServiceImpl.delCouponBatchModelByCode.num");
        }
    }

    private void deleteCouponBatchModel(Integer couponBatchId) throws ApiException {
        if (null == couponBatchId) {
            return;
        }
        int i = 0;
        try {
            i = this.pmCouponBatchMapper.deleteByPrimaryKey(couponBatchId);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmCouponBatchServiceImpl.deleteCouponBatchModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pm.PROMOTION.PmCouponBatchServiceImpl.deleteCouponBatchModel.num");
        }
    }

    private void updateCouponBatchModel(PmCouponBatch pmCouponBatch) throws ApiException {
        if (null == pmCouponBatch) {
            return;
        }
        int i = 0;
        try {
            i = this.pmCouponBatchMapper.updateByPrimaryKey(pmCouponBatch);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmCouponBatchServiceImpl.updateCouponBatchModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pm.PROMOTION.PmCouponBatchServiceImpl.updateCouponBatchModel.num");
        }
    }

    private void updateCouponBatchSelectiveModel(PmCouponBatch pmCouponBatch) throws ApiException {
        if (null == pmCouponBatch) {
            return;
        }
        int i = 0;
        try {
            i = this.pmCouponBatchMapper.updateByPrimaryKeySelective(pmCouponBatch);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmCouponBatchServiceImpl.updateCouponBatchSelectiveModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pm.PROMOTION.PmCouponBatchServiceImpl.updateCouponBatchSelectiveModel.num");
        }
    }

    private void updateStateCouponBatchModel(Integer couponBatchId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == couponBatchId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("couponBatchId", couponBatchId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.pmCouponBatchMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmCouponBatchServiceImpl.updateStateCouponBatchModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pm.PROMOTION.PmCouponBatchServiceImpl.updateStateCouponBatchModel.null");
        }
    }

    private void updateStateCouponBatchModelByCode(String tenantCode, String couponBatchCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)couponBatchCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("couponBatchCode", couponBatchCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.pmCouponBatchMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmCouponBatchServiceImpl.updateStateCouponBatchModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pm.PROMOTION.PmCouponBatchServiceImpl.updateStateCouponBatchModelByCode.null");
        }
    }

    private PmCouponBatch makeCouponBatch(PmCouponBatchDomain pmCouponBatchDomain, PmCouponBatch pmCouponBatch) {
        if (null == pmCouponBatchDomain) {
            return null;
        }
        if (null == pmCouponBatch) {
            pmCouponBatch = new PmCouponBatch();
        }
        try {
            BeanUtils.copyAllPropertys((Object)pmCouponBatch, (Object)pmCouponBatchDomain);
            return pmCouponBatch;
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmCouponBatchServiceImpl.makeCouponBatch", (Throwable)e);
            return null;
        }
    }

    private PmCouponBatchReDomain makePmCouponBatchReDomain(PmCouponBatch pmCouponBatch) {
        if (null == pmCouponBatch) {
            return null;
        }
        PmCouponBatchReDomain pmCouponBatchReDomain = new PmCouponBatchReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)pmCouponBatchReDomain, (Object)pmCouponBatch);
            return pmCouponBatchReDomain;
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmCouponBatchServiceImpl.makePmCouponBatchReDomain", (Throwable)e);
            return null;
        }
    }

    private List<PmCouponBatch> queryCouponBatchModelPage(Map<String, Object> parammap) {
        try {
            return this.pmCouponBatchMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmCouponBatchServiceImpl.queryCouponBatchModel", (Throwable)e);
            return null;
        }
    }

    private int countCouponBatch(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.pmCouponBatchMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmCouponBatchServiceImpl.countCouponBatch", (Throwable)e);
        }
        return i;
    }

    private PmCouponBatch createPmCouponBatch(PmCouponBatchDomain pmCouponBatchDomain) {
        String msg = this.checkCouponBatch(pmCouponBatchDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pm.PROMOTION.PmCouponBatchServiceImpl.saveCouponBatch.checkCouponBatch", msg);
        }
        PmCouponBatch pmCouponBatch = this.makeCouponBatch(pmCouponBatchDomain, null);
        this.setCouponBatchDefault(pmCouponBatch);
        return pmCouponBatch;
    }

    @Override
    public String saveCouponBatch(PmCouponBatchDomain pmCouponBatchDomain) throws ApiException {
        PmCouponBatch pmCouponBatch = this.createPmCouponBatch(pmCouponBatchDomain);
        this.saveCouponBatchModel(pmCouponBatch);
        this.sendEmail(null, pmCouponBatch);
        return pmCouponBatch.getCouponBatchCode();
    }

    @Override
    public String saveCouponBatchBatch(List<PmCouponBatchDomain> pmCouponBatchDomainList) throws ApiException {
        if (null == pmCouponBatchDomainList || pmCouponBatchDomainList.isEmpty()) {
            return null;
        }
        ArrayList<PmCouponBatch> pmCouponBatchList = new ArrayList<PmCouponBatch>();
        String code = "";
        for (PmCouponBatchDomain pmCouponBatchDomain : pmCouponBatchDomainList) {
            PmCouponBatch pmCouponBatch = this.createPmCouponBatch(pmCouponBatchDomain);
            code = pmCouponBatch.getCouponBatchCode();
            pmCouponBatchList.add(pmCouponBatch);
            this.sendEmail(null, pmCouponBatch);
        }
        this.saveCouponBatchBatchModel(pmCouponBatchList);
        return code;
    }

    @Override
    public void updateCouponBatchState(Integer couponBatchId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        this.logger.error("log >>> desc: sendActivity params{\u4fee\u6539\u8ba2\u5355\u72b6\u6001\u5f00\u59cb}=====");
        if (null == couponBatchId) {
            return;
        }
        this.updateStateCouponBatchModel(couponBatchId, dataState, oldDataState, map);
        if (PromotionConstants.DATA_STATE_1.intValue() == dataState.intValue()) {
            this.sendActivity(couponBatchId, map);
        }
        this.logger.error("log >>> desc: sendActivity params{\u4fee\u6539\u8ba2\u5355\u72b6\u6001\u7ed3\u675f}=====");
    }

    @Override
    public String auditCallBackApply(Map<String, Object> map) throws ApiException {
        this.logger.error("log >>> desc: sendActivity params{\u7ebf\u4e0b\u6d3b\u52a8\u7533\u8bf7\u5ba1\u6279\u6d41\u56de\u8c03\u5f00\u59cb}=====");
        this.logger.error("log >>> desc: sendActivity params{map}=====", map);
        String auditStatus = map.get("auditStatus").toString();
        int dateState = PromotionConstants.DATA_STATE_4;
        if (auditStatus.equals("NO")) {
            dateState = PromotionConstants.DATA_STATE_2;
        }
        this.updateStateCouponBatchModel(Integer.valueOf(map.get("couponBatchId").toString()), dateState, null, map);
        this.logger.error("log >>> desc: sendActivity params{\u7ebf\u4e0b\u6d3b\u52a8\u7533\u8bf7\u5ba1\u6279\u6d41\u56de\u8c03\u7ed3\u675f}=====");
        return "success";
    }

    private List<PmCouponBatchlistDomain> makePmCouponBatchlistDomainList(List<PmCouponBatchlist> pmCouponBatchlists) {
        ArrayList<PmCouponBatchlistDomain> pmCouponBatchlistDomainList = new ArrayList<PmCouponBatchlistDomain>();
        for (PmCouponBatchlist pmCouponBatchlist : pmCouponBatchlists) {
            pmCouponBatchlistDomainList.add(this.makePmCouponBatchlistDomain(pmCouponBatchlist));
        }
        return pmCouponBatchlistDomainList;
    }

    private PmCouponBatchlistDomain makePmCouponBatchlistDomain(PmCouponBatchlist pmCouponBatchlist) {
        PmCouponBatchlistDomain pmCouponBatchlistDomain = new PmCouponBatchlistDomain();
        try {
            BeanUtils.copyAllPropertys((Object)pmCouponBatchlistDomain, (Object)pmCouponBatchlist);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return pmCouponBatchlistDomain;
    }

    private List<PmCouponBatchlistDomain> queryPmCouponBatchlistDomainList(String couponBatchCode, String tenantCode) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("couponBatchCode", couponBatchCode);
        params.put("tenantCode", tenantCode);
        List<PmCouponBatchlist> pmCouponBatchlists = this.pmCouponBatchlistMapper.query(params);
        return this.makePmCouponBatchlistDomainList(pmCouponBatchlists);
    }

    private List<PmOfflineActivityTripDomain> queryPmOfflineActivityTripDomainList(String couponBatchCode, String tenantCode) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("offlineActivityCode", couponBatchCode);
        params.put("tenantCode", tenantCode);
        List<PmOfflineActivityTrip> pmOfflineActivityTripList = this.pmOfflineActivityTripMapper.query(params);
        return this.makePmOfflineActivityTripDomainList(pmOfflineActivityTripList);
    }

    private List<PmOfflineActivityTripDomain> makePmOfflineActivityTripDomainList(List<PmOfflineActivityTrip> pmOfflineActivityTripList) {
        ArrayList<PmOfflineActivityTripDomain> pmOfflineActivityTripDomainList = new ArrayList<PmOfflineActivityTripDomain>();
        for (PmOfflineActivityTrip pmOfflineActivityTrip : pmOfflineActivityTripList) {
            pmOfflineActivityTripDomainList.add(this.makePmOfflineActivityTripDomain(pmOfflineActivityTrip));
        }
        return pmOfflineActivityTripDomainList;
    }

    private PmOfflineActivityTripDomain makePmOfflineActivityTripDomain(PmOfflineActivityTrip pmOfflineActivityTrip) {
        PmOfflineActivityTripDomain pmOfflineActivityTripDomain = new PmOfflineActivityTripDomain();
        try {
            BeanUtils.copyAllPropertys((Object)pmOfflineActivityTripDomain, (Object)pmOfflineActivityTrip);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return pmOfflineActivityTripDomain;
    }

    private void sendEmail(final String userEmail, final PmCouponBatch pmCouponBatch) {
        new Thread(){

            @Override
            public void run() {
                try {
                    PmCouponBatchServiceImpl.this.sendCouponBatchEmail(userEmail, pmCouponBatch);
                }
                catch (Exception e) {
                    PmCouponBatchServiceImpl.this.logger.error("log >>> error: sendEmail params{}=====", (Throwable)e);
                }
            }
        }.start();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void sendCouponBatchEmail(String userEmail, PmCouponBatch pmCouponBatch) {
        this.logger.error("log >>> debug: sendCouponBatchEmail params{\u53d1\u9001\u90ae\u50ac}{userEmailOld}=====", (Object)(userEmail + ",userEmailNew=" + pmCouponBatch.getCouponBatchOp5()));
        String title = "";
        String sendUserTo = "";
        String sendUserCc = "";
        StringBuffer sendContent = new StringBuffer();
        title = pmCouponBatch.getCouponBatchCode() + "-" + pmCouponBatch.getCouponBatchName() + "-\u5df2\u63d0\u4ea4\u7ebf\u4e0b\u6d3b\u52a8\u7533\u8bf7";
        String userEmailOld = userEmail;
        String userEmailNew = "";
        if (pmCouponBatch != null) {
            userEmailNew = pmCouponBatch.getCouponBatchOp5();
        }
        if (!StringUtils.isNotBlank((String)userEmailNew)) return;
        if (StringUtils.isNotBlank((String)userEmailOld)) {
            if (userEmailOld.equals(userEmailNew)) return;
            sendUserTo = userEmailNew;
        } else {
            sendUserTo = userEmailNew;
        }
        sendContent.append("<html><body>");
        this.appendSendContent(sendContent, "\u60a8\u597d\uff01</span></br>");
        this.appendSendContent(sendContent, "\u7533\u8bf7\u4eba " + pmCouponBatch.getUserName() + " \u63d0\u4ea4\u7ebf\u4e0b\u6d3b\u52a8\u7533\u8bf7");
        this.appendSendContent(sendContent, " LINK\uff1a" + SupDisUtil.getMap((String)"DdFalgSetting-key", (String)(pmCouponBatch.getTenantCode() + "-ys_link-ys_link")));
        sendContent.append("</body></html>");
        this.sendEmail(title, sendUserTo, sendUserCc, sendContent.toString(), pmCouponBatch.getTenantCode());
    }

    private void appendSendContent(StringBuffer sendContent, Object context) {
        sendContent.append("<span style='font-size:14px;font-weight:bold; font-family: '\u5b8b\u4f53';'>" + context + "</span></br>");
    }

    private void sendEmail(String title, String sendUserTo, String sendUserCc, String sendContent, String tenantCode) {
        if (StringUtils.isBlank((String)sendUserTo)) {
            this.logger.error("log >>> debug: sendEmail params {\u672a\u8bbe\u7f6e\u90ae\u4ef6\u63a5\u6536\u4eba}=====", (Object)(title + "-" + sendUserTo + "-" + sendUserCc + "-" + sendContent));
            return;
        }
        this.logger.error("log >>> debug: sendEmail params {\u90ae\u4ef6\u63a8\u9001\u4fe1\u606f}=====", (Object)(title + "-" + sendUserTo + "-" + sendUserCc + "-" + sendContent));
        try {
            String emailParamJson = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)(tenantCode + "-ys_email_config-ys_email_config"));
            YsEmailUtil.send((String)emailParamJson, (String)title, (String)sendUserTo, (String)sendUserCc, (String)sendContent);
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmCouponBatchServiceImpl.sendOrderEmail:\u90ae\u4ef6\u63a8\u9001\u5f02\u5e38\uff01", (Object)e.getMessage());
        }
    }

    private PmCouponBatchReDomain makePmCouponBatchDomain(PmCouponBatch pmCouponBatch) {
        PmCouponBatchReDomain pmCouponBatchReDomain = this.makePmCouponBatchReDomain(pmCouponBatch);
        pmCouponBatchReDomain.setPmCouponBatchlistDomainList(this.queryPmCouponBatchlistDomainList(pmCouponBatch.getCouponBatchCode(), pmCouponBatch.getTenantCode()));
        pmCouponBatchReDomain.setPmOfflineActivityTripDomainList(this.queryPmOfflineActivityTripDomainList(pmCouponBatch.getCouponBatchCode(), pmCouponBatch.getTenantCode()));
        return pmCouponBatchReDomain;
    }

    private void sendActivity(Integer couponBatchId, Map<String, Object> map) {
        this.logger.error("log >>> desc: sendActivity params{\u7ebf\u4e0b\u6d3b\u52a8\u6fc0\u6d3b\u5ba1\u6279\u6d41\u5f00\u59cb} =====");
        PmCouponBatch pmCouponBatch = this.getCouponBatch(couponBatchId);
        PmCouponBatchReDomain pmCouponBatchDomain = this.makePmCouponBatchDomain(pmCouponBatch);
        HashMap<String, String> actParamMap = new HashMap<String, String>();
        HashMap<String, Object> sendparamMap = new HashMap<String, Object>();
        ActCommonDomain actCommonDomain = new ActCommonDomain();
        actCommonDomain.setTenantCode(pmCouponBatch.getTenantCode());
        actCommonDomain.setBusinessKey(pmCouponBatch.getCouponBatchCode());
        actCommonDomain.setInterfaceType("OffActivity");
        actCommonDomain.setCallUrl("pm.pmCouponBatch.auditCallBackApply");
        actCommonDomain.setParamMap(sendparamMap);
        actCommonDomain.setStartUserType("4");
        actCommonDomain.setStartUser(pmCouponBatch.getUserCode());
        actCommonDomain.setStartName(pmCouponBatch.getUserName());
        actCommonDomain.setUserCode(pmCouponBatch.getUserCode());
        actCommonDomain.setDepartCode(pmCouponBatch.getDepartCode());
        sendparamMap.put("couponBatchId", couponBatchId);
        sendparamMap.put("pmCouponBatchDomain", pmCouponBatchDomain);
        sendparamMap.put("totalPrice", pmCouponBatch.getCouponBatchPayfee());
        sendparamMap.put("title", pmCouponBatch.getCouponBatchCode() + "-" + pmCouponBatch.getCouponBatchName());
        actParamMap.put("actCommonDomain", JsonUtil.buildNormalBinder().toJson((Object)actCommonDomain));
        this.internalInvoke("act.actCommonService.activateProcess", actParamMap);
        this.logger.error("log >>> desc: sendActivity params{\u7ebf\u4e0b\u6d3b\u52a8\u6fc0\u6d3b\u5ba1\u6279\u6d41\u5f00\u59cb}=====");
    }

    @Override
    public void updateCouponBatchStateByCode(String tenantCode, String couponBatchCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)couponBatchCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateCouponBatchModelByCode(tenantCode, couponBatchCode, dataState, oldDataState, map);
    }

    @Override
    public void updateCouponBatch(PmCouponBatchDomain pmCouponBatchDomain) throws ApiException {
        this.logger.error("log >>> debug: updateCouponBatch params{targetCode}=====", (Object)pmCouponBatchDomain.getTargetCode());
        String msg = this.checkCouponBatch(pmCouponBatchDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pm.PROMOTION.PmCouponBatchServiceImpl.updateCouponBatch.checkCouponBatch", msg);
        }
        PmCouponBatch oldPmCouponBatch = this.getCouponBatchModelById(pmCouponBatchDomain.getCouponBatchId());
        String userEmailOld = oldPmCouponBatch.getCouponBatchOp5();
        if (null == oldPmCouponBatch) {
            throw new ApiException("pm.PROMOTION.PmCouponBatchServiceImpl.updateCouponBatch.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        PmCouponBatch pmCouponBatch = this.makeCouponBatch(pmCouponBatchDomain, oldPmCouponBatch);
        this.setCouponBatchUpdataDefault(pmCouponBatch);
        this.logger.error("log >>> debug: updateCouponBatch params{targetCode2}=====", (Object)(pmCouponBatch.getTargetCode() + ",couponBatchOp=" + pmCouponBatch.getCouponBatchOp()));
        this.updateCouponBatchModel(pmCouponBatch);
        this.sendEmail(userEmailOld, pmCouponBatch);
    }

    @Override
    public void updateByPrimaryKeySelectives(PmCouponBatchDomain pmCouponBatchDomain) throws ApiException {
        String msg = this.checkCouponBatch(pmCouponBatchDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pm.PROMOTION.PmCouponBatchServiceImpl.updateCouponBatch.checkCouponBatch", msg);
        }
        PmCouponBatch oldPmCouponBatch = this.getCouponBatchModelById(pmCouponBatchDomain.getCouponBatchId());
        if (null == oldPmCouponBatch) {
            throw new ApiException("pm.PROMOTION.PmCouponBatchServiceImpl.updateCouponBatch.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        PmCouponBatch pmCouponBatch = this.makeCouponBatch(pmCouponBatchDomain, null);
        this.setCouponBatchUpdataDefault(pmCouponBatch);
        this.updateCouponBatchSelectiveModel(pmCouponBatch);
    }

    @Override
    public PmCouponBatch getCouponBatch(Integer couponBatchId) {
        if (null == couponBatchId) {
            return null;
        }
        return this.getCouponBatchModelById(couponBatchId);
    }

    @Override
    public void deleteCouponBatch(Integer couponBatchId) throws ApiException {
        if (null == couponBatchId) {
            return;
        }
        this.deleteCouponBatchModel(couponBatchId);
    }

    @Override
    public QueryResult<PmCouponBatch> queryCouponBatchPage(Map<String, Object> map) {
        List<PmCouponBatch> pmCouponBatchList = this.queryCouponBatchModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countCouponBatch(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(pmCouponBatchList);
        return queryResult;
    }

    @Override
    public PmCouponBatch getCouponBatchByCode(String tenantCode, String couponBatchCode) throws ApiException {
        if (StringUtils.isBlank((String)couponBatchCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("couponBatchCode", couponBatchCode);
        return this.getCouponBatchModelByCode(map);
    }

    @Override
    public void deleteCouponBatchByCode(String tenantCode, String couponBatchCode) throws ApiException {
        if (StringUtils.isBlank((String)couponBatchCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("couponBatchCode", couponBatchCode);
        this.delCouponBatchModelByCode(map);
    }
}

