/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.portal.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.portal.dao.CmsTginfoMapper;
import com.yqbsoft.laser.service.portal.domain.CmsTginfoDomain;
import com.yqbsoft.laser.service.portal.model.CmsTginfo;
import com.yqbsoft.laser.service.portal.service.CmsTginfoService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CmsTginfoServiceImpl
extends BaseServiceImpl
implements CmsTginfoService {
    public static final String SYS_CODE = "cms.CmsTginfoServiceImpl";
    private CmsTginfoMapper cmsTginfoMapper;

    public void setCmsTginfoMapper(CmsTginfoMapper cmsTginfoMapper) {
        this.cmsTginfoMapper = cmsTginfoMapper;
    }

    private Date getSysDate() {
        try {
            return this.cmsTginfoMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("cms.CmsTginfoServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkTginfo(CmsTginfoDomain cmsTginfoDomain) {
        if (null == cmsTginfoDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)cmsTginfoDomain.getOauthEnvCode())) {
            msg = msg + "OauthEnvCode\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)cmsTginfoDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)cmsTginfoDomain.getTginfoExchangeurl()) && StringUtils.isBlank((String)cmsTginfoDomain.getTginfoCompanyurl())) {
            msg = msg + "TginfoCompanyurl\u3001TginfoExchangeurl\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setTginfoDefault(CmsTginfo cmsTginfo) {
        if (null == cmsTginfo) {
            return;
        }
        if (null == cmsTginfo.getDataState()) {
            cmsTginfo.setDataState(0);
        }
        if (null == cmsTginfo.getGmtCreate()) {
            cmsTginfo.setGmtCreate(this.getSysDate());
        }
        cmsTginfo.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)cmsTginfo.getTginfoCode())) {
            cmsTginfo.setTginfoCode(this.createUUIDString());
        }
    }

    private int getTginfoMaxCode() {
        int code = 0;
        try {
            return this.cmsTginfoMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("cms.CmsTginfoServiceImpl.getTginfoMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setTginfoUpdataDefault(CmsTginfo cmsTginfo) {
        if (null == cmsTginfo) {
            return;
        }
        cmsTginfo.setGmtModified(this.getSysDate());
    }

    private void saveTginfoModel(CmsTginfo cmsTginfo) throws ApiException {
        if (null == cmsTginfo) {
            return;
        }
        try {
            this.cmsTginfoMapper.insert(cmsTginfo);
        }
        catch (Exception e) {
            throw new ApiException("cms.CmsTginfoServiceImpl.saveTginfoModel.ex", (Throwable)e);
        }
    }

    private CmsTginfo getTginfoModelById(Integer tginfoId) {
        if (null == tginfoId) {
            return null;
        }
        try {
            return this.cmsTginfoMapper.selectByPrimaryKey(tginfoId);
        }
        catch (Exception e) {
            this.logger.error("cms.CmsTginfoServiceImpl.getTginfoModelById", (Throwable)e);
            return null;
        }
    }

    public CmsTginfo getTginfoModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.cmsTginfoMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("cms.CmsTginfoServiceImpl.getTginfoModelByCode", (Throwable)e);
            return null;
        }
    }

    public void delTginfoModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.cmsTginfoMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("cms.CmsTginfoServiceImpl.delTginfoModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("cms.CmsTginfoServiceImpl.delTginfoModelByCode.num");
        }
    }

    private void deleteTginfoModel(Integer tginfoId) throws ApiException {
        if (null == tginfoId) {
            return;
        }
        int i = 0;
        try {
            i = this.cmsTginfoMapper.deleteByPrimaryKey(tginfoId);
        }
        catch (Exception e) {
            throw new ApiException("cms.CmsTginfoServiceImpl.deleteTginfoModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("cms.CmsTginfoServiceImpl.deleteTginfoModel.num");
        }
    }

    private void updateTginfoModel(CmsTginfo cmsTginfo) throws ApiException {
        if (null == cmsTginfo) {
            return;
        }
        try {
            this.cmsTginfoMapper.updateByPrimaryKeySelective(cmsTginfo);
        }
        catch (Exception e) {
            throw new ApiException("cms.CmsTginfoServiceImpl.updateTginfoModel.ex", (Throwable)e);
        }
    }

    private void updateStateTginfoModel(Integer tginfoId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == tginfoId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tginfoId", tginfoId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.cmsTginfoMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("cms.CmsTginfoServiceImpl.updateStateTginfoModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("cms.CmsTginfoServiceImpl.updateStateTginfoModel.null");
        }
    }

    private CmsTginfo makeTginfo(CmsTginfoDomain cmsTginfoDomain, CmsTginfo cmsTginfo) {
        if (null == cmsTginfoDomain) {
            return null;
        }
        if (null == cmsTginfo) {
            cmsTginfo = new CmsTginfo();
        }
        try {
            BeanUtils.copyAllPropertys((Object)cmsTginfo, (Object)cmsTginfoDomain);
            return cmsTginfo;
        }
        catch (Exception e) {
            this.logger.error("cms.CmsTginfoServiceImpl.makeTginfo", (Throwable)e);
            return null;
        }
    }

    private List<CmsTginfo> queryTginfoModelPage(Map<String, Object> parammap) {
        try {
            return this.cmsTginfoMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("cms.CmsTginfoServiceImpl.queryTginfoModel", (Throwable)e);
            return null;
        }
    }

    private int countTginfo(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.cmsTginfoMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("cms.CmsTginfoServiceImpl.countTginfo", (Throwable)e);
        }
        return i;
    }

    @Override
    public String saveTginfo(CmsTginfoDomain cmsTginfoDomain) throws ApiException {
        String msg = this.checkTginfo(cmsTginfoDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("cms.CmsTginfoServiceImpl.saveTginfo.checkTginfo", msg);
        }
        CmsTginfo cmsTginfo = this.makeTginfo(cmsTginfoDomain, null);
        this.setTginfoDefault(cmsTginfo);
        this.saveTginfoModel(cmsTginfo);
        return cmsTginfo.getTginfoCode();
    }

    @Override
    public void updateTginfoState(Integer tginfoId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateTginfoModel(tginfoId, dataState, oldDataState);
        CmsTginfo cmsTginfo = this.getTginfo(tginfoId);
        if (2 == dataState) {
            this.updateCache(cmsTginfo);
        }
        if (2 == oldDataState) {
            this.delCache(cmsTginfo);
        }
    }

    @Override
    public void updateTginfo(CmsTginfoDomain cmsTginfoDomain) throws ApiException {
        String msg = this.checkTginfo(cmsTginfoDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("cms.CmsTginfoServiceImpl.updateTginfo.checkTginfo", msg);
        }
        CmsTginfo oldCmsTginfo = this.getTginfoModelById(cmsTginfoDomain.getTginfoId());
        if (null == oldCmsTginfo) {
            throw new ApiException("cms.CmsTginfoServiceImpl.updateTginfo.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        CmsTginfo cmsTginfo = this.makeTginfo(cmsTginfoDomain, oldCmsTginfo);
        this.setTginfoUpdataDefault(cmsTginfo);
        this.updateTginfoModel(cmsTginfo);
    }

    @Override
    public CmsTginfo getTginfo(Integer tginfoId) {
        return this.getTginfoModelById(tginfoId);
    }

    @Override
    public void deleteTginfo(Integer tginfoId) throws ApiException {
        this.deleteTginfoModel(tginfoId);
    }

    @Override
    public QueryResult<CmsTginfo> queryTginfoPage(Map<String, Object> map) {
        List<CmsTginfo> cmsTginfoList = this.queryTginfoModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countTginfo(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(cmsTginfoList);
        return queryResult;
    }

    @Override
    public CmsTginfo getTginfoByCode(Map<String, Object> map) {
        return this.getTginfoModelByCode(map);
    }

    @Override
    public void delTginfoByCode(Map<String, Object> map) throws ApiException {
        this.delTginfoModelByCode(map);
    }

    private void delCache(CmsTginfo tginfo) {
        if (null == tginfo) {
            return;
        }
        DisUtil.delMap((String)"cms_tginfo_cache", (String[])new String[]{tginfo.getTginfoCode() + "-" + tginfo.getTenantCode()});
        DisUtil.delMap((String)"cms_tginfo_cache_all", (String[])new String[]{tginfo.getMemberCode() + "-" + tginfo.getTenantCode()});
        if (StringUtils.isNotBlank((String)tginfo.getTginfoCompanyurl())) {
            DisUtil.delMap((String)"CmsTginfo-domain", (String[])new String[]{tginfo.getTginfoCompanyurl() + "-" + "*" + "-" + tginfo.getOauthEnvCode()});
        }
        if (StringUtils.isNotBlank((String)tginfo.getTginfoExchangeurl())) {
            DisUtil.delMap((String)"CmsTginfo-domain", (String[])new String[]{tginfo.getTginfoExchangeurl() + "-" + "*" + "-" + tginfo.getOauthEnvCode()});
        }
        DisUtil.delMap((String)"CmsTginfo-mem", (String[])new String[]{tginfo.getTginfoCode() + "-" + tginfo.getTenantCode()});
    }

    private void updateCache(CmsTginfo tginfo) {
        if (null == tginfo) {
            return;
        }
        DisUtil.setMap((String)"cms_tginfo_cache", (String)(tginfo.getTginfoCode() + "-" + tginfo.getTenantCode()), (String)JsonUtil.buildNonNullBinder().toJson((Object)tginfo));
        DisUtil.setMap((String)"cms_tginfo_cache_all", (String)(tginfo.getMemberCode() + "-" + tginfo.getTenantCode()), (String)JsonUtil.buildNonNullBinder().toJson((Object)tginfo));
        if (StringUtils.isNotBlank((String)tginfo.getTginfoCompanyurl())) {
            DisUtil.setMap((String)"CmsTginfo-domain", (String)(tginfo.getTginfoCompanyurl() + "-" + "*" + "-" + tginfo.getOauthEnvCode()), (String)(tginfo.getProappCode() + "," + tginfo.getTenantCode() + "," + tginfo.getTginfoCode()));
        }
        if (StringUtils.isNotBlank((String)tginfo.getTginfoExchangeurl())) {
            DisUtil.setMap((String)"CmsTginfo-domain", (String)(tginfo.getTginfoExchangeurl() + "-" + "*" + "-" + tginfo.getOauthEnvCode()), (String)(tginfo.getProappCode() + "," + tginfo.getTenantCode() + "," + tginfo.getTginfoCode()));
        }
        DisUtil.setMap((String)"CmsTginfo-mem", (String)(tginfo.getTginfoCode() + "-" + tginfo.getTenantCode()), (String)tginfo.getMemberCode());
    }

    @Override
    public void loadcache() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("dataState", 2);
        List<CmsTginfo> cmsTginfoList = this.queryTginfoModelPage(map);
        if (cmsTginfoList == null || cmsTginfoList.isEmpty()) {
            DisUtil.delVer((String)"cms_tginfo_cache");
            DisUtil.delVer((String)"cms_tginfo_cache_all");
            DisUtil.delVer((String)"CmsTginfo-domain");
            DisUtil.delVer((String)"CmsTginfo-mem");
            return;
        }
        HashMap<String, String> mmap = new HashMap<String, String>();
        HashMap<String, String> mmap2 = new HashMap<String, String>();
        HashMap<String, String> mmap3 = new HashMap<String, String>();
        HashMap<String, String> mmap4 = new HashMap<String, String>();
        for (CmsTginfo tginfo : cmsTginfoList) {
            mmap.put(tginfo.getTginfoCode() + "-" + tginfo.getTenantCode(), JsonUtil.buildNonNullBinder().toJson((Object)tginfo));
            mmap2.put(tginfo.getMemberCode() + "-" + tginfo.getTenantCode(), JsonUtil.buildNonNullBinder().toJson((Object)tginfo));
            if (StringUtils.isNotBlank((String)tginfo.getTginfoCompanyurl())) {
                mmap3.put(tginfo.getTginfoCompanyurl() + "-" + "*" + "-" + tginfo.getOauthEnvCode(), tginfo.getProappCode() + "," + tginfo.getTenantCode() + "," + tginfo.getTginfoCode());
            }
            if (StringUtils.isNotBlank((String)tginfo.getTginfoExchangeurl())) {
                mmap3.put(tginfo.getTginfoExchangeurl() + "-" + "*" + "-" + tginfo.getOauthEnvCode(), tginfo.getProappCode() + "," + tginfo.getTenantCode() + "," + tginfo.getTginfoCode());
            }
            mmap4.put(tginfo.getTginfoCode() + "-" + tginfo.getTenantCode(), tginfo.getMemberCode());
        }
        DisUtil.setMap((String)"cms_tginfo_cache", mmap);
        DisUtil.setMap((String)"cms_tginfo_cache_all", mmap2);
        DisUtil.setMap((String)"CmsTginfo-domain", mmap3);
        DisUtil.setMap((String)"CmsTginfo-mem", mmap4);
    }
}

