/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.portal.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.portal.dao.CmsBannerMapper;
import com.yqbsoft.laser.service.portal.domain.CmsBannerDomain;
import com.yqbsoft.laser.service.portal.model.CmsBanner;
import com.yqbsoft.laser.service.portal.service.CmsBannerService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class CmsBannerServiceImpl
extends BaseServiceImpl
implements CmsBannerService {
    public static final String SYS_CODE = "cms.CmsBannerServiceImpl";
    private CmsBannerMapper cmsBannerMapper;

    public void setCmsBannerMapper(CmsBannerMapper cmsBannerMapper) {
        this.cmsBannerMapper = cmsBannerMapper;
    }

    @Override
    public Integer saveBanner(CmsBannerDomain cmsBannerDomain) throws ApiException {
        if (null == cmsBannerDomain) {
            return null;
        }
        try {
            CmsBanner cmsBanner = new CmsBanner();
            BeanUtils.copyAllPropertys((Object)cmsBanner, (Object)cmsBannerDomain);
            cmsBanner.setGmtModified(new Date());
            if (cmsBannerDomain.getBannerId() != null) {
                return this.cmsBannerMapper.updateByPrimaryKeySelective(cmsBanner);
            }
            cmsBanner.setGmtCreate(new Date());
            return this.cmsBannerMapper.insert(cmsBanner);
        }
        catch (Exception e) {
            throw new ApiException("cms.CmsBannerServiceImpl.saveBannerModel.ex", (Throwable)e);
        }
    }

    @Override
    public Integer updateBanner(CmsBannerDomain cmsBannerDomain) throws ApiException {
        CmsBanner cmsBanner = new CmsBanner();
        try {
            BeanUtils.copyAllPropertys((Object)cmsBanner, (Object)cmsBannerDomain);
            return this.cmsBannerMapper.updateByPrimaryKeySelective(cmsBanner);
        }
        catch (Exception e) {
            throw new ApiException("cms.CmsBannerServiceImpl.updateBanner.ex", (Throwable)e);
        }
    }

    @Override
    public CmsBanner getBanner(Integer bannerId) {
        return this.cmsBannerMapper.selectByPrimaryKey(bannerId);
    }

    @Override
    public void deleteBanner(Integer bannerId) throws ApiException {
        this.cmsBannerMapper.deleteByPrimaryKey(bannerId);
    }

    @Override
    public QueryResult<CmsBanner> queryBannerListPage(Map<String, Object> paramMap) {
        List<CmsBanner> cmsCmsBannerList = this.cmsBannerMapper.queryBannerListPage(paramMap);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countBanner(paramMap));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(cmsCmsBannerList);
        return queryResult;
    }

    private int countBanner(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.cmsBannerMapper.countBanner(map);
        }
        catch (Exception e) {
            this.logger.error("cms.CmsBannerServiceImpl.countBanner", (Throwable)e);
        }
        return i;
    }
}

