/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.portal.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.portal.dao.CmsNoticeMapper;
import com.yqbsoft.laser.service.portal.domain.CmsNoticeDomain;
import com.yqbsoft.laser.service.portal.domain.CmsNoticeReDomain;
import com.yqbsoft.laser.service.portal.model.CmsNotice;
import com.yqbsoft.laser.service.portal.service.CmsNoticeService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CmsNoticeServiceImpl
extends BaseServiceImpl
implements CmsNoticeService {
    private static final String SYS_CODE = "cms.CmsNoticeServiceImpl";
    private CmsNoticeMapper cmsNoticeMapper;

    public void setCmsNoticeMapper(CmsNoticeMapper cmsNoticeMapper) {
        this.cmsNoticeMapper = cmsNoticeMapper;
    }

    private Date getSysDate() {
        try {
            return this.cmsNoticeMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("cms.CmsNoticeServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkNotice(CmsNoticeDomain cmsNoticeDomain) {
        if (null == cmsNoticeDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)cmsNoticeDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setNoticeDefault(CmsNotice cmsNotice) {
        if (null == cmsNotice) {
            return;
        }
        if (null == cmsNotice.getDataState()) {
            cmsNotice.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == cmsNotice.getGmtCreate()) {
            cmsNotice.setGmtCreate(date);
        }
        cmsNotice.setGmtModified(date);
        if (StringUtils.isBlank((String)cmsNotice.getNoticeCode())) {
            cmsNotice.setNoticeCode(this.getNo(null, "CmsNotice", "cmsNotice", cmsNotice.getTenantCode()));
        }
    }

    private int getNoticeMaxCode() {
        int code = 0;
        try {
            return this.cmsNoticeMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("cms.CmsNoticeServiceImpl.getNoticeMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setNoticeUpdataDefault(CmsNotice cmsNotice) {
        if (null == cmsNotice) {
            return;
        }
        cmsNotice.setGmtModified(this.getSysDate());
    }

    private void saveNoticeModel(CmsNotice cmsNotice) throws ApiException {
        if (null == cmsNotice) {
            return;
        }
        try {
            this.cmsNoticeMapper.insert(cmsNotice);
        }
        catch (Exception e) {
            throw new ApiException("cms.CmsNoticeServiceImpl.saveNoticeModel.ex", (Throwable)e);
        }
    }

    private void saveNoticeBatchModel(List<CmsNotice> cmsNoticeList) throws ApiException {
        if (null == cmsNoticeList || cmsNoticeList.isEmpty()) {
            return;
        }
        try {
            this.cmsNoticeMapper.insertBatch(cmsNoticeList);
        }
        catch (Exception e) {
            throw new ApiException("cms.CmsNoticeServiceImpl.saveNoticeBatchModel.ex", (Throwable)e);
        }
    }

    private CmsNotice getNoticeModelById(Integer noticeId) {
        if (null == noticeId) {
            return null;
        }
        try {
            return this.cmsNoticeMapper.selectByPrimaryKey(noticeId);
        }
        catch (Exception e) {
            this.logger.error("cms.CmsNoticeServiceImpl.getNoticeModelById", (Throwable)e);
            return null;
        }
    }

    private CmsNotice getNoticeModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.cmsNoticeMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("cms.CmsNoticeServiceImpl.getNoticeModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delNoticeModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.cmsNoticeMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("cms.CmsNoticeServiceImpl.delNoticeModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("cms.CmsNoticeServiceImpl.delNoticeModelByCode.num");
        }
    }

    private void deleteNoticeModel(Integer noticeId) throws ApiException {
        if (null == noticeId) {
            return;
        }
        int i = 0;
        try {
            i = this.cmsNoticeMapper.deleteByPrimaryKey(noticeId);
        }
        catch (Exception e) {
            throw new ApiException("cms.CmsNoticeServiceImpl.deleteNoticeModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("cms.CmsNoticeServiceImpl.deleteNoticeModel.num");
        }
    }

    private void updateNoticeModel(CmsNotice cmsNotice) throws ApiException {
        if (null == cmsNotice) {
            return;
        }
        int i = 0;
        try {
            i = this.cmsNoticeMapper.updateByPrimaryKey(cmsNotice);
        }
        catch (Exception e) {
            throw new ApiException("cms.CmsNoticeServiceImpl.updateNoticeModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("cms.CmsNoticeServiceImpl.updateNoticeModel.num");
        }
    }

    private void updateStateNoticeModel(Integer noticeId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == noticeId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("noticeId", noticeId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.cmsNoticeMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("cms.CmsNoticeServiceImpl.updateStateNoticeModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("cms.CmsNoticeServiceImpl.updateStateNoticeModel.null");
        }
    }

    private void updateStateNoticeModelByCode(String tenantCode, String noticeCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)noticeCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("noticeCode", noticeCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.cmsNoticeMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("cms.CmsNoticeServiceImpl.updateStateNoticeModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("cms.CmsNoticeServiceImpl.updateStateNoticeModelByCode.null");
        }
    }

    private CmsNotice makeNotice(CmsNoticeDomain cmsNoticeDomain, CmsNotice cmsNotice) {
        if (null == cmsNoticeDomain) {
            return null;
        }
        if (null == cmsNotice) {
            cmsNotice = new CmsNotice();
        }
        try {
            BeanUtils.copyAllPropertys((Object)cmsNotice, (Object)cmsNoticeDomain);
            return cmsNotice;
        }
        catch (Exception e) {
            this.logger.error("cms.CmsNoticeServiceImpl.makeNotice", (Throwable)e);
            return null;
        }
    }

    private CmsNoticeReDomain makeCmsNoticeReDomain(CmsNotice cmsNotice) {
        if (null == cmsNotice) {
            return null;
        }
        CmsNoticeReDomain cmsNoticeReDomain = new CmsNoticeReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)cmsNoticeReDomain, (Object)cmsNotice);
            return cmsNoticeReDomain;
        }
        catch (Exception e) {
            this.logger.error("cms.CmsNoticeServiceImpl.makeCmsNoticeReDomain", (Throwable)e);
            return null;
        }
    }

    private List<CmsNotice> queryNoticeModelPage(Map<String, Object> parammap) {
        try {
            return this.cmsNoticeMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("cms.CmsNoticeServiceImpl.queryNoticeModel", (Throwable)e);
            return null;
        }
    }

    private int countNotice(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.cmsNoticeMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("cms.CmsNoticeServiceImpl.countNotice", (Throwable)e);
        }
        return i;
    }

    private CmsNotice createCmsNotice(CmsNoticeDomain cmsNoticeDomain) {
        String msg = this.checkNotice(cmsNoticeDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("cms.CmsNoticeServiceImpl.saveNotice.checkNotice", msg);
        }
        CmsNotice cmsNotice = this.makeNotice(cmsNoticeDomain, null);
        this.setNoticeDefault(cmsNotice);
        return cmsNotice;
    }

    @Override
    public String saveNotice(CmsNoticeDomain cmsNoticeDomain) throws ApiException {
        CmsNotice cmsNotice = this.createCmsNotice(cmsNoticeDomain);
        this.saveNoticeModel(cmsNotice);
        return cmsNotice.getNoticeCode();
    }

    @Override
    public String saveNoticeBatch(List<CmsNoticeDomain> cmsNoticeDomainList) throws ApiException {
        if (null == cmsNoticeDomainList || cmsNoticeDomainList.isEmpty()) {
            return null;
        }
        ArrayList<CmsNotice> cmsNoticeList = new ArrayList<CmsNotice>();
        String code = "";
        for (CmsNoticeDomain cmsNoticeDomain : cmsNoticeDomainList) {
            CmsNotice cmsNotice = this.createCmsNotice(cmsNoticeDomain);
            code = cmsNotice.getNoticeCode();
            cmsNoticeList.add(cmsNotice);
        }
        this.saveNoticeBatchModel(cmsNoticeList);
        return code;
    }

    @Override
    public void updateNoticeState(Integer noticeId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == noticeId) {
            return;
        }
        this.updateStateNoticeModel(noticeId, dataState, oldDataState, map);
    }

    @Override
    public void updateNoticeStateByCode(String tenantCode, String noticeCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)noticeCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateNoticeModelByCode(tenantCode, noticeCode, dataState, oldDataState, map);
    }

    @Override
    public void updateNotice(CmsNoticeDomain cmsNoticeDomain) throws ApiException {
        String msg = this.checkNotice(cmsNoticeDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("cms.CmsNoticeServiceImpl.updateNotice.checkNotice", msg);
        }
        CmsNotice oldCmsNotice = this.getNoticeModelById(cmsNoticeDomain.getNoticeId());
        if (null == oldCmsNotice) {
            throw new ApiException("cms.CmsNoticeServiceImpl.updateNotice.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        CmsNotice cmsNotice = this.makeNotice(cmsNoticeDomain, oldCmsNotice);
        this.setNoticeUpdataDefault(cmsNotice);
        this.updateNoticeModel(cmsNotice);
    }

    @Override
    public CmsNotice getNotice(Integer noticeId) {
        if (null == noticeId) {
            return null;
        }
        return this.getNoticeModelById(noticeId);
    }

    @Override
    public void deleteNotice(Integer noticeId) throws ApiException {
        if (null == noticeId) {
            return;
        }
        this.deleteNoticeModel(noticeId);
    }

    @Override
    public QueryResult<CmsNotice> queryNoticePage(Map<String, Object> map) {
        List<CmsNotice> cmsNoticeList = this.queryNoticeModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countNotice(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(cmsNoticeList);
        return queryResult;
    }

    @Override
    public CmsNotice getNoticeByCode(String tenantCode, String noticeCode) throws ApiException {
        if (StringUtils.isBlank((String)noticeCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("noticeCode", noticeCode);
        return this.getNoticeModelByCode(map);
    }

    @Override
    public void deleteNoticeByCode(String tenantCode, String noticeCode) throws ApiException {
        if (StringUtils.isBlank((String)noticeCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("noticeCode", noticeCode);
        this.delNoticeModelByCode(map);
    }
}

