/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.portal.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.portal.PortalConstants;
import com.yqbsoft.laser.service.portal.dao.CmsSupplyMapper;
import com.yqbsoft.laser.service.portal.domain.CmsSupplyApplyDomain;
import com.yqbsoft.laser.service.portal.domain.CmsSupplyDomain;
import com.yqbsoft.laser.service.portal.model.CmsSupply;
import com.yqbsoft.laser.service.portal.service.CmsSupplyService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class CmsSupplyServiceImpl
extends BaseServiceImpl
implements CmsSupplyService {
    public static final String SYS_CODE = "cms.CmsSupplyServiceImpl";
    private CmsSupplyMapper cmsSupplyMapper;

    public void setCmsSupplyMapper(CmsSupplyMapper cmsSupplyMapper) {
        this.cmsSupplyMapper = cmsSupplyMapper;
    }

    @Override
    public Integer saveSupply(CmsSupplyDomain cmsSupplyDomain) throws ApiException {
        if (null == cmsSupplyDomain) {
            return null;
        }
        try {
            CmsSupply cmsSupply = new CmsSupply();
            BeanUtils.copyAllPropertys((Object)cmsSupply, (Object)cmsSupplyDomain);
            cmsSupply.setGmtModified(new Date());
            cmsSupply.setGmtCreate(new Date());
            cmsSupply.setApplyState(PortalConstants.APPLYSTATE_1);
            return this.cmsSupplyMapper.insert(cmsSupply);
        }
        catch (Exception e) {
            throw new ApiException("cms.CmsSupplyServiceImpl.saveSupplyModel.ex", (Throwable)e);
        }
    }

    @Override
    public CmsSupply getSupply(Integer supplyId) {
        return this.cmsSupplyMapper.selectByPrimaryKey(supplyId);
    }

    @Override
    public Integer updateSupply(CmsSupplyDomain cmsSupplyDomain) throws ApiException {
        if (null == cmsSupplyDomain) {
            return null;
        }
        try {
            CmsSupply cmsSupply = new CmsSupply();
            BeanUtils.copyAllPropertys((Object)cmsSupply, (Object)cmsSupplyDomain);
            cmsSupply.setGmtModified(new Date());
            cmsSupply.setApplyState(PortalConstants.APPLYSTATE_1);
            return this.cmsSupplyMapper.updateByPrimaryKeySelective(cmsSupply);
        }
        catch (Exception e) {
            throw new ApiException("cms.CmsSupplyServiceImpl.saveSupplyModel.ex", (Throwable)e);
        }
    }

    @Override
    public Integer saveApplySupply(CmsSupplyApplyDomain cmsSupplyApplyDomain) throws ApiException {
        if (null == cmsSupplyApplyDomain) {
            return null;
        }
        try {
            CmsSupply cmsSupply = new CmsSupply();
            cmsSupply.setApplyState(cmsSupplyApplyDomain.getApplyState());
            cmsSupply.setApplyGmtTime(new Date());
            cmsSupply.setApplyDesc(cmsSupplyApplyDomain.getApplyDesc());
            cmsSupply.setSupplyId(cmsSupplyApplyDomain.getSupplyId());
            return this.cmsSupplyMapper.updateByPrimaryKeySelective(cmsSupply);
        }
        catch (Exception e) {
            throw new ApiException("cms.CmsSupplyServiceImpl.applySupply.ex", (Throwable)e);
        }
    }

    @Override
    public QueryResult<CmsSupply> querySupplyListPage(Map<String, Object> map) {
        List<CmsSupply> cmsSupplyList = this.querySupplyModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countSupply(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(cmsSupplyList);
        return queryResult;
    }

    private List<CmsSupply> querySupplyModelPage(Map<String, Object> parammap) {
        try {
            return this.cmsSupplyMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("cms.CmsSupplyServiceImpl.querySupplyModelPage", (Throwable)e);
            return null;
        }
    }

    private int countSupply(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.cmsSupplyMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("cms.CmsSupplyServiceImpl.countSupply", (Throwable)e);
        }
        return i;
    }
}

