/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.portal.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.portal.PortalConstants;
import com.yqbsoft.laser.service.portal.dao.CmsAdvertiseMapper;
import com.yqbsoft.laser.service.portal.domain.CmsAdvertiseDomain;
import com.yqbsoft.laser.service.portal.domain.CmsReleaseDetailsReDomain;
import com.yqbsoft.laser.service.portal.model.CmsAdvertise;
import com.yqbsoft.laser.service.portal.service.CmsAdvertiseService;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.json.JSONArray;
import com.yqbsoft.laser.service.tool.json.JSONObject;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.DateUtil;
import com.yqbsoft.laser.service.tool.util.DateUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class CmsAdvertiseServiceImpl
extends BaseServiceImpl
implements CmsAdvertiseService {
    public static final String SYS_CODE = "cms.CmsAdvertiseServiceImpl";
    private CmsAdvertiseMapper cmsAdvertiseMapper;

    public void setCmsAdvertiseMapper(CmsAdvertiseMapper cmsAdvertiseMapper) {
        this.cmsAdvertiseMapper = cmsAdvertiseMapper;
    }

    private Date getSysDate() {
        try {
            return this.cmsAdvertiseMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("cms.CmsAdvertiseServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkadvertise(CmsAdvertiseDomain cmsAdvertiseDomain) {
        if (null == cmsAdvertiseDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        return msg;
    }

    private void setadvertiseDefault(CmsAdvertise cmsAdvertise) {
        if (null == cmsAdvertise) {
            return;
        }
        if (null == cmsAdvertise.getDataState()) {
            cmsAdvertise.setDataState(0);
        }
        if (null == cmsAdvertise.getGmtCreate()) {
            cmsAdvertise.setGmtCreate(this.getSysDate());
        }
        cmsAdvertise.setGmtModified(this.getSysDate());
        if (com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)cmsAdvertise.getAdvertiseCode())) {
            cmsAdvertise.setAdvertiseCode(this.createUUIDString());
        }
    }

    private int getadvertiseMaxCode() {
        int code = 0;
        try {
            return this.cmsAdvertiseMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("cms.CmsAdvertiseServiceImpl.getadvertiseMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setadvertiseUpdataDefault(CmsAdvertise cmsAdvertise) {
        if (null == cmsAdvertise) {
            return;
        }
        cmsAdvertise.setDataState(0);
        cmsAdvertise.setGmtModified(this.getSysDate());
    }

    private void saveadvertiseModel(CmsAdvertise cmsAdvertise) throws ApiException {
        if (null == cmsAdvertise) {
            return;
        }
        try {
            this.cmsAdvertiseMapper.insert(cmsAdvertise);
        }
        catch (Exception e) {
            throw new ApiException("cms.CmsAdvertiseServiceImpl.saveadvertiseModel.ex", (Throwable)e);
        }
    }

    private CmsAdvertise getadvertiseModelById(Integer advertiseId) {
        if (null == advertiseId) {
            return null;
        }
        try {
            return this.cmsAdvertiseMapper.selectByPrimaryKey(advertiseId);
        }
        catch (Exception e) {
            this.logger.error("cms.CmsAdvertiseServiceImpl.getadvertiseModelById", (Throwable)e);
            return null;
        }
    }

    public CmsAdvertise getadvertiseModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.cmsAdvertiseMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("cms.CmsAdvertiseServiceImpl.getadvertiseModelByCode", (Throwable)e);
            return null;
        }
    }

    public void deladvertiseModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.cmsAdvertiseMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("cms.CmsAdvertiseServiceImpl.deladvertiseModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("cms.CmsAdvertiseServiceImpl.deladvertiseModelByCode.num");
        }
    }

    private void deleteadvertiseModel(Integer advertiseId) throws ApiException {
        if (null == advertiseId) {
            return;
        }
        int i = 0;
        try {
            i = this.cmsAdvertiseMapper.deleteByPrimaryKey(advertiseId);
        }
        catch (Exception e) {
            throw new ApiException("cms.CmsAdvertiseServiceImpl.deleteadvertiseModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("cms.CmsAdvertiseServiceImpl.deleteadvertiseModel.num");
        }
    }

    private void updateadvertiseModel(CmsAdvertise cmsAdvertise) throws ApiException {
        if (null == cmsAdvertise) {
            return;
        }
        try {
            this.cmsAdvertiseMapper.updateByPrimaryKeySelective(cmsAdvertise);
        }
        catch (Exception e) {
            throw new ApiException("cms.CmsAdvertiseServiceImpl.updateadvertiseModel.ex", (Throwable)e);
        }
    }

    private void updateStateadvertiseModel(Integer advertiseId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == advertiseId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("advertiseId", advertiseId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.cmsAdvertiseMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("cms.CmsAdvertiseServiceImpl.updateStateadvertiseModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("cms.CmsAdvertiseServiceImpl.updateStateadvertiseModel.null");
        }
    }

    private CmsAdvertise makeadvertise(CmsAdvertiseDomain cmsAdvertiseDomain, CmsAdvertise cmsAdvertise) {
        if (null == cmsAdvertiseDomain) {
            return null;
        }
        if (null == cmsAdvertise) {
            cmsAdvertise = new CmsAdvertise();
        }
        try {
            BeanUtils.copyAllPropertys((Object)cmsAdvertise, (Object)cmsAdvertiseDomain);
            return cmsAdvertise;
        }
        catch (Exception e) {
            this.logger.error("cms.CmsAdvertiseServiceImpl.makeadvertise", (Throwable)e);
            return null;
        }
    }

    private List<CmsAdvertise> queryadvertiseModelPage(Map<String, Object> parammap) {
        try {
            return this.cmsAdvertiseMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("cms.CmsAdvertiseServiceImpl.queryadvertiseModel", (Throwable)e);
            return null;
        }
    }

    private int countadvertise(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.cmsAdvertiseMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("cms.CmsAdvertiseServiceImpl.countadvertise", (Throwable)e);
        }
        return i;
    }

    @Override
    public String saveadvertise(CmsAdvertiseDomain cmsAdvertiseDomain) throws ApiException {
        String msg = this.checkadvertise(cmsAdvertiseDomain);
        if (com.yqbsoft.laser.service.tool.util.StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("cms.CmsAdvertiseServiceImpl.saveadvertise.checkadvertise", msg);
        }
        CmsAdvertise cmsAdvertise = this.makeadvertise(cmsAdvertiseDomain, null);
        this.setadvertiseDefault(cmsAdvertise);
        this.saveadvertiseModel(cmsAdvertise);
        this.saveToRedis(cmsAdvertise.getAdvertiseId().toString(), JsonUtil.getAllJsonUtil().toJson((Object)cmsAdvertise));
        return cmsAdvertise.getAdvertiseCode();
    }

    @Override
    public void updateadvertiseState(Integer advertiseId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateadvertiseModel(advertiseId, dataState, oldDataState);
        CmsAdvertise cmsAdvertise = this.getadvertise(advertiseId);
        this.updateToRedis(advertiseId.toString(), JsonUtil.getAllJsonUtil().toJson((Object)cmsAdvertise));
        this.updateReleaseHtml(cmsAdvertise);
    }

    @Override
    public void updateadvertise(CmsAdvertiseDomain cmsAdvertiseDomain) throws ApiException {
        String msg = this.checkadvertise(cmsAdvertiseDomain);
        if (com.yqbsoft.laser.service.tool.util.StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("cms.CmsAdvertiseServiceImpl.updateadvertise.checkadvertise", msg);
        }
        CmsAdvertise oldCmsAdvertise = this.getadvertiseModelById(cmsAdvertiseDomain.getAdvertiseId());
        if (null == oldCmsAdvertise) {
            throw new ApiException("cms.CmsAdvertiseServiceImpl.updateadvertise.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        CmsAdvertise cmsAdvertise = this.makeadvertise(cmsAdvertiseDomain, oldCmsAdvertise);
        this.setadvertiseUpdataDefault(cmsAdvertise);
        this.updateadvertiseModel(cmsAdvertise);
        this.updateToRedis(cmsAdvertise.getAdvertiseId().toString(), JsonUtil.getAllJsonUtil().toJson((Object)cmsAdvertise));
    }

    @Override
    public CmsAdvertise getadvertise(Integer advertiseId) {
        CmsAdvertise resultCmsAdvertise = this.getByIdFromRedis(advertiseId.toString());
        if (null == resultCmsAdvertise) {
            resultCmsAdvertise = this.getadvertiseModelById(advertiseId);
        }
        return resultCmsAdvertise;
    }

    @Override
    public void deleteadvertise(Integer advertiseId) throws ApiException {
        CmsAdvertise cmsAdvertise = this.getadvertise(advertiseId);
        this.deleteadvertiseModel(advertiseId);
        this.updateReleaseHtml(cmsAdvertise);
        this.deleteByIdFromRedis(advertiseId.toString());
    }

    @Override
    public QueryResult<CmsAdvertise> queryadvertisePage(Map<String, Object> map) {
        List<CmsAdvertise> cmsAdvertiseList;
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        if (!StringUtils.isEmpty((Object)map.get("skuNo"))) {
            String skuNo = map.get("skuNo").toString();
            String tenantCode = map.get("tenantCode").toString();
            this.logger.info("skuno:{}", (Object)skuNo);
            cmsAdvertiseList = new ArrayList<CmsAdvertise>();
            List<CmsAdvertise> resultListFromRedis = this.getListFromRedis();
            if (!CollectionUtils.isEmpty(resultListFromRedis)) {
                for (CmsAdvertise cmsAdvertise : resultListFromRedis) {
                    String advertiseCon;
                    if (!cmsAdvertise.getTenantCode().equals(tenantCode) || com.yqbsoft.laser.service.tool.util.StringUtils.isEmpty((String)(advertiseCon = cmsAdvertise.getAdvertiseCon()))) continue;
                    for (JSONObject jsonObject : JSONArray.json2array((String)advertiseCon)) {
                        if (!jsonObject.getString("skuNo").equals(skuNo)) continue;
                        cmsAdvertiseList.add(cmsAdvertise);
                    }
                }
            }
            pageTools.setRecordCount(cmsAdvertiseList.size());
        } else {
            cmsAdvertiseList = this.queryadvertiseModelPage(map);
            pageTools.setRecordCount(this.countadvertise(map));
        }
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(cmsAdvertiseList);
        return queryResult;
    }

    @Override
    public CmsAdvertise getadvertiseByCode(Map<String, Object> map) {
        return this.getadvertiseModelByCode(map);
    }

    @Override
    public void deladvertiseByCode(Map<String, Object> map) throws ApiException {
        CmsAdvertise cmsAdvertise = this.getadvertiseByCode(map);
        this.deladvertiseModelByCode(map);
        this.updateReleaseHtml(cmsAdvertise);
    }

    @Override
    public void updateReleaseadvertise(Integer advertiseId, String userCode, Integer dataState) throws ApiException {
        CmsAdvertise cmsAdvertise = this.getadvertise(advertiseId);
        if (null == cmsAdvertise) {
            throw new ApiException("cms.CmsAdvertiseServiceImpl.updateReleaseadvertise.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        cmsAdvertise.setAdvertiseNameNow(cmsAdvertise.getAdvertiseName());
        cmsAdvertise.setAdvertiseOrderNow(cmsAdvertise.getAdvertiseOrder());
        cmsAdvertise.setAdvertisePathNow(cmsAdvertise.getAdvertisePath());
        cmsAdvertise.setAdvertisePlaceNow(cmsAdvertise.getAdvertisePlace());
        cmsAdvertise.setAdvertiseRemarkNow(cmsAdvertise.getAdvertiseRemark());
        cmsAdvertise.setAdvertiseTypeNow(cmsAdvertise.getAdvertiseType());
        cmsAdvertise.setAdvertiseUrlNow(cmsAdvertise.getAdvertiseUrl());
        cmsAdvertise.setDataOpbillstate(PortalConstants.DATA_OPBILLSTATE_1);
        cmsAdvertise.setAdvelinkReleasetime(this.getSysDate());
        cmsAdvertise.setGmtModified(this.getSysDate());
        cmsAdvertise.setDataState(dataState);
        this.updateadvertiseModel(cmsAdvertise);
        this.updateReleaseHtml(cmsAdvertise);
        this.updateToRedis(cmsAdvertise.getAdvertiseId().toString(), JsonUtil.getNotDefJsonUtil().toJson((Object)cmsAdvertise));
    }

    private void updateReleaseHtml(CmsAdvertise cmsAdvertise) {
        HashMap<String, String> map = new HashMap<String, String>();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("htmldataMenutype", "TG");
        params.put("htmldataMenu", cmsAdvertise.getTginfoMenuCode());
        params.put("htmldataCode", "CmsAdvertise");
        params.put("tenantCode", cmsAdvertise.getTenantCode());
        params.put("htmldataFilename", cmsAdvertise.getAdvertiseCode() + ".html");
        params.put("htmlcontOpparam", JsonUtil.buildNormalBinder().toJson((Object)cmsAdvertise));
        Date gmtCreate = cmsAdvertise.getGmtCreate();
        String separator = "/";
        String docPath = separator + DateUtils.getDateString((Date)gmtCreate, (String)"yyyyMM") + separator + DateUtils.getDateString((Date)gmtCreate, (String)"dd") + separator;
        params.put("htmldataFilepath", docPath);
        map.put("htmlRelease", JsonUtil.buildNormalBinder().toJson(params));
        this.internalInvoke("pfs.htmlcont.sendHtmlcontOpData", map);
    }

    @Override
    public void taskReleaseCms() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("advelinkReleasetimeDay", DateUtil.getDateStr((String)"yyyy-MM-dd"));
        map.put("dataState", 0);
        map.put("fuzzy", true);
        map.put("dataOpbillstate", 0);
        List<CmsAdvertise> list = this.queryadvertiseModelPage(map);
        HashSet<String> set = new HashSet<String>();
        for (CmsAdvertise cmsAdvertise : list) {
            set.add(cmsAdvertise.getAdvertisePath());
        }
        if (ListUtil.isNotEmpty(set)) {
            HashMap projects = new HashMap();
            ArrayList ps = new ArrayList();
            List<Map<String, Object>> allElevator = this.getOtherBillonByOtherCode(set);
            for (Map<String, Object> elevator : allElevator) {
                String projectCode = (String)elevator.get("projectCode");
                HashMap<String, String> elevatorTemp = new HashMap<String, String>();
                for (CmsAdvertise cmsAdvertise : list) {
                    if (!cmsAdvertise.getAdvertisePath().equals(projectCode)) continue;
                    if (elevator.get("areaCode") == null) {
                        elevator.put("areaCode", "-");
                    }
                    elevatorTemp.put((String)elevator.get("elevatorCode"), (String)elevator.get("areaCode"));
                }
                ps.add(elevatorTemp);
                projects.put(projectCode, ps);
            }
            ArrayList<Integer> updateCmsCode = new ArrayList<Integer>();
            ArrayList cmsReleaseDetailss = new ArrayList();
            for (CmsAdvertise cmsAdvertise : list) {
                List elevatorsTemp = (List)projects.get(cmsAdvertise.getAdvertisePath());
                if (!ListUtil.isNotEmpty((Collection)elevatorsTemp)) continue;
                ArrayList<CmsReleaseDetailsReDomain> cmsReleaseDetails = new ArrayList<CmsReleaseDetailsReDomain>();
                for (Map etemp : elevatorsTemp) {
                    for (Map.Entry elevator : etemp.entrySet()) {
                        CmsReleaseDetailsReDomain detail = new CmsReleaseDetailsReDomain();
                        detail.setAdvertiseCode(cmsAdvertise.getAdvertiseCode());
                        detail.setAppmanageIcode(cmsAdvertise.getAppmanageIcode());
                        detail.setDataState(0);
                        detail.setMemberName(cmsAdvertise.getMemberName());
                        detail.setMemberPhone(cmsAdvertise.getMemberPhone());
                        detail.setReleaseDay(cmsAdvertise.getReleaseday());
                        detail.setTenantCode(cmsAdvertise.getTenantCode());
                        detail.setOtherBillon((String)elevator.getKey());
                        detail.setAreaCode((String)elevator.getValue());
                        updateCmsCode.add(cmsAdvertise.getAdvertiseId());
                        cmsReleaseDetails.add(detail);
                    }
                }
                cmsReleaseDetailss.add(cmsReleaseDetails);
            }
            if (ListUtil.isNotEmpty(cmsReleaseDetailss)) {
                // empty if block
            }
            if (ListUtil.isNotEmpty(updateCmsCode)) {
                map.clear();
                map.put("advertiseIds", updateCmsCode);
                this.updateCmsNotReleaseModel(map);
            }
        }
    }

    private List<Map<String, Object>> getOtherBillonByOtherCode(Set<String> set) {
        HashMap<String, Set<String>> map = new HashMap<String, Set<String>>();
        map.put("projectCodes", set);
        HashMap<String, String> wrapper = new HashMap<String, String>();
        wrapper.put("map", JsonUtil.buildNormalBinder().toJson(map));
        String jsonObj = this.internalInvoke("pt.project.queryProjectElevatorList", wrapper);
        List list = (List)JsonUtil.buildNonNullBinder().getJsonToObject(jsonObj, List.class);
        return list;
    }

    public void updateCmsNotReleaseModel(Map<String, Object> advertiseIds) {
        try {
            this.cmsAdvertiseMapper.updateCmsNotRelease(advertiseIds);
        }
        catch (Exception e) {
            throw new ApiException("cms.CmsAdvertiseServiceImpl.updateadvertiseModel.ex", (Throwable)e);
        }
    }

    @Override
    public List<String> queryAdvertiseBillno(Map<String, Object> map) {
        if (map == null) {
            return null;
        }
        return this.queryAdvertiseBillnoModel(map);
    }

    @Override
    public void refushCache() {
        this.logger.info("cmsAdvertiseServiceImpl -> refushCache \u5237\u65b0\u7f13\u5b58\u6570\u636e");
        this.deleteAllCache();
        HashMap<String, Object> map = new HashMap<String, Object>();
        List<CmsAdvertise> cmsAdvertises = this.queryadvertiseModelPage(map);
        if (!CollectionUtils.isEmpty(cmsAdvertises)) {
            this.logger.info("\u5237\u65b0\u6570\u636e\u4e3a:{}", (Object)JsonUtil.getAllJsonUtil().toJson(cmsAdvertises));
            for (CmsAdvertise cmsAdvertise : cmsAdvertises) {
                this.saveToRedis(cmsAdvertise.getAdvertiseId().toString(), JsonUtil.getNotDefJsonUtil().toJson((Object)cmsAdvertise));
            }
        }
    }

    private List<String> queryAdvertiseBillnoModel(Map<String, Object> map) {
        try {
            return this.cmsAdvertiseMapper.queryAdvertiseBillno(map);
        }
        catch (Exception e) {
            this.logger.error("cms.CmsAdvertiseServiceImpl.queryAdvertiseBillnoModel", (Throwable)e);
            return null;
        }
    }

    private void saveToRedis(String mapKey, String value) {
        SupDisUtil.setMap((String)SYS_CODE, (String)mapKey, (String)value);
    }

    private void updateToRedis(String mapKey, String value) {
        SupDisUtil.setMap((String)SYS_CODE, (String)mapKey, (String)value);
    }

    private CmsAdvertise getByIdFromRedis(String id) {
        String dataStr = SupDisUtil.getMap((String)SYS_CODE, (String)id);
        if (StringUtils.isEmpty((Object)dataStr)) {
            return null;
        }
        return (CmsAdvertise)JsonUtil.getAllJsonUtil().getJsonToObject(dataStr, CmsAdvertise.class);
    }

    private void deleteByIdFromRedis(String id) {
        SupDisUtil.delMap((String)SYS_CODE, (String[])new String[]{id});
    }

    private void deleteAllCache() {
        SupDisUtil.del((String)SYS_CODE);
    }

    private List<CmsAdvertise> getListFromRedis() {
        ArrayList<CmsAdvertise> resultList = new ArrayList<CmsAdvertise>();
        Map mapAll = SupDisUtil.getMapAll((String)SYS_CODE);
        if (MapUtil.isEmpty((Map)mapAll)) {
            return null;
        }
        for (String dataStrValue : mapAll.values()) {
            CmsAdvertise cmsAdvertise = (CmsAdvertise)JsonUtil.getAllJsonUtil().getJsonToObject(dataStrValue, CmsAdvertise.class);
            resultList.add(cmsAdvertise);
        }
        return resultList;
    }
}

