/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.prb.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.prb.dao.PrbAuctionWinMapper;
import com.yqbsoft.laser.service.prb.domain.PrbAuctionWinDomain;
import com.yqbsoft.laser.service.prb.domain.PrbAuctionWinReDomain;
import com.yqbsoft.laser.service.prb.model.PrbAuctionEnroll;
import com.yqbsoft.laser.service.prb.model.PrbAuctionWin;
import com.yqbsoft.laser.service.prb.service.PrbAuctionEnrollService;
import com.yqbsoft.laser.service.prb.service.PrbAuctionService;
import com.yqbsoft.laser.service.prb.service.PrbAuctionWinService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PrbAuctionWinServiceImpl
extends BaseServiceImpl
implements PrbAuctionWinService {
    private static final String SYS_CODE = "at.PrbAuctionWinServiceImpl";
    private PrbAuctionWinMapper prbAuctionWinMapper;
    private PrbAuctionEnrollService prbAuctionEnrollService;
    private PrbAuctionService prbAuctionService;

    public void setPrbAuctionWinMapper(PrbAuctionWinMapper prbAuctionWinMapper) {
        this.prbAuctionWinMapper = prbAuctionWinMapper;
    }

    public PrbAuctionWinMapper getPrbAuctionWinMapper() {
        return this.prbAuctionWinMapper;
    }

    public PrbAuctionEnrollService getPrbAuctionEnrollService() {
        return this.prbAuctionEnrollService;
    }

    public void setPrbAuctionEnrollService(PrbAuctionEnrollService prbAuctionEnrollService) {
        this.prbAuctionEnrollService = prbAuctionEnrollService;
    }

    public PrbAuctionService getPrbAuctionService() {
        return this.prbAuctionService;
    }

    public void setPrbAuctionService(PrbAuctionService prbAuctionService) {
        this.prbAuctionService = prbAuctionService;
    }

    private Date getSysDate() {
        try {
            return this.prbAuctionWinMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("at.PrbAuctionWinServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkAuctionWin(PrbAuctionWinDomain prbAuctionWinDomain) {
        if (null == prbAuctionWinDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)prbAuctionWinDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setAuctionWinDefault(PrbAuctionWin prbAuctionWin) {
        if (null == prbAuctionWin) {
            return;
        }
        if (null == prbAuctionWin.getDataState()) {
            prbAuctionWin.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == prbAuctionWin.getGmtCreate()) {
            prbAuctionWin.setGmtCreate(date);
        }
        prbAuctionWin.setGmtModified(date);
        if (StringUtils.isBlank((String)prbAuctionWin.getAuctionWinCode())) {
            prbAuctionWin.setAuctionWinCode(this.getNo(null, "PrbAuctionWin", "prbAuctionWin", prbAuctionWin.getTenantCode()));
        }
    }

    private int getAuctionWinMaxCode() {
        int code = 0;
        try {
            return this.prbAuctionWinMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("at.PrbAuctionWinServiceImpl.getAuctionWinMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setAuctionWinUpdataDefault(PrbAuctionWin prbAuctionWin) {
        if (null == prbAuctionWin) {
            return;
        }
        prbAuctionWin.setGmtModified(this.getSysDate());
    }

    private void saveAuctionWinModel(PrbAuctionWin prbAuctionWin) throws ApiException {
        if (null == prbAuctionWin) {
            return;
        }
        try {
            this.prbAuctionWinMapper.insert(prbAuctionWin);
        }
        catch (Exception e) {
            throw new ApiException("at.PrbAuctionWinServiceImpl.saveAuctionWinModel.ex", (Throwable)e);
        }
    }

    private void saveAuctionWinBatchModel(List<PrbAuctionWin> prbAuctionWinList) throws ApiException {
        if (null == prbAuctionWinList || prbAuctionWinList.isEmpty()) {
            return;
        }
        try {
            this.prbAuctionWinMapper.insertBatch(prbAuctionWinList);
        }
        catch (Exception e) {
            throw new ApiException("at.PrbAuctionWinServiceImpl.saveAuctionWinBatchModel.ex", (Throwable)e);
        }
    }

    private PrbAuctionWin getAuctionWinModelById(Integer auctionWinId) {
        if (null == auctionWinId) {
            return null;
        }
        try {
            return this.prbAuctionWinMapper.selectByPrimaryKey(auctionWinId);
        }
        catch (Exception e) {
            this.logger.error("at.PrbAuctionWinServiceImpl.getAuctionWinModelById", (Throwable)e);
            return null;
        }
    }

    private PrbAuctionWin getAuctionWinModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.prbAuctionWinMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("at.PrbAuctionWinServiceImpl.getAuctionWinModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delAuctionWinModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.prbAuctionWinMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("at.PrbAuctionWinServiceImpl.delAuctionWinModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("at.PrbAuctionWinServiceImpl.delAuctionWinModelByCode.num");
        }
    }

    private void deleteAuctionWinModel(Integer auctionWinId) throws ApiException {
        if (null == auctionWinId) {
            return;
        }
        int i = 0;
        try {
            i = this.prbAuctionWinMapper.deleteByPrimaryKey(auctionWinId);
        }
        catch (Exception e) {
            throw new ApiException("at.PrbAuctionWinServiceImpl.deleteAuctionWinModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("at.PrbAuctionWinServiceImpl.deleteAuctionWinModel.num");
        }
    }

    private void updateAuctionWinModel(PrbAuctionWin prbAuctionWin) throws ApiException {
        if (null == prbAuctionWin) {
            return;
        }
        int i = 0;
        try {
            i = this.prbAuctionWinMapper.updateByPrimaryKey(prbAuctionWin);
        }
        catch (Exception e) {
            throw new ApiException("at.PrbAuctionWinServiceImpl.updateAuctionWinModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("at.PrbAuctionWinServiceImpl.updateAuctionWinModel.num");
        }
    }

    private void updateStateAuctionWinModel(Integer auctionWinId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == auctionWinId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("auctionWinId", auctionWinId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.prbAuctionWinMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("at.PrbAuctionWinServiceImpl.updateStateAuctionWinModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("at.PrbAuctionWinServiceImpl.updateStateAuctionWinModel.null");
        }
    }

    private void updateStateAuctionWinModelByCode(String tenantCode, String auctionWinCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)auctionWinCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("auctionWinCode", auctionWinCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.prbAuctionWinMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("at.PrbAuctionWinServiceImpl.updateStateAuctionWinModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("at.PrbAuctionWinServiceImpl.updateStateAuctionWinModelByCode.null" + ((Object)map).toString());
        }
    }

    private PrbAuctionWin makeAuctionWin(PrbAuctionWinDomain prbAuctionWinDomain, PrbAuctionWin prbAuctionWin) {
        if (null == prbAuctionWinDomain) {
            return null;
        }
        if (null == prbAuctionWin) {
            prbAuctionWin = new PrbAuctionWin();
        }
        try {
            BeanUtils.copyAllPropertys((Object)prbAuctionWin, (Object)prbAuctionWinDomain);
            return prbAuctionWin;
        }
        catch (Exception e) {
            this.logger.error("at.PrbAuctionWinServiceImpl.makeAuctionWin", (Throwable)e);
            return null;
        }
    }

    private PrbAuctionWinReDomain makePrbAuctionWinReDomain(PrbAuctionWin prbAuctionWin) {
        if (null == prbAuctionWin) {
            return null;
        }
        PrbAuctionWinReDomain prbAuctionWinReDomain = new PrbAuctionWinReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)prbAuctionWinReDomain, (Object)prbAuctionWin);
            return prbAuctionWinReDomain;
        }
        catch (Exception e) {
            this.logger.error("at.PrbAuctionWinServiceImpl.makePrbAuctionWinReDomain", (Throwable)e);
            return null;
        }
    }

    private List<PrbAuctionWin> queryAuctionWinModelPage(Map<String, Object> parammap) {
        try {
            return this.prbAuctionWinMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("at.PrbAuctionWinServiceImpl.queryAuctionWinModel", (Throwable)e);
            return null;
        }
    }

    private int countAuctionWin(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.prbAuctionWinMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("at.PrbAuctionWinServiceImpl.countAuctionWin", (Throwable)e);
        }
        return i;
    }

    private PrbAuctionWin createPrbAuctionWin(PrbAuctionWinDomain prbAuctionWinDomain) {
        String msg = this.checkAuctionWin(prbAuctionWinDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("at.PrbAuctionWinServiceImpl.saveAuctionWin.checkAuctionWin", msg);
        }
        PrbAuctionWin prbAuctionWin = this.makeAuctionWin(prbAuctionWinDomain, null);
        this.setAuctionWinDefault(prbAuctionWin);
        return prbAuctionWin;
    }

    @Override
    public String saveAuctionWin(PrbAuctionWinDomain prbAuctionWinDomain) throws ApiException {
        PrbAuctionEnroll prbAuctionEnroll = this.prbAuctionEnrollService.getAuctionEnrollByCode(prbAuctionWinDomain.getTenantCode(), prbAuctionWinDomain.getAuctionGinfoCode());
        if (null == prbAuctionEnroll) {
            this.logger.error("at.PrbAuctionWinServiceImpl.saveAuctionWin", (Object)("prbAuctionWinDomain" + JsonUtil.buildNonDefaultBinder().toJson((Object)prbAuctionWinDomain)));
            throw new ApiException("at.PrbAuctionWinServiceImpl.saveAuctionWin", "isnull");
        }
        PrbAuctionWin prbAuctionWin = this.createPrbAuctionWin(prbAuctionWinDomain);
        this.saveAuctionWinModel(prbAuctionWin);
        this.prbAuctionEnrollService.updateAuctionEnrollStateByCode(prbAuctionWinDomain.getTenantCode(), prbAuctionWinDomain.getAuctionGinfoCode(), 2, 1, null);
        this.prbAuctionService.updateAuctionStateByCode(prbAuctionWinDomain.getTenantCode(), prbAuctionWinDomain.getAuctionCode(), 2, 1, null);
        return prbAuctionWin.getAuctionWinCode();
    }

    @Override
    public String saveAuctionWinBatch(List<PrbAuctionWinDomain> prbAuctionWinDomainList) throws ApiException {
        if (null == prbAuctionWinDomainList || prbAuctionWinDomainList.isEmpty()) {
            return null;
        }
        ArrayList<PrbAuctionWin> prbAuctionWinList = new ArrayList<PrbAuctionWin>();
        String code = "";
        for (PrbAuctionWinDomain prbAuctionWinDomain : prbAuctionWinDomainList) {
            PrbAuctionWin prbAuctionWin = this.createPrbAuctionWin(prbAuctionWinDomain);
            code = prbAuctionWin.getAuctionWinCode();
            prbAuctionWinList.add(prbAuctionWin);
        }
        this.saveAuctionWinBatchModel(prbAuctionWinList);
        return code;
    }

    @Override
    public void updateAuctionWinState(Integer auctionWinId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == auctionWinId) {
            return;
        }
        this.updateStateAuctionWinModel(auctionWinId, dataState, oldDataState, map);
    }

    @Override
    public void updateAuctionWinStateByCode(String tenantCode, String auctionWinCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        PrbAuctionWin prbAuctionWin = this.getAuctionWinByCode(tenantCode, auctionWinCode);
        if (null == prbAuctionWin) {
            throw new ApiException("at.PrbAuctionWinServiceImpl.updateAuctionWinStateByCode", "isnull");
        }
        if (StringUtils.isBlank((String)auctionWinCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateAuctionWinModelByCode(tenantCode, auctionWinCode, dataState, oldDataState, map);
        if (1 == dataState) {
            this.prbAuctionEnrollService.updateAuctionEnrollStateByCode(prbAuctionWin.getTenantCode(), prbAuctionWin.getAuctionGinfoCode(), 3, 2, null);
            HashMap<String, Object> mapStr1 = new HashMap<String, Object>();
            mapStr1.put("auctionruleSelldpnum", prbAuctionWin.getAuctionWinAmount());
            this.prbAuctionService.updateAuctionStateByCode(prbAuctionWin.getTenantCode(), prbAuctionWin.getAuctionCode(), 3, 2, mapStr1);
        }
        if (-1 == dataState) {
            Date date = this.getSysDate();
            HashMap<String, Object> mapStr = new HashMap<String, Object>();
            mapStr.put("auctionAudit", date);
            if (MapUtil.isEmpty(map)) {
                mapStr.put("auctionAuremark", map.get("map"));
            }
            this.prbAuctionEnrollService.updateAuctionEnrollStateByCode(prbAuctionWin.getTenantCode(), prbAuctionWin.getAuctionGinfoCode(), -1, 2, mapStr);
            this.prbAuctionService.updateAuctionStateByCode(prbAuctionWin.getTenantCode(), prbAuctionWin.getAuctionCode(), 1, 2, null);
        }
    }

    @Override
    public void updateAuctionWin(PrbAuctionWinDomain prbAuctionWinDomain) throws ApiException {
        String msg = this.checkAuctionWin(prbAuctionWinDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("at.PrbAuctionWinServiceImpl.updateAuctionWin.checkAuctionWin", msg);
        }
        PrbAuctionWin oldPrbAuctionWin = this.getAuctionWinModelById(prbAuctionWinDomain.getAuctionWinId());
        if (null == oldPrbAuctionWin) {
            throw new ApiException("at.PrbAuctionWinServiceImpl.updateAuctionWin.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        PrbAuctionWin prbAuctionWin = this.makeAuctionWin(prbAuctionWinDomain, oldPrbAuctionWin);
        this.setAuctionWinUpdataDefault(prbAuctionWin);
        this.updateAuctionWinModel(prbAuctionWin);
    }

    @Override
    public PrbAuctionWin getAuctionWin(Integer auctionWinId) {
        if (null == auctionWinId) {
            return null;
        }
        return this.getAuctionWinModelById(auctionWinId);
    }

    @Override
    public void deleteAuctionWin(Integer auctionWinId) throws ApiException {
        if (null == auctionWinId) {
            return;
        }
        this.deleteAuctionWinModel(auctionWinId);
    }

    @Override
    public QueryResult<PrbAuctionWin> queryAuctionWinPage(Map<String, Object> map) {
        List<PrbAuctionWin> prbAuctionWinList = this.queryAuctionWinModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countAuctionWin(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(prbAuctionWinList);
        return queryResult;
    }

    @Override
    public PrbAuctionWin getAuctionWinByCode(String tenantCode, String auctionWinCode) throws ApiException {
        if (StringUtils.isBlank((String)auctionWinCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("auctionWinCode", auctionWinCode);
        return this.getAuctionWinModelByCode(map);
    }

    @Override
    public void deleteAuctionWinByCode(String tenantCode, String auctionWinCode) throws ApiException {
        if (StringUtils.isBlank((String)auctionWinCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("auctionWinCode", auctionWinCode);
        this.delAuctionWinModelByCode(map);
    }

    @Override
    public void updateAuctionWinStateByAuctionCode(String tenantCode, String auctionCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        this.updateStateAuctionWinModelByCodeModel(tenantCode, auctionCode, dataState, oldDataState, map);
    }

    private void updateStateAuctionWinModelByCodeModel(String tenantCode, String auctionCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)auctionCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("auctionCode", auctionCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.prbAuctionWinMapper.updateAuctionEnrollStateByAuctionCode(map);
        }
        catch (Exception e) {
            throw new ApiException("at.PrbAuctionWinServiceImpl.updateStateAuctionWinModelByCodeModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("at.PrbAuctionWinServiceImpl.updateStateAuctionWinModelByCodeModel.null" + ((Object)map).toString());
        }
    }
}

