/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.prb.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.prb.dao.PrbAuctionSettlMapper;
import com.yqbsoft.laser.service.prb.domain.PrbAuctionSettlDomain;
import com.yqbsoft.laser.service.prb.domain.PrbAuctionSettlReDomain;
import com.yqbsoft.laser.service.prb.model.PrbAuctionSettl;
import com.yqbsoft.laser.service.prb.service.PrbAuctionSettlService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PrbAuctionSettlServiceImpl
extends BaseServiceImpl
implements PrbAuctionSettlService {
    private static final String SYS_CODE = "at.PrbAuctionSettlServiceImpl";
    private PrbAuctionSettlMapper prbAuctionSettlMapper;

    public void setPrbAuctionSettlMapper(PrbAuctionSettlMapper prbAuctionSettlMapper) {
        this.prbAuctionSettlMapper = prbAuctionSettlMapper;
    }

    private Date getSysDate() {
        try {
            return this.prbAuctionSettlMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("at.PrbAuctionSettlServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkAuctionSettl(PrbAuctionSettlDomain prbAuctionSettlDomain) {
        if (null == prbAuctionSettlDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)prbAuctionSettlDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setAuctionSettlDefault(PrbAuctionSettl prbAuctionSettl) {
        if (null == prbAuctionSettl) {
            return;
        }
        if (null == prbAuctionSettl.getDataState()) {
            prbAuctionSettl.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == prbAuctionSettl.getGmtCreate()) {
            prbAuctionSettl.setGmtCreate(date);
        }
        prbAuctionSettl.setGmtModified(date);
        if (StringUtils.isBlank((String)prbAuctionSettl.getAuctionSettlCode())) {
            prbAuctionSettl.setAuctionSettlCode(this.getNo(null, "PrbAuctionSettl", "prbAuctionSettl", prbAuctionSettl.getTenantCode()));
        }
    }

    private int getAuctionSettlMaxCode() {
        int code = 0;
        try {
            return this.prbAuctionSettlMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("at.PrbAuctionSettlServiceImpl.getAuctionSettlMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setAuctionSettlUpdataDefault(PrbAuctionSettl prbAuctionSettl) {
        if (null == prbAuctionSettl) {
            return;
        }
        prbAuctionSettl.setGmtModified(this.getSysDate());
    }

    private void saveAuctionSettlModel(PrbAuctionSettl prbAuctionSettl) throws ApiException {
        if (null == prbAuctionSettl) {
            return;
        }
        try {
            this.prbAuctionSettlMapper.insert(prbAuctionSettl);
        }
        catch (Exception e) {
            throw new ApiException("at.PrbAuctionSettlServiceImpl.saveAuctionSettlModel.ex", (Throwable)e);
        }
    }

    private void saveAuctionSettlBatchModel(List<PrbAuctionSettl> prbAuctionSettlList) throws ApiException {
        if (null == prbAuctionSettlList || prbAuctionSettlList.isEmpty()) {
            return;
        }
        try {
            this.prbAuctionSettlMapper.insertBatch(prbAuctionSettlList);
        }
        catch (Exception e) {
            throw new ApiException("at.PrbAuctionSettlServiceImpl.saveAuctionSettlBatchModel.ex", (Throwable)e);
        }
    }

    private PrbAuctionSettl getAuctionSettlModelById(Integer auctionSettlId) {
        if (null == auctionSettlId) {
            return null;
        }
        try {
            return this.prbAuctionSettlMapper.selectByPrimaryKey(auctionSettlId);
        }
        catch (Exception e) {
            this.logger.error("at.PrbAuctionSettlServiceImpl.getAuctionSettlModelById", (Throwable)e);
            return null;
        }
    }

    private PrbAuctionSettl getAuctionSettlModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.prbAuctionSettlMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("at.PrbAuctionSettlServiceImpl.getAuctionSettlModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delAuctionSettlModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.prbAuctionSettlMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("at.PrbAuctionSettlServiceImpl.delAuctionSettlModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("at.PrbAuctionSettlServiceImpl.delAuctionSettlModelByCode.num");
        }
    }

    private void deleteAuctionSettlModel(Integer auctionSettlId) throws ApiException {
        if (null == auctionSettlId) {
            return;
        }
        int i = 0;
        try {
            i = this.prbAuctionSettlMapper.deleteByPrimaryKey(auctionSettlId);
        }
        catch (Exception e) {
            throw new ApiException("at.PrbAuctionSettlServiceImpl.deleteAuctionSettlModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("at.PrbAuctionSettlServiceImpl.deleteAuctionSettlModel.num");
        }
    }

    private void updateAuctionSettlModel(PrbAuctionSettl prbAuctionSettl) throws ApiException {
        if (null == prbAuctionSettl) {
            return;
        }
        int i = 0;
        try {
            i = this.prbAuctionSettlMapper.updateByPrimaryKey(prbAuctionSettl);
        }
        catch (Exception e) {
            throw new ApiException("at.PrbAuctionSettlServiceImpl.updateAuctionSettlModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("at.PrbAuctionSettlServiceImpl.updateAuctionSettlModel.num");
        }
    }

    private void updateStateAuctionSettlModel(Integer auctionSettlId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == auctionSettlId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("auctionSettlId", auctionSettlId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.prbAuctionSettlMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("at.PrbAuctionSettlServiceImpl.updateStateAuctionSettlModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("at.PrbAuctionSettlServiceImpl.updateStateAuctionSettlModel.null");
        }
    }

    private void updateStateAuctionSettlModelByCode(String tenantCode, String auctionSettlCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)auctionSettlCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("auctionSettlCode", auctionSettlCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.prbAuctionSettlMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("at.PrbAuctionSettlServiceImpl.updateStateAuctionSettlModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("at.PrbAuctionSettlServiceImpl.updateStateAuctionSettlModelByCode.null");
        }
    }

    private PrbAuctionSettl makeAuctionSettl(PrbAuctionSettlDomain prbAuctionSettlDomain, PrbAuctionSettl prbAuctionSettl) {
        if (null == prbAuctionSettlDomain) {
            return null;
        }
        if (null == prbAuctionSettl) {
            prbAuctionSettl = new PrbAuctionSettl();
        }
        try {
            BeanUtils.copyAllPropertys((Object)prbAuctionSettl, (Object)prbAuctionSettlDomain);
            return prbAuctionSettl;
        }
        catch (Exception e) {
            this.logger.error("at.PrbAuctionSettlServiceImpl.makeAuctionSettl", (Throwable)e);
            return null;
        }
    }

    private PrbAuctionSettlReDomain makePrbAuctionSettlReDomain(PrbAuctionSettl prbAuctionSettl) {
        if (null == prbAuctionSettl) {
            return null;
        }
        PrbAuctionSettlReDomain prbAuctionSettlReDomain = new PrbAuctionSettlReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)prbAuctionSettlReDomain, (Object)prbAuctionSettl);
            return prbAuctionSettlReDomain;
        }
        catch (Exception e) {
            this.logger.error("at.PrbAuctionSettlServiceImpl.makePrbAuctionSettlReDomain", (Throwable)e);
            return null;
        }
    }

    private List<PrbAuctionSettl> queryAuctionSettlModelPage(Map<String, Object> parammap) {
        try {
            return this.prbAuctionSettlMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("at.PrbAuctionSettlServiceImpl.queryAuctionSettlModel", (Throwable)e);
            return null;
        }
    }

    private int countAuctionSettl(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.prbAuctionSettlMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("at.PrbAuctionSettlServiceImpl.countAuctionSettl", (Throwable)e);
        }
        return i;
    }

    private PrbAuctionSettl createPrbAuctionSettl(PrbAuctionSettlDomain prbAuctionSettlDomain) {
        String msg = this.checkAuctionSettl(prbAuctionSettlDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("at.PrbAuctionSettlServiceImpl.saveAuctionSettl.checkAuctionSettl", msg);
        }
        PrbAuctionSettl prbAuctionSettl = this.makeAuctionSettl(prbAuctionSettlDomain, null);
        this.setAuctionSettlDefault(prbAuctionSettl);
        return prbAuctionSettl;
    }

    @Override
    public String saveAuctionSettl(PrbAuctionSettlDomain prbAuctionSettlDomain) throws ApiException {
        PrbAuctionSettl prbAuctionSettl = this.createPrbAuctionSettl(prbAuctionSettlDomain);
        this.saveAuctionSettlModel(prbAuctionSettl);
        return prbAuctionSettl.getAuctionSettlCode();
    }

    @Override
    public String saveAuctionSettlBatch(List<PrbAuctionSettlDomain> prbAuctionSettlDomainList) throws ApiException {
        if (null == prbAuctionSettlDomainList || prbAuctionSettlDomainList.isEmpty()) {
            return null;
        }
        ArrayList<PrbAuctionSettl> prbAuctionSettlList = new ArrayList<PrbAuctionSettl>();
        String code = "";
        for (PrbAuctionSettlDomain prbAuctionSettlDomain : prbAuctionSettlDomainList) {
            PrbAuctionSettl prbAuctionSettl = this.createPrbAuctionSettl(prbAuctionSettlDomain);
            code = prbAuctionSettl.getAuctionSettlCode();
            prbAuctionSettlList.add(prbAuctionSettl);
        }
        this.saveAuctionSettlBatchModel(prbAuctionSettlList);
        return code;
    }

    @Override
    public void updateAuctionSettlState(Integer auctionSettlId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == auctionSettlId) {
            return;
        }
        this.updateStateAuctionSettlModel(auctionSettlId, dataState, oldDataState, map);
    }

    @Override
    public void updateAuctionSettlStateByCode(String tenantCode, String auctionSettlCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)auctionSettlCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateAuctionSettlModelByCode(tenantCode, auctionSettlCode, dataState, oldDataState, map);
    }

    @Override
    public void updateAuctionSettl(PrbAuctionSettlDomain prbAuctionSettlDomain) throws ApiException {
        String msg = this.checkAuctionSettl(prbAuctionSettlDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("at.PrbAuctionSettlServiceImpl.updateAuctionSettl.checkAuctionSettl", msg);
        }
        PrbAuctionSettl oldPrbAuctionSettl = this.getAuctionSettlModelById(prbAuctionSettlDomain.getAuctionSettlId());
        if (null == oldPrbAuctionSettl) {
            throw new ApiException("at.PrbAuctionSettlServiceImpl.updateAuctionSettl.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        PrbAuctionSettl prbAuctionSettl = this.makeAuctionSettl(prbAuctionSettlDomain, oldPrbAuctionSettl);
        this.setAuctionSettlUpdataDefault(prbAuctionSettl);
        this.updateAuctionSettlModel(prbAuctionSettl);
    }

    @Override
    public PrbAuctionSettl getAuctionSettl(Integer auctionSettlId) {
        if (null == auctionSettlId) {
            return null;
        }
        return this.getAuctionSettlModelById(auctionSettlId);
    }

    @Override
    public void deleteAuctionSettl(Integer auctionSettlId) throws ApiException {
        if (null == auctionSettlId) {
            return;
        }
        this.deleteAuctionSettlModel(auctionSettlId);
    }

    @Override
    public QueryResult<PrbAuctionSettl> queryAuctionSettlPage(Map<String, Object> map) {
        List<PrbAuctionSettl> prbAuctionSettlList = this.queryAuctionSettlModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countAuctionSettl(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(prbAuctionSettlList);
        return queryResult;
    }

    @Override
    public PrbAuctionSettl getAuctionSettlByCode(String tenantCode, String auctionSettlCode) throws ApiException {
        if (StringUtils.isBlank((String)auctionSettlCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("auctionSettlCode", auctionSettlCode);
        return this.getAuctionSettlModelByCode(map);
    }

    @Override
    public void deleteAuctionSettlByCode(String tenantCode, String auctionSettlCode) throws ApiException {
        if (StringUtils.isBlank((String)auctionSettlCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("auctionSettlCode", auctionSettlCode);
        this.delAuctionSettlModelByCode(map);
    }
}

