/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.prb.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.spring.ApplicationContextUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.prb.dao.PrbAuctionPriceMapper;
import com.yqbsoft.laser.service.prb.domain.PrbAuctionPriceDomain;
import com.yqbsoft.laser.service.prb.domain.PrbAuctionPriceReDomain;
import com.yqbsoft.laser.service.prb.model.PrbAuctionEnroll;
import com.yqbsoft.laser.service.prb.model.PrbAuctionPrice;
import com.yqbsoft.laser.service.prb.service.PrbAuctionEnrollService;
import com.yqbsoft.laser.service.prb.service.PrbAuctionPriceService;
import com.yqbsoft.laser.service.prb.service.PrbAuctionService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PrbAuctionPriceServiceImpl
extends BaseServiceImpl
implements PrbAuctionPriceService {
    private static final String SYS_CODE = "at.PrbAuctionPriceServiceImpl";
    protected PrbAuctionPriceMapper prbAuctionPriceMapper;
    private PrbAuctionEnrollService prbAuctionEnrollService;
    private PrbAuctionService prbAuctionService;

    public void setprbAuctionPriceMapper(PrbAuctionPriceMapper prbAuctionPriceMapper) {
        this.prbAuctionPriceMapper = prbAuctionPriceMapper;
    }

    public PrbAuctionService getPrbAuctionService() {
        if (null == this.prbAuctionService) {
            this.prbAuctionService = (PrbAuctionService)ApplicationContextUtil.getService((String)"prbAuctionService");
        }
        return this.prbAuctionService;
    }

    public PrbAuctionEnrollService getPrbAuctionEnrollService() {
        return this.prbAuctionEnrollService;
    }

    public void setPrbAuctionEnrollService(PrbAuctionEnrollService prbAuctionEnrollService) {
        this.prbAuctionEnrollService = prbAuctionEnrollService;
    }

    private Date getSysDate() {
        try {
            return this.prbAuctionPriceMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("at.PrbAuctionPriceServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkAuctionPrice(PrbAuctionPriceDomain prbAuctionPriceDomain) {
        if (null == prbAuctionPriceDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)prbAuctionPriceDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setAuctionPriceDefault(PrbAuctionPrice prbAuctionPrice) {
        if (null == prbAuctionPrice) {
            return;
        }
        if (null == prbAuctionPrice.getDataState()) {
            prbAuctionPrice.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == prbAuctionPrice.getGmtCreate()) {
            prbAuctionPrice.setGmtCreate(date);
        }
        prbAuctionPrice.setGmtModified(date);
        if (StringUtils.isBlank((String)prbAuctionPrice.getAuctionPriceCode())) {
            prbAuctionPrice.setAuctionPriceCode(this.getNo(null, "PrbAuctionPrice", "prbAuctionPrice", prbAuctionPrice.getTenantCode()));
        }
    }

    private int getAuctionPriceMaxCode() {
        int code = 0;
        try {
            return this.prbAuctionPriceMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("at.PrbAuctionPriceServiceImpl.getAuctionPriceMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setAuctionPriceUpdataDefault(PrbAuctionPrice prbAuctionPrice) {
        if (null == prbAuctionPrice) {
            return;
        }
        prbAuctionPrice.setGmtModified(this.getSysDate());
    }

    private void saveAuctionPriceModel(PrbAuctionPrice prbAuctionPrice) throws ApiException {
        if (null == prbAuctionPrice) {
            return;
        }
        try {
            this.prbAuctionPriceMapper.insert(prbAuctionPrice);
        }
        catch (Exception e) {
            throw new ApiException("at.PrbAuctionPriceServiceImpl.saveAuctionPriceModel.ex", (Throwable)e);
        }
    }

    private void saveAuctionPriceBatchModel(List<PrbAuctionPrice> prbAuctionPriceList) throws ApiException {
        if (null == prbAuctionPriceList || prbAuctionPriceList.isEmpty()) {
            return;
        }
        try {
            this.prbAuctionPriceMapper.insertBatch(prbAuctionPriceList);
        }
        catch (Exception e) {
            throw new ApiException("at.PrbAuctionPriceServiceImpl.saveAuctionPriceBatchModel.ex", (Throwable)e);
        }
    }

    private PrbAuctionPrice getAuctionPriceModelById(Integer auctionPriceId) {
        if (null == auctionPriceId) {
            return null;
        }
        try {
            return this.prbAuctionPriceMapper.selectByPrimaryKey(auctionPriceId);
        }
        catch (Exception e) {
            this.logger.error("at.PrbAuctionPriceServiceImpl.getAuctionPriceModelById", (Throwable)e);
            return null;
        }
    }

    private PrbAuctionPrice getAuctionPriceModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.prbAuctionPriceMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("at.PrbAuctionPriceServiceImpl.getAuctionPriceModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delAuctionPriceModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.prbAuctionPriceMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("at.PrbAuctionPriceServiceImpl.delAuctionPriceModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("at.PrbAuctionPriceServiceImpl.delAuctionPriceModelByCode.num");
        }
    }

    private void deleteAuctionPriceModel(Integer auctionPriceId) throws ApiException {
        if (null == auctionPriceId) {
            return;
        }
        int i = 0;
        try {
            i = this.prbAuctionPriceMapper.deleteByPrimaryKey(auctionPriceId);
        }
        catch (Exception e) {
            throw new ApiException("at.PrbAuctionPriceServiceImpl.deleteAuctionPriceModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("at.PrbAuctionPriceServiceImpl.deleteAuctionPriceModel.num");
        }
    }

    private void updateAuctionPriceModel(PrbAuctionPrice prbAuctionPrice) throws ApiException {
        if (null == prbAuctionPrice) {
            return;
        }
        int i = 0;
        try {
            i = this.prbAuctionPriceMapper.updateByPrimaryKey(prbAuctionPrice);
        }
        catch (Exception e) {
            throw new ApiException("at.PrbAuctionPriceServiceImpl.updateAuctionPriceModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("at.PrbAuctionPriceServiceImpl.updateAuctionPriceModel.num");
        }
    }

    private void updateStateAuctionPriceModel(Integer auctionPriceId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == auctionPriceId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("auctionPriceId", auctionPriceId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.prbAuctionPriceMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("at.PrbAuctionPriceServiceImpl.updateStateAuctionPriceModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("at.PrbAuctionPriceServiceImpl.updateStateAuctionPriceModel.null");
        }
    }

    private void updateStateAuctionPriceModelByCode(String tenantCode, String auctionPriceCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)auctionPriceCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("auctionPriceCode", auctionPriceCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.prbAuctionPriceMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("at.PrbAuctionPriceServiceImpl.updateStateAuctionPriceModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("at.PrbAuctionPriceServiceImpl.updateStateAuctionPriceModelByCode.null");
        }
    }

    private PrbAuctionPrice makeAuctionPrice(PrbAuctionPriceDomain prbAuctionPriceDomain, PrbAuctionPrice prbAuctionPrice) {
        if (null == prbAuctionPriceDomain) {
            return null;
        }
        if (null == prbAuctionPrice) {
            prbAuctionPrice = new PrbAuctionPrice();
        }
        try {
            BeanUtils.copyAllPropertys((Object)prbAuctionPrice, (Object)prbAuctionPriceDomain);
            return prbAuctionPrice;
        }
        catch (Exception e) {
            this.logger.error("at.PrbAuctionPriceServiceImpl.makeAuctionPrice", (Throwable)e);
            return null;
        }
    }

    private PrbAuctionPriceReDomain makePrbAuctionPriceReDomain(PrbAuctionPrice prbAuctionPrice) {
        if (null == prbAuctionPrice) {
            return null;
        }
        PrbAuctionPriceReDomain prbAuctionPriceReDomain = new PrbAuctionPriceReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)prbAuctionPriceReDomain, (Object)prbAuctionPrice);
            return prbAuctionPriceReDomain;
        }
        catch (Exception e) {
            this.logger.error("at.PrbAuctionPriceServiceImpl.makePrbAuctionPriceReDomain", (Throwable)e);
            return null;
        }
    }

    private List<PrbAuctionPrice> queryAuctionPriceModelPage(Map<String, Object> parammap) {
        try {
            return this.prbAuctionPriceMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("at.PrbAuctionPriceServiceImpl.queryAuctionPriceModel", (Throwable)e);
            return null;
        }
    }

    private int countAuctionPrice(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.prbAuctionPriceMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("at.PrbAuctionPriceServiceImpl.countAuctionPrice", (Throwable)e);
        }
        return i;
    }

    private PrbAuctionPrice createPrbAuctionPrice(PrbAuctionPriceDomain prbAuctionPriceDomain) {
        String msg = this.checkAuctionPrice(prbAuctionPriceDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("at.PrbAuctionPriceServiceImpl.saveAuctionPrice.checkAuctionPrice", msg);
        }
        PrbAuctionPrice prbAuctionPrice = this.makeAuctionPrice(prbAuctionPriceDomain, null);
        this.setAuctionPriceDefault(prbAuctionPrice);
        return prbAuctionPrice;
    }

    @Override
    public String saveAuctionPrice(PrbAuctionPriceDomain prbAuctionPriceDomain) throws ApiException {
        PrbAuctionEnroll prbAuctionEnroll = this.prbAuctionEnrollService.getAuctionEnrollByCode(prbAuctionPriceDomain.getTenantCode(), prbAuctionPriceDomain.getAuctionGinfoCode());
        if (null == prbAuctionEnroll) {
            this.logger.error("at.PrbAuctionPriceServiceImpl.saveAuctionPrice.prbAuctionEnroll.null", (Object)(prbAuctionPriceDomain.getTenantCode() + "auctionGinfoCode==" + prbAuctionPriceDomain.getAuctionGinfoCode()));
            throw new ApiException("at.PrbAuctionPriceServiceImpl.saveAuctionPrice", "isnull");
        }
        PrbAuctionPrice prbAuctionPrice = this.createPrbAuctionPrice(prbAuctionPriceDomain);
        this.saveAuctionPriceModel(prbAuctionPrice);
        return prbAuctionPrice.getAuctionPriceCode();
    }

    @Override
    public String saveAuctionPriceBatch(List<PrbAuctionPriceDomain> prbAuctionPriceDomainList) throws ApiException {
        if (null == prbAuctionPriceDomainList || prbAuctionPriceDomainList.isEmpty()) {
            return null;
        }
        ArrayList<PrbAuctionPrice> prbAuctionPriceList = new ArrayList<PrbAuctionPrice>();
        String code = "";
        for (PrbAuctionPriceDomain prbAuctionPriceDomain : prbAuctionPriceDomainList) {
            PrbAuctionPrice prbAuctionPrice = this.createPrbAuctionPrice(prbAuctionPriceDomain);
            code = prbAuctionPrice.getAuctionPriceCode();
            prbAuctionPriceList.add(prbAuctionPrice);
        }
        this.saveAuctionPriceBatchModel(prbAuctionPriceList);
        return code;
    }

    @Override
    public void updateAuctionPriceState(Integer auctionPriceId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == auctionPriceId) {
            return;
        }
        this.updateStateAuctionPriceModel(auctionPriceId, dataState, oldDataState, map);
    }

    @Override
    public void updateAuctionPriceStateByCode(String tenantCode, String auctionPriceCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)auctionPriceCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateAuctionPriceModelByCode(tenantCode, auctionPriceCode, dataState, oldDataState, map);
    }

    @Override
    public void updateAuctionPlatformStateByCode(String tenantCode, String auctionPriceCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)auctionPriceCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        PrbAuctionPrice prbAuctionPrice = this.getAuctionPriceByCode(tenantCode, auctionPriceCode);
        if (null == prbAuctionPrice) {
            throw new ApiException("at.PrbAuctionPriceServiceImpl.updateAuctionPlatformStateByCode", "isnull");
        }
        if (StringUtils.isBlank((String)auctionPriceCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateAuctionPriceModelByCode(tenantCode, auctionPriceCode, dataState, oldDataState, map);
        if (1 == dataState) {
            HashMap<String, Object> mapStr1 = new HashMap<String, Object>();
            mapStr1.put("auctionruleSelldpnum", prbAuctionPrice.getAuctionPriceAmount());
            this.prbAuctionService.updateAuctionStateByCode(prbAuctionPrice.getTenantCode(), prbAuctionPrice.getAuctionCode(), 3, 2, mapStr1);
        }
        if (-1 == dataState) {
            this.prbAuctionService.updateAuctionStateByCode(prbAuctionPrice.getTenantCode(), prbAuctionPrice.getAuctionCode(), 1, 2, null);
        }
    }

    @Override
    public void updateAuctionPrice(PrbAuctionPriceDomain prbAuctionPriceDomain) throws ApiException {
        String msg = this.checkAuctionPrice(prbAuctionPriceDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("at.PrbAuctionPriceServiceImpl.updateAuctionPrice.checkAuctionPrice", msg);
        }
        PrbAuctionPrice oldPrbAuctionPrice = this.getAuctionPriceModelById(prbAuctionPriceDomain.getAuctionPriceId());
        if (null == oldPrbAuctionPrice) {
            this.logger.error("at.PrbAuctionPriceServiceImpl.updateAuctionPrice.PrbAuctionPriceCon.null", (Object)(prbAuctionPriceDomain.getAuctionPriceId() + "prbAuctionPriceDomain==" + JsonUtil.buildNormalBinder().toJson((Object)prbAuctionPriceDomain)));
            throw new ApiException("at.PrbAuctionPriceServiceImpl.updateAuctionPrice.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        PrbAuctionPrice prbAuctionPrice = this.makeAuctionPrice(prbAuctionPriceDomain, oldPrbAuctionPrice);
        this.setAuctionPriceUpdataDefault(prbAuctionPrice);
        this.updateAuctionPriceModel(prbAuctionPrice);
    }

    @Override
    public PrbAuctionPrice getAuctionPrice(Integer auctionPriceId) {
        if (null == auctionPriceId) {
            return null;
        }
        return this.getAuctionPriceModelById(auctionPriceId);
    }

    @Override
    public void deleteAuctionPrice(Integer auctionPriceId) throws ApiException {
        if (null == auctionPriceId) {
            return;
        }
        this.deleteAuctionPriceModel(auctionPriceId);
    }

    @Override
    public QueryResult<PrbAuctionPrice> queryAuctionPricePage(Map<String, Object> map) {
        List<PrbAuctionPrice> prbAuctionPriceList = this.queryAuctionPriceModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countAuctionPrice(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(prbAuctionPriceList);
        return queryResult;
    }

    @Override
    public PrbAuctionPrice getAuctionPriceByCode(String tenantCode, String auctionPriceCode) throws ApiException {
        if (StringUtils.isBlank((String)auctionPriceCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("auctionPriceCode", auctionPriceCode);
        return this.getAuctionPriceModelByCode(map);
    }

    @Override
    public void deleteAuctionPriceByCode(String tenantCode, String auctionPriceCode) throws ApiException {
        if (StringUtils.isBlank((String)auctionPriceCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("auctionPriceCode", auctionPriceCode);
        this.delAuctionPriceModelByCode(map);
    }

    @Override
    public String savePlatformAuctionPrice(PrbAuctionPriceDomain prbAuctionPriceDomain) throws ApiException {
        PrbAuctionPrice prbAuctionPrice = this.createPrbAuctionPrice(prbAuctionPriceDomain);
        this.saveAuctionPriceModel(prbAuctionPrice);
        this.getPrbAuctionService().updateAuctionStateByCode(prbAuctionPriceDomain.getTenantCode(), prbAuctionPriceDomain.getAuctionCode(), 2, 1, null);
        return prbAuctionPrice.getAuctionPriceCode();
    }
}

