/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.producestaticfile.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.producestaticfile.dao.PfsHtmltagMapper;
import com.yqbsoft.laser.service.producestaticfile.domain.PfsHtmltagDomain;
import com.yqbsoft.laser.service.producestaticfile.model.PfsHtmltag;
import com.yqbsoft.laser.service.producestaticfile.service.PfsHtmltagService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PfsHtmltagServiceImpl
extends BaseServiceImpl
implements PfsHtmltagService {
    private static final String SYS_CODE = "pfs.PfsHtmltagServiceImpl";
    private PfsHtmltagMapper pfsHtmltagMapper;

    public void setPfsHtmltagMapper(PfsHtmltagMapper pfsHtmltagMapper) {
        this.pfsHtmltagMapper = pfsHtmltagMapper;
    }

    private Date getSysDate() {
        try {
            return this.pfsHtmltagMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("pfs.PfsHtmltagServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkHtmltag(PfsHtmltagDomain pfsHtmltagDomain) {
        if (null == pfsHtmltagDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        return msg;
    }

    private void setHtmltagDefault(PfsHtmltag pfsHtmltag) {
        if (null == pfsHtmltag) {
            return;
        }
        if (null == pfsHtmltag.getDataState()) {
            pfsHtmltag.setDataState(0);
        }
        if (null == pfsHtmltag.getGmtCreate()) {
            pfsHtmltag.setGmtCreate(this.getSysDate());
        }
        pfsHtmltag.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)pfsHtmltag.getHtmltagCode())) {
            pfsHtmltag.setHtmltagCode(this.createUUIDString());
        }
    }

    private int getHtmltagMaxCode() {
        int code = 0;
        try {
            return this.pfsHtmltagMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("pfs.PfsHtmltagServiceImpl.getHtmltagMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setHtmltagUpdataDefault(PfsHtmltag pfsHtmltag) {
        if (null == pfsHtmltag) {
            return;
        }
        pfsHtmltag.setGmtModified(this.getSysDate());
    }

    private void saveHtmltagModel(PfsHtmltag pfsHtmltag) throws ApiException {
        if (null == pfsHtmltag) {
            return;
        }
        try {
            this.pfsHtmltagMapper.insert(pfsHtmltag);
        }
        catch (Exception e) {
            throw new ApiException("pfs.PfsHtmltagServiceImpl.saveHtmltagModel.ex", (Throwable)e);
        }
    }

    private PfsHtmltag getHtmltagModelById(Integer htmltagId) {
        if (null == htmltagId) {
            return null;
        }
        try {
            return this.pfsHtmltagMapper.selectByPrimaryKey(htmltagId);
        }
        catch (Exception e) {
            this.logger.error("pfs.PfsHtmltagServiceImpl.getHtmltagModelById", (Throwable)e);
            return null;
        }
    }

    public PfsHtmltag getHtmltagModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.pfsHtmltagMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("pfs.PfsHtmltagServiceImpl.getHtmltagModelByCode", (Throwable)e);
            return null;
        }
    }

    public void delHtmltagModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.pfsHtmltagMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pfs.PfsHtmltagServiceImpl.delHtmltagModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pfs.PfsHtmltagServiceImpl.delHtmltagModelByCode.num");
        }
    }

    private void deleteHtmltagModel(Integer htmltagId) throws ApiException {
        if (null == htmltagId) {
            return;
        }
        int i = 0;
        try {
            i = this.pfsHtmltagMapper.deleteByPrimaryKey(htmltagId);
        }
        catch (Exception e) {
            throw new ApiException("pfs.PfsHtmltagServiceImpl.deleteHtmltagModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pfs.PfsHtmltagServiceImpl.deleteHtmltagModel.num");
        }
    }

    private void updateHtmltagModel(PfsHtmltag pfsHtmltag) throws ApiException {
        if (null == pfsHtmltag) {
            return;
        }
        try {
            this.pfsHtmltagMapper.updateByPrimaryKeySelective(pfsHtmltag);
        }
        catch (Exception e) {
            throw new ApiException("pfs.PfsHtmltagServiceImpl.updateHtmltagModel.ex", (Throwable)e);
        }
    }

    private void updateStateHtmltagModel(Integer htmltagId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == htmltagId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("htmltagId", htmltagId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.pfsHtmltagMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("pfs.PfsHtmltagServiceImpl.updateStateHtmltagModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pfs.PfsHtmltagServiceImpl.updateStateHtmltagModel.null");
        }
    }

    private PfsHtmltag makeHtmltag(PfsHtmltagDomain pfsHtmltagDomain, PfsHtmltag pfsHtmltag) {
        if (null == pfsHtmltagDomain) {
            return null;
        }
        if (null == pfsHtmltag) {
            pfsHtmltag = new PfsHtmltag();
        }
        try {
            BeanUtils.copyAllPropertys((Object)pfsHtmltag, (Object)pfsHtmltagDomain);
            return pfsHtmltag;
        }
        catch (Exception e) {
            this.logger.error("pfs.PfsHtmltagServiceImpl.makeHtmltag", (Throwable)e);
            return null;
        }
    }

    private List<PfsHtmltag> queryHtmltagModelPage(Map<String, Object> parammap) {
        try {
            return this.pfsHtmltagMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("pfs.PfsHtmltagServiceImpl.queryHtmltagModel", (Throwable)e);
            return null;
        }
    }

    private int countHtmltag(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.pfsHtmltagMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("pfs.PfsHtmltagServiceImpl.countHtmltag", (Throwable)e);
        }
        return i;
    }

    @Override
    public String saveHtmltag(PfsHtmltagDomain pfsHtmltagDomain) throws ApiException {
        String msg = this.checkHtmltag(pfsHtmltagDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pfs.PfsHtmltagServiceImpl.saveHtmltag.checkHtmltag", msg);
        }
        PfsHtmltag pfsHtmltag = this.makeHtmltag(pfsHtmltagDomain, null);
        this.setHtmltagDefault(pfsHtmltag);
        this.saveHtmltagModel(pfsHtmltag);
        return pfsHtmltag.getHtmltagCode();
    }

    @Override
    public void updateHtmltagState(Integer htmltagId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateHtmltagModel(htmltagId, dataState, oldDataState);
    }

    @Override
    public void updateHtmltag(PfsHtmltagDomain pfsHtmltagDomain) throws ApiException {
        String msg = this.checkHtmltag(pfsHtmltagDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pfs.PfsHtmltagServiceImpl.updateHtmltag.checkHtmltag", msg);
        }
        PfsHtmltag oldPfsHtmltag = this.getHtmltagModelById(pfsHtmltagDomain.getHtmltagId());
        if (null == oldPfsHtmltag) {
            throw new ApiException("pfs.PfsHtmltagServiceImpl.updateHtmltag.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        PfsHtmltag pfsHtmltag = this.makeHtmltag(pfsHtmltagDomain, oldPfsHtmltag);
        this.setHtmltagUpdataDefault(pfsHtmltag);
        this.updateHtmltagModel(pfsHtmltag);
    }

    @Override
    public PfsHtmltag getHtmltag(Integer htmltagId) {
        return this.getHtmltagModelById(htmltagId);
    }

    @Override
    public void deleteHtmltag(Integer htmltagId) throws ApiException {
        this.deleteHtmltagModel(htmltagId);
    }

    @Override
    public QueryResult<PfsHtmltag> queryHtmltagPage(Map<String, Object> map) {
        List<PfsHtmltag> pfsHtmltagList = this.queryHtmltagModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countHtmltag(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(pfsHtmltagList);
        return queryResult;
    }

    @Override
    public PfsHtmltag getHtmltagByCode(Map<String, Object> map) {
        return this.getHtmltagModelByCode(map);
    }

    @Override
    public void delHtmltagByCode(Map<String, Object> map) throws ApiException {
        this.delHtmltagModelByCode(map);
    }
}

