/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.producestaticfile.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.freemarker.FreemarkerUtil;
import com.yqbsoft.laser.service.producestaticfile.dao.PfsMmodelMapper;
import com.yqbsoft.laser.service.producestaticfile.dao.PfsModelMapper;
import com.yqbsoft.laser.service.producestaticfile.dao.PfsModelTagMapper;
import com.yqbsoft.laser.service.producestaticfile.domain.PfsHtmltagDomain;
import com.yqbsoft.laser.service.producestaticfile.domain.PfsMmodelDomain;
import com.yqbsoft.laser.service.producestaticfile.domain.PfsModelDomain;
import com.yqbsoft.laser.service.producestaticfile.domain.PfsModelTagDomain;
import com.yqbsoft.laser.service.producestaticfile.domain.PfsModelTagReDomain;
import com.yqbsoft.laser.service.producestaticfile.domain.PfsModelTagvalueDomain;
import com.yqbsoft.laser.service.producestaticfile.model.PfsHtmltag;
import com.yqbsoft.laser.service.producestaticfile.model.PfsMmodel;
import com.yqbsoft.laser.service.producestaticfile.model.PfsModel;
import com.yqbsoft.laser.service.producestaticfile.model.PfsModelTag;
import com.yqbsoft.laser.service.producestaticfile.model.PfsModelTagvalue;
import com.yqbsoft.laser.service.producestaticfile.service.PfsHtmltagService;
import com.yqbsoft.laser.service.producestaticfile.service.PfsMmodelService;
import com.yqbsoft.laser.service.producestaticfile.service.PfsModelTagvalueService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PfsMmodelServiceImpl
extends BaseServiceImpl
implements PfsMmodelService {
    private static final String SYS_CODE = "pfs.PfsMmodelServiceImpl";
    private PfsMmodelMapper pfsMmodelMapper;
    private PfsModelMapper pfsModelMapper;
    private PfsModelTagMapper pfsModelTagMapper;
    private PfsModelTagvalueService pfsModelTagvalueService;
    private PfsHtmltagService pfsHtmltagService;

    public void setPfsHtmltagService(PfsHtmltagService pfsHtmltagService) {
        this.pfsHtmltagService = pfsHtmltagService;
    }

    public PfsModelTagvalueService getPfsModelTagvalueService() {
        return this.pfsModelTagvalueService;
    }

    public void setPfsModelTagvalueService(PfsModelTagvalueService pfsModelTagvalueService) {
        this.pfsModelTagvalueService = pfsModelTagvalueService;
    }

    public void setPfsMmodelMapper(PfsMmodelMapper pfsMmodelMapper) {
        this.pfsMmodelMapper = pfsMmodelMapper;
    }

    public void setPfsModelMapper(PfsModelMapper pfsModelMapper) {
        this.pfsModelMapper = pfsModelMapper;
    }

    public void setPfsModelTagMapper(PfsModelTagMapper pfsModelTagMapper) {
        this.pfsModelTagMapper = pfsModelTagMapper;
    }

    private Date getSysDate() {
        try {
            return this.pfsMmodelMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("pfs.PfsMmodelServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkMmodel(PfsMmodelDomain pfsMmodelDomain) {
        if (null == pfsMmodelDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)pfsMmodelDomain.getTenantCode())) {
            msg = msg + "FtpserverUrl\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setMmodelDefault(PfsMmodel pfsMmodel) {
        if (null == pfsMmodel) {
            return;
        }
        if (null == pfsMmodel.getDataState()) {
            pfsMmodel.setDataState(0);
        }
        if (null == pfsMmodel.getGmtCreate()) {
            pfsMmodel.setGmtCreate(this.getSysDate());
        }
        pfsMmodel.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)pfsMmodel.getMmodelCode())) {
            pfsMmodel.setMmodelCode(this.createUUIDString());
        }
    }

    private int getMmodelMaxCode() {
        int code = 0;
        try {
            return this.pfsMmodelMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("pfs.PfsMmodelServiceImpl.getMmodelMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setMmodelUpdataDefault(PfsMmodel pfsMmodel) {
        if (null == pfsMmodel) {
            return;
        }
        pfsMmodel.setGmtModified(this.getSysDate());
    }

    private void saveMmodelModel(PfsMmodel pfsMmodel) throws ApiException {
        if (null == pfsMmodel) {
            return;
        }
        try {
            this.pfsMmodelMapper.insert(pfsMmodel);
        }
        catch (Exception e) {
            throw new ApiException("pfs.PfsMmodelServiceImpl.saveMmodelModel.ex", (Throwable)e);
        }
    }

    private PfsMmodel getMmodelModelById(Integer mmodelId) {
        if (null == mmodelId) {
            return null;
        }
        try {
            return this.pfsMmodelMapper.selectByPrimaryKey(mmodelId);
        }
        catch (Exception e) {
            this.logger.error("pfs.PfsMmodelServiceImpl.getMmodelModelById", (Throwable)e);
            return null;
        }
    }

    public PfsMmodel getMmodelModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.pfsMmodelMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("pfs.PfsMmodelServiceImpl.getMmodelModelByCode", (Throwable)e);
            return null;
        }
    }

    public void delMmodelModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.pfsMmodelMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pfs.PfsMmodelServiceImpl.delMmodelModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pfs.PfsMmodelServiceImpl.delMmodelModelByCode.num");
        }
    }

    private void deleteMmodelModel(Integer mmodelId) throws ApiException {
        if (null == mmodelId) {
            return;
        }
        int i = 0;
        try {
            i = this.pfsMmodelMapper.deleteByPrimaryKey(mmodelId);
        }
        catch (Exception e) {
            throw new ApiException("pfs.PfsMmodelServiceImpl.deleteMmodelModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pfs.PfsMmodelServiceImpl.deleteMmodelModel.num");
        }
    }

    private void updateMmodelModel(PfsMmodel pfsMmodel) throws ApiException {
        if (null == pfsMmodel) {
            return;
        }
        try {
            this.pfsMmodelMapper.updateByPrimaryKeySelective(pfsMmodel);
        }
        catch (Exception e) {
            throw new ApiException("pfs.PfsMmodelServiceImpl.updateMmodelModel.ex", (Throwable)e);
        }
    }

    private void updateStateMmodelModel(Integer mmodelId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == mmodelId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("mmodelId", mmodelId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.pfsMmodelMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("pfs.PfsMmodelServiceImpl.updateStateMmodelModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pfs.PfsMmodelServiceImpl.updateStateMmodelModel.null");
        }
    }

    private PfsMmodel makeMmodel(PfsMmodelDomain pfsMmodelDomain, PfsMmodel pfsMmodel) {
        if (null == pfsMmodelDomain) {
            return null;
        }
        if (null == pfsMmodel) {
            pfsMmodel = new PfsMmodel();
        }
        try {
            BeanUtils.copyAllPropertys((Object)pfsMmodel, (Object)pfsMmodelDomain);
            return pfsMmodel;
        }
        catch (Exception e) {
            this.logger.error("pfs.PfsMmodelServiceImpl.makeMmodel", (Throwable)e);
            return null;
        }
    }

    private PfsMmodelDomain makeMmodelDomain(PfsMmodel pfsMmodel) {
        if (null == pfsMmodel) {
            return null;
        }
        PfsMmodelDomain pfsMmodelDomain = new PfsMmodelDomain();
        try {
            BeanUtils.copyAllPropertys((Object)pfsMmodelDomain, (Object)pfsMmodel);
            return pfsMmodelDomain;
        }
        catch (Exception e) {
            this.logger.error("pfs.PfsMmodelServiceImpl.makeMmodelDomain", (Throwable)e);
            return null;
        }
    }

    private List<PfsMmodel> queryMmodelModelPage(Map<String, Object> parammap) {
        try {
            return this.pfsMmodelMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("pfs.PfsMmodelServiceImpl.queryMmodelModel", (Throwable)e);
            return null;
        }
    }

    private int countMmodel(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.pfsMmodelMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("pfs.PfsMmodelServiceImpl.countMmodel", (Throwable)e);
        }
        return i;
    }

    private String checkModel(PfsModelDomain pfsModelDomain) {
        if (null == pfsModelDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)pfsModelDomain.getMmodelCode())) {
            msg = msg + "MmodelCode\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)pfsModelDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setModelDefault(PfsModel pfsModel) {
        if (null == pfsModel) {
            return;
        }
        if (null == pfsModel.getDataState()) {
            pfsModel.setDataState(0);
        }
        if (null == pfsModel.getGmtCreate()) {
            pfsModel.setGmtCreate(this.getSysDate());
        }
        pfsModel.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)pfsModel.getModelCode())) {
            pfsModel.setModelCode(this.createUUIDString());
        }
    }

    private int getModelMaxCode() {
        int code = 0;
        try {
            return this.pfsModelMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("pfs.PfsMmodelServiceImpl.getModelMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setModelUpdataDefault(PfsModel pfsModel) {
        if (null == pfsModel) {
            return;
        }
        pfsModel.setGmtModified(this.getSysDate());
    }

    private void saveModelModel(PfsModel pfsModel) throws ApiException {
        if (null == pfsModel) {
            return;
        }
        try {
            this.pfsModelMapper.insert(pfsModel);
        }
        catch (Exception e) {
            throw new ApiException("pfs.PfsMmodelServiceImpl.saveModelModel.ex", (Throwable)e);
        }
    }

    private PfsModel getModelModelById(Integer modelId) {
        if (null == modelId) {
            return null;
        }
        try {
            return this.pfsModelMapper.selectByPrimaryKey(modelId);
        }
        catch (Exception e) {
            this.logger.error("pfs.PfsMmodelServiceImpl.getModelModelById", (Throwable)e);
            return null;
        }
    }

    public PfsModel getModelModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.pfsModelMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("pfs.PfsMmodelServiceImpl.getModelModelByCode", (Throwable)e);
            return null;
        }
    }

    public void delModelModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.pfsModelMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pfs.PfsMmodelServiceImpl.delModelModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pfs.PfsMmodelServiceImpl.delModelModelByCode.num");
        }
    }

    private void deleteModelModel(Integer modelId) throws ApiException {
        if (null == modelId) {
            return;
        }
        int i = 0;
        try {
            i = this.pfsModelMapper.deleteByPrimaryKey(modelId);
        }
        catch (Exception e) {
            throw new ApiException("pfs.PfsMmodelServiceImpl.deleteModelModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pfs.PfsMmodelServiceImpl.deleteModelModel.num");
        }
    }

    private void updateModelModel(PfsModel pfsModel) throws ApiException {
        if (null == pfsModel) {
            return;
        }
        try {
            this.pfsModelMapper.updateByPrimaryKeySelective(pfsModel);
        }
        catch (Exception e) {
            throw new ApiException("pfs.PfsMmodelServiceImpl.updateModelModel.ex", (Throwable)e);
        }
    }

    private void updateStateModelModel(Integer modelId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == modelId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("modelId", modelId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.pfsModelMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("pfs.PfsMmodelServiceImpl.updateStateModelModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pfs.PfsMmodelServiceImpl.updateStateModelModel.null");
        }
    }

    private PfsModel makeModel(PfsModelDomain pfsModelDomain, PfsModel pfsModel) {
        if (null == pfsModelDomain) {
            return null;
        }
        if (null == pfsModel) {
            pfsModel = new PfsModel();
        }
        try {
            BeanUtils.copyAllPropertys((Object)pfsModel, (Object)pfsModelDomain);
            return pfsModel;
        }
        catch (Exception e) {
            this.logger.error("pfs.PfsMmodelServiceImpl.makeModel", (Throwable)e);
            return null;
        }
    }

    private PfsModelDomain makeModelDomain(PfsModel pfsModel) {
        if (null == pfsModel) {
            return null;
        }
        PfsModelDomain pfsModelDomain = new PfsModelDomain();
        try {
            BeanUtils.copyAllPropertys((Object)pfsModelDomain, (Object)pfsModel);
            return pfsModelDomain;
        }
        catch (Exception e) {
            this.logger.error("pfs.PfsMmodelServiceImpl.makeModelDomain", (Throwable)e);
            return null;
        }
    }

    private List<PfsModel> queryModelModelPage(Map<String, Object> parammap) {
        try {
            return this.pfsModelMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("pfs.PfsMmodelServiceImpl.queryModelModel", (Throwable)e);
            return null;
        }
    }

    private List<PfsModel> queryModelModelPlusPage(Map<String, Object> parammap) {
        try {
            return this.pfsModelMapper.queryPlus(parammap);
        }
        catch (Exception e) {
            this.logger.error("pfs.PfsMmodelServiceImpl.queryModelModel", (Throwable)e);
            return null;
        }
    }

    private int countModel(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.pfsModelMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("pfs.PfsMmodelServiceImpl.countModel", (Throwable)e);
        }
        return i;
    }

    private String checkModelTag(PfsModelTagDomain pfsModelTagDomain) {
        if (null == pfsModelTagDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)pfsModelTagDomain.getModelCode())) {
            msg = msg + "ModelCode\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)pfsModelTagDomain.getMmodelCode())) {
            msg = msg + "MmodelCode\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)pfsModelTagDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setModelTagDefault(PfsModelTag pfsModelTag) {
        if (null == pfsModelTag) {
            return;
        }
        if (null == pfsModelTag.getDataState()) {
            pfsModelTag.setDataState(0);
        }
        if (null == pfsModelTag.getGmtCreate()) {
            pfsModelTag.setGmtCreate(this.getSysDate());
        }
        pfsModelTag.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)pfsModelTag.getModelTagCode())) {
            pfsModelTag.setModelTagCode(this.createUUIDString());
        }
    }

    private int getModelTagMaxCode() {
        int code = 0;
        try {
            return this.pfsModelTagMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("pfs.PfsMmodelServiceImpl.getModelTagMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setModelTagUpdataDefault(PfsModelTag pfsModelTag) {
        if (null == pfsModelTag) {
            return;
        }
        pfsModelTag.setGmtModified(this.getSysDate());
    }

    private void saveModelTagModel(PfsModelTag pfsModelTag) throws ApiException {
        if (null == pfsModelTag) {
            return;
        }
        try {
            this.pfsModelTagMapper.insert(pfsModelTag);
        }
        catch (Exception e) {
            throw new ApiException("pfs.PfsMmodelServiceImpl.saveModelTagModel.ex", (Throwable)e);
        }
    }

    private void saveModelTagModelBatch(List<PfsModelTag> pfsModelTagList) throws ApiException {
        if (null == pfsModelTagList || pfsModelTagList.isEmpty()) {
            return;
        }
        try {
            this.pfsModelTagMapper.insertBatch(pfsModelTagList);
        }
        catch (Exception e) {
            throw new ApiException("pfs.PfsMmodelServiceImpl.saveModelTagModelBatch.ex", (Throwable)e);
        }
    }

    private PfsModelTag getModelTagModelById(Integer modelTagId) {
        if (null == modelTagId) {
            return null;
        }
        try {
            return this.pfsModelTagMapper.selectByPrimaryKey(modelTagId);
        }
        catch (Exception e) {
            this.logger.error("pfs.PfsMmodelServiceImpl.getModelTagModelById", (Throwable)e);
            return null;
        }
    }

    public PfsModelTag getModelTagModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.pfsModelTagMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("pfs.PfsMmodelServiceImpl.getModelTagModelByCode", (Throwable)e);
            return null;
        }
    }

    public void delModelTagModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.pfsModelTagMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pfs.PfsMmodelServiceImpl.delModelTagModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pfs.PfsMmodelServiceImpl.delModelTagModelByCode.num");
        }
    }

    public void delModelTagModelByModelCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        try {
            this.pfsModelTagMapper.delByModelCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pfs.PfsMmodelServiceImpl.delModelTagModelByModelCode.ex", (Throwable)e);
        }
    }

    private void deleteModelTagModel(Integer modelTagId) throws ApiException {
        if (null == modelTagId) {
            return;
        }
        int i = 0;
        try {
            i = this.pfsModelTagMapper.deleteByPrimaryKey(modelTagId);
        }
        catch (Exception e) {
            throw new ApiException("pfs.PfsMmodelServiceImpl.deleteModelTagModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pfs.PfsMmodelServiceImpl.deleteModelTagModel.num");
        }
    }

    private void updateModelTagModel(PfsModelTag pfsModelTag) throws ApiException {
        if (null == pfsModelTag) {
            return;
        }
        try {
            this.pfsModelTagMapper.updateByPrimaryKeySelective(pfsModelTag);
        }
        catch (Exception e) {
            throw new ApiException("pfs.PfsMmodelServiceImpl.updateModelTagModel.ex", (Throwable)e);
        }
    }

    private void updateStateModelTagModel(Integer modelTagId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == modelTagId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("modelTagId", modelTagId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.pfsModelTagMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("pfs.PfsMmodelServiceImpl.updateStateModelTagModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pfs.PfsMmodelServiceImpl.updateStateModelTagModel.null");
        }
    }

    private PfsModelTag makeModelTag(PfsModelTagDomain pfsModelTagDomain, PfsModelTag pfsModelTag) {
        if (null == pfsModelTagDomain) {
            return null;
        }
        if (null == pfsModelTag) {
            pfsModelTag = new PfsModelTag();
        }
        try {
            BeanUtils.copyAllPropertys((Object)pfsModelTag, (Object)pfsModelTagDomain);
            return pfsModelTag;
        }
        catch (Exception e) {
            this.logger.error("pfs.PfsMmodelServiceImpl.makeModelTag", (Throwable)e);
            return null;
        }
    }

    private PfsModelTagDomain makeModelTagDomain(PfsModelTag pfsModelTag) {
        if (null == pfsModelTag) {
            return null;
        }
        PfsModelTagDomain pfsModelTagDomain = new PfsModelTagDomain();
        try {
            BeanUtils.copyAllPropertys((Object)pfsModelTagDomain, (Object)pfsModelTag);
            return pfsModelTagDomain;
        }
        catch (Exception e) {
            this.logger.error("pfs.PfsMmodelServiceImpl.makeModelTagDomain", (Throwable)e);
            return null;
        }
    }

    private List<PfsModelTag> queryModelTagModelPage(Map<String, Object> parammap) {
        try {
            return this.pfsModelTagMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("pfs.PfsMmodelServiceImpl.queryModelTagModel", (Throwable)e);
            return null;
        }
    }

    private int countModelTag(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.pfsModelTagMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("pfs.PfsMmodelServiceImpl.countModelTag", (Throwable)e);
        }
        return i;
    }

    @Override
    public String saveMmodel(PfsMmodelDomain pfsMmodelDomain) throws ApiException {
        String msg = this.checkMmodel(pfsMmodelDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pfs.PfsMmodelServiceImpl.saveMmodel.checkMmodel", msg);
        }
        PfsMmodel pfsMmodel = this.makeMmodel(pfsMmodelDomain, null);
        this.setMmodelDefault(pfsMmodel);
        this.saveMmodelModel(pfsMmodel);
        return pfsMmodel.getMmodelCode();
    }

    @Override
    public void updateMmodelState(Integer mmodelId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateMmodelModel(mmodelId, dataState, oldDataState);
    }

    @Override
    public void updateMmodel(PfsMmodelDomain pfsMmodelDomain) throws ApiException {
        String msg = this.checkMmodel(pfsMmodelDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pfs.PfsMmodelServiceImpl.updateMmodel.checkMmodel", msg);
        }
        PfsMmodel oldPfsMmodel = this.getMmodelModelById(pfsMmodelDomain.getMmodelId());
        if (null == oldPfsMmodel) {
            throw new ApiException("pfs.PfsMmodelServiceImpl.updateMmodel.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        PfsMmodel pfsMmodel = this.makeMmodel(pfsMmodelDomain, oldPfsMmodel);
        this.setMmodelUpdataDefault(pfsMmodel);
        this.updateMmodelModel(pfsMmodel);
    }

    @Override
    public PfsMmodel getMmodel(Integer mmodelId) {
        return this.getMmodelModelById(mmodelId);
    }

    @Override
    public void deleteMmodel(Integer mmodelId) throws ApiException {
        this.deleteMmodelModel(mmodelId);
    }

    @Override
    public QueryResult<PfsMmodel> queryMmodelPage(Map<String, Object> map) {
        List<PfsMmodel> pfsMmodelList = this.queryMmodelModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countMmodel(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(pfsMmodelList);
        return queryResult;
    }

    @Override
    public PfsMmodel getMmodelByCode(Map<String, Object> map) {
        return this.getMmodelModelByCode(map);
    }

    @Override
    public void delMmodelByCode(Map<String, Object> map) throws ApiException {
        this.delMmodelModelByCode(map);
    }

    @Override
    public String saveModel(PfsModelDomain pfsModelDomain) throws ApiException {
        String msg = this.checkModel(pfsModelDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pfs.PfsMmodelServiceImpl.saveModel.checkModel", msg);
        }
        PfsModel pfsModel = this.makeModel(pfsModelDomain, null);
        this.setModelDefault(pfsModel);
        this.saveModelModel(pfsModel);
        this.saveModelTag(pfsModel);
        return pfsModel.getModelCode();
    }

    private void saveModelTag(PfsModel pfsModel) {
        if (null == pfsModel || StringUtils.isBlank((String)pfsModel.getModelHtmlconf())) {
            return;
        }
        List tagList = FreemarkerUtil.getExtValue((String)pfsModel.getModelHtmlconf());
        if (null == tagList || tagList.isEmpty()) {
            return;
        }
        PfsModelTagDomain pfsModelTagDomain = null;
        PfsModelTag pfsModelTag = null;
        ArrayList<PfsModelTag> pfsModelTagList = new ArrayList<PfsModelTag>();
        for (String value : tagList) {
            pfsModelTagDomain = this.makeModelDomain(pfsModel, value);
            pfsModelTag = this.makeModelTag(pfsModelTagDomain);
            if (null == pfsModelTag) continue;
            pfsModelTagList.add(pfsModelTag);
        }
        this.saveModelTagModelBatch(pfsModelTagList);
    }

    private PfsModelTagDomain makeModelDomain(PfsModel pfsModel, String value) {
        if (null == pfsModel || StringUtils.isBlank((String)value)) {
            return null;
        }
        PfsModelTagDomain pfsModelTagDomain = new PfsModelTagDomain();
        pfsModelTagDomain.setMmodelCode(pfsModel.getMmodelCode());
        pfsModelTagDomain.setModelCode(pfsModel.getModelCode());
        pfsModelTagDomain.setModelTagKey(value);
        pfsModelTagDomain.setModelTagValue(value);
        pfsModelTagDomain.setModelTagType("0");
        pfsModelTagDomain.setTenantCode(pfsModel.getTenantCode());
        return pfsModelTagDomain;
    }

    @Override
    public void updateModelState(Integer modelId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateModelModel(modelId, dataState, oldDataState);
    }

    @Override
    public void updateModel(PfsModelDomain pfsModelDomain) throws ApiException {
        String msg = this.checkModel(pfsModelDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pfs.PfsMmodelServiceImpl.updateModel.checkModel", msg);
        }
        PfsModel oldPfsModel = this.getModelModelById(pfsModelDomain.getModelId());
        if (null == oldPfsModel) {
            throw new ApiException("pfs.PfsMmodelServiceImpl.updateModel.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        PfsModel pfsModel = this.makeModel(pfsModelDomain, oldPfsModel);
        this.setModelUpdataDefault(pfsModel);
        this.updateModelModel(pfsModel);
    }

    public void updateModelTag(PfsModel pfsModel) {
        if (null == pfsModel) {
            return;
        }
        HashMap<String, Object> parammap = new HashMap<String, Object>();
        parammap.put("tenantCode", pfsModel.getTenantCode());
        parammap.put("modelCode", pfsModel.getModelCode());
        List<PfsModelTag> modelTagList = this.queryModelTagModelPage(parammap);
        if (null != modelTagList && !modelTagList.isEmpty()) {
            for (PfsModelTag pfsModelTag : modelTagList) {
                this.deleteModelTagModel(pfsModelTag.getModelTagId());
            }
        }
        this.saveModelTag(pfsModel);
    }

    @Override
    public PfsModel getModel(Integer modelId) {
        return this.getModelModelById(modelId);
    }

    @Override
    public void deleteModel(Integer modelId) throws ApiException {
        this.deleteModelModel(modelId);
    }

    @Override
    public QueryResult<PfsModel> queryModelPage(Map<String, Object> map) {
        List<PfsModel> pfsModelList = this.queryModelModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countModel(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(pfsModelList);
        return queryResult;
    }

    @Override
    public PfsModel getModelByCode(Map<String, Object> map) {
        return this.getModelModelByCode(map);
    }

    @Override
    public void delModelByCode(Map<String, Object> map) throws ApiException {
        this.delModelModelByCode(map);
    }

    @Override
    public String saveModelTag(PfsModelTagDomain pfsModelTagDomain) throws ApiException {
        PfsModelTag pfsModelTag = this.makeModelTag(pfsModelTagDomain);
        this.saveModelTagModel(pfsModelTag);
        return pfsModelTag.getModelTagCode();
    }

    private PfsModelTag makeModelTag(PfsModelTagDomain pfsModelTagDomain) {
        String msg = this.checkModelTag(pfsModelTagDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pfs.PfsMmodelServiceImpl.saveModelTag.checkModelTag", msg);
        }
        PfsModelTag pfsModelTag = this.makeModelTag(pfsModelTagDomain, null);
        this.setModelTagDefault(pfsModelTag);
        return pfsModelTag;
    }

    @Override
    public void updateModelTagState(Integer modelTagId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateModelTagModel(modelTagId, dataState, oldDataState);
    }

    @Override
    public void updateModelTag(PfsModelTagDomain pfsModelTagDomain) throws ApiException {
        String msg = this.checkModelTag(pfsModelTagDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pfs.PfsMmodelServiceImpl.updateModelTag.checkModelTag", msg);
        }
        PfsModelTag oldPfsModelTag = this.getModelTagModelById(pfsModelTagDomain.getModelTagId());
        if (null == oldPfsModelTag) {
            throw new ApiException("pfs.PfsMmodelServiceImpl.updateModelTag.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        PfsModelTag pfsModelTag = this.makeModelTag(pfsModelTagDomain, oldPfsModelTag);
        this.setModelTagUpdataDefault(pfsModelTag);
        this.updateModelTagModel(pfsModelTag);
    }

    @Override
    public PfsModelTag getModelTag(Integer modelTagId) {
        return this.getModelTagModelById(modelTagId);
    }

    @Override
    public void deleteModelTag(Integer modelTagId) throws ApiException {
        this.deleteModelTagModel(modelTagId);
    }

    @Override
    public QueryResult<PfsModelTagReDomain> queryModelTagPage(Map<String, Object> map) {
        List<PfsModelTag> pfsModelTagList = this.queryModelTagModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countModelTag(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(this.makeReList(pfsModelTagList));
        return queryResult;
    }

    @Override
    public QueryResult<PfsModelTag> queryModelTagModelByPage(Map<String, Object> map) {
        List<PfsModelTag> pfsModelTagList = this.queryModelTagModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countModelTag(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(pfsModelTagList);
        return queryResult;
    }

    private List<PfsModelTagReDomain> makeReList(List<PfsModelTag> pfsModelTagList) {
        if (null == pfsModelTagList || pfsModelTagList.isEmpty()) {
            return null;
        }
        ArrayList<PfsModelTagReDomain> list = new ArrayList<PfsModelTagReDomain>();
        for (PfsModelTag pfsModelTag : pfsModelTagList) {
            list.add(this.make(pfsModelTag));
        }
        return list;
    }

    private PfsModelTagReDomain make(PfsModelTag pfsModelTag) {
        if (null == pfsModelTag) {
            return null;
        }
        PfsModelTagReDomain pfsModelTagReDomain = new PfsModelTagReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)pfsModelTagReDomain, (Object)pfsModelTag);
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("modelTagCode", pfsModelTag.getModelTagCode());
            map.put("tenantCode", pfsModelTag.getTenantCode());
            map.put("htmltagCode", pfsModelTag.getModelTagValue());
            pfsModelTagReDomain.setPfsHtmltag(this.pfsHtmltagService.getHtmltagByCode(map));
            QueryResult<PfsModelTagvalue> qlist = this.pfsModelTagvalueService.queryModelTagvaluePage(map);
            if (null != qlist) {
                pfsModelTagReDomain.setPfsModelTagvalueList(qlist.getRows());
            }
        }
        catch (Exception e) {
            return null;
        }
        return pfsModelTagReDomain;
    }

    @Override
    public PfsModelTag getModelTagByCode(Map<String, Object> map) {
        return this.getModelTagModelByCode(map);
    }

    @Override
    public void delModelTagByCode(Map<String, Object> map) throws ApiException {
        this.delModelTagModelByCode(map);
    }

    @Override
    public void saveModelTagList(List<PfsModelTagDomain> pfsModelTagDomainList) throws ApiException {
        if (null == pfsModelTagDomainList || pfsModelTagDomainList.isEmpty()) {
            return;
        }
        ArrayList<PfsModelTag> pfsModelTagList = new ArrayList<PfsModelTag>();
        ArrayList<PfsModelTagvalueDomain> pfsModelTagvalueDomainList = new ArrayList<PfsModelTagvalueDomain>();
        String tenantCode = "";
        String modelCode = "";
        for (PfsModelTagDomain pfsModelTagDomain : pfsModelTagDomainList) {
            PfsModelTag pfsModelTag = this.makeModelTag(pfsModelTagDomain);
            pfsModelTagList.add(pfsModelTag);
            modelCode = pfsModelTag.getModelCode();
            tenantCode = pfsModelTag.getTenantCode();
            if (null == pfsModelTagDomain.getPfsModelTagvalueDomainList() || pfsModelTagDomain.getPfsModelTagvalueDomainList().isEmpty()) continue;
            for (PfsModelTagvalueDomain pfsModelTagvalueDomain : pfsModelTagDomain.getPfsModelTagvalueDomainList()) {
                pfsModelTagvalueDomain.setMmodelCode(pfsModelTag.getMmodelCode());
                pfsModelTagvalueDomain.setModelCode(pfsModelTag.getModelCode());
                pfsModelTagvalueDomain.setModelTagCode(pfsModelTag.getModelTagCode());
                pfsModelTagvalueDomain.setTenantCode(pfsModelTag.getTenantCode());
                pfsModelTagvalueDomainList.add(pfsModelTagvalueDomain);
            }
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("modelCode", modelCode);
        this.delModelTagModelByModelCode(map);
        this.saveModelTagModelBatch(pfsModelTagList);
        this.pfsModelTagvalueService.saveModelTagvalueBatch(pfsModelTagvalueDomainList);
    }

    @Override
    public void saveMmodelInit(String tenantCode) {
        if (StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        List<PfsMmodel> pfsMmodelList = this.queryMmodelModelPage(this.getQueryParamMap("tenantCode", new Object[]{"00000000"}));
        if (ListUtil.isEmpty(pfsMmodelList)) {
            return;
        }
        for (PfsMmodel pfsMmodel : pfsMmodelList) {
            List<PfsMmodel> oldPfsMmodelList = this.queryMmodelModelPage(this.getQueryParamMap("tenantCode,mmodelCode", new Object[]{tenantCode, pfsMmodel.getMmodelCode()}));
            if (ListUtil.isNotEmpty(oldPfsMmodelList)) continue;
            PfsMmodelDomain pfsMmodelDomain = this.makeMmodelDomain(pfsMmodel);
            if (null != pfsMmodelDomain) {
                pfsMmodelDomain.setMmodelId(null);
                pfsMmodelDomain.setTenantCode(tenantCode);
            }
            this.saveMmodel(pfsMmodelDomain);
        }
        this.savePfsModel(tenantCode);
        this.savePfsModelTag(tenantCode);
        this.savePfsHtmltag(tenantCode);
    }

    private PfsHtmltagDomain makeHtmltgDomain(PfsHtmltag pfsHtmltag) {
        if (null == pfsHtmltag) {
            return null;
        }
        PfsHtmltagDomain pfsHtmltagDomain = new PfsHtmltagDomain();
        try {
            BeanUtils.copyAllPropertys((Object)pfsHtmltagDomain, (Object)pfsHtmltag);
            return pfsHtmltagDomain;
        }
        catch (Exception e) {
            this.logger.error("pfs.PfsMmodelServiceImpl.makeHtmltgDomain", (Throwable)e);
            return null;
        }
    }

    private void savePfsHtmltag(String tenantCode) {
        if (StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        QueryResult<PfsHtmltag> qHtmltag = this.pfsHtmltagService.queryHtmltagPage(this.getQueryParamMap("tenantCode", new Object[]{"00000000"}));
        if (null == qHtmltag || ListUtil.isEmpty((Collection)qHtmltag.getList())) {
            return;
        }
        for (PfsHtmltag pfsHtmltag : qHtmltag.getList()) {
            QueryResult<PfsHtmltag> oldqHtmltag = this.pfsHtmltagService.queryHtmltagPage(this.getQueryParamMap("tenantCode,htmltagCode", new Object[]{tenantCode, pfsHtmltag.getHtmltagCode()}));
            if (null != oldqHtmltag && ListUtil.isNotEmpty((Collection)oldqHtmltag.getList())) continue;
            PfsHtmltagDomain pfsHtmltagDomain = this.makeHtmltgDomain(pfsHtmltag);
            if (null != pfsHtmltagDomain) {
                pfsHtmltagDomain.setHtmltagId(null);
                pfsHtmltagDomain.setTenantCode(tenantCode);
            }
            this.pfsHtmltagService.saveHtmltag(pfsHtmltagDomain);
        }
    }

    private void savePfsModelTag(String tenantCode) {
        if (StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        List<PfsModelTag> pfsModelTagList = this.queryModelTagModelPage(this.getQueryParamMap("tenantCode", new Object[]{"00000000"}));
        if (ListUtil.isEmpty(pfsModelTagList)) {
            return;
        }
        for (PfsModelTag pfsModelTag : pfsModelTagList) {
            List<PfsModelTag> oldPfsModelTagList = this.queryModelTagModelPage(this.getQueryParamMap("tenantCode,mmodelCode,modelCode,modelTagKey", new Object[]{tenantCode, pfsModelTag.getMmodelCode(), pfsModelTag.getModelCode(), pfsModelTag.getModelTagKey()}));
            if (ListUtil.isNotEmpty(oldPfsModelTagList)) continue;
            PfsModelTagDomain pfsModelTagDomain = this.makeModelTagDomain(pfsModelTag);
            if (null != pfsModelTagDomain) {
                pfsModelTagDomain.setModelTagId(null);
                pfsModelTagDomain.setTenantCode(tenantCode);
                pfsModelTagDomain.setDataState(pfsModelTag.getDataState());
            }
            this.saveModelTag(pfsModelTagDomain);
        }
    }

    private void savePfsModel(String tenantCode) {
        if (StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        List<PfsModel> pfsModelList = this.queryModelModelPlusPage(this.getQueryParamMap("tenantCode", new Object[]{"00000000"}));
        if (ListUtil.isEmpty(pfsModelList)) {
            return;
        }
        for (PfsModel pfsModel : pfsModelList) {
            List<PfsModel> oldPfsModelList = this.queryModelModelPlusPage(this.getQueryParamMap("tenantCode,mmodelCode,modelCode", new Object[]{tenantCode, pfsModel.getMmodelCode(), pfsModel.getModelCode()}));
            if (ListUtil.isNotEmpty(oldPfsModelList)) continue;
            PfsModelDomain pfsModelDomain = this.makeModelDomain(pfsModel);
            if (null != pfsModelDomain) {
                pfsModelDomain.setModelId(null);
                pfsModelDomain.setTenantCode(tenantCode);
            }
            this.saveModel(pfsModelDomain);
        }
    }
}

