/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.project.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.project.dao.ProProjectTaskMapper;
import com.yqbsoft.laser.service.project.domain.ProProjectTaskDomain;
import com.yqbsoft.laser.service.project.domain.ProProjectTaskReDomain;
import com.yqbsoft.laser.service.project.model.ProProjectTask;
import com.yqbsoft.laser.service.project.service.ProProjectTaskService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ProProjectTaskServiceImpl
extends BaseServiceImpl
implements ProProjectTaskService {
    private static final String SYS_CODE = "pro.ProProjectTaskServiceImpl";
    private ProProjectTaskMapper proProjectTaskMapper;

    public void setProProjectTaskMapper(ProProjectTaskMapper proProjectTaskMapper) {
        this.proProjectTaskMapper = proProjectTaskMapper;
    }

    private Date getSysDate() {
        try {
            return this.proProjectTaskMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("pro.ProProjectTaskServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkProjectTask(ProProjectTaskDomain proProjectTaskDomain) {
        if (null == proProjectTaskDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)proProjectTaskDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setProjectTaskDefault(ProProjectTask proProjectTask) {
        if (null == proProjectTask) {
            return;
        }
        if (null == proProjectTask.getDataState()) {
            proProjectTask.setDataState(0);
        }
        if (null == proProjectTask.getGmtCreate()) {
            proProjectTask.setGmtCreate(this.getSysDate());
        }
        proProjectTask.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)proProjectTask.getProjectTaskCode())) {
            proProjectTask.setProjectTaskCode(this.createUUIDString());
        }
    }

    private int getProjectTaskMaxCode() {
        int code = 0;
        try {
            return this.proProjectTaskMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("pro.ProProjectTaskServiceImpl.getProjectTaskMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setProjectTaskUpdataDefault(ProProjectTask proProjectTask) {
        if (null == proProjectTask) {
            return;
        }
        proProjectTask.setGmtModified(this.getSysDate());
    }

    private void saveProjectTaskModel(ProProjectTask proProjectTask) throws ApiException {
        if (null == proProjectTask) {
            return;
        }
        try {
            this.proProjectTaskMapper.insert(proProjectTask);
        }
        catch (Exception e) {
            throw new ApiException("pro.ProProjectTaskServiceImpl.saveProjectTaskModel.ex", (Throwable)e);
        }
    }

    private void saveProjectTaskBatchModel(List<ProProjectTask> proProjectTaskList) throws ApiException {
        if (null == proProjectTaskList || proProjectTaskList.isEmpty()) {
            return;
        }
        try {
            this.proProjectTaskMapper.insertBatch(proProjectTaskList);
        }
        catch (Exception e) {
            throw new ApiException("pro.ProProjectTaskServiceImpl.saveProjectTaskBatchModel.ex", (Throwable)e);
        }
    }

    private ProProjectTask getProjectTaskModelById(Integer projectTaskId) {
        if (null == projectTaskId) {
            return null;
        }
        try {
            return this.proProjectTaskMapper.selectByPrimaryKey(projectTaskId);
        }
        catch (Exception e) {
            this.logger.error("pro.ProProjectTaskServiceImpl.getProjectTaskModelById", (Throwable)e);
            return null;
        }
    }

    private ProProjectTask getProjectTaskModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.proProjectTaskMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("pro.ProProjectTaskServiceImpl.getProjectTaskModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delProjectTaskModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.proProjectTaskMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pro.ProProjectTaskServiceImpl.delProjectTaskModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pro.ProProjectTaskServiceImpl.delProjectTaskModelByCode.num");
        }
    }

    private void deleteProjectTaskModel(Integer projectTaskId) throws ApiException {
        if (null == projectTaskId) {
            return;
        }
        int i = 0;
        try {
            i = this.proProjectTaskMapper.deleteByPrimaryKey(projectTaskId);
        }
        catch (Exception e) {
            throw new ApiException("pro.ProProjectTaskServiceImpl.deleteProjectTaskModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pro.ProProjectTaskServiceImpl.deleteProjectTaskModel.num");
        }
    }

    private void updateProjectTaskModel(ProProjectTask proProjectTask) throws ApiException {
        if (null == proProjectTask) {
            return;
        }
        int i = 0;
        try {
            i = this.proProjectTaskMapper.updateByPrimaryKeySelective(proProjectTask);
        }
        catch (Exception e) {
            throw new ApiException("pro.ProProjectTaskServiceImpl.updateProjectTaskModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pro.ProProjectTaskServiceImpl.updateProjectTaskModel.num");
        }
    }

    private void updateStateProjectTaskModel(Integer projectTaskId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == projectTaskId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("projectTaskId", projectTaskId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.proProjectTaskMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("pro.ProProjectTaskServiceImpl.updateStateProjectTaskModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pro.ProProjectTaskServiceImpl.updateStateProjectTaskModel.null");
        }
    }

    private void updateStateProjectTaskModelByCode(String tenantCode, String projectTaskCode, Integer dataState, Integer oldDataState) throws ApiException {
        if (StringUtils.isBlank((String)projectTaskCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("projectTaskCode", projectTaskCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.proProjectTaskMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pro.ProProjectTaskServiceImpl.updateStateProjectTaskModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pro.ProProjectTaskServiceImpl.updateStateProjectTaskModelByCode.null");
        }
    }

    private ProProjectTask makeProjectTask(ProProjectTaskDomain proProjectTaskDomain, ProProjectTask proProjectTask) {
        if (null == proProjectTaskDomain) {
            return null;
        }
        if (null == proProjectTask) {
            proProjectTask = new ProProjectTask();
        }
        try {
            BeanUtils.copyAllPropertys((Object)proProjectTask, (Object)proProjectTaskDomain);
            return proProjectTask;
        }
        catch (Exception e) {
            this.logger.error("pro.ProProjectTaskServiceImpl.makeProjectTask", (Throwable)e);
            return null;
        }
    }

    private ProProjectTaskReDomain makeProProjectTaskReDomain(ProProjectTask proProjectTask) {
        if (null == proProjectTask) {
            return null;
        }
        ProProjectTaskReDomain proProjectTaskReDomain = new ProProjectTaskReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)proProjectTaskReDomain, (Object)proProjectTask);
            return proProjectTaskReDomain;
        }
        catch (Exception e) {
            this.logger.error("pro.ProProjectTaskServiceImpl.makeProProjectTaskReDomain", (Throwable)e);
            return null;
        }
    }

    private List<ProProjectTask> queryProjectTaskModelPage(Map<String, Object> parammap) {
        try {
            return this.proProjectTaskMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("pro.ProProjectTaskServiceImpl.queryProjectTaskModel", (Throwable)e);
            return null;
        }
    }

    private int countProjectTask(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.proProjectTaskMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("pro.ProProjectTaskServiceImpl.countProjectTask", (Throwable)e);
        }
        return i;
    }

    private ProProjectTask createProProjectTask(ProProjectTaskDomain proProjectTaskDomain) {
        String msg = this.checkProjectTask(proProjectTaskDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pro.ProProjectTaskServiceImpl.saveProjectTask.checkProjectTask", msg);
        }
        ProProjectTask proProjectTask = this.makeProjectTask(proProjectTaskDomain, null);
        this.setProjectTaskDefault(proProjectTask);
        return proProjectTask;
    }

    @Override
    public String saveProjectTask(ProProjectTaskDomain proProjectTaskDomain) throws ApiException {
        ProProjectTask proProjectTask = this.createProProjectTask(proProjectTaskDomain);
        this.saveProjectTaskModel(proProjectTask);
        return proProjectTask.getProjectTaskCode();
    }

    @Override
    public String saveProjectTaskBatch(List<ProProjectTaskDomain> proProjectTaskDomainList) throws ApiException {
        if (null == proProjectTaskDomainList || proProjectTaskDomainList.isEmpty()) {
            return null;
        }
        ArrayList<ProProjectTask> proProjectTaskList = new ArrayList<ProProjectTask>();
        String code = "";
        for (ProProjectTaskDomain proProjectTaskDomain : proProjectTaskDomainList) {
            ProProjectTask proProjectTask = this.createProProjectTask(proProjectTaskDomain);
            code = proProjectTask.getProjectTaskCode();
            proProjectTaskList.add(proProjectTask);
        }
        this.saveProjectTaskBatchModel(proProjectTaskList);
        return code;
    }

    @Override
    public void updateProjectTaskState(Integer projectTaskId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateProjectTaskModel(projectTaskId, dataState, oldDataState);
    }

    @Override
    public void updateProjectTaskStateByCode(String tenantCode, String projectTaskCode, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateProjectTaskModelByCode(tenantCode, projectTaskCode, dataState, oldDataState);
    }

    @Override
    public void updateProjectTask(ProProjectTaskDomain proProjectTaskDomain) throws ApiException {
        String msg = this.checkProjectTask(proProjectTaskDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pro.ProProjectTaskServiceImpl.updateProjectTask.checkProjectTask", msg);
        }
        ProProjectTask oldProProjectTask = this.getProjectTaskModelById(proProjectTaskDomain.getProjectTaskId());
        if (null == oldProProjectTask) {
            throw new ApiException("pro.ProProjectTaskServiceImpl.updateProjectTask.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        ProProjectTask proProjectTask = this.makeProjectTask(proProjectTaskDomain, oldProProjectTask);
        this.setProjectTaskUpdataDefault(proProjectTask);
        this.updateProjectTaskModel(proProjectTask);
    }

    @Override
    public ProProjectTask getProjectTask(Integer projectTaskId) {
        return this.getProjectTaskModelById(projectTaskId);
    }

    @Override
    public void deleteProjectTask(Integer projectTaskId) throws ApiException {
        this.deleteProjectTaskModel(projectTaskId);
    }

    @Override
    public QueryResult<ProProjectTask> queryProjectTaskPage(Map<String, Object> map) {
        List<ProProjectTask> proProjectTaskList = this.queryProjectTaskModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countProjectTask(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(proProjectTaskList);
        return queryResult;
    }

    @Override
    public ProProjectTask getProjectTaskByCode(String tenantCode, String projectTaskCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("projectTaskCode", projectTaskCode);
        return this.getProjectTaskModelByCode(map);
    }

    @Override
    public void deleteProjectTaskByCode(String tenantCode, String projectTaskCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("projectTaskCode", projectTaskCode);
        this.delProjectTaskModelByCode(map);
    }
}

