/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.project.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.project.dao.ProProjectCustrelMapper;
import com.yqbsoft.laser.service.project.domain.ProProjectCustrelDomain;
import com.yqbsoft.laser.service.project.domain.ProProjectCustrelReDomain;
import com.yqbsoft.laser.service.project.model.ProProjectCustrel;
import com.yqbsoft.laser.service.project.service.ProProjectCustrelService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ProProjectCustrelServiceImpl
extends BaseServiceImpl
implements ProProjectCustrelService {
    private static final String SYS_CODE = "pro.ProProjectCustrelServiceImpl";
    private ProProjectCustrelMapper proProjectCustrelMapper;

    public void setProProjectCustrelMapper(ProProjectCustrelMapper proProjectCustrelMapper) {
        this.proProjectCustrelMapper = proProjectCustrelMapper;
    }

    private Date getSysDate() {
        try {
            return this.proProjectCustrelMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("pro.ProProjectCustrelServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkProjectCustrel(ProProjectCustrelDomain proProjectCustrelDomain) {
        if (null == proProjectCustrelDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)proProjectCustrelDomain.getCompanyCode())) {
            msg = msg + "CompanyCode\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)proProjectCustrelDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setProjectCustrelDefault(ProProjectCustrel proProjectCustrel) {
        if (null == proProjectCustrel) {
            return;
        }
        if (null == proProjectCustrel.getDataState()) {
            proProjectCustrel.setDataState(0);
        }
        if (null == proProjectCustrel.getGmtCreate()) {
            proProjectCustrel.setGmtCreate(this.getSysDate());
        }
        proProjectCustrel.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)proProjectCustrel.getProjectCustrelCode())) {
            proProjectCustrel.setProjectCustrelCode(this.createUUIDString());
        }
    }

    private int getProjectCustrelMaxCode() {
        int code = 0;
        try {
            return this.proProjectCustrelMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("pro.ProProjectCustrelServiceImpl.getProjectCustrelMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setProjectCustrelUpdataDefault(ProProjectCustrel proProjectCustrel) {
        if (null == proProjectCustrel) {
            return;
        }
        proProjectCustrel.setGmtModified(this.getSysDate());
    }

    private void saveProjectCustrelModel(ProProjectCustrel proProjectCustrel) throws ApiException {
        if (null == proProjectCustrel) {
            return;
        }
        try {
            this.proProjectCustrelMapper.insert(proProjectCustrel);
        }
        catch (Exception e) {
            throw new ApiException("pro.ProProjectCustrelServiceImpl.saveProjectCustrelModel.ex", (Throwable)e);
        }
    }

    private void saveProjectCustrelBatchModel(List<ProProjectCustrel> proProjectCustrelList) throws ApiException {
        if (null == proProjectCustrelList || proProjectCustrelList.isEmpty()) {
            return;
        }
        try {
            this.proProjectCustrelMapper.insertBatch(proProjectCustrelList);
        }
        catch (Exception e) {
            throw new ApiException("pro.ProProjectCustrelServiceImpl.saveProjectCustrelBatchModel.ex", (Throwable)e);
        }
    }

    private ProProjectCustrel getProjectCustrelModelById(Integer projectCustrelId) {
        if (null == projectCustrelId) {
            return null;
        }
        try {
            return this.proProjectCustrelMapper.selectByPrimaryKey(projectCustrelId);
        }
        catch (Exception e) {
            this.logger.error("pro.ProProjectCustrelServiceImpl.getProjectCustrelModelById", (Throwable)e);
            return null;
        }
    }

    private ProProjectCustrel getProjectCustrelModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.proProjectCustrelMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("pro.ProProjectCustrelServiceImpl.getProjectCustrelModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delProjectCustrelModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.proProjectCustrelMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pro.ProProjectCustrelServiceImpl.delProjectCustrelModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pro.ProProjectCustrelServiceImpl.delProjectCustrelModelByCode.num");
        }
    }

    private void deleteProjectCustrelModel(Integer projectCustrelId) throws ApiException {
        if (null == projectCustrelId) {
            return;
        }
        int i = 0;
        try {
            i = this.proProjectCustrelMapper.deleteByPrimaryKey(projectCustrelId);
        }
        catch (Exception e) {
            throw new ApiException("pro.ProProjectCustrelServiceImpl.deleteProjectCustrelModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pro.ProProjectCustrelServiceImpl.deleteProjectCustrelModel.num");
        }
    }

    private void updateProjectCustrelModel(ProProjectCustrel proProjectCustrel) throws ApiException {
        if (null == proProjectCustrel) {
            return;
        }
        int i = 0;
        try {
            i = this.proProjectCustrelMapper.updateByPrimaryKeySelective(proProjectCustrel);
        }
        catch (Exception e) {
            throw new ApiException("pro.ProProjectCustrelServiceImpl.updateProjectCustrelModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pro.ProProjectCustrelServiceImpl.updateProjectCustrelModel.num");
        }
    }

    private void updateStateProjectCustrelModel(Integer projectCustrelId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == projectCustrelId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("projectCustrelId", projectCustrelId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.proProjectCustrelMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("pro.ProProjectCustrelServiceImpl.updateStateProjectCustrelModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pro.ProProjectCustrelServiceImpl.updateStateProjectCustrelModel.null");
        }
    }

    private void updateStateProjectCustrelModelByCode(String tenantCode, String projectCustrelCode, Integer dataState, Integer oldDataState) throws ApiException {
        if (StringUtils.isBlank((String)projectCustrelCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("projectCustrelCode", projectCustrelCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.proProjectCustrelMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pro.ProProjectCustrelServiceImpl.updateStateProjectCustrelModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pro.ProProjectCustrelServiceImpl.updateStateProjectCustrelModelByCode.null");
        }
    }

    private ProProjectCustrel makeProjectCustrel(ProProjectCustrelDomain proProjectCustrelDomain, ProProjectCustrel proProjectCustrel) {
        if (null == proProjectCustrelDomain) {
            return null;
        }
        if (null == proProjectCustrel) {
            proProjectCustrel = new ProProjectCustrel();
        }
        try {
            BeanUtils.copyAllPropertys((Object)proProjectCustrel, (Object)proProjectCustrelDomain);
            return proProjectCustrel;
        }
        catch (Exception e) {
            this.logger.error("pro.ProProjectCustrelServiceImpl.makeProjectCustrel", (Throwable)e);
            return null;
        }
    }

    private ProProjectCustrelReDomain makeProProjectCustrelReDomain(ProProjectCustrel proProjectCustrel) {
        if (null == proProjectCustrel) {
            return null;
        }
        ProProjectCustrelReDomain proProjectCustrelReDomain = new ProProjectCustrelReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)proProjectCustrelReDomain, (Object)proProjectCustrel);
            return proProjectCustrelReDomain;
        }
        catch (Exception e) {
            this.logger.error("pro.ProProjectCustrelServiceImpl.makeProProjectCustrelReDomain", (Throwable)e);
            return null;
        }
    }

    private List<ProProjectCustrel> queryProjectCustrelModelPage(Map<String, Object> parammap) {
        try {
            return this.proProjectCustrelMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("pro.ProProjectCustrelServiceImpl.queryProjectCustrelModel", (Throwable)e);
            return null;
        }
    }

    private int countProjectCustrel(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.proProjectCustrelMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("pro.ProProjectCustrelServiceImpl.countProjectCustrel", (Throwable)e);
        }
        return i;
    }

    private ProProjectCustrel createProProjectCustrel(ProProjectCustrelDomain proProjectCustrelDomain) {
        String msg = this.checkProjectCustrel(proProjectCustrelDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pro.ProProjectCustrelServiceImpl.saveProjectCustrel.checkProjectCustrel", msg);
        }
        ProProjectCustrel proProjectCustrel = this.makeProjectCustrel(proProjectCustrelDomain, null);
        this.setProjectCustrelDefault(proProjectCustrel);
        return proProjectCustrel;
    }

    @Override
    public String saveProjectCustrel(ProProjectCustrelDomain proProjectCustrelDomain) throws ApiException {
        ProProjectCustrel proProjectCustrel = this.createProProjectCustrel(proProjectCustrelDomain);
        this.saveProjectCustrelModel(proProjectCustrel);
        return proProjectCustrel.getProjectCustrelCode();
    }

    @Override
    public String saveProjectCustrelBatch(List<ProProjectCustrelDomain> proProjectCustrelDomainList) throws ApiException {
        if (null == proProjectCustrelDomainList || proProjectCustrelDomainList.isEmpty()) {
            return null;
        }
        ArrayList<ProProjectCustrel> proProjectCustrelList = new ArrayList<ProProjectCustrel>();
        String code = "";
        for (ProProjectCustrelDomain proProjectCustrelDomain : proProjectCustrelDomainList) {
            ProProjectCustrel proProjectCustrel = this.createProProjectCustrel(proProjectCustrelDomain);
            code = proProjectCustrel.getProjectCustrelCode();
            proProjectCustrelList.add(proProjectCustrel);
        }
        this.saveProjectCustrelBatchModel(proProjectCustrelList);
        return code;
    }

    @Override
    public void updateProjectCustrelState(Integer projectCustrelId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateProjectCustrelModel(projectCustrelId, dataState, oldDataState);
    }

    @Override
    public void updateProjectCustrelStateByCode(String tenantCode, String projectCustrelCode, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateProjectCustrelModelByCode(tenantCode, projectCustrelCode, dataState, oldDataState);
    }

    @Override
    public void updateProjectCustrel(ProProjectCustrelDomain proProjectCustrelDomain) throws ApiException {
        String msg = this.checkProjectCustrel(proProjectCustrelDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pro.ProProjectCustrelServiceImpl.updateProjectCustrel.checkProjectCustrel", msg);
        }
        ProProjectCustrel oldProProjectCustrel = this.getProjectCustrelModelById(proProjectCustrelDomain.getProjectCustrelId());
        if (null == oldProProjectCustrel) {
            throw new ApiException("pro.ProProjectCustrelServiceImpl.updateProjectCustrel.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        ProProjectCustrel proProjectCustrel = this.makeProjectCustrel(proProjectCustrelDomain, oldProProjectCustrel);
        this.setProjectCustrelUpdataDefault(proProjectCustrel);
        this.updateProjectCustrelModel(proProjectCustrel);
    }

    @Override
    public ProProjectCustrel getProjectCustrel(Integer projectCustrelId) {
        return this.getProjectCustrelModelById(projectCustrelId);
    }

    @Override
    public void deleteProjectCustrel(Integer projectCustrelId) throws ApiException {
        this.deleteProjectCustrelModel(projectCustrelId);
    }

    @Override
    public QueryResult<ProProjectCustrel> queryProjectCustrelPage(Map<String, Object> map) {
        List<ProProjectCustrel> proProjectCustrelList = this.queryProjectCustrelModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countProjectCustrel(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(proProjectCustrelList);
        return queryResult;
    }

    @Override
    public ProProjectCustrel getProjectCustrelByCode(String tenantCode, String projectCustrelCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("projectCustrelCode", projectCustrelCode);
        return this.getProjectCustrelModelByCode(map);
    }

    @Override
    public void deleteProjectCustrelByCode(String tenantCode, String projectCustrelCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("projectCustrelCode", projectCustrelCode);
        this.delProjectCustrelModelByCode(map);
    }
}

