/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.project.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.dd.DdTransUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.project.dao.PtBuildingMapper;
import com.yqbsoft.laser.service.project.domain.BuildingBatchDomain;
import com.yqbsoft.laser.service.project.domain.PtBuildingDomain;
import com.yqbsoft.laser.service.project.domain.PtFloorDomain;
import com.yqbsoft.laser.service.project.domain.PtHouseDomain;
import com.yqbsoft.laser.service.project.domain.PtUnitDomain;
import com.yqbsoft.laser.service.project.model.PtBuilding;
import com.yqbsoft.laser.service.project.model.PtFloor;
import com.yqbsoft.laser.service.project.model.PtHouse;
import com.yqbsoft.laser.service.project.model.PtProject;
import com.yqbsoft.laser.service.project.model.PtUnit;
import com.yqbsoft.laser.service.project.service.PtBuildingService;
import com.yqbsoft.laser.service.project.service.PtFloorService;
import com.yqbsoft.laser.service.project.service.PtHouseService;
import com.yqbsoft.laser.service.project.service.PtProjectService;
import com.yqbsoft.laser.service.project.service.PtUnitService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class PtBuildingServiceImpl
extends BaseServiceImpl
implements PtBuildingService {
    public static final String SYS_CODE = "pt.PROJECT.PtBuildingServiceImpl";
    private PtBuildingMapper ptBuildingMapper;
    private PtUnitService ptUnitService;
    private PtFloorService ptFloorService;
    private PtProjectService ptProjectService;
    private PtHouseService ptHouseService;

    public void setPtBuildingMapper(PtBuildingMapper ptBuildingMapper) {
        this.ptBuildingMapper = ptBuildingMapper;
    }

    public void setPtProjectService(PtProjectService ptProjectService) {
        this.ptProjectService = ptProjectService;
    }

    public void setPtUnitService(PtUnitService ptUnitService) {
        this.ptUnitService = ptUnitService;
    }

    public void setPtFloorService(PtFloorService ptFloorService) {
        this.ptFloorService = ptFloorService;
    }

    public void setPtHouseService(PtHouseService ptHouseService) {
        this.ptHouseService = ptHouseService;
    }

    private Date getSysDate() {
        try {
            return this.ptBuildingMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("pt.PROJECT.PtBuildingServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkBuilding(PtBuildingDomain ptBuildingDomain) {
        if (ptBuildingDomain == null) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        return msg;
    }

    private void setBuildingDefault(PtBuilding ptBuilding) {
        if (ptBuilding == null) {
            return;
        }
        if (ptBuilding.getDataState() == null) {
            ptBuilding.setDataState(0);
        }
        if (ptBuilding.getGmtCreate() == null) {
            ptBuilding.setGmtCreate(this.getSysDate());
        }
        ptBuilding.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)ptBuilding.getBuildingCode())) {
            ptBuilding.setBuildingCode(this.createUUIDString());
        }
    }

    private int getBuildingMaxCode() {
        int code = 0;
        try {
            return this.ptBuildingMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("pt.PROJECT.PtBuildingServiceImpl.getBuildingMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setBuildingUpdataDefault(PtBuilding ptBuilding) {
        if (ptBuilding == null) {
            return;
        }
        ptBuilding.setGmtModified(this.getSysDate());
    }

    private void saveBuildingModel(PtBuilding ptBuilding) throws ApiException {
        if (ptBuilding == null) {
            return;
        }
        try {
            this.ptBuildingMapper.insert(ptBuilding);
        }
        catch (Exception e) {
            throw new ApiException("pt.PROJECT.PtBuildingServiceImpl.saveBuildingModel.ex", (Throwable)e);
        }
    }

    private PtBuilding getBuildingModelById(Integer buildingId) {
        if (buildingId == null) {
            return null;
        }
        try {
            return this.ptBuildingMapper.selectByPrimaryKey(buildingId);
        }
        catch (Exception e) {
            this.logger.error("pt.PROJECT.PtBuildingServiceImpl.getBuildingModelById", (Throwable)e);
            return null;
        }
    }

    public PtBuilding getBuildingModelByCode(Map<String, Object> map) {
        if (map == null || map.isEmpty()) {
            return null;
        }
        try {
            return this.ptBuildingMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("pt.PROJECT.PtBuildingServiceImpl.getBuildingModelByCode", (Throwable)e);
            return null;
        }
    }

    public void delBuildingModelByCode(Map<String, Object> map) {
        if (map == null || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.ptBuildingMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pt.PROJECT.PtBuildingServiceImpl.delBuildingModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pt.PROJECT.PtBuildingServiceImpl.delBuildingModelByCode.num");
        }
    }

    private void deleteBuildingModel(Integer buildingId) throws ApiException {
        if (buildingId == null) {
            return;
        }
        int i = 0;
        try {
            i = this.ptBuildingMapper.deleteByPrimaryKey(buildingId);
        }
        catch (Exception e) {
            throw new ApiException("pt.PROJECT.PtBuildingServiceImpl.deleteBuildingModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pt.PROJECT.PtBuildingServiceImpl.deleteBuildingModel.num");
        }
    }

    private void updateBuildingModel(PtBuilding ptBuilding) throws ApiException {
        if (ptBuilding == null) {
            return;
        }
        try {
            this.ptBuildingMapper.updateByPrimaryKeySelective(ptBuilding);
        }
        catch (Exception e) {
            throw new ApiException("pt.PROJECT.PtBuildingServiceImpl.updateBuildingModel.ex", (Throwable)e);
        }
    }

    private void updateStateBuildingModel(Integer buildingId, Integer dataState, Integer oldDataState) throws ApiException {
        if (buildingId == null || dataState == null) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("buildingId", buildingId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.ptBuildingMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("pt.PROJECT.PtBuildingServiceImpl.updateStateBuildingModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pt.PROJECT.PtBuildingServiceImpl.updateStateBuildingModel.null");
        }
    }

    private PtBuilding makeBuilding(PtBuildingDomain ptBuildingDomain, PtBuilding ptBuilding) {
        if (ptBuildingDomain == null) {
            return null;
        }
        if (ptBuilding == null) {
            ptBuilding = new PtBuilding();
        }
        try {
            BeanUtils.copyAllPropertys((Object)ptBuilding, (Object)ptBuildingDomain);
            return ptBuilding;
        }
        catch (Exception e) {
            this.logger.error("pt.PROJECT.PtBuildingServiceImpl.makeBuilding", (Throwable)e);
            return null;
        }
    }

    private List<PtBuilding> queryBuildingModelPage(Map<String, Object> parammap) {
        try {
            return this.ptBuildingMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("pt.PROJECT.PtBuildingServiceImpl.queryBuildingModel", (Throwable)e);
            return null;
        }
    }

    private int countBuilding(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.ptBuildingMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("pt.PROJECT.PtBuildingServiceImpl.countBuilding", (Throwable)e);
        }
        return i;
    }

    @Override
    public PtBuilding saveBuilding(PtBuildingDomain ptBuildingDomain) throws ApiException {
        String msg = this.checkBuilding(ptBuildingDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pt.PROJECT.PtBuildingServiceImpl.saveBuilding.checkBuilding", msg);
        }
        PtBuilding ptBuilding = this.makeBuilding(ptBuildingDomain, null);
        this.setBuildingDefault(ptBuilding);
        this.saveBuildingModel(ptBuilding);
        return ptBuilding;
    }

    @Override
    public void updateBuildingState(Integer buildingId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateBuildingModel(buildingId, dataState, oldDataState);
    }

    @Override
    public void updateBuilding(PtBuildingDomain ptBuildingDomain) throws ApiException {
        String msg = this.checkBuilding(ptBuildingDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pt.PROJECT.PtBuildingServiceImpl.updateBuilding.checkBuilding", msg);
        }
        PtBuilding oldPtBuilding = this.getBuildingModelById(ptBuildingDomain.getBuildingId());
        if (oldPtBuilding == null) {
            throw new ApiException("pt.PROJECT.PtBuildingServiceImpl.updateBuilding.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        PtBuilding ptBuilding = this.makeBuilding(ptBuildingDomain, oldPtBuilding);
        this.setBuildingUpdataDefault(ptBuilding);
        this.updateBuildingModel(ptBuilding);
    }

    @Override
    public PtBuilding getBuilding(Integer buildingId) {
        return this.getBuildingModelById(buildingId);
    }

    @Override
    public void deleteBuilding(Integer buildingId) throws ApiException {
        this.deleteBuildingModel(buildingId);
    }

    @Override
    public QueryResult<PtBuilding> queryBuildingPage(Map<String, Object> map) {
        List<PtBuilding> ptBuildingList = this.queryBuildingModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countBuilding(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(ptBuildingList);
        return queryResult;
    }

    @Override
    public PtBuilding getBuildingByCode(Map<String, Object> map) {
        return this.getBuildingModelByCode(map);
    }

    @Override
    public void delBuildingByCode(Map<String, Object> map) throws ApiException {
        this.delBuildingModelByCode(map);
    }

    @Override
    public List<Map<String, Object>> getBuildingOrUnitInfo(Map<String, Object> map) {
        if (map == null) {
            return null;
        }
        List<Map<String, Object>> BuildingUnitInfos = this.getBuildingOrUnitInfoModel(map);
        return BuildingUnitInfos;
    }

    private List<Map<String, Object>> getBuildingOrUnitInfoModel(Map<String, Object> map) {
        try {
            return this.ptBuildingMapper.getBuildingOrUnitInfo(map);
        }
        catch (Exception e) {
            this.logger.error("pt.PROJECT.PtBuildingServiceImpl.getBuildingOrUnitInfoModel", (Throwable)e);
            return null;
        }
    }

    @Override
    public boolean insertInitBatchBuilding(List<BuildingBatchDomain> list) {
        if (ListUtil.isEmpty(list)) {
            return false;
        }
        Integer impType = 1;
        for (BuildingBatchDomain buildingBatchDomain : list) {
            if (buildingBatchDomain.getImpType() == null || buildingBatchDomain.getImpType() == 0) continue;
            impType = buildingBatchDomain.getImpType();
            break;
        }
        if (impType == 1) {
            return this.addBuildingBatch(list);
        }
        return this.updateBuildingBatch(list);
    }

    private boolean addBuildingBatch(List<BuildingBatchDomain> list) {
        String tenantCode = list.get(0).getTenantCode();
        ArrayList<PtHouseDomain> ptHouses = new ArrayList<PtHouseDomain>();
        HashSet<String> floorSet = new HashSet<String>();
        for (BuildingBatchDomain buildingBatchDomain : list) {
            PtHouse ptHouse;
            int buildingUnitNum = 0;
            int unitFloorNum = 0;
            String houseTypeStr = DdTransUtil.getDdValue((String)("PtHouse-houseType-" + buildingBatchDomain.getHouseType()));
            String houseName = buildingBatchDomain.getHouseName();
            Integer houseType = 1;
            if (StringUtils.isEmpty((String)houseName) || StringUtils.isEmpty((String)houseTypeStr)) {
                houseName = "";
                houseTypeStr = "";
            } else {
                houseType = Integer.parseInt(houseTypeStr);
            }
            PtBuilding building = this.getBuildingByName(buildingBatchDomain);
            if (building == null) {
                building = this.assembleBuilding(buildingBatchDomain);
                building.setBuildingType(houseType);
                building.setBuildingUnitNum(0);
                this.setBuildingDefault(building);
                this.saveBuildingModel(building);
            }
            String buildingCode = building.getBuildingCode();
            String buildingName = building.getBuildingName();
            PtUnit ptUnit = this.getPtUnit(buildingBatchDomain.getUnitName(), buildingCode, tenantCode);
            if (ptUnit == null) {
                PtUnitDomain ptUnitDomain = this.assembleUnit(buildingBatchDomain);
                ptUnitDomain.setUnitFloorNum(0);
                ptUnitDomain.setUnitType(houseType);
                ptUnitDomain.setSignLong(buildingBatchDomain.getSignLong());
                ptUnitDomain.setSignLat(buildingBatchDomain.getSignLat());
                ptUnitDomain.setBuildingCode(buildingCode);
                ptUnitDomain.setUnitName(buildingBatchDomain.getUnitName());
                ptUnit = this.ptUnitService.saveUnitRet(ptUnitDomain);
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("buildingUnitNum", building.getBuildingUnitNum() + ++buildingUnitNum);
                map.put("tenantCode", tenantCode);
                map.put("buildingCode", buildingCode);
                this.updateBuildingUnitNumModel(map);
            }
            if (ptUnit == null || StringUtils.isEmpty((String)buildingBatchDomain.getFloorName())) continue;
            PtFloor ptFloor = this.getPtFloor(ptUnit.getUnitCode(), buildingBatchDomain.getFloorName(), tenantCode);
            if (ptFloor == null) {
                PtFloorDomain ptFloorDomain = new PtFloorDomain();
                ptFloorDomain.setFloorType(houseType);
                ptFloorDomain.setFloorName(buildingBatchDomain.getFloorName());
                ptFloorDomain.setUnitName(buildingBatchDomain.getUnitName());
                ptFloorDomain.setUnitCode(ptUnit.getUnitCode());
                ptFloorDomain.setTenantCode(tenantCode);
                ptFloor = this.ptFloorService.saveFloorRet(ptFloorDomain);
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("addUnitFloorNum", ptUnit.getUnitFloorNum() + ++unitFloorNum);
                map.put("tenantCode", tenantCode);
                map.put("unitCode", ptUnit.getUnitCode());
                this.ptUnitService.updateUnitFloorNum(map);
            }
            if (ptFloor == null || StringUtils.isEmpty((String)houseName) || (ptHouse = this.getPtHouse("", "", "", ptFloor.getFloorCode(), houseName, tenantCode)) != null) continue;
            PtHouseDomain ptHouseDomain = new PtHouseDomain();
            ptHouseDomain.setHouseType(houseType);
            ptHouseDomain.setHouseName(houseName);
            ptHouseDomain.setAveragePrice(buildingBatchDomain.getAveragePrice());
            ptHouseDomain.setBalconyArea(buildingBatchDomain.getBalconyArea());
            ptHouseDomain.setBuildingCode(buildingCode);
            ptHouseDomain.setBuildingName(buildingName);
            ptHouseDomain.setFloorCode(ptFloor.getFloorCode());
            ptHouseDomain.setFloorName(buildingBatchDomain.getFloorName());
            ptHouseDomain.setFunctionalAreas(buildingBatchDomain.getFunctionalAreas());
            ptHouseDomain.setPrivateArea(buildingBatchDomain.getPrivateArea());
            ptHouseDomain.setPublicArea(buildingBatchDomain.getPublicArea());
            ptHouseDomain.setTenantCode(tenantCode);
            ptHouseDomain.setPublicCoefficient(buildingBatchDomain.getPublicCoefficient());
            ptHouseDomain.setTotalArea(buildingBatchDomain.getTotalArea());
            ptHouseDomain.setTotalPrice(buildingBatchDomain.getTotalPrice());
            ptHouseDomain.setUnitCode(ptUnit.getUnitCode());
            ptHouseDomain.setUnitName(buildingBatchDomain.getUnitName());
            Integer bd = buildingBatchDomain.getMinPrice();
            if (bd == null || bd < 500) {
                ptHouseDomain.setMinPrice(new BigDecimal(5000));
            } else {
                ptHouseDomain.setMinPrice(new BigDecimal(buildingBatchDomain.getMinPrice()));
            }
            ptHouseDomain.setManageUpdateNum(0);
            ptHouses.add(ptHouseDomain);
            floorSet.add(ptHouseDomain.getFloorCode());
        }
        if (ptHouses.size() > 0) {
            boolean flag = this.ptHouseService.saveBatchHouse(ptHouses);
            HashMap<String, Object> map2 = new HashMap<String, Object>();
            for (String str : floorSet) {
                int w = 0;
                for (PtHouseDomain ptHouseDomain : ptHouses) {
                    if (!str.equals(ptHouseDomain.getFloorCode())) continue;
                    ++w;
                }
                map2.put("tenantCode", tenantCode);
                map2.put("floorCode", str);
                map2.put("addFloorHouseNum", w);
                this.ptFloorService.updateFloorHouseNum(map2);
            }
            return flag;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean updateBuildingBatch(List<BuildingBatchDomain> list) {
        String tenantCode = list.get(0).getTenantCode();
        ArrayList<PtHouseDomain> ptHouses = new ArrayList<PtHouseDomain>();
        for (BuildingBatchDomain buildingBatchDomain : list) {
            String buildingName = buildingBatchDomain.getBuildingName();
            String unitName = buildingBatchDomain.getUnitName();
            String floorName = buildingBatchDomain.getFloorName();
            String houseName = buildingBatchDomain.getHouseName();
            if (StringUtils.isEmpty((String)buildingName) || StringUtils.isEmpty((String)unitName) || StringUtils.isEmpty((String)floorName) || StringUtils.isEmpty((String)houseName)) {
                this.logger.error("\u4f20\u5165\u7684\u53c2\u6570\u4e3a\u7a7a");
                return false;
            }
            String houseCode = "";
            PtBuilding building = this.getBuildingByName(buildingBatchDomain);
            if (building == null) {
                this.logger.error("\u672a\u67e5\u5230\u697c\u5e62\u4fe1\u606f");
                return false;
            }
            PtUnit ptUnit = this.getPtUnit(unitName, building.getBuildingCode(), tenantCode);
            if (ptUnit == null) {
                this.logger.error("\u672a\u67e5\u5230\u5355\u5143\u4fe1\u606f");
                return false;
            }
            PtFloor ptFloor = this.getPtFloor(ptUnit.getUnitCode(), floorName, tenantCode);
            if (ptFloor == null) {
                this.logger.error("\u672a\u67e5\u5230\u697c\u5c42\u4fe1\u606f");
                return false;
            }
            PtHouse ptHouse = this.getPtHouse(buildingName, unitName, floorName, ptFloor.getFloorCode(), houseName, tenantCode);
            if (ptHouse == null) {
                this.logger.error("\u672a\u67e5\u5230\u623f\u6237\u4fe1\u606f");
                return false;
            }
            houseCode = ptHouse.getHouseCode();
            PtHouseDomain ptHouseDomain = new PtHouseDomain();
            ptHouseDomain.setHouseCode(houseCode);
            ptHouseDomain.setAveragePrice(buildingBatchDomain.getAveragePrice());
            ptHouseDomain.setTotalPrice(buildingBatchDomain.getTotalPrice());
            ptHouses.add(ptHouseDomain);
        }
        int i = this.ptHouseService.updateBatchHouse(ptHouses);
        return i > 0;
    }

    public PtBuilding getBuildingByName(BuildingBatchDomain buildingBatchDomain) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("projectCode", buildingBatchDomain.getProjectCode());
        map.put("buildingName", buildingBatchDomain.getBuildingName());
        map.put("tenantCode", buildingBatchDomain.getTenantCode());
        List<PtBuilding> ptBuildingList = this.queryBuildingModelPage(map);
        if (ptBuildingList != null && ptBuildingList.size() > 0) {
            return ptBuildingList.get(0);
        }
        return null;
    }

    public PtBuilding assembleBuilding(BuildingBatchDomain buildingBatchDomain) {
        PtBuilding ptBuilding = null;
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("projectCode", buildingBatchDomain.getProjectCode());
        PtProject ptProject = this.ptProjectService.getProjectByCode(map);
        if (ptProject == null) {
            throw new ApiException("pt.PROJECT.PtBuildingServiceImpl.assembleBuilding \u6ca1\u6709\u627e\u5230\u8be5\u9879\u76ee,\u9879\u76eecode" + buildingBatchDomain.getProjectCode());
        }
        ptBuilding = new PtBuilding();
        ptBuilding.setBuildingName(buildingBatchDomain.getBuildingName());
        ptBuilding.setProjectName(ptProject.getProjectName());
        ptBuilding.setProjectCode(ptProject.getProjectCode());
        ptBuilding.setTenantCode(buildingBatchDomain.getTenantCode());
        return ptBuilding;
    }

    public PtUnitDomain assembleUnit(BuildingBatchDomain buildingBatchDomain) {
        PtUnitDomain ptUnitDomain = new PtUnitDomain();
        ptUnitDomain.setUnitName(buildingBatchDomain.getUnitName());
        ptUnitDomain.setBuildingName(buildingBatchDomain.getBuildingName());
        ptUnitDomain.setTenantCode(buildingBatchDomain.getTenantCode());
        return ptUnitDomain;
    }

    public String getFloorName(String houseName) {
        if (houseName.length() == 3) {
            houseName = houseName.substring(0, 1);
        } else if (houseName.length() == 4) {
            houseName = houseName.substring(0, 2);
        }
        return houseName;
    }

    public PtUnit getPtUnit(String unitName, String buildingCode, String tenantCode) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("unitName", unitName);
        map.put("buildingCode", buildingCode);
        map.put("tenantCode", tenantCode);
        QueryResult<PtUnit> ptUnitResults = this.ptUnitService.queryUnitPage(map);
        List ptUnit = null;
        if (ptUnitResults.getList() != null && ptUnitResults.getList().size() > 0) {
            ptUnit = ptUnitResults.getList();
            return (PtUnit)ptUnit.get(0);
        }
        return null;
    }

    public PtFloor getPtFloor(String unitCode, String floorName, String tenantCode) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("unitCode", unitCode);
        map.put("floorName", floorName);
        map.put("tenantCode", tenantCode);
        QueryResult<PtFloor> ptFloorResults = this.ptFloorService.queryFloorPage(map);
        List ptFloor = null;
        if (ptFloorResults.getList() != null && ptFloorResults.getList().size() > 0) {
            ptFloor = ptFloorResults.getList();
            return (PtFloor)ptFloor.get(0);
        }
        return null;
    }

    public PtHouse getPtHouse(String buildingName, String unitName, String floorName, String floorCode, String houseName, String tenantCode) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (!StringUtils.isEmpty((String)buildingName)) {
            map.put("buildingName", buildingName);
        }
        if (!StringUtils.isEmpty((String)unitName)) {
            map.put("unitName", unitName);
        }
        if (!StringUtils.isEmpty((String)floorName)) {
            map.put("floorName", floorName);
        }
        map.put("floorCode", floorCode);
        map.put("houseName", houseName);
        map.put("tenantCode", tenantCode);
        QueryResult<PtHouse> ptHouseResults = this.ptHouseService.queryHousePage(map);
        List ptHouse = null;
        if (ptHouseResults.getList() != null && ptHouseResults.getList().size() > 0) {
            ptHouse = ptHouseResults.getList();
            return (PtHouse)ptHouse.get(0);
        }
        return null;
    }

    private int updateBuildingUnitNumModel(Map<String, Object> map) {
        if (map == null) {
            return 0;
        }
        return this.ptBuildingMapper.updateBuildingUnitNum(map);
    }

    @Override
    public PtBuilding getBuildingByBuildingCode(String buildingCode) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("buildingCode", buildingCode);
        return this.getBuildingModelByCode(map);
    }

    @Override
    public List<Map<String, String>> queryBuildingByProjectCode(Map<String, Object> map) throws ApiException {
        if (map == null) {
            return null;
        }
        return this.queryBuildingByProjectCodeModel(map);
    }

    private List<Map<String, String>> queryBuildingByProjectCodeModel(Map<String, Object> map) throws ApiException {
        return this.ptBuildingMapper.queryBuildingByProjectCode(map);
    }
}

